<?php
/**
* KakikoContentsCommon.php 処理概要：セッション関連共通定義
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

session_start();

// 文字コード「Shift_JIS」を指定
header("Content-Type: text/html; charset=Shift_JIS");

require_once("function/Common.php");                       // カキコ共通関数
require_once("Pager/Pager.php");                           // PEAR Pager
require_once("Date.php");                                  // PEAR Date
require_once("HTML/QuickForm.php");                        // PEAR QuickForm
require_once("HTML/QuickForm/Renderer/ArraySmarty.php");   // PEAR ArraySmarty
require_once("class/common/KakikoSmarty.class.php");       // カキコまっぷSmartyクラス
require_once("class/common/KakikoTableName.class.php");    // マップ別テーブル名称取得クラス
require_once("function/KakikoCheckCallback.php");          // チェックコールバック
require_once("function/KakikoErrorHandler.php");           // エラートラップ
require_once("kakikomap/DBColumnDef.php");                 // カキコまっぷ定数(DB)

/**
* 関数概要：ページアクセスチェック
* 処理詳細：各ページ毎にアクセスチェックを行い結果を返す
*
* @引数： (I) pagepath - string ページパス
* @戻値： bool  : true(正常) false(異常)
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function access_check($pagepath){

    // ディレクトリ名が無い場合は無条件で異常とする
    if (!defined("DIRECTORY_NAME")) {
        return false;
    }

	// 自動ログイン状態のチェック
	if (!isset($_SESSION['LOGINMODE'])) {
//	    header("location: ./index.php");
        return false;
	}

    // チェック状態(true:正常)
    $check_flg = true;
    // ファイル名を抽出
    $pagename = basename($pagepath, ".php");

    // マップ公開区分が非公開(9)の場合公開停止画面へリダイレクト
    if(MAP_PUBLIC == 9){
		header("location: ".dirname($_SERVER['PHP_SELF'])."/mobileclosed.html");
		exit(-1);
    }

    // ページ別にアクセスの状態チェックを行う
    switch ($pagename) {
    	default :
            if ($_SESSION['LOGINMODE'] == 1 && !isset($_SESSION[DIRECTORY_NAME.'_userid'])) {
                $check_flg = false;
            }
    }

    return $check_flg;
}

/**
* 関数概要：ユーザエージェント（キャリア）チェック
* 処理詳細：ユーザエージェントにより振り分けを行う
*
* @引数：
* @戻値： string  : 	d	Docomo
*						a	au
*						v	vodafone
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function user_agent(){

	//USER_AGENT判定
	//Docomo
	if (preg_match( "/DoCoMo/", $_SERVER['HTTP_USER_AGENT'])){
		return "d";
	}
	
	//au
	if( preg_match( "/UP.Browser/", $_SERVER['HTTP_USER_AGENT'])){
		return "a";
	}
	
	//Vodafone
	if( preg_match( "/J-PHONE/", $_SERVER['HTTP_USER_AGENT'])){
		return "v";
	}elseif( preg_match( "/vodafone/", $_SERVER['HTTP_USER_AGENT'])){
		return "v";
	}

	//Other
	return -1;

}

/**
* 関数概要：文字エンコード処理
* 処理詳細：指定文字列を指定文字コードにエンコードする
*
* @引数： (I) $str	- string エンコード対象文字列
* 					  string 文字コード
* @戻値： string  : 		エンコード後文字列
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function mbConvertEncoding($str, $encode){

	return mb_convert_encoding($str, $encode, "auto");

}

/**
* 関数概要：文字デコード処理
* 処理詳細：指定文字列を内部エンコーディング（通常UTF-8）にデコードする
*
* @引数： (I) $str	- string デコード対象文字列
* @戻値： string  : 		デコード後文字列
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function mbConvertDecoding($str){

//	return mb_convert_encoding($str, "UTF-8", "auto");
	$internal = mb_internal_encoding();
	return mb_convert_encoding($str, $internal, "auto");

}

?>
