/*
 * Decompiled with CFR 0.152.
 */
package kamicup.publication.webmanager.swt;

import java.net.MalformedURLException;
import java.net.URL;
import kamicup.publication.webmanager.swt.Window;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextEditDialog {
    public static final int URL = 1;
    public static final int INT = 16;
    public static final int FILE = 256;
    Window window_;
    Shell shell_;
    Text txtValue;
    Button btnOk;
    int style;
    private boolean flag = false;
    private String value = null;

    public TextEditDialog(Window window, String title) {
        this.initWidget(window, title);
    }

    public TextEditDialog(Window window, String title, int style) {
        this.initWidget(window, title);
        this.style = style;
    }

    private void initWidget(Window window, String title) {
        this.window_ = window;
        this.shell_ = new Shell(window.getShell(), 65648);
        this.shell_.setText(title);
        this.shell_.setImage(this.window_.getShell().getImage());
        this.shell_.setLayout(new GridLayout(2, false));
        this.txtValue = new Text(this.shell_, 2052);
        this.txtValue.setLayoutData(new GridData(768));
        this.txtValue.addModifyListener(new MofidyAdaptor());
        this.btnOk = new Button(this.shell_, 8);
        this.btnOk.addSelectionListener(new SelectionAdaptor());
        this.btnOk.setLayoutData(new GridData());
        this.btnOk.setText("OK");
    }

    public void setInitValue(String value) {
        this.txtValue.setText(value);
    }

    public boolean open() {
        if (Window.isMacOSX()) {
            this.shell_.setSize(this.shell_.computeSize(380, 32));
        } else {
            this.shell_.setSize(this.shell_.computeSize(380, 32));
        }
        Point pl = this.window_.getShell().getLocation();
        this.shell_.setLocation(pl.x + 100, pl.y + 60);
        this.shell_.open();
        while (!this.shell_.isDisposed()) {
            if (this.window_.getDisplay().readAndDispatch()) continue;
            this.window_.getDisplay().sleep();
        }
        return this.flag;
    }

    public String getValue() {
        return this.value;
    }

    private boolean isStyleMatch(int style) {
        return (this.style & style) == style;
    }

    private class SelectionAdaptor
    implements SelectionListener {
        SelectionAdaptor() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TextEditDialog.this.value = TextEditDialog.this.txtValue.getText();
            TextEditDialog.this.flag = true;
            TextEditDialog.this.shell_.close();
            TextEditDialog.this.shell_.dispose();
        }
    }

    private class MofidyAdaptor
    implements ModifyListener {
        Color black = null;
        Color red = null;

        MofidyAdaptor() {
        }

        private void toBlack() {
            if (this.black == null) {
                this.black = new Color(Display.getCurrent(), 0, 0, 0);
            }
            TextEditDialog.this.txtValue.setForeground(this.black);
            TextEditDialog.this.txtValue.setToolTipText(null);
            TextEditDialog.this.btnOk.setEnabled(true);
        }

        private void toRed(String toolTip) {
            if (this.red == null) {
                this.red = new Color(Display.getCurrent(), 255, 0, 0);
            }
            TextEditDialog.this.txtValue.setForeground(this.red);
            TextEditDialog.this.txtValue.setToolTipText(toolTip);
            TextEditDialog.this.btnOk.setEnabled(false);
        }

        public void modifyText(ModifyEvent e) {
            if (TextEditDialog.this.isStyleMatch(1)) {
                try {
                    new URL(TextEditDialog.this.txtValue.getText());
                    this.toBlack();
                }
                catch (MalformedURLException murle) {
                    this.toRed(murle.toString());
                }
            } else if (TextEditDialog.this.isStyleMatch(16)) {
                try {
                    Integer.parseInt(TextEditDialog.this.txtValue.getText());
                    this.toBlack();
                }
                catch (NumberFormatException nfe) {
                    this.toRed(nfe.toString());
                }
            } else if (TextEditDialog.this.isStyleMatch(256)) {
                String value = TextEditDialog.this.txtValue.getText();
                if (value.indexOf("\\") != -1 || value.indexOf("/") != -1 || value.indexOf(":") != -1 || value.indexOf(";") != -1 || value.indexOf("*") != -1 || value.indexOf("?") != -1 || value.indexOf("\"") != -1 || value.indexOf("<") != -1 || value.indexOf(">") != -1 || value.indexOf("|") != -1) {
                    this.toRed("Can't use char\n \\  / : ; * ? \" < > |");
                } else {
                    this.toBlack();
                }
            }
        }
    }
}

