/*
 * Decompiled with CFR 0.152.
 */
package kamicup.relaxer.utils.v1_1b;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kamicup.relaxer.utils.v1_1b.IRNSContainer;
import kamicup.relaxer.utils.v1_1b.IRNode;
import kamicup.relaxer.utils.v1_1b.URelaxer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RNSContext
implements Serializable {
    private static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    private IRNode rnode_;
    private String namespaceUri_;
    private Map prefixByUri_ = new HashMap();
    private Map uriByPrefix_ = new HashMap();

    public RNSContext(IRNode rnode, String uri) {
        this.rnode_ = rnode;
        this.namespaceUri_ = uri;
    }

    public void declareNamespace(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        int size = attrs.getLength();
        int i = 0;
        while (i < size) {
            String uri;
            Attr attr = (Attr)attrs.item(i);
            String qName = attr.getName();
            if (qName.startsWith("xmlns:")) {
                uri = attr.getValue();
                String prefix = qName.substring("xmlns:".length());
                this.declareNamespace(prefix, uri);
                if (prefix.equals(element.getPrefix())) {
                    this._updateNamespaceUri(uri);
                }
            } else if (qName.startsWith("xmlns")) {
                uri = attr.getValue();
                this.declareNamespace("", uri);
                this._updateNamespaceUri(uri);
            }
            ++i;
        }
    }

    public void declareNamespace(String prefix, String uri) {
        this.prefixByUri_.put(uri, prefix);
        this.uriByPrefix_.put(prefix, uri);
    }

    public void setupNamespace(Element element) {
        this._setupNamespaceTagPrefix(element);
        this._setupNamespacePrefixDeclare(element);
    }

    private void _setupNamespaceTagPrefix(Element element) {
        String myPrefix;
        String uri = element.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        if ((myPrefix = this.getPrefixByUri(uri)) != null) {
            IRNSContainer parent;
            if (!"".equals(myPrefix)) {
                element.setPrefix(myPrefix);
            }
            if ((parent = (IRNSContainer)((Object)this.rnode_.rGetParentRNode())) == null) {
                this.addPrefixDecl(element, myPrefix, uri);
                return;
            }
            RNSContext parentContext = parent.rGetRNSContext();
            String parentPrefix = parentContext.getPrefixByUri(uri);
            if (!myPrefix.equals(parentPrefix)) {
                this.addPrefixDecl(element, myPrefix, uri);
            }
        } else {
            IRNSContainer parent = (IRNSContainer)((Object)this.rnode_.rGetParentRNode());
            if (parent == null) {
                if ("".equals(uri)) {
                    return;
                }
                this.addPrefixDecl(element, null, uri);
                return;
            }
            RNSContext parentContext = parent.rGetRNSContext();
            if (!uri.equals(parentContext.getNamespaceUri())) {
                this.addPrefixDecl(element, myPrefix, uri);
                return;
            }
            String parentPrefix = parentContext.getPrefixByUri(uri);
            if (parentPrefix != null) {
                this.addPrefixDecl(element, myPrefix, uri);
            }
        }
    }

    private void _setupNamespacePrefixDeclare(Element element) {
        String uri = element.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        Set keys = this.prefixByUri_.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String anotherPrefix;
            String anotherUri = (String)iter.next();
            if (uri.equals(anotherUri) || (anotherPrefix = (String)this.prefixByUri_.get(anotherUri)) == null) continue;
            this.addPrefixDecl(element, anotherPrefix, anotherUri);
        }
    }

    public void addPrefixDecl(Element element, String prefix, String uri) {
        try {
            this._addPrefixDeclDOM2(element, prefix, uri);
        }
        catch (DOMException e) {
            this._addPrefixDeclXerces(element, prefix, uri);
        }
    }

    private void _addPrefixDeclXerces(Element element, String prefix, String uri) {
        if (uri == null) {
            uri = "";
        }
        if (prefix == null || "".equals(prefix)) {
            Document doc = element.getOwnerDocument();
            Attr attr = doc.createAttribute("xmlns");
            attr.setValue(uri);
            element.setAttributeNode(attr);
        } else {
            Document doc = element.getOwnerDocument();
            Attr attr = doc.createAttribute("xmlns:" + prefix);
            attr.setValue(uri);
            element.setAttributeNode(attr);
        }
    }

    private void _addPrefixDeclDOM2(Element element, String prefix, String uri) {
        if (uri == null) {
            uri = "";
        }
        if (prefix == null || "".equals(prefix)) {
            Document doc = element.getOwnerDocument();
            Attr attr = doc.createAttributeNS(XMLNS_NS, "xmlns");
            attr.setValue(uri);
            element.setAttributeNode(attr);
        } else {
            Document doc = element.getOwnerDocument();
            Attr attr = doc.createAttributeNS(XMLNS_NS, "xmlns:" + prefix);
            attr.setValue(uri);
            element.setAttributeNode(attr);
        }
    }

    public void startNSMappings(ContentHandler handler) {
        Set keys = this.prefixByUri_.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            String prefix = (String)this.prefixByUri_.get(uri);
            try {
                handler.startPrefixMapping(prefix, uri);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public void endNSMappings(ContentHandler handler) {
        Set keys = this.prefixByUri_.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            String prefix = (String)this.prefixByUri_.get(uri);
            try {
                handler.endPrefixMapping(prefix);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public void makeNSMappings(StringBuffer buffer) {
        if (this.rnode_.rGetParentRNode() == null && this.getPrefixByUri(this.namespaceUri_) == null && !"".equals(this.namespaceUri_)) {
            buffer.append(URelaxer.getNSMapping("", this.namespaceUri_));
        }
        Set keys = this.prefixByUri_.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            buffer.append(this.makeNSMapping(uri));
        }
    }

    public void makeNSMappings(Writer buffer) throws IOException {
        if (this.rnode_.rGetParentRNode() == null && this.getPrefixByUri(this.namespaceUri_) == null && !"".equals(this.namespaceUri_)) {
            buffer.write(URelaxer.getNSMapping("", this.namespaceUri_));
        }
        Set keys = this.prefixByUri_.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            buffer.write(this.makeNSMapping(uri));
        }
    }

    public void makeNSMappings(PrintWriter buffer) {
        if (this.rnode_.rGetParentRNode() == null && this.getPrefixByUri(this.namespaceUri_) == null && !"".equals(this.namespaceUri_)) {
            buffer.print(URelaxer.getNSMapping("", this.namespaceUri_));
        }
        Set keys = this.prefixByUri_.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            buffer.print(this.makeNSMapping(uri));
        }
    }

    public String makeQName(String uri, String localName) {
        return URelaxer.getQName(this.getPrefixByUri(uri), localName);
    }

    public void makeQName(String uri, String localName, StringBuffer buffer) {
        URelaxer.makeQName(this.getPrefixByUri(uri), localName, buffer);
    }

    public void makeQName(String uri, String localName, Writer buffer) throws IOException {
        URelaxer.makeQName(this.getPrefixByUri(uri), localName, buffer);
    }

    public void makeQName(String uri, String localName, PrintWriter buffer) {
        URelaxer.makeQName(this.getPrefixByUri(uri), localName, buffer);
    }

    public String makeNSMapping(String uri) {
        String prefix = (String)this.prefixByUri_.get(uri);
        if (prefix == null) {
            return "";
        }
        return URelaxer.getNSMapping(prefix, uri);
    }

    public String getNamespaceUri() {
        return this.namespaceUri_;
    }

    private void _updateNamespaceUri(String uri) {
        this.namespaceUri_ = uri;
    }

    public String getPrefix() {
        return this.getPrefixByUri(this.namespaceUri_);
    }

    public void setPrefix(String prefix) {
        this.declareNamespace(prefix, this.namespaceUri_);
    }

    public String getPrefixByUri(String uri) {
        if (XML_NS.equals(uri)) {
            return "xml";
        }
        if (XMLNS_NS.equals(uri)) {
            return "xmlns";
        }
        String prefix = (String)this.prefixByUri_.get(uri);
        if (prefix != null) {
            return prefix;
        }
        IRNSContainer parent = (IRNSContainer)((Object)this.rnode_.rGetParentRNode());
        if (parent == null) {
            return null;
        }
        return parent.rGetRNSContext().getPrefixByUri(uri);
    }

    public String getUriByPrefix(String prefix) {
        if ("xml".equals(prefix)) {
            return XML_NS;
        }
        if ("xmlns".equals(prefix)) {
            return XMLNS_NS;
        }
        String uri = (String)this.uriByPrefix_.get(prefix);
        if (uri != null) {
            return uri;
        }
        IRNSContainer parent = (IRNSContainer)((Object)this.rnode_.rGetParentRNode());
        if (parent == null) {
            return null;
        }
        return parent.rGetRNSContext().getUriByPrefix(prefix);
    }

    public String getDefaultNamespace() {
        return this.getUriByPrefix("");
    }
}

