/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

class WidgetTable {
    static int FreeSlot = 0;
    static int GrowSize = 1024;
    static int[] IndexTable = new int[GrowSize];
    static Control[] ControlTable = new Control[GrowSize];

    static {
        int i = 0;
        while (i < GrowSize - 1) {
            WidgetTable.IndexTable[i] = i + 1;
            ++i;
        }
        WidgetTable.IndexTable[WidgetTable.GrowSize - 1] = -1;
    }

    WidgetTable() {
    }

    public static synchronized Control get(int handle) {
        if (handle == 0) {
            return null;
        }
        int index = OS.GetWindowLong(handle, -21) - 1;
        if (index >= 0 && index < ControlTable.length) {
            return ControlTable[index];
        }
        return null;
    }

    public static synchronized void put(int handle, Control control) {
        if (handle == 0) {
            return;
        }
        if (FreeSlot == -1) {
            FreeSlot = IndexTable.length;
            int length = FreeSlot + GrowSize;
            int[] newIndexTable = new int[length];
            Control[] newControlTable = new Control[length];
            System.arraycopy(IndexTable, 0, newIndexTable, 0, FreeSlot);
            System.arraycopy(ControlTable, 0, newControlTable, 0, FreeSlot);
            int i = FreeSlot;
            while (i < length - 1) {
                newIndexTable[i] = i + 1;
                ++i;
            }
            newIndexTable[length - 1] = -1;
            IndexTable = newIndexTable;
            ControlTable = newControlTable;
        }
        OS.SetWindowLong(handle, -21, FreeSlot + 1);
        int oldSlot = FreeSlot;
        FreeSlot = IndexTable[oldSlot];
        WidgetTable.IndexTable[oldSlot] = -2;
        WidgetTable.ControlTable[oldSlot] = control;
    }

    public static synchronized Control remove(int handle) {
        if (handle == 0) {
            return null;
        }
        Control control = null;
        int index = OS.GetWindowLong(handle, -21) - 1;
        if (index >= 0 && index < ControlTable.length) {
            control = ControlTable[index];
            WidgetTable.ControlTable[index] = null;
            WidgetTable.IndexTable[index] = FreeSlot;
            FreeSlot = index;
            OS.SetWindowLong(handle, -21, 0);
        }
        return control;
    }

    public static synchronized Shell[] shells() {
        int size = WidgetTable.shellSize();
        int index = 0;
        Shell[] result = new Shell[size];
        int i = 0;
        while (i < ControlTable.length) {
            Control control = ControlTable[i];
            if (control != null && control instanceof Shell) {
                result[index++] = (Shell)control;
            }
            ++i;
        }
        return result;
    }

    static int shellSize() {
        int length = 0;
        int i = 0;
        while (i < ControlTable.length) {
            Control control = ControlTable[i];
            if (control != null && control instanceof Shell) {
                ++length;
            }
            ++i;
        }
        return length;
    }

    public static synchronized int size() {
        int length = 0;
        int i = 0;
        while (i < ControlTable.length) {
            if (ControlTable[i] != null) {
                ++length;
            }
            ++i;
        }
        return length;
    }
}

