%define vendor_name hde

%define target_name Mako
%define version 0.2.4
%define unmangled_version 0.2.4
%define release 2

%define _prefix /opt/%{vendor_name}

Summary: A super-fast templating language that borrows the  best ideas from the existing templating languages.
Name: %{vendor_name}-python-%{target_name}
Version: %{version}
Release: %{release}
Source0: %{target_name}-%{unmangled_version}.tar.gz
License: MIT/X11
Group: Development/Libraries
Vendor: HDE,Inc.
URL: http://www.makotemplates.org/
Packager: Taizo ITO <taizo.ito@hde.co.jp>
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Prefix: %{_prefix}
BuildArch: noarch

%description
Mako is a template library written in Python. It provides a familiar, non-XML 
syntax which compiles into Python modules for maximum performance. Mako's 
syntax and API borrows from the best ideas of many others, including Django
templates, Cheetah, Myghty, and Genshi. Conceptually, Mako is an embedded 
Python (i.e. Python Server Page) language, which refines the familiar ideas
of componentized layout and inheritance to produce one of the most 
straightforward and flexible models available, while also maintaining close 
ties to Python calling and scoping semantics.

SVN version:
<http://svn.makotemplates.org/mako/trunk#egg=Mako-dev>



%prep
%setup -n %{target_name}-%{unmangled_version}

%build
python setup.py build

%install
python setup.py install -O1 --skip-build --single-version-externally-managed --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES  --home=%{_prefix}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f INSTALLED_FILES
%defattr(-,root,root)

%changelog
* Tue May 19 2009 Taizo ITO <taizo.ito@hde.co.jp> - 0.2.4-2
- changed installed directory 'unix_prefix' => 'unix_home'.

* Wed Dec 24 2008 HDE Package Maintainer <info@hde.co.jp> - 0.2.4-1
- update version.

* Mon Dec 8 2008 HDE Package Maintainer <info@hde.co.jp> - 0.2.3-1
- update version.

* Fri Nov 28 2008 HDE Package Maintainer <info@hde.co.jp> - 0.2.2-1
- initial
