unit StrSub;
(* Tu[` *)
(* Copyright (c) 2001,2002 Twiddle <hetareprog@hotmail.com> *)

interface

uses
  SysUtils, StrUtils, Classes;

type
  (*-------------------------------------------------------*)
  TPSStream = class(TStringStream)
  public
    procedure SaveToFile(const fileName: string);
    procedure LoadFromFile(const fileName: string);
  end;

function FindPos(const substr: string;
                 const str: string;
                 offset: integer;
                 limit: integer = 0): integer;
function FindPosP(const substr: string;
                  str: Pchar;
                  len: integer): integer;
function FindPosIC(const substr: string;
                   const str: string;
                   offset: integer;
                   limit: integer = 0): integer;

function StartWith(const substr: string;
                   const str: string;
                   offset: integer): boolean;

function StartWithP(const substr: string;
                    str: PChar;
                    len: integer): boolean;

function ReplaceStr(const AString: string;
                    const AFrom: string;
                    const ATo: string): string;

function HexToInt(const AString: string): Integer;
function Str2Int(const AString: string): Integer;
function isAllNumber(str: PChar; startPos, endPos: integer): boolean;
function GetHex(str: PChar; size: integer; var val, len: integer): boolean;
function GetDecimal(str: PChar; size: integer; var val, len: integer): boolean;
function CountLines(const AString: string): Integer;
function Nth(const AString: string; target: Char; n: Integer): Integer;
(*=======================================================*)
implementation
(*=======================================================*)

(* t@Cۑ *)
procedure TPSStream.SaveToFile(const fileName: string);
var
  fs: TFileStream;
begin
  fs := TFileStream.Create(fileName, fmCreate);
  Position := 0;
  fs.CopyFrom(Self, Size);
  fs.Free;
end;

(* t@Co *)
procedure TPSStream.LoadFromFile(const fileName: string);
var
  fs: TFileStream;
begin
  fs := TFileStream.Create(fileName, fmOpenRead);
  CopyFrom(fs, fs.Size);
  fs.Free;
end;

(*=======================================================*)
(*  *)
function FindPos(const substr: string;
                 const str: string;
                 offset: integer;
                 limit: integer): integer;
var
  index: integer;
  off: integer;
  len, lenSub: integer;
label NEXT;
begin
  if 0 < limit then
    len := limit
  else
    len := Length(str);
  lenSub := Length(substr);
  for index := offset to len do begin
    if (str[index] = substr[1]) then begin
      for off := 2 to lenSub do begin
        if (str[index + off -1] <> substr[off]) then
          goto NEXT;
      end;
      result := index;
      Exit;
    end;
    NEXT:
  end;
  result := 0;
end;

function FindPosP(const substr: string;
                  str: Pchar;
                  len: integer): integer;
var
  index: integer;
  off: integer;
  lenSub: integer;
label NEXT;
begin
  lenSub := Length(substr);
  Dec(str);
  for index := 1 to len do begin
    if ((str + index)^ = substr[1]) then begin
      for off := 2 to lenSub do begin
        if ((str + index + off -1)^ <> substr[off]) then
          goto NEXT;
      end;
      result := index;
      Exit;
    end;
    NEXT:
  end;
  result := 0;
end;

function FindPosIC(const substr: string;
                 const str: string;
                 offset: integer;
                 limit: integer): integer;
var
  index: integer;
  off: integer;
  len, lenSub: integer;
  tmpStr: string;
label NEXT;
begin
  if 0 < limit then
    len := limit
  else
    len := Length(str);
  tmpStr := UpperCase(substr);
  lenSub := Length(substr);
  for index := offset to len do begin
    if (UpCase(str[index]) = tmpStr[1]) then begin
      for off := 2 to lenSub do begin
        if (UpCase(str[index + off -1]) <> tmpStr[off]) then
          goto NEXT;
      end;
      result := index;
      Exit;
    end;
    NEXT:
  end;
  result := 0;
end;

(*  *)
function StartWith(const substr: string;
                   const str: string;
                   offset: integer): boolean;
var
  index, lenSub, len: integer;
begin
  lenSub := Length(substr);
  len := Length(str);
  if (len - offset) < lenSub then begin
    result := False;
    exit;
  end;
  Dec(offset);
  for index := 1 to lenSub do begin
    if substr[index] <> str[offset + index] then begin
      result := False;
      exit;
    end;
  end;
  result := True;
end;

function StartWithP(const substr: string;
                    str: PChar;
                    len: integer): boolean;
var
  index, lenSub: integer;
begin
  lenSub := Length(substr);
  if len < lenSub then begin
    result := False;
    exit;
  end;
  for index := 1 to lenSub do begin
    if substr[index] <> str^ then begin
      result := False;
      exit;
    end;
    Inc(str);
  end;
  result := True;
end;

(* AnsiReplaceStr(str, #0, ' ') ĊҒʂɓȂH  *)
function ReplaceStr(const AString: string;
                    const AFrom: string;
                    const ATo: string): string;
var
  startPos, endPos: integer;
  targetPos: integer;
  targetLen: integer;
begin
  startPos := 1;
  endPos := length(AString);
  targetLen := length(AFrom);
  result := '';
  while true do
  begin
    targetPos := FindPos(AFrom, AString, startPos, endPos);
    if 0 < targetPos then
    begin
      if startPos < targetPos then
        result := result + Copy(AString, startPos, targetPos - 1);
      result := result + ATo;
      startPos := targetPos + targetLen;
    end
    else begin
      result := result + Copy(AString, startPos, endPos);
      break;
    end;
  end;
end;

function HexToInt(const AString: string): Integer;
var
  i: integer;
begin
  result := 0;
  for i := 1 to length(AString) do
  begin
    case AString[i] of
    '0'..'9': result := result * 16 + Ord(AString[i]) - Ord('0');
    'A'..'F': result := result * 16 + Ord(AString[i]) - Ord('A') + 10;
    'a'..'f': result := result * 16 + Ord(AString[i]) - Ord('a') + 10;
    else break;
    end;
  end;
end;

function Str2Int(const AString: string): Integer;
var
  i, len, sign: integer;
begin
  result := 0;
  len := length(AString);
  if len <= 0 then
    exit;
  i := 1;
  if AString[i] = '-' then
  begin
    sign := -1;
    Inc(i);
  end
  else
    sign := 1;
  for i := i to len do
  begin
    case AString[i] of
    '0'..'9': result := result * 10 + Ord(AString[i]) - Ord('0');
    else break;
    end;
  end;
  result := result * sign;
end;

function isAllNumber(str: PChar; startPos, endPos: integer): boolean;
var
  i: integer;
begin
  i := startPos;
  result := false;
  while i < endPos do
  begin
    case (str +i)^ of
    '0'..'9': ;
    #$82:
      if (i < endPos) and ((str + i+1)^ in [#$4f..#$58]) then
        inc(i)
      else
        exit;
    else
      exit;
    end;
    Inc(i);
  end;
  result := true;
end;

function GetHex(str: PChar; size: integer; var val, len: integer): boolean;
var
  i: integer;
begin
  val := 0;
  i := 0;
  while i < size do
  begin
    case (str + i)^ of
    '0'..'9': val := val * 16 + Ord((str + i)^) - Ord('0');
    'A'..'F': val := val * 16 + Ord((str + i)^) - Ord('A') + 10;
    'a'..'f': val := val * 16 + Ord((str + i)^) - Ord('a') + 10;
    else
      begin
        len := i;
        result := 0 < i;
        exit;
      end;
    end;
    Inc(i);
  end;
  result := 0 < i;
end;

function GetDecimal(str: PChar; size: integer; var val, len: integer): boolean;
var
  i: integer;
begin
  val := 0;
  i := 0;
  while i < size do
  begin
    case (str + i)^ of
    '0'..'9': val := val * 10 + Ord((str + i)^) - Ord('0');
    else
      begin
        len := i;
        result := 0 < i;
        exit;
      end;
    end;
    Inc(i);
  end;
  result := 0 < i;
end;


function CountLines(const AString: string): Integer;
var
  i: Integer;
begin
  result := 0;
  for i := 1 to length(AString) do
  begin
    if AString[i] = #10 then
      Inc(result);
  end;
end;

function Nth(const AString: string; target: Char; n: Integer): Integer;
var
  count: integer;
begin
  count := 0;
  for result := 0 to length(AString) do
  begin
    if AString[result] = target then
    begin
      Inc(count);
      if (n <= count) then
        exit;
    end;
  end;
  result := 0;
end;


(*=======================================================*)

end.
