unit untDoeSUB;

interface

uses
  Classes, SysUtils, StrUtils, Forms, Controls, Types,
  HogeTextView, StrSub;

const
  ATTRIB_BOLD = 1;
  ATTRIB_LINK = 2;

  ATTRIB_ANCHOR_NAME = 0;
  ATTRIB_ANCHOR_HREF = 1;

  DD_OFFSET_LEFT = 32;
  LI_OFFSET_LEFT = 16;

type

  (*-------------------------------------------------------*)
  THogeMemoryStream = class(TMemoryStream)
  public
    procedure WriteString(const str: string);
    procedure WriteChar(c: Char);
    function ReadString: string;
    property Memory;
  end;

  (*-------------------------------------------------------*)
  TDatItemType = (ditNORMAL, ditNAME, ditDATE, ditMAIL, ditMSG);
  (*-------------------------------------------------------*)
  TDatOut = class(TObject)
  public
    constructor Create;
    destructor Destroy; override;
    procedure WriteHTML(str: PChar; size: integer); overload; virtual;
    procedure WriteHTML(str: String); overload; virtual;
    procedure WriteText(str: PChar; size: integer); overload; virtual; abstract;
    procedure WriteText(str: String); overload; virtual;
    procedure WriteChar(c: Char); virtual;
    procedure WriteItem(str: PChar; size: integer;
                        itemType: TDatItemType); virtual; abstract;
    procedure WriteAnchor(const Name: string;
                          const HRef: string;
                          str: PChar; size: integer); virtual; abstract;
    procedure Flush; virtual;
  end;

  (*-------------------------------------------------------*)

  TConvDatOut = class(TDatOut)
  protected
    str: PChar;
    index: integer;
    size: integer;
    procedure EndOfTag;
    function GetTagName: string;
    function GetAttribPair(var name, value: string): Boolean;
    procedure SkipSpaces;
    function GetURL: string;
    function GetRange(var ANK: string): string;
    function DoRange(const prefix: string): boolean;
    function ProcRedirect: boolean; virtual;
    function ProcTag: boolean; virtual;
    function ProcURL: boolean; virtual;
    function ProcEntity: boolean; virtual;
    procedure ProcHTML; virtual;
    procedure ProcName; virtual;
  public
    procedure WriteItem(str: PChar; size: integer; itemType: TDatItemType); override;
  end;

  (*-------------------------------------------------------*)


  (*-------------------------------------------------------*)

  TDat2View = class(TConvDatOut)
  protected
    FBrowser: THogeTextView;
    re_entrant: integer;
    canceled: boolean;
    FAttribute: THogeAttribute;
    FBold: THogeAttribute;
    FStream: THogeMemoryStream;
    flushCount: integer;
    FOffsetLeft: integer;
    FBiteSpaces: boolean;
    FUser: integer;
    FHref: string;
    function ProcTag: boolean; override;
    function ProcEntity: boolean; override;
    procedure BeginAnchor; virtual;
    procedure EndAnchor; virtual;
  public
    constructor Create(browser: THogeTextView);
    destructor Destroy; override;
    procedure WriteText(str: PChar; size: integer); override;
    procedure WriteAnchor(const Name: string;
                          const HRef: string;
                          str: PChar; size: integer); override;
    procedure WriteChar(c: Char); override;
    procedure WriteUNICODE(str: PChar; size: integer);
    procedure WriteBR;
    procedure SetBold(boldP: boolean);
    procedure Flush; override;
    procedure Cancel;
  end;

  TSimpleDat2View = class(TDat2View)
  protected
    procedure ProcHTML; override;
    procedure BeginAnchor; override;
    procedure EndAnchor; override;
  public
    procedure Flush; override;
  end;

  function TVMouseProc(Sender: THogeTextView; Shift: TShiftState;
                     X, Y: Integer): string;

implementation

procedure THogeMemoryStream.WriteString(const str: string);
begin
  WriteBuffer(str[1], length(str));
end;

procedure THogeMemoryStream.WriteChar(c:Char);
begin
  WriteBuffer(c, 1);
end;

function THogeMemoryStream.ReadString: string;
var
  savePos: integer;
  count: integer;
  s: string;
begin
  count := Size;
  if count <= 0 then
  begin
    s := '';
  end
  else begin
    savePos := Position;
    Position := 0;
    SetLength(s, count);
    ReadBuffer(s[1], count);
    Position := savePos;
  end;
  result := s;
end;

(*=======================================================*)

(*=======================================================*)
constructor TDatOut.Create;
begin
  inherited;
end;

destructor TDatOut.Destroy;
begin
  inherited;
end;

procedure TDatOut.WriteHTML(str: PChar; size: integer);
begin
  WriteItem(str, size, ditNORMAL);
end;

procedure TDatOut.WriteHTML(str: String);
begin
  WriteHTML(PChar(str), length(str));
end;

procedure TDatOut.WriteText(str: String);
begin
  WriteText(PChar(str), length(str));
end;

procedure TDatOut.WriteChar(c: Char);
begin
  WriteText(@c, 1);
end;

procedure TDatOut.Flush;
begin
end;

(*=======================================================*)
procedure TConvDatOut.EndOfTag;
var
  quote: boolean;
begin
  quote := false;
  while index < size do
  begin
    if (str + index)^ = '"' then
      quote := not quote
    else if (not quote) and ((str + index)^ = '>') then
    begin
      Inc(index);
      exit;
    end;
    Inc(index);
  end;
end;

(* ^O擾() *)
function TConvDatOut.GetTagName: string;
var
  i: integer;
  tag: string;
begin
  for i := index to size - 1 do
  begin
    case (str + i)^ of
    '>', ' ', #1..#$1F, '=':
      begin
        index := i;
        result := LowerCase(tag);
        exit;
      end;
    else tag := tag + (str + i)^;
    end;
  end;
  result := LowerCase(tag);
  index := size;
end;

function TConvDatOut.GetAttribPair(var name, value: string): Boolean;
var
  i: integer;
label GOTVALUE;
begin
  while (index < size -1) and ((str + index)^ <> '>') do
  begin
    SkipSpaces;
    if (index < size -1) then
    begin
      name := GetTagName;
      SkipSpaces;
      if (index < size -1) and ((str + index)^ = '=') then
      begin
        Inc(index);
        SkipSpaces;
        value := '';
        if (index < size -1) and ((str + index)^ = '"') then
        begin
          for i := index + 1 to size -1 do
          begin
            case (str + i)^ of
            '>': begin index := i; goto GOTVALUE;; end;
            '"': begin index := i + 1; goto GOTVALUE; end;
            else value := value + (str + i)^;
            end;
          end;
          index := size -1;
        end
        else
          value := GetTagName;
        GOTVALUE:
          result := True;
          exit;
      end;
    end;
  end;
  result := False;
end;


procedure TConvDatOut.SkipSpaces;
var
  i: integer;
begin
  for i := index to size -1 do
  begin
    case (str + i)^ of
    #0..#$20:;
    else
      begin
        index := i;
        exit;
      end;
    end;
  end;
end;

function TConvDatOut.GetURL: string;
begin
  while index < size do
  begin
    case (str + index)^ of
    #$21, #$23..#$3B, #$3D, #$3F..#$7E: result := result + (str + index)^;
    else break;
    end;
    Inc(index);
  end;
end;


function TConvDatOut.GetRange(var ANK: string): string;
var
  s: string;
begin
  ANK := '';
  while index < size do
  begin
    case (str + index)^ of
    '0'..'9':
      begin
        s := s + (str + index)^;
        ANK := ANK + (str + index)^;
      end;
    '-':
      begin
        if length(s) <= 0 then
          break;
        s := s + (str + index)^;
        ANK := ANK + (str + index)^;
      end;
    #$81:
      begin
        if (index + 1 < size) and
           (((str + index+1)^ = #$7c) or
            ((str + index+1)^ = #$5d))  then
        begin (* | *)
          if length(s) <= 0 then
            break;
          s := s + #$81 + (str + index+1)^; //'|';
          ANK := ANK + '-';
          inc(index);
        end
        else
          break;
      end;
    #$82:
      begin
        if (index + 1 < size) and ((str + index+1)^ in [#$4f..#$58]) then
        begin   (* Sp *)
          inc(index);
          s := s + #$82 + (str + index)^;
          ANK := ANK + Chr(Ord((str + index)^) - $1f);
        end
        else
          break;
      end;
    else break;
    end;
    Inc(index);
  end;
  result := s;
end;

function TConvDatOut.ProcTag: boolean;
begin
  result := False;
end;

function TConvDatOut.ProcEntity: boolean;
begin
  result := False;
end;

function TConvDatOut.DoRange(const prefix: string): boolean;
var
  s, ANK: string;
  len: integer;
  c: Char;
begin
  len := length(prefix);
  Inc(index, len);
  s := GetRange(ANK);
  if 0 < length(s) then
  begin
    s := AnsiReplaceStr(prefix + s, '&gt;', '>');
    WriteAnchor('', '#' + ANK, PChar(s), length(s));
    ProcTag;
    while (index + 2 < size) and ((str + index)^ in [',', '=']) do
    begin
      c := (str + index)^;
      inc(index);
      s := GetRange(ANK);
      if length(s) <= 0 then
      begin
        dec(index);
        break;
      end;
      WriteChar(c);
      WriteAnchor('', '#' + ANK, PChar(s), length(s));
    end;
    result := true;
  end else
  begin
    Dec(index, len);
    result := false;
  end;
end;

function TConvDatOut.ProcRedirect: boolean;
begin
  (* &gt;[&gt;]digit[,digit|-digit] *)
  result := false;
  if (str + index)^ = '&' then
  begin
    if StartWithP('&gt;&gt;', str + index, size - index) then
      result := DoRange('&gt;&gt;')
    else if StartWithP('&gt;', str + index, size - index) then
      result := DoRange('&gt;');
  end
  else if StartWithP('', str + index, size - index) then
    result := DoRange('')
  else if StartWithP('', str + index, size - index) then
    result := DoRange('');
end;

function TConvDatOut.ProcURL: boolean;
var
  s: string;
begin
  (* http://xxx or ttp://xxx *)
  result := true;
  if (str + index)^ = 'h' then
  begin
    if StartWithP('http://', str + index, size - index) then
    begin
      s := GetURL;
      WriteAnchor('', s, PChar(s), length(s));
    end
    else if StartWithP('htp://', str + index, size - index) then
    begin
      s := GetURL;
      WriteAnchor('', 'ht' + Copy(s, 2, high(integer)), PChar(s), length(s));
    end
    else
      result := false;
  end
  else if StartWithP('ttp://', str + index, size - index) then
  begin
    s := GetURL;
    WriteAnchor('', 'h' + s, PChar(s), length(s));
  end
  else
    result := false;
end;


procedure TConvDatOut.ProcHTML;
begin
  while (index < size) do
  begin
    if not (((str + index)^ = '<') and ProcTag) and
       not (((str + index)^ in ['h','t']) and ProcURL) and
       not (((str + index)^ in ['&', #$81]) and ProcRedirect) and
       not (((str + index)^ = '&') and ProcEntity) then
    begin
      case (str + index)^ of
      #0..#$1F:;
      else
        WriteChar((str + index)^);
      end;
      Inc(index);
    end;
  end;
end;

procedure TConvDatOut.ProcName;
begin
  if isAllNumber(str, index, index + size) then
    DoRange('')
  else
    ProcHTML;
end;

procedure TConvDatOut.WriteItem(str: PChar; size: integer; itemType: TDatItemType);
begin
  Self.str   := str;
  Self.index := 0;
  Self.size  := size;
  if itemType = ditNAME then
    ProcName
  else
    ProcHTML;
end;

(*=======================================================*)

(* =========================================================== *)
function ZoomToPoint(zoom: integer): Integer;
begin
  result := -9;
  case zoom of
  0: result := -9;
  1: result := -10;
  2: result := -12;
  3: result := -16;
  4: result := -24;
  end;
end;

function ZoomToExternalLeading(zoom: integer): Integer;
begin
  result := 1;
  case zoom of
  0: result := 1;
  1: result := 2;
  2: result := 2;
  3: result := 3;
  4: result := 4;
  end;
end;

function FindAnchorName(item: THogeTVItem; var startPos, size: integer): boolean;
var
  i: integer;
begin
  if startPos <= 0 then
    i := 1
  else begin
    i := startPos + size;
    size := 0;
  end;
  startPos := 0;
  result := True;
  for i := i to length(item.FAttrib) do
  begin
    if (Ord(item.FAttrib[i]) and (htvVMASK or htvATTMASK))
       = (htvHIDDEN or ATTRIB_ANCHOR_NAME) then
    begin
      if startPos <= 0 then
        startPos := i
    end
    else if 0 < startPos then
    begin
      size := i - startPos;
      exit;
    end;
  end;
  result := false;
end;


(* =========================================================== *)

constructor TDat2View.Create(browser: THogeTextView);
begin
  inherited Create;
  FBrowser := browser;
  canceled := false;
  re_entrant := 0;
  FAttribute := 0;
  FBold := 0;
  FStream := THogeMemoryStream.Create;
  FStream.Size := 4096;
  flushCount := 0;
  FOffsetLeft := 0;
  FBiteSpaces := False;
  FUser := 0;
end;

destructor TDat2View.Destroy;
begin
  FStream.Free;
  inherited;
end;

procedure TDat2View.BeginAnchor;
begin
end;

procedure TDat2View.EndAnchor;
begin
end;

function TDat2View.ProcTag: boolean;
  procedure SetFont;
  var
    name, value: string;
  begin
    while GetAttribPair(name, value) do
    begin
      if (name = 'face') and (0 < length(value)) then
      begin
        FBrowser.SetFont(value, 12);
        break;
      end;
    end;
  end;

  procedure SetAttrib;
  var
    name, value: string;
    att: integer;
  begin
    while GetAttribPair(name, value) do
    begin
      if (name = 'i') and (0 < length(value)) then
      begin
        att := (Str2Int(value) * 2) mod 32;
        if att <> FAttribute then
        begin
          Flush;
          FAttribute := att;
        end;
        break;
      end;
    end;
  end;

var
  tag: string;
begin
  if (str + index)^ = '<' then
  begin
    Inc(index);
    tag := GetTagName;
    if (tag = 'br') or (tag = 'hr') or (tag = '/p') or (tag = '/li') or
       (tag = 'ul') then
      WriteBR
    else if (tag = 'dd') then
    begin
      WriteBR;
      FOffsetLeft := DD_OFFSET_LEFT;
    end
    else if (tag = '/dd') then
    begin
      FOffsetLeft := 0;
    end
    else if (tag = 'b') then
      SetBold(True)
    else if (tag = '/b') then
      SetBold(False)
    else if (tag = 'font') then
      SetFont
    else if (tag = 'sa') then
      SetAttrib
    else if (tag = 'a') then
      BeginAnchor
    else if (tag = '/a') then
      EndAnchor;
    EndOfTag;
    result := True;
  end
  else
    result := false;
end;

(* (str + index)^ = '&' *)
function TDat2View.ProcEntity: boolean;
var
  i, len, val: integer;

  procedure OutCode;
  begin
    Inc(i, len);
    if 255 < val then
    begin
      if val <> 3642 then
        WriteUNICODE(PChar(@val), 2);
    end
    else if Chr(val) in LeadBytes then
    begin
      FStream.WriteBuffer((str + index)^, i - index)
    end
    else
      FStream.WriteBuffer(PChar(@val)^, 1);
    index := i;
    if (str + index)^ = ';' then
      Inc(index);
  end;

var
  s, sEnd: string;
begin
  result := true;
  i := index + 1;
  if (str + i)^ = '#' then
  begin
    val := 0;
    Inc(i);
    if (str + i)^ in ['X','x'] then
    begin
      Inc(i);
      if GetHex(str + i, size - i, val, len) then
      begin
        OutCode;
        exit;
      end;
    end
    else begin
      if GetDecimal(str + i, size - i, val, len) then
      begin
        OutCode;
        exit;
      end;
    end;
  end
  else begin
    while i < size do
    begin
      case (str + i)^ of
      'A'..'Z','a'..'z':
        begin
          s := s + (str + i)^;
          if s = 'amp' then  (* ÂO ; ŏIȂ̂ *)
          begin
            WriteChar('&');
            index := i + 1;
            if (index < size) and ((str + index)^ = ';') then
              Inc(index);
            exit;
          end;
        end;
      else
        begin
//          SetLength(s, i - index - 1);
//          Move((str + index + 1)^, s[1], i - index - 1);
          if (str + i)^ = ';' then
          begin
            sEnd := (str + i)^;
            Inc(i);
          end;
          if (s = 'gt') then
            WriteChar('>')
          else if (s = 'lt') then
            WriteChar('<')
          else if (s = 'quot') then
            WriteChar('"')
          else if (s = 'nbsp') or (s = 'ensp') or (s = 'thinsp') then
            WriteChar(' ')
          else if (s = 'copy') then
            WriteUNICODE(#$A9#$00, 2)
          else if (s = 'hearts') then
            WriteUNICODE(#$65#$26, 2)
          else
            WriteText('&' + s + sEnd);
          index := i;
          exit;
        end;
      end;
      Inc(i);
    end;
  end;
  result := false;
end;


procedure TDat2View.WriteText(str: PChar; size: integer);
begin
  FStream.WriteBuffer(str^, size);
  FBiteSpaces := False;
end;

procedure TDat2View.WriteAnchor(const Name: string;
                                const Href: string;
                                str: PChar; size: integer);
var
  user: integer;
begin
  Flush;
  if 0 < length(Href) then
    user := htvUSER
  else
    user := 0;

  FBrowser.nAppend(str, size, FBold or ATTRIB_LINK or user);
  FBrowser.Append(Name, ATTRIB_ANCHOR_NAME or htvHIDDEN);
  FBrowser.Append(Href, ATTRIB_ANCHOR_HREF or htvHIDDEN);

  FBiteSpaces := False;
end;

procedure TDat2View.WriteBR;
  procedure TrimRight;
  var
    i: integer;
    p: PChar;
  begin
    p := FStream.Memory;
    for i := FStream.Position -1 downto 0 do
    begin
      if (p+i)^ <> ' ' then
      begin
        FStream.Position := i + 1;
        exit;
      end;
    end;
    FStream.Position := 0;
  end;

begin
  TrimRight;
  Flush;
  FBrowser.Append(#10);
  FBiteSpaces := True;
end;

procedure TDat2View.SetBold(boldP: boolean);
begin
  Flush;
  if boldP then
    FBold := 1
  else
    FBold := 0;
end;

procedure TDat2View.WriteChar(c: Char);
begin
  if FBiteSpaces and (c = ' ') then
    exit;
  FBiteSpaces := False;
  if ' ' <= c then
    FStream.WriteChar(c);
end;

procedure TDat2View.WriteUNICODE(str: PChar; size: integer);
begin
  Flush;
  FBrowser.nAppend(str, size, FBold or FAttribute or htvUNICODE);
end;

procedure TDat2View.Flush;
begin
  FBrowser.Strings[FBrowser.Strings.Count -1].OffsetLeft := FOffsetLeft;
  if FStream.Position <= 0 then
    exit;
  if FUser <> 0 then
    FBrowser.nAppend(FStream.Memory, FStream.Position, FBold or FUser)
  else
    FBrowser.nAppend(FStream.Memory, FStream.Position, FBold or FAttribute);
  FStream.Position := 0;
  Inc(flushCount);
  if (flushCount mod 256) = 0 then
  begin
    Inc(re_entrant);
    Application.ProcessMessages;
    Dec(re_entrant);
  end;
end;

procedure TDat2View.Cancel;
begin
  canceled := true;
end;

(* =========================================================== *)

(*=======================================================*)

procedure TSimpleDat2View.BeginAnchor;
var
  name, value: string;
begin
  Flush;
  FHref := '';
  while GetAttribPair(name, value) do
  begin
    if name = 'href' then
    begin
      FHref := value;
      break;
    end;
  end;
  FUser := htvUSER or ATTRIB_LINK;
end;

procedure TSimpleDat2View.EndAnchor;
begin
  Flush;

  //WriteAnchor('', FHref, PChar(FHref), length(FHref));
  FBrowser.Append(FHref, ATTRIB_ANCHOR_HREF or htvHIDDEN);
  FUser := 0;
end;

procedure TSimpleDat2View.ProcHTML;
begin
  while (index < size) do
  begin
    if not (((str + index)^ = '<') and ProcTag) and
       not (((str + index)^ = '&') and ProcEntity) then
    begin
      case (str + index)^ of
      #0..#$1F:;
      else
        WriteChar((str + index)^);
      end;
      Inc(index);
    end;
  end;
end;

procedure TSimpleDat2View.Flush;
begin
  FBrowser.Invalidate;
  inherited;
end;

function TVMouseProc(Sender: THogeTextView; Shift: TShiftState;
                     X, Y: Integer): string;
var
  point: TPoint;
  view: THogeTextView;
  item: THogeTVItem;
  index: integer;
  newCursor: TCursor;
begin
  result := '';
  view := THogeTextView(Sender);
  point := view.ClientToPhysicalCharPos(X, Y);
  newCursor := crDefault;
  if 0 <= point.X then
  begin
    newCursor := crIBeam;
    item := view.Strings[point.Y];
    index := point.X +1;
    with THogeTextView(Sender) do
    begin
      if InSelection(point.X, point.Y) then
      begin
        if Cursor <> crDefault then
          Cursor := crDefault;
        exit;
      end;
    end;
    result := item.GetEmbed(index);
    if 0 < length(result) then
      newCursor := crHandPoint;
  end;
  with THogeTextView(Sender) do
    if Cursor <> newCursor then
      Cursor := newCursor;
end;

end.
