unit untFolderAlias;

interface

uses
  Classes, Contnrs, SysUtils,
  untTool, untOption;

type

  TAlias = class
  public
    DisplayName : string;
    BoardName   : string;
    Folders     : TStringList;
    constructor Create;
    destructor  Destroy; override;
  end;

  TFolderAlias = class
  private
    FAliasList : TObjectList;   
  public
    constructor Create();
    destructor  Destroy(); override;
    function    GetFolderPath(Server, BoardName, filename: string; var resultpath : string): boolean;
    procedure   AddAlias(BoardName, DisplayName, Server : string);
    procedure   Save();
  end;

implementation

{ TBoardAlias }

constructor TFolderAlias.Create();
var
  lines     : TStringList;
  i         : integer;
  parsemode : integer;
  alias     : TAlias;
  filepath  : string;
  items     : TStringArray;
begin

  alias := nil;
  SetLength(items, 0);

  FAliasList := TObjectList.Create;

  filepath := AppPath(FILE_BOARDALIAS);
  if FileExists(filepath) = false then exit;

  // Alias f[^̓ǂݍ
  lines := TStringList.Create;
  lines.LoadFromFile(filepath); 
  parsemode := 0;
  for i := 0 to lines.Count - 1 do
  begin

    if lines[i] = '' then
    begin
      parsemode := 0;
      continue;
    end;

    if parsemode = 0 then
    begin
      alias := TAlias.Create;
      FAliasList.Add(alias); 

      items := Split(lines[i], #9, 2);
      alias.DisplayName := items[0];
      alias.BoardName   := items[1];
      parsemode := 1;
    end else
    if parsemode = 1 then
    begin
      alias.Folders.Add(Lowercase(lines[i]));
    end;
  end;

  lines.Free;

end;

destructor TFolderAlias.Destroy;
begin
  FAliasList.Free;

  inherited;
end;

function TFolderAlias.GetFolderPath(Server, BoardName, filename: string; var resultpath : string): boolean;
var
  I, J, K  : integer;
  alias    : TAlias;
  folder   : string;
begin

  folder := LowerCase(Server + '\' + BoardName);
  folder := StringReplace(folder, '/', '_', [rfReplaceAll]);

  // Alias f[^̌
  for I := 0 to FAliasList.Count - 1 do
  begin
    alias := TAlias(FAliasList[i]);
    for J := 0 to alias.Folders.Count - 1 do
      if alias.Folders[J] = folder then
      begin

        // w肳ꂽt@C݂tH_Ԃ
        for K := 0 to alias.Folders.Count - 1 do
          if FileExists(AppPath(DIR_LOG + alias.Folders[K] + '\' + filename)) then
          begin
            resultpath := AppPath(DIR_LOG + alias.Folders[K] + '\');
            result := true;
            exit;
          end;

        // t@C݂Ȃ΁Aalias̍ŏ̃ACeԂ
        resultpath := AppPath(DIR_LOG + alias.Folders[0] + '\');
        result := false;
        exit;
      end;
  end;

  // }b`aliasf[^݂Ȃ΁Aw肳ꂽACeԂ
  resultpath := AppPath(DIR_LOG + folder + '\');
  result := false;

end;

procedure TFolderAlias.AddAlias(BoardName, DisplayName, Server: string);
var
  I        : integer;
  alias    : TAlias;
  folder   : string;
  match    : boolean;
begin

  alias := nil;

  folder := LowerCase(Server + '\' + BoardName);
  folder := StringReplace(folder, '/', '_', [rfReplaceAll]);

  // Alias f[^̌
  match := false;
  for I := 0 to FAliasList.Count - 1 do
  begin
    alias := TAlias(FAliasList[i]);
    if (alias.DisplayName = DisplayName) and
       (alias.BoardName   = BoardName) then
    begin
      match := true;
      break;
    end;
  end;

  // }b`ȂΐVǉ
  if match = false then
  begin
    alias := TAlias.Create;
    alias.DisplayName := DisplayName;
    alias.BoardName   := BoardName;
    FAliasList.Add(alias);
  end;

  if alias.Folders.IndexOf(folder) = - 1then
    alias.Folders.Add(folder);

end;

procedure TFolderAlias.Save;
var
  savefile : TStringList;
  I, J     : integer;
  alias    : TAlias;
begin

  savefile := TStringList.Create;

  for I := 0 to FAliasList.Count - 1 do
  begin
    alias := TAlias(FAliasList[i]);
    savefile.Add(alias.DisplayName + #9 + alias.BoardName);

    for J := 0 to alias.Folders.Count - 1 do
      savefile.Add(alias.Folders[J]);

    savefile.Add('');
  end;

  savefile.SaveToFile(AppPath(FILE_BOARDALIAS)); 

  savefile.Free;

end;

{ TAlias }

constructor TAlias.Create;
begin
  Folders := TStringList.Create;
end;

destructor TAlias.Destroy;
begin
  Folders.Free;

  inherited;
end;

end.
