unit untTopic;

interface

uses
  SysUtils, Classes, Contnrs, Dialogs, Forms, DzURL, BmRegexp,
  untTool, untOption, SyncObjs, untStreamTool,
  untBBSSub, RegExpr;

type

  TTopicMessage = class
  private
    FIsNewMessage: Boolean;
    FIndex: Integer;
    FBody: string;
    FRestStr: string;
    FPostemail: string;
    FPostName: string;
    //FReplaceMode : integer;
    procedure SetBody(const Value: string);
    procedure SetIndex(const Value: Integer);
    procedure SetIsNewMessage(const Value: Boolean);
    procedure SetPostemail(const Value: string);
    procedure SetPostName(const Value: string);
    procedure SetRestStr(const Value: string);
    function GetForPopup() : string;
  public
    property Index        : Integer read FIndex write SetIndex;
    property Body         : string  read FBody write SetBody;
    property PostName     : string  read FPostName write SetPostName;
		property Postemail    : string  read FPostemail write SetPostemail;
    property RestStr      : string  read FRestStr write SetRestStr;
    property IsNewMessage : Boolean read FIsNewMessage write SetIsNewMessage;
    property ForPopup     : string  read GetForPopup;
  end;

  TDownloadState = (dsNone, dsStarting, dsProcessing, dsDatLoaded, dsError, dsFreezed);
  TWriteDoneEvent = procedure(sender : TObject; ErrorMessage : string) of object;

  TTopic = class
  private
    FReferenceCount : integer;
    FIsDownloadingTopic: Boolean;
    FCritSec        : TCriticalSection;
    FTopicId: string;
    FIsNoNotice: Boolean;
    FNewMessageCount: Integer;
    FIndex: Integer;
    FDatSize: Integer;
    FMessageCount: Integer;
    FScrollPosition: Integer;
    FGotMessageCount: Integer;
    FBoardName: string;
    FTopicPath: string;
    FTitle: string;
    FBoardServer: string;
    FWroteName: string;
    FBoardId: string;
    FWroteEmail: string;
    FBoard: TObject;
    FLocalDir: string;
    FIsFavorite: boolean;
    FIsGotLog: boolean;
    FIsFreezed: boolean;
    FPriority: Integer;
    FMemo: string;
    FOnMessageReceived: TNotifyEvent;
    FNoNotice: Boolean;
    FMessageList : TThreadList;
    FIsError: Boolean;
    FStatusText: string;
    FIsLoadedLocalDat: Boolean;
    FLastModified: string;
    FNewReceivedMessage: TTopicMessage;
    FDownloadState: TDownloadState;
    FWriteError: string;
    FIsPosingArticle: Boolean;
    FDownloadThread: TThread;
    FLastWriteDate: string;
    FLastReadDate: string;
    FOldLog: Boolean;
    FNoIndex: Boolean;
    FOnChangeDownloadState: TNotifyEvent;
    FDefaultTopicChangeDownloadStateFunction: TNotifyEvent;
    FRaisingChangeDownloadState : Boolean;
    FIsInBox: boolean;
    procedure SetTopicId(const Value: string);
    procedure SetBoard(const Value: TObject);
    procedure SetDatSize(const Value: Integer);
    procedure SetGotMessageCount(const Value: Integer);
    procedure SetIndex(const Value: Integer);
    procedure SetIsNoNotice(const Value: Boolean);
    procedure SetMessageCount(const Value: Integer);
    procedure SetNewMessageCount(const Value: Integer);
    procedure SetScrollPosition(const Value: Integer);
    procedure SetTitle(const Value: string);
    procedure SetTopicPath(const Value: string);
    procedure SetWroteEmail(const Value: string);
    procedure SetWroteName(const Value: string);
    procedure UpdateBoardInfo();
    procedure SetLocalDir(const Value: string);
    procedure SetIsFavorite(const Value: boolean);
    procedure SetIsFreezed(const Value: boolean);
    procedure SetIsGotLog(const Value: boolean);
    procedure SetPriority(const Value: Integer);
    procedure SetMemo(const Value: string);
    procedure SetOnMessageReceived(const Value: TNotifyEvent);
    procedure SetNoNotice(const Value: Boolean);
    procedure SetIsError(const Value: Boolean);
    procedure SetStatusText(const Value: string);
    function  GetDatUrl: string;
    function  GetBrowserUrl: string;
    procedure SetIsDownloadingTopic(const Value: Boolean);
    procedure SetIsLoadedLocalDat(const Value: Boolean);
    procedure SetLastModified(const Value: string);
    procedure SetNewReceivedMessage(const Value: TTopicMessage);
    procedure SetDownloadState(const Value: TDownloadState);
    procedure SetWriteError(const Value: string);
    procedure SetIsPosingArticle(const Value: Boolean);
    procedure SetLastReadDate(const Value: string);
    procedure SetLastWriteDate(const Value: string);
    procedure SetOldLog(const Value: Boolean);
    procedure SetNoIndex(const Value: Boolean);
    procedure SetOnChangeDownloadState(const Value: TNotifyEvent);
    procedure SetDefaultTopicChangeDownloadStateFunction(
      const Value: TNotifyEvent);
    procedure RaiseChangeDownloadStateEvent;
    procedure SetIsInBox(const Value: boolean);
  public
    property OldLog : Boolean read FOldLog write SetOldLog;
    property TopicId         : string       read FTopicId         write SetTopicId;
    property TopicPath       : string       read FTopicPath       write SetTopicPath;
    property Title           : string       read FTitle           write SetTitle;
    property MessageCount    : Integer      read FMessageCount    write SetMessageCount;
    property Index           : Integer      read FIndex           write SetIndex;
    property Board           : TObject      read FBoard           write SetBoard;
    property IsNoNotice      : Boolean      read FIsNoNotice      write SetIsNoNotice;
    property GotMessageCount : Integer      read FGotMessageCount write SetGotMessageCount;
    property NewMessageCount : Integer      read FNewMessageCount write SetNewMessageCount;
    property WroteName       : string       read FWroteName       write SetWroteName;
    property WroteEmail      : string       read FWroteEmail      write SetWroteEmail;
    property DatSize         : Integer      read FDatSize         write SetDatSize;
    property ScrollPosition  : Integer      read FScrollPosition  write SetScrollPosition;
    property LocalDir        : string       read FLocalDir        write SetLocalDir;
    property IsFreezed       : boolean      read FIsFreezed       write SetIsFreezed;
    property IsGotLog        : boolean      read FIsGotLog        write SetIsGotLog;
    property IsFavorite      : boolean      read FIsFavorite      write SetIsFavorite;
    property IsInBox         : boolean read FIsInBox write SetIsInBox;
    property Priority        : Integer      read FPriority        write SetPriority;
    property Memo            : string       read FMemo            write SetMemo;
    property NoNotice        : Boolean read FNoNotice write SetNoNotice;
    property IsError         : Boolean read FIsError write SetIsError;
    property StatusText      : string read FStatusText write SetStatusText;
    property DatUrl          : string read GetDatUrl;
    property BrowserUrl      : string read GetBrowserUrl;
    property DownloadState   : TDownloadState read FDownloadState write SetDownloadState;
    property OnMessageReceived : TNotifyEvent read FOnMessageReceived write SetOnMessageReceived;
    property OnChangeDownloadState : TNotifyEvent read FOnChangeDownloadState write SetOnChangeDownloadState;
    //property OnUpdate         :  TNotifyEvent read FOnUpdate write SetOnUpdate;
    property MessageList     : TThreadList read FMessageList;
    property IsDownloadingTopic : Boolean read FIsDownloadingTopic write SetIsDownloadingTopic;
    property IsPosingArticle : Boolean read FIsPosingArticle write SetIsPosingArticle;
    property IsLoadedLocalDat : Boolean read FIsLoadedLocalDat write SetIsLoadedLocalDat;
    property LastModified : string read FLastModified write SetLastModified;
    property NewReceivedMessage : TTopicMessage read FNewReceivedMessage write SetNewReceivedMessage;
    property WriteError : string read FWriteError write SetWriteError;
    //property DownloadThread : TThread read FDownloadThread write SetDownloadThread;
    property LastReadDate  : string read FLastReadDate write SetLastReadDate;
    property LastWriteDate : string read FLastWriteDate write SetLastWriteDate;
    property NoIndex : Boolean read FNoIndex write SetNoIndex;
    constructor Create(Board : TObject; TopicId : string);
    destructor  Destroy(); override;
    procedure SaveIdx();
    procedure CheckWriteFolder;
    procedure StopDownload;
    procedure EraseLog;
    procedure EraseMessageList;
    procedure CountUp;
    procedure CountDown;
    procedure AddNewMessage(msg : TTopicMessage);
    property  DefaultTopicChangeDownloadStateFunction : TNotifyEvent read FDefaultTopicChangeDownloadStateFunction write SetDefaultTopicChangeDownloadStateFunction;
  end;

implementation

uses
  untBoard, untGlobal, untBBSCore;

{ TTopicMessage }

//  vpeB 

// |bvAbvp̃bZ[W
function TTopicMessage.GetForPopup: string;
var
  puretext : string;
  regex    : TRegExpr;
begin

  puretext := IntToStr(FIndex)       + ' ' +
              'OF'   + FPostName + ' ' +
              'eF' + FRestStr  + #10 +
              FBody;

  // HTML^O
	puretext := StringReplace(puretext, '<br>', #10, [rfReplaceAll]);
  regex := TRegExpr.Create;
  regex.Expression := '<.*?>';
  puretext := regex.Replace(puretext, '');
  regex.Free;

  // ꕶϊ
  puretext := StringReplace(puretext, '&gt;', '>', [rfReplaceAll]);
  puretext := StringReplace(puretext, '&lt;', '<', [rfReplaceAll]);

  result := puretext;

end;

procedure TTopicMessage.SetBody(const Value: string);
begin
  FBody := Value;
end;

procedure TTopicMessage.SetIndex(const Value: Integer);
begin
  FIndex := Value;
end;

procedure TTopicMessage.SetIsNewMessage(const Value: Boolean);
begin
  FIsNewMessage := Value;
end;

procedure TTopicMessage.SetPostemail(const Value: string);
begin
  FPostemail := Value;
end;

procedure TTopicMessage.SetPostName(const Value: string);
begin
  FPostName := Value;
end;

procedure TTopicMessage.SetRestStr(const Value: string);
begin
  FRestStr := Value;
end;

{ TTopic }

//  vpeB 

procedure TTopic.SetBoard(const Value: TObject);
begin
  FCritSec.Enter;
  FBoard := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetNoIndex(const Value: Boolean);
begin
  FCritSec.Enter;
  FNoIndex := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetLastReadDate(const Value: string);
begin
  FCritSec.Enter;
  FLastReadDate := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetOldLog(const Value: Boolean);
begin
  FCritSec.Enter;
  FOldLog := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetLastWriteDate(const Value: string);
begin
  FCritSec.Enter;
  FLastWriteDate := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetIsPosingArticle(const Value: Boolean);
begin
  FCritSec.Enter;
  FIsPosingArticle := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetLastModified(const Value: string);
begin
  FCritSec.Enter;
  FLastModified := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetNewReceivedMessage(const Value: TTopicMessage);
begin
  FCritSec.Enter;
  FNewReceivedMessage := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetIsLoadedLocalDat(const Value: Boolean);
begin
  FCritSec.Enter;
  FIsLoadedLocalDat := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetIsDownloadingTopic(const Value: Boolean);
begin
  FCritSec.Enter;
  FIsDownloadingTopic := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetDatSize(const Value: Integer);
begin
  FCritSec.Enter;
  FDatSize := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetStatusText(const Value : string);
begin

//  if FRaisingChangeDownloadState then exit;

  FCritSec.Enter;
  FStatusText := Value;
  FCritSec.Leave;

  RaiseChangeDownloadStateEvent;


end;

procedure TTopic.SetDownloadState(const Value: TDownloadState);
begin

//  if FRaisingChangeDownloadState then exit;

  FCritSec.Enter;
  FDownloadState := Value;
  FCritSec.Leave;

  RaiseChangeDownloadStateEvent;


end;


procedure TTopic.SetGotMessageCount(const Value: Integer);
begin
  FCritSec.Enter;
  FGotMessageCount := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetIndex(const Value: Integer);
begin
  FCritSec.Enter;
  FIndex := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetIsNoNotice(const Value: Boolean);
begin
  FCritSec.Enter;
  FIsNoNotice := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetMessageCount(const Value: Integer);
begin
  FCritSec.Enter;
  FMessageCount := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetNewMessageCount(const Value: Integer);
begin
  FCritSec.Enter;
  FNewMessageCount := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetScrollPosition(const Value: Integer);
begin
  FCritSec.Enter;
  FScrollPosition := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetTitle(const Value: string);
begin
  FCritSec.Enter;
  FTitle := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetTopicId(const Value: string);
begin
  FCritSec.Enter;
  FTopicId := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetTopicPath(const Value: string);
begin
  FCritSec.Enter;
  FTopicPath := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetIsInBox(const Value: boolean);
begin
  FCritSec.Enter;
  FIsInBox := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetWroteEmail(const Value: string);
begin
  FCritSec.Enter;
  FWroteEmail := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetWroteName(const Value: string);
begin
  FCritSec.Enter;
  FWroteName := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetLocalDir(const Value: string);
begin
  FCritSec.Enter;
  FLocalDir := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetIsFavorite(const Value: boolean);
begin
  FCritSec.Enter;
  FIsFavorite := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetIsFreezed(const Value: boolean);
begin
  FCritSec.Enter;
  FIsFreezed := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetIsGotLog(const Value: boolean);
begin
  FCritSec.Enter;
  FIsGotLog := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetPriority(const Value: Integer);
begin
  FCritSec.Enter;
  FPriority := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetMemo(const Value: string);
begin
  FCritSec.Enter;
  FMemo := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetOnMessageReceived(const Value: TNotifyEvent);
begin
  FCritSec.Enter;
  FOnMessageReceived := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetNoNotice(const Value: Boolean);
begin
  FCritSec.Enter;
  FNoNotice := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetIsError(const Value: Boolean);
begin
  FCritSec.Enter;
  FIsError := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetWriteError(const Value: string);
begin
  FCritSec.Enter;
  FWriteError := Value;
  FCritSec.Leave;
end;

function TTopic.GetDatUrl: string;
var
  Board : TOnlineBoard;
begin
  //UpdateBoardInfo();
  Board := TOnlineBoard(FBoard);

  if board.BBSType = btJBBS then
    result := 'http://' + Board.Server
            + '/bbs/read.cgi?BBS=' + board.BoardName
            + '&KEY=' + FTopicId
  else
  	result := 'http://' + Board.Server + '/'
            + Board.BoardName  +	'/dat/'
            + FTopicId + '.dat';
end;

function TTopic.GetBrowserUrl : string;
var
  Board : TOnlineBoard;
begin
  Board := TOnlineBoard(FBoard);

  if board.BBSType = btJBBS then
    result := 'http://' + Board.Server
            + '/bbs/read.cgi?BBS=' + board.BoardName
            + '&KEY=' + FTopicId
  else
    result := 'http://' + Board.Server + '/test/read.cgi/'  +
              Board.BoardName  + '/' + FTopicId + '/';
end;

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : topicpath
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TTopic.Create(Board : TObject; TopicId : string);
var
  idxpath      : string;
  idxlines     : TStringList;
  idxitems     : TStringArray;
  state        : Integer;
  savedir      : string;
  onlineboard  : TOnlineBoard;
label
  NoIdx;
begin
  FBoard   := Board;
  FTopicId := topicId;

  SetLength(idxitems, 0);

  FCritSec := TCriticalSection.Create;
  FCritSec.Enter;

  FGotmessagecount := 0;
  FNewmessagecount := 0;

  FOldLog := false;
  onlineboard := TOnlineBoard(Board);
  if gFolderAlias.GetFolderPath(onlineboard.Server, onlineboard.BoardName, FTopicId + '.i', savedir) then
    FLocalDir := savedir
  else
  begin
    if gFolderAlias.GetFolderPath(onlineboard.Server, onlineboard.BoardName, FTopicId + '.idx', savedir) then
      FOldLog   := true;
    FLocalDir := savedir;
  end;

  UpdateBoardInfo();

  // IDX t@CΓǂݍ
  FNoIndex := true;
  if DirectoryExists(FLocalDir) = true then
  begin
    idxpath := localdir + FTopicId + '.i';
    if FileExists(idxpath) = false then
    begin
      idxpath := localdir + FTopicId + '.idx';
      if FileExists(idxpath) = false then
        goto NoIdx;
    end;

    idxlines := TStringList.Create();
    idxlines.LoadFromFile(idxpath);
    if idxlines.Count > 0 then
    begin
      idxitems := Split(idxlines[0], #9);
      if Length(idxitems) >= 18 then
      begin
        FNoIndex := false;

        state := StrToIntNeo(idxitems[1]);
        FIsFreezed       := Boolean(state and 16);
        FIsGotLog        := Boolean(state and 32);
        FIsFavorite      := Boolean(state and 64);

        FPriority        := StrToInt(idxitems[2]);
        FTitle           := idxitems[3];
        FMessageCount    := StrToInt(idxitems[7]);
        FGotMessageCount := StrToInt(idxitems[8]);
        FNewMessageCount := StrToInt(idxitems[9]);
        FLastReadDate    := idxitems[10];
        FLastWriteDate   := idxitems[11];
        FBoardName       := idxitems[12];
        FDatSize         := StrToInt(idxitems[13]);
        FWroteName       := idxitems[14];
        FWroteEmail      := idxitems[15];
        FScrollPosition  := StrToInt(idxitems[16]);
        FMemo            := idxitems[17];
      end;

      // only 88 item
      if Length(idxitems) > 21 then
        FLastModified    := idxitems[21];

      // ver0.23 add
      if Length(idxitems) > 22 then
      begin
        state    := StrToIntNeo(idxitems[22]);
        FIsInBox := Boolean(state and 16);
      end;

    end;
    idxlines.Free;
  end;

NoIdx:

  FMessageList := TThreadList.Create;

  FCritSec.Leave;

end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TTopic.Destroy;
var
  I       : Integer;
  MsgList : TList;
begin

  StopDownload;

  MsgList := FMessageList.LockList;
  for I := 0 to MsgList.Count - 1 do
    TObject(MsgList[I]).Free;
  FMessageList.UnlockList;
  FMessageList.Free;
  
  FCritSec.Free;

  inherited;
end;

{ --------------------------------------------------------
  ֐: SaveIdx
  pr  : Idxt@C̋L^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.SaveIdx;
var
  line    : string;
  state   : Integer;
  state2  : Integer;
  idxpath : string;
begin

  FCritSec.Enter;

  CheckWriteFolder;

  FNoIndex := false;

  state := 0;
  if(FIsFreezed)  then state := state or 16;
  if(FIsGotLog)   then state := state or 32;
	if(FIsFavorite) then state := state or 64;

  state2 := 0;
  if(FIsInBox)    then state2 := state2 or 16;

  line := '88' + #9 +
          IntToStr(state) + #9 +
					IntToStr(FPriority) + #9 +
					FTitle + #9 +
          FBoardServer + #9 +
					FBoardId + #9 +
				  FTopicId + #9 +
					IntToStr(FMessageCount) + #9 +
					IntToStr(FGotMessageCount) + #9 +
					IntToStr(FNewMessageCount) + #9 +
					FLastReadDate  + #9 +
					FLastWriteDate + #9	+
					FBoardName + #9 +
					IntToStr(FDatsize) + #9 +
					FWroteName + #9 +
					FWroteEmail + #9 +
					IntToStr(FScrollPosition) + #9 +
					FMemo + #9 +
          #9 +
          #9 +
          #9 +
          FLastModified + #9 +
          IntToStr(state2) + #9;

  // ۑ
  idxpath := FLocalDir + FTopicId + '.i';
  WriteFile(idxpath, line);

  FCritSec.Leave;

end;

{ --------------------------------------------------------
  ֐: StopDownload
  pr  : _E[h~
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.StopDownload;
begin

  FCritSec.Enter;

  if FDownloadThread <> nil then
  begin
    FDownloadThread.Terminate;

    //FMessageList.Clear;

  end;

  FCritSec.Leave;

end;

procedure TTopic.EraseMessageList;
var
  datpath : string;
begin

  FCritSec.Enter;

	datpath := LocalDir + FTopicId + '.d';
  DeleteFile(datpath);
	FMessageList.Clear();
  FMessagecount    := 0;
  FGotmessagecount := 0;
  FNewmessagecount := 0;
  Fdatsize         := 0;

  FCritSec.Leave;

end;

{ --------------------------------------------------------
  ֐: EraseLog
  pr  : O̍폜
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.EraseLog;
var
  idxpath : string;
  datpath : string;
begin

  StopDownload;
  Application.ProcessMessages;

  FCritSec.Enter;

  // 폜
  idxpath := LocalDir + FTopicId + '.i';
	datpath := LocalDir + FTopicId + '.d';
  DeleteFile(idxpath);
  DeleteFile(datpath);

 FMessageList.Clear(); 
//  FMessagecount    := 0; 
  FPriority        := 0; 
  FGotmessagecount := 0; 
  FNewmessagecount := 0; 
  FLastReadDate    := ''; 
  FLastWriteDate   := ''; 
  FMemo            := ''; 
  Fnonotice        := true; 
  Fisgotlog        := false; 
  Fdatsize         := 0;

  FStatusText := 'u' + Ftitle + 'ṽO폜܂';

  FCritSec.Leave;

end;

//  vCx[g֐ 

{ --------------------------------------------------------
  ֐: UpdateBoardInfo
  pr  : {[h̍XV
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.UpdateBoardInfo;
begin

  FCritSec.Enter;

  {
  if gBoardList.BoardListId <> FBoardListId then
  begin

    FBoardListId := gBoardList.BoardListId;
		board := TOnlineBoard(gBoardList.GetBoardByPath(FBoardPath));
  	if board <> nil then
    begin
      FBoardServer := board.Server;
			FBoardName   := board.DisplayName;
			FBoard       := board;
    end else
    begin
			FBoardName   := '';
			FBoard       := nil;
    end;
  end;
  }

  FCritSec.Leave;

end;

procedure TTopic.CheckWriteFolder;
begin

  FCritSec.Enter;

  // tH_Ȃ΍
  if DirectoryExists(FLocalDir) = false then
    CreateFullDir(FLocalDir);

  FCritSec.Leave;

end;

procedure TTopic.CountUp;
begin
  FCritSec.Enter;
  Inc(FReferenceCount);
  FCritSec.Leave;
end;

procedure TTopic.CountDown;
begin
  FCritSec.Enter;
  Dec(FReferenceCount);
  if FReferenceCount <= 0 then
  begin
    gBBSCore.FreeTopic(FTopicPath);
  end;
  FCritSec.Leave;
end;

procedure TTopic.AddNewMessage(msg: TTopicMessage);
var
  msgs : TList;
begin
  FCritSec.Enter;

  msgs := FMessageList.LockList;
  msg.Index := msgs.Count + 1;
  msgs.Add(msg);
  FMessageList.UnlockList;

  FCritSec.Leave;
end;

procedure TTopic.SetOnChangeDownloadState(const Value: TNotifyEvent);
begin
  FCritSec.Enter;
  FOnChangeDownloadState := Value;
  FCritSec.Leave;
end;

procedure TTopic.SetDefaultTopicChangeDownloadStateFunction(
  const Value: TNotifyEvent);
begin
  FCritSec.Enter;
  FDefaultTopicChangeDownloadStateFunction := Value;
  FCritSec.Leave;
end;

procedure TTopic.RaiseChangeDownloadStateEvent;
begin

  if FRaisingChangeDownloadState then exit;

  FCritSec.Enter;

  FRaisingChangeDownloadState := true;

  if Assigned(FOnChangeDownloadState) then
    FOnChangeDownloadState(self)
  else if Assigned(FDefaultTopicChangeDownloadStateFunction) then
    FDefaultTopicChangeDownloadStateFunction(Self);

  FRaisingChangeDownloadState := false;

  FCritSec.Leave;

end;

end.
