unit untTaskThread;

interface

uses
  Classes, SysUtils, Dialogs, Contnrs,
  untTopic, untBoard, IdThreadMgrPool, IdThread;

type

  TTaskMgr = class
  private
    FDownloadBoardThreadMgrPool     : TIdThreadMgrPool;
    FDownloadTopicThreadMgrPool     : TIdThreadMgrPool;
    FAllSubscribedTopicsLoadMgrPool : TIdThreadMgrPool;
    procedure ThreadException(AThread: TIdThread; AException: Exception);
  public
    procedure DownloadBoard(Board : TOnlineBoard);
    procedure DownloadTopic(Topic : TTopic);
    procedure LoadTopic(Topic : TTopic);
    procedure AllSubscribedTopics(Board : TAllSubscribedTopics);
    constructor Create();
    destructor  Destroy; override;
  end; 

implementation

uses
  untTopicDownloadThread, untBoardDownloadThread,
  untAllSubscribedTopicsLoadThread;

{ TTaskMgr }

constructor TTaskMgr.Create;
begin

  FDownloadBoardThreadMgrPool := TIdThreadMgrPool.Create(nil);
  FDownloadBoardThreadMgrPool.ThreadClass := TBoardDownloadThread;

  FDownloadTopicThreadMgrPool := TIdThreadMgrPool.Create(nil);
  FDownloadTopicThreadMgrPool.ThreadClass := TTopicDownloadThread;

  FAllSubscribedTopicsLoadMgrPool := TIdThreadMgrPool.Create(nil);
  FAllSubscribedTopicsLoadMgrPool.ThreadClass := TAllSubscribedTopicsLoadThread;

end;

destructor TTaskMgr.Destroy;
begin
  //FDownloadBoardThreadMgrPool.TerminateThreads;
  //FDownloadTopicThreadMgrPool.TerminateThreads;
  FDownloadBoardThreadMgrPool.Free;
  FDownloadTopicThreadMgrPool.Free;

  inherited;
end;

procedure TTaskMgr.DownloadBoard(Board: TOnlineBoard);
var
  Thread : TBoardDownloadThread;
begin

  Thread := TBoardDownloadThread(FDownloadBoardThreadMgrPool.GetThread);
  Thread.Board := Board;
  Thread.ThreadMgr := FDownloadBoardThreadMgrPool;
  Thread.OnException := self.ThreadException;
  Thread.Priority := tpNormal	;
  Thread.StopMode := smTerminate;
  Thread.Start;

end;

procedure TTaskMgr.DownloadTopic(Topic: TTopic);
var
  Thread : TTopicDownloadThread;
begin

  Thread := TTopicDownloadThread(FDownloadTopicThreadMgrPool.GetThread);
  Thread.Topic := Topic;
  Thread.NoDownload := false;
  Thread.ThreadMgr := FDownloadTopicThreadMgrPool;
  Thread.OnException := self.ThreadException;
  Thread.Priority := tpNormal	;
  Thread.StopMode := smTerminate;
  Thread.Start;

end;

procedure TTaskMgr.LoadTopic(Topic: TTopic);
var
  Thread : TTopicDownloadThread;
begin

  Thread := TTopicDownloadThread(FDownloadTopicThreadMgrPool.GetThread);
  Thread.Topic := Topic;
  Thread.NoDownload := true;
  Thread.ThreadMgr := FDownloadTopicThreadMgrPool;
  Thread.OnException := self.ThreadException;
  Thread.Priority := tpNormal	;
  Thread.StopMode := smTerminate;
  Thread.Start;

end;

procedure TTaskMgr.AllSubscribedTopics(Board: TAllSubscribedTopics);
var
  Thread : TTopicDownloadThread;
begin

  Thread := TTopicDownloadThread(FAllSubscribedTopicsLoadMgrPool.GetThread);
  Thread.ThreadMgr := FDownloadTopicThreadMgrPool;
  Thread.OnException := self.ThreadException;
  Thread.Priority := tpNormal	;
  Thread.StopMode := smTerminate;
  Thread.Start;

end;

procedure TTaskMgr.ThreadException(AThread: TIdThread; AException: Exception);
begin

  ShowMessage(AException.Message);

end;

end.



