unit untTopicBrowserIE;

interface

uses
  Classes, ComCtrls, Controls, OleCtrls, SHDocVw, MSHTML,
  untTopic, SysUtils, untGlobal, untOption, Forms, untHintWindow,
  untTool, ExtCtrls, windows, untBBSCore, BmRegExp, untTopicBrowser,
  HTMLDocumentEvent, StrUtils;

type

  TTopicBrowserIE = class(TTopicBrowser)
  protected
    FDownloadComplete : boolean;
    FOutputTimer    : TTimer;
    FLogLoadedCount : Integer;
    FBrowser        : TWebBrowser;
    FReplaceMode    : integer;
    FReceivedIndex  : integer;
    FSender         : TTopic;
    FWaitInitialize : boolean;
    FStartIndex     : integer;
    FRestoredPos    : boolean;
    FNoScroll       : boolean;
		FHtmlEvent      : THTMLDocumentEventSink;
    procedure BrowserInitialize();
    procedure Browser_NavigateComplete2(Sender: TObject; const pDisp: IDispatch; var URL: OleVariant);
    procedure Browser_StatusTextChange(Sender: TObject; const Text: WideString);
    procedure Browser_BeforeNavigate(Sender: TObject; const pDisp: IDispatch; var URL: OleVariant; var Flags: OleVariant; var TargetFrameName: OleVariant; var PostData: OleVariant; var Headers: OleVariant; var Cancel: WordBool);
    procedure Browser_NewWindow(Sender: TObject; var ppDisp: IDispatch; var Cancel: WordBool);
    procedure BrowserOutput(output : string);
    function  DatToHtml(body: string): string;
    function  ReplaceString(MatchStr: string): string;
    procedure OutputTime(sender : TObject);
    procedure Topic_MessageReceived(sender: TObject); override;
    procedure Topic_ChangeDownloadState(Sender : TObject);override;
    procedure RestoreScrollPosition;
    procedure JumpMessage(msgno : integer); override;
    function  OnContextMenu(Sender: TObject): WordBool;
  public
    procedure   SaveScrollPosition; override;
    procedure   ChangeViewLimit(NewLimit: integer); override;
    procedure SearchText(str: string); override;
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy;    override;
    procedure   CloseTopic; override;
    procedure   OpenTopic(Topic : TTopic); override;
    procedure   Download;   override;
    procedure   SetTextSize(TextSize: Integer);
  end;

implementation

{ TTopicBrowserIE }

constructor TTopicBrowserIE.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FHtmlEvent := nil;

  // uEU̐
  FBrowser := TWebBrowser.Create(self);
  TWinControl(FBrowser).Parent := self;
  FBrowser.Align   := alClient;
  FBrowser.Visible := true;
  FBrowser.OnNavigateComplete2 := Browser_NavigateComplete2;
  FBrowser.OnStatusTextChange  := Browser_StatusTextChange;
  FBrowser.OnBeforeNavigate2   := Browser_BeforeNavigate;
  FBrowser.OnNewWindow2        := Browser_NewWindow;

  FOutputTimer := TTimer.Create(self);
  FOutputTimer.Enabled  := false;
  FOutputTimer.Interval := 1;
  FOutputTimer.OnTimer  := OutputTime;

  BrowserInitialize();

end;

destructor TTopicBrowserIE.Destroy;
begin
  FOutputTimer.Free;
  FBrowser.Free;
  FHtmlEvent.Free; 

  inherited;
end;

procedure TTopicBrowserIE.CloseTopic;
begin

  inherited;

  FHtmlEvent.Free; 
  FOutputTimer.Enabled := false;
  BrowserInitialize();
end;

procedure TTopicBrowserIE.Download;
begin

  FLogLoadedCount := 0;
  
  inherited;
end;

procedure TTopicBrowserIE.ChangeViewLimit(NewLimit: integer);
var
  outputhtml : string;
begin

  Fviewlimit := newlimit;
	if FTopic <> nil then
  begin
    SaveScrollPosition();
    BrowserInitialize();
    outputhtml := StringReplace(gHeaderHtml, '&THREADURL', FTopic.BrowserUrl, [rfReplaceAll]);
    BrowserOutput(outputhtml);
    FTopic.NoNotice := true;
    FTopic.StopDownload;

    FLogLoadedCount := 0;
    if FTopic <> nil then
    begin
      if FLogLoaded = false then FTopic.NoNotice := true;
      FNewMsg := false;
      gBBSCore.LoadTopic(FTopic);
    end;
  end;

end;

// uEȔ
procedure TTopicBrowserIE.Browser_NavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
var
  Disp: DispHTMLDocument;//ISimpleCom;
begin

  if FWaitInitialize = true then
  begin
		FWaitInitialize := false;

    Disp := FBrowser.Document as DispHTMLDocument;
    FHtmlEvent := THTMLDocumentEventSink.Create(Self, Disp, HTMLDocumentEvents2);
    FHtmlEvent.OnContextMenu := OnContextMenu;

  end;

end;

procedure TTopicBrowserIE.Browser_NewWindow(Sender: TObject;
  var ppDisp: IDispatch; var Cancel: WordBool);
begin
  ppDisp := FBrowser;
end;

function TTopicBrowserIE.OnContextMenu(Sender: TObject): WordBool;
var
	Doc: IHtmlDocument2;
	Range: IHTMLTxtRange;
	s: string;
  msgno : integer;
begin
  Result := True;

	Doc := FBrowser.Document as IHtmlDocument2;
	Range := Doc.selection.createRange as IHTMLTxtRange;
	s := StringReplace(Range.text, '@', ' ', [rfReplaceAll]);
	s := ZenkakuToHankaku(Trim(s));
  msgno := StrToIntNeo(s);
  if msgno > 0 then
    if ChangeStatusText('jump://goto/' + IntToStr(msgno)) then
      result := false;
end;

// Xe[^Xo[̕ω
procedure TTopicBrowserIE.Browser_StatusTextChange(Sender: TObject;
  const Text: WideString);
begin

  ChangeStatusText(Text);

end;

// bZ[WM
procedure TTopicBrowserIE.Topic_MessageReceived(sender: TObject);
begin
  inherited;

  if sender <> FTopic then exit;
  FSender := TTopic(sender);

  if FLoading = false then
    FOutputTimer.Enabled := true;
    
end;

// bZ[W
procedure TTopicBrowserIE.OutputTime(sender: TObject);
var
  outputhtml  : string;
  mailname    : string;
  output      : string;
  strBody     : string;
  I           : integer;
  msg         : TTopicMessage;
  html        : string;
  SleepCount  : integer;
  WriteCount  : integer;
  WriteTiming : integer;
  msgs        : TList;
label
  First, Finish;
begin

  msgs := FTopic.MessageList.LockList;

First:

  FOutputTimer.Enabled := false;

  FLoading := true;

  FDownloading:= true;
  FLogLoaded  := true;

  WriteTiming := 10;
  WriteCount  := 0;
  SleepCount  := 0;
  I           := FReceivedIndex;

  while I < msgs.Count do
  begin
  
    Inc(SleepCount);
    Inc(WriteCount);
    if SleepCount > 50 then
    begin
      Application.ProcessMessages;
      SleepCount := 0;
      if WriteCount > WriteTiming then
      begin
        WriteCount := 0;
        BrowserOutput(html);
        html := '';
        
        case WriteTiming of
           0 : WriteTiming := 10;
          10 : WriteTiming := 50;
          50 : WriteTiming := 1000;
        end;
      end;
    end;

    I := FReceivedIndex;
    if I < msgs.Count then
    begin
      if FSender <> FTopic then exit;

      FReceivedIndex := I + 1;
      msg := TTopicMessage(msgs[I]);
      Inc(I);

      if msg.IsNewMessage = false then
      begin
        Inc(FLogLoadedCount);
        if msg.Index > 1 then
          if FViewLimit > 0 then
            if FTopic.GotMessageCount - FLogLoadedCount > FViewLimit then
              goto First;

        outputhtml := gResHtml;
      end else
      begin
        outputhtml  := gNewResHtml;
        FNewMsg     := true;
      end;

      if FStartIndex = 0 then
        if msg.Index > 1 then
          FStartIndex := msg.Index;

      if msg.PostEmail  <> '' then
      begin
        mailname := '<A HREF="mailto:' + msg.PostEmail+ '">' +
                    msg.PostName + '</A>';
      end else
        mailname := msg.PostName;

      outputhtml := StringReplace(outputhtml, '&MAILNAME', '<B>' + mailname + '</B>', [rfReplaceAll]);
      outputhtml := StringReplace(outputhtml, '&NUMBER',   '<a href="menu://at/' + IntToStr(msg.Index) + '">' + IntToStr(msg.Index) + '</a>', [rfReplaceAll]);
      outputhtml := StringReplace(outputhtml, '&DATE',     msg.RestStr, [rfReplaceAll]);
      outputhtml := StringReplace(outputhtml, '&PLAINNUMBER',IntToStr(msg.Index), [rfReplaceAll]);
      outputhtml := StringReplace(outputhtml, '&MAIL', msg.Postemail, [rfReplaceAll]);
      outputhtml := StringReplace(outputhtml, '&NAME', '<B>' + msg.PostName + '</B>', [rfReplaceAll]);
      outputhtml := StringReplace(outputhtml, '&THREADURL', FTopic.BrowserUrl, [rfReplaceAll]);

      strBody := DatToHtml(msg.Body);
      outputhtml := StringReplace(outputhtml, '&MESSAGE',  strBody, [rfReplaceAll]);

      // XN[
      if FRestoredPos = false then
        if msg.IsNewMessage = true then
        begin
          WriteCount := 0;
          BrowserOutput(html);
          html := '';
          RestoreScrollPosition;
        end;

      //this.ImageIndex = 4;

      // 
      output := '<a name="a' + IntToStr(msg.Index) + '"></a>' + outputhtml + #13#10;
      html := html + output;
      //BrowserOutput(output);

      msg.IsNewMessage := false;
    end;
  end;

  BrowserOutput(html);

Finish:

  FLoading := false;

  if FReceivedIndex < msgs.Count then
    FOutputTimer.Enabled := true
  else
    // XN[
    RestoreScrollPosition;

  FTopic.MessageList.UnlockList;

  Topic_ChangeDownloadState(FTopic);

end;


{ --------------------------------------------------------
  ֐: BrowserInitialize
  pr  : uEȔ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowserIE.BrowserInitialize();
var
  I : Integer;
begin

  FOutputTimer.Enabled := false;
  FReceivedIndex  := 0;
  FLogLoadedCount := 0;
  FStartIndex     := 0;
  FRestoredPos    := false;

  FWaitInitialize := true;
  FBrowser.Navigate('about:blank');

  // o܂ő҂
  for I := 0 to 100 do
    if FWaitInitialize = false then
      break
    else
      Application.ProcessMessages;

end;

{ --------------------------------------------------------
  ֐: SaveScrollPosition
  pr  : XN[ʒu̕ۑ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowserIE.SaveScrollPosition;
var
  body : Variant;
  top  : Integer;
  scrollheight : Integer;
  lastspace    : Integer;
begin

  try
    body := (FBrowser.Document as IHTMLDocument2).body;
    top          := body.scrollTop;
    scrollheight := body.scrollHeight;
    //offsetheight := body.offsetHeight;
    lastspace    := scrollheight  -  top;
    FTopic.ScrollPosition := lastspace;
    Topic.SaveIdx();
  except on Exception do ;
  end;

end;

{ --------------------------------------------------------
  ֐: BrowserOutput
  pr  : uEU֏o
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowserIE.BrowserOutput(output: string);
begin

  OleVariant(FBrowser.Document as IHTMLDocument2).write(output);
  
  //Application.ProcessMessages;

end;

{ --------------------------------------------------------
  ֐: SearchText
  pr  : 
    : str - 
  ߂l: Ȃ
  l  : http://hogehoge2001.tripod.co.jp/note-delphi.htmlq؁B
  ------------------------------------------------------ }
procedure TTopicBrowserIE.SearchText(str: string);
var
  textRange: OleVariant;
  b        : Boolean;
  txt      : String;
  forwardP : boolean;
begin

  forwardP := true;

  (* ݂̃ZNVT *)
  textRange := OleVariant(FBrowser.Document as IHTMLDocument2).selection;
  textRange := textRange.createRange();
  textRange.select();
  if forwardP then
  begin  (* O *)
    textRange.moveStart('character');
    textRange.moveEnd('textedit');
    b := textRange.findText(str, 1);
  end
  else begin (* 납*)
    txt := textRange.text;
    if length(txt) <= 0 then
      textRange := OleVariant(FBrowser.Document as IHTMLDocument2).body.createTextRange;
    textRange.moveEnd('word', -1);
    b := textRange.findText(str, -1);
  end;
  (* [ጩĂ` *)
  if b then
  begin
    textRange.select();
    OleVariant(FBrowser.Document as IHTMLDocument2).body.scrollTop
      := OleVariant(FBrowser.Document as IHTMLDocument2).body.scrollTop
       + textRange.offsetTop - FBrowser.Height div 2;
  end;
end;



// XN[
procedure TTopicBrowserIE.RestoreScrollPosition;
var
  body : OleVariant;
  scrollheight : Integer;
  top          : Integer;
begin
  inherited;

  if FRestoredPos = true then exit;
  FRestoredPos := true;

  if FNoScroll then
  begin
    FNoScroll := false;
    exit;
  end;

  Application.ProcessMessages;

  body := (FBrowser.Document as IHTMLDocument2).body;
  //if body <> nil then
  //begin
    scrollheight := body.scrollHeight;
    top := scrollheight  -  FTopic.ScrollPosition;
    body.scrollTop := top;
  //end;

end;

procedure TTopicBrowserIE.Browser_BeforeNavigate(Sender: TObject;
  const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
  Headers: OleVariant; var Cancel: WordBool);
begin

  if URL = 'about:blank' then exit;

  Cancel := true;
  RaiseNavigateUrlEvent(URL);  

end;

procedure TTopicBrowserIE.JumpMessage(msgno: integer);
begin
  inherited;

  if msgno < FStartIndex then
  begin

    //FTopic.ScrollPosition := -1;
    FNoScroll := true;
    ChangeViewLimit(FTopic.GotMessageCount - msgno + 1);

  end else
  begin

    OleVariant(FBrowser.Document).body.scrollTop
	  	:= OleVariant(FBrowser.Document).anchors.item('a' + IntToStr(msgno) ).offsetTop;
  end;

end;

{ --------------------------------------------------------
  ֐: DatToHtml
  pr  : >>1 ̕ϊ
    : body - Ώۂ̕
  ߂l: Ȃ
  l  : ϊ̕
  ------------------------------------------------------ }
function TTopicBrowserIE.DatToHtml(body: string): string;
var
  AWK : TAwkStr;
begin

  body := EraseATag(body);
  AWK := TAwkStr.Create(nil);
  AWK.OnReplaceString := ReplaceString;

  // XԍɃN\
  FReplaceMode := 1;
  AWK.RegExp := '(&gt;|)+[0-9O-X]+([-|[][0-9O-X]+)?';
  AWK.GSub('', body);

  // URLɃN\
  FReplaceMode := 2; 
  AWK.RegExp := 'h*ttp://[a-zA-Z_/%@\-~\.0-9&=%\?#;:\,\+]+';
  AWK.GSub('', body);

  AWK.Free;
  result := body;

end;

function TTopicBrowserIE.ReplaceString(MatchStr : string) : string;
var
  strNum : string;
  I      : integer;
  isnum  : char;
  check  : string;
begin

  case FReplaceMode of

  1:
    begin

    check := ZenkakuToHankaku(MatchStr);
    for i := Length(check)  downto 1 do
    begin
      isnum := check[i];
      if (isnum in ['0'..'9']) or (isnum = '-') then 
        strNum := isnum + strNum;
    end;

    result := '<A HREF="jump://goto/' + strNum + '">' + MatchStr + '</A>';

    end;
  2:
    begin

    check := Matchstr;
    if Copy(check, 1, 1) <> 'h' then
      check := 'h' + check;

    if Pos('#', check) <> 0 then
      result := '<a href="' + AnsiReplaceText(check, '#', '[%23]') + '">' + MatchStr + '</a>'
    else
      result := '<a href="' + check + '">' + MatchStr + '</a>';

    end;
  end;

end;

procedure TTopicBrowserIE.Topic_ChangeDownloadState(Sender: TObject);
begin
  inherited;

  if FTopic = nil then exit;
  if FTopic <> sender then exit;

  Case FTopic.DownloadState of
    dsNone: FDownloadComplete := true;
    else    FDownloadComplete := false;
  end;
end;

procedure TTopicBrowserIE.OpenTopic(Topic: TTopic);
var
  outputhtml : string;
begin
  inherited;

  if Topic <> nil then
  begin
    outputhtml := StringReplace(gHeaderHtml, '&THREADURL', Topic.BrowserUrl, [rfReplaceAll]);
    BrowserOutput(outputhtml);
  end;
end;

procedure TTopicBrowserIE.SetTextSize(TextSize : Integer); 
var
  size, rc: OleVariant; 
begin 
  if (TextSize < 0) or (TextSize > 4) then 
    Exit; 

  if Assigned(FBrowser.Document) then 
  begin 
    size := TextSize; 
    FBrowser.ExecWB(OLECMDID_ZOOM , OLECMDEXECOPT_DONTPROMPTUSER, size, rc); 
  end; 
end;

end.

