Gtk.init

module Kz
  DEFAULT_LOAD_PATH = $LOAD_PATH.dup

  class << self
    def reload(kz)
      if ENABLE
        $LOAD_PATH.clear
        $LOAD_PATH.concat(DEFAULT_LOAD_PATH)
        kz.ext_reload
      end
    rescue Exception
      print_error($!)
    end

    def pop_statusbar(kz, id, timeout)
      Gtk.timeout_add(timeout) do
        kz.statusbar.pop(id)
        false
      end
    end

    def setup(kz)
      kz.ext_setup
    rescue Exception
      print_error($!)
    end
  end

  class Window
    def ext_setup
      Actions.init_actions(self)
    end

    def ext_reload
      Actions.reload_actions(self)
    end
  end
end

require "kz/actions"
