/* -*- c-file-style: "ruby"; indent-tabs-mode: nil -*- */

#include "kz-rb-ext.h"

#define _SELF(obj) RVAL2DL(obj)

static VALUE
rb_kz_dl_initialize(int argc, VALUE *argv, VALUE self)
{
    VALUE uri, filename;
    KzDownloader *dl;

    rb_scan_args(argc, argv, "11", &uri, &filename);

    if (NIL_P(filename)) {
        dl = kz_downloader_new(RVAL2CSTR(uri));
    } else {
        dl = kz_downloader_new_with_filename(RVAL2CSTR(uri),
                                             RVAL2CSTR(filename));
    }
    G_INITIALIZE(self, dl);

    return Qnil;
}

static VALUE
rb_kz_dl_cancel(VALUE self)
{
    kz_downloader_cancel(_SELF(self));
    return Qnil;
}

static VALUE
rb_kz_dl_to_file(VALUE self)
{
    return CBOOL2RVAL(kz_downloader_to_file(_SELF(self)));
}

static VALUE
rb_kz_dl_get_string(VALUE self)
{
    return CSTR2RVAL(kz_downloader_get_string(_SELF(self)));
}

static VALUE
rb_kz_dl_get_percent(VALUE self)
{
    return INT2NUM(kz_downloader_get_percent(_SELF(self)));
}

static VALUE
rb_kz_dl_get_current_progress(VALUE self)
{
    return INT2NUM(kz_downloader_get_current_progress(_SELF(self)));
}

static VALUE
rb_kz_dl_get_total_progress(VALUE self)
{
    return INT2NUM(kz_downloader_get_total_progress(_SELF(self)));
}


void
Init_kz_rb_downloader(VALUE mKz)
{
    VALUE cKzDownloader;

    cKzDownloader = G_DEF_CLASS(KZ_TYPE_DOWNLOADER, "Downloader", mKz);

    rb_define_method(cKzDownloader, "initialize", rb_kz_dl_initialize, -1);
    rb_define_method(cKzDownloader, "cancel", rb_kz_dl_cancel, 0);
    rb_define_method(cKzDownloader, "to_file", rb_kz_dl_to_file, 0);
    rb_define_method(cKzDownloader, "string", rb_kz_dl_get_string, 0);
    rb_define_method(cKzDownloader, "percent", rb_kz_dl_get_percent, 0);
    rb_define_method(cKzDownloader, "current_progress",
                     rb_kz_dl_get_current_progress, 0);
    rb_define_method(cKzDownloader, "total_progress",
                     rb_kz_dl_get_total_progress, 0);

    G_DEF_SETTERS(cKzDownloader);
}
