/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-edit.h,v 1.2 2003/10/27 18:41:23 makeinu Exp $
 */

#ifndef __KZ_BOOKMARK_EDIT_H__
#define __KZ_BOOKMARK_EDIT_H__

#include <gtk/gtk.h>
#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_EDIT			(kz_bookmark_edit_get_type ())
#define KZ_BOOKMARK_EDIT(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_EDIT, KzBookmarkEdit))
#define KZ_BOOKMARK_EDIT_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_BOOKMARK_EDIT, KzBookmarkEditClass))
#define KZ_IS_BOOKMARK_EDIT(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_EDIT))
#define KZ_IS_BOOKMARK_EDIT_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_BOOKMARK_EDIT))
#define KZ_BOOKMARK_EDIT_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_BOOKMARK_EDIT, KzBookmarkEditClass))

typedef struct _KzBookmarkEdit		KzBookmarkEdit;
typedef struct _KzBookmarkEditClass	KzBookmarkEditClass;
typedef struct _KzBookmarkEditPriv	KzBookmarkEditPriv;

struct _KzBookmarkEdit
{
	GtkVBox   parent;

	GtkWidget  *title_entry;
	GtkWidget  *uri_entry;
	GtkWidget  *memo_textview;

	gboolean    changing; /* FIXME: use private struct */

	KzBookmark *bookmark;
};

struct _KzBookmarkEditClass
{
	GtkWindowClass parent_class;
};

GtkType    kz_bookmark_edit_get_type     (void);
GtkWidget *kz_bookmark_edit_new          (void);
void       kz_bookmark_edit_set          (KzBookmarkEdit *edit,
					  KzBookmark     *bookmark);
void       kz_bookmark_edit_clear        (KzBookmarkEdit *edit);

G_END_DECLS

#endif /* __KZ_BOOKMARK_EDIT_H__ */
