
/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-sidebar.h"

#include <gtk/gtktreeview.h>
#include <gtk/gtktreestore.h>

#include "kz-bookmarklist.h"

#ifndef __KZ_META_TREE_H__
#define __KZ_META_TREE_H__

#define KZ_TYPE_META_TREE		(kz_meta_tree_get_type ())
#define KZ_META_TREE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_META_TREE, KzMETATree))
#define KZ_META_TREE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_META_TREE, KzMETATreeClass))
#define KZ_IS_META_TREE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_META_TREE))
#define KZ_IS_META_TREE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_META_TREE))
#define KZ_META_TREE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_META_TREE, KzMETATreeClass))

typedef struct _KzMETATree	KzMETATree;
typedef struct _KzMETATreeClass	KzMETATreeClass;
typedef struct _KzMETATreePriv	KzMETATreePriv;
typedef struct _KzMETATreeItem	KzMETATreeItem;

struct _KzMETATree
{
	GtkVBox parent;

	KzSidebar    *sidebar;

	GtkTreeView  *tree_view;
	GtkTreeStore *store;

	KzBookmark   *bookmarklist;
};

struct _KzMETATreeClass
{
	GtkVBoxClass parent_class;
};

KzSidebarEntry   *kz_meta_tree_get_entry(gint idx);

GtkType	          kz_meta_tree_get_type           (void);
GtkWidget        *kz_meta_tree_new                (KzSidebar *sidebar);

#endif /* __KZ_META_TREE_H__ */
