/*
 *  Copyright (C) 2006 George Staikos <staikos@kde.org>
 *  Copyright (C) 2006, 2008, 2009 Apple Inc. All rights reserved.
 *  Copyright (C) 2007-2009 Torch Mobile, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef WTF_UNICODE_H
#define WTF_UNICODE_H

#include <wtf/Assertions.h>

#include <QChar>
#include <QString>

// ugly hack to make UChar compatible with JSChar in API/JSStringRef.h
typedef uint16_t UChar;
typedef uint32_t UChar32;

namespace WTF {
namespace Unicode {

inline bool isSeparatorSpace(UChar32 c)
{
    return QChar::category(c) == QChar::Separator_Space;
}

}
}

COMPILE_ASSERT(sizeof(UChar) == 2, UCharIsTwoBytes);

#endif // WTF_UNICODE_H
