/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Copyright (C) 2016 Ivailo Monev
**
** This file is part of the QtCore module of the Katie Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
**
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QLOCALE_DATA_P_H
#define QLOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Katie API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

QT_BEGIN_NAMESPACE

/*
    This part of the file was generated from Common Locale Data Repository v38

    http://www.unicode.org/cldr/

    Do not change it, instead edit CLDR data and regenerate this file using
    genlocale.py.
*/

// GENERATED PART STARTS HERE
static const struct languageTblData {
    const QLocale::Language language;
    const char* name;
    const char* code;
} languageTbl[] = {
    { QLocale::Language::AnyLanguage, "Default\0", nullptr },
    { QLocale::Language::C, "C\0", "C\0" },
    { QLocale::Language::Abkhazian, "Abkhazian\0", "ab\0" },
    { QLocale::Language::Achinese, "Achinese\0", "ace\0" },
    { QLocale::Language::Acoli, "Acoli\0", "ach\0" },
    { QLocale::Language::Adangme, "Adangme\0", "ada\0" },
    { QLocale::Language::Adyghe, "Adyghe\0", "ady\0" },
    { QLocale::Language::Afar, "Afar\0", "aa\0" },
    { QLocale::Language::Afrihili, "Afrihili\0", "afh\0" },
    { QLocale::Language::Afrikaans, "Afrikaans\0", "af\0" },
    { QLocale::Language::Aghem, "Aghem\0", "agq\0" },
    { QLocale::Language::Ainu, "Ainu\0", "ain\0" },
    { QLocale::Language::Akan, "Akan\0", "ak\0" },
    { QLocale::Language::Akkadian, "Akkadian\0", "akk\0" },
    { QLocale::Language::Akoose, "Akoose\0", "bss\0" },
    { QLocale::Language::Alabama, "Alabama\0", "akz\0" },
    { QLocale::Language::Albanian, "Albanian\0", "sq\0" },
    { QLocale::Language::Aleut, "Aleut\0", "ale\0" },
    { QLocale::Language::AlgerianArabic, "Algerian Arabic\0", "arq\0" },
    { QLocale::Language::AmericanEnglish, "American English\0", "en_US\0" },
    { QLocale::Language::AmericanSignLanguage, "American Sign Language\0", "ase\0" },
    { QLocale::Language::Amharic, "Amharic\0", "am\0" },
    { QLocale::Language::AncientEgyptian, "Ancient Egyptian\0", "egy\0" },
    { QLocale::Language::AncientGreek, "Ancient Greek\0", "grc\0" },
    { QLocale::Language::Angika, "Angika\0", "anp\0" },
    { QLocale::Language::AoNaga, "Ao Naga\0", "njo\0" },
    { QLocale::Language::Arabic, "Arabic\0", "ar\0" },
    { QLocale::Language::ArabicNajdi, "Arabic, Najdi\0", "ars\0" },
    { QLocale::Language::Aragonese, "Aragonese\0", "an\0" },
    { QLocale::Language::Aramaic, "Aramaic\0", "arc\0" },
    { QLocale::Language::Araona, "Araona\0", "aro\0" },
    { QLocale::Language::Arapaho, "Arapaho\0", "arp\0" },
    { QLocale::Language::Arawak, "Arawak\0", "arw\0" },
    { QLocale::Language::Armenian, "Armenian\0", "hy\0" },
    { QLocale::Language::Aromanian, "Aromanian\0", "rup\0" },
    { QLocale::Language::Arpitan, "Arpitan\0", "frp\0" },
    { QLocale::Language::Assamese, "Assamese\0", "as\0" },
    { QLocale::Language::Asturian, "Asturian\0", "ast\0" },
    { QLocale::Language::Asu, "Asu\0", "asa\0" },
    { QLocale::Language::Atikamekw, "Atikamekw\0", "atj\0" },
    { QLocale::Language::Atsam, "Atsam\0", "cch\0" },
    { QLocale::Language::AustralianEnglish, "Australian English\0", "en_AU\0" },
    { QLocale::Language::AustrianGerman, "Austrian German\0", "de_AT\0" },
    { QLocale::Language::Avaric, "Avaric\0", "av\0" },
    { QLocale::Language::Avestan, "Avestan\0", "ae\0" },
    { QLocale::Language::Awadhi, "Awadhi\0", "awa\0" },
    { QLocale::Language::Aymara, "Aymara\0", "ay\0" },
    { QLocale::Language::Azerbaijani, "Azerbaijani\0", "az\0" },
    { QLocale::Language::Badaga, "Badaga\0", "bfq\0" },
    { QLocale::Language::Bafia, "Bafia\0", "ksf\0" },
    { QLocale::Language::Bafut, "Bafut\0", "bfd\0" },
    { QLocale::Language::Bakhtiari, "Bakhtiari\0", "bqi\0" },
    { QLocale::Language::Balinese, "Balinese\0", "ban\0" },
    { QLocale::Language::Baluchi, "Baluchi\0", "bal\0" },
    { QLocale::Language::Bambara, "Bambara\0", "bm\0" },
    { QLocale::Language::Bamun, "Bamun\0", "bax\0" },
    { QLocale::Language::Bangla, "Bangla\0", "bn\0" },
    { QLocale::Language::Banjar, "Banjar\0", "bjn\0" },
    { QLocale::Language::Basaa, "Basaa\0", "bas\0" },
    { QLocale::Language::Bashkir, "Bashkir\0", "ba\0" },
    { QLocale::Language::Basque, "Basque\0", "eu\0" },
    { QLocale::Language::BatakToba, "Batak Toba\0", "bbc\0" },
    { QLocale::Language::Bavarian, "Bavarian\0", "bar\0" },
    { QLocale::Language::Beja, "Beja\0", "bej\0" },
    { QLocale::Language::Belarusian, "Belarusian\0", "be\0" },
    { QLocale::Language::Bemba, "Bemba\0", "bem\0" },
    { QLocale::Language::Bena, "Bena\0", "bez\0" },
    { QLocale::Language::Betawi, "Betawi\0", "bew\0" },
    { QLocale::Language::Bhojpuri, "Bhojpuri\0", "bho\0" },
    { QLocale::Language::Bikol, "Bikol\0", "bik\0" },
    { QLocale::Language::Bini, "Bini\0", "bin\0" },
    { QLocale::Language::Bishnupriya, "Bishnupriya\0", "bpy\0" },
    { QLocale::Language::Bislama, "Bislama\0", "bi\0" },
    { QLocale::Language::Blin, "Blin\0", "byn\0" },
    { QLocale::Language::Blissymbols, "Blissymbols\0", "zbl\0" },
    { QLocale::Language::Bodo, "Bodo\0", "brx\0" },
    { QLocale::Language::Bosnian, "Bosnian\0", "bs\0" },
    { QLocale::Language::Brahui, "Brahui\0", "brh\0" },
    { QLocale::Language::Braj, "Braj\0", "bra\0" },
    { QLocale::Language::BrazilianPortuguese, "Brazilian Portuguese\0", "pt_BR\0" },
    { QLocale::Language::Breton, "Breton\0", "br\0" },
    { QLocale::Language::BritishEnglish, "British English\0", "en_GB\0" },
    { QLocale::Language::Buginese, "Buginese\0", "bug\0" },
    { QLocale::Language::Bulgarian, "Bulgarian\0", "bg\0" },
    { QLocale::Language::Bulu, "Bulu\0", "bum\0" },
    { QLocale::Language::Buriat, "Buriat\0", "bua\0" },
    { QLocale::Language::Burmese, "Burmese\0", "my\0" },
    { QLocale::Language::Caddo, "Caddo\0", "cad\0" },
    { QLocale::Language::CajunFrench, "Cajun French\0", "frc\0" },
    { QLocale::Language::CanadianEnglish, "Canadian English\0", "en_CA\0" },
    { QLocale::Language::CanadianFrench, "Canadian French\0", "fr_CA\0" },
    { QLocale::Language::Cantonese, "Cantonese\0", "yue\0" },
    { QLocale::Language::Capiznon, "Capiznon\0", "cps\0" },
    { QLocale::Language::Carib, "Carib\0", "car\0" },
    { QLocale::Language::CarolinaAlgonquian, "Carolina Algonquian\0", "crr\0" },
    { QLocale::Language::Catalan, "Catalan\0", "ca\0" },
    { QLocale::Language::Cayuga, "Cayuga\0", "cay\0" },
    { QLocale::Language::Cebuano, "Cebuano\0", "ceb\0" },
    { QLocale::Language::CentralAtlasTamazight, "Central Atlas Tamazight\0", "tzm\0" },
    { QLocale::Language::CentralDusun, "Central Dusun\0", "dtp\0" },
    { QLocale::Language::CentralKurdish, "Central Kurdish\0", "ckb\0" },
    { QLocale::Language::CentralOjibwa, "Central Ojibwa\0", "ojc\0" },
    { QLocale::Language::CentralYupik, "Central Yupik\0", "esu\0" },
    { QLocale::Language::ChadianArabic, "Chadian Arabic\0", "shu\0" },
    { QLocale::Language::Chagatai, "Chagatai\0", "chg\0" },
    { QLocale::Language::Chakma, "Chakma\0", "ccp\0" },
    { QLocale::Language::Chamorro, "Chamorro\0", "ch\0" },
    { QLocale::Language::Chechen, "Chechen\0", "ce\0" },
    { QLocale::Language::Cherokee, "Cherokee\0", "chr\0" },
    { QLocale::Language::Cheyenne, "Cheyenne\0", "chy\0" },
    { QLocale::Language::Chibcha, "Chibcha\0", "chb\0" },
    { QLocale::Language::Chickasaw, "Chickasaw\0", "cic\0" },
    { QLocale::Language::Chiga, "Chiga\0", "cgg\0" },
    { QLocale::Language::Chilcotin, "Chilcotin\0", "clc\0" },
    { QLocale::Language::ChimborazoHighlandQuichua, "Chimborazo Highland Quichua\0", "qug\0" },
    { QLocale::Language::Chinese, "Chinese\0", "zh\0" },
    { QLocale::Language::ChinookJargon, "Chinook Jargon\0", "chn\0" },
    { QLocale::Language::Chipewyan, "Chipewyan\0", "chp\0" },
    { QLocale::Language::Choctaw, "Choctaw\0", "cho\0" },
    { QLocale::Language::ChurchSlavic, "Church Slavic\0", "cu\0" },
    { QLocale::Language::Chuukese, "Chuukese\0", "chk\0" },
    { QLocale::Language::Chuvash, "Chuvash\0", "cv\0" },
    { QLocale::Language::ClassicalNewari, "Classical Newari\0", "nwc\0" },
    { QLocale::Language::ClassicalSyriac, "Classical Syriac\0", "syc\0" },
    { QLocale::Language::Colognian, "Colognian\0", "ksh\0" },
    { QLocale::Language::Comorian, "Comorian\0", "swb\0" },
    { QLocale::Language::CongoSwahili, "Congo Swahili\0", "sw_CD\0" },
    { QLocale::Language::Coptic, "Coptic\0", "cop\0" },
    { QLocale::Language::Cornish, "Cornish\0", "kw\0" },
    { QLocale::Language::Corsican, "Corsican\0", "co\0" },
    { QLocale::Language::Cree, "Cree\0", "cr\0" },
    { QLocale::Language::CrimeanTatar, "Crimean Tatar\0", "crh\0" },
    { QLocale::Language::Croatian, "Croatian\0", "hr\0" },
    { QLocale::Language::Czech, "Czech\0", "cs\0" },
    { QLocale::Language::Dakota, "Dakota\0", "dak\0" },
    { QLocale::Language::Danish, "Danish\0", "da\0" },
    { QLocale::Language::Dargwa, "Dargwa\0", "dar\0" },
    { QLocale::Language::Dari, "Dari\0", "fa_AF\0" },
    { QLocale::Language::Dazaga, "Dazaga\0", "dzg\0" },
    { QLocale::Language::Delaware, "Delaware\0", "del\0" },
    { QLocale::Language::Dinka, "Dinka\0", "din\0" },
    { QLocale::Language::Divehi, "Divehi\0", "dv\0" },
    { QLocale::Language::Dogri, "Dogri\0", "doi\0" },
    { QLocale::Language::Dogrib, "Dogrib\0", "dgr\0" },
    { QLocale::Language::Duala, "Duala\0", "dua\0" },
    { QLocale::Language::Dutch, "Dutch\0", "nl\0" },
    { QLocale::Language::Dyula, "Dyula\0", "dyu\0" },
    { QLocale::Language::Dzongkha, "Dzongkha\0", "dz\0" },
    { QLocale::Language::EasternCanadianInuktitut, "Eastern Canadian Inuktitut\0", "ike\0" },
    { QLocale::Language::EasternFrisian, "Eastern Frisian\0", "frs\0" },
    { QLocale::Language::EasternOjibwa, "Eastern Ojibwa\0", "ojg\0" },
    { QLocale::Language::Efik, "Efik\0", "efi\0" },
    { QLocale::Language::EgyptianArabic, "Egyptian Arabic\0", "arz\0" },
    { QLocale::Language::Ekajuk, "Ekajuk\0", "eka\0" },
    { QLocale::Language::Elamite, "Elamite\0", "elx\0" },
    { QLocale::Language::Embu, "Embu\0", "ebu\0" },
    { QLocale::Language::Emilian, "Emilian\0", "egl\0" },
    { QLocale::Language::English, "English\0", "en\0" },
    { QLocale::Language::Erzya, "Erzya\0", "myv\0" },
    { QLocale::Language::Esperanto, "Esperanto\0", "eo\0" },
    { QLocale::Language::Estonian, "Estonian\0", "et\0" },
    { QLocale::Language::EuropeanPortuguese, "European Portuguese\0", "pt_PT\0" },
    { QLocale::Language::EuropeanSpanish, "European Spanish\0", "es_ES\0" },
    { QLocale::Language::Ewe, "Ewe\0", "ee\0" },
    { QLocale::Language::Ewondo, "Ewondo\0", "ewo\0" },
    { QLocale::Language::Extremaduran, "Extremaduran\0", "ext\0" },
    { QLocale::Language::Fang, "Fang\0", "fan\0" },
    { QLocale::Language::Fanti, "Fanti\0", "fat\0" },
    { QLocale::Language::Faroese, "Faroese\0", "fo\0" },
    { QLocale::Language::FijiHindi, "Fiji Hindi\0", "hif\0" },
    { QLocale::Language::Fijian, "Fijian\0", "fj\0" },
    { QLocale::Language::Filipino, "Filipino\0", "fil\0" },
    { QLocale::Language::Finnish, "Finnish\0", "fi\0" },
    { QLocale::Language::Flemish, "Flemish\0", "nl_BE\0" },
    { QLocale::Language::Fon, "Fon\0", "fon\0" },
    { QLocale::Language::Frafra, "Frafra\0", "gur\0" },
    { QLocale::Language::French, "French\0", "fr\0" },
    { QLocale::Language::Friulian, "Friulian\0", "fur\0" },
    { QLocale::Language::Fulah, "Fulah\0", "ff\0" },
    { QLocale::Language::Ga, "Ga\0", "gaa\0" },
    { QLocale::Language::Gagauz, "Gagauz\0", "gag\0" },
    { QLocale::Language::Galician, "Galician\0", "gl\0" },
    { QLocale::Language::GanChinese, "Gan Chinese\0", "gan\0" },
    { QLocale::Language::Ganda, "Ganda\0", "lg\0" },
    { QLocale::Language::Gayo, "Gayo\0", "gay\0" },
    { QLocale::Language::Gbaya, "Gbaya\0", "gba\0" },
    { QLocale::Language::Geez, "Geez\0", "gez\0" },
    { QLocale::Language::Georgian, "Georgian\0", "ka\0" },
    { QLocale::Language::German, "German\0", "de\0" },
    { QLocale::Language::GhegAlbanian, "Gheg Albanian\0", "aln\0" },
    { QLocale::Language::Ghomala, "Ghomala\0", "bbj\0" },
    { QLocale::Language::Gilaki, "Gilaki\0", "glk\0" },
    { QLocale::Language::Gilbertese, "Gilbertese\0", "gil\0" },
    { QLocale::Language::GoanKonkani, "Goan Konkani\0", "gom\0" },
    { QLocale::Language::Gondi, "Gondi\0", "gon\0" },
    { QLocale::Language::Gorontalo, "Gorontalo\0", "gor\0" },
    { QLocale::Language::Gothic, "Gothic\0", "got\0" },
    { QLocale::Language::Grebo, "Grebo\0", "grb\0" },
    { QLocale::Language::Greek, "Greek\0", "el\0" },
    { QLocale::Language::Guarani, "Guarani\0", "gn\0" },
    { QLocale::Language::Gujarati, "Gujarati\0", "gu\0" },
    { QLocale::Language::Gusii, "Gusii\0", "guz\0" },
    { QLocale::Language::Gwichin, "Gwichʼin\0", "gwi\0" },
    { QLocale::Language::Haida, "Haida\0", "hai\0" },
    { QLocale::Language::HaitianCreole, "Haitian Creole\0", "ht\0" },
    { QLocale::Language::HakkaChinese, "Hakka Chinese\0", "hak\0" },
    { QLocale::Language::Halkomelem, "Halkomelem\0", "hur\0" },
    { QLocale::Language::Hausa, "Hausa\0", "ha\0" },
    { QLocale::Language::Hawaiian, "Hawaiian\0", "haw\0" },
    { QLocale::Language::Hebrew, "Hebrew\0", "he\0" },
    { QLocale::Language::Herero, "Herero\0", "hz\0" },
    { QLocale::Language::Hiligaynon, "Hiligaynon\0", "hil\0" },
    { QLocale::Language::Hindi, "Hindi\0", "hi\0" },
    { QLocale::Language::HiriMotu, "Hiri Motu\0", "ho\0" },
    { QLocale::Language::Hittite, "Hittite\0", "hit\0" },
    { QLocale::Language::Hmong, "Hmong\0", "hmn\0" },
    { QLocale::Language::HmongNjua, "Hmong Njua\0", "hnj\0" },
    { QLocale::Language::Hungarian, "Hungarian\0", "hu\0" },
    { QLocale::Language::Hupa, "Hupa\0", "hup\0" },
    { QLocale::Language::Iban, "Iban\0", "iba\0" },
    { QLocale::Language::Ibibio, "Ibibio\0", "ibb\0" },
    { QLocale::Language::Icelandic, "Icelandic\0", "is\0" },
    { QLocale::Language::Ido, "Ido\0", "io\0" },
    { QLocale::Language::Igbo, "Igbo\0", "ig\0" },
    { QLocale::Language::Iloko, "Iloko\0", "ilo\0" },
    { QLocale::Language::InariSami, "Inari Sami\0", "smn\0" },
    { QLocale::Language::Indonesian, "Indonesian\0", "id\0" },
    { QLocale::Language::Ingrian, "Ingrian\0", "izh\0" },
    { QLocale::Language::Ingush, "Ingush\0", "inh\0" },
    { QLocale::Language::Innuaimun, "Innu-aimun\0", "moe\0" },
    { QLocale::Language::Interlingua, "Interlingua\0", "ia\0" },
    { QLocale::Language::Interlingue, "Interlingue\0", "ie\0" },
    { QLocale::Language::Inuktitut, "Inuktitut\0", "iu\0" },
    { QLocale::Language::Inupiaq, "Inupiaq\0", "ik\0" },
    { QLocale::Language::Irish, "Irish\0", "ga\0" },
    { QLocale::Language::Italian, "Italian\0", "it\0" },
    { QLocale::Language::JamaicanCreoleEnglish, "Jamaican Creole English\0", "jam\0" },
    { QLocale::Language::Japanese, "Japanese\0", "ja\0" },
    { QLocale::Language::Javanese, "Javanese\0", "jv\0" },
    { QLocale::Language::Jju, "Jju\0", "kaj\0" },
    { QLocale::Language::JolaFonyi, "Jola-Fonyi\0", "dyo\0" },
    { QLocale::Language::JudeoArabic, "Judeo-Arabic\0", "jrb\0" },
    { QLocale::Language::JudeoPersian, "Judeo-Persian\0", "jpr\0" },
    { QLocale::Language::Jutish, "Jutish\0", "jut\0" },
    { QLocale::Language::Kabardian, "Kabardian\0", "kbd\0" },
    { QLocale::Language::Kabuverdianu, "Kabuverdianu\0", "kea\0" },
    { QLocale::Language::Kabyle, "Kabyle\0", "kab\0" },
    { QLocale::Language::Kachin, "Kachin\0", "kac\0" },
    { QLocale::Language::Kaingang, "Kaingang\0", "kgp\0" },
    { QLocale::Language::Kako, "Kako\0", "kkj\0" },
    { QLocale::Language::Kalaallisut, "Kalaallisut\0", "kl\0" },
    { QLocale::Language::Kalenjin, "Kalenjin\0", "kln\0" },
    { QLocale::Language::Kalmyk, "Kalmyk\0", "xal\0" },
    { QLocale::Language::Kamba, "Kamba\0", "kam\0" },
    { QLocale::Language::Kanembu, "Kanembu\0", "kbl\0" },
    { QLocale::Language::Kannada, "Kannada\0", "kn\0" },
    { QLocale::Language::Kanuri, "Kanuri\0", "kr\0" },
    { QLocale::Language::KaraKalpak, "Kara-Kalpak\0", "kaa\0" },
    { QLocale::Language::KarachayBalkar, "Karachay-Balkar\0", "krc\0" },
    { QLocale::Language::Karelian, "Karelian\0", "krl\0" },
    { QLocale::Language::Kashmiri, "Kashmiri\0", "ks\0" },
    { QLocale::Language::Kashubian, "Kashubian\0", "csb\0" },
    { QLocale::Language::Kawi, "Kawi\0", "kaw\0" },
    { QLocale::Language::Kazakh, "Kazakh\0", "kk\0" },
    { QLocale::Language::Kenyang, "Kenyang\0", "ken\0" },
    { QLocale::Language::Khasi, "Khasi\0", "kha\0" },
    { QLocale::Language::Khmer, "Khmer\0", "km\0" },
    { QLocale::Language::Khotanese, "Khotanese\0", "kho\0" },
    { QLocale::Language::Khowar, "Khowar\0", "khw\0" },
    { QLocale::Language::Kiche, "Kʼicheʼ\0", "quc\0" },
    { QLocale::Language::Kikuyu, "Kikuyu\0", "ki\0" },
    { QLocale::Language::Kimbundu, "Kimbundu\0", "kmb\0" },
    { QLocale::Language::Kinaraya, "Kinaray-a\0", "krj\0" },
    { QLocale::Language::Kinyarwanda, "Kinyarwanda\0", "rw\0" },
    { QLocale::Language::Kirghiz, "Kirghiz\0", "ky\0" },
    { QLocale::Language::Kirmanjki, "Kirmanjki\0", "kiu\0" },
    { QLocale::Language::Klingon, "Klingon\0", "tlh\0" },
    { QLocale::Language::Kom, "Kom\0", "bkm\0" },
    { QLocale::Language::Komi, "Komi\0", "kv\0" },
    { QLocale::Language::KomiPermyak, "Komi-Permyak\0", "koi\0" },
    { QLocale::Language::Kongo, "Kongo\0", "kg\0" },
    { QLocale::Language::Konkani, "Konkani\0", "kok\0" },
    { QLocale::Language::Korean, "Korean\0", "ko\0" },
    { QLocale::Language::Koro, "Koro\0", "kfo\0" },
    { QLocale::Language::Kosraean, "Kosraean\0", "kos\0" },
    { QLocale::Language::Kotava, "Kotava\0", "avk\0" },
    { QLocale::Language::KoyraChiini, "Koyra Chiini\0", "khq\0" },
    { QLocale::Language::KoyraboroSenni, "Koyraboro Senni\0", "ses\0" },
    { QLocale::Language::Kpelle, "Kpelle\0", "kpe\0" },
    { QLocale::Language::Krio, "Krio\0", "kri\0" },
    { QLocale::Language::Kuanyama, "Kuanyama\0", "kj\0" },
    { QLocale::Language::Kumyk, "Kumyk\0", "kum\0" },
    { QLocale::Language::Kurdish, "Kurdish\0", "ku\0" },
    { QLocale::Language::Kurukh, "Kurukh\0", "kru\0" },
    { QLocale::Language::Kutenai, "Kutenai\0", "kut\0" },
    { QLocale::Language::Kwakwala, "Kwakʼwala\0", "kwk\0" },
    { QLocale::Language::Kwasio, "Kwasio\0", "nmg\0" },
    { QLocale::Language::Ladino, "Ladino\0", "lad\0" },
    { QLocale::Language::Lahnda, "Lahnda\0", "lah\0" },
    { QLocale::Language::Lakota, "Lakota\0", "lkt\0" },
    { QLocale::Language::Lamba, "Lamba\0", "lam\0" },
    { QLocale::Language::Langi, "Langi\0", "lag\0" },
    { QLocale::Language::Lao, "Lao\0", "lo\0" },
    { QLocale::Language::Latgalian, "Latgalian\0", "ltg\0" },
    { QLocale::Language::Latin, "Latin\0", "la\0" },
    { QLocale::Language::LatinAmericanSpanish, "Latin American Spanish\0", "es_419\0" },
    { QLocale::Language::Latvian, "Latvian\0", "lv\0" },
    { QLocale::Language::Laz, "Laz\0", "lzz\0" },
    { QLocale::Language::Lezghian, "Lezghian\0", "lez\0" },
    { QLocale::Language::Ligurian, "Ligurian\0", "lij\0" },
    { QLocale::Language::Lillooet, "Lillooet\0", "lil\0" },
    { QLocale::Language::Limburgish, "Limburgish\0", "li\0" },
    { QLocale::Language::Lingala, "Lingala\0", "ln\0" },
    { QLocale::Language::LinguaFrancaNova, "Lingua Franca Nova\0", "lfn\0" },
    { QLocale::Language::LiteraryChinese, "Literary Chinese\0", "lzh\0" },
    { QLocale::Language::Lithuanian, "Lithuanian\0", "lt\0" },
    { QLocale::Language::Livonian, "Livonian\0", "liv\0" },
    { QLocale::Language::Lojban, "Lojban\0", "jbo\0" },
    { QLocale::Language::Lombard, "Lombard\0", "lmo\0" },
    { QLocale::Language::LouisianaCreole, "Louisiana Creole\0", "lou\0" },
    { QLocale::Language::LowGerman, "Low German\0", "nds\0" },
    { QLocale::Language::LowSaxon, "Low Saxon\0", "nds_NL\0" },
    { QLocale::Language::LowerSilesian, "Lower Silesian\0", "sli\0" },
    { QLocale::Language::LowerSorbian, "Lower Sorbian\0", "dsb\0" },
    { QLocale::Language::Lozi, "Lozi\0", "loz\0" },
    { QLocale::Language::LubaKatanga, "Luba-Katanga\0", "lu\0" },
    { QLocale::Language::LubaLulua, "Luba-Lulua\0", "lua\0" },
    { QLocale::Language::Luiseno, "Luiseno\0", "lui\0" },
    { QLocale::Language::LuleSami, "Lule Sami\0", "smj\0" },
    { QLocale::Language::Lunda, "Lunda\0", "lun\0" },
    { QLocale::Language::Luo, "Luo\0", "luo\0" },
    { QLocale::Language::Luxembourgish, "Luxembourgish\0", "lb\0" },
    { QLocale::Language::Luyia, "Luyia\0", "luy\0" },
    { QLocale::Language::Maba, "Maba\0", "mde\0" },
    { QLocale::Language::Macedonian, "Macedonian\0", "mk\0" },
    { QLocale::Language::Machame, "Machame\0", "jmc\0" },
    { QLocale::Language::Madurese, "Madurese\0", "mad\0" },
    { QLocale::Language::Mafa, "Mafa\0", "maf\0" },
    { QLocale::Language::Magahi, "Magahi\0", "mag\0" },
    { QLocale::Language::MainFranconian, "Main-Franconian\0", "vmf\0" },
    { QLocale::Language::Maithili, "Maithili\0", "mai\0" },
    { QLocale::Language::Makasar, "Makasar\0", "mak\0" },
    { QLocale::Language::MakhuwaMeetto, "Makhuwa-Meetto\0", "mgh\0" },
    { QLocale::Language::Makonde, "Makonde\0", "kde\0" },
    { QLocale::Language::Malagasy, "Malagasy\0", "mg\0" },
    { QLocale::Language::Malay, "Malay\0", "ms\0" },
    { QLocale::Language::Malayalam, "Malayalam\0", "ml\0" },
    { QLocale::Language::Malecite, "Malecite\0", "pqm\0" },
    { QLocale::Language::Maltese, "Maltese\0", "mt\0" },
    { QLocale::Language::Manchu, "Manchu\0", "mnc\0" },
    { QLocale::Language::Mandar, "Mandar\0", "mdr\0" },
    { QLocale::Language::Mandingo, "Mandingo\0", "man\0" },
    { QLocale::Language::Manipuri, "Manipuri\0", "mni\0" },
    { QLocale::Language::Manx, "Manx\0", "gv\0" },
    { QLocale::Language::Maori, "Māori\0", "mi\0" },
    { QLocale::Language::Mapuche, "Mapuche\0", "arn\0" },
    { QLocale::Language::Marathi, "Marathi\0", "mr\0" },
    { QLocale::Language::Mari, "Mari\0", "chm\0" },
    { QLocale::Language::Marshallese, "Marshallese\0", "mh\0" },
    { QLocale::Language::Marwari, "Marwari\0", "mwr\0" },
    { QLocale::Language::Masai, "Masai\0", "mas\0" },
    { QLocale::Language::Mazanderani, "Mazanderani\0", "mzn\0" },
    { QLocale::Language::Medumba, "Medumba\0", "byv\0" },
    { QLocale::Language::Mende, "Mende\0", "men\0" },
    { QLocale::Language::Mentawai, "Mentawai\0", "mwv\0" },
    { QLocale::Language::Meru, "Meru\0", "mer\0" },
    { QLocale::Language::Meta, "Metaʼ\0", "mgo\0" },
    { QLocale::Language::MexicanSpanish, "Mexican Spanish\0", "es_MX\0" },
    { QLocale::Language::Michif, "Michif\0", "crg\0" },
    { QLocale::Language::MiddleDutch, "Middle Dutch\0", "dum\0" },
    { QLocale::Language::MiddleEnglish, "Middle English\0", "enm\0" },
    { QLocale::Language::MiddleFrench, "Middle French\0", "frm\0" },
    { QLocale::Language::MiddleHighGerman, "Middle High German\0", "gmh\0" },
    { QLocale::Language::MiddleIrish, "Middle Irish\0", "mga\0" },
    { QLocale::Language::Mikmaq, "Mi'kmaq\0", "mic\0" },
    { QLocale::Language::MinNanChinese, "Min Nan Chinese\0", "nan\0" },
    { QLocale::Language::Minangkabau, "Minangkabau\0", "min\0" },
    { QLocale::Language::Mingrelian, "Mingrelian\0", "xmf\0" },
    { QLocale::Language::Mirandese, "Mirandese\0", "mwl\0" },
    { QLocale::Language::Mizo, "Mizo\0", "lus\0" },
    { QLocale::Language::ModernStandardArabic, "Modern Standard Arabic\0", "ar_001\0" },
    { QLocale::Language::Mohawk, "Mohawk\0", "moh\0" },
    { QLocale::Language::Moksha, "Moksha\0", "mdf\0" },
    { QLocale::Language::Moldavian, "Moldavian\0", "ro_MD\0" },
    { QLocale::Language::Mongo, "Mongo\0", "lol\0" },
    { QLocale::Language::Mongolian, "Mongolian\0", "mn\0" },
    { QLocale::Language::Montenegrin, "Montenegrin\0", "sr_ME\0" },
    { QLocale::Language::MooseCree, "Moose Cree\0", "crm\0" },
    { QLocale::Language::Morisyen, "Morisyen\0", "mfe\0" },
    { QLocale::Language::MoroccanArabic, "Moroccan Arabic\0", "ary\0" },
    { QLocale::Language::Mossi, "Mossi\0", "mos\0" },
    { QLocale::Language::Multiplelanguages, "Multiple languages\0", "mul\0" },
    { QLocale::Language::Mundang, "Mundang\0", "mua\0" },
    { QLocale::Language::Muscogee, "Muscogee\0", "mus\0" },
    { QLocale::Language::MuslimTat, "Muslim Tat\0", "ttt\0" },
    { QLocale::Language::Myene, "Myene\0", "mye\0" },
    { QLocale::Language::NKo, "N’Ko\0", "nqo\0" },
    { QLocale::Language::Nama, "Nama\0", "naq\0" },
    { QLocale::Language::NauruLanguage, "Nauru\0", "na\0" },
    { QLocale::Language::Navajo, "Navajo\0", "nv\0" },
    { QLocale::Language::Ndonga, "Ndonga\0", "ng\0" },
    { QLocale::Language::Neapolitan, "Neapolitan\0", "nap\0" },
    { QLocale::Language::Nepali, "Nepali\0", "ne\0" },
    { QLocale::Language::Newari, "Newari\0", "new\0" },
    { QLocale::Language::Ngambay, "Ngambay\0", "sba\0" },
    { QLocale::Language::Ngiemboon, "Ngiemboon\0", "nnh\0" },
    { QLocale::Language::Ngomba, "Ngomba\0", "jgo\0" },
    { QLocale::Language::Nheengatu, "Nheengatu\0", "yrl\0" },
    { QLocale::Language::Nias, "Nias\0", "nia\0" },
    { QLocale::Language::NigerianPidgin, "Nigerian Pidgin\0", "pcm\0" },
    { QLocale::Language::Niuean, "Niuean\0", "niu\0" },
    { QLocale::Language::Nogai, "Nogai\0", "nog\0" },
    { QLocale::Language::Nolinguisticcontent, "No linguistic content\0", "zxx\0" },
    { QLocale::Language::NorthNdebele, "North Ndebele\0", "nd\0" },
    { QLocale::Language::NorthernEastCree, "Northern East Cree\0", "crl\0" },
    { QLocale::Language::NorthernFrisian, "Northern Frisian\0", "frr\0" },
    { QLocale::Language::NorthernHaida, "Northern Haida\0", "hdn\0" },
    { QLocale::Language::NorthernLuri, "Northern Luri\0", "lrc\0" },
    { QLocale::Language::NorthernSami, "Northern Sami\0", "se\0" },
    { QLocale::Language::NorthernSotho, "Northern Sotho\0", "nso\0" },
    { QLocale::Language::NorthernTutchone, "Northern Tutchone\0", "ttm\0" },
    { QLocale::Language::NorthwesternOjibwa, "Northwestern Ojibwa\0", "ojb\0" },
    { QLocale::Language::Norwegian, "Norwegian\0", "no\0" },
    { QLocale::Language::NorwegianBokmal, "Norwegian Bokmål\0", "nb\0" },
    { QLocale::Language::NorwegianNynorsk, "Norwegian Nynorsk\0", "nn\0" },
    { QLocale::Language::Novial, "Novial\0", "nov\0" },
    { QLocale::Language::Nuer, "Nuer\0", "nus\0" },
    { QLocale::Language::Nyamwezi, "Nyamwezi\0", "nym\0" },
    { QLocale::Language::Nyanja, "Nyanja\0", "ny\0" },
    { QLocale::Language::Nyankole, "Nyankole\0", "nyn\0" },
    { QLocale::Language::NyasaTonga, "Nyasa Tonga\0", "tog\0" },
    { QLocale::Language::Nyoro, "Nyoro\0", "nyo\0" },
    { QLocale::Language::Nzima, "Nzima\0", "nzi\0" },
    { QLocale::Language::Occitan, "Occitan\0", "oc\0" },
    { QLocale::Language::Odia, "Odia\0", "or\0" },
    { QLocale::Language::OjiCree, "Oji-Cree\0", "ojs\0" },
    { QLocale::Language::Ojibwa, "Ojibwa\0", "oj\0" },
    { QLocale::Language::Okanagan, "Okanagan\0", "oka\0" },
    { QLocale::Language::OldEnglish, "Old English\0", "ang\0" },
    { QLocale::Language::OldFrench, "Old French\0", "fro\0" },
    { QLocale::Language::OldHighGerman, "Old High German\0", "goh\0" },
    { QLocale::Language::OldIrish, "Old Irish\0", "sga\0" },
    { QLocale::Language::OldNorse, "Old Norse\0", "non\0" },
    { QLocale::Language::OldPersian, "Old Persian\0", "peo\0" },
    { QLocale::Language::OldProvencal, "Old Provençal\0", "pro\0" },
    { QLocale::Language::Oromo, "Oromo\0", "om\0" },
    { QLocale::Language::Osage, "Osage\0", "osa\0" },
    { QLocale::Language::Ossetic, "Ossetic\0", "os\0" },
    { QLocale::Language::OttomanTurkish, "Ottoman Turkish\0", "ota\0" },
    { QLocale::Language::Pahlavi, "Pahlavi\0", "pal\0" },
    { QLocale::Language::PalatineGerman, "Palatine German\0", "pfl\0" },
    { QLocale::Language::Palauan, "Palauan\0", "pau\0" },
    { QLocale::Language::Pali, "Pali\0", "pi\0" },
    { QLocale::Language::Pampanga, "Pampanga\0", "pam\0" },
    { QLocale::Language::Pangasinan, "Pangasinan\0", "pag\0" },
    { QLocale::Language::Papiamento, "Papiamento\0", "pap\0" },
    { QLocale::Language::Pashto, "Pashto\0", "ps\0" },
    { QLocale::Language::PennsylvaniaGerman, "Pennsylvania German\0", "pdc\0" },
    { QLocale::Language::Persian, "Persian\0", "fa\0" },
    { QLocale::Language::Phoenician, "Phoenician\0", "phn\0" },
    { QLocale::Language::Picard, "Picard\0", "pcd\0" },
    { QLocale::Language::Piedmontese, "Piedmontese\0", "pms\0" },
    { QLocale::Language::PlainsCree, "Plains Cree\0", "crk\0" },
    { QLocale::Language::Plautdietsch, "Plautdietsch\0", "pdt\0" },
    { QLocale::Language::Pohnpeian, "Pohnpeian\0", "pon\0" },
    { QLocale::Language::Polish, "Polish\0", "pl\0" },
    { QLocale::Language::Pontic, "Pontic\0", "pnt\0" },
    { QLocale::Language::Portuguese, "Portuguese\0", "pt\0" },
    { QLocale::Language::Prussian, "Prussian\0", "prg\0" },
    { QLocale::Language::Punjabi, "Punjabi\0", "pa\0" },
    { QLocale::Language::Quechua, "Quechua\0", "qu\0" },
    { QLocale::Language::Rajasthani, "Rajasthani\0", "raj\0" },
    { QLocale::Language::Rapanui, "Rapanui\0", "rap\0" },
    { QLocale::Language::Rarotongan, "Rarotongan\0", "rar\0" },
    { QLocale::Language::Riffian, "Riffian\0", "rif\0" },
    { QLocale::Language::Rohingya, "Rohingya\0", "rhg\0" },
    { QLocale::Language::Romagnol, "Romagnol\0", "rgn\0" },
    { QLocale::Language::Romanian, "Romanian\0", "ro\0" },
    { QLocale::Language::Romansh, "Romansh\0", "rm\0" },
    { QLocale::Language::Romany, "Romany\0", "rom\0" },
    { QLocale::Language::Rombo, "Rombo\0", "rof\0" },
    { QLocale::Language::Rotuman, "Rotuman\0", "rtm\0" },
    { QLocale::Language::Roviana, "Roviana\0", "rug\0" },
    { QLocale::Language::Rundi, "Rundi\0", "rn\0" },
    { QLocale::Language::Russian, "Russian\0", "ru\0" },
    { QLocale::Language::Rusyn, "Rusyn\0", "rue\0" },
    { QLocale::Language::Rwa, "Rwa\0", "rwk\0" },
    { QLocale::Language::Saho, "Saho\0", "ssy\0" },
    { QLocale::Language::Sakha, "Sakha\0", "sah\0" },
    { QLocale::Language::SamaritanAramaic, "Samaritan Aramaic\0", "sam\0" },
    { QLocale::Language::Samburu, "Samburu\0", "saq\0" },
    { QLocale::Language::SamiSkolt, "Sami, Skolt\0", "sms\0" },
    { QLocale::Language::SamiSouthern, "Sami, Southern\0", "sma\0" },
    { QLocale::Language::Samoan, "Samoan\0", "sm\0" },
    { QLocale::Language::Samogitian, "Samogitian\0", "sgs\0" },
    { QLocale::Language::Sandawe, "Sandawe\0", "sad\0" },
    { QLocale::Language::Sango, "Sango\0", "sg\0" },
    { QLocale::Language::Sangu, "Sangu\0", "sbp\0" },
    { QLocale::Language::Sanskrit, "Sanskrit\0", "sa\0" },
    { QLocale::Language::Santali, "Santali\0", "sat\0" },
    { QLocale::Language::Sardinian, "Sardinian\0", "sc\0" },
    { QLocale::Language::Sasak, "Sasak\0", "sas\0" },
    { QLocale::Language::SassareseSardinian, "Sassarese Sardinian\0", "sdc\0" },
    { QLocale::Language::SaterlandFrisian, "Saterland Frisian\0", "stq\0" },
    { QLocale::Language::Saurashtra, "Saurashtra\0", "saz\0" },
    { QLocale::Language::Scots, "Scots\0", "sco\0" },
    { QLocale::Language::ScottishGaelic, "Scottish Gaelic\0", "gd\0" },
    { QLocale::Language::Selayar, "Selayar\0", "sly\0" },
    { QLocale::Language::Selkup, "Selkup\0", "sel\0" },
    { QLocale::Language::Sena, "Sena\0", "seh\0" },
    { QLocale::Language::Seneca, "Seneca\0", "see\0" },
    { QLocale::Language::Serbian, "Serbian\0", "sr\0" },
    { QLocale::Language::SerboCroatian, "Serbo-Croatian\0", "sh\0" },
    { QLocale::Language::Serer, "Serer\0", "srr\0" },
    { QLocale::Language::Seri, "Seri\0", "sei\0" },
    { QLocale::Language::SeselwaCreoleFrench, "Seselwa Creole French\0", "crs\0" },
    { QLocale::Language::Shambala, "Shambala\0", "ksb\0" },
    { QLocale::Language::Shan, "Shan\0", "shn\0" },
    { QLocale::Language::Shona, "Shona\0", "sn\0" },
    { QLocale::Language::SichuanYi, "Sichuan Yi\0", "ii\0" },
    { QLocale::Language::Sicilian, "Sicilian\0", "scn\0" },
    { QLocale::Language::Sidamo, "Sidamo\0", "sid\0" },
    { QLocale::Language::Siksika, "Siksika\0", "bla\0" },
    { QLocale::Language::Silesian, "Silesian\0", "szl\0" },
    { QLocale::Language::SimplifiedChinese, "Simplified Chinese\0", "zh_Hans\0" },
    { QLocale::Language::Sindhi, "Sindhi\0", "sd\0" },
    { QLocale::Language::Sinhala, "Sinhala\0", "si\0" },
    { QLocale::Language::Slave, "Slave\0", "den\0" },
    { QLocale::Language::Slovak, "Slovak\0", "sk\0" },
    { QLocale::Language::Slovenian, "Slovenian\0", "sl\0" },
    { QLocale::Language::Soga, "Soga\0", "xog\0" },
    { QLocale::Language::Sogdien, "Sogdien\0", "sog\0" },
    { QLocale::Language::Somali, "Somali\0", "so\0" },
    { QLocale::Language::Soninke, "Soninke\0", "snk\0" },
    { QLocale::Language::SouthNdebele, "South Ndebele\0", "nr\0" },
    { QLocale::Language::SouthernAltai, "Southern Altai\0", "alt\0" },
    { QLocale::Language::SouthernEastCree, "Southern East Cree\0", "crj\0" },
    { QLocale::Language::SouthernHaida, "Southern Haida\0", "hax\0" },
    { QLocale::Language::SouthernKurdish, "Southern Kurdish\0", "sdh\0" },
    { QLocale::Language::SouthernLushootseed, "Southern Lushootseed\0", "slh\0" },
    { QLocale::Language::SouthernSotho, "Southern Sotho\0", "st\0" },
    { QLocale::Language::SouthernTutchone, "Southern Tutchone\0", "tce\0" },
    { QLocale::Language::Spanish, "Spanish\0", "es\0" },
    { QLocale::Language::SrananTongo, "Sranan Tongo\0", "srn\0" },
    { QLocale::Language::StandardMoroccanTamazight, "Standard Moroccan Tamazight\0", "zgh\0" },
    { QLocale::Language::StraitsSalish, "Straits Salish\0", "str\0" },
    { QLocale::Language::Sukuma, "Sukuma\0", "suk\0" },
    { QLocale::Language::Sumerian, "Sumerian\0", "sux\0" },
    { QLocale::Language::Sundanese, "Sundanese\0", "su\0" },
    { QLocale::Language::Susu, "Susu\0", "sus\0" },
    { QLocale::Language::Swahili, "Swahili\0", "sw\0" },
    { QLocale::Language::SwampyCree, "Swampy Cree\0", "csw\0" },
    { QLocale::Language::Swati, "Swati\0", "ss\0" },
    { QLocale::Language::Swedish, "Swedish\0", "sv\0" },
    { QLocale::Language::SwissFrench, "Swiss French\0", "fr_CH\0" },
    { QLocale::Language::SwissGerman, "Swiss German\0", "gsw\0" },
    { QLocale::Language::SwissHighGerman, "Swiss High German\0", "de_CH\0" },
    { QLocale::Language::Syriac, "Syriac\0", "syr\0" },
    { QLocale::Language::Tachelhit, "Tachelhit\0", "shi\0" },
    { QLocale::Language::Tagalog, "Tagalog\0", "tl\0" },
    { QLocale::Language::Tagish, "Tagish\0", "tgx\0" },
    { QLocale::Language::Tahitian, "Tahitian\0", "ty\0" },
    { QLocale::Language::Tahltan, "Tahltan\0", "tht\0" },
    { QLocale::Language::TaiDam, "Tai Dam\0", "blt\0" },
    { QLocale::Language::Taita, "Taita\0", "dav\0" },
    { QLocale::Language::Tajik, "Tajik\0", "tg\0" },
    { QLocale::Language::Talysh, "Talysh\0", "tly\0" },
    { QLocale::Language::Tamashek, "Tamashek\0", "tmh\0" },
    { QLocale::Language::Tamil, "Tamil\0", "ta\0" },
    { QLocale::Language::Taroko, "Taroko\0", "trv\0" },
    { QLocale::Language::Tasawaq, "Tasawaq\0", "twq\0" },
    { QLocale::Language::Tatar, "Tatar\0", "tt\0" },
    { QLocale::Language::Telugu, "Telugu\0", "te\0" },
    { QLocale::Language::Tereno, "Tereno\0", "ter\0" },
    { QLocale::Language::Teso, "Teso\0", "teo\0" },
    { QLocale::Language::Tetum, "Tetum\0", "tet\0" },
    { QLocale::Language::Thai, "Thai\0", "th\0" },
    { QLocale::Language::Tibetan, "Tibetan\0", "bo\0" },
    { QLocale::Language::Tigre, "Tigre\0", "tig\0" },
    { QLocale::Language::Tigrinya, "Tigrinya\0", "ti\0" },
    { QLocale::Language::Timne, "Timne\0", "tem\0" },
    { QLocale::Language::Tiv, "Tiv\0", "tiv\0" },
    { QLocale::Language::Tlingit, "Tlingit\0", "tli\0" },
    { QLocale::Language::TokPisin, "Tok Pisin\0", "tpi\0" },
    { QLocale::Language::TokelauLanguage, "Tokelau\0", "tkl\0" },
    { QLocale::Language::Tongan, "Tongan\0", "to\0" },
    { QLocale::Language::TornedalenFinnish, "Tornedalen Finnish\0", "fit\0" },
    { QLocale::Language::Torwali, "Torwali\0", "trw\0" },
    { QLocale::Language::TraditionalChinese, "Traditional Chinese\0", "zh_Hant\0" },
    { QLocale::Language::Tsakhur, "Tsakhur\0", "tkr\0" },
    { QLocale::Language::Tsakonian, "Tsakonian\0", "tsd\0" },
    { QLocale::Language::Tsimshian, "Tsimshian\0", "tsi\0" },
    { QLocale::Language::Tsonga, "Tsonga\0", "ts\0" },
    { QLocale::Language::Tswana, "Tswana\0", "tn\0" },
    { QLocale::Language::Tulu, "Tulu\0", "tcy\0" },
    { QLocale::Language::Tumbuka, "Tumbuka\0", "tum\0" },
    { QLocale::Language::TunisianArabic, "Tunisian Arabic\0", "aeb\0" },
    { QLocale::Language::Turkish, "Turkish\0", "tr\0" },
    { QLocale::Language::Turkmen, "Turkmen\0", "tk\0" },
    { QLocale::Language::Turoyo, "Turoyo\0", "tru\0" },
    { QLocale::Language::TuvaluLanguage, "Tuvalu\0", "tvl\0" },
    { QLocale::Language::Tuvinian, "Tuvinian\0", "tyv\0" },
    { QLocale::Language::Twi, "Twi\0", "tw\0" },
    { QLocale::Language::Tyap, "Tyap\0", "kcg\0" },
    { QLocale::Language::Udmurt, "Udmurt\0", "udm\0" },
    { QLocale::Language::Ugaritic, "Ugaritic\0", "uga\0" },
    { QLocale::Language::Uighur, "Uighur\0", "ug\0" },
    { QLocale::Language::Ukrainian, "Ukrainian\0", "uk\0" },
    { QLocale::Language::Umbundu, "Umbundu\0", "umb\0" },
    { QLocale::Language::Unknownlanguage, "Unknown language\0", "und\0" },
    { QLocale::Language::UpperSorbian, "Upper Sorbian\0", "hsb\0" },
    { QLocale::Language::Urdu, "Urdu\0", "ur\0" },
    { QLocale::Language::Uzbek, "Uzbek\0", "uz\0" },
    { QLocale::Language::Vai, "Vai\0", "vai\0" },
    { QLocale::Language::Venda, "Venda\0", "ve\0" },
    { QLocale::Language::Venetian, "Venetian\0", "vec\0" },
    { QLocale::Language::Veps, "Veps\0", "vep\0" },
    { QLocale::Language::Vietnamese, "Vietnamese\0", "vi\0" },
    { QLocale::Language::Volapuk, "Volapük\0", "vo\0" },
    { QLocale::Language::Voro, "Võro\0", "vro\0" },
    { QLocale::Language::Votic, "Votic\0", "vot\0" },
    { QLocale::Language::Vunjo, "Vunjo\0", "vun\0" },
    { QLocale::Language::Walloon, "Walloon\0", "wa\0" },
    { QLocale::Language::Walser, "Walser\0", "wae\0" },
    { QLocale::Language::Waray, "Waray\0", "war\0" },
    { QLocale::Language::Warlpiri, "Warlpiri\0", "wbp\0" },
    { QLocale::Language::Washo, "Washo\0", "was\0" },
    { QLocale::Language::Wayuu, "Wayuu\0", "guc\0" },
    { QLocale::Language::Welsh, "Welsh\0", "cy\0" },
    { QLocale::Language::WestFlemish, "West Flemish\0", "vls\0" },
    { QLocale::Language::WesternBalochi, "Western Balochi\0", "bgn\0" },
    { QLocale::Language::WesternCanadianInuktitut, "Western Canadian Inuktitut\0", "ikt\0" },
    { QLocale::Language::WesternFrisian, "Western Frisian\0", "fy\0" },
    { QLocale::Language::WesternMari, "Western Mari\0", "mrj\0" },
    { QLocale::Language::WesternOjibwa, "Western Ojibwa\0", "ojw\0" },
    { QLocale::Language::Wolaytta, "Wolaytta\0", "wal\0" },
    { QLocale::Language::Wolof, "Wolof\0", "wo\0" },
    { QLocale::Language::WoodsCree, "Woods Cree\0", "cwd\0" },
    { QLocale::Language::WuChinese, "Wu Chinese\0", "wuu\0" },
    { QLocale::Language::Xhosa, "Xhosa\0", "xh\0" },
    { QLocale::Language::XiangChinese, "Xiang Chinese\0", "hsn\0" },
    { QLocale::Language::Yangben, "Yangben\0", "yav\0" },
    { QLocale::Language::Yao, "Yao\0", "yao\0" },
    { QLocale::Language::Yapese, "Yapese\0", "yap\0" },
    { QLocale::Language::Yemba, "Yemba\0", "ybb\0" },
    { QLocale::Language::Yiddish, "Yiddish\0", "yi\0" },
    { QLocale::Language::Yoruba, "Yoruba\0", "yo\0" },
    { QLocale::Language::Zapotec, "Zapotec\0", "zap\0" },
    { QLocale::Language::Zarma, "Zarma\0", "dje\0" },
    { QLocale::Language::Zaza, "Zaza\0", "zza\0" },
    { QLocale::Language::Zeelandic, "Zeelandic\0", "zea\0" },
    { QLocale::Language::Zenaga, "Zenaga\0", "zen\0" },
    { QLocale::Language::Zhuang, "Zhuang\0", "za\0" },
    { QLocale::Language::ZoroastrianDari, "Zoroastrian Dari\0", "gbz\0" },
    { QLocale::Language::Zulu, "Zulu\0", "zu\0" },
    { QLocale::Language::Zuni, "Zuni\0", "zun\0" },
};
static const qint16 languageTblSize = sizeof(languageTbl) / sizeof(languageTblData);

static const struct countryTblData {
    const QLocale::Country country;
    const char* name;
    const char* code;
} countryTbl[] = {
    { QLocale::Country::AnyCountry, "Default\0", nullptr },
    { QLocale::Country::Afghanistan, "Afghanistan\0", "AF\0" },
    { QLocale::Country::Africa, "Africa\0", "002\0" },
    { QLocale::Country::AlandIslands, "Åland Islands\0", "AX\0" },
    { QLocale::Country::Albania, "Albania\0", "AL\0" },
    { QLocale::Country::Algeria, "Algeria\0", "DZ\0" },
    { QLocale::Country::AmericanSamoa, "American Samoa\0", "AS\0" },
    { QLocale::Country::Americas, "Americas\0", "019\0" },
    { QLocale::Country::Andorra, "Andorra\0", "AD\0" },
    { QLocale::Country::Angola, "Angola\0", "AO\0" },
    { QLocale::Country::Anguilla, "Anguilla\0", "AI\0" },
    { QLocale::Country::Antarctica, "Antarctica\0", "AQ\0" },
    { QLocale::Country::AntiguaAndBarbuda, "Antigua & Barbuda\0", "AG\0" },
    { QLocale::Country::Argentina, "Argentina\0", "AR\0" },
    { QLocale::Country::Armenia, "Armenia\0", "AM\0" },
    { QLocale::Country::Aruba, "Aruba\0", "AW\0" },
    { QLocale::Country::AscensionIsland, "Ascension Island\0", "AC\0" },
    { QLocale::Country::Asia, "Asia\0", "142\0" },
    { QLocale::Country::Australasia, "Australasia\0", "053\0" },
    { QLocale::Country::Australia, "Australia\0", "AU\0" },
    { QLocale::Country::Austria, "Austria\0", "AT\0" },
    { QLocale::Country::Azerbaijan, "Azerbaijan\0", "AZ\0" },
    { QLocale::Country::Bahamas, "Bahamas\0", "BS\0" },
    { QLocale::Country::Bahrain, "Bahrain\0", "BH\0" },
    { QLocale::Country::Bangladesh, "Bangladesh\0", "BD\0" },
    { QLocale::Country::Barbados, "Barbados\0", "BB\0" },
    { QLocale::Country::Belarus, "Belarus\0", "BY\0" },
    { QLocale::Country::Belgium, "Belgium\0", "BE\0" },
    { QLocale::Country::Belize, "Belize\0", "BZ\0" },
    { QLocale::Country::Benin, "Benin\0", "BJ\0" },
    { QLocale::Country::Bermuda, "Bermuda\0", "BM\0" },
    { QLocale::Country::Bhutan, "Bhutan\0", "BT\0" },
    { QLocale::Country::Bolivia, "Bolivia\0", "BO\0" },
    { QLocale::Country::Bosnia, "Bosnia\0", "BA\0" },
    { QLocale::Country::Botswana, "Botswana\0", "BW\0" },
    { QLocale::Country::BouvetIsland, "Bouvet Island\0", "BV\0" },
    { QLocale::Country::Brazil, "Brazil\0", "BR\0" },
    { QLocale::Country::BritishIndianOceanTerritory, "British Indian Ocean Territory\0", "IO\0" },
    { QLocale::Country::BritishVirginIslands, "British Virgin Islands\0", "VG\0" },
    { QLocale::Country::Brunei, "Brunei\0", "BN\0" },
    { QLocale::Country::Bulgaria, "Bulgaria\0", "BG\0" },
    { QLocale::Country::BurkinaFaso, "Burkina Faso\0", "BF\0" },
    { QLocale::Country::Burundi, "Burundi\0", "BI\0" },
    { QLocale::Country::CaboVerde, "Cabo Verde\0", "CV\0" },
    { QLocale::Country::Cambodia, "Cambodia\0", "KH\0" },
    { QLocale::Country::Cameroon, "Cameroon\0", "CM\0" },
    { QLocale::Country::Canada, "Canada\0", "CA\0" },
    { QLocale::Country::CanaryIslands, "Canary Islands\0", "IC\0" },
    { QLocale::Country::Caribbean, "Caribbean\0", "029\0" },
    { QLocale::Country::CaribbeanNetherlands, "Caribbean Netherlands\0", "BQ\0" },
    { QLocale::Country::CaymanIslands, "Cayman Islands\0", "KY\0" },
    { QLocale::Country::CentralAfricanRepublic, "Central African Republic\0", "CF\0" },
    { QLocale::Country::CentralAmerica, "Central America\0", "013\0" },
    { QLocale::Country::CentralAsia, "Central Asia\0", "143\0" },
    { QLocale::Country::CeutaAndMelilla, "Ceuta & Melilla\0", "EA\0" },
    { QLocale::Country::Chad, "Chad\0", "TD\0" },
    { QLocale::Country::Chile, "Chile\0", "CL\0" },
    { QLocale::Country::China, "China\0", "CN\0" },
    { QLocale::Country::ChristmasIsland, "Christmas Island\0", "CX\0" },
    { QLocale::Country::ClippertonIsland, "Clipperton Island\0", "CP\0" },
    { QLocale::Country::CocosKeelingIslands, "Cocos (Keeling) Islands\0", "CC\0" },
    { QLocale::Country::Colombia, "Colombia\0", "CO\0" },
    { QLocale::Country::Comoros, "Comoros\0", "KM\0" },
    { QLocale::Country::CongoBrazzaville, "Congo - Brazzaville\0", "CG\0" },
    { QLocale::Country::CongoDRC, "Congo (DRC)\0", "CD\0" },
    { QLocale::Country::CookIslands, "Cook Islands\0", "CK\0" },
    { QLocale::Country::CostaRica, "Costa Rica\0", "CR\0" },
    { QLocale::Country::CotedIvoire, "Côte d’Ivoire\0", "CI\0" },
    { QLocale::Country::Croatia, "Croatia\0", "HR\0" },
    { QLocale::Country::Cuba, "Cuba\0", "CU\0" },
    { QLocale::Country::Curacao, "Curaçao\0", "CW\0" },
    { QLocale::Country::Cyprus, "Cyprus\0", "CY\0" },
    { QLocale::Country::CzechRepublic, "Czech Republic\0", "CZ\0" },
    { QLocale::Country::Denmark, "Denmark\0", "DK\0" },
    { QLocale::Country::DiegoGarcia, "Diego Garcia\0", "DG\0" },
    { QLocale::Country::Djibouti, "Djibouti\0", "DJ\0" },
    { QLocale::Country::Dominica, "Dominica\0", "DM\0" },
    { QLocale::Country::DominicanRepublic, "Dominican Republic\0", "DO\0" },
    { QLocale::Country::EastTimor, "East Timor\0", "TL\0" },
    { QLocale::Country::EasternAfrica, "Eastern Africa\0", "014\0" },
    { QLocale::Country::EasternAsia, "Eastern Asia\0", "030\0" },
    { QLocale::Country::EasternEurope, "Eastern Europe\0", "151\0" },
    { QLocale::Country::Ecuador, "Ecuador\0", "EC\0" },
    { QLocale::Country::Egypt, "Egypt\0", "EG\0" },
    { QLocale::Country::ElSalvador, "El Salvador\0", "SV\0" },
    { QLocale::Country::EquatorialGuinea, "Equatorial Guinea\0", "GQ\0" },
    { QLocale::Country::Eritrea, "Eritrea\0", "ER\0" },
    { QLocale::Country::Estonia, "Estonia\0", "EE\0" },
    { QLocale::Country::Eswatini, "Eswatini\0", "SZ\0" },
    { QLocale::Country::Ethiopia, "Ethiopia\0", "ET\0" },
    { QLocale::Country::Europe, "Europe\0", "150\0" },
    { QLocale::Country::EuropeanUnion, "European Union\0", "EU\0" },
    { QLocale::Country::Eurozone, "Eurozone\0", "EZ\0" },
    { QLocale::Country::FalklandIslands, "Falkland Islands\0", "FK\0" },
    { QLocale::Country::FaroeIslands, "Faroe Islands\0", "FO\0" },
    { QLocale::Country::Fiji, "Fiji\0", "FJ\0" },
    { QLocale::Country::Finland, "Finland\0", "FI\0" },
    { QLocale::Country::France, "France\0", "FR\0" },
    { QLocale::Country::FrenchGuiana, "French Guiana\0", "GF\0" },
    { QLocale::Country::FrenchPolynesia, "French Polynesia\0", "PF\0" },
    { QLocale::Country::FrenchSouthernTerritories, "French Southern Territories\0", "TF\0" },
    { QLocale::Country::Gabon, "Gabon\0", "GA\0" },
    { QLocale::Country::Gambia, "Gambia\0", "GM\0" },
    { QLocale::Country::Georgia, "Georgia\0", "GE\0" },
    { QLocale::Country::Germany, "Germany\0", "DE\0" },
    { QLocale::Country::Ghana, "Ghana\0", "GH\0" },
    { QLocale::Country::Gibraltar, "Gibraltar\0", "GI\0" },
    { QLocale::Country::Greece, "Greece\0", "GR\0" },
    { QLocale::Country::Greenland, "Greenland\0", "GL\0" },
    { QLocale::Country::Grenada, "Grenada\0", "GD\0" },
    { QLocale::Country::Guadeloupe, "Guadeloupe\0", "GP\0" },
    { QLocale::Country::Guam, "Guam\0", "GU\0" },
    { QLocale::Country::Guatemala, "Guatemala\0", "GT\0" },
    { QLocale::Country::Guernsey, "Guernsey\0", "GG\0" },
    { QLocale::Country::Guinea, "Guinea\0", "GN\0" },
    { QLocale::Country::GuineaBissau, "Guinea-Bissau\0", "GW\0" },
    { QLocale::Country::Guyana, "Guyana\0", "GY\0" },
    { QLocale::Country::Haiti, "Haiti\0", "HT\0" },
    { QLocale::Country::HeardAndMcDonaldIslands, "Heard & McDonald Islands\0", "HM\0" },
    { QLocale::Country::Honduras, "Honduras\0", "HN\0" },
    { QLocale::Country::HongKong, "Hong Kong\0", "HK\0" },
    { QLocale::Country::Hungary, "Hungary\0", "HU\0" },
    { QLocale::Country::Iceland, "Iceland\0", "IS\0" },
    { QLocale::Country::India, "India\0", "IN\0" },
    { QLocale::Country::Indonesia, "Indonesia\0", "ID\0" },
    { QLocale::Country::Iran, "Iran\0", "IR\0" },
    { QLocale::Country::Iraq, "Iraq\0", "IQ\0" },
    { QLocale::Country::Ireland, "Ireland\0", "IE\0" },
    { QLocale::Country::IsleofMan, "Isle of Man\0", "IM\0" },
    { QLocale::Country::Israel, "Israel\0", "IL\0" },
    { QLocale::Country::Italy, "Italy\0", "IT\0" },
    { QLocale::Country::Jamaica, "Jamaica\0", "JM\0" },
    { QLocale::Country::Japan, "Japan\0", "JP\0" },
    { QLocale::Country::Jersey, "Jersey\0", "JE\0" },
    { QLocale::Country::Jordan, "Jordan\0", "JO\0" },
    { QLocale::Country::Kazakhstan, "Kazakhstan\0", "KZ\0" },
    { QLocale::Country::Kenya, "Kenya\0", "KE\0" },
    { QLocale::Country::Kiribati, "Kiribati\0", "KI\0" },
    { QLocale::Country::Kosovo, "Kosovo\0", "XK\0" },
    { QLocale::Country::Kuwait, "Kuwait\0", "KW\0" },
    { QLocale::Country::Kyrgyzstan, "Kyrgyzstan\0", "KG\0" },
    { QLocale::Country::Laos, "Laos\0", "LA\0" },
    { QLocale::Country::LatinAmerica, "Latin America\0", "419\0" },
    { QLocale::Country::Latvia, "Latvia\0", "LV\0" },
    { QLocale::Country::Lebanon, "Lebanon\0", "LB\0" },
    { QLocale::Country::Lesotho, "Lesotho\0", "LS\0" },
    { QLocale::Country::Liberia, "Liberia\0", "LR\0" },
    { QLocale::Country::Libya, "Libya\0", "LY\0" },
    { QLocale::Country::Liechtenstein, "Liechtenstein\0", "LI\0" },
    { QLocale::Country::Lithuania, "Lithuania\0", "LT\0" },
    { QLocale::Country::Luxembourg, "Luxembourg\0", "LU\0" },
    { QLocale::Country::Macao, "Macao\0", "MO\0" },
    { QLocale::Country::Madagascar, "Madagascar\0", "MG\0" },
    { QLocale::Country::Malawi, "Malawi\0", "MW\0" },
    { QLocale::Country::Malaysia, "Malaysia\0", "MY\0" },
    { QLocale::Country::Maldives, "Maldives\0", "MV\0" },
    { QLocale::Country::Mali, "Mali\0", "ML\0" },
    { QLocale::Country::Malta, "Malta\0", "MT\0" },
    { QLocale::Country::MarshallIslands, "Marshall Islands\0", "MH\0" },
    { QLocale::Country::Martinique, "Martinique\0", "MQ\0" },
    { QLocale::Country::Mauritania, "Mauritania\0", "MR\0" },
    { QLocale::Country::Mauritius, "Mauritius\0", "MU\0" },
    { QLocale::Country::Mayotte, "Mayotte\0", "YT\0" },
    { QLocale::Country::Melanesia, "Melanesia\0", "054\0" },
    { QLocale::Country::Mexico, "Mexico\0", "MX\0" },
    { QLocale::Country::Micronesia, "Micronesia\0", "FM\0" },
    { QLocale::Country::MicronesianRegion, "Micronesian Region\0", "057\0" },
    { QLocale::Country::MiddleAfrica, "Middle Africa\0", "017\0" },
    { QLocale::Country::Moldova, "Moldova\0", "MD\0" },
    { QLocale::Country::Monaco, "Monaco\0", "MC\0" },
    { QLocale::Country::Mongolia, "Mongolia\0", "MN\0" },
    { QLocale::Country::Montenegro, "Montenegro\0", "ME\0" },
    { QLocale::Country::Montserrat, "Montserrat\0", "MS\0" },
    { QLocale::Country::Morocco, "Morocco\0", "MA\0" },
    { QLocale::Country::Mozambique, "Mozambique\0", "MZ\0" },
    { QLocale::Country::Myanmar, "Myanmar\0", "MM\0" },
    { QLocale::Country::Namibia, "Namibia\0", "NA\0" },
    { QLocale::Country::Nauru, "Nauru\0", "NR\0" },
    { QLocale::Country::Nepal, "Nepal\0", "NP\0" },
    { QLocale::Country::Netherlands, "Netherlands\0", "NL\0" },
    { QLocale::Country::NewCaledonia, "New Caledonia\0", "NC\0" },
    { QLocale::Country::NewZealand, "New Zealand\0", "NZ\0" },
    { QLocale::Country::Nicaragua, "Nicaragua\0", "NI\0" },
    { QLocale::Country::Niger, "Niger\0", "NE\0" },
    { QLocale::Country::Nigeria, "Nigeria\0", "NG\0" },
    { QLocale::Country::Niue, "Niue\0", "NU\0" },
    { QLocale::Country::NorfolkIsland, "Norfolk Island\0", "NF\0" },
    { QLocale::Country::NorthAmerica, "North America\0", "003\0" },
    { QLocale::Country::NorthKorea, "North Korea\0", "KP\0" },
    { QLocale::Country::NorthMacedonia, "North Macedonia\0", "MK\0" },
    { QLocale::Country::NorthernAfrica, "Northern Africa\0", "015\0" },
    { QLocale::Country::NorthernAmerica, "Northern America\0", "021\0" },
    { QLocale::Country::NorthernEurope, "Northern Europe\0", "154\0" },
    { QLocale::Country::NorthernMarianaIslands, "Northern Mariana Islands\0", "MP\0" },
    { QLocale::Country::Norway, "Norway\0", "NO\0" },
    { QLocale::Country::Oceania, "Oceania\0", "009\0" },
    { QLocale::Country::Oman, "Oman\0", "OM\0" },
    { QLocale::Country::OutlyingOceania, "Outlying Oceania\0", "QO\0" },
    { QLocale::Country::Pakistan, "Pakistan\0", "PK\0" },
    { QLocale::Country::Palau, "Palau\0", "PW\0" },
    { QLocale::Country::Palestine, "Palestine\0", "PS\0" },
    { QLocale::Country::Panama, "Panama\0", "PA\0" },
    { QLocale::Country::PapuaNewGuinea, "Papua New Guinea\0", "PG\0" },
    { QLocale::Country::Paraguay, "Paraguay\0", "PY\0" },
    { QLocale::Country::Peru, "Peru\0", "PE\0" },
    { QLocale::Country::Philippines, "Philippines\0", "PH\0" },
    { QLocale::Country::PitcairnIslands, "Pitcairn Islands\0", "PN\0" },
    { QLocale::Country::Poland, "Poland\0", "PL\0" },
    { QLocale::Country::Polynesia, "Polynesia\0", "061\0" },
    { QLocale::Country::Portugal, "Portugal\0", "PT\0" },
    { QLocale::Country::PseudoAccents, "Pseudo-Accents\0", "XA\0" },
    { QLocale::Country::PseudoBidi, "Pseudo-Bidi\0", "XB\0" },
    { QLocale::Country::PuertoRico, "Puerto Rico\0", "PR\0" },
    { QLocale::Country::Qatar, "Qatar\0", "QA\0" },
    { QLocale::Country::Reunion, "Réunion\0", "RE\0" },
    { QLocale::Country::Romania, "Romania\0", "RO\0" },
    { QLocale::Country::Russia, "Russia\0", "RU\0" },
    { QLocale::Country::Rwanda, "Rwanda\0", "RW\0" },
    { QLocale::Country::Samoa, "Samoa\0", "WS\0" },
    { QLocale::Country::SanMarino, "San Marino\0", "SM\0" },
    { QLocale::Country::SaoTomeAndPrincipe, "São Tomé & Príncipe\0", "ST\0" },
    { QLocale::Country::SaudiArabia, "Saudi Arabia\0", "SA\0" },
    { QLocale::Country::Senegal, "Senegal\0", "SN\0" },
    { QLocale::Country::Serbia, "Serbia\0", "RS\0" },
    { QLocale::Country::Seychelles, "Seychelles\0", "SC\0" },
    { QLocale::Country::SierraLeone, "Sierra Leone\0", "SL\0" },
    { QLocale::Country::Singapore, "Singapore\0", "SG\0" },
    { QLocale::Country::SintMaarten, "Sint Maarten\0", "SX\0" },
    { QLocale::Country::Slovakia, "Slovakia\0", "SK\0" },
    { QLocale::Country::Slovenia, "Slovenia\0", "SI\0" },
    { QLocale::Country::SolomonIslands, "Solomon Islands\0", "SB\0" },
    { QLocale::Country::Somalia, "Somalia\0", "SO\0" },
    { QLocale::Country::SouthAfrica, "South Africa\0", "ZA\0" },
    { QLocale::Country::SouthAmerica, "South America\0", "005\0" },
    { QLocale::Country::SouthGeorgiaAndSouthSandwichIslands, "South Georgia & South Sandwich Islands\0", "GS\0" },
    { QLocale::Country::SouthKorea, "South Korea\0", "KR\0" },
    { QLocale::Country::SouthSudan, "South Sudan\0", "SS\0" },
    { QLocale::Country::SoutheastAsia, "Southeast Asia\0", "035\0" },
    { QLocale::Country::SouthernAfrica, "Southern Africa\0", "018\0" },
    { QLocale::Country::SouthernAsia, "Southern Asia\0", "034\0" },
    { QLocale::Country::SouthernEurope, "Southern Europe\0", "039\0" },
    { QLocale::Country::Spain, "Spain\0", "ES\0" },
    { QLocale::Country::SriLanka, "Sri Lanka\0", "LK\0" },
    { QLocale::Country::StBarthelemy, "St. Barthélemy\0", "BL\0" },
    { QLocale::Country::StHelena, "St. Helena\0", "SH\0" },
    { QLocale::Country::StKittsAndNevis, "St. Kitts & Nevis\0", "KN\0" },
    { QLocale::Country::StLucia, "St. Lucia\0", "LC\0" },
    { QLocale::Country::StMartin, "St. Martin\0", "MF\0" },
    { QLocale::Country::StPierreAndMiquelon, "St. Pierre & Miquelon\0", "PM\0" },
    { QLocale::Country::StVincentAndGrenadines, "St. Vincent & Grenadines\0", "VC\0" },
    { QLocale::Country::SubSaharanAfrica, "Sub-Saharan Africa\0", "202\0" },
    { QLocale::Country::Sudan, "Sudan\0", "SD\0" },
    { QLocale::Country::Suriname, "Suriname\0", "SR\0" },
    { QLocale::Country::SvalbardAndJanMayen, "Svalbard & Jan Mayen\0", "SJ\0" },
    { QLocale::Country::Sweden, "Sweden\0", "SE\0" },
    { QLocale::Country::Switzerland, "Switzerland\0", "CH\0" },
    { QLocale::Country::Syria, "Syria\0", "SY\0" },
    { QLocale::Country::Taiwan, "Taiwan\0", "TW\0" },
    { QLocale::Country::Tajikistan, "Tajikistan\0", "TJ\0" },
    { QLocale::Country::Tanzania, "Tanzania\0", "TZ\0" },
    { QLocale::Country::Thailand, "Thailand\0", "TH\0" },
    { QLocale::Country::Togo, "Togo\0", "TG\0" },
    { QLocale::Country::Tokelau, "Tokelau\0", "TK\0" },
    { QLocale::Country::Tonga, "Tonga\0", "TO\0" },
    { QLocale::Country::TrinidadAndTobago, "Trinidad & Tobago\0", "TT\0" },
    { QLocale::Country::TristandaCunha, "Tristan da Cunha\0", "TA\0" },
    { QLocale::Country::Tunisia, "Tunisia\0", "TN\0" },
    { QLocale::Country::Turkey, "Turkey\0", "TR\0" },
    { QLocale::Country::Turkmenistan, "Turkmenistan\0", "TM\0" },
    { QLocale::Country::TurksAndCaicosIslands, "Turks & Caicos Islands\0", "TC\0" },
    { QLocale::Country::Tuvalu, "Tuvalu\0", "TV\0" },
    { QLocale::Country::UK, "UK\0", "GB\0" },
    { QLocale::Country::UN, "UN\0", "UN\0" },
    { QLocale::Country::US, "US\0", "US\0" },
    { QLocale::Country::Uganda, "Uganda\0", "UG\0" },
    { QLocale::Country::Ukraine, "Ukraine\0", "UA\0" },
    { QLocale::Country::UnitedArabEmirates, "United Arab Emirates\0", "AE\0" },
    { QLocale::Country::UnitedStatesOutlyingIslands, "U.S. Outlying Islands\0", "UM\0" },
    { QLocale::Country::UnitedStatesVirginIslands, "U.S. Virgin Islands\0", "VI\0" },
    { QLocale::Country::UnknownRegion, "Unknown Region\0", "ZZ\0" },
    { QLocale::Country::Uruguay, "Uruguay\0", "UY\0" },
    { QLocale::Country::Uzbekistan, "Uzbekistan\0", "UZ\0" },
    { QLocale::Country::Vanuatu, "Vanuatu\0", "VU\0" },
    { QLocale::Country::VaticanCity, "Vatican City\0", "VA\0" },
    { QLocale::Country::Venezuela, "Venezuela\0", "VE\0" },
    { QLocale::Country::Vietnam, "Vietnam\0", "VN\0" },
    { QLocale::Country::WallisAndFutuna, "Wallis & Futuna\0", "WF\0" },
    { QLocale::Country::WesternAfrica, "Western Africa\0", "011\0" },
    { QLocale::Country::WesternAsia, "Western Asia\0", "145\0" },
    { QLocale::Country::WesternEurope, "Western Europe\0", "155\0" },
    { QLocale::Country::WesternSahara, "Western Sahara\0", "EH\0" },
    { QLocale::Country::Yemen, "Yemen\0", "YE\0" },
    { QLocale::Country::Zambia, "Zambia\0", "ZM\0" },
    { QLocale::Country::Zimbabwe, "Zimbabwe\0", "ZW\0" },
    { QLocale::Country::world, "world\0", "001\0" },
};
static const qint16 countryTblSize = sizeof(countryTbl) / sizeof(countryTblData);

static const struct scriptTblData {
    const QLocale::Script script;
    const char* name;
    const char* code;
} scriptTbl[] = {
    { QLocale::Script::AnyScript, "Default\0", nullptr },
    { QLocale::Script::AdlamScript, "Adlam\0", "Adlm\0" },
    { QLocale::Script::AfakaScript, "Afaka\0", "Afak\0" },
    { QLocale::Script::AhomScript, "Ahom\0", "Ahom\0" },
    { QLocale::Script::AnatolianHieroglyphsScript, "Anatolian Hieroglyphs\0", "Hluw\0" },
    { QLocale::Script::ArabicScript, "Arabic\0", "Arab\0" },
    { QLocale::Script::ArmenianScript, "Armenian\0", "Armn\0" },
    { QLocale::Script::AvestanScript, "Avestan\0", "Avst\0" },
    { QLocale::Script::BalineseScript, "Balinese\0", "Bali\0" },
    { QLocale::Script::BamumScript, "Bamum\0", "Bamu\0" },
    { QLocale::Script::BanglaScript, "Bangla\0", "Beng\0" },
    { QLocale::Script::BassaVahScript, "Bassa Vah\0", "Bass\0" },
    { QLocale::Script::BatakScript, "Batak\0", "Batk\0" },
    { QLocale::Script::BhaiksukiScript, "Bhaiksuki\0", "Bhks\0" },
    { QLocale::Script::BlissymbolsScript, "Blissymbols\0", "Blis\0" },
    { QLocale::Script::BookPahlaviScript, "Book Pahlavi\0", "Phlv\0" },
    { QLocale::Script::BopomofoScript, "Bopomofo\0", "Bopo\0" },
    { QLocale::Script::BrahmiScript, "Brahmi\0", "Brah\0" },
    { QLocale::Script::BrailleScript, "Braille\0", "Brai\0" },
    { QLocale::Script::BugineseScript, "Buginese\0", "Bugi\0" },
    { QLocale::Script::BuhidScript, "Buhid\0", "Buhd\0" },
    { QLocale::Script::CarianScript, "Carian\0", "Cari\0" },
    { QLocale::Script::CaucasianAlbanianScript, "Caucasian Albanian\0", "Aghb\0" },
    { QLocale::Script::ChakmaScript, "Chakma\0", "Cakm\0" },
    { QLocale::Script::ChamScript, "Cham\0", "Cham\0" },
    { QLocale::Script::CherokeeScript, "Cherokee\0", "Cher\0" },
    { QLocale::Script::ChorasmianScript, "Chorasmian\0", "Chrs\0" },
    { QLocale::Script::CirthScript, "Cirth\0", "Cirt\0" },
    { QLocale::Script::CopticScript, "Coptic\0", "Copt\0" },
    { QLocale::Script::CypriotScript, "Cypriot\0", "Cprt\0" },
    { QLocale::Script::CyproMinoanScript, "Cypro-Minoan\0", "Cpmn\0" },
    { QLocale::Script::CyrillicScript, "Cyrillic\0", "Cyrl\0" },
    { QLocale::Script::DeseretScript, "Deseret\0", "Dsrt\0" },
    { QLocale::Script::DevanagariScript, "Devanagari\0", "Deva\0" },
    { QLocale::Script::DivesAkuruScript, "Dives Akuru\0", "Diak\0" },
    { QLocale::Script::DograScript, "Dogra\0", "Dogr\0" },
    { QLocale::Script::DuployanshorthandScript, "Duployan shorthand\0", "Dupl\0" },
    { QLocale::Script::EasternSyriacScript, "Eastern Syriac\0", "Syrn\0" },
    { QLocale::Script::EgyptiandemoticScript, "Egyptian demotic\0", "Egyd\0" },
    { QLocale::Script::EgyptianhieraticScript, "Egyptian hieratic\0", "Egyh\0" },
    { QLocale::Script::EgyptianhieroglyphsScript, "Egyptian hieroglyphs\0", "Egyp\0" },
    { QLocale::Script::ElbasanScript, "Elbasan\0", "Elba\0" },
    { QLocale::Script::ElymaicScript, "Elymaic\0", "Elym\0" },
    { QLocale::Script::EmojiScript, "Emoji\0", "Zsye\0" },
    { QLocale::Script::EstrangeloSyriacScript, "Estrangelo Syriac\0", "Syre\0" },
    { QLocale::Script::EthiopicScript, "Ethiopic\0", "Ethi\0" },
    { QLocale::Script::FrakturLatinScript, "Fraktur Latin\0", "Latf\0" },
    { QLocale::Script::FraserScript, "Fraser\0", "Lisu\0" },
    { QLocale::Script::GaelicLatinScript, "Gaelic Latin\0", "Latg\0" },
    { QLocale::Script::GeorgianKhutsuriScript, "Georgian Khutsuri\0", "Geok\0" },
    { QLocale::Script::GeorgianScript, "Georgian\0", "Geor\0" },
    { QLocale::Script::GlagoliticScript, "Glagolitic\0", "Glag\0" },
    { QLocale::Script::GothicScript, "Gothic\0", "Goth\0" },
    { QLocale::Script::GranthaScript, "Grantha\0", "Gran\0" },
    { QLocale::Script::GreekScript, "Greek\0", "Grek\0" },
    { QLocale::Script::GujaratiScript, "Gujarati\0", "Gujr\0" },
    { QLocale::Script::GunjalaGondiScript, "Gunjala Gondi\0", "Gong\0" },
    { QLocale::Script::GurmukhiScript, "Gurmukhi\0", "Guru\0" },
    { QLocale::Script::HanScript, "Han\0", "Hani\0" },
    { QLocale::Script::HangulScript, "Hangul\0", "Hang\0" },
    { QLocale::Script::HanifiRohingyaScript, "Hanifi Rohingya\0", "Rohg\0" },
    { QLocale::Script::HanunooScript, "Hanunoo\0", "Hano\0" },
    { QLocale::Script::HanwithBopomofoScript, "Han with Bopomofo\0", "Hanb\0" },
    { QLocale::Script::HatranScript, "Hatran\0", "Hatr\0" },
    { QLocale::Script::HebrewScript, "Hebrew\0", "Hebr\0" },
    { QLocale::Script::HiraganaScript, "Hiragana\0", "Hira\0" },
    { QLocale::Script::ImperialAramaicScript, "Imperial Aramaic\0", "Armi\0" },
    { QLocale::Script::IndusScript, "Indus\0", "Inds\0" },
    { QLocale::Script::InheritedScript, "Inherited\0", "Zinh\0" },
    { QLocale::Script::InscriptionalPahlaviScript, "Inscriptional Pahlavi\0", "Phli\0" },
    { QLocale::Script::InscriptionalParthianScript, "Inscriptional Parthian\0", "Prti\0" },
    { QLocale::Script::JamoScript, "Jamo\0", "Jamo\0" },
    { QLocale::Script::JapaneseScript, "Japanese\0", "Jpan\0" },
    { QLocale::Script::JapanesesyllabariesScript, "Japanese syllabaries\0", "Hrkt\0" },
    { QLocale::Script::JavaneseScript, "Javanese\0", "Java\0" },
    { QLocale::Script::JurchenScript, "Jurchen\0", "Jurc\0" },
    { QLocale::Script::KaithiScript, "Kaithi\0", "Kthi\0" },
    { QLocale::Script::KannadaScript, "Kannada\0", "Knda\0" },
    { QLocale::Script::KatakanaScript, "Katakana\0", "Kana\0" },
    { QLocale::Script::KawiScript, "Kawi\0", "Kawi\0" },
    { QLocale::Script::KayahLiScript, "Kayah Li\0", "Kali\0" },
    { QLocale::Script::KharoshthiScript, "Kharoshthi\0", "Khar\0" },
    { QLocale::Script::KhitansmallscriptScript, "Khitan small script\0", "Kits\0" },
    { QLocale::Script::KhmerScript, "Khmer\0", "Khmr\0" },
    { QLocale::Script::KhojkiScript, "Khojki\0", "Khoj\0" },
    { QLocale::Script::KhudawadiScript, "Khudawadi\0", "Sind\0" },
    { QLocale::Script::KoreanScript, "Korean\0", "Kore\0" },
    { QLocale::Script::KpelleScript, "Kpelle\0", "Kpel\0" },
    { QLocale::Script::LannaScript, "Lanna\0", "Lana\0" },
    { QLocale::Script::LaoScript, "Lao\0", "Laoo\0" },
    { QLocale::Script::LatinScript, "Latin\0", "Latn\0" },
    { QLocale::Script::LepchaScript, "Lepcha\0", "Lepc\0" },
    { QLocale::Script::LimbuScript, "Limbu\0", "Limb\0" },
    { QLocale::Script::LinearAScript, "Linear A\0", "Lina\0" },
    { QLocale::Script::LinearBScript, "Linear B\0", "Linb\0" },
    { QLocale::Script::LomaScript, "Loma\0", "Loma\0" },
    { QLocale::Script::LycianScript, "Lycian\0", "Lyci\0" },
    { QLocale::Script::LydianScript, "Lydian\0", "Lydi\0" },
    { QLocale::Script::MahajaniScript, "Mahajani\0", "Mahj\0" },
    { QLocale::Script::MakasarScript, "Makasar\0", "Maka\0" },
    { QLocale::Script::MalayalamScript, "Malayalam\0", "Mlym\0" },
    { QLocale::Script::MandaeanScript, "Mandaean\0", "Mand\0" },
    { QLocale::Script::ManichaeanScript, "Manichaean\0", "Mani\0" },
    { QLocale::Script::MarchenScript, "Marchen\0", "Marc\0" },
    { QLocale::Script::MasaramGondiScript, "Masaram Gondi\0", "Gonm\0" },
    { QLocale::Script::MathematicalNotationScript, "Mathematical Notation\0", "Zmth\0" },
    { QLocale::Script::MayanhieroglyphsScript, "Mayan hieroglyphs\0", "Maya\0" },
    { QLocale::Script::MedefaidrinScript, "Medefaidrin\0", "Medf\0" },
    { QLocale::Script::MeiteiMayekScript, "Meitei Mayek\0", "Mtei\0" },
    { QLocale::Script::MendeScript, "Mende\0", "Mend\0" },
    { QLocale::Script::MeroiticCursiveScript, "Meroitic Cursive\0", "Merc\0" },
    { QLocale::Script::MeroiticScript, "Meroitic\0", "Mero\0" },
    { QLocale::Script::ModiScript, "Modi\0", "Modi\0" },
    { QLocale::Script::MongolianScript, "Mongolian\0", "Mong\0" },
    { QLocale::Script::MoonScript, "Moon\0", "Moon\0" },
    { QLocale::Script::MroScript, "Mro\0", "Mroo\0" },
    { QLocale::Script::MultaniScript, "Multani\0", "Mult\0" },
    { QLocale::Script::MyanmarScript, "Myanmar\0", "Mymr\0" },
    { QLocale::Script::NKoScript, "N’Ko\0", "Nkoo\0" },
    { QLocale::Script::NabataeanScript, "Nabataean\0", "Nbat\0" },
    { QLocale::Script::NagMundariScript, "Nag Mundari\0", "Nagm\0" },
    { QLocale::Script::NandinagariScript, "Nandinagari\0", "Nand\0" },
    { QLocale::Script::NastaliqScript, "Nastaliq\0", "Aran\0" },
    { QLocale::Script::NaxiGebaScript, "Naxi Geba\0", "Nkgb\0" },
    { QLocale::Script::NewTaiLueScript, "New Tai Lue\0", "Talu\0" },
    { QLocale::Script::NewaScript, "Newa\0", "Newa\0" },
    { QLocale::Script::NushuScript, "Nüshu\0", "Nshu\0" },
    { QLocale::Script::NyiakengPuachueHmongScript, "Nyiakeng Puachue Hmong\0", "Hmnp\0" },
    { QLocale::Script::OdiaScript, "Odia\0", "Orya\0" },
    { QLocale::Script::OghamScript, "Ogham\0", "Ogam\0" },
    { QLocale::Script::OlChikiScript, "Ol Chiki\0", "Olck\0" },
    { QLocale::Script::OldChurchSlavonicCyrillicScript, "Old Church Slavonic Cyrillic\0", "Cyrs\0" },
    { QLocale::Script::OldHungarianScript, "Old Hungarian\0", "Hung\0" },
    { QLocale::Script::OldItalicScript, "Old Italic\0", "Ital\0" },
    { QLocale::Script::OldNorthArabianScript, "Old North Arabian\0", "Narb\0" },
    { QLocale::Script::OldPermicScript, "Old Permic\0", "Perm\0" },
    { QLocale::Script::OldPersianScript, "Old Persian\0", "Xpeo\0" },
    { QLocale::Script::OldSogdianScript, "Old Sogdian\0", "Sogo\0" },
    { QLocale::Script::OldSouthArabianScript, "Old South Arabian\0", "Sarb\0" },
    { QLocale::Script::OldUyghurScript, "Old Uyghur\0", "Ougr\0" },
    { QLocale::Script::OrkhonScript, "Orkhon\0", "Orkh\0" },
    { QLocale::Script::OsageScript, "Osage\0", "Osge\0" },
    { QLocale::Script::OsmanyaScript, "Osmanya\0", "Osma\0" },
    { QLocale::Script::PahawhHmongScript, "Pahawh Hmong\0", "Hmng\0" },
    { QLocale::Script::PalmyreneScript, "Palmyrene\0", "Palm\0" },
    { QLocale::Script::PauCinHauScript, "Pau Cin Hau\0", "Pauc\0" },
    { QLocale::Script::PhagspaScript, "Phags-pa\0", "Phag\0" },
    { QLocale::Script::PhoenicianScript, "Phoenician\0", "Phnx\0" },
    { QLocale::Script::PollardPhoneticScript, "Pollard Phonetic\0", "Plrd\0" },
    { QLocale::Script::PsalterPahlaviScript, "Psalter Pahlavi\0", "Phlp\0" },
    { QLocale::Script::RejangScript, "Rejang\0", "Rjng\0" },
    { QLocale::Script::RongorongoScript, "Rongorongo\0", "Roro\0" },
    { QLocale::Script::RunicScript, "Runic\0", "Runr\0" },
    { QLocale::Script::SACuneiformScript, "S-A Cuneiform\0", "Xsux\0" },
    { QLocale::Script::SamaritanScript, "Samaritan\0", "Samr\0" },
    { QLocale::Script::SaratiScript, "Sarati\0", "Sara\0" },
    { QLocale::Script::SaurashtraScript, "Saurashtra\0", "Saur\0" },
    { QLocale::Script::SharadaScript, "Sharada\0", "Shrd\0" },
    { QLocale::Script::ShavianScript, "Shavian\0", "Shaw\0" },
    { QLocale::Script::SiddhamScript, "Siddham\0", "Sidd\0" },
    { QLocale::Script::SignWritingScript, "SignWriting\0", "Sgnw\0" },
    { QLocale::Script::SimplifiedHanScript, "Simplified Han\0", "Hans\0" },
    { QLocale::Script::SinhalaScript, "Sinhala\0", "Sinh\0" },
    { QLocale::Script::SogdianScript, "Sogdian\0", "Sogd\0" },
    { QLocale::Script::SoraSompengScript, "Sora Sompeng\0", "Sora\0" },
    { QLocale::Script::SoyomboScript, "Soyombo\0", "Soyo\0" },
    { QLocale::Script::SundaneseScript, "Sundanese\0", "Sund\0" },
    { QLocale::Script::SylotiNagriScript, "Syloti Nagri\0", "Sylo\0" },
    { QLocale::Script::SymbolsScript, "Symbols\0", "Zsym\0" },
    { QLocale::Script::SyriacScript, "Syriac\0", "Syrc\0" },
    { QLocale::Script::TagalogScript, "Tagalog\0", "Tglg\0" },
    { QLocale::Script::TagbanwaScript, "Tagbanwa\0", "Tagb\0" },
    { QLocale::Script::TaiLeScript, "Tai Le\0", "Tale\0" },
    { QLocale::Script::TaiVietScript, "Tai Viet\0", "Tavt\0" },
    { QLocale::Script::TakriScript, "Takri\0", "Takr\0" },
    { QLocale::Script::TamilScript, "Tamil\0", "Taml\0" },
    { QLocale::Script::TangsaScript, "Tangsa\0", "Tnsa\0" },
    { QLocale::Script::TangutScript, "Tangut\0", "Tang\0" },
    { QLocale::Script::TeluguScript, "Telugu\0", "Telu\0" },
    { QLocale::Script::TengwarScript, "Tengwar\0", "Teng\0" },
    { QLocale::Script::ThaanaScript, "Thaana\0", "Thaa\0" },
    { QLocale::Script::ThaiScript, "Thai\0", "Thai\0" },
    { QLocale::Script::TibetanScript, "Tibetan\0", "Tibt\0" },
    { QLocale::Script::TifinaghScript, "Tifinagh\0", "Tfng\0" },
    { QLocale::Script::TirhutaScript, "Tirhuta\0", "Tirh\0" },
    { QLocale::Script::TotoScript, "Toto\0", "Toto\0" },
    { QLocale::Script::TraditionalHanScript, "Traditional Han\0", "Hant\0" },
    { QLocale::Script::UCASScript, "UCAS\0", "Cans\0" },
    { QLocale::Script::UgariticScript, "Ugaritic\0", "Ugar\0" },
    { QLocale::Script::UnwrittenScript, "Unwritten\0", "Zxxx\0" },
    { QLocale::Script::VaiScript, "Vai\0", "Vaii\0" },
    { QLocale::Script::VarangKshitiScript, "Varang Kshiti\0", "Wara\0" },
    { QLocale::Script::VisibleSpeechScript, "Visible Speech\0", "Visp\0" },
    { QLocale::Script::VithkuqiScript, "Vithkuqi\0", "Vith\0" },
    { QLocale::Script::WanchoScript, "Wancho\0", "Wcho\0" },
    { QLocale::Script::WesternSyriacScript, "Western Syriac\0", "Syrj\0" },
    { QLocale::Script::WoleaiScript, "Woleai\0", "Wole\0" },
    { QLocale::Script::YezidiScript, "Yezidi\0", "Yezi\0" },
    { QLocale::Script::YiScript, "Yi\0", "Yiii\0" },
    { QLocale::Script::ZanabazarSquareScript, "Zanabazar Square\0", "Zanb\0" },
    { QLocale::Script::ZawgyiScript, "Zawgyi\0", "Qaag\0" },
};
static const qint16 scriptTblSize = sizeof(scriptTbl) / sizeof(scriptTblData);

static const QLocalePrivate localeTbl[] = {
    {
        QLocale::Language::C, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 101, 48,
        nullptr, nullptr,
        "d MMM yyyy\0", "d MMMM yyyy\0", "HH:mm:ss\0", "HH:mm:ss z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // C
    {
        QLocale::Language::Afrikaans, QLocale::Script::LatinScript, QLocale::Country::Namibia,
        Qt::Saturday, Qt::Thursday, Qt::Friday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Afrikaans\0", "Namibië\0",
        "yyyy-MM-dd\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "vm.\0", "nm.\0",
        { "Jan.\0", "Feb.\0", "Mrt.\0", "Apr.\0", "Mei\0", "Jun.\0", "Jul.\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Des.\0" },
        { "Januarie\0", "Februarie\0", "Maart\0", "April\0", "Mei\0", "Junie\0", "Julie\0", "Augustus\0", "September\0", "Oktober\0", "November\0", "Desember\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan.\0", "Feb.\0", "Mrt.\0", "Apr.\0", "Mei\0", "Jun.\0", "Jul.\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Des.\0" },
        { "Januarie\0", "Februarie\0", "Maart\0", "April\0", "Mei\0", "Junie\0", "Julie\0", "Augustus\0", "September\0", "Oktober\0", "November\0", "Desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Ma.\0", "Di.\0", "Wo.\0", "Do.\0", "Vr.\0", "Sa.\0", "So.\0" },
        { "Maandag\0", "Dinsdag\0", "Woensdag\0", "Donderdag\0", "Vrydag\0", "Saterdag\0", "Sondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "S\0", "S\0" },
        { "Ma.\0", "Di.\0", "Wo.\0", "Do.\0", "Vr.\0", "Sa.\0", "So.\0" },
        { "Maandag\0", "Dinsdag\0", "Woensdag\0", "Donderdag\0", "Vrydag\0", "Saterdag\0", "Sondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "S\0", "S\0" }
    }, // af_NA
    {
        QLocale::Language::Afrikaans, QLocale::Script::LatinScript, QLocale::Country::SouthAfrica,
        Qt::Saturday, Qt::Thursday, Qt::Friday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Afrikaans\0", "Suid-Afrika\0",
        "yyyy-MM-dd\0", "dd MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "vm.\0", "nm.\0",
        { "Jan.\0", "Feb.\0", "Mrt.\0", "Apr.\0", "Mei\0", "Jun.\0", "Jul.\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Des.\0" },
        { "Januarie\0", "Februarie\0", "Maart\0", "April\0", "Mei\0", "Junie\0", "Julie\0", "Augustus\0", "September\0", "Oktober\0", "November\0", "Desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan.\0", "Feb.\0", "Mrt.\0", "Apr.\0", "Mei\0", "Jun.\0", "Jul.\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Des.\0" },
        { "Januarie\0", "Februarie\0", "Maart\0", "April\0", "Mei\0", "Junie\0", "Julie\0", "Augustus\0", "September\0", "Oktober\0", "November\0", "Desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Ma.\0", "Di.\0", "Wo.\0", "Do.\0", "Vr.\0", "Sa.\0", "So.\0" },
        { "Maandag\0", "Dinsdag\0", "Woensdag\0", "Donderdag\0", "Vrydag\0", "Saterdag\0", "Sondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "S\0", "S\0" },
        { "Ma.\0", "Di.\0", "Wo.\0", "Do.\0", "Vr.\0", "Sa.\0", "So.\0" },
        { "Maandag\0", "Dinsdag\0", "Woensdag\0", "Donderdag\0", "Vrydag\0", "Saterdag\0", "Sondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "S\0", "S\0" }
    }, // af_ZA
    {
        QLocale::Language::Aghem, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Aghem\0", "Kàmàlûŋ\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.g\0", "a.k\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "n\0", "k\0", "t\0", "t\0", "s\0", "z\0", "k\0", "f\0", "d\0", "l\0", "c\0", "f\0" },
        { "nùm\0", "kɨz\0", "tɨd\0", "taa\0", "see\0", "nzu\0", "dum\0", "fɔe\0", "dzu\0", "lɔm\0", "kaa\0", "fwo\0" },
        { "ndzɔ̀ŋɔ̀nùm\0", "ndzɔ̀ŋɔ̀kƗ̀zùʔ\0", "ndzɔ̀ŋɔ̀tƗ̀dʉ̀ghà\0", "ndzɔ̀ŋɔ̀tǎafʉ̄ghā\0", "ndzɔ̀ŋèsèe\0", "ndzɔ̀ŋɔ̀nzùghò\0", "ndzɔ̀ŋɔ̀dùmlo\0", "ndzɔ̀ŋɔ̀kwîfɔ̀e\0", "ndzɔ̀ŋɔ̀tƗ̀fʉ̀ghàdzughù\0", "ndzɔ̀ŋɔ̀ghǔuwelɔ̀m\0", "ndzɔ̀ŋɔ̀chwaʔàkaa wo\0", "ndzɔ̀ŋèfwòo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "k\0", "g\0", "t\0", "u\0", "g\0", "d\0", "n\0" },
        { "kpa\0", "ghɔ\0", "tɔm\0", "ume\0", "ghɨ\0", "dzk\0", "nts\0" },
        { "tsuʔukpà\0", "tsuʔughɔe\0", "tsuʔutɔ̀mlò\0", "tsuʔumè\0", "tsuʔughɨ̂m\0", "tsuʔndzɨkɔʔɔ\0", "tsuʔntsɨ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // agq_CM
    {
        QLocale::Language::Akan, QLocale::Script::LatinScript, QLocale::Country::Ghana,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Akan\0", "Gaana\0",
        "yyyy/MM/dd\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AN\0", "EW\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "S-Ɔ\0", "K-Ɔ\0", "E-Ɔ\0", "E-O\0", "E-K\0", "O-A\0", "A-K\0", "D-Ɔ\0", "F-Ɛ\0", "Ɔ-A\0", "Ɔ-O\0", "M-Ɔ\0" },
        { "Sanda-Ɔpɛpɔn\0", "Kwakwar-Ɔgyefuo\0", "Ebɔw-Ɔbenem\0", "Ebɔbira-Oforisuo\0", "Esusow Aketseaba-Kɔtɔnimba\0", "Obirade-Ayɛwohomumu\0", "Ayɛwoho-Kitawonsa\0", "Difuu-Ɔsandaa\0", "Fankwa-Ɛbɔ\0", "Ɔbɛsɛ-Ahinime\0", "Ɔberɛfɛw-Obubuo\0", "Mumu-Ɔpɛnimba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "D\0", "B\0", "W\0", "Y\0", "F\0", "M\0", "K\0" },
        { "Dwo\0", "Ben\0", "Wuk\0", "Yaw\0", "Fia\0", "Mem\0", "Kwe\0" },
        { "Dwowda\0", "Benada\0", "Wukuda\0", "Yawda\0", "Fida\0", "Memeneda\0", "Kwesida\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ak_GH
    {
        QLocale::Language::Amharic, QLocale::Script::EthiopicScript, QLocale::Country::Ethiopia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "አማርኛ\0", "ኢትዮጵያ\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "ጥዋት\0", "ከሰዓት\0",
        { "ጃንዩ\0", "ፌብሩ\0", "ማርች\0", "ኤፕሪ\0", "ሜይ\0", "ጁን\0", "ጁላይ\0", "ኦገስ\0", "ሴፕቴ\0", "ኦክቶ\0", "ኖቬም\0", "ዲሴም\0" },
        { "ጃንዩወሪ\0", "ፌብሩወሪ\0", "ማርች\0", "ኤፕሪል\0", "ሜይ\0", "ጁን\0", "ጁላይ\0", "ኦገስት\0", "ሴፕቴምበር\0", "ኦክቶበር\0", "ኖቬምበር\0", "ዲሴምበር\0" },
        { "ጃ\0", "ፌ\0", "ማ\0", "ኤ\0", "ሜ\0", "ጁ\0", "ጁ\0", "ኦ\0", "ሴ\0", "ኦ\0", "ኖ\0", "ዲ\0" },
        { "ጃንዩ\0", "ፌብሩ\0", "ማርች\0", "ኤፕሪ\0", "ሜይ\0", "ጁን\0", "ጁላይ\0", "ኦገስ\0", "ሴፕቴ\0", "ኦክቶ\0", "ኖቬም\0", "ዲሴም\0" },
        { "ጃንዩወሪ\0", "ፌብሩወሪ\0", "ማርች\0", "ኤፕሪል\0", "ሜይ\0", "ጁን\0", "ጁላይ\0", "ኦገስት\0", "ሴፕቴምበር\0", "ኦክቶበር\0", "ኖቬምበር\0", "ዲሴምበር\0" },
        { "ጃ\0", "ፌ\0", "ማ\0", "ኤ\0", "ሜ\0", "ጁ\0", "ጁ\0", "ኦ\0", "ሴ\0", "ኦ\0", "ኖ\0", "ዲ\0" },
        { "ሰኞ\0", "ማክሰ\0", "ረቡዕ\0", "ሐሙስ\0", "ዓርብ\0", "ቅዳሜ\0", "እሑድ\0" },
        { "ሰኞ\0", "ማክሰኞ\0", "ረቡዕ\0", "ሐሙስ\0", "ዓርብ\0", "ቅዳሜ\0", "እሑድ\0" },
        { "ሰ\0", "ማ\0", "ረ\0", "ሐ\0", "ዓ\0", "ቅ\0", "እ\0" },
        { "ሰኞ\0", "ማክሰ\0", "ረቡዕ\0", "ሐሙስ\0", "ዓርብ\0", "ቅዳሜ\0", "እሑድ\0" },
        { "ሰኞ\0", "ማክሰኞ\0", "ረቡዕ\0", "ሐሙስ\0", "ዓርብ\0", "ቅዳሜ\0", "እሑድ\0" },
        { "ሰ\0", "ማ\0", "ረ\0", "ሐ\0", "ዓ\0", "ቅ\0", "እ\0" }
    }, // am_ET
    {
        QLocale::Language::Arabic, QLocale::Script::AnyScript, QLocale::Country::world,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "العالم\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_001
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::UnitedArabEmirates,
        Qt::Saturday, Qt::Saturday, Qt::Sunday,
        46, 44, 1563, 37, 45, 43, 69, 48,
        "العربية\0", "الإمارات العربية المتحدة\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_AE
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Bahrain,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "البحرين\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_BH
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Djibouti,
        Qt::Saturday, Qt::Saturday, Qt::Sunday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "جيبوتي\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_DJ
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Algeria,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        44, 46, 1563, 37, 45, 43, 69, 48,
        "العربية\0", "الجزائر\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "جانفي\0", "فيفري\0", "مارس\0", "أفريل\0", "ماي\0", "جوان\0", "جويلية\0", "أوت\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "جانفي\0", "فيفري\0", "مارس\0", "أفريل\0", "ماي\0", "جوان\0", "جويلية\0", "أوت\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ج\0", "ف\0", "م\0", "أ\0", "م\0", "ج\0", "ج\0", "أ\0", "س\0", "أ\0", "ن\0", "د\0" },
        { "جانفي\0", "فيفري\0", "مارس\0", "أفريل\0", "ماي\0", "جوان\0", "جويلية\0", "أوت\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "جانفي\0", "فيفري\0", "مارس\0", "أفريل\0", "ماي\0", "جوان\0", "جويلية\0", "أوت\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ج\0", "ف\0", "م\0", "أ\0", "م\0", "ج\0", "ج\0", "أ\0", "س\0", "أ\0", "ن\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_DZ
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Egypt,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "مصر\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_EG
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::WesternSahara,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 1563, 37, 45, 43, 69, 48,
        "العربية\0", "الصحراء الغربية\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_EH
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Eritrea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "إريتريا\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_ER
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Israel,
        Qt::Monday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "إسرائيل\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "H:mm\0", "H:mm:ss Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_IL
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Iraq,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "العراق\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "ك\0", "ش\0", "آ\0", "ن\0", "أ\0", "ح\0", "ت\0", "آ\0", "أ\0", "ت\0", "ت\0", "ك\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "ك\0", "ش\0", "آ\0", "ن\0", "أ\0", "ح\0", "ت\0", "آ\0", "أ\0", "ت\0", "ت\0", "ك\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_IQ
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Jordan,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "الأردن\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "ك\0", "ش\0", "آ\0", "ن\0", "أ\0", "ح\0", "ت\0", "آ\0", "أ\0", "ت\0", "ت\0", "ك\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "ك\0", "ش\0", "آ\0", "ن\0", "أ\0", "ح\0", "ت\0", "آ\0", "أ\0", "ت\0", "ت\0", "ك\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_JO
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Comoros,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "جزر القمر\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_KM
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Kuwait,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "الكويت\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_KW
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Lebanon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "لبنان\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "ك\0", "ش\0", "آ\0", "ن\0", "أ\0", "ح\0", "ت\0", "آ\0", "أ\0", "ت\0", "ت\0", "ك\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "ك\0", "ش\0", "آ\0", "ن\0", "أ\0", "ح\0", "ت\0", "آ\0", "أ\0", "ت\0", "ت\0", "ك\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_LB
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Libya,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        44, 46, 1563, 37, 45, 43, 69, 48,
        "العربية\0", "ليبيا\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_LY
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Morocco,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 1563, 37, 45, 43, 69, 48,
        "العربية\0", "المغرب\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "ماي\0", "يونيو\0", "يوليوز\0", "غشت\0", "شتنبر\0", "أكتوبر\0", "نونبر\0", "دجنبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "ماي\0", "يونيو\0", "يوليوز\0", "غشت\0", "شتنبر\0", "أكتوبر\0", "نونبر\0", "دجنبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "م\0", "ن\0", "ل\0", "غ\0", "ش\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "ماي\0", "يونيو\0", "يوليوز\0", "غشت\0", "شتنبر\0", "أكتوبر\0", "نونبر\0", "دجنبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "ماي\0", "يونيو\0", "يوليوز\0", "غشت\0", "شتنبر\0", "أكتوبر\0", "نونبر\0", "دجنبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "م\0", "ن\0", "ل\0", "غ\0", "ش\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_MA
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Mauritania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "موريتانيا\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "إبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغشت\0", "شتمبر\0", "أكتوبر\0", "نوفمبر\0", "دجمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "إبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغشت\0", "شتمبر\0", "أكتوبر\0", "نوفمبر\0", "دجمبر\0" },
        { "ي\0", "ف\0", "م\0", "إ\0", "و\0", "ن\0", "ل\0", "غ\0", "ش\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "إبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغشت\0", "شتمبر\0", "أكتوبر\0", "نوفمبر\0", "دجمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "إبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغشت\0", "شتمبر\0", "أكتوبر\0", "نوفمبر\0", "دجمبر\0" },
        { "ي\0", "ف\0", "م\0", "إ\0", "و\0", "ن\0", "ل\0", "غ\0", "ش\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_MR
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Oman,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "عُمان\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_OM
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::PalestinianTerritories,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "الأراضي الفلسطينية\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "ك\0", "ش\0", "آ\0", "ن\0", "أ\0", "ح\0", "ت\0", "آ\0", "أ\0", "ت\0", "ت\0", "ك\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "ك\0", "ش\0", "آ\0", "ن\0", "أ\0", "ح\0", "ت\0", "آ\0", "أ\0", "ت\0", "ت\0", "ك\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_PS
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Qatar,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "قطر\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_QA
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::SaudiArabia,
        Qt::Monday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "المملكة العربية السعودية\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_SA
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Sudan,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "السودان\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_SD
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Somalia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "الصومال\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمع\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_SO
    {
        QLocale::Language::Arabic, QLocale::Script::AnyScript, QLocale::Country::SouthSudan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "جنوب السودان\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_SS
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Syria,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "سوريا\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "ك\0", "ش\0", "آ\0", "ن\0", "أ\0", "ح\0", "ت\0", "آ\0", "أ\0", "ت\0", "ت\0", "ك\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "كانون الثاني\0", "شباط\0", "آذار\0", "نيسان\0", "أيار\0", "حزيران\0", "تموز\0", "آب\0", "أيلول\0", "تشرين الأول\0", "تشرين الثاني\0", "كانون الأول\0" },
        { "ك\0", "ش\0", "آ\0", "ن\0", "أ\0", "ح\0", "ت\0", "آ\0", "أ\0", "ت\0", "ت\0", "ك\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_SY
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Chad,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "تشاد\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_TD
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Tunisia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 1563, 37, 45, 43, 69, 48,
        "العربية\0", "تونس\0",
        "d‏/M‏/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "جانفي\0", "فيفري\0", "مارس\0", "أفريل\0", "ماي\0", "جوان\0", "جويلية\0", "أوت\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "جانفي\0", "فيفري\0", "مارس\0", "أفريل\0", "ماي\0", "جوان\0", "جويلية\0", "أوت\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ج\0", "ف\0", "م\0", "أ\0", "م\0", "ج\0", "ج\0", "أ\0", "س\0", "أ\0", "ن\0", "د\0" },
        { "جانفي\0", "فيفري\0", "مارس\0", "أفريل\0", "ماي\0", "جوان\0", "جويلية\0", "أوت\0", "سبتمبر\0", "أكتوبر\0", "نفمبر\0", "ديسمبر\0" },
        { "جانفي\0", "فيفري\0", "مارس\0", "أفريل\0", "ماي\0", "جوان\0", "جويلية\0", "أوت\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ج\0", "ف\0", "م\0", "أ\0", "م\0", "ج\0", "ج\0", "أ\0", "س\0", "أ\0", "ن\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_TN
    {
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Yemen,
        Qt::Monday, Qt::Friday, Qt::Saturday,
        1643, 1644, 1563, 37, 45, 43, 69, 1632,
        "العربية\0", "اليمن\0",
        "d‏/M‏/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صباحًا\0", "مساءً\0",
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "يناير\0", "فبراير\0", "مارس\0", "أبريل\0", "مايو\0", "يونيو\0", "يوليو\0", "أغسطس\0", "سبتمبر\0", "أكتوبر\0", "نوفمبر\0", "ديسمبر\0" },
        { "ي\0", "ف\0", "م\0", "أ\0", "و\0", "ن\0", "ل\0", "غ\0", "س\0", "ك\0", "ب\0", "د\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "الاثنين\0", "الثلاثاء\0", "الأربعاء\0", "الخميس\0", "الجمعة\0", "السبت\0", "الأحد\0" },
        { "ن\0", "ث\0", "ر\0", "خ\0", "ج\0", "س\0", "ح\0" }
    }, // ar_YE
    {
        QLocale::Language::Assamese, QLocale::Script::BanglaScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 2534,
        "অসমীয়া\0", "ভাৰত\0",
        "d-M-yyyy\0", "d MMMM, yyyy\0", "AP h.mm\0", "AP h.mm.ss Z\0",
        "পূৰ্বাহ্ন\0", "অপৰাহ্ন\0",
        { "জানু\0", "ফেব্ৰু\0", "মাৰ্চ\0", "এপ্ৰিল\0", "মে’\0", "জুন\0", "জুলাই\0", "আগ\0", "ছেপ্তে\0", "অক্টো\0", "নৱে\0", "ডিচে\0" },
        { "জানুৱাৰী\0", "ফেব্ৰুৱাৰী\0", "মাৰ্চ\0", "এপ্ৰিল\0", "মে’\0", "জুন\0", "জুলাই\0", "আগষ্ট\0", "ছেপ্তেম্বৰ\0", "অক্টোবৰ\0", "নৱেম্বৰ\0", "ডিচেম্বৰ\0" },
        { "জ\0", "ফ\0", "ম\0", "এ\0", "ম\0", "জ\0", "জ\0", "আ\0", "ছ\0", "অ\0", "ন\0", "ড\0" },
        { "জানু\0", "ফেব্ৰু\0", "মাৰ্চ\0", "এপ্ৰিল\0", "মে’\0", "জুন\0", "জুলাই\0", "আগ\0", "ছেপ্তে\0", "অক্টো\0", "নৱে\0", "ডিচে\0" },
        { "জানুৱাৰী\0", "ফেব্ৰুৱাৰী\0", "মাৰ্চ\0", "এপ্ৰিল\0", "মে’\0", "জুন\0", "জুলাই\0", "আগষ্ট\0", "ছেপ্তেম্বৰ\0", "অক্টোবৰ\0", "নৱেম্বৰ\0", "ডিচেম্বৰ\0" },
        { "জ\0", "ফ\0", "ম\0", "এ\0", "ম\0", "জ\0", "জ\0", "আ\0", "ছ\0", "অ\0", "ন\0", "ড\0" },
        { "সোম\0", "মঙ্গল\0", "বুধ\0", "বৃহ\0", "শুক্ৰ\0", "শনি\0", "দেও\0" },
        { "সোমবাৰ\0", "মঙ্গলবাৰ\0", "বুধবাৰ\0", "বৃহস্পতিবাৰ\0", "শুক্ৰবাৰ\0", "শনিবাৰ\0", "দেওবাৰ\0" },
        { "স\0", "ম\0", "ব\0", "ব\0", "শ\0", "শ\0", "দ\0" },
        { "সোম\0", "মঙ্গল\0", "বুধ\0", "বৃহ\0", "শুক্ৰ\0", "শনি\0", "দেও\0" },
        { "সোমবাৰ\0", "মঙ্গলবাৰ\0", "বুধবাৰ\0", "বৃহস্পতিবাৰ\0", "শুক্ৰবাৰ\0", "শনিবাৰ\0", "দেওবাৰ\0" },
        { "স\0", "ম\0", "ব\0", "ব\0", "শ\0", "শ\0", "দ\0" }
    }, // as_IN
    {
        QLocale::Language::Asu, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kipare\0", "Tadhania\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "icheheavo\0", "ichamthi\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Dec\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "J\0", "J\0", "J\0", "A\0", "I\0", "J\0", "J\0" },
        { "Jtt\0", "Jnn\0", "Jtn\0", "Alh\0", "Ijm\0", "Jmo\0", "Jpi\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // asa_TZ
    {
        QLocale::Language::Asturian, QLocale::Script::LatinScript, QLocale::Country::Spain,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "asturianu\0", "España\0",
        "d/M/yyyy\0", "d MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "mañana\0", "tarde\0",
        { "Xin\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Xun\0", "Xnt\0", "Ago\0", "Set\0", "Och\0", "Pay\0", "Avi\0" },
        { "xineru\0", "febreru\0", "marzu\0", "abril\0", "mayu\0", "xunu\0", "xunetu\0", "agostu\0", "setiembre\0", "ochobre\0", "payares\0", "avientu\0" },
        { "X\0", "F\0", "M\0", "A\0", "M\0", "X\0", "X\0", "A\0", "S\0", "O\0", "P\0", "A\0" },
        { "xin\0", "feb\0", "mar\0", "abr\0", "may\0", "xun\0", "xnt\0", "ago\0", "set\0", "och\0", "pay\0", "avi\0" },
        { "de xineru\0", "de febreru\0", "de marzu\0", "d’abril\0", "de mayu\0", "de xunu\0", "de xunetu\0", "d’agostu\0", "de setiembre\0", "d’ochobre\0", "de payares\0", "d’avientu\0" },
        { "X\0", "F\0", "M\0", "A\0", "M\0", "X\0", "X\0", "A\0", "S\0", "O\0", "P\0", "A\0" },
        { "llu\0", "mar\0", "mié\0", "xue\0", "vie\0", "sáb\0", "dom\0" },
        { "llunes\0", "martes\0", "miércoles\0", "xueves\0", "vienres\0", "sábadu\0", "domingu\0" },
        { "L\0", "M\0", "M\0", "X\0", "V\0", "S\0", "D\0" },
        { "llu\0", "mar\0", "mié\0", "xue\0", "vie\0", "sáb\0", "dom\0" },
        { "llunes\0", "martes\0", "miércoles\0", "xueves\0", "vienres\0", "sábadu\0", "domingu\0" },
        { "L\0", "M\0", "M\0", "X\0", "V\0", "S\0", "D\0" }
    }, // ast_ES
    {
        QLocale::Language::Azerbaijani, QLocale::Script::CyrillicScript, QLocale::Country::Azerbaijan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "azərbaycan\0", "Azərbaycan\0",
        "dd.MM.yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "yan\0", "fev\0", "mar\0", "apr\0", "may\0", "iyn\0", "iyl\0", "avq\0", "sen\0", "okt\0", "noy\0", "dek\0" },
        { "yanvar\0", "fevral\0", "mart\0", "aprel\0", "may\0", "iyun\0", "iyul\0", "avqust\0", "sentyabr\0", "oktyabr\0", "noyabr\0", "dekabr\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "yan\0", "fev\0", "mar\0", "apr\0", "may\0", "iyn\0", "iyl\0", "avq\0", "sen\0", "okt\0", "noy\0", "dek\0" },
        { "yanvar\0", "fevral\0", "mart\0", "aprel\0", "may\0", "iyun\0", "iyul\0", "avqust\0", "sentyabr\0", "oktyabr\0", "noyabr\0", "dekabr\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "B.E.\0", "Ç.A.\0", "Ç.\0", "C.A.\0", "C.\0", "Ş.\0", "B.\0" },
        { "bazar ertəsi\0", "çərşənbə axşamı\0", "çərşənbə\0", "cümə axşamı\0", "cümə\0", "şənbə\0", "bazar\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" },
        { "B.e.\0", "Ç.a.\0", "Ç.\0", "C.a.\0", "C.\0", "Ş.\0", "B.\0" },
        { "bazar ertəsi\0", "çərşənbə axşamı\0", "çərşənbə\0", "cümə axşamı\0", "cümə\0", "şənbə\0", "bazar\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // az_Cyrl_AZ
    {
        QLocale::Language::Azerbaijani, QLocale::Script::LatinScript, QLocale::Country::Azerbaijan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "azərbaycan\0", "Azərbaycan\0",
        "dd.MM.yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "yan\0", "fev\0", "mar\0", "apr\0", "may\0", "iyn\0", "iyl\0", "avq\0", "sen\0", "okt\0", "noy\0", "dek\0" },
        { "yanvar\0", "fevral\0", "mart\0", "aprel\0", "may\0", "iyun\0", "iyul\0", "avqust\0", "sentyabr\0", "oktyabr\0", "noyabr\0", "dekabr\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "yan\0", "fev\0", "mar\0", "apr\0", "may\0", "iyn\0", "iyl\0", "avq\0", "sen\0", "okt\0", "noy\0", "dek\0" },
        { "yanvar\0", "fevral\0", "mart\0", "aprel\0", "may\0", "iyun\0", "iyul\0", "avqust\0", "sentyabr\0", "oktyabr\0", "noyabr\0", "dekabr\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "B.E.\0", "Ç.A.\0", "Ç.\0", "C.A.\0", "C.\0", "Ş.\0", "B.\0" },
        { "bazar ertəsi\0", "çərşənbə axşamı\0", "çərşənbə\0", "cümə axşamı\0", "cümə\0", "şənbə\0", "bazar\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" },
        { "B.e.\0", "Ç.a.\0", "Ç.\0", "C.a.\0", "C.\0", "Ş.\0", "B.\0" },
        { "bazar ertəsi\0", "çərşənbə axşamı\0", "çərşənbə\0", "cümə axşamı\0", "cümə\0", "şənbə\0", "bazar\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // az_Latn_AZ
    {
        QLocale::Language::Basaa, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Ɓàsàa\0", "Kàmɛ̀rûn\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "I bikɛ̂glà\0", "I ɓugajɔp\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "k\0", "m\0", "m\0", "m\0", "m\0", "h\0", "n\0", "h\0", "d\0", "b\0", "m\0", "l\0" },
        { "kɔn\0", "mac\0", "mat\0", "mto\0", "mpu\0", "hil\0", "nje\0", "hik\0", "dip\0", "bio\0", "may\0", "liɓ\0" },
        { "Kɔndɔŋ\0", "Màcɛ̂l\0", "Màtùmb\0", "Màtop\0", "M̀puyɛ\0", "Hìlòndɛ̀\0", "Njèbà\0", "Hìkaŋ\0", "Dìpɔ̀s\0", "Bìòôm\0", "Màyɛsèp\0", "Lìbuy li ńyèe\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "n\0", "u\0", "ŋ\0", "m\0", "k\0", "j\0", "n\0" },
        { "nja\0", "uum\0", "ŋge\0", "mbɔ\0", "kɔɔ\0", "jon\0", "nɔy\0" },
        { "ŋgwà njaŋgumba\0", "ŋgwà ûm\0", "ŋgwà ŋgê\0", "ŋgwà mbɔk\0", "ŋgwà kɔɔ\0", "ŋgwà jôn\0", "ŋgwà nɔ̂y\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // bas_CM
    {
        QLocale::Language::Belarusian, QLocale::Script::CyrillicScript, QLocale::Country::Belarus,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "беларуская\0", "Беларусь\0",
        "d.MM.yyyy\0", "d MMMM yyyy 'г'.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "сту\0", "лют\0", "сак\0", "кра\0", "май\0", "чэр\0", "ліп\0", "жні\0", "вер\0", "кас\0", "ліс\0", "сне\0" },
        { "студзень\0", "люты\0", "сакавік\0", "красавік\0", "май\0", "чэрвень\0", "ліпень\0", "жнівень\0", "верасень\0", "кастрычнік\0", "лістапад\0", "снежань\0" },
        { "с\0", "л\0", "с\0", "к\0", "м\0", "ч\0", "л\0", "ж\0", "в\0", "к\0", "л\0", "с\0" },
        { "сту\0", "лют\0", "сак\0", "кра\0", "мая\0", "чэр\0", "ліп\0", "жні\0", "вер\0", "кас\0", "ліс\0", "сне\0" },
        { "студзеня\0", "лютага\0", "сакавіка\0", "красавіка\0", "мая\0", "чэрвеня\0", "ліпеня\0", "жніўня\0", "верасня\0", "кастрычніка\0", "лістапада\0", "снежня\0" },
        { "с\0", "л\0", "с\0", "к\0", "м\0", "ч\0", "л\0", "ж\0", "в\0", "к\0", "л\0", "с\0" },
        { "пн\0", "аў\0", "ср\0", "чц\0", "пт\0", "сб\0", "нд\0" },
        { "панядзелак\0", "аўторак\0", "серада\0", "чацвер\0", "пятніца\0", "субота\0", "нядзеля\0" },
        { "п\0", "а\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пн\0", "аў\0", "ср\0", "чц\0", "пт\0", "сб\0", "нд\0" },
        { "панядзелак\0", "аўторак\0", "серада\0", "чацвер\0", "пятніца\0", "субота\0", "нядзеля\0" },
        { "п\0", "а\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // be_BY
    {
        QLocale::Language::Bemba, QLocale::Script::LatinScript, QLocale::Country::Zambia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Ichibemba\0", "Zambia\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "uluchelo\0", "akasuba\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "E\0", "M\0", "J\0", "J\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Epr\0", "Mei\0", "Jun\0", "Jul\0", "Oga\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Epreo\0", "Mei\0", "Juni\0", "Julai\0", "Ogasti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Disemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Palichimo\0", "Palichibuli\0", "Palichitatu\0", "Palichine\0", "Palichisano\0", "Pachibelushi\0", "Pa Mulungu\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // bem_ZM
    {
        QLocale::Language::Bena, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Hibena\0", "Hutanzania\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "pamilau\0", "pamunyi\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "H\0", "V\0", "D\0", "T\0", "H\0", "S\0", "S\0", "N\0", "T\0", "K\0", "K\0", "K\0" },
        { "Hut\0", "Vil\0", "Dat\0", "Tai\0", "Han\0", "Sit\0", "Sab\0", "Nan\0", "Tis\0", "Kum\0", "Kmj\0", "Kmb\0" },
        { "pa mwedzi gwa hutala\0", "pa mwedzi gwa wuvili\0", "pa mwedzi gwa wudatu\0", "pa mwedzi gwa wutai\0", "pa mwedzi gwa wuhanu\0", "pa mwedzi gwa sita\0", "pa mwedzi gwa saba\0", "pa mwedzi gwa nane\0", "pa mwedzi gwa tisa\0", "pa mwedzi gwa kumi\0", "pa mwedzi gwa kumi na moja\0", "pa mwedzi gwa kumi na mbili\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "J\0", "H\0", "H\0", "H\0", "W\0", "J\0", "M\0" },
        { "Vil\0", "Hiv\0", "Hid\0", "Hit\0", "Hih\0", "Lem\0", "Mul\0" },
        { "pa shahuviluha\0", "pa hivili\0", "pa hidatu\0", "pa hitayi\0", "pa hihanu\0", "pa shahulembela\0", "pa mulungu\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // bez_TZ
    {
        QLocale::Language::Bulgarian, QLocale::Script::CyrillicScript, QLocale::Country::Bulgaria,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "български\0", "България\0",
        "d.MM.yyyy 'г'.\0", "d MMMM yyyy 'г'.\0", "H:mm 'ч'.\0", "H:mm:ss 'ч'. Z\0",
        "am\0", "pm\0",
        { "яну\0", "фев\0", "март\0", "апр\0", "май\0", "юни\0", "юли\0", "авг\0", "сеп\0", "окт\0", "ное\0", "дек\0" },
        { "януари\0", "февруари\0", "март\0", "април\0", "май\0", "юни\0", "юли\0", "август\0", "септември\0", "октомври\0", "ноември\0", "декември\0" },
        { "я\0", "ф\0", "м\0", "а\0", "м\0", "ю\0", "ю\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "яну\0", "фев\0", "март\0", "апр\0", "май\0", "юни\0", "юли\0", "авг\0", "сеп\0", "окт\0", "ное\0", "дек\0" },
        { "януари\0", "февруари\0", "март\0", "април\0", "май\0", "юни\0", "юли\0", "август\0", "септември\0", "октомври\0", "ноември\0", "декември\0" },
        { "я\0", "ф\0", "м\0", "а\0", "м\0", "ю\0", "ю\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "нд\0" },
        { "понеделник\0", "вторник\0", "сряда\0", "четвъртък\0", "петък\0", "събота\0", "неделя\0" },
        { "п\0", "в\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "нд\0" },
        { "понеделник\0", "вторник\0", "сряда\0", "четвъртък\0", "петък\0", "събота\0", "неделя\0" },
        { "п\0", "в\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // bg_BG
    {
        QLocale::Language::Bambara, QLocale::Script::AnyScript, QLocale::Country::Mali,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "bamanakan\0", "Mali\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "Z\0", "F\0", "M\0", "A\0", "M\0", "Z\0", "Z\0", "U\0", "S\0", "Ɔ\0", "N\0", "D\0" },
        { "zan\0", "feb\0", "mar\0", "awi\0", "mɛ\0", "zuw\0", "zul\0", "uti\0", "sɛt\0", "ɔku\0", "now\0", "des\0" },
        { "zanwuye\0", "feburuye\0", "marisi\0", "awirili\0", "mɛ\0", "zuwɛn\0", "zuluye\0", "uti\0", "sɛtanburu\0", "ɔkutɔburu\0", "nowanburu\0", "desanburu\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "N\0", "T\0", "A\0", "A\0", "J\0", "S\0", "K\0" },
        { "ntɛ\0", "tar\0", "ara\0", "ala\0", "jum\0", "sib\0", "kar\0" },
        { "ntɛnɛ\0", "tarata\0", "araba\0", "alamisa\0", "juma\0", "sibiri\0", "kari\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // bm_ML
    {
        QLocale::Language::Bangla, QLocale::Script::BanglaScript, QLocale::Country::Bangladesh,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 2534,
        "বাংলা\0", "বাংলাদেশ\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "জানুয়ারী\0", "ফেব্রুয়ারী\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "আগস্ট\0", "সেপ্টেম্বর\0", "অক্টোবর\0", "নভেম্বর\0", "ডিসেম্বর\0" },
        { "জানুয়ারী\0", "ফেব্রুয়ারী\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "আগস্ট\0", "সেপ্টেম্বর\0", "অক্টোবর\0", "নভেম্বর\0", "ডিসেম্বর\0" },
        { "জা\0", "ফে\0", "মা\0", "এ\0", "মে\0", "জুন\0", "জু\0", "আ\0", "সে\0", "অ\0", "ন\0", "ডি\0" },
        { "জানু\0", "ফেব\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "আগস্ট\0", "সেপ্টেম্বর\0", "অক্টোবর\0", "নভেম্বর\0", "ডিসেম্বর\0" },
        { "জানুয়ারী\0", "ফেব্রুয়ারী\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "আগস্ট\0", "সেপ্টেম্বর\0", "অক্টোবর\0", "নভেম্বর\0", "ডিসেম্বর\0" },
        { "জা\0", "ফে\0", "মা\0", "এ\0", "মে\0", "জুন\0", "জু\0", "আ\0", "সে\0", "অ\0", "ন\0", "ডি\0" },
        { "সোম\0", "মঙ্গল\0", "বুধ\0", "বৃহস্পতি\0", "শুক্র\0", "শনি\0", "রবি\0" },
        { "সোমবার\0", "মঙ্গলবার\0", "বুধবার\0", "বৃহস্পতিবার\0", "শুক্রবার\0", "শনিবার\0", "রবিবার\0" },
        { "সো\0", "ম\0", "বু\0", "বৃ\0", "শু\0", "শ\0", "র\0" },
        { "সোম\0", "মঙ্গল\0", "বুধ\0", "বৃহস্পতি\0", "শুক্র\0", "শনি\0", "রবি\0" },
        { "সোমবার\0", "মঙ্গলবার\0", "বুধবার\0", "বৃহস্পতিবার\0", "শুক্রবার\0", "শনিবার\0", "রবিবার\0" },
        { "সো\0", "ম\0", "বু\0", "বৃ\0", "শু\0", "শ\0", "র\0" }
    }, // bn_BD
    {
        QLocale::Language::Bangla, QLocale::Script::AnyScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 2534,
        "বাংলা\0", "ভারত\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "জানুয়ারী\0", "ফেব্রুয়ারী\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "আগস্ট\0", "সেপ্টেম্বর\0", "অক্টোবর\0", "নভেম্বর\0", "ডিসেম্বর\0" },
        { "জানুয়ারী\0", "ফেব্রুয়ারী\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "আগস্ট\0", "সেপ্টেম্বর\0", "অক্টোবর\0", "নভেম্বর\0", "ডিসেম্বর\0" },
        { "জা\0", "ফে\0", "মা\0", "এ\0", "মে\0", "জুন\0", "জু\0", "আ\0", "সে\0", "অ\0", "ন\0", "ডি\0" },
        { "জানু\0", "ফেব\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "আগস্ট\0", "সেপ্টেম্বর\0", "অক্টোবর\0", "নভেম্বর\0", "ডিসেম্বর\0" },
        { "জানুয়ারী\0", "ফেব্রুয়ারী\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "আগস্ট\0", "সেপ্টেম্বর\0", "অক্টোবর\0", "নভেম্বর\0", "ডিসেম্বর\0" },
        { "জা\0", "ফে\0", "মা\0", "এ\0", "মে\0", "জুন\0", "জু\0", "আ\0", "সে\0", "অ\0", "ন\0", "ডি\0" },
        { "সোম\0", "মঙ্গল\0", "বুধ\0", "বৃহস্পতি\0", "শুক্র\0", "শনি\0", "রবি\0" },
        { "সোমবার\0", "মঙ্গলবার\0", "বুধবার\0", "বৃহস্পতিবার\0", "শুক্রবার\0", "শনিবার\0", "রবিবার\0" },
        { "সো\0", "ম\0", "বু\0", "বৃ\0", "শু\0", "শ\0", "র\0" },
        { "সোম\0", "মঙ্গল\0", "বুধ\0", "বৃহস্পতি\0", "শুক্র\0", "শনি\0", "রবি\0" },
        { "সোমবার\0", "মঙ্গলবার\0", "বুধবার\0", "বৃহস্পতিবার\0", "শুক্রবার\0", "শনিবার\0", "রবিবার\0" },
        { "সো\0", "ম\0", "বু\0", "বৃ\0", "শু\0", "শ\0", "র\0" }
    }, // bn_IN
    {
        QLocale::Language::Tibetan, QLocale::Script::TibetanScript, QLocale::Country::China,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "བོད་སྐད་\0", "རྒྱ་ནག\0",
        "yyyy-MM-dd\0", "སྤྱི་ལོ་yyyy MMMMའི་ཚེས་d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "སྔ་དྲོ་\0", "ཕྱི་དྲོ་\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "ཟླ་བ་དང་པོ་\0", "ཟླ་བ་གཉིས་པ་\0", "ཟླ་བ་གསུམ་པ་\0", "ཟླ་བ་བཞི་པ་\0", "ཟླ་བ་ལྔ་པ་\0", "ཟླ་བ་དྲུག་པ་\0", "ཟླ་བ་བདུན་པ་\0", "ཟླ་བ་བརྒྱད་པ་\0", "ཟླ་བ་དགུ་པ་\0", "ཟླ་བ་བཅུ་པ་\0", "ཟླ་བ་བཅུ་གཅིག་པ་\0", "ཟླ་བ་བཅུ་གཉིས་པ་\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ཟླ་༡\0", "ཟླ་༢\0", "ཟླ་༣\0", "ཟླ་༤\0", "ཟླ་༥\0", "ཟླ་༦\0", "ཟླ་༧\0", "ཟླ་༨\0", "ཟླ་༩\0", "ཟླ་༡༠\0", "ཟླ་༡༡\0", "ཟླ་༡༢\0" },
        { "ཟླ་བ་དང་པོ\0", "ཟླ་བ་གཉིས་པ\0", "ཟླ་བ་གསུམ་པ\0", "ཟླ་བ་བཞི་པ\0", "ཟླ་བ་ལྔ་པ\0", "ཟླ་བ་དྲུག་པ\0", "ཟླ་བ་བདུན་པ\0", "ཟླ་བ་བརྒྱད་པ\0", "ཟླ་བ་དགུ་པ\0", "ཟླ་བ་བཅུ་པ\0", "ཟླ་བ་བཅུ་གཅིག་པ\0", "ཟླ་བ་བཅུ་གཉིས་པ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ཟླ་བ་\0", "མིག་དམར་\0", "ལྷག་པ་\0", "ཕུར་བུ་\0", "པ་སངས་\0", "སྤེན་པ་\0", "ཉི་མ་\0" },
        { "གཟའ་ཟླ་བ་\0", "གཟའ་མིག་དམར་\0", "གཟའ་ལྷག་པ་\0", "གཟའ་ཕུར་བུ་\0", "གཟའ་པ་སངས་\0", "གཟའ་སྤེན་པ་\0", "གཟའ་ཉི་མ་\0" },
        { "ཟླ\0", "མིག\0", "ལྷག\0", "ཕུར\0", "སངས\0", "སྤེན\0", "ཉི\0" },
        { "ཟླ་བ་\0", "མིག་དམར་\0", "ལྷག་པ་\0", "ཕུར་བུ་\0", "པ་སངས་\0", "སྤེན་པ་\0", "ཉི་མ་\0" },
        { "གཟའ་ཟླ་བ་\0", "གཟའ་མིག་དམར་\0", "གཟའ་ལྷག་པ་\0", "གཟའ་ཕུར་བུ་\0", "གཟའ་པ་སངས་\0", "གཟའ་སྤེན་པ་\0", "གཟའ་ཉི་མ་\0" },
        { "ཟླ\0", "མིག\0", "ལྷག\0", "ཕུར\0", "སངས\0", "སྤེན\0", "ཉི\0" }
    }, // bo_CN
    {
        QLocale::Language::Tibetan, QLocale::Script::TibetanScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "བོད་སྐད་\0", "རྒྱ་གར་\0",
        "yyyy-MM-dd\0", "སྤྱི་ལོ་yyyy MMMMའི་ཚེས་d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "སྔ་དྲོ་\0", "ཕྱི་དྲོ་\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "ཟླ་བ་དང་པོ་\0", "ཟླ་བ་གཉིས་པ་\0", "ཟླ་བ་གསུམ་པ་\0", "ཟླ་བ་བཞི་པ་\0", "ཟླ་བ་ལྔ་པ་\0", "ཟླ་བ་དྲུག་པ་\0", "ཟླ་བ་བདུན་པ་\0", "ཟླ་བ་བརྒྱད་པ་\0", "ཟླ་བ་དགུ་པ་\0", "ཟླ་བ་བཅུ་པ་\0", "ཟླ་བ་བཅུ་གཅིག་པ་\0", "ཟླ་བ་བཅུ་གཉིས་པ་\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ཟླ་༡\0", "ཟླ་༢\0", "ཟླ་༣\0", "ཟླ་༤\0", "ཟླ་༥\0", "ཟླ་༦\0", "ཟླ་༧\0", "ཟླ་༨\0", "ཟླ་༩\0", "ཟླ་༡༠\0", "ཟླ་༡༡\0", "ཟླ་༡༢\0" },
        { "ཟླ་བ་དང་པོ\0", "ཟླ་བ་གཉིས་པ\0", "ཟླ་བ་གསུམ་པ\0", "ཟླ་བ་བཞི་པ\0", "ཟླ་བ་ལྔ་པ\0", "ཟླ་བ་དྲུག་པ\0", "ཟླ་བ་བདུན་པ\0", "ཟླ་བ་བརྒྱད་པ\0", "ཟླ་བ་དགུ་པ\0", "ཟླ་བ་བཅུ་པ\0", "ཟླ་བ་བཅུ་གཅིག་པ\0", "ཟླ་བ་བཅུ་གཉིས་པ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ཟླ་བ་\0", "མིག་དམར་\0", "ལྷག་པ་\0", "ཕུར་བུ་\0", "པ་སངས་\0", "སྤེན་པ་\0", "ཉི་མ་\0" },
        { "གཟའ་ཟླ་བ་\0", "གཟའ་མིག་དམར་\0", "གཟའ་ལྷག་པ་\0", "གཟའ་ཕུར་བུ་\0", "གཟའ་པ་སངས་\0", "གཟའ་སྤེན་པ་\0", "གཟའ་ཉི་མ་\0" },
        { "ཟླ\0", "མིག\0", "ལྷག\0", "ཕུར\0", "སངས\0", "སྤེན\0", "ཉི\0" },
        { "ཟླ་བ་\0", "མིག་དམར་\0", "ལྷག་པ་\0", "ཕུར་བུ་\0", "པ་སངས་\0", "སྤེན་པ་\0", "ཉི་མ་\0" },
        { "གཟའ་ཟླ་བ་\0", "གཟའ་མིག་དམར་\0", "གཟའ་ལྷག་པ་\0", "གཟའ་ཕུར་བུ་\0", "གཟའ་པ་སངས་\0", "གཟའ་སྤེན་པ་\0", "གཟའ་ཉི་མ་\0" },
        { "ཟླ\0", "མིག\0", "ལྷག\0", "ཕུར\0", "སངས\0", "སྤེན\0", "ཉི\0" }
    }, // bo_IN
    {
        QLocale::Language::Breton, QLocale::Script::LatinScript, QLocale::Country::France,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "brezhoneg\0", "Frañs\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "A.M.\0", "G.M.\0",
        { "Gen.\0", "Cʼhwe.\0", "Meur.\0", "Ebr.\0", "Mae\0", "Mezh.\0", "Goue.\0", "Eost\0", "Gwen.\0", "Here\0", "Du\0", "Kzu.\0" },
        { "Genver\0", "Cʼhwevrer\0", "Meurzh\0", "Ebrel\0", "Mae\0", "Mezheven\0", "Gouere\0", "Eost\0", "Gwengolo\0", "Here\0", "Du\0", "Kerzu\0" },
        { "01\0", "02\0", "03\0", "04\0", "05\0", "06\0", "07\0", "08\0", "09\0", "10\0", "11\0", "12\0" },
        { "Gen.\0", "Cʼhwe.\0", "Meur.\0", "Ebr.\0", "Mae\0", "Mezh.\0", "Goue.\0", "Eost\0", "Gwen.\0", "Here\0", "Du\0", "Kzu.\0" },
        { "Genver\0", "Cʼhwevrer\0", "Meurzh\0", "Ebrel\0", "Mae\0", "Mezheven\0", "Gouere\0", "Eost\0", "Gwengolo\0", "Here\0", "Du\0", "Kerzu\0" },
        { "01\0", "02\0", "03\0", "04\0", "05\0", "06\0", "07\0", "08\0", "09\0", "10\0", "11\0", "12\0" },
        { "Lun\0", "Meu.\0", "Mer.\0", "Yaou\0", "Gwe.\0", "Sad.\0", "Sul\0" },
        { "Lun\0", "Meurzh\0", "Mercʼher\0", "Yaou\0", "Gwener\0", "Sadorn\0", "Sul\0" },
        { "L\0", "Mz\0", "Mc\0", "Y\0", "G\0", "Sa\0", "Su\0" },
        { "Lun\0", "Meu.\0", "Mer.\0", "Yaou\0", "Gwe.\0", "Sad.\0", "Sul\0" },
        { "Lun\0", "Meurzh\0", "Mercʼher\0", "Yaou\0", "Gwener\0", "Sadorn\0", "Sul\0" },
        { "L\0", "Mz\0", "Mc\0", "Y\0", "G\0", "Sa\0", "Su\0" }
    }, // br_FR
    {
        QLocale::Language::Bodo, QLocale::Script::DevanagariScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "बर’\0", "भारत\0",
        "yyyy-MM-dd\0", "MMMM d, yyyy\0", "AP नि h:mm\0", "AP h:mm:ss Z\0",
        "फुं\0", "बेलासे\0",
        { "जान\0", "फेब\0", "मार्च\0", "एप्रि\0", "मे\0", "जुन\0", "जुल\0", "आग\0", "सेप\0", "अक्ट’\0", "नवे\0", "डिसे\0" },
        { "जानुवारी\0", "फेब्रूवारी\0", "मार्च\0", "एप्रिल\0", "मे\0", "जुन\0", "जुलाई\0", "आगष्ट\0", "सेप्थेम्बर\0", "अक्ट’बर\0", "नवेम्बर\0", "डिसेम्बर\0" },
        { "ज\0", "फ\0", "म\0", "ए\0", "म\0", "ज\0", "ज\0", "आ\0", "स\0", "अ\0", "न\0", "ड\0" },
        { "जान\0", "फेब\0", "मार्च\0", "एप्रि\0", "मे\0", "जुन\0", "जुल\0", "आग\0", "सेप\0", "अक्ट’\0", "नवे\0", "डिसे\0" },
        { "जानुवारी\0", "फेब्रूवारी\0", "मार्च\0", "एप्रिल\0", "मे\0", "जुन\0", "जुलाई\0", "आगष्ट\0", "सेप्थेम्बर\0", "अक्ट’बर\0", "नवेम्बर\0", "डिसेम्बर\0" },
        { "ज\0", "फ\0", "म\0", "ए\0", "म\0", "ज\0", "ज\0", "आ\0", "स\0", "अ\0", "न\0", "ड\0" },
        { "सम\0", "मंगल\0", "बुध\0", "बिस्थि\0", "सुखुर\0", "सुनि\0", "रबि\0" },
        { "समबार\0", "मंगलबार\0", "बुधबार\0", "बिस्थिबार\0", "सुखुरबार\0", "सुनिबार\0", "रबिबार\0" },
        { "स\0", "मं\0", "बु\0", "बि\0", "सु\0", "सु\0", "र\0" },
        { "सम\0", "मंगल\0", "बुध\0", "बिस्थि\0", "सुखुर\0", "सुनि\0", "रबि\0" },
        { "समबार\0", "मंगलबार\0", "बुधबार\0", "बिस्थिबार\0", "सुखुरबार\0", "सुनिबार\0", "रबिबार\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // brx_IN
    {
        QLocale::Language::Bosnian, QLocale::Script::CyrillicScript, QLocale::Country::BosniaAndHerzegovina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "bosanski\0", "Bosna i Hercegovina\0",
        "d. M. yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "prijepodne\0", "popodne\0",
        { "jan\0", "feb\0", "mar\0", "apr\0", "maj\0", "jun\0", "jul\0", "aug\0", "sep\0", "okt\0", "nov\0", "dec\0" },
        { "januar\0", "februar\0", "mart\0", "april\0", "maj\0", "juni\0", "juli\0", "august\0", "septembar\0", "oktobar\0", "novembar\0", "decembar\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "jan\0", "feb\0", "mar\0", "apr\0", "maj\0", "jun\0", "jul\0", "aug\0", "sep\0", "okt\0", "nov\0", "dec\0" },
        { "januar\0", "februar\0", "mart\0", "april\0", "maj\0", "juni\0", "juli\0", "august\0", "septembar\0", "oktobar\0", "novembar\0", "decembar\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "pon\0", "uto\0", "sri\0", "čet\0", "pet\0", "sub\0", "ned\0" },
        { "ponedjeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "p\0", "u\0", "s\0", "č\0", "p\0", "s\0", "n\0" },
        { "pon\0", "uto\0", "sri\0", "čet\0", "pet\0", "sub\0", "ned\0" },
        { "ponedjeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "P\0", "U\0", "S\0", "Č\0", "P\0", "S\0", "N\0" }
    }, // bs_Cyrl_BA
    {
        QLocale::Language::Bosnian, QLocale::Script::LatinScript, QLocale::Country::BosniaAndHerzegovina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "bosanski\0", "Bosna i Hercegovina\0",
        "d. M. yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "prijepodne\0", "popodne\0",
        { "jan\0", "feb\0", "mar\0", "apr\0", "maj\0", "jun\0", "jul\0", "aug\0", "sep\0", "okt\0", "nov\0", "dec\0" },
        { "januar\0", "februar\0", "mart\0", "april\0", "maj\0", "juni\0", "juli\0", "august\0", "septembar\0", "oktobar\0", "novembar\0", "decembar\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "jan\0", "feb\0", "mar\0", "apr\0", "maj\0", "jun\0", "jul\0", "aug\0", "sep\0", "okt\0", "nov\0", "dec\0" },
        { "januar\0", "februar\0", "mart\0", "april\0", "maj\0", "juni\0", "juli\0", "august\0", "septembar\0", "oktobar\0", "novembar\0", "decembar\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "pon\0", "uto\0", "sri\0", "čet\0", "pet\0", "sub\0", "ned\0" },
        { "ponedjeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "p\0", "u\0", "s\0", "č\0", "p\0", "s\0", "n\0" },
        { "pon\0", "uto\0", "sri\0", "čet\0", "pet\0", "sub\0", "ned\0" },
        { "ponedjeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "P\0", "U\0", "S\0", "Č\0", "P\0", "S\0", "N\0" }
    }, // bs_Latn_BA
    {
        QLocale::Language::Catalan, QLocale::Script::LatinScript, QLocale::Country::Andorra,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "català\0", "Andorra\0",
        "d/M/yyyy\0", "d MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "gen.\0", "febr.\0", "març\0", "abr.\0", "maig\0", "juny\0", "jul.\0", "ag.\0", "set.\0", "oct.\0", "nov.\0", "des.\0" },
        { "gener\0", "febrer\0", "març\0", "abril\0", "maig\0", "juny\0", "juliol\0", "agost\0", "setembre\0", "octubre\0", "novembre\0", "desembre\0" },
        { "GN\0", "FB\0", "MÇ\0", "AB\0", "MG\0", "JN\0", "JL\0", "AG\0", "ST\0", "OC\0", "NV\0", "DS\0" },
        { "de gen.\0", "de febr.\0", "de març\0", "d’abr.\0", "de maig\0", "de juny\0", "de jul.\0", "d’ag.\0", "de set.\0", "d’oct.\0", "de nov.\0", "de des.\0" },
        { "de gener\0", "de febrer\0", "de març\0", "d’abril\0", "de maig\0", "de juny\0", "de juliol\0", "d’agost\0", "de setembre\0", "d’octubre\0", "de novembre\0", "de desembre\0" },
        { "GN\0", "FB\0", "MÇ\0", "AB\0", "MG\0", "JN\0", "JL\0", "AG\0", "ST\0", "OC\0", "NV\0", "DS\0" },
        { "dl.\0", "dt.\0", "dc.\0", "dj.\0", "dv.\0", "ds.\0", "dg.\0" },
        { "dilluns\0", "dimarts\0", "dimecres\0", "dijous\0", "divendres\0", "dissabte\0", "diumenge\0" },
        { "dl\0", "dt\0", "dc\0", "dj\0", "dv\0", "ds\0", "dg\0" },
        { "dl.\0", "dt.\0", "dc.\0", "dj.\0", "dv.\0", "ds.\0", "dg.\0" },
        { "dilluns\0", "dimarts\0", "dimecres\0", "dijous\0", "divendres\0", "dissabte\0", "diumenge\0" },
        { "dl\0", "dt\0", "dc\0", "dj\0", "dv\0", "ds\0", "dg\0" }
    }, // ca_AD
    {
        QLocale::Language::Catalan, QLocale::Script::AnyScript, QLocale::Country::Spain,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "català\0", "Espanya\0",
        "d/M/yyyy\0", "d MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "gen.\0", "febr.\0", "març\0", "abr.\0", "maig\0", "juny\0", "jul.\0", "ag.\0", "set.\0", "oct.\0", "nov.\0", "des.\0" },
        { "gener\0", "febrer\0", "març\0", "abril\0", "maig\0", "juny\0", "juliol\0", "agost\0", "setembre\0", "octubre\0", "novembre\0", "desembre\0" },
        { "GN\0", "FB\0", "MÇ\0", "AB\0", "MG\0", "JN\0", "JL\0", "AG\0", "ST\0", "OC\0", "NV\0", "DS\0" },
        { "de gen.\0", "de febr.\0", "de març\0", "d’abr.\0", "de maig\0", "de juny\0", "de jul.\0", "d’ag.\0", "de set.\0", "d’oct.\0", "de nov.\0", "de des.\0" },
        { "de gener\0", "de febrer\0", "de març\0", "d’abril\0", "de maig\0", "de juny\0", "de juliol\0", "d’agost\0", "de setembre\0", "d’octubre\0", "de novembre\0", "de desembre\0" },
        { "GN\0", "FB\0", "MÇ\0", "AB\0", "MG\0", "JN\0", "JL\0", "AG\0", "ST\0", "OC\0", "NV\0", "DS\0" },
        { "dl.\0", "dt.\0", "dc.\0", "dj.\0", "dv.\0", "ds.\0", "dg.\0" },
        { "dilluns\0", "dimarts\0", "dimecres\0", "dijous\0", "divendres\0", "dissabte\0", "diumenge\0" },
        { "dl\0", "dt\0", "dc\0", "dj\0", "dv\0", "ds\0", "dg\0" },
        { "dl.\0", "dt.\0", "dc.\0", "dj.\0", "dv.\0", "ds.\0", "dg.\0" },
        { "dilluns\0", "dimarts\0", "dimecres\0", "dijous\0", "divendres\0", "dissabte\0", "diumenge\0" },
        { "dl\0", "dt\0", "dc\0", "dj\0", "dv\0", "ds\0", "dg\0" }
    }, // ca_ES
    {
        QLocale::Language::Catalan, QLocale::Script::AnyScript, QLocale::Country::France,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "català\0", "França\0",
        "d/M/yyyy\0", "d MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "gen.\0", "febr.\0", "març\0", "abr.\0", "maig\0", "juny\0", "jul.\0", "ag.\0", "set.\0", "oct.\0", "nov.\0", "des.\0" },
        { "gener\0", "febrer\0", "març\0", "abril\0", "maig\0", "juny\0", "juliol\0", "agost\0", "setembre\0", "octubre\0", "novembre\0", "desembre\0" },
        { "GN\0", "FB\0", "MÇ\0", "AB\0", "MG\0", "JN\0", "JL\0", "AG\0", "ST\0", "OC\0", "NV\0", "DS\0" },
        { "de gen.\0", "de febr.\0", "de març\0", "d’abr.\0", "de maig\0", "de juny\0", "de jul.\0", "d’ag.\0", "de set.\0", "d’oct.\0", "de nov.\0", "de des.\0" },
        { "de gener\0", "de febrer\0", "de març\0", "d’abril\0", "de maig\0", "de juny\0", "de juliol\0", "d’agost\0", "de setembre\0", "d’octubre\0", "de novembre\0", "de desembre\0" },
        { "GN\0", "FB\0", "MÇ\0", "AB\0", "MG\0", "JN\0", "JL\0", "AG\0", "ST\0", "OC\0", "NV\0", "DS\0" },
        { "dl.\0", "dt.\0", "dc.\0", "dj.\0", "dv.\0", "ds.\0", "dg.\0" },
        { "dilluns\0", "dimarts\0", "dimecres\0", "dijous\0", "divendres\0", "dissabte\0", "diumenge\0" },
        { "dl\0", "dt\0", "dc\0", "dj\0", "dv\0", "ds\0", "dg\0" },
        { "dl.\0", "dt.\0", "dc.\0", "dj.\0", "dv.\0", "ds.\0", "dg.\0" },
        { "dilluns\0", "dimarts\0", "dimecres\0", "dijous\0", "divendres\0", "dissabte\0", "diumenge\0" },
        { "dl\0", "dt\0", "dc\0", "dj\0", "dv\0", "ds\0", "dg\0" }
    }, // ca_FR
    {
        QLocale::Language::Catalan, QLocale::Script::AnyScript, QLocale::Country::Italy,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "català\0", "Itàlia\0",
        "d/M/yyyy\0", "d MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "gen.\0", "febr.\0", "març\0", "abr.\0", "maig\0", "juny\0", "jul.\0", "ag.\0", "set.\0", "oct.\0", "nov.\0", "des.\0" },
        { "gener\0", "febrer\0", "març\0", "abril\0", "maig\0", "juny\0", "juliol\0", "agost\0", "setembre\0", "octubre\0", "novembre\0", "desembre\0" },
        { "GN\0", "FB\0", "MÇ\0", "AB\0", "MG\0", "JN\0", "JL\0", "AG\0", "ST\0", "OC\0", "NV\0", "DS\0" },
        { "de gen.\0", "de febr.\0", "de març\0", "d’abr.\0", "de maig\0", "de juny\0", "de jul.\0", "d’ag.\0", "de set.\0", "d’oct.\0", "de nov.\0", "de des.\0" },
        { "de gener\0", "de febrer\0", "de març\0", "d’abril\0", "de maig\0", "de juny\0", "de juliol\0", "d’agost\0", "de setembre\0", "d’octubre\0", "de novembre\0", "de desembre\0" },
        { "GN\0", "FB\0", "MÇ\0", "AB\0", "MG\0", "JN\0", "JL\0", "AG\0", "ST\0", "OC\0", "NV\0", "DS\0" },
        { "dl.\0", "dt.\0", "dc.\0", "dj.\0", "dv.\0", "ds.\0", "dg.\0" },
        { "dilluns\0", "dimarts\0", "dimecres\0", "dijous\0", "divendres\0", "dissabte\0", "diumenge\0" },
        { "dl\0", "dt\0", "dc\0", "dj\0", "dv\0", "ds\0", "dg\0" },
        { "dl.\0", "dt.\0", "dc.\0", "dj.\0", "dv.\0", "ds.\0", "dg.\0" },
        { "dilluns\0", "dimarts\0", "dimecres\0", "dijous\0", "divendres\0", "dissabte\0", "diumenge\0" },
        { "dl\0", "dt\0", "dc\0", "dj\0", "dv\0", "ds\0", "dg\0" }
    }, // ca_IT
    {
        QLocale::Language::Chakma, QLocale::Script::AnyScript, QLocale::Country::Bangladesh,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 69942,
        "𑄌𑄋𑄴𑄟𑄳𑄦\0", "𑄝𑄁𑄣𑄘𑄬𑄌𑄴\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "𑄎𑄚𑄪𑄠𑄢𑄨\0", "𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨\0", "𑄟𑄢𑄴𑄌𑄧\0", "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴\0", "𑄟𑄬\0", "𑄎𑄚𑄴\0", "𑄎𑄪𑄣𑄭\0", "𑄃𑄉𑄧𑄌𑄴𑄑𑄴\0", "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴\0", "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0" },
        { "𑄎𑄚𑄪𑄠𑄢𑄨\0", "𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨\0", "𑄟𑄢𑄴𑄌𑄧\0", "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪𑄣𑄭\0", "𑄃𑄉𑄧𑄌𑄴𑄑𑄴\0", "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴\0", "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0" },
        { "𑄎\0", "𑄜𑄬\0", "𑄟\0", "𑄃𑄬\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪\0", "𑄃\0", "𑄥𑄬\0", "𑄃𑄧\0", "𑄚𑄧\0", "𑄓𑄨\0" },
        { "𑄎𑄚𑄪\0", "𑄜𑄬𑄛𑄴\0", "𑄟𑄢𑄴𑄌𑄧\0", "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪𑄣𑄭\0", "𑄃𑄉𑄧𑄌𑄴𑄑𑄴\0", "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴\0", "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄢𑄴\0" },
        { "𑄎𑄚𑄪𑄠𑄢𑄨\0", "𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨\0", "𑄟𑄢𑄴𑄌𑄧\0", "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪𑄣𑄭\0", "𑄃𑄉𑄧𑄌𑄴𑄑𑄴\0", "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄃𑄧𑄇𑄴𑄑𑄬𑄝𑄧𑄢𑄴\0", "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0" },
        { "𑄎\0", "𑄜𑄬\0", "𑄟\0", "𑄃𑄬\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪\0", "𑄃\0", "𑄥𑄬\0", "𑄃𑄧\0", "𑄚𑄧\0", "𑄓𑄨\0" },
        { "𑄥𑄧𑄟𑄴\0", "𑄟𑄧𑄁𑄉𑄧𑄣𑄴\0", "𑄝𑄪𑄖𑄴\0", "𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴\0", "𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴\0", "𑄥𑄧𑄚𑄨\0", "𑄢𑄧𑄝𑄨\0" },
        { "𑄥𑄧𑄟𑄴𑄝𑄢𑄴\0", "𑄟𑄧𑄁𑄉𑄧𑄣𑄴𑄝𑄢𑄴\0", "𑄝𑄪𑄖𑄴𑄝𑄢𑄴\0", "𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴𑄝𑄢𑄴\0", "𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴𑄝𑄢𑄴\0", "𑄥𑄧𑄚𑄨𑄝𑄢𑄴\0", "𑄢𑄧𑄝𑄨𑄝𑄢𑄴\0" },
        { "𑄥𑄧\0", "𑄟𑄧\0", "𑄝𑄪\0", "𑄝𑄳𑄢𑄨\0", "𑄥𑄪\0", "𑄥𑄧\0", "𑄢𑄧\0" },
        { "𑄥𑄧𑄟𑄴\0", "𑄟𑄧𑄁𑄉𑄧𑄣𑄴\0", "𑄝𑄪𑄖𑄴\0", "𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴\0", "𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴\0", "𑄥𑄧𑄚𑄨\0", "𑄢𑄧𑄝𑄨\0" },
        { "𑄥𑄧𑄟𑄴𑄝𑄢𑄴\0", "𑄟𑄧𑄁𑄉𑄧𑄣𑄴𑄝𑄢𑄴\0", "𑄝𑄪𑄖𑄴𑄝𑄢𑄴\0", "𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴𑄝𑄢𑄴\0", "𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴𑄝𑄢𑄴\0", "𑄥𑄧𑄚𑄨𑄝𑄢𑄴\0", "𑄢𑄧𑄝𑄨𑄝𑄢𑄴\0" },
        { "𑄥𑄧\0", "𑄟𑄧\0", "𑄝𑄪\0", "𑄝𑄳𑄢𑄨\0", "𑄥𑄪\0", "𑄥𑄧\0", "𑄢𑄧\0" }
    }, // ccp_BD
    {
        QLocale::Language::Chakma, QLocale::Script::AnyScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 69942,
        "𑄌𑄋𑄴𑄟𑄳𑄦\0", "𑄞𑄢𑄧𑄖𑄴\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "𑄎𑄚𑄪𑄠𑄢𑄨\0", "𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨\0", "𑄟𑄢𑄴𑄌𑄧\0", "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪𑄣𑄭\0", "𑄃𑄉𑄧𑄌𑄴𑄑𑄴\0", "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴\0", "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0" },
        { "𑄎𑄚𑄪𑄠𑄢𑄨\0", "𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨\0", "𑄟𑄢𑄴𑄌𑄧\0", "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪𑄣𑄭\0", "𑄃𑄉𑄧𑄌𑄴𑄑𑄴\0", "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴\0", "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0" },
        { "𑄎\0", "𑄜𑄬\0", "𑄟\0", "𑄃𑄬\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪\0", "𑄃\0", "𑄥𑄬\0", "𑄃𑄧\0", "𑄚𑄧\0", "𑄓𑄨\0" },
        { "𑄎𑄚𑄪\0", "𑄜𑄬𑄛𑄴\0", "𑄟𑄢𑄴𑄌𑄧\0", "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪𑄣𑄭\0", "𑄃𑄉𑄧𑄌𑄴𑄑𑄴\0", "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴\0", "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄢𑄴\0" },
        { "𑄎𑄚𑄪𑄠𑄢𑄨\0", "𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨\0", "𑄟𑄢𑄴𑄌𑄧\0", "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪𑄣𑄭\0", "𑄃𑄉𑄧𑄌𑄴𑄑𑄴\0", "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄃𑄧𑄇𑄴𑄑𑄬𑄝𑄧𑄢𑄴\0", "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0", "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴\0" },
        { "𑄎\0", "𑄜𑄬\0", "𑄟\0", "𑄃𑄬\0", "𑄟𑄬\0", "𑄎𑄪𑄚𑄴\0", "𑄎𑄪\0", "𑄃\0", "𑄥𑄬\0", "𑄃𑄧\0", "𑄚𑄧\0", "𑄓𑄨\0" },
        { "𑄥𑄧𑄟𑄴\0", "𑄟𑄧𑄁𑄉𑄧𑄣𑄴\0", "𑄝𑄪𑄖𑄴\0", "𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴\0", "𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴\0", "𑄥𑄧𑄚𑄨\0", "𑄢𑄧𑄝𑄨\0" },
        { "𑄥𑄧𑄟𑄴𑄝𑄢𑄴\0", "𑄟𑄧𑄁𑄉𑄧𑄣𑄴𑄝𑄢𑄴\0", "𑄝𑄪𑄖𑄴𑄝𑄢𑄴\0", "𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴𑄝𑄢𑄴\0", "𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴𑄝𑄢𑄴\0", "𑄥𑄧𑄚𑄨𑄝𑄢𑄴\0", "𑄢𑄧𑄝𑄨𑄝𑄢𑄴\0" },
        { "𑄥𑄧\0", "𑄟𑄧\0", "𑄝𑄪\0", "𑄝𑄳𑄢𑄨\0", "𑄥𑄪\0", "𑄥𑄧\0", "𑄢𑄧\0" },
        { "𑄥𑄧𑄟𑄴\0", "𑄟𑄧𑄁𑄉𑄧𑄣𑄴\0", "𑄝𑄪𑄖𑄴\0", "𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴\0", "𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴\0", "𑄥𑄧𑄚𑄨\0", "𑄢𑄧𑄝𑄨\0" },
        { "𑄥𑄧𑄟𑄴𑄝𑄢𑄴\0", "𑄟𑄧𑄁𑄉𑄧𑄣𑄴𑄝𑄢𑄴\0", "𑄝𑄪𑄖𑄴𑄝𑄢𑄴\0", "𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴𑄝𑄢𑄴\0", "𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴𑄝𑄢𑄴\0", "𑄥𑄧𑄚𑄨𑄝𑄢𑄴\0", "𑄢𑄧𑄝𑄨𑄝𑄢𑄴\0" },
        { "𑄥𑄧\0", "𑄟𑄧\0", "𑄝𑄪\0", "𑄝𑄳𑄢𑄨\0", "𑄥𑄪\0", "𑄥𑄧\0", "𑄢𑄧\0" }
    }, // ccp_IN
    {
        QLocale::Language::Chechen, QLocale::Script::CyrillicScript, QLocale::Country::Russia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "нохчийн\0", "Росси\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "январь\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "янв\0", "фев\0", "мар\0", "апр\0", "май\0", "июн\0", "июл\0", "авг\0", "сен\0", "окт\0", "ноя\0", "дек\0" },
        { "январь\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "ор\0", "ши\0", "кха\0", "еа\0", "пӀе\0", "шуо\0", "кӀи\0" },
        { "оршот\0", "шинара\0", "кхаара\0", "еара\0", "пӀераска\0", "шуот\0", "кӀира\0" },
        { "о\0", "ш\0", "кх\0", "е\0", "пӀ\0", "ш\0", "кӀ\0" },
        { "ор\0", "ши\0", "кха\0", "еа\0", "пӀе\0", "шуо\0", "кӀи\0" },
        { "оршот\0", "шинара\0", "кхаара\0", "еара\0", "пӀераска\0", "шуот\0", "кӀира\0" },
        { "ор\0", "ши\0", "кха\0", "еа\0", "пӀе\0", "шуо\0", "кӀи\0" }
    }, // ce_RU
    {
        QLocale::Language::Cebuano, QLocale::Script::LatinScript, QLocale::Country::Philippines,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Binisaya\0", "Pilipinas\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Ene\0", "Peb\0", "Mar\0", "Abr\0", "May\0", "Hun\0", "Hul\0", "Ago\0", "Set\0", "Okt\0", "Nob\0", "Dis\0" },
        { "Enero\0", "Pebrero\0", "Marso\0", "Abril\0", "Mayo\0", "Hunyo\0", "Hulyo\0", "Agosto\0", "Setyembre\0", "Oktubre\0", "Nobyembre\0", "Disyembre\0" },
        { "E\0", "P\0", "M\0", "A\0", "M\0", "H\0", "H\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Ene\0", "Peb\0", "Mar\0", "Abr\0", "May\0", "Hun\0", "Hul\0", "Ago\0", "Set\0", "Okt\0", "Nob\0", "Dis\0" },
        { "Enero\0", "Pebrero\0", "Marso\0", "Abril\0", "Mayo\0", "Hunyo\0", "Hulyo\0", "Agosto\0", "Setyembre\0", "Oktubre\0", "Nobyembre\0", "Disyembre\0" },
        { "E\0", "P\0", "M\0", "A\0", "M\0", "H\0", "H\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Lun\0", "Mar\0", "Miy\0", "Huw\0", "Biy\0", "Sab\0", "Dom\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "L\0", "M\0", "M\0", "H\0", "B\0", "S\0", "D\0" },
        { "Lun\0", "Mar\0", "Miy\0", "Huw\0", "Biy\0", "Sab\0", "Dom\0" },
        { "Lunes\0", "Martes\0", "Miyerkules\0", "Huwebes\0", "Biyernes\0", "Sabado\0", "Domingo\0" },
        { "L\0", "M\0", "M\0", "H\0", "B\0", "S\0", "D\0" }
    }, // ceb_PH
    {
        QLocale::Language::Chiga, QLocale::Script::LatinScript, QLocale::Country::Uganda,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Rukiga\0", "Uganda\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "KBZ\0", "KBR\0", "KST\0", "KKN\0", "KTN\0", "KMK\0", "KMS\0", "KMN\0", "KMW\0", "KKM\0", "KNK\0", "KNB\0" },
        { "Okwokubanza\0", "Okwakabiri\0", "Okwakashatu\0", "Okwakana\0", "Okwakataana\0", "Okwamukaaga\0", "Okwamushanju\0", "Okwamunaana\0", "Okwamwenda\0", "Okwaikumi\0", "Okwaikumi na kumwe\0", "Okwaikumi na ibiri\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "K\0", "R\0", "S\0", "N\0", "T\0", "M\0", "S\0" },
        { "ORK\0", "OKB\0", "OKS\0", "OKN\0", "OKT\0", "OMK\0", "SAN\0" },
        { "Orwokubanza\0", "Orwakabiri\0", "Orwakashatu\0", "Orwakana\0", "Orwakataano\0", "Orwamukaaga\0", "Sande\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // cgg_UG
    {
        QLocale::Language::Cherokee, QLocale::Script::CherokeeScript, QLocale::Country::UnitedStates,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ᏣᎳᎩ\0", "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "ᏌᎾᎴ\0", "ᏒᎯᏱᎢᏗᏢ\0",
        { "ᎤᏃ\0", "ᎧᎦ\0", "ᎠᏅ\0", "ᎧᏬ\0", "ᎠᏂ\0", "ᏕᎭ\0", "ᎫᏰ\0", "ᎦᎶ\0", "ᏚᎵ\0", "ᏚᏂ\0", "ᏅᏓ\0", "ᎥᏍ\0" },
        { "ᎤᏃᎸᏔᏅ\0", "ᎧᎦᎵ\0", "ᎠᏅᏱ\0", "ᎧᏬᏂ\0", "ᎠᏂᏍᎬᏘ\0", "ᏕᎭᎷᏱ\0", "ᎫᏰᏉᏂ\0", "ᎦᎶᏂ\0", "ᏚᎵᏍᏗ\0", "ᏚᏂᏅᏗ\0", "ᏅᏓᏕᏆ\0", "ᎥᏍᎩᏱ\0" },
        { "Ꭴ\0", "Ꭷ\0", "Ꭰ\0", "Ꭷ\0", "Ꭰ\0", "Ꮥ\0", "Ꭻ\0", "Ꭶ\0", "Ꮪ\0", "Ꮪ\0", "Ꮕ\0", "Ꭵ\0" },
        { "ᎤᏃ\0", "ᎧᎦ\0", "ᎠᏅ\0", "ᎧᏬ\0", "ᎠᏂ\0", "ᏕᎭ\0", "ᎫᏰ\0", "ᎦᎶ\0", "ᏚᎵ\0", "ᏚᏂ\0", "ᏅᏓ\0", "ᎥᏍ\0" },
        { "ᎤᏃᎸᏔᏅ\0", "ᎧᎦᎵ\0", "ᎠᏅᏱ\0", "ᎧᏬᏂ\0", "ᎠᏂᏍᎬᏘ\0", "ᏕᎭᎷᏱ\0", "ᎫᏰᏉᏂ\0", "ᎦᎶᏂ\0", "ᏚᎵᏍᏗ\0", "ᏚᏂᏅᏗ\0", "ᏅᏓᏕᏆ\0", "ᎥᏍᎩᏱ\0" },
        { "Ꭴ\0", "Ꭷ\0", "Ꭰ\0", "Ꭷ\0", "Ꭰ\0", "Ꮥ\0", "Ꭻ\0", "Ꭶ\0", "Ꮪ\0", "Ꮪ\0", "Ꮕ\0", "Ꭵ\0" },
        { "ᏉᏅᎯ\0", "ᏔᎵᏁ\0", "ᏦᎢᏁ\0", "ᏅᎩᏁ\0", "ᏧᎾᎩ\0", "ᏈᏕᎾ\0", "ᏆᏍᎬ\0" },
        { "ᎤᎾᏙᏓᏉᏅᎯ\0", "ᏔᎵᏁᎢᎦ\0", "ᏦᎢᏁᎢᎦ\0", "ᏅᎩᏁᎢᎦ\0", "ᏧᎾᎩᎶᏍᏗ\0", "ᎤᎾᏙᏓᏈᏕᎾ\0", "ᎤᎾᏙᏓᏆᏍᎬ\0" },
        { "Ꮙ\0", "Ꮤ\0", "Ꮶ\0", "Ꮕ\0", "Ꮷ\0", "Ꭴ\0", "Ꮖ\0" },
        { "ᏉᏅᎯ\0", "ᏔᎵᏁ\0", "ᏦᎢᏁ\0", "ᏅᎩᏁ\0", "ᏧᎾᎩ\0", "ᏈᏕᎾ\0", "ᏆᏍᎬ\0" },
        { "ᎤᎾᏙᏓᏉᏅᎯ\0", "ᏔᎵᏁᎢᎦ\0", "ᏦᎢᏁᎢᎦ\0", "ᏅᎩᏁᎢᎦ\0", "ᏧᎾᎩᎶᏍᏗ\0", "ᎤᎾᏙᏓᏈᏕᎾ\0", "ᎤᎾᏙᏓᏆᏍᎬ\0" },
        { "Ꮙ\0", "Ꮤ\0", "Ꮶ\0", "Ꮕ\0", "Ꮷ\0", "Ꭴ\0", "Ꮖ\0" }
    }, // chr_US
    {
        QLocale::Language::CentralKurdish, QLocale::Script::ArabicScript, QLocale::Country::Iraq,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        1643, 1644, 59, 1642, 45, 43, 69, 1632,
        "کوردیی ناوەندی\0", "عێراق\0",
        "yyyy-MM-dd\0", "dی MMMMی yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "ب.ن\0", "د.ن\0",
        { "کانوونی دووەم\0", "شوبات\0", "ئازار\0", "نیسان\0", "ئایار\0", "حوزەیران\0", "تەمووز\0", "ئاب\0", "ئەیلوول\0", "تشرینی یەکەم\0", "تشرینی دووەم\0", "کانونی یەکەم\0" },
        { "کانوونی دووەم\0", "شوبات\0", "ئازار\0", "نیسان\0", "ئایار\0", "حوزەیران\0", "تەمووز\0", "ئاب\0", "ئەیلوول\0", "تشرینی یەکەم\0", "تشرینی دووەم\0", "کانونی یەکەم\0" },
        { "ک\0", "ش\0", "ئ\0", "ن\0", "ئ\0", "ح\0", "ت\0", "ئ\0", "ئ\0", "ت\0", "ت\0", "ک\0" },
        { "کانوونی دووەم\0", "شوبات\0", "ئازار\0", "نیسان\0", "ئایار\0", "حوزەیران\0", "تەمووز\0", "ئاب\0", "ئەیلوول\0", "تشرینی یەکەم\0", "تشرینی دووەم\0", "کانونی یەکەم\0" },
        { "کانوونی دووەم\0", "شوبات\0", "ئازار\0", "نیسان\0", "ئایار\0", "حوزەیران\0", "تەمووز\0", "ئاب\0", "ئەیلوول\0", "تشرینی یەکەم\0", "تشرینی دووەم\0", "کانونی یەکەم\0" },
        { "ک\0", "ش\0", "ئ\0", "ن\0", "ئ\0", "ح\0", "ت\0", "ئ\0", "ئ\0", "ت\0", "ت\0", "ک\0" },
        { "دووشەممە\0", "سێشەممە\0", "چوارشەممە\0", "پێنجشەممە\0", "ھەینی\0", "شەممە\0", "یەکشەممە\0" },
        { "دووشەممە\0", "سێشەممە\0", "چوارشەممە\0", "پێنجشەممە\0", "ھەینی\0", "شەممە\0", "یەکشەممە\0" },
        { "د\0", "س\0", "چ\0", "پ\0", "ھ\0", "ش\0", "ی\0" },
        { "دووشەممە\0", "سێشەممە\0", "چوارشەممە\0", "پێنجشەممە\0", "ھەینی\0", "شەممە\0", "یەکشەممە\0" },
        { "دووشەممە\0", "سێشەممە\0", "چوارشەممە\0", "پێنجشەممە\0", "ھەینی\0", "شەممە\0", "یەکشەممە\0" },
        { "د\0", "س\0", "چ\0", "پ\0", "ھ\0", "ش\0", "ی\0" }
    }, // ckb_IQ
    {
        QLocale::Language::CentralKurdish, QLocale::Script::ArabicScript, QLocale::Country::Iran,
        Qt::Saturday, Qt::Friday, Qt::Friday,
        1643, 1644, 59, 1642, 45, 43, 69, 1632,
        "کوردیی ناوەندی\0", "ئێران\0",
        "yyyy-MM-dd\0", "dی MMMMی yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ب.ن\0", "د.ن\0",
        { "کانوونی دووەم\0", "شوبات\0", "ئازار\0", "نیسان\0", "ئایار\0", "حوزەیران\0", "تەمووز\0", "ئاب\0", "ئەیلوول\0", "تشرینی یەکەم\0", "تشرینی دووەم\0", "کانونی یەکەم\0" },
        { "کانوونی دووەم\0", "شوبات\0", "ئازار\0", "نیسان\0", "ئایار\0", "حوزەیران\0", "تەمووز\0", "ئاب\0", "ئەیلوول\0", "تشرینی یەکەم\0", "تشرینی دووەم\0", "کانونی یەکەم\0" },
        { "ک\0", "ش\0", "ئ\0", "ن\0", "ئ\0", "ح\0", "ت\0", "ئ\0", "ئ\0", "ت\0", "ت\0", "ک\0" },
        { "کانوونی دووەم\0", "شوبات\0", "ئازار\0", "نیسان\0", "ئایار\0", "حوزەیران\0", "تەمووز\0", "ئاب\0", "ئەیلوول\0", "تشرینی یەکەم\0", "تشرینی دووەم\0", "کانونی یەکەم\0" },
        { "کانوونی دووەم\0", "شوبات\0", "ئازار\0", "نیسان\0", "ئایار\0", "حوزەیران\0", "تەمووز\0", "ئاب\0", "ئەیلوول\0", "تشرینی یەکەم\0", "تشرینی دووەم\0", "کانونی یەکەم\0" },
        { "ک\0", "ش\0", "ئ\0", "ن\0", "ئ\0", "ح\0", "ت\0", "ئ\0", "ئ\0", "ت\0", "ت\0", "ک\0" },
        { "دووشەممە\0", "سێشەممە\0", "چوارشەممە\0", "پێنجشەممە\0", "ھەینی\0", "شەممە\0", "یەکشەممە\0" },
        { "دووشەممە\0", "سێشەممە\0", "چوارشەممە\0", "پێنجشەممە\0", "ھەینی\0", "شەممە\0", "یەکشەممە\0" },
        { "د\0", "س\0", "چ\0", "پ\0", "ھ\0", "ش\0", "ی\0" },
        { "دووشەممە\0", "سێشەممە\0", "چوارشەممە\0", "پێنجشەممە\0", "ھەینی\0", "شەممە\0", "یەکشەممە\0" },
        { "دووشەممە\0", "سێشەممە\0", "چوارشەممە\0", "پێنجشەممە\0", "ھەینی\0", "شەممە\0", "یەکشەممە\0" },
        { "د\0", "س\0", "چ\0", "پ\0", "ھ\0", "ش\0", "ی\0" }
    }, // ckb_IR
    {
        QLocale::Language::Czech, QLocale::Script::LatinScript, QLocale::Country::Czechia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "čeština\0", "Česko\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "dop.\0", "odp.\0",
        { "led\0", "úno\0", "bře\0", "dub\0", "kvě\0", "čvn\0", "čvc\0", "srp\0", "zář\0", "říj\0", "lis\0", "pro\0" },
        { "leden\0", "únor\0", "březen\0", "duben\0", "květen\0", "červen\0", "červenec\0", "srpen\0", "září\0", "říjen\0", "listopad\0", "prosinec\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "led\0", "úno\0", "bře\0", "dub\0", "kvě\0", "čvn\0", "čvc\0", "srp\0", "zář\0", "říj\0", "lis\0", "pro\0" },
        { "ledna\0", "února\0", "března\0", "dubna\0", "května\0", "června\0", "července\0", "srpna\0", "září\0", "října\0", "listopadu\0", "prosince\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "po\0", "út\0", "st\0", "čt\0", "pá\0", "so\0", "ne\0" },
        { "pondělí\0", "úterý\0", "středa\0", "čtvrtek\0", "pátek\0", "sobota\0", "neděle\0" },
        { "P\0", "Ú\0", "S\0", "Č\0", "P\0", "S\0", "N\0" },
        { "po\0", "út\0", "st\0", "čt\0", "pá\0", "so\0", "ne\0" },
        { "pondělí\0", "úterý\0", "středa\0", "čtvrtek\0", "pátek\0", "sobota\0", "neděle\0" },
        { "P\0", "Ú\0", "S\0", "Č\0", "P\0", "S\0", "N\0" }
    }, // cs_CZ
    {
        QLocale::Language::Welsh, QLocale::Script::LatinScript, QLocale::Country::UnitedKingdom,
        Qt::Sunday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Cymraeg\0", "Y Deyrnas Unedig\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "yb\0", "yh\0",
        { "Ion\0", "Chw\0", "Maw\0", "Ebr\0", "Mai\0", "Meh\0", "Gor\0", "Awst\0", "Medi\0", "Hyd\0", "Tach\0", "Rhag\0" },
        { "Ionawr\0", "Chwefror\0", "Mawrth\0", "Ebrill\0", "Mai\0", "Mehefin\0", "Gorffennaf\0", "Awst\0", "Medi\0", "Hydref\0", "Tachwedd\0", "Rhagfyr\0" },
        { "I\0", "Ch\0", "M\0", "E\0", "M\0", "M\0", "G\0", "A\0", "M\0", "H\0", "T\0", "Rh\0" },
        { "Ion\0", "Chwef\0", "Maw\0", "Ebr\0", "Mai\0", "Meh\0", "Gorff\0", "Awst\0", "Medi\0", "Hyd\0", "Tach\0", "Rhag\0" },
        { "Ionawr\0", "Chwefror\0", "Mawrth\0", "Ebrill\0", "Mai\0", "Mehefin\0", "Gorffennaf\0", "Awst\0", "Medi\0", "Hydref\0", "Tachwedd\0", "Rhagfyr\0" },
        { "I\0", "Ch\0", "M\0", "E\0", "M\0", "M\0", "G\0", "A\0", "M\0", "H\0", "T\0", "Rh\0" },
        { "Llun\0", "Maw\0", "Mer\0", "Iau\0", "Gwe\0", "Sad\0", "Sul\0" },
        { "Dydd Llun\0", "Dydd Mawrth\0", "Dydd Mercher\0", "Dydd Iau\0", "Dydd Gwener\0", "Dydd Sadwrn\0", "Dydd Sul\0" },
        { "Ll\0", "M\0", "M\0", "I\0", "G\0", "S\0", "S\0" },
        { "Llun\0", "Maw\0", "Mer\0", "Iau\0", "Gwen\0", "Sad\0", "Sul\0" },
        { "Dydd Llun\0", "Dydd Mawrth\0", "Dydd Mercher\0", "Dydd Iau\0", "Dydd Gwener\0", "Dydd Sadwrn\0", "Dydd Sul\0" },
        { "Ll\0", "M\0", "M\0", "I\0", "G\0", "S\0", "S\0" }
    }, // cy_GB
    {
        QLocale::Language::Danish, QLocale::Script::LatinScript, QLocale::Country::Denmark,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "dansk\0", "Danmark\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH.mm\0", "HH.mm.ss Z\0",
        "AM\0", "PM\0",
        { "jan.\0", "feb.\0", "mar.\0", "apr.\0", "maj\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januar\0", "februar\0", "marts\0", "april\0", "maj\0", "juni\0", "juli\0", "august\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mar.\0", "apr.\0", "maj\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januar\0", "februar\0", "marts\0", "april\0", "maj\0", "juni\0", "juli\0", "august\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "man\0", "tir\0", "ons\0", "tor\0", "fre\0", "lør\0", "søn\0" },
        { "mandag\0", "tirsdag\0", "onsdag\0", "torsdag\0", "fredag\0", "lørdag\0", "søndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" },
        { "man.\0", "tir.\0", "ons.\0", "tor.\0", "fre.\0", "lør.\0", "søn.\0" },
        { "mandag\0", "tirsdag\0", "onsdag\0", "torsdag\0", "fredag\0", "lørdag\0", "søndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" }
    }, // da_DK
    {
        QLocale::Language::Danish, QLocale::Script::AnyScript, QLocale::Country::Greenland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "dansk\0", "Grønland\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH.mm\0", "HH.mm.ss Z\0",
        "AM\0", "PM\0",
        { "jan.\0", "feb.\0", "mar.\0", "apr.\0", "maj\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januar\0", "februar\0", "marts\0", "april\0", "maj\0", "juni\0", "juli\0", "august\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mar.\0", "apr.\0", "maj\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januar\0", "februar\0", "marts\0", "april\0", "maj\0", "juni\0", "juli\0", "august\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "man\0", "tir\0", "ons\0", "tor\0", "fre\0", "lør\0", "søn\0" },
        { "mandag\0", "tirsdag\0", "onsdag\0", "torsdag\0", "fredag\0", "lørdag\0", "søndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" },
        { "man.\0", "tir.\0", "ons.\0", "tor.\0", "fre.\0", "lør.\0", "søn.\0" },
        { "mandag\0", "tirsdag\0", "onsdag\0", "torsdag\0", "fredag\0", "lørdag\0", "søndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" }
    }, // da_GL
    {
        QLocale::Language::Taita, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kitaita\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Luma lwa K\0", "luma lwa p\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "I\0", "K\0", "K\0", "K\0", "K\0", "K\0", "M\0", "W\0", "I\0", "I\0", "I\0", "I\0" },
        { "Imb\0", "Kaw\0", "Kad\0", "Kan\0", "Kas\0", "Kar\0", "Mfu\0", "Wun\0", "Ike\0", "Iku\0", "Imw\0", "Iwi\0" },
        { "Mori ghwa imbiri\0", "Mori ghwa kawi\0", "Mori ghwa kadadu\0", "Mori ghwa kana\0", "Mori ghwa kasanu\0", "Mori ghwa karandadu\0", "Mori ghwa mfungade\0", "Mori ghwa wunyanya\0", "Mori ghwa ikenda\0", "Mori ghwa ikumi\0", "Mori ghwa ikumi na imweri\0", "Mori ghwa ikumi na iwi\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "J\0", "K\0", "K\0", "K\0", "K\0", "N\0", "J\0" },
        { "Jim\0", "Kaw\0", "Kad\0", "Kan\0", "Kas\0", "Ngu\0", "Jum\0" },
        { "Kuramuka jimweri\0", "Kuramuka kawi\0", "Kuramuka kadadu\0", "Kuramuka kana\0", "Kuramuka kasanu\0", "Kifula nguwo\0", "Ituku ja jumwa\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // dav_KE
    {
        QLocale::Language::German, QLocale::Script::LatinScript, QLocale::Country::Austria,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Deutsch\0", "Österreich\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jän\0", "Feb\0", "Mär\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Jänner\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jän.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Jänner\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mo\0", "Di\0", "Mi\0", "Do\0", "Fr\0", "Sa\0", "So\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mo.\0", "Di.\0", "Mi.\0", "Do.\0", "Fr.\0", "Sa.\0", "So.\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" }
    }, // de_AT
    {
        QLocale::Language::German, QLocale::Script::LatinScript, QLocale::Country::Belgium,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Deutsch\0", "Belgien\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mär\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sept.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mo\0", "Di\0", "Mi\0", "Do\0", "Fr\0", "Sa\0", "So\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mo.\0", "Di.\0", "Mi.\0", "Do.\0", "Fr.\0", "Sa.\0", "So.\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" }
    }, // de_BE
    {
        QLocale::Language::German, QLocale::Script::LatinScript, QLocale::Country::Switzerland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 8217, 59, 37, 45, 43, 69, 48,
        "Deutsch\0", "Schweiz\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mär\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sept.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mo\0", "Di\0", "Mi\0", "Do\0", "Fr\0", "Sa\0", "So\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mo.\0", "Di.\0", "Mi.\0", "Do.\0", "Fr.\0", "Sa.\0", "So.\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" }
    }, // de_CH
    {
        QLocale::Language::German, QLocale::Script::LatinScript, QLocale::Country::Germany,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Deutsch\0", "Deutschland\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mär\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sept.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mo\0", "Di\0", "Mi\0", "Do\0", "Fr\0", "Sa\0", "So\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mo.\0", "Di.\0", "Mi.\0", "Do.\0", "Fr.\0", "Sa.\0", "So.\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" }
    }, // de_DE
    {
        QLocale::Language::German, QLocale::Script::LatinScript, QLocale::Country::Italy,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Deutsch\0", "Italien\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jän\0", "Feb\0", "Mär\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Jänner\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jän.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Jänner\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mo\0", "Di\0", "Mi\0", "Do\0", "Fr\0", "Sa\0", "So\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mo.\0", "Di.\0", "Mi.\0", "Do.\0", "Fr.\0", "Sa.\0", "So.\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" }
    }, // de_IT
    {
        QLocale::Language::German, QLocale::Script::LatinScript, QLocale::Country::Liechtenstein,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 8217, 59, 37, 45, 43, 69, 48,
        "Deutsch\0", "Liechtenstein\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mär\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sept.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mo\0", "Di\0", "Mi\0", "Do\0", "Fr\0", "Sa\0", "So\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mo.\0", "Di.\0", "Mi.\0", "Do.\0", "Fr.\0", "Sa.\0", "So.\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" }
    }, // de_LI
    {
        QLocale::Language::German, QLocale::Script::LatinScript, QLocale::Country::Luxembourg,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Deutsch\0", "Luxemburg\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mär\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sept.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mo\0", "Di\0", "Mi\0", "Do\0", "Fr\0", "Sa\0", "So\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mo.\0", "Di.\0", "Mi.\0", "Do.\0", "Fr.\0", "Sa.\0", "So.\0" },
        { "Montag\0", "Dienstag\0", "Mittwoch\0", "Donnerstag\0", "Freitag\0", "Samstag\0", "Sonntag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" }
    }, // de_LU
    {
        QLocale::Language::Zarma, QLocale::Script::LatinScript, QLocale::Country::Niger,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 160, 59, 37, 45, 43, 69, 48,
        "Zarmaciine\0", "Nižer\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Subbaahi\0", "Zaarikay b\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "Ž\0", "F\0", "M\0", "A\0", "M\0", "Ž\0", "Ž\0", "U\0", "S\0", "O\0", "N\0", "D\0" },
        { "Žan\0", "Fee\0", "Mar\0", "Awi\0", "Me\0", "Žuw\0", "Žuy\0", "Ut\0", "Sek\0", "Okt\0", "Noo\0", "Dee\0" },
        { "Žanwiye\0", "Feewiriye\0", "Marsi\0", "Awiril\0", "Me\0", "Žuweŋ\0", "Žuyye\0", "Ut\0", "Sektanbur\0", "Oktoobur\0", "Noowanbur\0", "Deesanbur\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "T\0", "T\0", "L\0", "M\0", "Z\0", "S\0", "H\0" },
        { "Ati\0", "Ata\0", "Ala\0", "Alm\0", "Alz\0", "Asi\0", "Alh\0" },
        { "Atinni\0", "Atalaata\0", "Alarba\0", "Alhamisi\0", "Alzuma\0", "Asibti\0", "Alhadi\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // dje_NE
    {
        QLocale::Language::Dogri, QLocale::Script::DevanagariScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "डोगरी\0", "भारत\0",
        "d/M/yyyy\0", "d, MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "सवेर\0", "स’ञ\0",
        { "जन.\0", "फर.\0", "मार्च\0", "अप्रैल\0", "मेई\0", "जून\0", "जुलाई\0", "अग.\0", "सित.\0", "अक्तू.\0", "नव.\0", "दिस.\0" },
        { "जनवरी\0", "फरवरी\0", "मार्च\0", "अप्रैल\0", "मेई\0", "जून\0", "जुलाई\0", "अगस्त\0", "सितंबर\0", "अक्तूबर\0", "नवंबर\0", "दिसंबर\0" },
        { "ज\0", "फ\0", "मा\0", "अ\0", "मे\0", "जू\0", "जु\0", "अ\0", "सि\0", "अ\0", "न\0", "दि\0" },
        { "जन.\0", "फर.\0", "मार्च\0", "अप्रैल\0", "मेई\0", "जून\0", "जुलाई\0", "अग.\0", "सित.\0", "अक्तू.\0", "नव.\0", "दिस.\0" },
        { "जनवरी\0", "फरवरी\0", "मार्च\0", "अप्रैल\0", "मेई\0", "जून\0", "जुलाई\0", "अगस्त\0", "सितंबर\0", "अत्तूबर\0", "नवबर\0", "दिसंबर\0" },
        { "ज\0", "फ\0", "मा\0", "अ\0", "मे\0", "जू\0", "जु\0", "अ\0", "सि\0", "अ\0", "न\0", "दि\0" },
        { "सोम\0", "मंगल\0", "बुध\0", "बीर\0", "शुक्र\0", "शनि\0", "ऐत\0" },
        { "सोमबार\0", "मंगलबार\0", "बुधबार\0", "बीरबार\0", "शुक्रबार\0", "शनिबार\0", "ऐतबार\0" },
        { "सो\0", "म.\0", "बु.\0", "बी.\0", "शु.\0", "श.\0", "ऐ\0" },
        { "सोम\0", "मंगल\0", "बुध\0", "बीर\0", "शुक्र\0", "शनि\0", "ऐत\0" },
        { "सोमबार\0", "मंगलबार\0", "बुधबार\0", "बीरबार\0", "शुक्रबार\0", "शनीबार\0", "ऐतबार\0" },
        { "सो.\0", "म.\0", "बु.\0", "बी.\0", "शु.\0", "श.\0", "ऐ.\0" }
    }, // doi_IN
    {
        QLocale::Language::LowerSorbian, QLocale::Script::LatinScript, QLocale::Country::Germany,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "dolnoserbšćina\0", "Nimska\0",
        "d.M.yyyy\0", "d. MMMM yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "dopołdnja\0", "wótpołdnja\0",
        { "jan\0", "feb\0", "měr\0", "apr\0", "maj\0", "jun\0", "jul\0", "awg\0", "sep\0", "okt\0", "now\0", "dec\0" },
        { "januar\0", "februar\0", "měrc\0", "apryl\0", "maj\0", "junij\0", "julij\0", "awgust\0", "september\0", "oktober\0", "nowember\0", "december\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "jan.\0", "feb.\0", "měr.\0", "apr.\0", "maj.\0", "jun.\0", "jul.\0", "awg.\0", "sep.\0", "okt.\0", "now.\0", "dec.\0" },
        { "januara\0", "februara\0", "měrca\0", "apryla\0", "maja\0", "junija\0", "julija\0", "awgusta\0", "septembra\0", "oktobra\0", "nowembra\0", "decembra\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "pón\0", "wał\0", "srj\0", "stw\0", "pět\0", "sob\0", "nje\0" },
        { "pónjeźele\0", "wałtora\0", "srjoda\0", "stwórtk\0", "pětk\0", "sobota\0", "njeźela\0" },
        { "p\0", "w\0", "s\0", "s\0", "p\0", "s\0", "n\0" },
        { "pón\0", "wał\0", "srj\0", "stw\0", "pět\0", "sob\0", "nje\0" },
        { "pónjeźele\0", "wałtora\0", "srjoda\0", "stwórtk\0", "pětk\0", "sobota\0", "njeźela\0" },
        { "p\0", "w\0", "s\0", "s\0", "p\0", "s\0", "n\0" }
    }, // dsb_DE
    {
        QLocale::Language::Duala, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "duálá\0", "Cameroun\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "idiɓa\0", "ebyámu\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "d\0", "ŋ\0", "s\0", "d\0", "e\0", "e\0", "m\0", "d\0", "n\0", "m\0", "t\0", "e\0" },
        { "di\0", "ŋgɔn\0", "sɔŋ\0", "diɓ\0", "emi\0", "esɔ\0", "mad\0", "diŋ\0", "nyɛt\0", "may\0", "tin\0", "elá\0" },
        { "dimɔ́di\0", "ŋgɔndɛ\0", "sɔŋɛ\0", "diɓáɓá\0", "emiasele\0", "esɔpɛsɔpɛ\0", "madiɓɛ́díɓɛ́\0", "diŋgindi\0", "nyɛtɛki\0", "mayésɛ́\0", "tiníní\0", "eláŋgɛ́\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "m\0", "k\0", "m\0", "ŋ\0", "ɗ\0", "e\0", "e\0" },
        { "mɔ́s\0", "kwa\0", "muk\0", "ŋgi\0", "ɗón\0", "esa\0", "ét\0" },
        { "mɔ́sú\0", "kwasú\0", "mukɔ́sú\0", "ŋgisú\0", "ɗónɛsú\0", "esaɓasú\0", "éti\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // dua_CM
    {
        QLocale::Language::JolaFonyi, QLocale::Script::LatinScript, QLocale::Country::Senegal,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "joola\0", "Senegal\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "S\0", "F\0", "M\0", "A\0", "M\0", "S\0", "S\0", "U\0", "S\0", "O\0", "N\0", "D\0" },
        { "Sa\0", "Fe\0", "Ma\0", "Ab\0", "Me\0", "Su\0", "Sú\0", "Ut\0", "Se\0", "Ok\0", "No\0", "De\0" },
        { "Sanvie\0", "Fébirie\0", "Mars\0", "Aburil\0", "Mee\0", "Sueŋ\0", "Súuyee\0", "Ut\0", "Settembar\0", "Oktobar\0", "Novembar\0", "Disambar\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "T\0", "T\0", "A\0", "A\0", "A\0", "S\0", "D\0" },
        { "Ten\0", "Tal\0", "Ala\0", "Ara\0", "Arj\0", "Sib\0", "Dim\0" },
        { "Teneŋ\0", "Talata\0", "Alarbay\0", "Aramisay\0", "Arjuma\0", "Sibiti\0", "Dimas\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // dyo_SN
    {
        QLocale::Language::Dzongkha, QLocale::Script::TibetanScript, QLocale::Country::Bhutan,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 3872,
        "རྫོང་ཁ\0", "འབྲུག\0",
        "yyyy-MM-dd\0", "སྤྱི་ལོ་yyyy MMMM ཚེས་ dd\0", "ཆུ་ཚོད་ h སྐར་མ་ mm AP\0", "ཆུ་ཚོད་ h སྐར་མ་ mm:ss AP Z\0",
        "སྔ་ཆ་\0", "ཕྱི་ཆ་\0",
        { "ཟླ་༡\0", "ཟླ་༢\0", "ཟླ་༣\0", "ཟླ་༤\0", "ཟླ་༥\0", "ཟླ་༦\0", "ཟླ་༧\0", "ཟླ་༨\0", "ཟླ་༩\0", "ཟླ་༡༠\0", "ཟླ་༡༡\0", "ཟླ་༡༢\0" },
        { "སྤྱི་ཟླ་དངཔ་\0", "སྤྱི་ཟླ་གཉིས་པ་\0", "སྤྱི་ཟླ་གསུམ་པ་\0", "སྤྱི་ཟླ་བཞི་པ\0", "སྤྱི་ཟླ་ལྔ་པ་\0", "སྤྱི་ཟླ་དྲུག་པ\0", "སྤྱི་ཟླ་བདུན་པ་\0", "སྤྱི་ཟླ་བརྒྱད་པ་\0", "སྤྱི་ཟླ་དགུ་པ་\0", "སྤྱི་ཟླ་བཅུ་པ་\0", "སྤྱི་ཟླ་བཅུ་གཅིག་པ་\0", "སྤྱི་ཟླ་བཅུ་གཉིས་པ་\0" },
        { "༡\0", "༢\0", "༣\0", "༤\0", "༥\0", "༦\0", "༧\0", "༨\0", "༩\0", "༡༠\0", "༡༡\0", "༡༢\0" },
        { "༡\0", "༢\0", "༣\0", "༤\0", "༥\0", "༦\0", "༧\0", "༨\0", "༩\0", "༡༠\0", "༡༡\0", "12\0" },
        { "ཟླ་དངཔ་\0", "ཟླ་གཉིས་པ་\0", "ཟླ་གསུམ་པ་\0", "ཟླ་བཞི་པ་\0", "ཟླ་ལྔ་པ་\0", "ཟླ་དྲུག་པ\0", "ཟླ་བདུན་པ་\0", "ཟླ་བརྒྱད་པ་\0", "ཟླ་དགུ་པ་\0", "ཟླ་བཅུ་པ་\0", "ཟླ་བཅུ་གཅིག་པ་\0", "ཟླ་བཅུ་གཉིས་པ་\0" },
        { "༡\0", "༢\0", "༣\0", "4\0", "༥\0", "༦\0", "༧\0", "༨\0", "9\0", "༡༠\0", "༡༡\0", "༡༢\0" },
        { "མིར་\0", "ལྷག་\0", "ཕུར་\0", "སངས་\0", "སྤེན་\0", "ཉི་\0", "ཟླ་\0" },
        { "གཟའ་མིག་དམར་\0", "གཟའ་ལྷག་པ་\0", "གཟའཕུར་བུ་\0", "གཟའ་པ་སངས་\0", "གཟའ་སྤེན་པ་\0", "གཟའ་ཉི་མ་\0", "གཟའ་ཟླ་བ་\0" },
        { "མིར\0", "ལྷག\0", "ཕུར\0", "སངྶ\0", "སྤེན\0", "ཉི\0", "ཟླ\0" },
        { "མིར་\0", "ལྷག་\0", "ཕུར་\0", "སངས་\0", "སྤེན་\0", "ཉི་\0", "ཟླ་\0" },
        { "གཟའ་མིག་དམར་\0", "གཟའ་ལྷག་པ་\0", "གཟའ་ཕུར་བུ་\0", "གཟའ་པ་སངས་\0", "གཟའ་སྤེན་པ་\0", "གཟའ་ཉི་མ་\0", "གཟའ་ཟླ་བ་\0" },
        { "མིར\0", "ལྷག\0", "ཕུར\0", "སངྶ\0", "སྤེན\0", "ཉི\0", "ཟླ\0" }
    }, // dz_BT
    {
        QLocale::Language::Embu, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kĩembu\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "KI\0", "UT\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "M\0", "K\0", "K\0", "K\0", "G\0", "G\0", "M\0", "K\0", "K\0", "I\0", "I\0", "I\0" },
        { "Mbe\0", "Kai\0", "Kat\0", "Kan\0", "Gat\0", "Gan\0", "Mug\0", "Knn\0", "Ken\0", "Iku\0", "Imw\0", "Igi\0" },
        { "Mweri wa mbere\0", "Mweri wa kaĩri\0", "Mweri wa kathatũ\0", "Mweri wa kana\0", "Mweri wa gatano\0", "Mweri wa gatantatũ\0", "Mweri wa mũgwanja\0", "Mweri wa kanana\0", "Mweri wa kenda\0", "Mweri wa ikũmi\0", "Mweri wa ikũmi na ũmwe\0", "Mweri wa ikũmi na Kaĩrĩ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "N\0", "N\0", "N\0", "A\0", "M\0", "N\0", "K\0" },
        { "Tat\0", "Ine\0", "Tan\0", "Arm\0", "Maa\0", "NMM\0", "Kma\0" },
        { "Njumatatu\0", "Njumaine\0", "Njumatano\0", "Aramithi\0", "Njumaa\0", "NJumamothii\0", "Kiumia\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ebu_KE
    {
        QLocale::Language::Ewe, QLocale::Script::LatinScript, QLocale::Country::Ghana,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Eʋegbe\0", "Ghana nutome\0",
        "M/d/yyyy\0", "MMMM d 'iAP' yyyy\0", "AP 'AP' h:mm\0", "AP 'AP' h:mm:ss Z\0",
        "ŋdi\0", "ɣetrɔ\0",
        { "dzv\0", "dzd\0", "ted\0", "afɔ\0", "dam\0", "mas\0", "sia\0", "dea\0", "any\0", "kel\0", "ade\0", "dzm\0" },
        { "dzove\0", "dzodze\0", "tedoxe\0", "afɔfĩe\0", "dama\0", "masa\0", "siamlɔm\0", "deasiamime\0", "anyɔnyɔ\0", "kele\0", "adeɛmekpɔxe\0", "dzome\0" },
        { "d\0", "d\0", "t\0", "a\0", "d\0", "m\0", "s\0", "d\0", "a\0", "k\0", "a\0", "d\0" },
        { "dzv\0", "dzd\0", "ted\0", "afɔ\0", "dam\0", "mas\0", "sia\0", "dea\0", "any\0", "kel\0", "ade\0", "dzm\0" },
        { "dzove\0", "dzodze\0", "tedoxe\0", "afɔfĩe\0", "dama\0", "masa\0", "siamlɔm\0", "deasiamime\0", "anyɔnyɔ\0", "kele\0", "adeɛmekpɔxe\0", "dzome\0" },
        { "d\0", "d\0", "t\0", "a\0", "d\0", "m\0", "s\0", "d\0", "a\0", "k\0", "a\0", "d\0" },
        { "dzo\0", "bla\0", "kuɖ\0", "yaw\0", "fiɖ\0", "mem\0", "kɔs\0" },
        { "dzoɖa\0", "blaɖa\0", "kuɖa\0", "yawoɖa\0", "fiɖa\0", "memleɖa\0", "kɔsiɖa\0" },
        { "d\0", "b\0", "k\0", "y\0", "f\0", "m\0", "k\0" },
        { "dzo\0", "bla\0", "kuɖ\0", "yaw\0", "fiɖ\0", "mem\0", "kɔs\0" },
        { "dzoɖa\0", "blaɖa\0", "kuɖa\0", "yawoɖa\0", "fiɖa\0", "memleɖa\0", "kɔsiɖa\0" },
        { "d\0", "b\0", "k\0", "y\0", "f\0", "m\0", "k\0" }
    }, // ee_GH
    {
        QLocale::Language::Ewe, QLocale::Script::LatinScript, QLocale::Country::Togo,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Eʋegbe\0", "Togo nutome\0",
        "M/d/yyyy\0", "MMMM d 'iAP' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ŋdi\0", "ɣetrɔ\0",
        { "dzv\0", "dzd\0", "ted\0", "afɔ\0", "dam\0", "mas\0", "sia\0", "dea\0", "any\0", "kel\0", "ade\0", "dzm\0" },
        { "dzove\0", "dzodze\0", "tedoxe\0", "afɔfĩe\0", "dama\0", "masa\0", "siamlɔm\0", "deasiamime\0", "anyɔnyɔ\0", "kele\0", "adeɛmekpɔxe\0", "dzome\0" },
        { "d\0", "d\0", "t\0", "a\0", "d\0", "m\0", "s\0", "d\0", "a\0", "k\0", "a\0", "d\0" },
        { "dzv\0", "dzd\0", "ted\0", "afɔ\0", "dam\0", "mas\0", "sia\0", "dea\0", "any\0", "kel\0", "ade\0", "dzm\0" },
        { "dzove\0", "dzodze\0", "tedoxe\0", "afɔfĩe\0", "dama\0", "masa\0", "siamlɔm\0", "deasiamime\0", "anyɔnyɔ\0", "kele\0", "adeɛmekpɔxe\0", "dzome\0" },
        { "d\0", "d\0", "t\0", "a\0", "d\0", "m\0", "s\0", "d\0", "a\0", "k\0", "a\0", "d\0" },
        { "dzo\0", "bla\0", "kuɖ\0", "yaw\0", "fiɖ\0", "mem\0", "kɔs\0" },
        { "dzoɖa\0", "blaɖa\0", "kuɖa\0", "yawoɖa\0", "fiɖa\0", "memleɖa\0", "kɔsiɖa\0" },
        { "d\0", "b\0", "k\0", "y\0", "f\0", "m\0", "k\0" },
        { "dzo\0", "bla\0", "kuɖ\0", "yaw\0", "fiɖ\0", "mem\0", "kɔs\0" },
        { "dzoɖa\0", "blaɖa\0", "kuɖa\0", "yawoɖa\0", "fiɖa\0", "memleɖa\0", "kɔsiɖa\0" },
        { "d\0", "b\0", "k\0", "y\0", "f\0", "m\0", "k\0" }
    }, // ee_TG
    {
        QLocale::Language::Greek, QLocale::Script::GreekScript, QLocale::Country::Cyprus,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 101, 48,
        "Ελληνικά\0", "Κύπρος\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "π.μ.\0", "μ.μ.\0",
        { "Ιαν\0", "Φεβ\0", "Μάρ\0", "Απρ\0", "Μάι\0", "Ιούν\0", "Ιούλ\0", "Αύγ\0", "Σεπ\0", "Οκτ\0", "Νοέ\0", "Δεκ\0" },
        { "Ιανουάριος\0", "Φεβρουάριος\0", "Μάρτιος\0", "Απρίλιος\0", "Μάιος\0", "Ιούνιος\0", "Ιούλιος\0", "Αύγουστος\0", "Σεπτέμβριος\0", "Οκτώβριος\0", "Νοέμβριος\0", "Δεκέμβριος\0" },
        { "Ι\0", "Φ\0", "Μ\0", "Α\0", "Μ\0", "Ι\0", "Ι\0", "Α\0", "Σ\0", "Ο\0", "Ν\0", "Δ\0" },
        { "Ιαν\0", "Φεβ\0", "Μαρ\0", "Απρ\0", "Μαΐ\0", "Ιουν\0", "Ιουλ\0", "Αυγ\0", "Σεπ\0", "Οκτ\0", "Νοε\0", "Δεκ\0" },
        { "Ιανουαρίου\0", "Φεβρουαρίου\0", "Μαρτίου\0", "Απριλίου\0", "Μαΐου\0", "Ιουνίου\0", "Ιουλίου\0", "Αυγούστου\0", "Σεπτεμβρίου\0", "Οκτωβρίου\0", "Νοεμβρίου\0", "Δεκεμβρίου\0" },
        { "Ι\0", "Φ\0", "Μ\0", "Α\0", "Μ\0", "Ι\0", "Ι\0", "Α\0", "Σ\0", "Ο\0", "Ν\0", "Δ\0" },
        { "Δευ\0", "Τρί\0", "Τετ\0", "Πέμ\0", "Παρ\0", "Σάβ\0", "Κυρ\0" },
        { "Δευτέρα\0", "Τρίτη\0", "Τετάρτη\0", "Πέμπτη\0", "Παρασκευή\0", "Σάββατο\0", "Κυριακή\0" },
        { "Δ\0", "Τ\0", "Τ\0", "Π\0", "Π\0", "Σ\0", "Κ\0" },
        { "Δευ\0", "Τρί\0", "Τετ\0", "Πέμ\0", "Παρ\0", "Σάβ\0", "Κυρ\0" },
        { "Δευτέρα\0", "Τρίτη\0", "Τετάρτη\0", "Πέμπτη\0", "Παρασκευή\0", "Σάββατο\0", "Κυριακή\0" },
        { "Δ\0", "Τ\0", "Τ\0", "Π\0", "Π\0", "Σ\0", "Κ\0" }
    }, // el_CY
    {
        QLocale::Language::Greek, QLocale::Script::GreekScript, QLocale::Country::Greece,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 101, 48,
        "Ελληνικά\0", "Ελλάδα\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "π.μ.\0", "μ.μ.\0",
        { "Ιαν\0", "Φεβ\0", "Μάρ\0", "Απρ\0", "Μάι\0", "Ιούν\0", "Ιούλ\0", "Αύγ\0", "Σεπ\0", "Οκτ\0", "Νοέ\0", "Δεκ\0" },
        { "Ιανουάριος\0", "Φεβρουάριος\0", "Μάρτιος\0", "Απρίλιος\0", "Μάιος\0", "Ιούνιος\0", "Ιούλιος\0", "Αύγουστος\0", "Σεπτέμβριος\0", "Οκτώβριος\0", "Νοέμβριος\0", "Δεκέμβριος\0" },
        { "Ι\0", "Φ\0", "Μ\0", "Α\0", "Μ\0", "Ι\0", "Ι\0", "Α\0", "Σ\0", "Ο\0", "Ν\0", "Δ\0" },
        { "Ιαν\0", "Φεβ\0", "Μαρ\0", "Απρ\0", "Μαΐ\0", "Ιουν\0", "Ιουλ\0", "Αυγ\0", "Σεπ\0", "Οκτ\0", "Νοε\0", "Δεκ\0" },
        { "Ιανουαρίου\0", "Φεβρουαρίου\0", "Μαρτίου\0", "Απριλίου\0", "Μαΐου\0", "Ιουνίου\0", "Ιουλίου\0", "Αυγούστου\0", "Σεπτεμβρίου\0", "Οκτωβρίου\0", "Νοεμβρίου\0", "Δεκεμβρίου\0" },
        { "Ι\0", "Φ\0", "Μ\0", "Α\0", "Μ\0", "Ι\0", "Ι\0", "Α\0", "Σ\0", "Ο\0", "Ν\0", "Δ\0" },
        { "Δευ\0", "Τρί\0", "Τετ\0", "Πέμ\0", "Παρ\0", "Σάβ\0", "Κυρ\0" },
        { "Δευτέρα\0", "Τρίτη\0", "Τετάρτη\0", "Πέμπτη\0", "Παρασκευή\0", "Σάββατο\0", "Κυριακή\0" },
        { "Δ\0", "Τ\0", "Τ\0", "Π\0", "Π\0", "Σ\0", "Κ\0" },
        { "Δευ\0", "Τρί\0", "Τετ\0", "Πέμ\0", "Παρ\0", "Σάβ\0", "Κυρ\0" },
        { "Δευτέρα\0", "Τρίτη\0", "Τετάρτη\0", "Πέμπτη\0", "Παρασκευή\0", "Σάββατο\0", "Κυριακή\0" },
        { "Δ\0", "Τ\0", "Τ\0", "Π\0", "Π\0", "Σ\0", "Κ\0" }
    }, // el_GR
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::world,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "world\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "M01\0", "M02\0", "M03\0", "M04\0", "M05\0", "M06\0", "M07\0", "M08\0", "M09\0", "M10\0", "M11\0", "M12\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_001
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Europe,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Europe\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_150
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::UnitedArabEmirates,
        Qt::Saturday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "United Arab Emirates\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "M01\0", "M02\0", "M03\0", "M04\0", "M05\0", "M06\0", "M07\0", "M08\0", "M09\0", "M10\0", "M11\0", "M12\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_AE
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::AntiguaAndBarbuda,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Antigua & Barbuda\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_AG
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Anguilla,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Anguilla\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_AI
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::AmericanSamoa,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "American Samoa\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_AS
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Austria,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "English\0", "Austria\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_AT
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Australia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 101, 48,
        "English\0", "Australia\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "June\0", "July\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M.\0", "Tu.\0", "W.\0", "Th.\0", "F.\0", "Sa.\0", "Su.\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M.\0", "Tu.\0", "W.\0", "Th.\0", "F.\0", "Sa.\0", "Su.\0" }
    }, // en_AU
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Barbados,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Barbados\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_BB
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Belgium,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "English\0", "Belgium\0",
        "dd/MM/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_BE
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Burundi,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Burundi\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "M01\0", "M02\0", "M03\0", "M04\0", "M05\0", "M06\0", "M07\0", "M08\0", "M09\0", "M10\0", "M11\0", "M12\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_BI
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Bermuda,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Bermuda\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_BM
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Bahamas,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Bahamas\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_BS
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Botswana,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Botswana\0",
        "dd/MM/yyyy\0", "dd MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_BW
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Belize,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Belize\0",
        "dd/MM/yyyy\0", "dd MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_BZ
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Canada,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Canada\0",
        "yyyy-MM-dd\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "a.m.\0", "p.m.\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "M01\0", "M02\0", "M03\0", "M04\0", "M05\0", "M06\0", "M07\0", "M08\0", "M09\0", "M10\0", "M11\0", "M12\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_CA
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::CocosKeelingIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Cocos (Keeling) Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_CC
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Switzerland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 8217, 59, 37, 45, 43, 69, 48,
        "English\0", "Switzerland\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_CH
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::CookIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Cook Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_CK
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Cameroon\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_CM
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::ChristmasIsland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Christmas Island\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_CX
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Cyprus,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Cyprus\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_CY
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Germany,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "English\0", "Germany\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_DE
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::DiegoGarcia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Diego Garcia\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_DG
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Denmark,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "English\0", "Denmark\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH.mm\0", "HH.mm.ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_DK
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Dominica,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Dominica\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_DM
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Eritrea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Eritrea\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_ER
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Finland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "English\0", "Finland\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "H.mm\0", "H.mm.ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_FI
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Fiji,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Fiji\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_FJ
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::FalklandIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Falkland Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_FK
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Micronesia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Micronesia\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_FM
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::UnitedKingdom,
        Qt::Sunday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "United Kingdom\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // en_GB
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Grenada,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Grenada\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_GD
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Guernsey,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Guernsey\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_GG
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Ghana,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Ghana\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_GH
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Gibraltar,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Gibraltar\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_GI
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Gambia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Gambia\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_GM
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Guam,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Guam\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_GU
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Guyana,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Guyana\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_GY
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::HongKongSARChina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Hong Kong SAR China\0",
        "d/M/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_HK
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Ireland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Ireland\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_IE
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Israel,
        Qt::Monday, Qt::Friday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Israel\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_IL
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::IsleofMan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Isle of Man\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_IM
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "India\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_IN
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::BritishIndianOceanTerritory,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "British Indian Ocean Territory\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_IO
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Jersey,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Jersey\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_JE
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Jamaica,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Jamaica\0",
        "d/M/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_JM
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Kenya\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_KE
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Kiribati,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Kiribati\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_KI
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::StKittsAndNevis,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "St. Kitts & Nevis\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_KN
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::CaymanIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Cayman Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_KY
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::StLucia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "St. Lucia\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_LC
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Liberia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Liberia\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_LR
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Lesotho,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Lesotho\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_LS
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Madagascar,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Madagascar\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_MG
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::MarshallIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Marshall Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_MH
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::MacaoSARChina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Macao SAR China\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_MO
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::NorthernMarianaIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Northern Mariana Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_MP
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Montserrat,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Montserrat\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_MS
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Malta,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Malta\0",
        "M/d/yyyy\0", "dd MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_MT
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Mauritius,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Mauritius\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_MU
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Maldives,
        Qt::Friday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Maldives\0",
        "d-M-yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_MV
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Malawi,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Malawi\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_MW
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Malaysia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Malaysia\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_MY
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Namibia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Namibia\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_NA
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::NorfolkIsland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Norfolk Island\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_NF
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Nigeria,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Nigeria\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_NG
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Netherlands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "English\0", "Netherlands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_NL
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Nauru,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Nauru\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_NR
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Niue,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Niue\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_NU
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::NewZealand,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "New Zealand\0",
        "d/MM/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_NZ
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::PapuaNewGuinea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Papua New Guinea\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_PG
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Philippines,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Philippines\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_PH
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Pakistan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Pakistan\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_PK
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::PitcairnIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Pitcairn Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_PN
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::PuertoRico,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Puerto Rico\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_PR
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Palau,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Palau\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_PW
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Rwanda,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Rwanda\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_RW
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::SolomonIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Solomon Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SB
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Seychelles,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Seychelles\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SC
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Sudan,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Sudan\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SD
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Sweden,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "English\0", "Sweden\0",
        "yyyy-MM-dd\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SE
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Singapore,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Singapore\0",
        "d/M/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SG
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::StHelena,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "St. Helena\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SH
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::Slovenia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 101, 48,
        "English\0", "Slovenia\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SI
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::SierraLeone,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Sierra Leone\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SL
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::SouthSudan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "South Sudan\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SS
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::SintMaarten,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Sint Maarten\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SX
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Eswatini,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Eswatini\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_SZ
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::TurksAndCaicosIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Turks & Caicos Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_TC
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Tokelau,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Tokelau\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_TK
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Tonga,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Tonga\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_TO
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::TrinidadAndTobago,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Trinidad & Tobago\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_TT
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Tuvalu,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Tuvalu\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_TV
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Tanzania\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_TZ
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Uganda,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Uganda\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_UG
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::UnitedStatesOutlyingIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "U.S. Outlying Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_UM
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::UnitedStates,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "United States\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_US
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::StVincentAndGrenadines,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "St. Vincent & Grenadines\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_VC
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::BritishVirginIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "British Virgin Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_VG
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::UnitedStatesVirginIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "U.S. Virgin Islands\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_VI
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Vanuatu,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Vanuatu\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_VU
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Samoa,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Samoa\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_WS
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::SouthAfrica,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "English\0", "South Africa\0",
        "yyyy/MM/dd\0", "dd MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_ZA
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Zambia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Zambia\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_ZM
    {
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::Zimbabwe,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "English\0", "Zimbabwe\0",
        "d/M/yyyy\0", "dd MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sept\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // en_ZW
    {
        QLocale::Language::Esperanto, QLocale::Script::LatinScript, QLocale::Country::world,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "esperanto\0", "Mondo\0",
        "yyyy-MM-dd\0", "yyyy-MMMM-dd\0", "HH:mm\0", "HH:mm:ss Z\0",
        "atm\0", "ptm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "januaro\0", "februaro\0", "marto\0", "aprilo\0", "majo\0", "junio\0", "julio\0", "aŭgusto\0", "septembro\0", "oktobro\0", "novembro\0", "decembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan\0", "feb\0", "mar\0", "apr\0", "maj\0", "jun\0", "jul\0", "aŭg\0", "sep\0", "okt\0", "nov\0", "dec\0" },
        { "januaro\0", "februaro\0", "marto\0", "aprilo\0", "majo\0", "junio\0", "julio\0", "aŭgusto\0", "septembro\0", "oktobro\0", "novembro\0", "decembro\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "lundo\0", "mardo\0", "merkredo\0", "ĵaŭdo\0", "vendredo\0", "sabato\0", "dimanĉo\0" },
        { "L\0", "M\0", "M\0", "Ĵ\0", "V\0", "S\0", "D\0" },
        { "lu\0", "ma\0", "me\0", "ĵa\0", "ve\0", "sa\0", "di\0" },
        { "lundo\0", "mardo\0", "merkredo\0", "ĵaŭdo\0", "vendredo\0", "sabato\0", "dimanĉo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // eo_001
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::LatinAmerica,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "español\0", "Latinoamérica\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "l\0", "m\0", "m\0", "j\0", "v\0", "s\0", "d\0" }
    }, // es_419
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Argentina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Argentina\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_AR
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Bolivia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Bolivia\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_BO
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Brazil,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Brasil\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_BR
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Belize,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Belice\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_BZ
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Chile,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Chile\0",
        "dd-MM-yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene.\0", "feb.\0", "mar.\0", "abr.\0", "may.\0", "jun.\0", "jul.\0", "ago.\0", "sept.\0", "oct.\0", "nov.\0", "dic.\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_CL
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Colombia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Colombia\0",
        "d/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "a. m.\0", "p. m.\0",
        { "ene.\0", "feb.\0", "mar.\0", "abr.\0", "may.\0", "jun.\0", "jul.\0", "ago.\0", "sept.\0", "oct.\0", "nov.\0", "dic.\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "l\0", "m\0", "m\0", "j\0", "v\0", "s\0", "d\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_CO
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::CostaRica,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "español\0", "Costa Rica\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_CR
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Cuba,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Cuba\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_CU
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::DominicanRepublic,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "República Dominicana\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_DO
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::CeutaAndMelilla,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Ceuta y Melilla\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_EA
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Ecuador,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Ecuador\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_EC
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Spain,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "España\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_ES
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::EquatorialGuinea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Guinea Ecuatorial\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_GQ
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Guatemala,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Guatemala\0",
        "d/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_GT
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Honduras,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Honduras\0",
        "d/M/yyyy\0", "dd 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_HN
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::CanaryIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Canarias\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_IC
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Mexico,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "México\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_MX
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Nicaragua,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Nicaragua\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_NI
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Panama,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Panamá\0",
        "MM/dd/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_PA
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Peru,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Perú\0",
        "d/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "Ene.\0", "Feb.\0", "Mar.\0", "Abr.\0", "May.\0", "Jun.\0", "Jul.\0", "Ago.\0", "Set.\0", "Oct.\0", "Nov.\0", "Dic.\0" },
        { "Enero\0", "Febrero\0", "Marzo\0", "Abril\0", "Mayo\0", "Junio\0", "Julio\0", "Agosto\0", "Setiembre\0", "Octubre\0", "Noviembre\0", "Diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene.\0", "feb.\0", "mar.\0", "abr.\0", "may.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "oct.\0", "nov.\0", "dic.\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "setiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_PE
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Philippines,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Filipinas\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_PH
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::PuertoRico,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Puerto Rico\0",
        "MM/dd/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_PR
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Paraguay,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Paraguay\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene.\0", "feb.\0", "mar.\0", "abr.\0", "may.\0", "jun.\0", "jul.\0", "ago.\0", "sept.\0", "oct.\0", "nov.\0", "dic.\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene.\0", "feb.\0", "mar.\0", "abr.\0", "may.\0", "jun.\0", "jul.\0", "ago.\0", "sept.\0", "oct.\0", "nov.\0", "dic.\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_PY
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::ElSalvador,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "El Salvador\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_SV
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::UnitedStates,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Estados Unidos\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "a. m.\0", "p. m.\0",
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene\0", "feb\0", "mar\0", "abr\0", "may\0", "jun\0", "jul\0", "ago\0", "sept\0", "oct\0", "nov\0", "dic\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_US
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Uruguay,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Uruguay\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "a. m.\0", "p. m.\0",
        { "Ene.\0", "Feb.\0", "Mar.\0", "Abr.\0", "May.\0", "Jun.\0", "Jul.\0", "Ago.\0", "Set.\0", "Oct.\0", "Nov.\0", "Dic.\0" },
        { "Enero\0", "Febrero\0", "Marzo\0", "Abril\0", "Mayo\0", "Junio\0", "Julio\0", "Agosto\0", "Setiembre\0", "Octubre\0", "Noviembre\0", "Diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene.\0", "feb.\0", "mar.\0", "abr.\0", "may.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "oct.\0", "nov.\0", "dic.\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "setiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_UY
    {
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Venezuela,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "español\0", "Venezuela\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "a. m.\0", "p. m.\0",
        { "ene.\0", "feb.\0", "mar.\0", "abr.\0", "may.\0", "jun.\0", "jul.\0", "ago.\0", "sept.\0", "oct.\0", "nov.\0", "dic.\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ene.\0", "feb.\0", "mar.\0", "abr.\0", "may.\0", "jun.\0", "jul.\0", "ago.\0", "sept.\0", "oct.\0", "nov.\0", "dic.\0" },
        { "enero\0", "febrero\0", "marzo\0", "abril\0", "mayo\0", "junio\0", "julio\0", "agosto\0", "septiembre\0", "octubre\0", "noviembre\0", "diciembre\0" },
        { "E\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mié\0", "jue\0", "vie\0", "sáb\0", "dom\0" },
        { "lunes\0", "martes\0", "miércoles\0", "jueves\0", "viernes\0", "sábado\0", "domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // es_VE
    {
        QLocale::Language::Estonian, QLocale::Script::LatinScript, QLocale::Country::Estonia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "eesti\0", "Eesti\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "jaan\0", "veebr\0", "märts\0", "apr\0", "mai\0", "juuni\0", "juuli\0", "aug\0", "sept\0", "okt\0", "nov\0", "dets\0" },
        { "jaanuar\0", "veebruar\0", "märts\0", "aprill\0", "mai\0", "juuni\0", "juuli\0", "august\0", "september\0", "oktoober\0", "november\0", "detsember\0" },
        { "J\0", "V\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jaan\0", "veebr\0", "märts\0", "apr\0", "mai\0", "juuni\0", "juuli\0", "aug\0", "sept\0", "okt\0", "nov\0", "dets\0" },
        { "jaanuar\0", "veebruar\0", "märts\0", "aprill\0", "mai\0", "juuni\0", "juuli\0", "august\0", "september\0", "oktoober\0", "november\0", "detsember\0" },
        { "J\0", "V\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "E\0", "T\0", "K\0", "N\0", "R\0", "L\0", "P\0" },
        { "Esmaspäev\0", "Teisipäev\0", "Kolmapäev\0", "Neljapäev\0", "Reede\0", "Laupäev\0", "Pühapäev\0" },
        { "E\0", "T\0", "K\0", "N\0", "R\0", "L\0", "P\0" },
        { "E\0", "T\0", "K\0", "N\0", "R\0", "L\0", "P\0" },
        { "Esmaspäev\0", "Teisipäev\0", "Kolmapäev\0", "Neljapäev\0", "Reede\0", "Laupäev\0", "Pühapäev\0" },
        { "E\0", "T\0", "K\0", "N\0", "R\0", "L\0", "P\0" }
    }, // et_EE
    {
        QLocale::Language::Basque, QLocale::Script::LatinScript, QLocale::Country::Spain,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 8722, 43, 69, 48,
        "euskara\0", "Espainia\0",
        "yyyy/M/d\0", "yyyy('ddd')'Ho' MMMM'rdddn' d('AP')\0", "HH:mm\0", "HH:mm:ss (Z)\0",
        "AM\0", "PM\0",
        { "urt.\0", "ots.\0", "mar.\0", "api.\0", "mai.\0", "eka.\0", "uzt.\0", "abu.\0", "ira.\0", "urr.\0", "aza.\0", "abe.\0" },
        { "urtarrila\0", "otsaila\0", "martxoa\0", "apirila\0", "maiatza\0", "ekaina\0", "uztaila\0", "abuztua\0", "iraila\0", "urria\0", "azaroa\0", "abendua\0" },
        { "U\0", "O\0", "M\0", "A\0", "M\0", "E\0", "U\0", "A\0", "I\0", "U\0", "A\0", "A\0" },
        { "urt.\0", "ots.\0", "mar.\0", "api.\0", "mai.\0", "eka.\0", "uzt.\0", "abu.\0", "ira.\0", "urr.\0", "aza.\0", "abe.\0" },
        { "urtarrilak\0", "otsailak\0", "martxoak\0", "apirilak\0", "maiatzak\0", "ekainak\0", "uztailak\0", "abuztuak\0", "irailak\0", "urriak\0", "azaroak\0", "abenduak\0" },
        { "U\0", "O\0", "M\0", "A\0", "M\0", "E\0", "U\0", "A\0", "I\0", "U\0", "A\0", "A\0" },
        { "al.\0", "ar.\0", "az.\0", "og.\0", "or.\0", "lr.\0", "ig.\0" },
        { "astelehena\0", "asteartea\0", "asteazkena\0", "osteguna\0", "ostirala\0", "larunbata\0", "igandea\0" },
        { "A\0", "A\0", "A\0", "O\0", "O\0", "L\0", "I\0" },
        { "al.\0", "ar.\0", "az.\0", "og.\0", "or.\0", "lr.\0", "ig.\0" },
        { "astelehena\0", "asteartea\0", "asteazkena\0", "osteguna\0", "ostirala\0", "larunbata\0", "igandea\0" },
        { "A\0", "A\0", "A\0", "O\0", "O\0", "L\0", "I\0" }
    }, // eu_ES
    {
        QLocale::Language::Ewondo, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "ewondo\0", "Kamərún\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "kíkíríg\0", "ngəgógəle\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "o\0", "b\0", "l\0", "n\0", "t\0", "s\0", "z\0", "m\0", "e\0", "a\0", "d\0", "b\0" },
        { "ngo\0", "ngb\0", "ngl\0", "ngn\0", "ngt\0", "ngs\0", "ngz\0", "ngm\0", "nge\0", "nga\0", "ngad\0", "ngab\0" },
        { "ngɔn osú\0", "ngɔn bɛ̌\0", "ngɔn lála\0", "ngɔn nyina\0", "ngɔn tána\0", "ngɔn saməna\0", "ngɔn zamgbála\0", "ngɔn mwom\0", "ngɔn ebulú\0", "ngɔn awóm\0", "ngɔn awóm ai dziá\0", "ngɔn awóm ai bɛ̌\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "m\0", "s\0", "s\0", "s\0", "f\0", "s\0", "s\0" },
        { "mɔ́n\0", "smb\0", "sml\0", "smn\0", "fúl\0", "sér\0", "sɔ́n\0" },
        { "mɔ́ndi\0", "sɔ́ndɔ məlú mə́bɛ̌\0", "sɔ́ndɔ məlú mə́lɛ́\0", "sɔ́ndɔ məlú mə́nyi\0", "fúladé\0", "séradé\0", "sɔ́ndɔ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ewo_CM
    {
        QLocale::Language::Persian, QLocale::Script::ArabicScript, QLocale::Country::Afghanistan,
        Qt::Saturday, Qt::Thursday, Qt::Friday,
        1643, 1644, 59, 1642, 45, 43, 69, 1776,
        "فارسی\0", "افغانستان\0",
        "yyyy/M/d\0", "yyyy MMMM d\0", "H:mm\0", "H:mm:ss (Z)\0",
        "قبل‌ازظهر\0", "بعدازظهر\0",
        { "جنوری\0", "فبروری\0", "مارچ\0", "اپریل\0", "می\0", "جون\0", "جولای\0", "اگست\0", "سپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "جنوری\0", "فبروری\0", "مارچ\0", "اپریل\0", "می\0", "جون\0", "جولای\0", "اگست\0", "سپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "ج\0", "ف\0", "م\0", "ا\0", "م\0", "ج\0", "ج\0", "ا\0", "س\0", "ا\0", "ن\0", "د\0" },
        { "جنو\0", "فبروری\0", "مارچ\0", "اپریل\0", "می\0", "جون\0", "جول\0", "اگست\0", "سپتمبر\0", "اکتوبر\0", "نومبر\0", "دسم\0" },
        { "جنوری\0", "فبروری\0", "مارچ\0", "اپریل\0", "می\0", "جون\0", "جولای\0", "اگست\0", "سپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "ج\0", "ف\0", "م\0", "ا\0", "م\0", "ج\0", "ج\0", "ا\0", "س\0", "ا\0", "ن\0", "د\0" },
        { "دوشنبه\0", "سه‌شنبه\0", "چهارشنبه\0", "پنجشنبه\0", "جمعه\0", "شنبه\0", "یکشنبه\0" },
        { "دوشنبه\0", "سه‌شنبه\0", "چهارشنبه\0", "پنجشنبه\0", "جمعه\0", "شنبه\0", "یکشنبه\0" },
        { "د\0", "س\0", "چ\0", "پ\0", "ج\0", "ش\0", "ی\0" },
        { "دوشنبه\0", "سه‌شنبه\0", "چهارشنبه\0", "پنجشنبه\0", "جمعه\0", "شنبه\0", "یکشنبه\0" },
        { "دوشنبه\0", "سه‌شنبه\0", "چهارشنبه\0", "پنجشنبه\0", "جمعه\0", "شنبه\0", "یکشنبه\0" },
        { "د\0", "س\0", "چ\0", "پ\0", "ج\0", "ش\0", "ی\0" }
    }, // fa_AF
    {
        QLocale::Language::Persian, QLocale::Script::ArabicScript, QLocale::Country::Iran,
        Qt::Saturday, Qt::Friday, Qt::Friday,
        1643, 1644, 59, 1642, 45, 43, 69, 1776,
        "فارسی\0", "ایران\0",
        "yyyy/M/d\0", "d MMMM yyyy\0", "H:mm\0", "H:mm:ss (Z)\0",
        "قبل‌ازظهر\0", "بعدازظهر\0",
        { "ژانویه\0", "فوریه\0", "مارس\0", "آوریل\0", "مه\0", "ژوئن\0", "ژوئیه\0", "اوت\0", "سپتامبر\0", "اکتبر\0", "نوامبر\0", "دسامبر\0" },
        { "ژانویه\0", "فوریه\0", "مارس\0", "آوریل\0", "مه\0", "ژوئن\0", "ژوئیه\0", "اوت\0", "سپتامبر\0", "اکتبر\0", "نوامبر\0", "دسامبر\0" },
        { "ژ\0", "ف\0", "م\0", "آ\0", "م\0", "ژ\0", "ژ\0", "ا\0", "س\0", "ا\0", "ن\0", "د\0" },
        { "ژانویه\0", "فوریه\0", "مارس\0", "آوریل\0", "مه\0", "ژوئن\0", "ژوئیه\0", "اوت\0", "سپتامبر\0", "اکتبر\0", "نوامبر\0", "دسامبر\0" },
        { "ژانویهٔ\0", "فوریهٔ\0", "مارس\0", "آوریل\0", "مهٔ\0", "ژوئن\0", "ژوئیهٔ\0", "اوت\0", "سپتامبر\0", "اکتبر\0", "نوامبر\0", "دسامبر\0" },
        { "ژ\0", "ف\0", "م\0", "آ\0", "م\0", "ژ\0", "ژ\0", "ا\0", "س\0", "ا\0", "ن\0", "د\0" },
        { "دوشنبه\0", "سه‌شنبه\0", "چهارشنبه\0", "پنجشنبه\0", "جمعه\0", "شنبه\0", "یکشنبه\0" },
        { "دوشنبه\0", "سه‌شنبه\0", "چهارشنبه\0", "پنجشنبه\0", "جمعه\0", "شنبه\0", "یکشنبه\0" },
        { "د\0", "س\0", "چ\0", "پ\0", "ج\0", "ش\0", "ی\0" },
        { "دوشنبه\0", "سه‌شنبه\0", "چهارشنبه\0", "پنجشنبه\0", "جمعه\0", "شنبه\0", "یکشنبه\0" },
        { "دوشنبه\0", "سه‌شنبه\0", "چهارشنبه\0", "پنجشنبه\0", "جمعه\0", "شنبه\0", "یکشنبه\0" },
        { "د\0", "س\0", "چ\0", "پ\0", "ج\0", "ش\0", "ی\0" }
    }, // fa_IR
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::BurkinaFaso,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Burkibaa Faaso\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_BF
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Kameruun\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_CM
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::Ghana,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Ganaa\0",
        "d/M/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_GH
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::Gambia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Gammbi\0",
        "d/M/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_GM
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::Guinea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Gine\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_GN
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::GuineaBissau,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Gine-Bisaawo\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_GW
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::Liberia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Liberiyaa\0",
        "d/M/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_LR
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::Mauritania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Muritani\0",
        "d/M/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_MR
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::Niger,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Nijeer\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_NE
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::Nigeria,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Nijeriyaa\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_NG
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::SierraLeone,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Seraa liyon\0",
        "d/M/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_SL
    {
        QLocale::Language::Fulah, QLocale::Script::AdlamScript, QLocale::Country::Senegal,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Senegaal\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Adlm_SN
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::BurkinaFaso,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Burkibaa Faaso\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_BF
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Kameruun\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_CM
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::Ghana,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Ganaa\0",
        "d/M/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_GH
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::Gambia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Gammbi\0",
        "d/M/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_GM
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::Guinea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Gine\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_GN
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::GuineaBissau,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Gine-Bisaawo\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_GW
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::Liberia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Liberiyaa\0",
        "d/M/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_LR
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::Mauritania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Muritani\0",
        "d/M/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_MR
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::Niger,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Nijeer\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_NE
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::Nigeria,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Nijeriyaa\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_NG
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::SierraLeone,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Seraa liyon\0",
        "d/M/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_SL
    {
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::Senegal,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Pulaar\0", "Senegaal\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "subaka\0", "kikiiɗe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "s\0", "c\0", "m\0", "s\0", "d\0", "k\0", "m\0", "j\0", "s\0", "y\0", "j\0", "b\0" },
        { "sii\0", "col\0", "mbo\0", "see\0", "duu\0", "kor\0", "mor\0", "juk\0", "slt\0", "yar\0", "jol\0", "bow\0" },
        { "siilo\0", "colte\0", "mbooy\0", "seeɗto\0", "duujal\0", "korse\0", "morso\0", "juko\0", "siilto\0", "yarkomaa\0", "jolal\0", "bowte\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "a\0", "m\0", "n\0", "n\0", "m\0", "h\0", "d\0" },
        { "aaɓ\0", "maw\0", "nje\0", "naa\0", "mwd\0", "hbi\0", "dew\0" },
        { "aaɓnde\0", "mawbaare\0", "njeslaare\0", "naasaande\0", "mawnde\0", "hoore-biir\0", "dewo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ff_Latn_SN
    {
        QLocale::Language::Finnish, QLocale::Script::LatinScript, QLocale::Country::Finland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "suomi\0", "Suomi\0",
        "d.M.yyyy\0", "d. MMMM yyyy\0", "H.mm\0", "H.mm.ss Z\0",
        "ap.\0", "ip.\0",
        { "tammi\0", "helmi\0", "maalis\0", "huhti\0", "touko\0", "kesä\0", "heinä\0", "elo\0", "syys\0", "loka\0", "marras\0", "joulu\0" },
        { "tammikuu\0", "helmikuu\0", "maaliskuu\0", "huhtikuu\0", "toukokuu\0", "kesäkuu\0", "heinäkuu\0", "elokuu\0", "syyskuu\0", "lokakuu\0", "marraskuu\0", "joulukuu\0" },
        { "T\0", "H\0", "M\0", "H\0", "T\0", "K\0", "H\0", "E\0", "S\0", "L\0", "M\0", "J\0" },
        { "tammik.\0", "helmik.\0", "maalisk.\0", "huhtik.\0", "toukok.\0", "kesäk.\0", "heinäk.\0", "elok.\0", "syysk.\0", "lokak.\0", "marrask.\0", "jouluk.\0" },
        { "tammikuuta\0", "helmikuuta\0", "maaliskuuta\0", "huhtikuuta\0", "toukokuuta\0", "kesäkuuta\0", "heinäkuuta\0", "elokuuta\0", "syyskuuta\0", "lokakuuta\0", "marraskuuta\0", "joulukuuta\0" },
        { "T\0", "H\0", "M\0", "H\0", "T\0", "K\0", "H\0", "E\0", "S\0", "L\0", "M\0", "J\0" },
        { "ma\0", "ti\0", "ke\0", "to\0", "pe\0", "la\0", "su\0" },
        { "maanantai\0", "tiistai\0", "keskiviikko\0", "torstai\0", "perjantai\0", "lauantai\0", "sunnuntai\0" },
        { "M\0", "T\0", "K\0", "T\0", "P\0", "L\0", "S\0" },
        { "ma\0", "ti\0", "ke\0", "to\0", "pe\0", "la\0", "su\0" },
        { "maanantaina\0", "tiistaina\0", "keskiviikkona\0", "torstaina\0", "perjantaina\0", "lauantaina\0", "sunnuntaina\0" },
        { "M\0", "T\0", "K\0", "T\0", "P\0", "L\0", "S\0" }
    }, // fi_FI
    {
        QLocale::Language::Filipino, QLocale::Script::LatinScript, QLocale::Country::Philippines,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Filipino\0", "Pilipinas\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Ene\0", "Peb\0", "Mar\0", "Abr\0", "May\0", "Hun\0", "Hul\0", "Ago\0", "Set\0", "Okt\0", "Nob\0", "Dis\0" },
        { "Enero\0", "Pebrero\0", "Marso\0", "Abril\0", "Mayo\0", "Hunyo\0", "Hulyo\0", "Agosto\0", "Setyembre\0", "Oktubre\0", "Nobyembre\0", "Disyembre\0" },
        { "E\0", "P\0", "M\0", "A\0", "M\0", "Hun\0", "Hul\0", "Ago\0", "Set\0", "Okt\0", "Nob\0", "Dis\0" },
        { "Ene\0", "Peb\0", "Mar\0", "Abr\0", "May\0", "Hun\0", "Hul\0", "Ago\0", "Set\0", "Okt\0", "Nob\0", "Dis\0" },
        { "Enero\0", "Pebrero\0", "Marso\0", "Abril\0", "Mayo\0", "Hunyo\0", "Hulyo\0", "Agosto\0", "Setyembre\0", "Oktubre\0", "Nobyembre\0", "Disyembre\0" },
        { "Ene\0", "Peb\0", "Mar\0", "Abr\0", "May\0", "Hun\0", "Hul\0", "Ago\0", "Set\0", "Okt\0", "Nob\0", "Dis\0" },
        { "Lun\0", "Mar\0", "Miy\0", "Huw\0", "Biy\0", "Sab\0", "Lin\0" },
        { "Lunes\0", "Martes\0", "Miyerkules\0", "Huwebes\0", "Biyernes\0", "Sabado\0", "Linggo\0" },
        { "Lun\0", "Mar\0", "Miy\0", "Huw\0", "Biy\0", "Sab\0", "Lin\0" },
        { "Lun\0", "Mar\0", "Miy\0", "Huw\0", "Biy\0", "Sab\0", "Lin\0" },
        { "Lunes\0", "Martes\0", "Miyerkules\0", "Huwebes\0", "Biyernes\0", "Sabado\0", "Linggo\0" },
        { "Lun\0", "Mar\0", "Miy\0", "Huw\0", "Biy\0", "Sab\0", "Lin\0" }
    }, // fil_PH
    {
        QLocale::Language::Faroese, QLocale::Script::LatinScript, QLocale::Country::Denmark,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 8722, 43, 69, 48,
        "føroyskt\0", "Danmark\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "jan\0", "feb\0", "mar\0", "apr\0", "mai\0", "jun\0", "jul\0", "aug\0", "sep\0", "okt\0", "nov\0", "des\0" },
        { "januar\0", "februar\0", "mars\0", "apríl\0", "mai\0", "juni\0", "juli\0", "august\0", "september\0", "oktober\0", "november\0", "desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mar.\0", "apr.\0", "mai\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "des.\0" },
        { "januar\0", "februar\0", "mars\0", "apríl\0", "mai\0", "juni\0", "juli\0", "august\0", "september\0", "oktober\0", "november\0", "desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "mán\0", "týs\0", "mik\0", "hós\0", "frí\0", "ley\0", "sun\0" },
        { "mánadagur\0", "týsdagur\0", "mikudagur\0", "hósdagur\0", "fríggjadagur\0", "leygardagur\0", "sunnudagur\0" },
        { "M\0", "T\0", "M\0", "H\0", "F\0", "L\0", "S\0" },
        { "mán.\0", "týs.\0", "mik.\0", "hós.\0", "frí.\0", "ley.\0", "sun.\0" },
        { "mánadagur\0", "týsdagur\0", "mikudagur\0", "hósdagur\0", "fríggjadagur\0", "leygardagur\0", "sunnudagur\0" },
        { "M\0", "T\0", "M\0", "H\0", "F\0", "L\0", "S\0" }
    }, // fo_DK
    {
        QLocale::Language::Faroese, QLocale::Script::LatinScript, QLocale::Country::FaroeIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 8722, 43, 69, 48,
        "føroyskt\0", "Føroyar\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "jan\0", "feb\0", "mar\0", "apr\0", "mai\0", "jun\0", "jul\0", "aug\0", "sep\0", "okt\0", "nov\0", "des\0" },
        { "januar\0", "februar\0", "mars\0", "apríl\0", "mai\0", "juni\0", "juli\0", "august\0", "september\0", "oktober\0", "november\0", "desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mar.\0", "apr.\0", "mai\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "des.\0" },
        { "januar\0", "februar\0", "mars\0", "apríl\0", "mai\0", "juni\0", "juli\0", "august\0", "september\0", "oktober\0", "november\0", "desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "mán\0", "týs\0", "mik\0", "hós\0", "frí\0", "ley\0", "sun\0" },
        { "mánadagur\0", "týsdagur\0", "mikudagur\0", "hósdagur\0", "fríggjadagur\0", "leygardagur\0", "sunnudagur\0" },
        { "M\0", "T\0", "M\0", "H\0", "F\0", "L\0", "S\0" },
        { "mán.\0", "týs.\0", "mik.\0", "hós.\0", "frí.\0", "ley.\0", "sun.\0" },
        { "mánadagur\0", "týsdagur\0", "mikudagur\0", "hósdagur\0", "fríggjadagur\0", "leygardagur\0", "sunnudagur\0" },
        { "M\0", "T\0", "M\0", "H\0", "F\0", "L\0", "S\0" }
    }, // fo_FO
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Belgium,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Belgique\0",
        "d/MM/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_BE
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::BurkinaFaso,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Burkina Faso\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_BF
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Burundi,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Burundi\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_BI
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Benin,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Bénin\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_BJ
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::StBarthelemy,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Saint-Barthélemy\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_BL
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Canada,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "français\0", "Canada\0",
        "yyyy-MM-dd\0", "d MMMM yyyy\0", "HH 'h' mm\0", "HH 'h' mm 'min' ss 's' Z\0",
        "a.m.\0", "p.m.\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juill.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juill.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_CA
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::CongoKinshasa,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Congo-Kinshasa\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_CD
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::CentralAfricanRepublic,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "République centrafricaine\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_CF
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::CongoBrazzaville,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Congo-Brazzaville\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_CG
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Switzerland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Suisse\0",
        "dd.MM.yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_CH
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::CotedIvoire,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Côte d’Ivoire\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_CI
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Cameroun\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "matin\0", "soir\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_CM
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Djibouti,
        Qt::Saturday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Djibouti\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_DJ
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Algeria,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Algérie\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_DZ
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::France,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "France\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_FR
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Gabon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Gabon\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_GA
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::FrenchGuiana,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Guyane française\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_GF
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Guinea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Guinée\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_GN
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Guadeloupe,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Guadeloupe\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_GP
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::EquatorialGuinea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Guinée équatoriale\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_GQ
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Haiti,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Haïti\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_HT
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Comoros,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Comores\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_KM
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Luxembourg,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "français\0", "Luxembourg\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_LU
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Morocco,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "français\0", "Maroc\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "jan.\0", "fév.\0", "mar.\0", "avr.\0", "mai\0", "jui.\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "jan.\0", "fév.\0", "mar.\0", "avr.\0", "mai\0", "jui.\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_MA
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Monaco,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Monaco\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_MC
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::StMartin,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Saint-Martin\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_MF
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Madagascar,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Madagascar\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_MG
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Mali,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Mali\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_ML
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Martinique,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Martinique\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_MQ
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Mauritania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Mauritanie\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_MR
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Mauritius,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Maurice\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_MU
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::NewCaledonia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Nouvelle-Calédonie\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_NC
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Niger,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Niger\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_NE
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::FrenchPolynesia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Polynésie française\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_PF
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::StPierreAndMiquelon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Saint-Pierre-et-Miquelon\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_PM
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Reunion,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "La Réunion\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_RE
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Rwanda,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Rwanda\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_RW
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Seychelles,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Seychelles\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_SC
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Senegal,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Sénégal\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_SN
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Syria,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Syrie\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_SY
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Chad,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Tchad\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_TD
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Togo,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Togo\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_TG
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Tunisia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Tunisie\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_TN
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Vanuatu,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Vanuatu\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_VU
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::WallisAndFutuna,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Wallis-et-Futuna\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_WF
    {
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::Mayotte,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8239, 59, 37, 45, 43, 69, 48,
        "français\0", "Mayotte\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "févr.\0", "mars\0", "avr.\0", "mai\0", "juin\0", "juil.\0", "août\0", "sept.\0", "oct.\0", "nov.\0", "déc.\0" },
        { "janvier\0", "février\0", "mars\0", "avril\0", "mai\0", "juin\0", "juillet\0", "août\0", "septembre\0", "octobre\0", "novembre\0", "décembre\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mer.\0", "jeu.\0", "ven.\0", "sam.\0", "dim.\0" },
        { "lundi\0", "mardi\0", "mercredi\0", "jeudi\0", "vendredi\0", "samedi\0", "dimanche\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fr_YT
    {
        QLocale::Language::Friulian, QLocale::Script::LatinScript, QLocale::Country::Italy,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "furlan\0", "Italie\0",
        "dd/MM/yyyy\0", "d 'di' MMMM 'dAP' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.\0", "p.\0",
        { "Zen\0", "Fev\0", "Mar\0", "Avr\0", "Mai\0", "Jug\0", "Lui\0", "Avo\0", "Set\0", "Otu\0", "Nov\0", "Dic\0" },
        { "Zenâr\0", "Fevrâr\0", "Març\0", "Avrîl\0", "Mai\0", "Jugn\0", "Lui\0", "Avost\0", "Setembar\0", "Otubar\0", "Novembar\0", "Dicembar\0" },
        { "Z\0", "F\0", "M\0", "A\0", "M\0", "J\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Zen\0", "Fev\0", "Mar\0", "Avr\0", "Mai\0", "Jug\0", "Lui\0", "Avo\0", "Set\0", "Otu\0", "Nov\0", "Dic\0" },
        { "Zenâr\0", "Fevrâr\0", "Març\0", "Avrîl\0", "Mai\0", "Jugn\0", "Lui\0", "Avost\0", "Setembar\0", "Otubar\0", "Novembar\0", "Dicembar\0" },
        { "Z\0", "F\0", "M\0", "A\0", "M\0", "J\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mie\0", "joi\0", "vin\0", "sab\0", "dom\0" },
        { "lunis\0", "martars\0", "miercus\0", "joibe\0", "vinars\0", "sabide\0", "domenie\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mie\0", "joi\0", "vin\0", "sab\0", "dom\0" },
        { "lunis\0", "martars\0", "miercus\0", "joibe\0", "vinars\0", "sabide\0", "domenie\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // fur_IT
    {
        QLocale::Language::WesternFrisian, QLocale::Script::LatinScript, QLocale::Country::Netherlands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Frysk\0", "Nederlân\0",
        "dd-MM-yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mrt\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Jannewaris\0", "Febrewaris\0", "Maart\0", "April\0", "Maaie\0", "Juny\0", "July\0", "Augustus\0", "Septimber\0", "Oktober\0", "Novimber\0", "Desimber\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mrt\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Jannewaris\0", "Febrewaris\0", "Maart\0", "April\0", "Maaie\0", "Juny\0", "July\0", "Augustus\0", "Septimber\0", "Oktober\0", "Novimber\0", "Desimber\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "mo\0", "ti\0", "wo\0", "to\0", "fr\0", "so\0", "si\0" },
        { "moandei\0", "tiisdei\0", "woansdei\0", "tongersdei\0", "freed\0", "sneon\0", "snein\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "mo\0", "ti\0", "wo\0", "to\0", "fr\0", "so\0", "si\0" },
        { "moandei\0", "tiisdei\0", "woansdei\0", "tongersdei\0", "freed\0", "sneon\0", "snein\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // fy_NL
    {
        QLocale::Language::Irish, QLocale::Script::AnyScript, QLocale::Country::UnitedKingdom,
        Qt::Sunday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Gaeilge\0", "an Ríocht Aontaithe\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "r.n.\0", "i.n.\0",
        { "Ean\0", "Feabh\0", "Márta\0", "Aib\0", "Beal\0", "Meith\0", "Iúil\0", "Lún\0", "MFómh\0", "DFómh\0", "Samh\0", "Noll\0" },
        { "Eanáir\0", "Feabhra\0", "Márta\0", "Aibreán\0", "Bealtaine\0", "Meitheamh\0", "Iúil\0", "Lúnasa\0", "Meán Fómhair\0", "Deireadh Fómhair\0", "Samhain\0", "Nollaig\0" },
        { "E\0", "F\0", "M\0", "A\0", "B\0", "M\0", "I\0", "L\0", "M\0", "D\0", "S\0", "N\0" },
        { "Ean\0", "Feabh\0", "Márta\0", "Aib\0", "Beal\0", "Meith\0", "Iúil\0", "Lún\0", "MFómh\0", "DFómh\0", "Samh\0", "Noll\0" },
        { "Eanáir\0", "Feabhra\0", "Márta\0", "Aibreán\0", "Bealtaine\0", "Meitheamh\0", "Iúil\0", "Lúnasa\0", "Meán Fómhair\0", "Deireadh Fómhair\0", "Samhain\0", "Nollaig\0" },
        { "E\0", "F\0", "M\0", "A\0", "B\0", "M\0", "I\0", "L\0", "M\0", "D\0", "S\0", "N\0" },
        { "Luan\0", "Máirt\0", "Céad\0", "Déar\0", "Aoine\0", "Sath\0", "Domh\0" },
        { "Dé Luain\0", "Dé Máirt\0", "Dé Céadaoin\0", "Déardaoin\0", "Dé hAoine\0", "Dé Sathairn\0", "Dé Domhnaigh\0" },
        { "L\0", "M\0", "C\0", "D\0", "A\0", "S\0", "D\0" },
        { "Luan\0", "Máirt\0", "Céad\0", "Déar\0", "Aoine\0", "Sath\0", "Domh\0" },
        { "Dé Luain\0", "Dé Máirt\0", "Dé Céadaoin\0", "Déardaoin\0", "Dé hAoine\0", "Dé Sathairn\0", "Dé Domhnaigh\0" },
        { "L\0", "M\0", "C\0", "D\0", "A\0", "S\0", "D\0" }
    }, // ga_GB
    {
        QLocale::Language::Irish, QLocale::Script::LatinScript, QLocale::Country::Ireland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Gaeilge\0", "Éire\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "r.n.\0", "i.n.\0",
        { "Ean\0", "Feabh\0", "Márta\0", "Aib\0", "Beal\0", "Meith\0", "Iúil\0", "Lún\0", "MFómh\0", "DFómh\0", "Samh\0", "Noll\0" },
        { "Eanáir\0", "Feabhra\0", "Márta\0", "Aibreán\0", "Bealtaine\0", "Meitheamh\0", "Iúil\0", "Lúnasa\0", "Meán Fómhair\0", "Deireadh Fómhair\0", "Samhain\0", "Nollaig\0" },
        { "E\0", "F\0", "M\0", "A\0", "B\0", "M\0", "I\0", "L\0", "M\0", "D\0", "S\0", "N\0" },
        { "Ean\0", "Feabh\0", "Márta\0", "Aib\0", "Beal\0", "Meith\0", "Iúil\0", "Lún\0", "MFómh\0", "DFómh\0", "Samh\0", "Noll\0" },
        { "Eanáir\0", "Feabhra\0", "Márta\0", "Aibreán\0", "Bealtaine\0", "Meitheamh\0", "Iúil\0", "Lúnasa\0", "Meán Fómhair\0", "Deireadh Fómhair\0", "Samhain\0", "Nollaig\0" },
        { "E\0", "F\0", "M\0", "A\0", "B\0", "M\0", "I\0", "L\0", "M\0", "D\0", "S\0", "N\0" },
        { "Luan\0", "Máirt\0", "Céad\0", "Déar\0", "Aoine\0", "Sath\0", "Domh\0" },
        { "Dé Luain\0", "Dé Máirt\0", "Dé Céadaoin\0", "Déardaoin\0", "Dé hAoine\0", "Dé Sathairn\0", "Dé Domhnaigh\0" },
        { "L\0", "M\0", "C\0", "D\0", "A\0", "S\0", "D\0" },
        { "Luan\0", "Máirt\0", "Céad\0", "Déar\0", "Aoine\0", "Sath\0", "Domh\0" },
        { "Dé Luain\0", "Dé Máirt\0", "Dé Céadaoin\0", "Déardaoin\0", "Dé hAoine\0", "Dé Sathairn\0", "Dé Domhnaigh\0" },
        { "L\0", "M\0", "C\0", "D\0", "A\0", "S\0", "D\0" }
    }, // ga_IE
    {
        QLocale::Language::ScottishGaelic, QLocale::Script::LatinScript, QLocale::Country::UnitedKingdom,
        Qt::Sunday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Gàidhlig\0", "An Rìoghachd Aonaichte\0",
        "dd/MM/yyyy\0", "d'mh' MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "m\0", "f\0",
        { "Faoi\0", "Gearr\0", "Màrt\0", "Gibl\0", "Cèit\0", "Ògmh\0", "Iuch\0", "Lùna\0", "Sult\0", "Dàmh\0", "Samh\0", "Dùbh\0" },
        { "Am Faoilleach\0", "An Gearran\0", "Am Màrt\0", "An Giblean\0", "An Cèitean\0", "An t-Ògmhios\0", "An t-Iuchar\0", "An Lùnastal\0", "An t-Sultain\0", "An Dàmhair\0", "An t-Samhain\0", "An Dùbhlachd\0" },
        { "F\0", "G\0", "M\0", "G\0", "C\0", "Ò\0", "I\0", "L\0", "S\0", "D\0", "S\0", "D\0" },
        { "Faoi\0", "Gearr\0", "Màrt\0", "Gibl\0", "Cèit\0", "Ògmh\0", "Iuch\0", "Lùna\0", "Sult\0", "Dàmh\0", "Samh\0", "Dùbh\0" },
        { "dhen Fhaoilleach\0", "dhen Ghearran\0", "dhen Mhàrt\0", "dhen Ghiblean\0", "dhen Chèitean\0", "dhen Ògmhios\0", "dhen Iuchar\0", "dhen Lùnastal\0", "dhen t-Sultain\0", "dhen Dàmhair\0", "dhen t-Samhain\0", "dhen Dùbhlachd\0" },
        { "F\0", "G\0", "M\0", "G\0", "C\0", "Ò\0", "I\0", "L\0", "S\0", "D\0", "S\0", "D\0" },
        { "DiL\0", "DiM\0", "DiC\0", "Dia\0", "Dih\0", "DiS\0", "DiD\0" },
        { "DiLuain\0", "DiMàirt\0", "DiCiadain\0", "DiarDaoin\0", "DihAoine\0", "DiSathairne\0", "DiDòmhnaich\0" },
        { "L\0", "M\0", "C\0", "A\0", "H\0", "S\0", "D\0" },
        { "DiL\0", "DiM\0", "DiC\0", "Dia\0", "Dih\0", "DiS\0", "DiD\0" },
        { "DiLuain\0", "DiMàirt\0", "DiCiadain\0", "DiarDaoin\0", "DihAoine\0", "DiSathairne\0", "DiDòmhnaich\0" },
        { "L\0", "M\0", "C\0", "A\0", "H\0", "S\0", "D\0" }
    }, // gd_GB
    {
        QLocale::Language::Galician, QLocale::Script::LatinScript, QLocale::Country::Spain,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "galego\0", "España\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "Xan.\0", "Feb.\0", "Mar.\0", "Abr.\0", "Maio\0", "Xuño\0", "Xul.\0", "Ago.\0", "Set.\0", "Out.\0", "Nov.\0", "Dec.\0" },
        { "Xaneiro\0", "Febreiro\0", "Marzo\0", "Abril\0", "Maio\0", "Xuño\0", "Xullo\0", "Agosto\0", "Setembro\0", "Outubro\0", "Novembro\0", "Decembro\0" },
        { "X\0", "F\0", "M\0", "A\0", "M\0", "X\0", "X\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "xan.\0", "feb.\0", "mar.\0", "abr.\0", "maio\0", "xuño\0", "xul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dec.\0" },
        { "xaneiro\0", "febreiro\0", "marzo\0", "abril\0", "maio\0", "xuño\0", "xullo\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "decembro\0" },
        { "x.\0", "f.\0", "m.\0", "a.\0", "m.\0", "x.\0", "x.\0", "a.\0", "s.\0", "o.\0", "n.\0", "d.\0" },
        { "Luns\0", "Mar.\0", "Mér.\0", "Xov.\0", "Ven.\0", "Sáb.\0", "Dom.\0" },
        { "Luns\0", "Martes\0", "Mércores\0", "Xoves\0", "Venres\0", "Sábado\0", "Domingo\0" },
        { "L\0", "M\0", "M\0", "X\0", "V\0", "S\0", "D\0" },
        { "luns\0", "mar.\0", "mér.\0", "xov.\0", "ven.\0", "sáb.\0", "dom.\0" },
        { "luns\0", "martes\0", "mércores\0", "xoves\0", "venres\0", "sábado\0", "domingo\0" },
        { "l.\0", "m.\0", "m.\0", "x.\0", "v.\0", "s.\0", "d.\0" }
    }, // gl_ES
    {
        QLocale::Language::SwissGerman, QLocale::Script::LatinScript, QLocale::Country::Switzerland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 8217, 59, 37, 8722, 43, 69, 48,
        "Schwiizertüütsch\0", "Schwiiz\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Vormittag\0", "Namittag\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mär\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "Auguscht\0", "Septämber\0", "Oktoober\0", "Novämber\0", "Dezämber\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mä.\0", "Zi.\0", "Mi.\0", "Du.\0", "Fr.\0", "Sa.\0", "Su.\0" },
        { "Määntig\0", "Ziischtig\0", "Mittwuch\0", "Dunschtig\0", "Friitig\0", "Samschtig\0", "Sunntig\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // gsw_CH
    {
        QLocale::Language::SwissGerman, QLocale::Script::AnyScript, QLocale::Country::France,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 8217, 59, 37, 8722, 43, 69, 48,
        "Schwiizertüütsch\0", "Frankriich\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Vormittag\0", "Namittag\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mär\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "Auguscht\0", "Septämber\0", "Oktoober\0", "Novämber\0", "Dezämber\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mä.\0", "Zi.\0", "Mi.\0", "Du.\0", "Fr.\0", "Sa.\0", "Su.\0" },
        { "Määntig\0", "Ziischtig\0", "Mittwuch\0", "Dunschtig\0", "Friitig\0", "Samschtig\0", "Sunntig\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // gsw_FR
    {
        QLocale::Language::SwissGerman, QLocale::Script::LatinScript, QLocale::Country::Liechtenstein,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 8217, 59, 37, 8722, 43, 69, 48,
        "Schwiizertüütsch\0", "Liächteschtäi\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Vormittag\0", "Namittag\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mär\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Januar\0", "Februar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "Auguscht\0", "Septämber\0", "Oktoober\0", "Novämber\0", "Dezämber\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mä.\0", "Zi.\0", "Mi.\0", "Du.\0", "Fr.\0", "Sa.\0", "Su.\0" },
        { "Määntig\0", "Ziischtig\0", "Mittwuch\0", "Dunschtig\0", "Friitig\0", "Samschtig\0", "Sunntig\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // gsw_LI
    {
        QLocale::Language::Gujarati, QLocale::Script::GujaratiScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ગુજરાતી\0", "ભારત\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "hh:mm AP\0", "hh:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "જાન્યુ\0", "ફેબ્રુ\0", "માર્ચ\0", "એપ્રિલ\0", "મે\0", "જૂન\0", "જુલાઈ\0", "ઑગસ્ટ\0", "સપ્ટે\0", "ઑક્ટો\0", "નવે\0", "ડિસે\0" },
        { "જાન્યુઆરી\0", "ફેબ્રુઆરી\0", "માર્ચ\0", "એપ્રિલ\0", "મે\0", "જૂન\0", "જુલાઈ\0", "ઑગસ્ટ\0", "સપ્ટેમ્બર\0", "ઑક્ટોબર\0", "નવેમ્બર\0", "ડિસેમ્બર\0" },
        { "જા\0", "ફે\0", "મા\0", "એ\0", "મે\0", "જૂ\0", "જુ\0", "ઑ\0", "સ\0", "ઑ\0", "ન\0", "ડિ\0" },
        { "જાન્યુ\0", "ફેબ્રુ\0", "માર્ચ\0", "એપ્રિલ\0", "મે\0", "જૂન\0", "જુલાઈ\0", "ઑગસ્ટ\0", "સપ્ટે\0", "ઑક્ટો\0", "નવે\0", "ડિસે\0" },
        { "જાન્યુઆરી\0", "ફેબ્રુઆરી\0", "માર્ચ\0", "એપ્રિલ\0", "મે\0", "જૂન\0", "જુલાઈ\0", "ઑગસ્ટ\0", "સપ્ટેમ્બર\0", "ઑક્ટોબર\0", "નવેમ્બર\0", "ડિસેમ્બર\0" },
        { "જા\0", "ફે\0", "મા\0", "એ\0", "મે\0", "જૂ\0", "જુ\0", "ઑ\0", "સ\0", "ઑ\0", "ન\0", "ડિ\0" },
        { "સોમ\0", "મંગળ\0", "બુધ\0", "ગુરુ\0", "શુક્ર\0", "શનિ\0", "રવિ\0" },
        { "સોમવાર\0", "મંગળવાર\0", "બુધવાર\0", "ગુરુવાર\0", "શુક્રવાર\0", "શનિવાર\0", "રવિવાર\0" },
        { "સો\0", "મં\0", "બુ\0", "ગુ\0", "શુ\0", "શ\0", "ર\0" },
        { "સોમ\0", "મંગળ\0", "બુધ\0", "ગુરુ\0", "શુક્ર\0", "શનિ\0", "રવિ\0" },
        { "સોમવાર\0", "મંગળવાર\0", "બુધવાર\0", "ગુરુવાર\0", "શુક્રવાર\0", "શનિવાર\0", "રવિવાર\0" },
        { "સો\0", "મં\0", "બુ\0", "ગુ\0", "શુ\0", "શ\0", "ર\0" }
    }, // gu_IN
    {
        QLocale::Language::Gusii, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Ekegusii\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Mambia\0", "Mog\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "C\0", "F\0", "M\0", "A\0", "M\0", "J\0", "C\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Can\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Cul\0", "Agt\0", "Sep\0", "Okt\0", "Nob\0", "Dis\0" },
        { "Chanuari\0", "Feburari\0", "Machi\0", "Apiriri\0", "Mei\0", "Juni\0", "Chulai\0", "Agosti\0", "Septemba\0", "Okitoba\0", "Nobemba\0", "Disemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "C\0", "C\0", "C\0", "A\0", "I\0", "E\0", "C\0" },
        { "Ctt\0", "Cmn\0", "Cmt\0", "Ars\0", "Icm\0", "Est\0", "Cpr\0" },
        { "Chumatato\0", "Chumaine\0", "Chumatano\0", "Aramisi\0", "Ichuma\0", "Esabato\0", "Chumapiri\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // guz_KE
    {
        QLocale::Language::Manx, QLocale::Script::LatinScript, QLocale::Country::IsleofMan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Gaelg\0", "Ellan Vannin\0",
        "dd/MM/yyyy\0", "dd MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "J-guer\0", "T-arree\0", "Mayrnt\0", "Avrril\0", "Boaldyn\0", "M-souree\0", "J-souree\0", "Luanistyn\0", "M-fouyir\0", "J-fouyir\0", "M-Houney\0", "M-Nollick\0" },
        { "Jerrey-geuree\0", "Toshiaght-arree\0", "Mayrnt\0", "Averil\0", "Boaldyn\0", "Mean-souree\0", "Jerrey-souree\0", "Luanistyn\0", "Mean-fouyir\0", "Jerrey-fouyir\0", "Mee Houney\0", "Mee ny Nollick\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Jel\0", "Jem\0", "Jerc\0", "Jerd\0", "Jeh\0", "Jes\0", "Jed\0" },
        { "Jelhein\0", "Jemayrt\0", "Jercean\0", "Jerdein\0", "Jeheiney\0", "Jesarn\0", "Jedoonee\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // gv_IM
    {
        QLocale::Language::Hausa, QLocale::Script::AnyScript, QLocale::Country::Ghana,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Hausa\0", "Gana\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "SF\0", "YM\0",
        { "Jan\0", "Fab\0", "Mar\0", "Afi\0", "May\0", "Yun\0", "Yul\0", "Agu\0", "Sat\0", "Okt\0", "Nuw\0", "Dis\0" },
        { "Janairu\0", "Faburairu\0", "Maris\0", "Afirilu\0", "Mayu\0", "Yuni\0", "Yuli\0", "Agusta\0", "Satumba\0", "Oktoba\0", "Nuwamba\0", "Disamba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "Y\0", "Y\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Fab\0", "Mar\0", "Afi\0", "May\0", "Yun\0", "Yul\0", "Agu\0", "Sat\0", "Okt\0", "Nuw\0", "Dis\0" },
        { "Janairu\0", "Faburairu\0", "Maris\0", "Afirilu\0", "Mayu\0", "Yuni\0", "Yuli\0", "Agusta\0", "Satumba\0", "Oktoba\0", "Nuwamba\0", "Disamba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "Y\0", "Y\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Lit\0", "Tal\0", "Lar\0", "Alh\0", "Jum\0", "Asa\0", "Lah\0" },
        { "Litinin\0", "Talata\0", "Laraba\0", "Alhamis\0", "Jummaʼa\0", "Asabar\0", "Lahadi\0" },
        { "L\0", "T\0", "L\0", "A\0", "J\0", "A\0", "L\0" },
        { "Lit\0", "Tal\0", "Lar\0", "Alh\0", "Jum\0", "Asa\0", "Lah\0" },
        { "Litinin\0", "Talata\0", "Laraba\0", "Alhamis\0", "Jummaʼa\0", "Asabar\0", "Lahadi\0" },
        { "L\0", "T\0", "L\0", "A\0", "J\0", "A\0", "L\0" }
    }, // ha_GH
    {
        QLocale::Language::Hausa, QLocale::Script::AnyScript, QLocale::Country::Niger,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Hausa\0", "Nijar\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "SF\0", "YM\0",
        { "Jan\0", "Fab\0", "Mar\0", "Afi\0", "May\0", "Yun\0", "Yul\0", "Agu\0", "Sat\0", "Okt\0", "Nuw\0", "Dis\0" },
        { "Janairu\0", "Faburairu\0", "Maris\0", "Afirilu\0", "Mayu\0", "Yuni\0", "Yuli\0", "Agusta\0", "Satumba\0", "Oktoba\0", "Nuwamba\0", "Disamba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "Y\0", "Y\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Fab\0", "Mar\0", "Afi\0", "May\0", "Yun\0", "Yul\0", "Agu\0", "Sat\0", "Okt\0", "Nuw\0", "Dis\0" },
        { "Janairu\0", "Faburairu\0", "Maris\0", "Afirilu\0", "Mayu\0", "Yuni\0", "Yuli\0", "Agusta\0", "Satumba\0", "Oktoba\0", "Nuwamba\0", "Disamba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "Y\0", "Y\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Lit\0", "Tal\0", "Lar\0", "Alh\0", "Jum\0", "Asa\0", "Lah\0" },
        { "Litinin\0", "Talata\0", "Laraba\0", "Alhamis\0", "Jummaʼa\0", "Asabar\0", "Lahadi\0" },
        { "L\0", "T\0", "L\0", "A\0", "J\0", "A\0", "L\0" },
        { "Lit\0", "Tal\0", "Lar\0", "Alh\0", "Jum\0", "Asa\0", "Lah\0" },
        { "Litinin\0", "Talata\0", "Laraba\0", "Alhamis\0", "Jummaʼa\0", "Asabar\0", "Lahadi\0" },
        { "L\0", "T\0", "L\0", "A\0", "J\0", "A\0", "L\0" }
    }, // ha_NE
    {
        QLocale::Language::Hausa, QLocale::Script::AnyScript, QLocale::Country::Nigeria,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Hausa\0", "Najeriya\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "SF\0", "YM\0",
        { "Jan\0", "Fab\0", "Mar\0", "Afi\0", "May\0", "Yun\0", "Yul\0", "Agu\0", "Sat\0", "Okt\0", "Nuw\0", "Dis\0" },
        { "Janairu\0", "Faburairu\0", "Maris\0", "Afirilu\0", "Mayu\0", "Yuni\0", "Yuli\0", "Agusta\0", "Satumba\0", "Oktoba\0", "Nuwamba\0", "Disamba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "Y\0", "Y\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Fab\0", "Mar\0", "Afi\0", "May\0", "Yun\0", "Yul\0", "Agu\0", "Sat\0", "Okt\0", "Nuw\0", "Dis\0" },
        { "Janairu\0", "Faburairu\0", "Maris\0", "Afirilu\0", "Mayu\0", "Yuni\0", "Yuli\0", "Agusta\0", "Satumba\0", "Oktoba\0", "Nuwamba\0", "Disamba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "Y\0", "Y\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Lit\0", "Tal\0", "Lar\0", "Alh\0", "Jum\0", "Asa\0", "Lah\0" },
        { "Litinin\0", "Talata\0", "Laraba\0", "Alhamis\0", "Jummaʼa\0", "Asabar\0", "Lahadi\0" },
        { "L\0", "T\0", "L\0", "A\0", "J\0", "A\0", "L\0" },
        { "Lit\0", "Tal\0", "Lar\0", "Alh\0", "Jum\0", "Asa\0", "Lah\0" },
        { "Litinin\0", "Talata\0", "Laraba\0", "Alhamis\0", "Jummaʼa\0", "Asabar\0", "Lahadi\0" },
        { "L\0", "T\0", "L\0", "A\0", "J\0", "A\0", "L\0" }
    }, // ha_NG
    {
        QLocale::Language::Hawaiian, QLocale::Script::LatinScript, QLocale::Country::UnitedStates,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ʻŌlelo Hawaiʻi\0", "ʻAmelika Hui Pū ʻIa\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Ian.\0", "Pep.\0", "Mal.\0", "ʻAp.\0", "Mei\0", "Iun.\0", "Iul.\0", "ʻAu.\0", "Kep.\0", "ʻOk.\0", "Now.\0", "Kek.\0" },
        { "Ianuali\0", "Pepeluali\0", "Malaki\0", "ʻApelila\0", "Mei\0", "Iune\0", "Iulai\0", "ʻAukake\0", "Kepakemapa\0", "ʻOkakopa\0", "Nowemapa\0", "Kekemapa\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Ian.\0", "Pep.\0", "Mal.\0", "ʻAp.\0", "Mei\0", "Iun.\0", "Iul.\0", "ʻAu.\0", "Kep.\0", "ʻOk.\0", "Now.\0", "Kek.\0" },
        { "Ianuali\0", "Pepeluali\0", "Malaki\0", "ʻApelila\0", "Mei\0", "Iune\0", "Iulai\0", "ʻAukake\0", "Kepakemapa\0", "ʻOkakopa\0", "Nowemapa\0", "Kekemapa\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "P1\0", "P2\0", "P3\0", "P4\0", "P5\0", "P6\0", "LP\0" },
        { "Poʻakahi\0", "Poʻalua\0", "Poʻakolu\0", "Poʻahā\0", "Poʻalima\0", "Poʻaono\0", "Lāpule\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "P1\0", "P2\0", "P3\0", "P4\0", "P5\0", "P6\0", "LP\0" },
        { "Poʻakahi\0", "Poʻalua\0", "Poʻakolu\0", "Poʻahā\0", "Poʻalima\0", "Poʻaono\0", "Lāpule\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // haw_US
    {
        QLocale::Language::Hebrew, QLocale::Script::HebrewScript, QLocale::Country::Israel,
        Qt::Monday, Qt::Friday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "עברית\0", "ישראל\0",
        "d.M.yyyy\0", "d בMMMM yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "AM\0", "PM\0",
        { "ינו׳\0", "פבר׳\0", "מרץ\0", "אפר׳\0", "מאי\0", "יוני\0", "יולי\0", "אוג׳\0", "ספט׳\0", "אוק׳\0", "נוב׳\0", "דצמ׳\0" },
        { "ינואר\0", "פברואר\0", "מרץ\0", "אפריל\0", "מאי\0", "יוני\0", "יולי\0", "אוגוסט\0", "ספטמבר\0", "אוקטובר\0", "נובמבר\0", "דצמבר\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ינו׳\0", "פבר׳\0", "מרץ\0", "אפר׳\0", "מאי\0", "יוני\0", "יולי\0", "אוג׳\0", "ספט׳\0", "אוק׳\0", "נוב׳\0", "דצמ׳\0" },
        { "ינואר\0", "פברואר\0", "מרץ\0", "אפריל\0", "מאי\0", "יוני\0", "יולי\0", "אוגוסט\0", "ספטמבר\0", "אוקטובר\0", "נובמבר\0", "דצמבר\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "יום ב׳\0", "יום ג׳\0", "יום ד׳\0", "יום ה׳\0", "יום ו׳\0", "שבת\0", "יום א׳\0" },
        { "יום שני\0", "יום שלישי\0", "יום רביעי\0", "יום חמישי\0", "יום שישי\0", "יום שבת\0", "יום ראשון\0" },
        { "ב׳\0", "ג׳\0", "ד׳\0", "ה׳\0", "ו׳\0", "ש׳\0", "א׳\0" },
        { "יום ב׳\0", "יום ג׳\0", "יום ד׳\0", "יום ה׳\0", "יום ו׳\0", "שבת\0", "יום א׳\0" },
        { "יום שני\0", "יום שלישי\0", "יום רביעי\0", "יום חמישי\0", "יום שישי\0", "יום שבת\0", "יום ראשון\0" },
        { "ב׳\0", "ג׳\0", "ד׳\0", "ה׳\0", "ו׳\0", "ש׳\0", "א׳\0" }
    }, // he_IL
    {
        QLocale::Language::Hindi, QLocale::Script::DevanagariScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "हिन्दी\0", "भारत\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "जन॰\0", "फ़र॰\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुल॰\0", "अग॰\0", "सित॰\0", "अक्तू॰\0", "नव॰\0", "दिस॰\0" },
        { "जनवरी\0", "फ़रवरी\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुलाई\0", "अगस्त\0", "सितंबर\0", "अक्तूबर\0", "नवंबर\0", "दिसंबर\0" },
        { "ज\0", "फ़\0", "मा\0", "अ\0", "म\0", "जू\0", "जु\0", "अ\0", "सि\0", "अ\0", "न\0", "दि\0" },
        { "जन॰\0", "फ़र॰\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुल॰\0", "अग॰\0", "सित॰\0", "अक्तू॰\0", "नव॰\0", "दिस॰\0" },
        { "जनवरी\0", "फ़रवरी\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुलाई\0", "अगस्त\0", "सितंबर\0", "अक्तूबर\0", "नवंबर\0", "दिसंबर\0" },
        { "ज\0", "फ़\0", "मा\0", "अ\0", "म\0", "जू\0", "जु\0", "अ\0", "सि\0", "अ\0", "न\0", "दि\0" },
        { "सोम\0", "मंगल\0", "बुध\0", "गुरु\0", "शुक्र\0", "शनि\0", "रवि\0" },
        { "सोमवार\0", "मंगलवार\0", "बुधवार\0", "गुरुवार\0", "शुक्रवार\0", "शनिवार\0", "रविवार\0" },
        { "सो\0", "मं\0", "बु\0", "गु\0", "शु\0", "श\0", "र\0" },
        { "सोम\0", "मंगल\0", "बुध\0", "गुरु\0", "शुक्र\0", "शनि\0", "रवि\0" },
        { "सोमवार\0", "मंगलवार\0", "बुधवार\0", "गुरुवार\0", "शुक्रवार\0", "शनिवार\0", "रविवार\0" },
        { "सो\0", "मं\0", "बु\0", "गु\0", "शु\0", "श\0", "र\0" }
    }, // hi_IN
    {
        QLocale::Language::Hindi, QLocale::Script::LatinScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "हिन्दी\0", "भारत\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "am\0", "pm\0",
        { "जन॰\0", "फ़र॰\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुल॰\0", "अग॰\0", "सित॰\0", "अक्तू॰\0", "नव॰\0", "दिस॰\0" },
        { "जनवरी\0", "फ़रवरी\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुलाई\0", "अगस्त\0", "सितंबर\0", "अक्तूबर\0", "नवंबर\0", "दिसंबर\0" },
        { "ज\0", "फ़\0", "मा\0", "अ\0", "म\0", "जू\0", "जु\0", "अ\0", "सि\0", "अ\0", "न\0", "दि\0" },
        { "जन॰\0", "फ़र॰\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुल॰\0", "अग॰\0", "सित॰\0", "अक्तू॰\0", "नव॰\0", "दिस॰\0" },
        { "जनवरी\0", "फ़रवरी\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुलाई\0", "अगस्त\0", "सितंबर\0", "अक्तूबर\0", "नवंबर\0", "दिसंबर\0" },
        { "ज\0", "फ़\0", "मा\0", "अ\0", "म\0", "जू\0", "जु\0", "अ\0", "सि\0", "अ\0", "न\0", "दि\0" },
        { "सोम\0", "मंगल\0", "बुध\0", "गुरु\0", "शुक्र\0", "शनि\0", "रवि\0" },
        { "सोमवार\0", "मंगलवार\0", "बुधवार\0", "गुरुवार\0", "शुक्रवार\0", "शनिवार\0", "रविवार\0" },
        { "सो\0", "मं\0", "बु\0", "गु\0", "शु\0", "श\0", "र\0" },
        { "सोम\0", "मंगल\0", "बुध\0", "गुरु\0", "शुक्र\0", "शनि\0", "रवि\0" },
        { "सोमवार\0", "मंगलवार\0", "बुधवार\0", "गुरुवार\0", "शुक्रवार\0", "शनिवार\0", "रविवार\0" },
        { "सो\0", "मं\0", "बु\0", "गु\0", "शु\0", "श\0", "र\0" }
    }, // hi_Latn_IN
    {
        QLocale::Language::Croatian, QLocale::Script::LatinScript, QLocale::Country::BosniaAndHerzegovina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 8722, 43, 69, 48,
        "hrvatski\0", "Bosna i Hercegovina\0",
        "d. M. yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "sij\0", "velj\0", "ožu\0", "tra\0", "svi\0", "lip\0", "srp\0", "kol\0", "ruj\0", "lis\0", "stu\0", "pro\0" },
        { "siječanj\0", "veljača\0", "ožujak\0", "travanj\0", "svibanj\0", "lipanj\0", "srpanj\0", "kolovoz\0", "rujan\0", "listopad\0", "studeni\0", "prosinac\0" },
        { "1.\0", "2.\0", "3.\0", "4.\0", "5.\0", "6.\0", "7.\0", "8.\0", "9.\0", "10.\0", "11.\0", "12.\0" },
        { "sij\0", "velj\0", "ožu\0", "tra\0", "svi\0", "lip\0", "srp\0", "kol\0", "ruj\0", "lis\0", "stu\0", "pro\0" },
        { "siječnja\0", "veljače\0", "ožujka\0", "travnja\0", "svibnja\0", "lipnja\0", "srpnja\0", "kolovoza\0", "rujna\0", "listopada\0", "studenoga\0", "prosinca\0" },
        { "1.\0", "2.\0", "3.\0", "4.\0", "5.\0", "6.\0", "7.\0", "8.\0", "9.\0", "10.\0", "11.\0", "12.\0" },
        { "pon\0", "uto\0", "sri\0", "čet\0", "pet\0", "sub\0", "ned\0" },
        { "ponedjeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "P\0", "U\0", "S\0", "Č\0", "P\0", "S\0", "N\0" },
        { "pon\0", "uto\0", "sri\0", "čet\0", "pet\0", "sub\0", "ned\0" },
        { "ponedjeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "P\0", "U\0", "S\0", "Č\0", "P\0", "S\0", "N\0" }
    }, // hr_BA
    {
        QLocale::Language::Croatian, QLocale::Script::LatinScript, QLocale::Country::Croatia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 8722, 43, 69, 48,
        "hrvatski\0", "Hrvatska\0",
        "dd. MM. yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "sij\0", "velj\0", "ožu\0", "tra\0", "svi\0", "lip\0", "srp\0", "kol\0", "ruj\0", "lis\0", "stu\0", "pro\0" },
        { "siječanj\0", "veljača\0", "ožujak\0", "travanj\0", "svibanj\0", "lipanj\0", "srpanj\0", "kolovoz\0", "rujan\0", "listopad\0", "studeni\0", "prosinac\0" },
        { "1.\0", "2.\0", "3.\0", "4.\0", "5.\0", "6.\0", "7.\0", "8.\0", "9.\0", "10.\0", "11.\0", "12.\0" },
        { "sij\0", "velj\0", "ožu\0", "tra\0", "svi\0", "lip\0", "srp\0", "kol\0", "ruj\0", "lis\0", "stu\0", "pro\0" },
        { "siječnja\0", "veljače\0", "ožujka\0", "travnja\0", "svibnja\0", "lipnja\0", "srpnja\0", "kolovoza\0", "rujna\0", "listopada\0", "studenoga\0", "prosinca\0" },
        { "1.\0", "2.\0", "3.\0", "4.\0", "5.\0", "6.\0", "7.\0", "8.\0", "9.\0", "10.\0", "11.\0", "12.\0" },
        { "pon\0", "uto\0", "sri\0", "čet\0", "pet\0", "sub\0", "ned\0" },
        { "ponedjeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "p\0", "u\0", "s\0", "č\0", "p\0", "s\0", "n\0" },
        { "pon\0", "uto\0", "sri\0", "čet\0", "pet\0", "sub\0", "ned\0" },
        { "ponedjeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "P\0", "U\0", "S\0", "Č\0", "P\0", "S\0", "N\0" }
    }, // hr_HR
    {
        QLocale::Language::UpperSorbian, QLocale::Script::LatinScript, QLocale::Country::Germany,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "hornjoserbšćina\0", "Němska\0",
        "d.M.yyyy\0", "d. MMMM yyyy\0", "H:mm 'hodź'.\0", "H:mm:ss Z\0",
        "dopołdnja\0", "popołdnju\0",
        { "jan\0", "feb\0", "měr\0", "apr\0", "mej\0", "jun\0", "jul\0", "awg\0", "sep\0", "okt\0", "now\0", "dec\0" },
        { "januar\0", "februar\0", "měrc\0", "apryl\0", "meja\0", "junij\0", "julij\0", "awgust\0", "september\0", "oktober\0", "nowember\0", "december\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "jan.\0", "feb.\0", "měr.\0", "apr.\0", "mej.\0", "jun.\0", "jul.\0", "awg.\0", "sep.\0", "okt.\0", "now.\0", "dec.\0" },
        { "januara\0", "februara\0", "měrca\0", "apryla\0", "meje\0", "junija\0", "julija\0", "awgusta\0", "septembra\0", "oktobra\0", "nowembra\0", "decembra\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "pón\0", "wut\0", "srj\0", "štw\0", "pja\0", "sob\0", "nje\0" },
        { "póndźela\0", "wutora\0", "srjeda\0", "štwórtk\0", "pjatk\0", "sobota\0", "njedźela\0" },
        { "p\0", "w\0", "s\0", "š\0", "p\0", "s\0", "n\0" },
        { "pón\0", "wut\0", "srj\0", "štw\0", "pja\0", "sob\0", "nje\0" },
        { "póndźela\0", "wutora\0", "srjeda\0", "štwórtk\0", "pjatk\0", "sobota\0", "njedźela\0" },
        { "p\0", "w\0", "s\0", "š\0", "p\0", "s\0", "n\0" }
    }, // hsb_DE
    {
        QLocale::Language::Hungarian, QLocale::Script::LatinScript, QLocale::Country::Hungary,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "magyar\0", "Magyarország\0",
        "yyyy. MM. dd.\0", "yyyy. MMMM d.\0", "H:mm\0", "H:mm:ss Z\0",
        "de.\0", "du.\0",
        { "jan.\0", "febr.\0", "márc.\0", "ápr.\0", "máj.\0", "jún.\0", "júl.\0", "aug.\0", "szept.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "január\0", "február\0", "március\0", "április\0", "május\0", "június\0", "július\0", "augusztus\0", "szeptember\0", "október\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "Á\0", "M\0", "J\0", "J\0", "A\0", "Sz\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "febr.\0", "márc.\0", "ápr.\0", "máj.\0", "jún.\0", "júl.\0", "aug.\0", "szept.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "január\0", "február\0", "március\0", "április\0", "május\0", "június\0", "július\0", "augusztus\0", "szeptember\0", "október\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "Á\0", "M\0", "J\0", "J\0", "A\0", "Sz\0", "O\0", "N\0", "D\0" },
        { "H\0", "K\0", "Sze\0", "Cs\0", "P\0", "Szo\0", "V\0" },
        { "hétfő\0", "kedd\0", "szerda\0", "csütörtök\0", "péntek\0", "szombat\0", "vasárnap\0" },
        { "H\0", "K\0", "Sz\0", "Cs\0", "P\0", "Sz\0", "V\0" },
        { "H\0", "K\0", "Sze\0", "Cs\0", "P\0", "Szo\0", "V\0" },
        { "hétfő\0", "kedd\0", "szerda\0", "csütörtök\0", "péntek\0", "szombat\0", "vasárnap\0" },
        { "H\0", "K\0", "Sz\0", "Cs\0", "P\0", "Sz\0", "V\0" }
    }, // hu_HU
    {
        QLocale::Language::Armenian, QLocale::Script::ArmenianScript, QLocale::Country::Armenia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "հայերեն\0", "Հայաստան\0",
        "dd.MM.yyyy\0", "dd MMMM, yyyy թ.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "հնվ\0", "փտվ\0", "մրտ\0", "ապր\0", "մյս\0", "հնս\0", "հլս\0", "օգս\0", "սեպ\0", "հոկ\0", "նոյ\0", "դեկ\0" },
        { "հունվար\0", "փետրվար\0", "մարտ\0", "ապրիլ\0", "մայիս\0", "հունիս\0", "հուլիս\0", "օգոստոս\0", "սեպտեմբեր\0", "հոկտեմբեր\0", "նոյեմբեր\0", "դեկտեմբեր\0" },
        { "Հ\0", "Փ\0", "Մ\0", "Ա\0", "Մ\0", "Հ\0", "Հ\0", "Օ\0", "Ս\0", "Հ\0", "Ն\0", "Դ\0" },
        { "հնվ\0", "փտվ\0", "մրտ\0", "ապր\0", "մյս\0", "հնս\0", "հլս\0", "օգս\0", "սեպ\0", "հոկ\0", "նոյ\0", "դեկ\0" },
        { "հունվարի\0", "փետրվարի\0", "մարտի\0", "ապրիլի\0", "մայիսի\0", "հունիսի\0", "հուլիսի\0", "օգոստոսի\0", "սեպտեմբերի\0", "հոկտեմբերի\0", "նոյեմբերի\0", "դեկտեմբերի\0" },
        { "Հ\0", "Փ\0", "Մ\0", "Ա\0", "Մ\0", "Հ\0", "Հ\0", "Օ\0", "Ս\0", "Հ\0", "Ն\0", "Դ\0" },
        { "երկ\0", "երք\0", "չրք\0", "հնգ\0", "ուր\0", "շբթ\0", "կիր\0" },
        { "երկուշաբթի\0", "երեքշաբթի\0", "չորեքշաբթի\0", "հինգշաբթի\0", "ուրբաթ\0", "շաբաթ\0", "կիրակի\0" },
        { "Ե\0", "Ե\0", "Չ\0", "Հ\0", "Ո\0", "Շ\0", "Կ\0" },
        { "երկ\0", "երք\0", "չրք\0", "հնգ\0", "ուր\0", "շբթ\0", "կիր\0" },
        { "երկուշաբթի\0", "երեքշաբթի\0", "չորեքշաբթի\0", "հինգշաբթի\0", "ուրբաթ\0", "շաբաթ\0", "կիրակի\0" },
        { "Ե\0", "Ե\0", "Չ\0", "Հ\0", "Ո\0", "Շ\0", "Կ\0" }
    }, // hy_AM
    {
        QLocale::Language::Interlingua, QLocale::Script::AnyScript, QLocale::Country::world,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "interlingua\0", "Mundo\0",
        "dd-MM-yyyy\0", "d 'dddd' MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "jan\0", "feb\0", "mar\0", "apr\0", "mai\0", "jun\0", "jul\0", "aug\0", "sep\0", "oct\0", "nov\0", "dec\0" },
        { "januario\0", "februario\0", "martio\0", "april\0", "maio\0", "junio\0", "julio\0", "augusto\0", "septembre\0", "octobre\0", "novembre\0", "decembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "jan\0", "feb\0", "mar\0", "apr\0", "mai\0", "jun\0", "jul\0", "aug\0", "sep\0", "oct\0", "nov\0", "dec\0" },
        { "januario\0", "februario\0", "martio\0", "april\0", "maio\0", "junio\0", "julio\0", "augusto\0", "septembre\0", "octobre\0", "novembre\0", "decembre\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "lun\0", "mar\0", "mer\0", "jov\0", "ven\0", "sab\0", "dom\0" },
        { "lunedi\0", "martedi\0", "mercuridi\0", "jovedi\0", "venerdi\0", "sabbato\0", "dominica\0" },
        { "l\0", "m\0", "m\0", "j\0", "v\0", "s\0", "d\0" },
        { "lun\0", "mar\0", "mer\0", "jov\0", "ven\0", "sab\0", "dom\0" },
        { "lunedi\0", "martedi\0", "mercuridi\0", "jovedi\0", "venerdi\0", "sabbato\0", "dominica\0" },
        { "l\0", "m\0", "m\0", "j\0", "v\0", "s\0", "d\0" }
    }, // ia_001
    {
        QLocale::Language::Indonesian, QLocale::Script::LatinScript, QLocale::Country::Indonesia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Indonesia\0", "Indonesia\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH.mm\0", "HH.mm.ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Agu\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Maret\0", "April\0", "Mei\0", "Juni\0", "Juli\0", "Agustus\0", "September\0", "Oktober\0", "November\0", "Desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Agu\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Maret\0", "April\0", "Mei\0", "Juni\0", "Juli\0", "Agustus\0", "September\0", "Oktober\0", "November\0", "Desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Sen\0", "Sel\0", "Rab\0", "Kam\0", "Jum\0", "Sab\0", "Min\0" },
        { "Senin\0", "Selasa\0", "Rabu\0", "Kamis\0", "Jumat\0", "Sabtu\0", "Minggu\0" },
        { "S\0", "S\0", "R\0", "K\0", "J\0", "S\0", "M\0" },
        { "Sen\0", "Sel\0", "Rab\0", "Kam\0", "Jum\0", "Sab\0", "Min\0" },
        { "Senin\0", "Selasa\0", "Rabu\0", "Kamis\0", "Jumat\0", "Sabtu\0", "Minggu\0" },
        { "S\0", "S\0", "R\0", "K\0", "J\0", "S\0", "M\0" }
    }, // id_ID
    {
        QLocale::Language::Igbo, QLocale::Script::LatinScript, QLocale::Country::Nigeria,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Igbo\0", "Naịjịrịa\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "A.M.\0", "P.M.\0",
        { "Jen\0", "Feb\0", "Maa\0", "Epr\0", "Mee\0", "Juu\0", "Jul\0", "Ọgọ\0", "Sep\0", "Ọkt\0", "Nov\0", "Dis\0" },
        { "Jenụwarị\0", "Febrụwarị\0", "Maachị\0", "Epreel\0", "Mee\0", "Juun\0", "Julaị\0", "Ọgọọst\0", "Septemba\0", "Ọktoba\0", "Novemba\0", "Disemba\0" },
        { "J\0", "F\0", "M\0", "E\0", "M\0", "J\0", "J\0", "Ọ\0", "S\0", "Ọ\0", "N\0", "D\0" },
        { "Jen\0", "Feb\0", "Maa\0", "Epr\0", "Mee\0", "Juu\0", "Jul\0", "Ọgọ\0", "Sep\0", "Ọkt\0", "Nov\0", "Dis\0" },
        { "Jenụwarị\0", "Febrụwarị\0", "Maachị\0", "Epreel\0", "Mee\0", "Juun\0", "Julaị\0", "Ọgọọst\0", "Septemba\0", "Ọktoba\0", "Novemba\0", "Disemba\0" },
        { "J\0", "F\0", "M\0", "E\0", "M\0", "J\0", "J\0", "Ọ\0", "S\0", "Ọ\0", "N\0", "D\0" },
        { "Mọn\0", "Tiu\0", "Wen\0", "Tọọ\0", "Fraị\0", "Sat\0", "Sọn\0" },
        { "Mọnde\0", "Tiuzdee\0", "Wenezdee\0", "Tọọzdee\0", "Fraịdee\0", "Satọdee\0", "Sọndee\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mọn\0", "Tiu\0", "Wen\0", "Tọọ\0", "Fraị\0", "Sat\0", "Sọn\0" },
        { "Mọnde\0", "Tiuzdee\0", "Wenezdee\0", "Tọọzdee\0", "Fraịdee\0", "Satọdee\0", "Sọndee\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ig_NG
    {
        QLocale::Language::SichuanYi, QLocale::Script::YiScript, QLocale::Country::China,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ꆈꌠꉙ\0", "ꍏꇩ\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ꎸꄑ\0", "ꁯꋒ\0",
        { "ꋍꆪ\0", "ꑍꆪ\0", "ꌕꆪ\0", "ꇖꆪ\0", "ꉬꆪ\0", "ꃘꆪ\0", "ꏃꆪ\0", "ꉆꆪ\0", "ꈬꆪ\0", "ꊰꆪ\0", "ꊰꊪꆪ\0", "ꊰꑋꆪ\0" },
        { "ꋍꆪ\0", "ꑍꆪ\0", "ꌕꆪ\0", "ꇖꆪ\0", "ꉬꆪ\0", "ꃘꆪ\0", "ꏃꆪ\0", "ꉆꆪ\0", "ꈬꆪ\0", "ꊰꆪ\0", "ꊰꊪꆪ\0", "ꊰꑋꆪ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ꋍꆪ\0", "ꑍꆪ\0", "ꌕꆪ\0", "ꇖꆪ\0", "ꉬꆪ\0", "ꃘꆪ\0", "ꏃꆪ\0", "ꉆꆪ\0", "ꈬꆪ\0", "ꊰꆪ\0", "ꊰꊪꆪ\0", "ꊰꑋꆪ\0" },
        { "ꋍꆪ\0", "ꑍꆪ\0", "ꌕꆪ\0", "ꇖꆪ\0", "ꉬꆪ\0", "ꃘꆪ\0", "ꏃꆪ\0", "ꉆꆪ\0", "ꈬꆪ\0", "ꊰꆪ\0", "ꊰꊪꆪ\0", "ꊰꑋꆪ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ꆏꋍ\0", "ꆏꑍ\0", "ꆏꌕ\0", "ꆏꇖ\0", "ꆏꉬ\0", "ꆏꃘ\0", "ꑭꆏ\0" },
        { "ꆏꊂꋍ\0", "ꆏꊂꑍ\0", "ꆏꊂꌕ\0", "ꆏꊂꇖ\0", "ꆏꊂꉬ\0", "ꆏꊂꃘ\0", "ꑭꆏꑍ\0" },
        { "ꋍ\0", "ꑍ\0", "ꌕ\0", "ꇖ\0", "ꉬ\0", "ꃘ\0", "ꆏ\0" },
        { "ꆏꋍ\0", "ꆏꑍ\0", "ꆏꌕ\0", "ꆏꇖ\0", "ꆏꉬ\0", "ꆏꃘ\0", "ꑭꆏ\0" },
        { "ꆏꊂꋍ\0", "ꆏꊂꑍ\0", "ꆏꊂꌕ\0", "ꆏꊂꇖ\0", "ꆏꊂꉬ\0", "ꆏꊂꃘ\0", "ꑭꆏꑍ\0" },
        { "ꋍ\0", "ꑍ\0", "ꌕ\0", "ꇖ\0", "ꉬ\0", "ꃘ\0", "ꆏ\0" }
    }, // ii_CN
    {
        QLocale::Language::Icelandic, QLocale::Script::LatinScript, QLocale::Country::Iceland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "íslenska\0", "Ísland\0",
        "d.M.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "f.h.\0", "e.h.\0",
        { "jan.\0", "feb.\0", "mar.\0", "apr.\0", "maí\0", "jún.\0", "júl.\0", "ágú.\0", "sep.\0", "okt.\0", "nóv.\0", "des.\0" },
        { "janúar\0", "febrúar\0", "mars\0", "apríl\0", "maí\0", "júní\0", "júlí\0", "ágúst\0", "september\0", "október\0", "nóvember\0", "desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "Á\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mar.\0", "apr.\0", "maí\0", "jún.\0", "júl.\0", "ágú.\0", "sep.\0", "okt.\0", "nóv.\0", "des.\0" },
        { "janúar\0", "febrúar\0", "mars\0", "apríl\0", "maí\0", "júní\0", "júlí\0", "ágúst\0", "september\0", "október\0", "nóvember\0", "desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "Á\0", "S\0", "O\0", "N\0", "D\0" },
        { "mán.\0", "þri.\0", "mið.\0", "fim.\0", "fös.\0", "lau.\0", "sun.\0" },
        { "mánudagur\0", "þriðjudagur\0", "miðvikudagur\0", "fimmtudagur\0", "föstudagur\0", "laugardagur\0", "sunnudagur\0" },
        { "M\0", "Þ\0", "M\0", "F\0", "F\0", "L\0", "S\0" },
        { "mán.\0", "þri.\0", "mið.\0", "fim.\0", "fös.\0", "lau.\0", "sun.\0" },
        { "mánudagur\0", "þriðjudagur\0", "miðvikudagur\0", "fimmtudagur\0", "föstudagur\0", "laugardagur\0", "sunnudagur\0" },
        { "M\0", "Þ\0", "M\0", "F\0", "F\0", "L\0", "S\0" }
    }, // is_IS
    {
        QLocale::Language::Italian, QLocale::Script::LatinScript, QLocale::Country::Switzerland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 8217, 59, 37, 45, 43, 69, 48,
        "italiano\0", "Svizzera\0",
        "dd.MM.yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "gen\0", "feb\0", "mar\0", "apr\0", "mag\0", "giu\0", "lug\0", "ago\0", "set\0", "ott\0", "nov\0", "dic\0" },
        { "gennaio\0", "febbraio\0", "marzo\0", "aprile\0", "maggio\0", "giugno\0", "luglio\0", "agosto\0", "settembre\0", "ottobre\0", "novembre\0", "dicembre\0" },
        { "G\0", "F\0", "M\0", "A\0", "M\0", "G\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "gen\0", "feb\0", "mar\0", "apr\0", "mag\0", "giu\0", "lug\0", "ago\0", "set\0", "ott\0", "nov\0", "dic\0" },
        { "gennaio\0", "febbraio\0", "marzo\0", "aprile\0", "maggio\0", "giugno\0", "luglio\0", "agosto\0", "settembre\0", "ottobre\0", "novembre\0", "dicembre\0" },
        { "G\0", "F\0", "M\0", "A\0", "M\0", "G\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mer\0", "gio\0", "ven\0", "sab\0", "dom\0" },
        { "lunedì\0", "martedì\0", "mercoledì\0", "giovedì\0", "venerdì\0", "sabato\0", "domenica\0" },
        { "L\0", "M\0", "M\0", "G\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mer\0", "gio\0", "ven\0", "sab\0", "dom\0" },
        { "lunedì\0", "martedì\0", "mercoledì\0", "giovedì\0", "venerdì\0", "sabato\0", "domenica\0" },
        { "L\0", "M\0", "M\0", "G\0", "V\0", "S\0", "D\0" }
    }, // it_CH
    {
        QLocale::Language::Italian, QLocale::Script::LatinScript, QLocale::Country::Italy,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "italiano\0", "Italia\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "gen\0", "feb\0", "mar\0", "apr\0", "mag\0", "giu\0", "lug\0", "ago\0", "set\0", "ott\0", "nov\0", "dic\0" },
        { "gennaio\0", "febbraio\0", "marzo\0", "aprile\0", "maggio\0", "giugno\0", "luglio\0", "agosto\0", "settembre\0", "ottobre\0", "novembre\0", "dicembre\0" },
        { "G\0", "F\0", "M\0", "A\0", "M\0", "G\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "gen\0", "feb\0", "mar\0", "apr\0", "mag\0", "giu\0", "lug\0", "ago\0", "set\0", "ott\0", "nov\0", "dic\0" },
        { "gennaio\0", "febbraio\0", "marzo\0", "aprile\0", "maggio\0", "giugno\0", "luglio\0", "agosto\0", "settembre\0", "ottobre\0", "novembre\0", "dicembre\0" },
        { "G\0", "F\0", "M\0", "A\0", "M\0", "G\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mer\0", "gio\0", "ven\0", "sab\0", "dom\0" },
        { "lunedì\0", "martedì\0", "mercoledì\0", "giovedì\0", "venerdì\0", "sabato\0", "domenica\0" },
        { "L\0", "M\0", "M\0", "G\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mer\0", "gio\0", "ven\0", "sab\0", "dom\0" },
        { "lunedì\0", "martedì\0", "mercoledì\0", "giovedì\0", "venerdì\0", "sabato\0", "domenica\0" },
        { "L\0", "M\0", "M\0", "G\0", "V\0", "S\0", "D\0" }
    }, // it_IT
    {
        QLocale::Language::Italian, QLocale::Script::LatinScript, QLocale::Country::SanMarino,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "italiano\0", "San Marino\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "gen\0", "feb\0", "mar\0", "apr\0", "mag\0", "giu\0", "lug\0", "ago\0", "set\0", "ott\0", "nov\0", "dic\0" },
        { "gennaio\0", "febbraio\0", "marzo\0", "aprile\0", "maggio\0", "giugno\0", "luglio\0", "agosto\0", "settembre\0", "ottobre\0", "novembre\0", "dicembre\0" },
        { "G\0", "F\0", "M\0", "A\0", "M\0", "G\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "gen\0", "feb\0", "mar\0", "apr\0", "mag\0", "giu\0", "lug\0", "ago\0", "set\0", "ott\0", "nov\0", "dic\0" },
        { "gennaio\0", "febbraio\0", "marzo\0", "aprile\0", "maggio\0", "giugno\0", "luglio\0", "agosto\0", "settembre\0", "ottobre\0", "novembre\0", "dicembre\0" },
        { "G\0", "F\0", "M\0", "A\0", "M\0", "G\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mer\0", "gio\0", "ven\0", "sab\0", "dom\0" },
        { "lunedì\0", "martedì\0", "mercoledì\0", "giovedì\0", "venerdì\0", "sabato\0", "domenica\0" },
        { "L\0", "M\0", "M\0", "G\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mer\0", "gio\0", "ven\0", "sab\0", "dom\0" },
        { "lunedì\0", "martedì\0", "mercoledì\0", "giovedì\0", "venerdì\0", "sabato\0", "domenica\0" },
        { "L\0", "M\0", "M\0", "G\0", "V\0", "S\0", "D\0" }
    }, // it_SM
    {
        QLocale::Language::Italian, QLocale::Script::LatinScript, QLocale::Country::VaticanCity,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "italiano\0", "Città del Vaticano\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "gen\0", "feb\0", "mar\0", "apr\0", "mag\0", "giu\0", "lug\0", "ago\0", "set\0", "ott\0", "nov\0", "dic\0" },
        { "gennaio\0", "febbraio\0", "marzo\0", "aprile\0", "maggio\0", "giugno\0", "luglio\0", "agosto\0", "settembre\0", "ottobre\0", "novembre\0", "dicembre\0" },
        { "G\0", "F\0", "M\0", "A\0", "M\0", "G\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "gen\0", "feb\0", "mar\0", "apr\0", "mag\0", "giu\0", "lug\0", "ago\0", "set\0", "ott\0", "nov\0", "dic\0" },
        { "gennaio\0", "febbraio\0", "marzo\0", "aprile\0", "maggio\0", "giugno\0", "luglio\0", "agosto\0", "settembre\0", "ottobre\0", "novembre\0", "dicembre\0" },
        { "G\0", "F\0", "M\0", "A\0", "M\0", "G\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun\0", "mar\0", "mer\0", "gio\0", "ven\0", "sab\0", "dom\0" },
        { "lunedì\0", "martedì\0", "mercoledì\0", "giovedì\0", "venerdì\0", "sabato\0", "domenica\0" },
        { "L\0", "M\0", "M\0", "G\0", "V\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mer\0", "gio\0", "ven\0", "sab\0", "dom\0" },
        { "lunedì\0", "martedì\0", "mercoledì\0", "giovedì\0", "venerdì\0", "sabato\0", "domenica\0" },
        { "L\0", "M\0", "M\0", "G\0", "V\0", "S\0", "D\0" }
    }, // it_VA
    {
        QLocale::Language::Japanese, QLocale::Script::JapaneseScript, QLocale::Country::Japan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "日本語\0", "日本\0",
        "yyyy/MM/dd\0", "yyyy年M月d日\0", "H:mm\0", "H:mm:ss Z\0",
        "午前\0", "午後\0",
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "月\0", "火\0", "水\0", "木\0", "金\0", "土\0", "日\0" },
        { "月曜日\0", "火曜日\0", "水曜日\0", "木曜日\0", "金曜日\0", "土曜日\0", "日曜日\0" },
        { "月\0", "火\0", "水\0", "木\0", "金\0", "土\0", "日\0" },
        { "月\0", "火\0", "水\0", "木\0", "金\0", "土\0", "日\0" },
        { "月曜日\0", "火曜日\0", "水曜日\0", "木曜日\0", "金曜日\0", "土曜日\0", "日曜日\0" },
        { "月\0", "火\0", "水\0", "木\0", "金\0", "土\0", "日\0" }
    }, // ja_JP
    {
        QLocale::Language::Ngomba, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Ndaꞌa\0", "Kamɛlûn\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "mbaꞌmbaꞌ\0", "ŋka mbɔ́t nji\0",
        { "Nduŋmbi Saŋ\0", "Pɛsaŋ Pɛ́pá\0", "Pɛsaŋ Pɛ́tát\0", "Pɛsaŋ Pɛ́nɛ́kwa\0", "Pɛsaŋ Pataa\0", "Pɛsaŋ Pɛ́nɛ́ntúkú\0", "Pɛsaŋ Saambá\0", "Pɛsaŋ Pɛ́nɛ́fɔm\0", "Pɛsaŋ Pɛ́nɛ́pfúꞋú\0", "Pɛsaŋ Nɛgɛ́m\0", "Pɛsaŋ Ntsɔ̌pmɔ́\0", "Pɛsaŋ Ntsɔ̌ppá\0" },
        { "Nduŋmbi Saŋ\0", "Pɛsaŋ Pɛ́pá\0", "Pɛsaŋ Pɛ́tát\0", "Pɛsaŋ Pɛ́nɛ́kwa\0", "Pɛsaŋ Pataa\0", "Pɛsaŋ Pɛ́nɛ́ntúkú\0", "Pɛsaŋ Saambá\0", "Pɛsaŋ Pɛ́nɛ́fɔm\0", "Pɛsaŋ Pɛ́nɛ́pfúꞋú\0", "Pɛsaŋ Nɛgɛ́m\0", "Pɛsaŋ Ntsɔ̌pmɔ́\0", "Pɛsaŋ Ntsɔ̌ppá\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Nduŋmbi Saŋ\0", "Pɛsaŋ Pɛ́pá\0", "Pɛsaŋ Pɛ́tát\0", "Pɛsaŋ Pɛ́nɛ́kwa\0", "Pɛsaŋ Pataa\0", "Pɛsaŋ Pɛ́nɛ́ntúkú\0", "Pɛsaŋ Saambá\0", "Pɛsaŋ Pɛ́nɛ́fɔm\0", "Pɛsaŋ Pɛ́nɛ́pfúꞋú\0", "Pɛsaŋ Nɛgɛ́m\0", "Pɛsaŋ Ntsɔ̌pmɔ́\0", "Pɛsaŋ Ntsɔ̌ppá\0" },
        { "Nduŋmbi Saŋ\0", "Pɛsaŋ Pɛ́pá\0", "Pɛsaŋ Pɛ́tát\0", "Pɛsaŋ Pɛ́nɛ́kwa\0", "Pɛsaŋ Pataa\0", "Pɛsaŋ Pɛ́nɛ́ntúkú\0", "Pɛsaŋ Saambá\0", "Pɛsaŋ Pɛ́nɛ́fɔm\0", "Pɛsaŋ Pɛ́nɛ́pfúꞋú\0", "Pɛsaŋ Nɛgɛ́m\0", "Pɛsaŋ Ntsɔ̌pmɔ́\0", "Pɛsaŋ Ntsɔ̌ppá\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mɔ́ndi\0", "Ápta Mɔ́ndi\0", "Wɛ́nɛsɛdɛ\0", "Tɔ́sɛdɛ\0", "Fɛlâyɛdɛ\0", "Sásidɛ\0", "Sɔ́ndi\0" },
        { "Mɔ́ndi\0", "Ápta Mɔ́ndi\0", "Wɛ́nɛsɛdɛ\0", "Tɔ́sɛdɛ\0", "Fɛlâyɛdɛ\0", "Sásidɛ\0", "Sɔ́ndi\0" },
        { "Mɔ́\0", "ÁM\0", "Wɛ́\0", "Tɔ́\0", "Fɛ\0", "Sá\0", "Sɔ́\0" },
        { "Mɔ́ndi\0", "Ápta Mɔ́ndi\0", "Wɛ́nɛsɛdɛ\0", "Tɔ́sɛdɛ\0", "Fɛlâyɛdɛ\0", "Sásidɛ\0", "Sɔ́ndi\0" },
        { "Mɔ́ndi\0", "Ápta Mɔ́ndi\0", "Wɛ́nɛsɛdɛ\0", "Tɔ́sɛdɛ\0", "Fɛlâyɛdɛ\0", "Sásidɛ\0", "Sɔ́ndi\0" },
        { "Mɔ́\0", "ÁM\0", "Wɛ́\0", "Tɔ́\0", "Fɛ\0", "Sá\0", "Sɔ́\0" }
    }, // jgo_CM
    {
        QLocale::Language::Machame, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kimachame\0", "Tanzania\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "utuko\0", "kyiukonyi\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprilyi\0", "Mei\0", "Junyi\0", "Julyai\0", "Agusti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "J\0", "J\0", "J\0", "A\0", "I\0", "J\0", "J\0" },
        { "Jtt\0", "Jnn\0", "Jtn\0", "Alh\0", "Iju\0", "Jmo\0", "Jpi\0" },
        { "Jumatatuu\0", "Jumanne\0", "Jumatanu\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapilyi\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // jmc_TZ
    {
        QLocale::Language::Javanese, QLocale::Script::LatinScript, QLocale::Country::Indonesia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Jawa\0", "Indonésia\0",
        "dd-MM-yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Isuk\0", "Wengi\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Agt\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Maret\0", "April\0", "Mei\0", "Juni\0", "Juli\0", "Agustus\0", "September\0", "Oktober\0", "November\0", "Desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Agt\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Maret\0", "April\0", "Mei\0", "Juni\0", "Juli\0", "Agustus\0", "September\0", "Oktober\0", "November\0", "Desember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Sen\0", "Sel\0", "Rab\0", "Kam\0", "Jum\0", "Sab\0", "Ahad\0" },
        { "Senin\0", "Selasa\0", "Rabu\0", "Kamis\0", "Jumat\0", "Sabtu\0", "Ahad\0" },
        { "S\0", "S\0", "R\0", "K\0", "J\0", "S\0", "A\0" },
        { "Sen\0", "Sel\0", "Rab\0", "Kam\0", "Jum\0", "Sab\0", "Ahad\0" },
        { "Senin\0", "Selasa\0", "Rabu\0", "Kamis\0", "Jumat\0", "Sabtu\0", "Ahad\0" },
        { "S\0", "S\0", "R\0", "K\0", "J\0", "S\0", "A\0" }
    }, // jv_ID
    {
        QLocale::Language::Georgian, QLocale::Script::GeorgianScript, QLocale::Country::Georgia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "ქართული\0", "საქართველო\0",
        "dd.MM.yyyy\0", "d MMMM, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "იან\0", "თებ\0", "მარ\0", "აპრ\0", "მაი\0", "ივნ\0", "ივლ\0", "აგვ\0", "სექ\0", "ოქტ\0", "ნოე\0", "დეკ\0" },
        { "იანვარი\0", "თებერვალი\0", "მარტი\0", "აპრილი\0", "მაისი\0", "ივნისი\0", "ივლისი\0", "აგვისტო\0", "სექტემბერი\0", "ოქტომბერი\0", "ნოემბერი\0", "დეკემბერი\0" },
        { "ი\0", "თ\0", "მ\0", "ა\0", "მ\0", "ი\0", "ი\0", "ა\0", "ს\0", "ო\0", "ნ\0", "დ\0" },
        { "იან\0", "თებ\0", "მარ\0", "აპრ\0", "მაი\0", "ივნ\0", "ივლ\0", "აგვ\0", "სექ\0", "ოქტ\0", "ნოე\0", "დეკ\0" },
        { "იანვარი\0", "თებერვალი\0", "მარტი\0", "აპრილი\0", "მაისი\0", "ივნისი\0", "ივლისი\0", "აგვისტო\0", "სექტემბერი\0", "ოქტომბერი\0", "ნოემბერი\0", "დეკემბერი\0" },
        { "ი\0", "თ\0", "მ\0", "ა\0", "მ\0", "ი\0", "ი\0", "ა\0", "ს\0", "ო\0", "ნ\0", "დ\0" },
        { "ორშ\0", "სამ\0", "ოთხ\0", "ხუთ\0", "პარ\0", "შაბ\0", "კვი\0" },
        { "ორშაბათი\0", "სამშაბათი\0", "ოთხშაბათი\0", "ხუთშაბათი\0", "პარასკევი\0", "შაბათი\0", "კვირა\0" },
        { "ო\0", "ს\0", "ო\0", "ხ\0", "პ\0", "შ\0", "კ\0" },
        { "ორშ\0", "სამ\0", "ოთხ\0", "ხუთ\0", "პარ\0", "შაბ\0", "კვი\0" },
        { "ორშაბათი\0", "სამშაბათი\0", "ოთხშაბათი\0", "ხუთშაბათი\0", "პარასკევი\0", "შაბათი\0", "კვირა\0" },
        { "ო\0", "ს\0", "ო\0", "ხ\0", "პ\0", "შ\0", "კ\0" }
    }, // ka_GE
    {
        QLocale::Language::Kabyle, QLocale::Script::LatinScript, QLocale::Country::Algeria,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Taqbaylit\0", "Lezzayer\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "FT\0", "MD\0",
        { "Yen\0", "Fur\0", "Meɣ\0", "Yeb\0", "May\0", "Yun\0", "Yul\0", "Ɣuc\0", "Cte\0", "Tub\0", "Nun\0", "Duǧ\0" },
        { "Yennayer\0", "Fuṛar\0", "Meɣres\0", "Yebrir\0", "Mayyu\0", "Yunyu\0", "Yulyu\0", "Ɣuct\0", "Ctember\0", "Tuber\0", "Nunembeṛ\0", "Duǧembeṛ\0" },
        { "Y\0", "F\0", "M\0", "Y\0", "M\0", "Y\0", "Y\0", "Ɣ\0", "C\0", "T\0", "N\0", "D\0" },
        { "Yen\0", "Fur\0", "Meɣ\0", "Yeb\0", "May\0", "Yun\0", "Yul\0", "Ɣuc\0", "Cte\0", "Tub\0", "Nun\0", "Duǧ\0" },
        { "Yennayer\0", "Fuṛar\0", "Meɣres\0", "Yebrir\0", "Mayyu\0", "Yunyu\0", "Yulyu\0", "Ɣuct\0", "Ctembeṛ\0", "Tubeṛ\0", "Nunembeṛ\0", "Duǧembeṛ\0" },
        { "Y\0", "F\0", "M\0", "Y\0", "M\0", "Y\0", "Y\0", "Ɣ\0", "C\0", "T\0", "N\0", "D\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Arim\0", "Aram\0", "Ahad\0", "Amhad\0", "Sem\0", "Sed\0", "Acer\0" },
        { "S\0", "K\0", "K\0", "S\0", "S\0", "S\0", "Y\0" },
        { "San\0", "Kraḍ\0", "Kuẓ\0", "Sam\0", "Sḍis\0", "Say\0", "Yan\0" },
        { "Sanass\0", "Kraḍass\0", "Kuẓass\0", "Samass\0", "Sḍisass\0", "Sayass\0", "Yanass\0" },
        { "R\0", "R\0", "H\0", "M\0", "S\0", "S\0", "C\0" }
    }, // kab_DZ
    {
        QLocale::Language::Kamba, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kikamba\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Ĩyakwakya\0", "Ĩyawĩoo\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "M\0", "K\0", "K\0", "K\0", "K\0", "T\0", "M\0", "N\0", "K\0", "Ĩ\0", "Ĩ\0", "Ĩ\0" },
        { "Mbe\0", "Kel\0", "Ktũ\0", "Kan\0", "Ktn\0", "Tha\0", "Moo\0", "Nya\0", "Knd\0", "Ĩku\0", "Ĩkm\0", "Ĩkl\0" },
        { "Mwai wa mbee\0", "Mwai wa kelĩ\0", "Mwai wa katatũ\0", "Mwai wa kana\0", "Mwai wa katano\0", "Mwai wa thanthatũ\0", "Mwai wa muonza\0", "Mwai wa nyaanya\0", "Mwai wa kenda\0", "Mwai wa ĩkumi\0", "Mwai wa ĩkumi na ĩmwe\0", "Mwai wa ĩkumi na ilĩ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "W\0", "E\0", "A\0", "A\0", "A\0", "A\0", "Y\0" },
        { "Wkw\0", "Wkl\0", "Wtũ\0", "Wkn\0", "Wtn\0", "Wth\0", "Wky\0" },
        { "Wa kwambĩlĩlya\0", "Wa kelĩ\0", "Wa katatũ\0", "Wa kana\0", "Wa katano\0", "Wa thanthatũ\0", "Wa kyumwa\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // kam_KE
    {
        QLocale::Language::Makonde, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Chimakonde\0", "Tanzania\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Muhi\0", "Chilo\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Mwedi Ntandi\0", "Mwedi wa Pili\0", "Mwedi wa Tatu\0", "Mwedi wa Nchechi\0", "Mwedi wa Nnyano\0", "Mwedi wa Nnyano na Umo\0", "Mwedi wa Nnyano na Mivili\0", "Mwedi wa Nnyano na Mitatu\0", "Mwedi wa Nnyano na Nchechi\0", "Mwedi wa Nnyano na Nnyano\0", "Mwedi wa Nnyano na Nnyano na U\0", "Mwedi wa Nnyano na Nnyano na M\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "3\0", "4\0", "5\0", "6\0", "7\0", "1\0", "2\0" },
        { "Ll3\0", "Ll4\0", "Ll5\0", "Ll6\0", "Ll7\0", "Ll1\0", "Ll2\0" },
        { "Liduva lyatatu\0", "Liduva lyanchechi\0", "Liduva lyannyano\0", "Liduva lyannyano na linji\0", "Liduva lyannyano na mavili\0", "Liduva litandi\0", "Liduva lyapili\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // kde_TZ
    {
        QLocale::Language::Kabuverdianu, QLocale::Script::LatinScript, QLocale::Country::CapeVerde,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "kabuverdianu\0", "Kabu Verdi\0",
        "dd/MM/yyyy\0", "d 'di' MMMM 'di' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "am\0", "pm\0",
        { "Jan\0", "Feb\0", "Mar\0", "Abr\0", "Mai\0", "Jun\0", "Jul\0", "Ago\0", "Set\0", "Otu\0", "Nuv\0", "Diz\0" },
        { "Janeru\0", "Febreru\0", "Marsu\0", "Abril\0", "Maiu\0", "Junhu\0", "Julhu\0", "Agostu\0", "Setenbru\0", "Otubru\0", "Nuvenbru\0", "Dizenbru\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Abr\0", "Mai\0", "Jun\0", "Jul\0", "Ago\0", "Set\0", "Otu\0", "Nuv\0", "Diz\0" },
        { "Janeru\0", "Febreru\0", "Marsu\0", "Abril\0", "Maiu\0", "Junhu\0", "Julhu\0", "Agostu\0", "Setenbru\0", "Otubru\0", "Nuvenbru\0", "Dizenbru\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "sig\0", "ter\0", "kua\0", "kin\0", "ses\0", "sab\0", "dum\0" },
        { "sigunda-fera\0", "tersa-fera\0", "kuarta-fera\0", "kinta-fera\0", "sesta-fera\0", "sábadu\0", "dumingu\0" },
        { "S\0", "T\0", "K\0", "K\0", "S\0", "S\0", "D\0" },
        { "sig\0", "ter\0", "kua\0", "kin\0", "ses\0", "sab\0", "dum\0" },
        { "sigunda-fera\0", "tersa-fera\0", "kuarta-fera\0", "kinta-fera\0", "sesta-fera\0", "sábadu\0", "dumingu\0" },
        { "S\0", "T\0", "K\0", "K\0", "S\0", "S\0", "D\0" }
    }, // kea_CV
    {
        QLocale::Language::Kaingang, QLocale::Script::LatinScript, QLocale::Country::Brazil,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "kanhgág\0", "Mrasir\0",
        "dd/MM/yyyy\0", "d 'nddd' MMMM, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "1Ky.\0", "2Ky.\0", "3Ky.\0", "4Ky.\0", "5Ky.\0", "6Ky.\0", "7Ky.\0", "8Ky.\0", "9Ky.\0", "10Ky.\0", "11Ky.\0", "12Ky.\0" },
        { "1-Kysã\0", "2-Kysã\0", "3-Kysã\0", "4-Kysã\0", "5-Kysã\0", "6-Kysã\0", "7-Kysã\0", "8-Kysã\0", "9-Kysã\0", "10-Kysã\0", "11-Kysã\0", "12-Kysã\0" },
        { "1K\0", "2K\0", "3K\0", "4K\0", "5K\0", "6K\0", "7K\0", "8K\0", "9K\0", "10K\0", "11K\0", "12K\0" },
        { "1Ky.\0", "2Ky.\0", "3Ky.\0", "4Ky.\0", "5Ky.\0", "6Ky.\0", "7Ky.\0", "8Ky.\0", "9Ky.\0", "10Ky.\0", "11Ky.\0", "12Ky.\0" },
        { "1-Kysã\0", "2-Kysã\0", "3-Kysã\0", "4-Kysã\0", "5-Kysã\0", "6-Kysã\0", "7-Kysã\0", "8-Kysã\0", "9-Kysã\0", "10-Kysã\0", "11-Kysã\0", "12-Kysã\0" },
        { "1K\0", "2K\0", "3K\0", "4K\0", "5K\0", "6K\0", "7K\0", "8K\0", "9K\0", "10K\0", "11K\0", "12K\0" },
        { "pir.\0", "rég.\0", "tẽg.\0", "vẽn.\0", "pén.\0", "sav.\0", "num.\0" },
        { "pir-kurã-há\0", "régre-kurã-há\0", "tẽgtũ-kurã-há\0", "vẽnhkãgra-kurã-há\0", "pénkar-kurã-há\0", "savnu\0", "numĩggu\0" },
        { "P.\0", "R.\0", "T.\0", "V.\0", "P.\0", "S.\0", "N.\0" },
        { "pir.\0", "rég.\0", "tẽg.\0", "vẽn.\0", "pén.\0", "sav.\0", "num.\0" },
        { "pir-kurã-há\0", "régre-kurã-há\0", "tẽgtũ-kurã-há\0", "vẽnhkãgra-kurã-há\0", "pénkar-kurã-há\0", "savnu\0", "numĩggu\0" },
        { "P.\0", "R.\0", "T.\0", "V.\0", "P.\0", "S.\0", "N.\0" }
    }, // kgp_BR
    {
        QLocale::Language::KoyraChiini, QLocale::Script::LatinScript, QLocale::Country::Mali,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 160, 59, 37, 45, 43, 69, 48,
        "Koyra ciini\0", "Maali\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Adduha\0", "Aluula\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "Ž\0", "F\0", "M\0", "A\0", "M\0", "Ž\0", "Ž\0", "U\0", "S\0", "O\0", "N\0", "D\0" },
        { "Žan\0", "Fee\0", "Mar\0", "Awi\0", "Me\0", "Žuw\0", "Žuy\0", "Ut\0", "Sek\0", "Okt\0", "Noo\0", "Dee\0" },
        { "Žanwiye\0", "Feewiriye\0", "Marsi\0", "Awiril\0", "Me\0", "Žuweŋ\0", "Žuyye\0", "Ut\0", "Sektanbur\0", "Oktoobur\0", "Noowanbur\0", "Deesanbur\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "T\0", "T\0", "L\0", "L\0", "L\0", "S\0", "H\0" },
        { "Ati\0", "Ata\0", "Ala\0", "Alm\0", "Alj\0", "Ass\0", "Alh\0" },
        { "Atini\0", "Atalata\0", "Alarba\0", "Alhamiisa\0", "Aljuma\0", "Assabdu\0", "Alhadi\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // khq_ML
    {
        QLocale::Language::Kikuyu, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Gikuyu\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Kiroko\0", "Hwaĩ-inĩ\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "K\0", "G\0", "K\0", "G\0", "G\0", "M\0", "K\0", "K\0", "I\0", "I\0", "D\0" },
        { "JEN\0", "WKR\0", "WGT\0", "WKN\0", "WTN\0", "WTD\0", "WMJ\0", "WNN\0", "WKD\0", "WIK\0", "WMW\0", "DIT\0" },
        { "Njenuarĩ\0", "Mwere wa kerĩ\0", "Mwere wa gatatũ\0", "Mwere wa kana\0", "Mwere wa gatano\0", "Mwere wa gatandatũ\0", "Mwere wa mũgwanja\0", "Mwere wa kanana\0", "Mwere wa kenda\0", "Mwere wa ikũmi\0", "Mwere wa ikũmi na ũmwe\0", "Ndithemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "N\0", "N\0", "N\0", "A\0", "N\0", "N\0", "K\0" },
        { "NTT\0", "NMN\0", "NMT\0", "ART\0", "NMA\0", "NMM\0", "KMA\0" },
        { "Njumatatũ\0", "Njumaine\0", "Njumatana\0", "Aramithi\0", "Njumaa\0", "Njumamothi\0", "Kiumia\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ki_KE
    {
        QLocale::Language::Kazakh, QLocale::Script::AnyScript, QLocale::Country::Kazakhstan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "қазақ тілі\0", "Қазақстан\0",
        "dd.MM.yyyy\0", "yyyy 'ж'. d MMMM\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "қаң.\0", "ақп.\0", "нау.\0", "сәу.\0", "мам.\0", "мау.\0", "шіл.\0", "там.\0", "қыр.\0", "қаз.\0", "қар.\0", "жел.\0" },
        { "Қаңтар\0", "Ақпан\0", "Наурыз\0", "Сәуір\0", "Мамыр\0", "Маусым\0", "Шілде\0", "Тамыз\0", "Қыркүйек\0", "Қазан\0", "Қараша\0", "Желтоқсан\0" },
        { "Қ\0", "А\0", "Н\0", "С\0", "М\0", "М\0", "Ш\0", "Т\0", "Қ\0", "Қ\0", "Қ\0", "Ж\0" },
        { "қаң.\0", "ақп.\0", "нау.\0", "сәу.\0", "мам.\0", "мау.\0", "шіл.\0", "там.\0", "қыр.\0", "қаз.\0", "қар.\0", "жел.\0" },
        { "қаңтар\0", "ақпан\0", "наурыз\0", "сәуір\0", "мамыр\0", "маусым\0", "шілде\0", "тамыз\0", "қыркүйек\0", "қазан\0", "қараша\0", "желтоқсан\0" },
        { "Қ\0", "А\0", "Н\0", "С\0", "М\0", "М\0", "Ш\0", "Т\0", "Қ\0", "Қ\0", "Қ\0", "Ж\0" },
        { "дс\0", "сс\0", "ср\0", "бс\0", "жм\0", "сб\0", "жс\0" },
        { "дүйсенбі\0", "сейсенбі\0", "сәрсенбі\0", "бейсенбі\0", "жұма\0", "сенбі\0", "жексенбі\0" },
        { "Д\0", "С\0", "С\0", "Б\0", "Ж\0", "С\0", "Ж\0" },
        { "дс\0", "сс\0", "ср\0", "бс\0", "жм\0", "сб\0", "жс\0" },
        { "дүйсенбі\0", "сейсенбі\0", "сәрсенбі\0", "бейсенбі\0", "жұма\0", "сенбі\0", "жексенбі\0" },
        { "Д\0", "С\0", "С\0", "Б\0", "Ж\0", "С\0", "Ж\0" }
    }, // kk_KZ
    {
        QLocale::Language::Kako, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "kakɔ\0", "Kamɛrun\0",
        "dd/MM yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "pamba\0", "wanja\0", "mbiyɔ mɛndoŋgɔ\0", "Nyɔlɔmbɔŋgɔ\0", "Mɔnɔ ŋgbanja\0", "Nyaŋgwɛ ŋgbanja\0", "kuŋgwɛ\0", "fɛ\0", "njapi\0", "nyukul\0", "M11\0", "ɓulɓusɛ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "pamba\0", "wanja\0", "mbiyɔ mɛndoŋgɔ\0", "Nyɔlɔmbɔŋgɔ\0", "Mɔnɔ ŋgbanja\0", "Nyaŋgwɛ ŋgbanja\0", "kuŋgwɛ\0", "fɛ\0", "njapi\0", "nyukul\0", "M11\0", "ɓulɓusɛ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "lundi\0", "mardi\0", "mɛrkɛrɛdi\0", "yedi\0", "vaŋdɛrɛdi\0", "mɔnɔ sɔndi\0", "sɔndi\0" },
        { "lundi\0", "mardi\0", "mɛrkɛrɛdi\0", "yedi\0", "vaŋdɛrɛdi\0", "mɔnɔ sɔndi\0", "sɔndi\0" },
        { "lu\0", "ma\0", "mɛ\0", "ye\0", "va\0", "ms\0", "so\0" },
        { "lundi\0", "mardi\0", "mɛrkɛrɛdi\0", "yedi\0", "vaŋdɛrɛdi\0", "mɔnɔ sɔndi\0", "sɔndi\0" },
        { "lundi\0", "mardi\0", "mɛrkɛrɛdi\0", "yedi\0", "vaŋdɛrɛdi\0", "mɔnɔ sɔndi\0", "sɔndi\0" },
        { "lu\0", "ma\0", "mɛ\0", "ye\0", "va\0", "ms\0", "so\0" }
    }, // kkj_CM
    {
        QLocale::Language::Kalaallisut, QLocale::Script::LatinScript, QLocale::Country::Greenland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 8722, 43, 69, 48,
        "kalaallisut\0", "Kalaallit Nunaat\0",
        "yyyy-MM-dd\0", "dd MMMM yyyy\0", "HH.mm\0", "HH.mm.ss Z\0",
        "ulloqeqqata-tungaa\0", "ulloqeqqata-kingorna\0",
        { "jan\0", "febr\0", "mar\0", "apr\0", "maj\0", "jun\0", "jul\0", "aug\0", "sept\0", "okt\0", "nov\0", "dec\0" },
        { "januaari\0", "februaari\0", "marsi\0", "apriili\0", "maaji\0", "juuni\0", "juuli\0", "aggusti\0", "septembari\0", "oktobari\0", "novembari\0", "decembari\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan\0", "febr\0", "mar\0", "apr\0", "maj\0", "jun\0", "jul\0", "aug\0", "sept\0", "okt\0", "nov\0", "dec\0" },
        { "januaarip\0", "februaarip\0", "marsip\0", "apriilip\0", "maajip\0", "juunip\0", "juulip\0", "aggustip\0", "septembarip\0", "oktobarip\0", "novembarip\0", "decembarip\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "ataasinngorneq\0", "marlunngorneq\0", "pingasunngorneq\0", "sisamanngorneq\0", "tallimanngorneq\0", "arfininngorneq\0", "sapaat\0" },
        { "A\0", "M\0", "P\0", "S\0", "T\0", "A\0", "S\0" },
        { "ata\0", "mar\0", "pin\0", "sis\0", "tal\0", "arf\0", "sap\0" },
        { "ataasinngorneq\0", "marlunngorneq\0", "pingasunngorneq\0", "sisamanngorneq\0", "tallimanngorneq\0", "arfininngorneq\0", "sapaat\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // kl_GL
    {
        QLocale::Language::Kalenjin, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kalenjin\0", "Emetab Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "karoon\0", "kooskoliny\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "M\0", "N\0", "T\0", "I\0", "M\0", "P\0", "N\0", "R\0", "B\0", "E\0", "K\0", "K\0" },
        { "Mul\0", "Ngat\0", "Taa\0", "Iwo\0", "Mam\0", "Paa\0", "Nge\0", "Roo\0", "Bur\0", "Epe\0", "Kpt\0", "Kpa\0" },
        { "Mulgul\0", "Ng’atyaato\0", "Kiptaamo\0", "Iwootkuut\0", "Mamuut\0", "Paagi\0", "Ng’eiyeet\0", "Rooptui\0", "Bureet\0", "Epeeso\0", "Kipsuunde ne taai\0", "Kipsuunde nebo aeng’\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "T\0", "O\0", "S\0", "A\0", "M\0", "L\0", "T\0" },
        { "Kot\0", "Koo\0", "Kos\0", "Koa\0", "Kom\0", "Kol\0", "Kts\0" },
        { "Kotaai\0", "Koaeng’\0", "Kosomok\0", "Koang’wan\0", "Komuut\0", "Kolo\0", "Kotisap\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // kln_KE
    {
        QLocale::Language::Khmer, QLocale::Script::KhmerScript, QLocale::Country::Cambodia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "ខ្មែរ\0", "កម្ពុជា\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "មករា\0", "កុម្ភៈ\0", "មីនា\0", "មេសា\0", "ឧសភា\0", "មិថុនា\0", "កក្កដា\0", "សីហា\0", "កញ្ញា\0", "តុលា\0", "វិច្ឆិកា\0", "ធ្នូ\0" },
        { "មករា\0", "កុម្ភៈ\0", "មីនា\0", "មេសា\0", "ឧសភា\0", "មិថុនា\0", "កក្កដា\0", "សីហា\0", "កញ្ញា\0", "តុលា\0", "វិច្ឆិកា\0", "ធ្នូ\0" },
        { "ម\0", "ក\0", "ម\0", "ម\0", "ឧ\0", "ម\0", "ក\0", "ស\0", "ក\0", "ត\0", "វ\0", "ធ\0" },
        { "មករា\0", "កុម្ភៈ\0", "មីនា\0", "មេសា\0", "ឧសភា\0", "មិថុនា\0", "កក្កដា\0", "សីហា\0", "កញ្ញា\0", "តុលា\0", "វិច្ឆិកា\0", "ធ្នូ\0" },
        { "មករា\0", "កុម្ភៈ\0", "មីនា\0", "មេសា\0", "ឧសភា\0", "មិថុនា\0", "កក្កដា\0", "សីហា\0", "កញ្ញា\0", "តុលា\0", "វិច្ឆិកា\0", "ធ្នូ\0" },
        { "ម\0", "ក\0", "ម\0", "ម\0", "ឧ\0", "ម\0", "ក\0", "ស\0", "ក\0", "ត\0", "វ\0", "ធ\0" },
        { "ចន្ទ\0", "អង្គារ\0", "ពុធ\0", "ព្រហ\0", "សុក្រ\0", "សៅរ៍\0", "អាទិត្យ\0" },
        { "ចន្ទ\0", "អង្គារ\0", "ពុធ\0", "ព្រហស្បតិ៍\0", "សុក្រ\0", "សៅរ៍\0", "អាទិត្យ\0" },
        { "ច\0", "អ\0", "ព\0", "ព\0", "ស\0", "ស\0", "អ\0" },
        { "ចន្ទ\0", "អង្គារ\0", "ពុធ\0", "ព្រហ\0", "សុក្រ\0", "សៅរ៍\0", "អាទិត្យ\0" },
        { "ច័ន្ទ\0", "អង្គារ\0", "ពុធ\0", "ព្រហស្បតិ៍\0", "សុក្រ\0", "សៅរ៍\0", "អាទិត្យ\0" },
        { "ច\0", "អ\0", "ព\0", "ព\0", "ស\0", "ស\0", "អ\0" }
    }, // km_KH
    {
        QLocale::Language::Kannada, QLocale::Script::KannadaScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ಕನ್ನಡ\0", "ಭಾರತ\0",
        "d/M/yyyy\0", "MMMM d, yyyy\0", "hh:mm AP\0", "hh:mm:ss AP Z\0",
        "ಪೂರ್ವಾಹ್ನ\0", "ಅಪರಾಹ್ನ\0",
        { "ಜನ\0", "ಫೆಬ್ರ\0", "ಮಾರ್ಚ್\0", "ಏಪ್ರಿ\0", "ಮೇ\0", "ಜೂನ್\0", "ಜುಲೈ\0", "ಆಗ\0", "ಸೆಪ್ಟೆಂ\0", "ಅಕ್ಟೋ\0", "ನವೆಂ\0", "ಡಿಸೆಂ\0" },
        { "ಜನವರಿ\0", "ಫೆಬ್ರವರಿ\0", "ಮಾರ್ಚ್\0", "ಏಪ್ರಿಲ್\0", "ಮೇ\0", "ಜೂನ್\0", "ಜುಲೈ\0", "ಆಗಸ್ಟ್\0", "ಸೆಪ್ಟೆಂಬರ್\0", "ಅಕ್ಟೋಬರ್\0", "ನವೆಂಬರ್\0", "ಡಿಸೆಂಬರ್\0" },
        { "ಜ\0", "ಫೆ\0", "ಮಾ\0", "ಏ\0", "ಮೇ\0", "ಜೂ\0", "ಜು\0", "ಆ\0", "ಸೆ\0", "ಅ\0", "ನ\0", "ಡಿ\0" },
        { "ಜನವರಿ\0", "ಫೆಬ್ರವರಿ\0", "ಮಾರ್ಚ್\0", "ಏಪ್ರಿ\0", "ಮೇ\0", "ಜೂನ್\0", "ಜುಲೈ\0", "ಆಗ\0", "ಸೆಪ್ಟೆಂ\0", "ಅಕ್ಟೋ\0", "ನವೆಂ\0", "ಡಿಸೆಂ\0" },
        { "ಜನವರಿ\0", "ಫೆಬ್ರವರಿ\0", "ಮಾರ್ಚ್\0", "ಏಪ್ರಿಲ್\0", "ಮೇ\0", "ಜೂನ್\0", "ಜುಲೈ\0", "ಆಗಸ್ಟ್\0", "ಸೆಪ್ಟೆಂಬರ್\0", "ಅಕ್ಟೋಬರ್\0", "ನವೆಂಬರ್\0", "ಡಿಸೆಂಬರ್\0" },
        { "ಜ\0", "ಫೆ\0", "ಮಾ\0", "ಏ\0", "ಮೇ\0", "ಜೂ\0", "ಜು\0", "ಆ\0", "ಸೆ\0", "ಅ\0", "ನ\0", "ಡಿ\0" },
        { "ಸೋಮ\0", "ಮಂಗಳ\0", "ಬುಧ\0", "ಗುರು\0", "ಶುಕ್ರ\0", "ಶನಿ\0", "ಭಾನು\0" },
        { "ಸೋಮವಾರ\0", "ಮಂಗಳವಾರ\0", "ಬುಧವಾರ\0", "ಗುರುವಾರ\0", "ಶುಕ್ರವಾರ\0", "ಶನಿವಾರ\0", "ಭಾನುವಾರ\0" },
        { "ಸೋ\0", "ಮಂ\0", "ಬು\0", "ಗು\0", "ಶು\0", "ಶ\0", "ಭಾ\0" },
        { "ಸೋಮ\0", "ಮಂಗಳ\0", "ಬುಧ\0", "ಗುರು\0", "ಶುಕ್ರ\0", "ಶನಿ\0", "ಭಾನು\0" },
        { "ಸೋಮವಾರ\0", "ಮಂಗಳವಾರ\0", "ಬುಧವಾರ\0", "ಗುರುವಾರ\0", "ಶುಕ್ರವಾರ\0", "ಶನಿವಾರ\0", "ಭಾನುವಾರ\0" },
        { "ಸೋ\0", "ಮಂ\0", "ಬು\0", "ಗು\0", "ಶು\0", "ಶ\0", "ಭಾ\0" }
    }, // kn_IN
    {
        QLocale::Language::Korean, QLocale::Script::KoreanScript, QLocale::Country::NorthKorea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "한국어\0", "조선민주주의인민공화국\0",
        "yyyy. M. d.\0", "yyyy년 M월 d일\0", "AP h:mm\0", "AP h시 m분 s초 Z\0",
        "오전\0", "오후\0",
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "월\0", "화\0", "수\0", "목\0", "금\0", "토\0", "일\0" },
        { "월요일\0", "화요일\0", "수요일\0", "목요일\0", "금요일\0", "토요일\0", "일요일\0" },
        { "월\0", "화\0", "수\0", "목\0", "금\0", "토\0", "일\0" },
        { "월\0", "화\0", "수\0", "목\0", "금\0", "토\0", "일\0" },
        { "월요일\0", "화요일\0", "수요일\0", "목요일\0", "금요일\0", "토요일\0", "일요일\0" },
        { "월\0", "화\0", "수\0", "목\0", "금\0", "토\0", "일\0" }
    }, // ko_KP
    {
        QLocale::Language::Korean, QLocale::Script::KoreanScript, QLocale::Country::SouthKorea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "한국어\0", "대한민국\0",
        "yyyy. M. d.\0", "yyyy년 M월 d일\0", "AP h:mm\0", "AP h시 m분 s초 Z\0",
        "오전\0", "오후\0",
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "1월\0", "2월\0", "3월\0", "4월\0", "5월\0", "6월\0", "7월\0", "8월\0", "9월\0", "10월\0", "11월\0", "12월\0" },
        { "월\0", "화\0", "수\0", "목\0", "금\0", "토\0", "일\0" },
        { "월요일\0", "화요일\0", "수요일\0", "목요일\0", "금요일\0", "토요일\0", "일요일\0" },
        { "월\0", "화\0", "수\0", "목\0", "금\0", "토\0", "일\0" },
        { "월\0", "화\0", "수\0", "목\0", "금\0", "토\0", "일\0" },
        { "월요일\0", "화요일\0", "수요일\0", "목요일\0", "금요일\0", "토요일\0", "일요일\0" },
        { "월\0", "화\0", "수\0", "목\0", "금\0", "토\0", "일\0" }
    }, // ko_KR
    {
        QLocale::Language::Konkani, QLocale::Script::DevanagariScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "कोंकणी\0", "भारत\0",
        "d-M-yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "जाने\0", "फेब्रु\0", "मार्च\0", "एप्री\0", "मे\0", "जून\0", "जुल\0", "ऑग\0", "सप्टें\0", "ऑक्टो\0", "नो\0", "डिसे\0" },
        { "जानेवारी\0", "फेब्रुवारी\0", "मार्च\0", "एप्रील\0", "मे\0", "जून\0", "जुलय\0", "ऑगस्ट\0", "सप्टेंबर\0", "ऑक्टोबर\0", "नोव्हेंबर\0", "डिसेंबर\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "जानेवारी\0", "फेब्रुवारी\0", "मार्च\0", "एप्रील\0", "मे\0", "जून\0", "जुलय\0", "ऑगस्ट\0", "सप्टेंबर\0", "ऑक्टोबर\0", "नोव्हेंबर\0", "डिसेंबर\0" },
        { "जानेवारी\0", "फेब्रुवारी\0", "मार्च\0", "एप्रील\0", "मे\0", "जून\0", "जुलय\0", "ऑगस्ट\0", "सप्टेंबर\0", "ऑक्टोबर\0", "नोव्हेंबर\0", "डिसेंबर\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "सोमार\0", "मंगळार\0", "बुधवार\0", "बिरेस्तार\0", "शुक्रार\0", "शेनवार\0", "आयतार\0" },
        { "सोमार\0", "मंगळार\0", "बुधवार\0", "बिरेस्तार\0", "शुक्रार\0", "शेनवार\0", "आयतार\0" },
        { "सो\0", "मं\0", "बु\0", "ब\0", "शु\0", "शे\0", "आ\0" },
        { "सोमार\0", "मंगळार\0", "बुधवार\0", "बिरेस्तार\0", "शुक्रार\0", "शेनवार\0", "आयतार\0" },
        { "सोमार\0", "मंगळार\0", "बुधवार\0", "बिरेस्तार\0", "शुक्रार\0", "शेनवार\0", "आयतार\0" },
        { "सो\0", "मं\0", "बु\0", "बि\0", "शु\0", "शे\0", "आ\0" }
    }, // kok_IN
    {
        QLocale::Language::Kashmiri, QLocale::Script::ArabicScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        1643, 1644, 59, 37, 45, 43, 69, 1776,
        "کٲشُر\0", "ہِندوستان\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "جنؤری\0", "فرؤری\0", "مارٕچ\0", "اپریل\0", "مئی\0", "جوٗن\0", "جوٗلایی\0", "اگست\0", "ستمبر\0", "اکتوٗبر\0", "نومبر\0", "دسمبر\0" },
        { "جنؤری\0", "فرؤری\0", "مارٕچ\0", "اپریل\0", "مئی\0", "جوٗن\0", "جوٗلایی\0", "اگست\0", "ستمبر\0", "اکتوٗبر\0", "نومبر\0", "دسمبر\0" },
        { "ج\0", "ف\0", "م\0", "ا\0", "م\0", "ج\0", "ج\0", "ا\0", "س\0", "س\0", "ا\0", "ن\0" },
        { "جنؤری\0", "فرؤری\0", "مارٕچ\0", "اپریل\0", "مئی\0", "جوٗن\0", "جوٗلایی\0", "اگست\0", "ستمبر\0", "اکتوٗبر\0", "نومبر\0", "دسمبر\0" },
        { "جنؤری\0", "فرؤری\0", "مارٕچ\0", "اپریل\0", "مئی\0", "جوٗن\0", "جوٗلایی\0", "اگست\0", "ستمبر\0", "اکتوٗبر\0", "نومبر\0", "دسمبر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "ژ\0", "ب\0", "ب\0", "ب\0", "ج\0", "ب\0", "ا\0" },
        { "ژٔندٕروار\0", "بۆموار\0", "بودوار\0", "برؠسوار\0", "جُمہ\0", "بٹوار\0", "آتھوار\0" },
        { "ژٔندرٕروار\0", "بۆموار\0", "بودوار\0", "برؠسوار\0", "جُمہ\0", "بٹوار\0", "اَتھوار\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ks_Arab_IN
    {
        QLocale::Language::Kashmiri, QLocale::Script::DevanagariScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        1643, 1644, 59, 37, 45, 43, 69, 1776,
        "کٲشُر\0", "ہِندوستان\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "جنؤری\0", "فرؤری\0", "مارٕچ\0", "اپریل\0", "مئی\0", "جوٗن\0", "جوٗلایی\0", "اگست\0", "ستمبر\0", "اکتوٗبر\0", "نومبر\0", "دسمبر\0" },
        { "جنؤری\0", "فرؤری\0", "مارٕچ\0", "اپریل\0", "مئی\0", "جوٗن\0", "جوٗلایی\0", "اگست\0", "ستمبر\0", "اکتوٗبر\0", "نومبر\0", "دسمبر\0" },
        { "ج\0", "ف\0", "م\0", "ا\0", "م\0", "ج\0", "ج\0", "ا\0", "س\0", "س\0", "ا\0", "ن\0" },
        { "جنؤری\0", "فرؤری\0", "مارٕچ\0", "اپریل\0", "مئی\0", "جوٗن\0", "جوٗلایی\0", "اگست\0", "ستمبر\0", "اکتوٗبر\0", "نومبر\0", "دسمبر\0" },
        { "جنؤری\0", "فرؤری\0", "مارٕچ\0", "اپریل\0", "مئی\0", "جوٗن\0", "جوٗلایی\0", "اگست\0", "ستمبر\0", "اکتوٗبر\0", "نومبر\0", "دسمبر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "ژ\0", "ب\0", "ب\0", "ب\0", "ج\0", "ب\0", "ا\0" },
        { "ژٔندٕروار\0", "بۆموار\0", "بودوار\0", "برؠسوار\0", "جُمہ\0", "بٹوار\0", "آتھوار\0" },
        { "ژٔندرٕروار\0", "بۆموار\0", "بودوار\0", "برؠسوار\0", "جُمہ\0", "بٹوار\0", "اَتھوار\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ks_Deva_IN
    {
        QLocale::Language::Shambala, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kishambaa\0", "Tanzania\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "makeo\0", "nyiaghuo\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januali\0", "Febluali\0", "Machi\0", "Aplili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "3\0", "4\0", "5\0", "A\0", "I\0", "1\0", "2\0" },
        { "Jtt\0", "Jmn\0", "Jtn\0", "Alh\0", "Iju\0", "Jmo\0", "Jpi\0" },
        { "Jumaatatu\0", "Jumaane\0", "Jumaatano\0", "Alhamisi\0", "Ijumaa\0", "Jumaamosi\0", "Jumaapii\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ksb_TZ
    {
        QLocale::Language::Bafia, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "rikpa\0", "kamɛrún\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "sárúwá\0", "cɛɛ́nko\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ŋ1\0", "ŋ2\0", "ŋ3\0", "ŋ4\0", "ŋ5\0", "ŋ6\0", "ŋ7\0", "ŋ8\0", "ŋ9\0", "ŋ10\0", "ŋ11\0", "ŋ12\0" },
        { "ŋwíí a ntɔ́ntɔ\0", "ŋwíí akǝ bɛ́ɛ\0", "ŋwíí akǝ ráá\0", "ŋwíí akǝ nin\0", "ŋwíí akǝ táan\0", "ŋwíí akǝ táafɔk\0", "ŋwíí akǝ táabɛɛ\0", "ŋwíí akǝ táaraa\0", "ŋwíí akǝ táanin\0", "ŋwíí akǝ ntɛk\0", "ŋwíí akǝ ntɛk di bɔ́k\0", "ŋwíí akǝ ntɛk di bɛ́ɛ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "l\0", "m\0", "m\0", "j\0", "j\0", "s\0", "s\0" },
        { "lǝn\0", "maa\0", "mɛk\0", "jǝǝ\0", "júm\0", "sam\0", "sɔ́n\0" },
        { "lǝndí\0", "maadí\0", "mɛkrɛdí\0", "jǝǝdí\0", "júmbá\0", "samdí\0", "sɔ́ndǝ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ksf_CM
    {
        QLocale::Language::Colognian, QLocale::Script::LatinScript, QLocale::Country::Germany,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "Kölsch\0", "Doütschland\0",
        "d. M. yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Vörmeddaach\0", "Nommendaach\0",
        { "Jan.\0", "Fäb.\0", "Mäz.\0", "Apr.\0", "Mai\0", "Jun.\0", "Jul.\0", "Ouj.\0", "Säp.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Fäb\0", "Mäz\0", "Apr\0", "Mai\0", "Jun\0", "Jul\0", "Ouj\0", "Säp\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Jannewa\0", "Fäbrowa\0", "Määz\0", "Aprell\0", "Mai\0", "Juuni\0", "Juuli\0", "Oujoß\0", "Septämber\0", "Oktohber\0", "Novämber\0", "Dezämber\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Mo.\0", "Di.\0", "Me.\0", "Du.\0", "Fr.\0", "Sa.\0", "Su.\0" },
        { "Mohndaach\0", "Dinnsdaach\0", "Metwoch\0", "Dunnersdaach\0", "Friidaach\0", "Samsdaach\0", "Sunndaach\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ksh_DE
    {
        QLocale::Language::Kurdish, QLocale::Script::AnyScript, QLocale::Country::Turkey,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "kurdî\0", "Tirkiye\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "BN\0", "PN\0",
        { "rêb\0", "reş\0", "ada\0", "avr\0", "gul\0", "pûş\0", "tîr\0", "gel\0", "rez\0", "kew\0", "ser\0", "ber\0" },
        { "rêbendan\0", "reşemî\0", "adar\0", "avrêl\0", "gulan\0", "pûşper\0", "tîrmeh\0", "gelawêj\0", "rezber\0", "kewçêr\0", "sermawez\0", "berfanbar\0" },
        { "R\0", "R\0", "A\0", "A\0", "G\0", "P\0", "T\0", "G\0", "R\0", "K\0", "S\0", "B\0" },
        { "rêb\0", "reş\0", "ada\0", "avr\0", "gul\0", "pûş\0", "tîr\0", "gel\0", "rez\0", "kew\0", "ser\0", "ber\0" },
        { "rêbendanê\0", "reşemiyê\0", "adarê\0", "avrêlê\0", "gulanê\0", "pûşperê\0", "tîrmehê\0", "gelawêjê\0", "rezberê\0", "kewçêrê\0", "sermawezê\0", "berfanbarê\0" },
        { "R\0", "R\0", "A\0", "A\0", "G\0", "P\0", "T\0", "G\0", "R\0", "K\0", "S\0", "B\0" },
        { "dş\0", "sş\0", "çş\0", "pş\0", "în\0", "ş\0", "yş\0" },
        { "duşem\0", "sêşem\0", "çarşem\0", "pêncşem\0", "în\0", "şemî\0", "yekşem\0" },
        { "D\0", "S\0", "Ç\0", "P\0", "Î\0", "Ş\0", "Y\0" },
        { "dş\0", "sş\0", "çş\0", "pş\0", "în\0", "ş\0", "yş\0" },
        { "duşem\0", "sêşem\0", "çarşem\0", "pêncşem\0", "în\0", "şemî\0", "yekşem\0" },
        { "D\0", "S\0", "Ç\0", "P\0", "Î\0", "Ş\0", "Y\0" }
    }, // ku_TR
    {
        QLocale::Language::Cornish, QLocale::Script::LatinScript, QLocale::Country::UnitedKingdom,
        Qt::Sunday, Qt::Friday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "kernewek\0", "Rywvaneth Unys\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Gen\0", "Hwe\0", "Meu\0", "Ebr\0", "Me\0", "Met\0", "Gor\0", "Est\0", "Gwn\0", "Hed\0", "Du\0", "Kev\0" },
        { "mis Genver\0", "mis Hwevrer\0", "mis Meurth\0", "mis Ebrel\0", "mis Me\0", "mis Metheven\0", "mis Gortheren\0", "mis Est\0", "mis Gwynngala\0", "mis Hedra\0", "mis Du\0", "mis Kevardhu\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Lun\0", "Mth\0", "Mhr\0", "Yow\0", "Gwe\0", "Sad\0", "Sul\0" },
        { "dy Lun\0", "dy Meurth\0", "dy Merher\0", "dy Yow\0", "dy Gwener\0", "dy Sadorn\0", "dy Sul\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // kw_GB
    {
        QLocale::Language::Kyrgyz, QLocale::Script::AnyScript, QLocale::Country::Kyrgyzstan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "кыргызча\0", "Кыргызстан\0",
        "d/M/yyyy\0", "yyyy-'ж'., d-MMMM\0", "HH:mm\0", "HH:mm:ss Z\0",
        "таңкы\0", "түштөн кийинки\0",
        { "Янв\0", "Фев\0", "Мар\0", "Апр\0", "Май\0", "Июн\0", "Июл\0", "Авг\0", "Сен\0", "Окт\0", "Ноя\0", "Дек\0" },
        { "Январь\0", "Февраль\0", "Март\0", "Апрель\0", "Май\0", "Июнь\0", "Июль\0", "Август\0", "Сентябрь\0", "Октябрь\0", "Ноябрь\0", "Декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "янв.\0", "фев.\0", "мар.\0", "апр.\0", "май\0", "июн.\0", "июл.\0", "авг.\0", "сен.\0", "окт.\0", "ноя.\0", "дек.\0" },
        { "январь\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "дүй.\0", "шейш.\0", "шарш.\0", "бейш.\0", "жума\0", "ишм.\0", "жек.\0" },
        { "дүйшөмбү\0", "шейшемби\0", "шаршемби\0", "бейшемби\0", "жума\0", "ишемби\0", "жекшемби\0" },
        { "Д\0", "Ш\0", "Ш\0", "Б\0", "Ж\0", "И\0", "Ж\0" },
        { "дүй.\0", "шейш.\0", "шарш.\0", "бейш.\0", "жума\0", "ишм.\0", "жек.\0" },
        { "дүйшөмбү\0", "шейшемби\0", "шаршемби\0", "бейшемби\0", "жума\0", "ишемби\0", "жекшемби\0" },
        { "Д\0", "Ш\0", "Ш\0", "Б\0", "Ж\0", "И\0", "Ж\0" }
    }, // ky_KG
    {
        QLocale::Language::Langi, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kɨlaangi\0", "Taansanía\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "TOO\0", "MUU\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "F\0", "N\0", "K\0", "I\0", "I\0", "I\0", "M\0", "V\0", "S\0", "I\0", "S\0", "S\0" },
        { "Fúngatɨ\0", "Naanɨ\0", "Keenda\0", "Ikúmi\0", "Inyambala\0", "Idwaata\0", "Mʉʉnchɨ\0", "Vɨɨrɨ\0", "Saatʉ\0", "Inyi\0", "Saano\0", "Sasatʉ\0" },
        { "Kʉfúngatɨ\0", "Kʉnaanɨ\0", "Kʉkeenda\0", "Kwiikumi\0", "Kwiinyambála\0", "Kwiidwaata\0", "Kʉmʉʉnchɨ\0", "Kʉvɨɨrɨ\0", "Kʉsaatʉ\0", "Kwiinyi\0", "Kʉsaano\0", "Kʉsasatʉ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "T\0", "E\0", "O\0", "A\0", "I\0", "M\0", "P\0" },
        { "Táatu\0", "Íne\0", "Táano\0", "Alh\0", "Ijm\0", "Móosi\0", "Píili\0" },
        { "Jumatátu\0", "Jumaíne\0", "Jumatáano\0", "Alamíisi\0", "Ijumáa\0", "Jumamóosi\0", "Jumapíiri\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // lag_TZ
    {
        QLocale::Language::Luxembourgish, QLocale::Script::LatinScript, QLocale::Country::Luxembourg,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Lëtzebuergesch\0", "Lëtzebuerg\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "moies\0", "nomëttes\0",
        { "Jan\0", "Feb\0", "Mäe\0", "Abr\0", "Mee\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Okt\0", "Nov\0", "Dez\0" },
        { "Januar\0", "Februar\0", "Mäerz\0", "Abrëll\0", "Mee\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan.\0", "Feb.\0", "Mäe.\0", "Abr.\0", "Mee\0", "Juni\0", "Juli\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Januar\0", "Februar\0", "Mäerz\0", "Abrëll\0", "Mee\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktober\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Méi\0", "Dën\0", "Mët\0", "Don\0", "Fre\0", "Sam\0", "Son\0" },
        { "Méindeg\0", "Dënschdeg\0", "Mëttwoch\0", "Donneschdeg\0", "Freideg\0", "Samschdeg\0", "Sonndeg\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Méi.\0", "Dën.\0", "Mët.\0", "Don.\0", "Fre.\0", "Sam.\0", "Son.\0" },
        { "Méindeg\0", "Dënschdeg\0", "Mëttwoch\0", "Donneschdeg\0", "Freideg\0", "Samschdeg\0", "Sonndeg\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" }
    }, // lb_LU
    {
        QLocale::Language::Ganda, QLocale::Script::LatinScript, QLocale::Country::Uganda,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Luganda\0", "Yuganda\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apu\0", "Maa\0", "Juu\0", "Jul\0", "Agu\0", "Seb\0", "Oki\0", "Nov\0", "Des\0" },
        { "Janwaliyo\0", "Febwaliyo\0", "Marisi\0", "Apuli\0", "Maayi\0", "Juuni\0", "Julaayi\0", "Agusito\0", "Sebuttemba\0", "Okitobba\0", "Novemba\0", "Desemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "B\0", "L\0", "L\0", "L\0", "L\0", "L\0", "S\0" },
        { "Bal\0", "Lw2\0", "Lw3\0", "Lw4\0", "Lw5\0", "Lw6\0", "Sab\0" },
        { "Balaza\0", "Lwakubiri\0", "Lwakusatu\0", "Lwakuna\0", "Lwakutaano\0", "Lwamukaaga\0", "Sabbiiti\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // lg_UG
    {
        QLocale::Language::Lakota, QLocale::Script::LatinScript, QLocale::Country::UnitedStates,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Lakȟólʼiyapi\0", "Mílahaŋska Tȟamákȟočhe\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "Wiótheȟika Wí\0", "Thiyóȟeyuŋka Wí\0", "Ištáwičhayazaŋ Wí\0", "Pȟežítȟo Wí\0", "Čhaŋwápetȟo Wí\0", "Wípazukȟa-wašté Wí\0", "Čhaŋpȟásapa Wí\0", "Wasútȟuŋ Wí\0", "Čhaŋwápeǧi Wí\0", "Čhaŋwápe-kasná Wí\0", "Waníyetu Wí\0", "Tȟahékapšuŋ Wí\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Aŋpétuwaŋži\0", "Aŋpétunuŋpa\0", "Aŋpétuyamni\0", "Aŋpétutopa\0", "Aŋpétuzaptaŋ\0", "Owáŋgyužažapi\0", "Aŋpétuwakȟaŋ\0" },
        { "W\0", "N\0", "Y\0", "T\0", "Z\0", "O\0", "A\0" }
    }, // lkt_US
    {
        QLocale::Language::Lingala, QLocale::Script::LatinScript, QLocale::Country::Angola,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "lingála\0", "Angóla\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ntɔ́ngɔ́\0", "mpókwa\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "y\0", "f\0", "m\0", "a\0", "m\0", "y\0", "y\0", "a\0", "s\0", "ɔ\0", "n\0", "d\0" },
        { "yan\0", "fbl\0", "msi\0", "apl\0", "mai\0", "yun\0", "yul\0", "agt\0", "stb\0", "ɔtb\0", "nvb\0", "dsb\0" },
        { "sánzá ya yambo\0", "sánzá ya míbalé\0", "sánzá ya mísáto\0", "sánzá ya mínei\0", "sánzá ya mítáno\0", "sánzá ya motóbá\0", "sánzá ya nsambo\0", "sánzá ya mwambe\0", "sánzá ya libwa\0", "sánzá ya zómi\0", "sánzá ya zómi na mɔ̌kɔ́\0", "sánzá ya zómi na míbalé\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "y\0", "m\0", "m\0", "m\0", "m\0", "p\0", "e\0" },
        { "ybo\0", "mbl\0", "mst\0", "min\0", "mtn\0", "mps\0", "eye\0" },
        { "mokɔlɔ mwa yambo\0", "mokɔlɔ mwa míbalé\0", "mokɔlɔ mwa mísáto\0", "mokɔlɔ ya mínéi\0", "mokɔlɔ ya mítáno\0", "mpɔ́sɔ\0", "eyenga\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ln_AO
    {
        QLocale::Language::Lingala, QLocale::Script::LatinScript, QLocale::Country::CongoKinshasa,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "lingála\0", "Republíki ya Kongó Demokratíki\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ntɔ́ngɔ́\0", "mpókwa\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "y\0", "f\0", "m\0", "a\0", "m\0", "y\0", "y\0", "a\0", "s\0", "ɔ\0", "n\0", "d\0" },
        { "yan\0", "fbl\0", "msi\0", "apl\0", "mai\0", "yun\0", "yul\0", "agt\0", "stb\0", "ɔtb\0", "nvb\0", "dsb\0" },
        { "sánzá ya yambo\0", "sánzá ya míbalé\0", "sánzá ya mísáto\0", "sánzá ya mínei\0", "sánzá ya mítáno\0", "sánzá ya motóbá\0", "sánzá ya nsambo\0", "sánzá ya mwambe\0", "sánzá ya libwa\0", "sánzá ya zómi\0", "sánzá ya zómi na mɔ̌kɔ́\0", "sánzá ya zómi na míbalé\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "y\0", "m\0", "m\0", "m\0", "m\0", "p\0", "e\0" },
        { "ybo\0", "mbl\0", "mst\0", "min\0", "mtn\0", "mps\0", "eye\0" },
        { "mokɔlɔ mwa yambo\0", "mokɔlɔ mwa míbalé\0", "mokɔlɔ mwa mísáto\0", "mokɔlɔ ya mínéi\0", "mokɔlɔ ya mítáno\0", "mpɔ́sɔ\0", "eyenga\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ln_CD
    {
        QLocale::Language::Lingala, QLocale::Script::LatinScript, QLocale::Country::CentralAfricanRepublic,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "lingála\0", "Repibiki ya Afríka ya Káti\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ntɔ́ngɔ́\0", "mpókwa\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "y\0", "f\0", "m\0", "a\0", "m\0", "y\0", "y\0", "a\0", "s\0", "ɔ\0", "n\0", "d\0" },
        { "yan\0", "fbl\0", "msi\0", "apl\0", "mai\0", "yun\0", "yul\0", "agt\0", "stb\0", "ɔtb\0", "nvb\0", "dsb\0" },
        { "sánzá ya yambo\0", "sánzá ya míbalé\0", "sánzá ya mísáto\0", "sánzá ya mínei\0", "sánzá ya mítáno\0", "sánzá ya motóbá\0", "sánzá ya nsambo\0", "sánzá ya mwambe\0", "sánzá ya libwa\0", "sánzá ya zómi\0", "sánzá ya zómi na mɔ̌kɔ́\0", "sánzá ya zómi na míbalé\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "y\0", "m\0", "m\0", "m\0", "m\0", "p\0", "e\0" },
        { "ybo\0", "mbl\0", "mst\0", "min\0", "mtn\0", "mps\0", "eye\0" },
        { "mokɔlɔ mwa yambo\0", "mokɔlɔ mwa míbalé\0", "mokɔlɔ mwa mísáto\0", "mokɔlɔ ya mínéi\0", "mokɔlɔ ya mítáno\0", "mpɔ́sɔ\0", "eyenga\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ln_CF
    {
        QLocale::Language::Lingala, QLocale::Script::LatinScript, QLocale::Country::CongoBrazzaville,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "lingála\0", "Kongo\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ntɔ́ngɔ́\0", "mpókwa\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "y\0", "f\0", "m\0", "a\0", "m\0", "y\0", "y\0", "a\0", "s\0", "ɔ\0", "n\0", "d\0" },
        { "yan\0", "fbl\0", "msi\0", "apl\0", "mai\0", "yun\0", "yul\0", "agt\0", "stb\0", "ɔtb\0", "nvb\0", "dsb\0" },
        { "sánzá ya yambo\0", "sánzá ya míbalé\0", "sánzá ya mísáto\0", "sánzá ya mínei\0", "sánzá ya mítáno\0", "sánzá ya motóbá\0", "sánzá ya nsambo\0", "sánzá ya mwambe\0", "sánzá ya libwa\0", "sánzá ya zómi\0", "sánzá ya zómi na mɔ̌kɔ́\0", "sánzá ya zómi na míbalé\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "y\0", "m\0", "m\0", "m\0", "m\0", "p\0", "e\0" },
        { "ybo\0", "mbl\0", "mst\0", "min\0", "mtn\0", "mps\0", "eye\0" },
        { "mokɔlɔ mwa yambo\0", "mokɔlɔ mwa míbalé\0", "mokɔlɔ mwa mísáto\0", "mokɔlɔ ya mínéi\0", "mokɔlɔ ya mítáno\0", "mpɔ́sɔ\0", "eyenga\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ln_CG
    {
        QLocale::Language::Lao, QLocale::Script::LaoScript, QLocale::Country::Laos,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "ລາວ\0", "ລາວ\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "H:mm\0", "H ໂມງ m ນາທີ ss ວິນາທີ Z\0",
        "ກ່ອນທ່ຽງ\0", "ຫຼັງທ່ຽງ\0",
        { "ມ.ກ.\0", "ກ.ພ.\0", "ມ.ນ.\0", "ມ.ສ.\0", "ພ.ພ.\0", "ມິ.ຖ.\0", "ກ.ລ.\0", "ສ.ຫ.\0", "ກ.ຍ.\0", "ຕ.ລ.\0", "ພ.ຈ.\0", "ທ.ວ.\0" },
        { "ມັງກອນ\0", "ກຸມພາ\0", "ມີນາ\0", "ເມສາ\0", "ພຶດສະພາ\0", "ມິຖຸນາ\0", "ກໍລະກົດ\0", "ສິງຫາ\0", "ກັນຍາ\0", "ຕຸລາ\0", "ພະຈິກ\0", "ທັນວາ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ມ.ກ.\0", "ກ.ພ.\0", "ມ.ນ.\0", "ມ.ສ.\0", "ພ.ພ.\0", "ມິ.ຖ.\0", "ກ.ລ.\0", "ສ.ຫ.\0", "ກ.ຍ.\0", "ຕ.ລ.\0", "ພ.ຈ.\0", "ທ.ວ.\0" },
        { "ມັງກອນ\0", "ກຸມພາ\0", "ມີນາ\0", "ເມສາ\0", "ພຶດສະພາ\0", "ມິຖຸນາ\0", "ກໍລະກົດ\0", "ສິງຫາ\0", "ກັນຍາ\0", "ຕຸລາ\0", "ພະຈິກ\0", "ທັນວາ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ຈັນ\0", "ອັງຄານ\0", "ພຸດ\0", "ພະຫັດ\0", "ສຸກ\0", "ເສົາ\0", "ອາທິດ\0" },
        { "ວັນຈັນ\0", "ວັນອັງຄານ\0", "ວັນພຸດ\0", "ວັນພະຫັດ\0", "ວັນສຸກ\0", "ວັນເສົາ\0", "ວັນອາທິດ\0" },
        { "ຈ\0", "ອ\0", "ພ\0", "ພຫ\0", "ສຸ\0", "ສ\0", "ອາ\0" },
        { "ຈັນ\0", "ອັງຄານ\0", "ພຸດ\0", "ພະຫັດ\0", "ສຸກ\0", "ເສົາ\0", "ອາທິດ\0" },
        { "ວັນຈັນ\0", "ວັນອັງຄານ\0", "ວັນພຸດ\0", "ວັນພະຫັດ\0", "ວັນສຸກ\0", "ວັນເສົາ\0", "ວັນອາທິດ\0" },
        { "ຈ\0", "ອ\0", "ພ\0", "ພຫ\0", "ສຸ\0", "ສ\0", "ອາ\0" }
    }, // lo_LA
    {
        QLocale::Language::NorthernLuri, QLocale::Script::ArabicScript, QLocale::Country::Iraq,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 1776,
        "لۊری شومالی\0", nullptr,
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "جانڤیە\0", "فئڤریە\0", "مارس\0", "آڤریل\0", "مئی\0", "جوٙأن\0", "جوٙلا\0", "آگوست\0", "سئپتامر\0", "ئوکتوڤر\0", "نوڤامر\0", "دئسامر\0" },
        { "جانڤیە\0", "فئڤریە\0", "مارس\0", "آڤریل\0", "مئی\0", "جوٙأن\0", "جوٙلا\0", "آگوست\0", "سئپتامر\0", "ئوکتوڤر\0", "نوڤامر\0", "دئسامر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "جانڤیە\0", "فئڤریە\0", "مارس\0", "آڤریل\0", "مئی\0", "جوٙأن\0", "جوٙلا\0", "آگوست\0", "سئپتامر\0", "ئوکتوڤر\0", "نوڤامر\0", "دئسامر\0" },
        { "جانڤیە\0", "فئڤریە\0", "مارس\0", "آڤریل\0", "مئی\0", "جوٙأن\0", "جوٙلا\0", "آگوست\0", "سئپتامر\0", "ئوکتوڤر\0", "نوڤامر\0", "دئسامر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // lrc_IQ
    {
        QLocale::Language::NorthernLuri, QLocale::Script::ArabicScript, QLocale::Country::Iran,
        Qt::Saturday, Qt::Friday, Qt::Friday,
        46, 44, 59, 37, 45, 43, 69, 1776,
        "لۊری شومالی\0", nullptr,
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "جانڤیە\0", "فئڤریە\0", "مارس\0", "آڤریل\0", "مئی\0", "جوٙأن\0", "جوٙلا\0", "آگوست\0", "سئپتامر\0", "ئوکتوڤر\0", "نوڤامر\0", "دئسامر\0" },
        { "جانڤیە\0", "فئڤریە\0", "مارس\0", "آڤریل\0", "مئی\0", "جوٙأن\0", "جوٙلا\0", "آگوست\0", "سئپتامر\0", "ئوکتوڤر\0", "نوڤامر\0", "دئسامر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "جانڤیە\0", "فئڤریە\0", "مارس\0", "آڤریل\0", "مئی\0", "جوٙأن\0", "جوٙلا\0", "آگوست\0", "سئپتامر\0", "ئوکتوڤر\0", "نوڤامر\0", "دئسامر\0" },
        { "جانڤیە\0", "فئڤریە\0", "مارس\0", "آڤریل\0", "مئی\0", "جوٙأن\0", "جوٙلا\0", "آگوست\0", "سئپتامر\0", "ئوکتوڤر\0", "نوڤامر\0", "دئسامر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // lrc_IR
    {
        QLocale::Language::Lithuanian, QLocale::Script::LatinScript, QLocale::Country::Lithuania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "lietuvių\0", "Lietuva\0",
        "yyyy-MM-dd\0", "yyyy 'm'. MMMM d 'd'.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "priešpiet\0", "popiet\0",
        { "saus.\0", "vas.\0", "kov.\0", "bal.\0", "geg.\0", "birž.\0", "liep.\0", "rugp.\0", "rugs.\0", "spal.\0", "lapkr.\0", "gruod.\0" },
        { "sausis\0", "vasaris\0", "kovas\0", "balandis\0", "gegužė\0", "birželis\0", "liepa\0", "rugpjūtis\0", "rugsėjis\0", "spalis\0", "lapkritis\0", "gruodis\0" },
        { "S\0", "V\0", "K\0", "B\0", "G\0", "B\0", "L\0", "R\0", "R\0", "S\0", "L\0", "G\0" },
        { "saus.\0", "vas.\0", "kov.\0", "bal.\0", "geg.\0", "birž.\0", "liep.\0", "rugp.\0", "rugs.\0", "spal.\0", "lapkr.\0", "gruod.\0" },
        { "sausio\0", "vasario\0", "kovo\0", "balandžio\0", "gegužės\0", "birželio\0", "liepos\0", "rugpjūčio\0", "rugsėjo\0", "spalio\0", "lapkričio\0", "gruodžio\0" },
        { "S\0", "V\0", "K\0", "B\0", "G\0", "B\0", "L\0", "R\0", "R\0", "S\0", "L\0", "G\0" },
        { "pr\0", "an\0", "tr\0", "kt\0", "pn\0", "št\0", "sk\0" },
        { "pirmadienis\0", "antradienis\0", "trečiadienis\0", "ketvirtadienis\0", "penktadienis\0", "šeštadienis\0", "sekmadienis\0" },
        { "P\0", "A\0", "T\0", "K\0", "P\0", "Š\0", "S\0" },
        { "pr\0", "an\0", "tr\0", "kt\0", "pn\0", "št\0", "sk\0" },
        { "pirmadienis\0", "antradienis\0", "trečiadienis\0", "ketvirtadienis\0", "penktadienis\0", "šeštadienis\0", "sekmadienis\0" },
        { "P\0", "A\0", "T\0", "K\0", "P\0", "Š\0", "S\0" }
    }, // lt_LT
    {
        QLocale::Language::LubaKatanga, QLocale::Script::LatinScript, QLocale::Country::CongoKinshasa,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Tshiluba\0", "Ditunga wa Kongu\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Dinda\0", "Dilolo\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "C\0", "L\0", "L\0", "M\0", "L\0", "L\0", "K\0", "L\0", "L\0", "L\0", "K\0", "C\0" },
        { "Cio\0", "Lui\0", "Lus\0", "Muu\0", "Lum\0", "Luf\0", "Kab\0", "Lush\0", "Lut\0", "Lun\0", "Kas\0", "Cis\0" },
        { "Ciongo\0", "Lùishi\0", "Lusòlo\0", "Mùuyà\0", "Lumùngùlù\0", "Lufuimi\0", "Kabàlàshìpù\0", "Lùshìkà\0", "Lutongolo\0", "Lungùdi\0", "Kaswèkèsè\0", "Ciswà\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "N\0", "N\0", "N\0", "N\0", "N\0", "L\0", "L\0" },
        { "Nko\0", "Ndy\0", "Ndg\0", "Njw\0", "Ngv\0", "Lub\0", "Lum\0" },
        { "Nkodya\0", "Ndàayà\0", "Ndangù\0", "Njòwa\0", "Ngòvya\0", "Lubingu\0", "Lumingu\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // lu_CD
    {
        QLocale::Language::Luo, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Dholuo\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "OD\0", "OT\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "C\0", "R\0", "D\0", "N\0", "B\0", "U\0", "B\0", "B\0", "C\0", "P\0", "C\0", "P\0" },
        { "DAC\0", "DAR\0", "DAD\0", "DAN\0", "DAH\0", "DAU\0", "DAO\0", "DAB\0", "DOC\0", "DAP\0", "DGI\0", "DAG\0" },
        { "Dwe mar Achiel\0", "Dwe mar Ariyo\0", "Dwe mar Adek\0", "Dwe mar Ang’wen\0", "Dwe mar Abich\0", "Dwe mar Auchiel\0", "Dwe mar Abiriyo\0", "Dwe mar Aboro\0", "Dwe mar Ochiko\0", "Dwe mar Apar\0", "Dwe mar gi achiel\0", "Dwe mar Apar gi ariyo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "W\0", "T\0", "T\0", "T\0", "T\0", "N\0", "J\0" },
        { "WUT\0", "TAR\0", "TAD\0", "TAN\0", "TAB\0", "NGS\0", "JMP\0" },
        { "Wuok Tich\0", "Tich Ariyo\0", "Tich Adek\0", "Tich Ang’wen\0", "Tich Abich\0", "Ngeso\0", "Jumapil\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // luo_KE
    {
        QLocale::Language::Luyia, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Luluhia\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "J3\0", "J4\0", "J5\0", "Al\0", "Ij\0", "J1\0", "J2\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Murwa wa Kanne\0", "Murwa wa Katano\0", "Jumamosi\0", "Jumapiri\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // luy_KE
    {
        QLocale::Language::Latvian, QLocale::Script::LatinScript, QLocale::Country::Latvia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "latviešu\0", "Latvija\0",
        "dd.MM.yyyy\0", "yyyy. 'APdAP' d. MMMM\0", "HH:mm\0", "HH:mm:ss Z\0",
        "priekšpusdiena\0", "pēcpusdiena\0",
        { "janv.\0", "febr.\0", "marts\0", "apr.\0", "maijs\0", "jūn.\0", "jūl.\0", "aug.\0", "sept.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "janvāris\0", "februāris\0", "marts\0", "aprīlis\0", "maijs\0", "jūnijs\0", "jūlijs\0", "augusts\0", "septembris\0", "oktobris\0", "novembris\0", "decembris\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "janv.\0", "febr.\0", "marts\0", "apr.\0", "maijs\0", "jūn.\0", "jūl.\0", "aug.\0", "sept.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "janvāris\0", "februāris\0", "marts\0", "aprīlis\0", "maijs\0", "jūnijs\0", "jūlijs\0", "augusts\0", "septembris\0", "oktobris\0", "novembris\0", "decembris\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Pirmd.\0", "Otrd.\0", "Trešd.\0", "Ceturtd.\0", "Piektd.\0", "Sestd.\0", "Svētd.\0" },
        { "Pirmdiena\0", "Otrdiena\0", "Trešdiena\0", "Ceturtdiena\0", "Piektdiena\0", "Sestdiena\0", "Svētdiena\0" },
        { "P\0", "O\0", "T\0", "C\0", "P\0", "S\0", "S\0" },
        { "pirmd.\0", "otrd.\0", "trešd.\0", "ceturtd.\0", "piektd.\0", "sestd.\0", "svētd.\0" },
        { "pirmdiena\0", "otrdiena\0", "trešdiena\0", "ceturtdiena\0", "piektdiena\0", "sestdiena\0", "svētdiena\0" },
        { "P\0", "O\0", "T\0", "C\0", "P\0", "S\0", "S\0" }
    }, // lv_LV
    {
        QLocale::Language::Maithili, QLocale::Script::DevanagariScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "मैथिली\0", "भारत\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "भोर\0", "सांझ\0",
        { "जन॰\0", "फर॰\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुल॰\0", "अग॰\0", "सित॰\0", "अक्तू॰\0", "नव॰\0", "दिस॰\0" },
        { "जनवरी\0", "फरवरी\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुलाई\0", "अगस्त\0", "सितंबर\0", "अक्टूबर\0", "नवंबर\0", "दिसंबर\0" },
        { "ज\0", "फ\0", "मा\0", "अ\0", "म\0", "जू\0", "जु\0", "अ\0", "सि\0", "अ\0", "न\0", "दि\0" },
        { "जन॰\0", "फ़र॰\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुल॰\0", "अग॰\0", "सित॰\0", "अक्तू॰\0", "नव॰\0", "दिस॰\0" },
        { "जनवरी\0", "फरवरी\0", "मार्च\0", "अप्रैल\0", "मई\0", "जून\0", "जुलाई\0", "अगस्त\0", "सितंबर\0", "अक्तूबर\0", "नवंबर\0", "दिसंबर\0" },
        { "ज\0", "फ\0", "मा\0", "अ\0", "म\0", "जू\0", "जु\0", "अ\0", "सि\0", "अ\0", "न\0", "दि\0" },
        { "सोम\0", "मंगल\0", "बुध\0", "गुरु\0", "शुक्र\0", "शनि\0", "रवि\0" },
        { "सोम दिन\0", "मंगल दिन\0", "बुध दिन\0", "बृहस्पति दिन\0", "शुक्र दिन\0", "शनि दिन\0", "रवि दिन\0" },
        { "सो\0", "मं\0", "बु\0", "गु\0", "शु\0", "श\0", "र\0" },
        { "सोम\0", "मंगल\0", "बुध\0", "गुरु\0", "शुक्र\0", "शनि\0", "रवि\0" },
        { "सोम दिन\0", "मंगल दिन\0", "बुध दिन\0", "बृहस्पति दिन\0", "शुक्र दिन\0", "शनि दिन\0", "रवि दिन\0" },
        { "सो\0", "मं\0", "बु\0", "गु\0", "शु\0", "श\0", "र\0" }
    }, // mai_IN
    {
        QLocale::Language::Masai, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Maa\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Ɛnkakɛnyá\0", "Ɛndámâ\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Dal\0", "Ará\0", "Ɔɛn\0", "Doy\0", "Lép\0", "Rok\0", "Sás\0", "Bɔ́r\0", "Kús\0", "Gís\0", "Shʉ́\0", "Ntʉ́\0" },
        { "Oladalʉ́\0", "Arát\0", "Ɔɛnɨ́ɔɨŋɔk\0", "Olodoyíóríê inkókúâ\0", "Oloilépūnyīē inkókúâ\0", "Kújúɔrɔk\0", "Mórusásin\0", "Ɔlɔ́ɨ́bɔ́rárɛ\0", "Kúshîn\0", "Olgísan\0", "Pʉshʉ́ka\0", "Ntʉ́ŋʉ́s\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "3\0", "4\0", "5\0", "6\0", "7\0", "1\0", "2\0" },
        { "Jtt\0", "Jnn\0", "Jtn\0", "Alh\0", "Iju\0", "Jmo\0", "Jpi\0" },
        { "Jumatátu\0", "Jumane\0", "Jumatánɔ\0", "Alaámisi\0", "Jumáa\0", "Jumamósi\0", "Jumapílí\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // mas_KE
    {
        QLocale::Language::Masai, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Maa\0", "Tansania\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Ɛnkakɛnyá\0", "Ɛndámâ\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Dal\0", "Ará\0", "Ɔɛn\0", "Doy\0", "Lép\0", "Rok\0", "Sás\0", "Bɔ́r\0", "Kús\0", "Gís\0", "Shʉ́\0", "Ntʉ́\0" },
        { "Oladalʉ́\0", "Arát\0", "Ɔɛnɨ́ɔɨŋɔk\0", "Olodoyíóríê inkókúâ\0", "Oloilépūnyīē inkókúâ\0", "Kújúɔrɔk\0", "Mórusásin\0", "Ɔlɔ́ɨ́bɔ́rárɛ\0", "Kúshîn\0", "Olgísan\0", "Pʉshʉ́ka\0", "Ntʉ́ŋʉ́s\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "3\0", "4\0", "5\0", "6\0", "7\0", "1\0", "2\0" },
        { "Jtt\0", "Jnn\0", "Jtn\0", "Alh\0", "Iju\0", "Jmo\0", "Jpi\0" },
        { "Jumatátu\0", "Jumane\0", "Jumatánɔ\0", "Alaámisi\0", "Jumáa\0", "Jumamósi\0", "Jumapílí\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // mas_TZ
    {
        QLocale::Language::Meru, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kĩmĩrũ\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "RŨ\0", "ŨG\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "Ĩ\0", "M\0", "N\0", "N\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "JAN\0", "FEB\0", "MAC\0", "ĨPU\0", "MĨĨ\0", "NJU\0", "NJR\0", "AGA\0", "SPT\0", "OKT\0", "NOV\0", "DEC\0" },
        { "Januarĩ\0", "Feburuarĩ\0", "Machi\0", "Ĩpurũ\0", "Mĩĩ\0", "Njuni\0", "Njuraĩ\0", "Agasti\0", "Septemba\0", "Oktũba\0", "Novemba\0", "Dicemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "W\0", "W\0", "W\0", "W\0", "J\0", "K\0" },
        { "MRA\0", "WAI\0", "WET\0", "WEN\0", "WTN\0", "JUM\0", "KIU\0" },
        { "Muramuko\0", "Wairi\0", "Wethatu\0", "Wena\0", "Wetano\0", "Jumamosi\0", "Kiumia\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // mer_KE
    {
        QLocale::Language::Morisyen, QLocale::Script::LatinScript, QLocale::Country::Mauritius,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 160, 59, 37, 45, 43, 69, 48,
        "kreol morisien\0", "Moris\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "z\0", "f\0", "m\0", "a\0", "m\0", "z\0", "z\0", "o\0", "s\0", "o\0", "n\0", "d\0" },
        { "zan\0", "fev\0", "mar\0", "avr\0", "me\0", "zin\0", "zil\0", "out\0", "sep\0", "okt\0", "nov\0", "des\0" },
        { "zanvie\0", "fevriye\0", "mars\0", "avril\0", "me\0", "zin\0", "zilye\0", "out\0", "septam\0", "oktob\0", "novam\0", "desam\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "l\0", "m\0", "m\0", "z\0", "v\0", "s\0", "d\0" },
        { "lin\0", "mar\0", "mer\0", "ze\0", "van\0", "sam\0", "dim\0" },
        { "lindi\0", "mardi\0", "merkredi\0", "zedi\0", "vandredi\0", "samdi\0", "dimans\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // mfe_MU
    {
        QLocale::Language::Malagasy, QLocale::Script::LatinScript, QLocale::Country::Madagascar,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Malagasy\0", "Madagasikara\0",
        "yyyy-MM-dd\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "Mey\0", "Jon\0", "Jol\0", "Aog\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Janoary\0", "Febroary\0", "Martsa\0", "Aprily\0", "Mey\0", "Jona\0", "Jolay\0", "Aogositra\0", "Septambra\0", "Oktobra\0", "Novambra\0", "Desambra\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "Mey\0", "Jon\0", "Jol\0", "Aog\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Janoary\0", "Febroary\0", "Martsa\0", "Aprily\0", "Mey\0", "Jona\0", "Jolay\0", "Aogositra\0", "Septambra\0", "Oktobra\0", "Novambra\0", "Desambra\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Alats\0", "Tal\0", "Alar\0", "Alak\0", "Zom\0", "Asab\0", "Alah\0" },
        { "Alatsinainy\0", "Talata\0", "Alarobia\0", "Alakamisy\0", "Zoma\0", "Asabotsy\0", "Alahady\0" },
        { "A\0", "T\0", "A\0", "A\0", "Z\0", "A\0", "A\0" },
        { "Alats\0", "Tal\0", "Alar\0", "Alak\0", "Zom\0", "Asab\0", "Alah\0" },
        { "Alatsinainy\0", "Talata\0", "Alarobia\0", "Alakamisy\0", "Zoma\0", "Asabotsy\0", "Alahady\0" },
        { "A\0", "T\0", "A\0", "A\0", "Z\0", "A\0", "A\0" }
    }, // mg_MG
    {
        QLocale::Language::MakhuwaMeetto, QLocale::Script::LatinScript, QLocale::Country::Mozambique,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Makua\0", "Umozambiki\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "wichishu\0", "mchochil’l\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "K\0", "U\0", "R\0", "C\0", "T\0", "M\0", "S\0", "N\0", "T\0", "K\0", "M\0", "Y\0" },
        { "Kwa\0", "Una\0", "Rar\0", "Che\0", "Tha\0", "Moc\0", "Sab\0", "Nan\0", "Tis\0", "Kum\0", "Moj\0", "Yel\0" },
        { "Mweri wo kwanza\0", "Mweri wo unayeli\0", "Mweri wo uneraru\0", "Mweri wo unecheshe\0", "Mweri wo unethanu\0", "Mweri wo thanu na mocha\0", "Mweri wo saba\0", "Mweri wo nane\0", "Mweri wo tisa\0", "Mweri wo kumi\0", "Mweri wo kumi na moja\0", "Mweri wo kumi na yel’li\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "J\0", "J\0", "J\0", "A\0", "I\0", "J\0", "S\0" },
        { "Jtt\0", "Jnn\0", "Jtn\0", "Ara\0", "Iju\0", "Jmo\0", "Sab\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Arahamisi\0", "Ijumaa\0", "Jumamosi\0", "Sabato\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // mgh_MZ
    {
        QLocale::Language::Meta, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "metaʼ\0", "Kamalun\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "mbegtug\0", "imeg àbùbì\0", "imeg mbəŋchubi\0", "iməg ngwə̀t\0", "iməg fog\0", "iməg ichiibɔd\0", "iməg àdùmbə̀ŋ\0", "iməg ichika\0", "iməg kud\0", "iməg tèsiʼe\0", "iməg zò\0", "iməg krizmed\0" },
        { "iməg mbegtug\0", "imeg àbùbì\0", "imeg mbəŋchubi\0", "iməg ngwə̀t\0", "iməg fog\0", "iməg ichiibɔd\0", "iməg àdùmbə̀ŋ\0", "iməg ichika\0", "iməg kud\0", "iməg tèsiʼe\0", "iməg zò\0", "iməg krizmed\0" },
        { "M1\0", "A2\0", "M3\0", "N4\0", "F5\0", "I6\0", "A7\0", "I8\0", "K9\0", "10\0", "11\0", "12\0" },
        { "mbegtug\0", "imeg àbùbì\0", "imeg mbəŋchubi\0", "iməg ngwə̀t\0", "iməg fog\0", "iməg ichiibɔd\0", "iməg àdùmbə̀ŋ\0", "iməg ichika\0", "iməg kud\0", "iməg tèsiʼe\0", "iməg zò\0", "iməg krizmed\0" },
        { "iməg mbegtug\0", "imeg àbùbì\0", "imeg mbəŋchubi\0", "iməg ngwə̀t\0", "iməg fog\0", "iməg ichiibɔd\0", "iməg àdùmbə̀ŋ\0", "iməg ichika\0", "iməg kud\0", "iməg tèsiʼe\0", "iməg zò\0", "iməg krizmed\0" },
        { "M1\0", "A2\0", "M3\0", "N4\0", "F5\0", "I6\0", "A7\0", "I8\0", "K9\0", "10\0", "11\0", "12\0" },
        { "Aneg 2\0", "Aneg 3\0", "Aneg 4\0", "Aneg 5\0", "Aneg 6\0", "Aneg 7\0", "Aneg 1\0" },
        { "Aneg 2\0", "Aneg 3\0", "Aneg 4\0", "Aneg 5\0", "Aneg 6\0", "Aneg 7\0", "Aneg 1\0" },
        { "A2\0", "A3\0", "A4\0", "A5\0", "A6\0", "A7\0", "A1\0" },
        { "Aneg 2\0", "Aneg 3\0", "Aneg 4\0", "Aneg 5\0", "Aneg 6\0", "Aneg 7\0", "Aneg 1\0" },
        { "Aneg 2\0", "Aneg 3\0", "Aneg 4\0", "Aneg 5\0", "Aneg 6\0", "Aneg 7\0", "Aneg 1\0" },
        { "A2\0", "A3\0", "A4\0", "A5\0", "A6\0", "A7\0", "A1\0" }
    }, // mgo_CM
    {
        QLocale::Language::Maori, QLocale::Script::LatinScript, QLocale::Country::NewZealand,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "te reo Māori\0", "Aotearoa\0",
        "dd-MM-yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "Kohi\0", "Hui\0", "Pou\0", "Pae\0", "Hara\0", "Pipi\0", "Hōngo\0", "Here\0", "Mahu\0", "Nuku\0", "Rangi\0", "Haki\0" },
        { "Kohitātea\0", "Huitanguru\0", "Poutūterangi\0", "Paengawhāwhā\0", "Haratua\0", "Pipiri\0", "Hōngongoi\0", "Hereturikōkā\0", "Mahuru\0", "Whiringa-ā-nuku\0", "Whiringa-ā-rangi\0", "Hakihea\0" },
        { "K\0", "H\0", "P\0", "P\0", "H\0", "P\0", "H\0", "H\0", "M\0", "N\0", "R\0", "H\0" },
        { "Kohi\0", "Hui\0", "Pou\0", "Pae\0", "Hara\0", "Pipi\0", "Hōngo\0", "Here\0", "Mahu\0", "Nuku\0", "Rangi\0", "Haki\0" },
        { "Kohitātea\0", "Huitanguru\0", "Poutūterangi\0", "Paengawhāwhā\0", "Haratua\0", "Pipiri\0", "Hōngongoi\0", "Hereturikōkā\0", "Mahuru\0", "Whiringa-ā-nuku\0", "Whiringa-ā-rangi\0", "Hakihea\0" },
        { "K\0", "H\0", "P\0", "P\0", "H\0", "P\0", "H\0", "H\0", "M\0", "N\0", "R\0", "H\0" },
        { "Hin\0", "Tū\0", "Apa\0", "Par\0", "Mer\0", "Hor\0", "Tap\0" },
        { "Rāhina\0", "Rātū\0", "Rāapa\0", "Rāpare\0", "Rāmere\0", "Rāhoroi\0", "Rātapu\0" },
        { "H\0", "T\0", "A\0", "P\0", "M\0", "H\0", "T\0" },
        { "Hin\0", "Tū\0", "Apa\0", "Par\0", "Mer\0", "Hor\0", "Tap\0" },
        { "Rāhina\0", "Rātū\0", "Rāapa\0", "Rāpare\0", "Rāmere\0", "Rāhoroi\0", "Rātapu\0" },
        { "H\0", "T\0", "A\0", "P\0", "M\0", "H\0", "T\0" }
    }, // mi_NZ
    {
        QLocale::Language::Macedonian, QLocale::Script::CyrillicScript, QLocale::Country::NorthMacedonia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "македонски\0", "Северна Македонија\0",
        "d.M.yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "претпладне\0", "попладне\0",
        { "јан.\0", "фев.\0", "мар.\0", "апр.\0", "мај\0", "јун.\0", "јул.\0", "авг.\0", "септ.\0", "окт.\0", "ноем.\0", "дек.\0" },
        { "јануари\0", "февруари\0", "март\0", "април\0", "мај\0", "јуни\0", "јули\0", "август\0", "септември\0", "октомври\0", "ноември\0", "декември\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "јан.\0", "фев.\0", "мар.\0", "апр.\0", "мај\0", "јун.\0", "јул.\0", "авг.\0", "септ.\0", "окт.\0", "ноем.\0", "дек.\0" },
        { "јануари\0", "февруари\0", "март\0", "април\0", "мај\0", "јуни\0", "јули\0", "август\0", "септември\0", "октомври\0", "ноември\0", "декември\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "пон.\0", "вто.\0", "сре.\0", "чет.\0", "пет.\0", "саб.\0", "нед.\0" },
        { "понеделник\0", "вторник\0", "среда\0", "четврток\0", "петок\0", "сабота\0", "недела\0" },
        { "п\0", "в\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пон.\0", "вто.\0", "сре.\0", "чет.\0", "пет.\0", "саб.\0", "нед.\0" },
        { "понеделник\0", "вторник\0", "среда\0", "четврток\0", "петок\0", "сабота\0", "недела\0" },
        { "п\0", "в\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // mk_MK
    {
        QLocale::Language::Malayalam, QLocale::Script::MalayalamScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "മലയാളം\0", "ഇന്ത്യ\0",
        "d/M/yyyy\0", "yyyy, MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "ജനു\0", "ഫെബ്രു\0", "മാർ\0", "ഏപ്രി\0", "മേയ്\0", "ജൂൺ\0", "ജൂലൈ\0", "ഓഗ\0", "സെപ്റ്റം\0", "ഒക്ടോ\0", "നവം\0", "ഡിസം\0" },
        { "ജനുവരി\0", "ഫെബ്രുവരി\0", "മാർച്ച്\0", "ഏപ്രിൽ\0", "മേയ്\0", "ജൂൺ\0", "ജൂലൈ\0", "ഓഗസ്റ്റ്\0", "സെപ്റ്റംബർ\0", "ഒക്‌ടോബർ\0", "നവംബർ\0", "ഡിസംബർ\0" },
        { "ജ\0", "ഫെ\0", "മാ\0", "ഏ\0", "മെ\0", "ജൂൺ\0", "ജൂ\0", "ഓ\0", "സെ\0", "ഒ\0", "ന\0", "ഡി\0" },
        { "ജനു\0", "ഫെബ്രു\0", "മാർ\0", "ഏപ്രി\0", "മേയ്\0", "ജൂൺ\0", "ജൂലൈ\0", "ഓഗ\0", "സെപ്റ്റം\0", "ഒക്ടോ\0", "നവം\0", "ഡിസം\0" },
        { "ജനുവരി\0", "ഫെബ്രുവരി\0", "മാർച്ച്\0", "ഏപ്രിൽ\0", "മേയ്\0", "ജൂൺ\0", "ജൂലൈ\0", "ഓഗസ്റ്റ്\0", "സെപ്റ്റംബർ\0", "ഒക്‌ടോബർ\0", "നവംബർ\0", "ഡിസംബർ\0" },
        { "ജ\0", "ഫെ\0", "മാ\0", "ഏ\0", "മെ\0", "ജൂൺ\0", "ജൂ\0", "ഓ\0", "സെ\0", "ഒ\0", "ന\0", "ഡി\0" },
        { "തിങ്കൾ\0", "ചൊവ്വ\0", "ബുധൻ\0", "വ്യാഴം\0", "വെള്ി\0", "ശനി\0", "ഞായർ\0" },
        { "തിങ്കളാഴ്‌ച\0", "ചൊവ്വാഴ്‌ച\0", "ബുധനാഴ്‌ച\0", "വ്യാഴാഴ്‌ച\0", "വെള്ളിയാഴ്‌ച\0", "ശനിയാഴ്‌ച\0", "ഞായറാഴ്‌ച\0" },
        { "തി\0", "ചൊ\0", "ബു\0", "വ്യാ\0", "വെ\0", "ശ\0", "ഞാ\0" },
        { "തിങ്കൾ\0", "ചൊവ്വ\0", "ബുധൻ\0", "വ്യാഴം\0", "വെള്ളി\0", "ശനി\0", "ഞായർ\0" },
        { "തിങ്കളാഴ്‌ച\0", "ചൊവ്വാഴ്ച\0", "ബുധനാഴ്‌ച\0", "വ്യാഴാഴ്‌ച\0", "വെള്ളിയാഴ്‌ച\0", "ശനിയാഴ്‌ച\0", "ഞായറാഴ്‌ച\0" },
        { "തി\0", "ചൊ\0", "ബു\0", "വ്യാ\0", "വെ\0", "ശ\0", "ഞ\0" }
    }, // ml_IN
    {
        QLocale::Language::Mongolian, QLocale::Script::CyrillicScript, QLocale::Country::Mongolia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "монгол\0", "Монгол\0",
        "yyyy.MM.dd\0", "yyyy 'оны' MMMM'ын' d\0", "HH:mm\0", "HH:mm:ss (Z)\0",
        "ү.ө.\0", "ү.х.\0",
        { "1-р сар\0", "2-р сар\0", "3-р сар\0", "4-р сар\0", "5-р сар\0", "6-р сар\0", "7-р сар\0", "8-р сар\0", "9-р сар\0", "10-р сар\0", "11-р сар\0", "12-р сар\0" },
        { "Нэгдүгээр сар\0", "Хоёрдугаар сар\0", "Гуравдугаар сар\0", "Дөрөвдүгээр сар\0", "Тавдугаар сар\0", "Зургаадугаар сар\0", "Долоодугаар сар\0", "Наймдугаар сар\0", "Есдүгээр сар\0", "Аравдугаар сар\0", "Арван нэгдүгээр сар\0", "Арван хоёрдугаар сар\0" },
        { "I\0", "II\0", "III\0", "IV\0", "V\0", "VI\0", "VII\0", "VIII\0", "IX\0", "X\0", "XI\0", "XII\0" },
        { "1-р сар\0", "2-р сар\0", "3-р сар\0", "4-р сар\0", "5-р сар\0", "6-р сар\0", "7-р сар\0", "8-р сар\0", "9-р сар\0", "10-р сар\0", "11-р сар\0", "12-р сар\0" },
        { "нэгдүгээр сар\0", "хоёрдугаар сар\0", "гуравдугаар сар\0", "дөрөвдүгээр сар\0", "тавдугаар сар\0", "зургаадугаар сар\0", "долоодугаар сар\0", "наймдугаар сар\0", "есдүгээр сар\0", "аравдугаар сар\0", "арван нэгдүгээр сар\0", "арван хоёрдугаар сар\0" },
        { "I\0", "II\0", "III\0", "IV\0", "V\0", "VI\0", "VII\0", "VIII\0", "IX\0", "X\0", "XI\0", "XII\0" },
        { "Да\0", "Мя\0", "Лх\0", "Пү\0", "Ба\0", "Бя\0", "Ня\0" },
        { "Даваа\0", "Мягмар\0", "Лхагва\0", "Пүрэв\0", "Баасан\0", "Бямба\0", "Ням\0" },
        { "Да\0", "Мя\0", "Лх\0", "Пү\0", "Ба\0", "Бя\0", "Ня\0" },
        { "Да\0", "Мя\0", "Лх\0", "Пү\0", "Ба\0", "Бя\0", "Ня\0" },
        { "даваа\0", "мягмар\0", "лхагва\0", "пүрэв\0", "баасан\0", "бямба\0", "ням\0" },
        { "Да\0", "Мя\0", "Лх\0", "Пү\0", "Ба\0", "Бя\0", "Ня\0" }
    }, // mn_MN
    {
        QLocale::Language::Manipuri, QLocale::Script::BanglaScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "মৈতৈলোন্\0", "ইন্দিয়া\0",
        "d/M/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "এ এম\0", "পি এম\0",
        { "জানু\0", "ফেব্রু\0", "মার\0", "এপ্রি\0", "মে\0", "জুন\0", "জুলা\0", "আগ\0", "সেপ্ট\0", "ওক্টো\0", "নভে\0", "ডিসে\0" },
        { "জানুৱারি\0", "ফেব্রুৱারি\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "ওগষ্ট\0", "সেপ্টেম্বর\0", "ওক্টোবর\0", "নবেম্বর\0", "ডিসেম্বর\0" },
        { "জা\0", "ফে\0", "মার\0", "এপ\0", "মে\0", "জুন\0", "জুল\0", "আ\0", "সে\0", "ও\0", "নব\0", "ডি\0" },
        { "জানুৱারি\0", "ফেব্রুৱারি\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "আগস্ট\0", "সেপ্টেম্বর\0", "ওক্টোবর\0", "নভেম্বর\0", "ডিসেম্বর\0" },
        { "জানুৱারি\0", "ফেব্রুৱারি\0", "মার্চ\0", "এপ্রিল\0", "মে\0", "জুন\0", "জুলাই\0", "আগস্ট\0", "সেপ্টেম্বর\0", "ওক্টোবর\0", "নভেম্বর\0", "ডিসেম্বর\0" },
        { "জা\0", "ফে\0", "মার\0", "এপ\0", "মে\0", "জুন\0", "জুল\0", "আ\0", "সে\0", "ওক\0", "নব\0", "ডি\0" },
        { "নিংথৌকাবা\0", "লৈবাকপোকপা\0", "য়ুমশকৈশা\0", "শগোলশেন\0", "ইরাই\0", "থাংজ\0", "নোংমাইজিং\0" },
        { "নিংথৌকাবা\0", "লৈবাকপোকপা\0", "য়ুমশকৈশা\0", "শগোলশেন\0", "ইরাই\0", "থাংজ\0", "নোংমাইজিং\0" },
        { "নিং\0", "লৈ\0", "য়ুম\0", "শগ\0", "ইরা\0", "থাং\0", "নো\0" },
        { "নিংথৌকাবা\0", "লৈবাকপোকপা\0", "য়ুমশকৈশা\0", "শগোলশেন\0", "ইরাই\0", "থাংজ\0", "নোংমাইজিং\0" },
        { "নিংথৌকাবা\0", "লৈবাকপোকপা\0", "য়ুমশকৈশা\0", "শগোলশেন\0", "ইরাই\0", "থাংজ\0", "নোংমাইজিং\0" },
        { "নিং\0", "লৈবা\0", "য়ুম\0", "শগো\0", "ইরা\0", "থাং\0", "নোং\0" }
    }, // mni_Beng_IN
    {
        QLocale::Language::Marathi, QLocale::Script::DevanagariScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 2406,
        "मराठी\0", "भारत\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "जाने\0", "फेब्रु\0", "मार्च\0", "एप्रि\0", "मे\0", "जून\0", "जुलै\0", "ऑग\0", "सप्टें\0", "ऑक्टो\0", "नोव्हें\0", "डिसें\0" },
        { "जानेवारी\0", "फेब्रुवारी\0", "मार्च\0", "एप्रिल\0", "मे\0", "जून\0", "जुलै\0", "ऑगस्ट\0", "सप्टेंबर\0", "ऑक्टोबर\0", "नोव्हेंबर\0", "डिसेंबर\0" },
        { "जा\0", "फे\0", "मा\0", "ए\0", "मे\0", "जू\0", "जु\0", "ऑ\0", "स\0", "ऑ\0", "नो\0", "डि\0" },
        { "जाने\0", "फेब्रु\0", "मार्च\0", "एप्रि\0", "मे\0", "जून\0", "जुलै\0", "ऑग\0", "सप्टें\0", "ऑक्टो\0", "नोव्हें\0", "डिसें\0" },
        { "जानेवारी\0", "फेब्रुवारी\0", "मार्च\0", "एप्रिल\0", "मे\0", "जून\0", "जुलै\0", "ऑगस्ट\0", "सप्टेंबर\0", "ऑक्टोबर\0", "नोव्हेंबर\0", "डिसेंबर\0" },
        { "जा\0", "फे\0", "मा\0", "ए\0", "मे\0", "जू\0", "जु\0", "ऑ\0", "स\0", "ऑ\0", "नो\0", "डि\0" },
        { "सोम\0", "मंगळ\0", "बुध\0", "गुरु\0", "शुक्र\0", "शनि\0", "रवि\0" },
        { "सोमवार\0", "मंगळवार\0", "बुधवार\0", "गुरुवार\0", "शुक्रवार\0", "शनिवार\0", "रविवार\0" },
        { "सो\0", "मं\0", "बु\0", "गु\0", "शु\0", "श\0", "र\0" },
        { "सोम\0", "मंगळ\0", "बुध\0", "गुरु\0", "शुक्र\0", "शनि\0", "रवि\0" },
        { "सोमवार\0", "मंगळवार\0", "बुधवार\0", "गुरुवार\0", "शुक्रवार\0", "शनिवार\0", "रविवार\0" },
        { "सो\0", "मं\0", "बु\0", "गु\0", "शु\0", "श\0", "र\0" }
    }, // mr_IN
    {
        QLocale::Language::Malay, QLocale::Script::AnyScript, QLocale::Country::Brunei,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Melayu\0", "Brunei\0",
        "d/MM/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "PG\0", "PTG\0",
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ogo\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januari\0", "Februari\0", "Mac\0", "April\0", "Mei\0", "Jun\0", "Julai\0", "Ogos\0", "September\0", "Oktober\0", "November\0", "Disember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ogo\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januari\0", "Februari\0", "Mac\0", "April\0", "Mei\0", "Jun\0", "Julai\0", "Ogos\0", "September\0", "Oktober\0", "November\0", "Disember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Isn\0", "Sel\0", "Rab\0", "Kha\0", "Jum\0", "Sab\0", "Ahd\0" },
        { "Isnin\0", "Selasa\0", "Rabu\0", "Khamis\0", "Jumaat\0", "Sabtu\0", "Ahad\0" },
        { "I\0", "S\0", "R\0", "K\0", "J\0", "S\0", "A\0" },
        { "Isn\0", "Sel\0", "Rab\0", "Kha\0", "Jum\0", "Sab\0", "Ahd\0" },
        { "Isnin\0", "Selasa\0", "Rabu\0", "Khamis\0", "Jumaat\0", "Sabtu\0", "Ahad\0" },
        { "I\0", "S\0", "R\0", "K\0", "J\0", "S\0", "A\0" }
    }, // ms_BN
    {
        QLocale::Language::Malay, QLocale::Script::AnyScript, QLocale::Country::Indonesia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Melayu\0", "Indonesia\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "HH.mm\0", "HH.mm.ss Z\0",
        "PG\0", "PTG\0",
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ogo\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januari\0", "Februari\0", "Mac\0", "April\0", "Mei\0", "Jun\0", "Julai\0", "Ogos\0", "September\0", "Oktober\0", "November\0", "Disember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ogo\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januari\0", "Februari\0", "Mac\0", "April\0", "Mei\0", "Jun\0", "Julai\0", "Ogos\0", "September\0", "Oktober\0", "November\0", "Disember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Isn\0", "Sel\0", "Rab\0", "Kha\0", "Jum\0", "Sab\0", "Ahd\0" },
        { "Isnin\0", "Selasa\0", "Rabu\0", "Khamis\0", "Jumaat\0", "Sabtu\0", "Ahad\0" },
        { "I\0", "S\0", "R\0", "K\0", "J\0", "S\0", "A\0" },
        { "Isn\0", "Sel\0", "Rab\0", "Kha\0", "Jum\0", "Sab\0", "Ahd\0" },
        { "Isnin\0", "Selasa\0", "Rabu\0", "Khamis\0", "Jumaat\0", "Sabtu\0", "Ahad\0" },
        { "I\0", "S\0", "R\0", "K\0", "J\0", "S\0", "A\0" }
    }, // ms_ID
    {
        QLocale::Language::Malay, QLocale::Script::AnyScript, QLocale::Country::Malaysia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Melayu\0", "Malaysia\0",
        "d/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "PG\0", "PTG\0",
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ogo\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januari\0", "Februari\0", "Mac\0", "April\0", "Mei\0", "Jun\0", "Julai\0", "Ogos\0", "September\0", "Oktober\0", "November\0", "Disember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ogo\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januari\0", "Februari\0", "Mac\0", "April\0", "Mei\0", "Jun\0", "Julai\0", "Ogos\0", "September\0", "Oktober\0", "November\0", "Disember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Isn\0", "Sel\0", "Rab\0", "Kha\0", "Jum\0", "Sab\0", "Ahd\0" },
        { "Isnin\0", "Selasa\0", "Rabu\0", "Khamis\0", "Jumaat\0", "Sabtu\0", "Ahad\0" },
        { "I\0", "S\0", "R\0", "K\0", "J\0", "S\0", "A\0" },
        { "Isn\0", "Sel\0", "Rab\0", "Kha\0", "Jum\0", "Sab\0", "Ahd\0" },
        { "Isnin\0", "Selasa\0", "Rabu\0", "Khamis\0", "Jumaat\0", "Sabtu\0", "Ahad\0" },
        { "I\0", "S\0", "R\0", "K\0", "J\0", "S\0", "A\0" }
    }, // ms_MY
    {
        QLocale::Language::Malay, QLocale::Script::AnyScript, QLocale::Country::Singapore,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Melayu\0", "Singapura\0",
        "d/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "PG\0", "PTG\0",
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ogo\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januari\0", "Februari\0", "Mac\0", "April\0", "Mei\0", "Jun\0", "Julai\0", "Ogos\0", "September\0", "Oktober\0", "November\0", "Disember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ogo\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januari\0", "Februari\0", "Mac\0", "April\0", "Mei\0", "Jun\0", "Julai\0", "Ogos\0", "September\0", "Oktober\0", "November\0", "Disember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Isn\0", "Sel\0", "Rab\0", "Kha\0", "Jum\0", "Sab\0", "Ahd\0" },
        { "Isnin\0", "Selasa\0", "Rabu\0", "Khamis\0", "Jumaat\0", "Sabtu\0", "Ahad\0" },
        { "I\0", "S\0", "R\0", "K\0", "J\0", "S\0", "A\0" },
        { "Isn\0", "Sel\0", "Rab\0", "Kha\0", "Jum\0", "Sab\0", "Ahd\0" },
        { "Isnin\0", "Selasa\0", "Rabu\0", "Khamis\0", "Jumaat\0", "Sabtu\0", "Ahad\0" },
        { "I\0", "S\0", "R\0", "K\0", "J\0", "S\0", "A\0" }
    }, // ms_SG
    {
        QLocale::Language::Maltese, QLocale::Script::LatinScript, QLocale::Country::Malta,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Malti\0", "Malta\0",
        "dd/MM/yyyy\0", "d 'tAP'’ MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Fra\0", "Mar\0", "Apr\0", "Mej\0", "Ġun\0", "Lul\0", "Aww\0", "Set\0", "Ott\0", "Nov\0", "Diċ\0" },
        { "Jannar\0", "Frar\0", "Marzu\0", "April\0", "Mejju\0", "Ġunju\0", "Lulju\0", "Awwissu\0", "Settembru\0", "Ottubru\0", "Novembru\0", "Diċembru\0" },
        { "Jn\0", "Fr\0", "Mz\0", "Ap\0", "Mj\0", "Ġn\0", "Lj\0", "Aw\0", "St\0", "Ob\0", "Nv\0", "Dċ\0" },
        { "Jan\0", "Fra\0", "Mar\0", "Apr\0", "Mej\0", "Ġun\0", "Lul\0", "Aww\0", "Set\0", "Ott\0", "Nov\0", "Diċ\0" },
        { "Jannar\0", "Frar\0", "Marzu\0", "April\0", "Mejju\0", "Ġunju\0", "Lulju\0", "Awwissu\0", "Settembru\0", "Ottubru\0", "Novembru\0", "Diċembru\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "Ġ\0", "L\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Tne\0", "Tli\0", "Erb\0", "Ħam\0", "Ġim\0", "Sib\0", "Ħad\0" },
        { "It-Tnejn\0", "It-Tlieta\0", "L-Erbgħa\0", "Il-Ħamis\0", "Il-Ġimgħa\0", "Is-Sibt\0", "Il-Ħadd\0" },
        { "Tn\0", "Tl\0", "Er\0", "Ħm\0", "Ġm\0", "Sb\0", "Ħd\0" },
        { "Tne\0", "Tli\0", "Erb\0", "Ħam\0", "Ġim\0", "Sib\0", "Ħad\0" },
        { "It-Tnejn\0", "It-Tlieta\0", "L-Erbgħa\0", "Il-Ħamis\0", "Il-Ġimgħa\0", "Is-Sibt\0", "Il-Ħadd\0" },
        { "T\0", "Tl\0", "Er\0", "Ħm\0", "Ġm\0", "Sb\0", "Ħd\0" }
    }, // mt_MT
    {
        QLocale::Language::Mundang, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "MUNDAŊ\0", "kameruŋ\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "comme\0", "lilli\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "O\0", "A\0", "I\0", "F\0", "D\0", "B\0", "L\0", "M\0", "E\0", "U\0", "W\0", "Y\0" },
        { "FLO\0", "CLA\0", "CKI\0", "FMF\0", "MAD\0", "MBI\0", "MLI\0", "MAM\0", "FDE\0", "FMU\0", "FGW\0", "FYU\0" },
        { "Fĩi Loo\0", "Cokcwaklaŋne\0", "Cokcwaklii\0", "Fĩi Marfoo\0", "Madǝǝuutǝbijaŋ\0", "Mamǝŋgwãafahbii\0", "Mamǝŋgwãalii\0", "Madǝmbii\0", "Fĩi Dǝɓlii\0", "Fĩi Mundaŋ\0", "Fĩi Gwahlle\0", "Fĩi Yuru\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "L\0", "Z\0", "O\0", "A\0", "G\0", "E\0", "Y\0" },
        { "Cla\0", "Czi\0", "Cko\0", "Cka\0", "Cga\0", "Cze\0", "Cya\0" },
        { "Comlaaɗii\0", "Comzyiiɗii\0", "Comkolle\0", "Comkaldǝɓlii\0", "Comgaisuu\0", "Comzyeɓsuu\0", "Com’yakke\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // mua_CM
    {
        QLocale::Language::Burmese, QLocale::Script::MyanmarScript, QLocale::Country::MyanmarBurma,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 4170, 37, 45, 43, 69, 4160,
        "မြန်မာ\0", "မြန်မာ\0",
        "dd-MM-yyyy\0", "yyyy- MMMM d\0", "H:mm\0", "Z HH:mm:ss\0",
        "နံနက်\0", "ညနေ\0",
        { "ဇန်\0", "ဖေ\0", "မတ်\0", "ဧ\0", "မေ\0", "ဇွန်\0", "ဇူ\0", "ဩ\0", "စက်\0", "အောက်\0", "နို\0", "ဒီ\0" },
        { "ဇန်နဝါရီ\0", "ဖေဖော်ဝါရီ\0", "မတ်\0", "ဧပြီ\0", "မေ\0", "ဇွန်\0", "ဇူလိုင်\0", "ဩဂုတ်\0", "စက်တင်ဘာ\0", "အောက်တိုဘာ\0", "နိုဝင်ဘာ\0", "ဒီဇင်ဘာ\0" },
        { "ဇ\0", "ဖ\0", "မ\0", "ဧ\0", "မ\0", "ဇ\0", "ဇ\0", "ဩ\0", "စ\0", "အ\0", "န\0", "ဒ\0" },
        { "ဇန်\0", "ဖေ\0", "မတ်\0", "ဧ\0", "မေ\0", "ဇွန်\0", "ဇူ\0", "ဩ\0", "စက်\0", "အောက်\0", "နို\0", "ဒီ\0" },
        { "ဇန်နဝါရီ\0", "ဖေဖော်ဝါရီ\0", "မတ်\0", "ဧပြီ\0", "မေ\0", "ဇွန်\0", "ဇူလိုင်\0", "ဩဂုတ်\0", "စက်တင်ဘာ\0", "အောက်တိုဘာ\0", "နိုဝင်ဘာ\0", "ဒီဇင်ဘာ\0" },
        { "ဇ\0", "ဖ\0", "မ\0", "ဧ\0", "မ\0", "ဇ\0", "ဇ\0", "ဩ\0", "စ\0", "အ\0", "န\0", "ဒ\0" },
        { "တနင်္လာ\0", "အင်္ဂါ\0", "ဗုဒ္ဓဟူး\0", "ကြာသပတေး\0", "သောကြာ\0", "စနေ\0", "တနင်္ဂနွေ\0" },
        { "တနင်္လာ\0", "အင်္ဂါ\0", "ဗုဒ္ဓဟူး\0", "ကြာသပတေး\0", "သောကြာ\0", "စနေ\0", "တနင်္ဂနွေ\0" },
        { "တ\0", "အ\0", "ဗ\0", "က\0", "သ\0", "စ\0", "တ\0" },
        { "တနင်္လာ\0", "အင်္ဂါ\0", "ဗုဒ္ဓဟူး\0", "ကြာသပတေး\0", "သောကြာ\0", "စနေ\0", "တနင်္ဂနွေ\0" },
        { "တနင်္လာ\0", "အင်္ဂါ\0", "ဗုဒ္ဓဟူး\0", "ကြာသပတေး\0", "သောကြာ\0", "စနေ\0", "တနင်္ဂနွေ\0" },
        { "တ\0", "အ\0", "ဗ\0", "က\0", "သ\0", "စ\0", "တ\0" }
    }, // my_MM
    {
        QLocale::Language::Mazanderani, QLocale::Script::ArabicScript, QLocale::Country::Iran,
        Qt::Saturday, Qt::Friday, Qt::Friday,
        46, 44, 59, 37, 45, 43, 69, 1776,
        "مازرونی\0", "ایران\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "ژانویه\0", "فوریه\0", "مارس\0", "آوریل\0", "مه\0", "ژوئن\0", "ژوئیه\0", "اوت\0", "سپتامبر\0", "اکتبر\0", "نوامبر\0", "دسامبر\0" },
        { "ژانویه\0", "فوریه\0", "مارس\0", "آوریل\0", "مه\0", "ژوئن\0", "ژوئیه\0", "اوت\0", "سپتامبر\0", "اکتبر\0", "نوامبر\0", "دسامبر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ژانویه\0", "فوریه\0", "مارس\0", "آوریل\0", "مه\0", "ژوئن\0", "ژوئیه\0", "اوت\0", "سپتامبر\0", "اکتبر\0", "نوامبر\0", "دسامبر\0" },
        { "ژانویه\0", "فوریه\0", "مارس\0", "آوریل\0", "مه\0", "ژوئن\0", "ژوئیه\0", "اوت\0", "سپتامبر\0", "اکتبر\0", "نوامبر\0", "دسامبر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // mzn_IR
    {
        QLocale::Language::Nama, QLocale::Script::LatinScript, QLocale::Country::Namibia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Khoekhoegowab\0", "Namibiab\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "ǁgoagas\0", "ǃuias\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "ǃKhanni\0", "ǃKhanǀgôab\0", "ǀKhuuǁkhâb\0", "ǃHôaǂkhaib\0", "ǃKhaitsâb\0", "Gamaǀaeb\0", "ǂKhoesaob\0", "Aoǁkhuumûǁkhâb\0", "Taraǀkhuumûǁkhâb\0", "ǂNûǁnâiseb\0", "ǀHooǂgaeb\0", "Hôasoreǁkhâb\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "E\0", "W\0", "D\0", "F\0", "A\0", "S\0" },
        { "Ma\0", "De\0", "Wu\0", "Do\0", "Fr\0", "Sat\0", "Son\0" },
        { "Mantaxtsees\0", "Denstaxtsees\0", "Wunstaxtsees\0", "Dondertaxtsees\0", "Fraitaxtsees\0", "Satertaxtsees\0", "Sontaxtsees\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // naq_NA
    {
        QLocale::Language::NorwegianBokmal, QLocale::Script::LatinScript, QLocale::Country::Norway,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        nullptr, nullptr,
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "M01\0", "M02\0", "M03\0", "M04\0", "M05\0", "M06\0", "M07\0", "M08\0", "M09\0", "M10\0", "M11\0", "M12\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // nb_NO
    {
        QLocale::Language::NorwegianBokmal, QLocale::Script::LatinScript, QLocale::Country::SvalbardAndJanMayen,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        nullptr, nullptr,
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "M01\0", "M02\0", "M03\0", "M04\0", "M05\0", "M06\0", "M07\0", "M08\0", "M09\0", "M10\0", "M11\0", "M12\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // nb_SJ
    {
        QLocale::Language::NorthNdebele, QLocale::Script::LatinScript, QLocale::Country::Zimbabwe,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "isiNdebele\0", "Zimbabwe\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "Z\0", "N\0", "M\0", "M\0", "N\0", "N\0", "N\0", "N\0", "M\0", "M\0", "L\0", "M\0" },
        { "Zib\0", "Nhlo\0", "Mbi\0", "Mab\0", "Nkw\0", "Nhla\0", "Ntu\0", "Ncw\0", "Mpan\0", "Mfu\0", "Lwe\0", "Mpal\0" },
        { "Zibandlela\0", "Nhlolanja\0", "Mbimbitho\0", "Mabasa\0", "Nkwenkwezi\0", "Nhlangula\0", "Ntulikazi\0", "Ncwabakazi\0", "Mpandula\0", "Mfumfu\0", "Lwezi\0", "Mpalakazi\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "S\0", "S\0", "S\0", "S\0", "M\0", "S\0" },
        { "Mvu\0", "Sib\0", "Sit\0", "Sin\0", "Sih\0", "Mgq\0", "Son\0" },
        { "Mvulo\0", "Sibili\0", "Sithathu\0", "Sine\0", "Sihlanu\0", "Mgqibelo\0", "Sonto\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // nd_ZW
    {
        QLocale::Language::LowGerman, QLocale::Script::LatinScript, QLocale::Country::Germany,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Neddersass’sch\0", "Düütschland\0",
        "d.MM.yyyy\0", "d. MMMM yyyy\0", "'h'. H.mm\0", "'hodddH' H.mm:ss (Z)\0",
        "vm\0", "nm\0",
        { "Jan.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Januaar\0", "Februaar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktover\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Januaar\0", "Februaar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktover\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Ma.\0", "Di.\0", "Mi.\0", "Du.\0", "Fr.\0", "Sa.\0", "Sü.\0" },
        { "Maandag\0", "Dingsdag\0", "Middeweken\0", "Dunnersdag\0", "Freedag\0", "Sünnavend\0", "Sünndag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Ma.\0", "Di.\0", "Mi.\0", "Du.\0", "Fr.\0", "Sa.\0", "Sü.\0" },
        { "Maandag\0", "Dingsdag\0", "Middeweken\0", "Dunnersdag\0", "Freedag\0", "Sünnavend\0", "Sünndag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" }
    }, // nds_DE
    {
        QLocale::Language::LowGerman, QLocale::Script::LatinScript, QLocale::Country::Netherlands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Neddersass’sch\0", "Nedderlannen\0",
        "d.MM.yyyy\0", "d. MMMM yyyy\0", "'h'. H.mm\0", "'hodddH' H.mm:ss (Z)\0",
        "vm\0", "nm\0",
        { "Jan.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Januaar\0", "Februaar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktover\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan.\0", "Feb.\0", "März\0", "Apr.\0", "Mai\0", "Juni\0", "Juli\0", "Aug.\0", "Sep.\0", "Okt.\0", "Nov.\0", "Dez.\0" },
        { "Januaar\0", "Februaar\0", "März\0", "April\0", "Mai\0", "Juni\0", "Juli\0", "August\0", "September\0", "Oktover\0", "November\0", "Dezember\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Ma.\0", "Di.\0", "Mi.\0", "Du.\0", "Fr.\0", "Sa.\0", "Sü.\0" },
        { "Maandag\0", "Dingsdag\0", "Middeweken\0", "Dunnersdag\0", "Freedag\0", "Sünnavend\0", "Sünndag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" },
        { "Ma.\0", "Di.\0", "Mi.\0", "Du.\0", "Fr.\0", "Sa.\0", "Sü.\0" },
        { "Maandag\0", "Dingsdag\0", "Middeweken\0", "Dunnersdag\0", "Freedag\0", "Sünnavend\0", "Sünndag\0" },
        { "M\0", "D\0", "M\0", "D\0", "F\0", "S\0", "S\0" }
    }, // nds_NL
    {
        QLocale::Language::Nepali, QLocale::Script::AnyScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 2406,
        "नेपाली\0", "भारत\0",
        "yyyy/M/d\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "पूर्वाह्न\0", "अपराह्न\0",
        { "जनवरी\0", "फेब्रुअरी\0", "मार्च\0", "अप्रिल\0", "मे\0", "जुन\0", "जुलाई\0", "अगस्ट\0", "सेप्टेम्बर\0", "अक्टोबर\0", "नोभेम्बर\0", "डिसेम्बर\0" },
        { "जनवरी\0", "फेब्रुअरी\0", "मार्च\0", "अप्रिल\0", "मे\0", "जुन\0", "जुलाई\0", "अगस्ट\0", "सेप्टेम्बर\0", "अक्टोबर\0", "नोभेम्बर\0", "डिसेम्बर\0" },
        { "जन\0", "फेेब\0", "मार्च\0", "अप्र\0", "मे\0", "जुन\0", "जुल\0", "अग\0", "सेप\0", "अक्टो\0", "नोभे\0", "डिसे\0" },
        { "जनवरी\0", "फेब्रुअरी\0", "मार्च\0", "अप्रिल\0", "मे\0", "जुन\0", "जुलाई\0", "अगस्ट\0", "सेप्टेम्बर\0", "अक्टोबर\0", "नोभेम्बर\0", "डिसेम्बर\0" },
        { "जनवरी\0", "फेब्रुअरी\0", "मार्च\0", "अप्रिल\0", "मे\0", "जुन\0", "जुलाई\0", "अगस्ट\0", "सेप्टेम्बर\0", "अक्टोबर\0", "नोभेम्बर\0", "डिसेम्बर\0" },
        { "जन\0", "फेब\0", "मार्च\0", "अप्र\0", "मे\0", "जुन\0", "जुल\0", "अग\0", "सेप\0", "अक्टो\0", "नोभे\0", "डिसे\0" },
        { "सोम\0", "मङ्गल\0", "बुध\0", "बिहि\0", "शुक्र\0", "शनि\0", "आइत\0" },
        { "सोमबार\0", "मङ्गलबार\0", "बुधबार\0", "बिहिबार\0", "शुक्रबार\0", "शनिबार\0", "आइतबार\0" },
        { "सो\0", "म\0", "बु\0", "बि\0", "शु\0", "श\0", "आ\0" },
        { "सोम\0", "मङ्गल\0", "बुध\0", "बिहि\0", "शुक्र\0", "शनि\0", "आइत\0" },
        { "सोमबार\0", "मङ्गलबार\0", "बुधबार\0", "बिहिबार\0", "शुक्रबार\0", "शनिबार\0", "आइतबार\0" },
        { "सो\0", "म\0", "बु\0", "बि\0", "शु\0", "श\0", "आ\0" }
    }, // ne_IN
    {
        QLocale::Language::Nepali, QLocale::Script::DevanagariScript, QLocale::Country::Nepal,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 2406,
        "नेपाली\0", "नेपाल\0",
        "yyyy/M/d\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "पूर्वाह्न\0", "अपराह्न\0",
        { "जनवरी\0", "फेब्रुअरी\0", "मार्च\0", "अप्रिल\0", "मे\0", "जुन\0", "जुलाई\0", "अगस्ट\0", "सेप्टेम्बर\0", "अक्टोबर\0", "नोभेम्बर\0", "डिसेम्बर\0" },
        { "जनवरी\0", "फेब्रुअरी\0", "मार्च\0", "अप्रिल\0", "मे\0", "जुन\0", "जुलाई\0", "अगस्ट\0", "सेप्टेम्बर\0", "अक्टोबर\0", "नोभेम्बर\0", "डिसेम्बर\0" },
        { "जन\0", "फेेब\0", "मार्च\0", "अप्र\0", "मे\0", "जुन\0", "जुल\0", "अग\0", "सेप\0", "अक्टो\0", "नोभे\0", "डिसे\0" },
        { "जनवरी\0", "फेब्रुअरी\0", "मार्च\0", "अप्रिल\0", "मे\0", "जुन\0", "जुलाई\0", "अगस्ट\0", "सेप्टेम्बर\0", "अक्टोबर\0", "नोभेम्बर\0", "डिसेम्बर\0" },
        { "जनवरी\0", "फेब्रुअरी\0", "मार्च\0", "अप्रिल\0", "मे\0", "जुन\0", "जुलाई\0", "अगस्ट\0", "सेप्टेम्बर\0", "अक्टोबर\0", "नोभेम्बर\0", "डिसेम्बर\0" },
        { "जन\0", "फेब\0", "मार्च\0", "अप्र\0", "मे\0", "जुन\0", "जुल\0", "अग\0", "सेप\0", "अक्टो\0", "नोभे\0", "डिसे\0" },
        { "सोम\0", "मङ्गल\0", "बुध\0", "बिहि\0", "शुक्र\0", "शनि\0", "आइत\0" },
        { "सोमबार\0", "मङ्गलबार\0", "बुधबार\0", "बिहिबार\0", "शुक्रबार\0", "शनिबार\0", "आइतबार\0" },
        { "सो\0", "म\0", "बु\0", "बि\0", "शु\0", "श\0", "आ\0" },
        { "सोम\0", "मङ्गल\0", "बुध\0", "बिहि\0", "शुक्र\0", "शनि\0", "आइत\0" },
        { "सोमबार\0", "मङ्गलबार\0", "बुधबार\0", "बिहिबार\0", "शुक्रबार\0", "शनिबार\0", "आइतबार\0" },
        { "सो\0", "म\0", "बु\0", "बि\0", "शु\0", "श\0", "आ\0" }
    }, // ne_NP
    {
        QLocale::Language::Dutch, QLocale::Script::LatinScript, QLocale::Country::Aruba,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Nederlands\0", "Aruba\0",
        "dd-MM-yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" }
    }, // nl_AW
    {
        QLocale::Language::Dutch, QLocale::Script::LatinScript, QLocale::Country::Belgium,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Nederlands\0", "België\0",
        "d/MM/yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" }
    }, // nl_BE
    {
        QLocale::Language::Dutch, QLocale::Script::LatinScript, QLocale::Country::CaribbeanNetherlands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Nederlands\0", "Caribisch Nederland\0",
        "dd-MM-yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" }
    }, // nl_BQ
    {
        QLocale::Language::Dutch, QLocale::Script::LatinScript, QLocale::Country::Curacao,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Nederlands\0", "Curaçao\0",
        "dd-MM-yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" }
    }, // nl_CW
    {
        QLocale::Language::Dutch, QLocale::Script::LatinScript, QLocale::Country::Netherlands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Nederlands\0", "Nederland\0",
        "dd-MM-yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" }
    }, // nl_NL
    {
        QLocale::Language::Dutch, QLocale::Script::LatinScript, QLocale::Country::Suriname,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Nederlands\0", "Suriname\0",
        "dd-MM-yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" }
    }, // nl_SR
    {
        QLocale::Language::Dutch, QLocale::Script::LatinScript, QLocale::Country::SintMaarten,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Nederlands\0", "Sint-Maarten\0",
        "dd-MM-yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mrt.\0", "apr.\0", "mei\0", "jun.\0", "jul.\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "maart\0", "april\0", "mei\0", "juni\0", "juli\0", "augustus\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" },
        { "ma\0", "di\0", "wo\0", "do\0", "vr\0", "za\0", "zo\0" },
        { "maandag\0", "dinsdag\0", "woensdag\0", "donderdag\0", "vrijdag\0", "zaterdag\0", "zondag\0" },
        { "M\0", "D\0", "W\0", "D\0", "V\0", "Z\0", "Z\0" }
    }, // nl_SX
    {
        QLocale::Language::Kwasio, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Kwasio\0", "Kamerun\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "maná\0", "kugú\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ng1\0", "ng2\0", "ng3\0", "ng4\0", "ng5\0", "ng6\0", "ng7\0", "ng8\0", "ng9\0", "ng10\0", "ng11\0", "kris\0" },
        { "ngwɛn matáhra\0", "ngwɛn ńmba\0", "ngwɛn ńlal\0", "ngwɛn ńna\0", "ngwɛn ńtan\0", "ngwɛn ńtuó\0", "ngwɛn hɛmbuɛrí\0", "ngwɛn lɔmbi\0", "ngwɛn rɛbvuâ\0", "ngwɛn wum\0", "ngwɛn wum navǔr\0", "krísimin\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "m\0", "s\0", "s\0", "s\0", "m\0", "s\0", "s\0" },
        { "mɔ́n\0", "smb\0", "sml\0", "smn\0", "mbs\0", "sas\0", "sɔ́n\0" },
        { "mɔ́ndɔ\0", "sɔ́ndɔ mafú mába\0", "sɔ́ndɔ mafú málal\0", "sɔ́ndɔ mafú mána\0", "mabágá má sukul\0", "sásadi\0", "sɔ́ndɔ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // nmg_CM
    {
        QLocale::Language::NorwegianNynorsk, QLocale::Script::LatinScript, QLocale::Country::Norway,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        nullptr, "Noreg\0",
        "dd.MM.yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "jan.\0", "feb.\0", "mars\0", "apr.\0", "mai\0", "juni\0", "juli\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "des.\0" },
        { "M01\0", "M02\0", "M03\0", "M04\0", "M05\0", "M06\0", "M07\0", "M08\0", "M09\0", "M10\0", "M11\0", "M12\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "mån\0", "tys\0", "ons\0", "tor\0", "fre\0", "lau\0", "søn\0" },
        { "måndag\0", "tysdag\0", "onsdag\0", "torsdag\0", "fredag\0", "laurdag\0", "søndag\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "må.\0", "ty.\0", "on.\0", "to.\0", "fr.\0", "la.\0", "sø.\0" },
        { "måndag\0", "tysdag\0", "onsdag\0", "torsdag\0", "fredag\0", "laurdag\0", "søndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" }
    }, // nn_NO
    {
        QLocale::Language::Ngiemboon, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Shwóŋò ngiembɔɔn\0", "Kàmalûm\0",
        "dd/MM/yyyy\0", "'yyyyɛ'̌ʼ d 'nAP' MMMM, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "mbaʼámbaʼ\0", "ncwònzém\0",
        { "saŋ tsetsɛ̀ɛ lùm\0", "saŋ kàg ngwóŋ\0", "saŋ lepyè shúm\0", "saŋ cÿó\0", "saŋ tsɛ̀ɛ cÿó\0", "saŋ njÿoláʼ\0", "saŋ tyɛ̀b tyɛ̀b mbʉ̀ŋ\0", "saŋ mbʉ̀ŋ\0", "saŋ ngwɔ̀ʼ mbÿɛ\0", "saŋ tàŋa tsetsáʼ\0", "saŋ mejwoŋó\0", "saŋ lùm\0" },
        { "saŋ tsetsɛ̀ɛ lùm\0", "saŋ kàg ngwóŋ\0", "saŋ lepyè shúm\0", "saŋ cÿó\0", "saŋ tsɛ̀ɛ cÿó\0", "saŋ njÿoláʼ\0", "saŋ tyɛ̀b tyɛ̀b mbʉ̀ŋ\0", "saŋ mbʉ̀ŋ\0", "saŋ ngwɔ̀ʼ mbÿɛ\0", "saŋ tàŋa tsetsáʼ\0", "saŋ mejwoŋó\0", "saŋ lùm\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "saŋ tsetsɛ̀ɛ lùm\0", "saŋ kàg ngwóŋ\0", "saŋ lepyè shúm\0", "saŋ cÿó\0", "saŋ tsɛ̀ɛ cÿó\0", "saŋ njÿoláʼ\0", "saŋ tyɛ̀b tyɛ̀b mbʉ̀ŋ\0", "saŋ mbʉ̀ŋ\0", "saŋ ngwɔ̀ʼ mbÿɛ\0", "saŋ tàŋa tsetsáʼ\0", "saŋ mejwoŋó\0", "saŋ lùm\0" },
        { "saŋ tsetsɛ̀ɛ lùm\0", "saŋ kàg ngwóŋ\0", "saŋ lepyè shúm\0", "saŋ cÿó\0", "saŋ tsɛ̀ɛ cÿó\0", "saŋ njÿoláʼ\0", "saŋ tyɛ̀b tyɛ̀b mbʉ̀ŋ\0", "saŋ mbʉ̀ŋ\0", "saŋ ngwɔ̀ʼ mbÿɛ\0", "saŋ tàŋa tsetsáʼ\0", "saŋ mejwoŋó\0", "saŋ lùm\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "mvfò lyɛ̌ʼ\0", "mbɔ́ɔntè mvfò lyɛ̌ʼ\0", "tsètsɛ̀ɛ lyɛ̌ʼ\0", "mbɔ́ɔntè tsetsɛ̀ɛ lyɛ̌ʼ\0", "mvfò màga lyɛ̌ʼ\0", "màga lyɛ̌ʼ\0", "lyɛʼɛ́ sẅíŋtè\0" },
        { "mvfò lyɛ̌ʼ\0", "mbɔ́ɔntè mvfò lyɛ̌ʼ\0", "tsètsɛ̀ɛ lyɛ̌ʼ\0", "mbɔ́ɔntè tsetsɛ̀ɛ lyɛ̌ʼ\0", "mvfò màga lyɛ̌ʼ\0", "màga lyɛ̌ʼ\0", "lyɛʼɛ́ sẅíŋtè\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "mvfò lyɛ̌ʼ\0", "mbɔ́ɔntè mvfò lyɛ̌ʼ\0", "tsètsɛ̀ɛ lyɛ̌ʼ\0", "mbɔ́ɔntè tsetsɛ̀ɛ lyɛ̌ʼ\0", "mvfò màga lyɛ̌ʼ\0", "màga lyɛ̌ʼ\0", "lyɛʼɛ́ sẅíŋtè\0" },
        { "mvfò lyɛ̌ʼ\0", "mbɔ́ɔntè mvfò lyɛ̌ʼ\0", "tsètsɛ̀ɛ lyɛ̌ʼ\0", "mbɔ́ɔntè tsetsɛ̀ɛ lyɛ̌ʼ\0", "mvfò màga lyɛ̌ʼ\0", "màga lyɛ̌ʼ\0", "lyɛʼɛ́ sẅíŋtè\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // nnh_CM
    {
        QLocale::Language::Nuer, QLocale::Script::LatinScript, QLocale::Country::SouthSudan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Thok Nath\0", nullptr,
        "d/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "Z h:mm:ss AP\0",
        "RW\0", "TŊ\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "T\0", "P\0", "D\0", "G\0", "D\0", "K\0", "P\0", "T\0", "T\0", "L\0", "K\0", "T\0" },
        { "Tiop\0", "Pɛt\0", "Duɔ̱ɔ̱\0", "Guak\0", "Duä\0", "Kor\0", "Pay\0", "Thoo\0", "Tɛɛ\0", "Laa\0", "Kur\0", "Tid\0" },
        { "Tiop thar pɛt\0", "Pɛt\0", "Duɔ̱ɔ̱ŋ\0", "Guak\0", "Duät\0", "Kornyoot\0", "Pay yie̱tni\0", "Tho̱o̱r\0", "Tɛɛr\0", "Laath\0", "Kur\0", "Tio̱p in di̱i̱t\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "J\0", "R\0", "D\0", "Ŋ\0", "D\0", "B\0", "C\0" },
        { "Jiec\0", "Rɛw\0", "Diɔ̱k\0", "Ŋuaan\0", "Dhieec\0", "Bäkɛl\0", "Cäŋ\0" },
        { "Jiec la̱t\0", "Rɛw lätni\0", "Diɔ̱k lätni\0", "Ŋuaan lätni\0", "Dhieec lätni\0", "Bäkɛl lätni\0", "Cäŋ kuɔth\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // nus_SS
    {
        QLocale::Language::Nyankole, QLocale::Script::LatinScript, QLocale::Country::Uganda,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Runyankore\0", "Uganda\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "KBZ\0", "KBR\0", "KST\0", "KKN\0", "KTN\0", "KMK\0", "KMS\0", "KMN\0", "KMW\0", "KKM\0", "KNK\0", "KNB\0" },
        { "Okwokubanza\0", "Okwakabiri\0", "Okwakashatu\0", "Okwakana\0", "Okwakataana\0", "Okwamukaaga\0", "Okwamushanju\0", "Okwamunaana\0", "Okwamwenda\0", "Okwaikumi\0", "Okwaikumi na kumwe\0", "Okwaikumi na ibiri\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "K\0", "R\0", "S\0", "N\0", "T\0", "M\0", "S\0" },
        { "ORK\0", "OKB\0", "OKS\0", "OKN\0", "OKT\0", "OMK\0", "SAN\0" },
        { "Orwokubanza\0", "Orwakabiri\0", "Orwakashatu\0", "Orwakana\0", "Orwakataano\0", "Orwamukaaga\0", "Sande\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // nyn_UG
    {
        QLocale::Language::Oromo, QLocale::Script::LatinScript, QLocale::Country::Ethiopia,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Oromoo\0", "Itoophiyaa\0",
        "dd/MM/yyyy\0", "dd MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "WD\0", "WB\0",
        { "Ama\0", "Gur\0", "Bit\0", "Elb\0", "Cam\0", "Wax\0", "Ado\0", "Hag\0", "Ful\0", "Onk\0", "Sad\0", "Mud\0" },
        { "Amajjii\0", "Guraandhala\0", "Bitooteessa\0", "Elba\0", "Caamsa\0", "Waxabajjii\0", "Adooleessa\0", "Hagayya\0", "Fuulbana\0", "Onkololeessa\0", "Sadaasa\0", "Muddee\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Ama\0", "Gur\0", "Bit\0", "Elb\0", "Cam\0", "Wax\0", "Ado\0", "Hag\0", "Ful\0", "Onk\0", "Sad\0", "Mud\0" },
        { "Amajjii\0", "Guraandhala\0", "Bitooteessa\0", "Elba\0", "Caamsa\0", "Waxabajjii\0", "Adooleessa\0", "Hagayya\0", "Fuulbana\0", "Onkololeessa\0", "Sadaasa\0", "Muddee\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Wix\0", "Qib\0", "Rob\0", "Kam\0", "Jim\0", "San\0", "Dil\0" },
        { "Wiixata\0", "Qibxata\0", "Roobii\0", "Kamiisa\0", "Jimaata\0", "Sanbata\0", "Dilbata\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Wix\0", "Qib\0", "Rob\0", "Kam\0", "Jim\0", "San\0", "Dil\0" },
        { "Wiixata\0", "Qibxata\0", "Roobii\0", "Kamiisa\0", "Jimaata\0", "Sanbata\0", "Dilbata\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // om_ET
    {
        QLocale::Language::Oromo, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Oromoo\0", "Keeniyaa\0",
        "dd/MM/yyyy\0", "dd MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "WD\0", "WB\0",
        { "Ama\0", "Gur\0", "Bit\0", "Elb\0", "Cam\0", "Wax\0", "Ado\0", "Hag\0", "Ful\0", "Onk\0", "Sad\0", "Mud\0" },
        { "Amajjii\0", "Guraandhala\0", "Bitooteessa\0", "Elba\0", "Caamsa\0", "Waxabajjii\0", "Adooleessa\0", "Hagayya\0", "Fuulbana\0", "Onkololeessa\0", "Sadaasa\0", "Muddee\0" },
        { "A\0", "G\0", "B\0", "E\0", "C\0", "W\0", "A\0", "H\0", "F\0", "O\0", "S\0", "M\0" },
        { "Ama\0", "Gur\0", "Bit\0", "Elb\0", "Cam\0", "Wax\0", "Ado\0", "Hag\0", "Ful\0", "Onk\0", "Sad\0", "Mud\0" },
        { "Amajjii\0", "Guraandhala\0", "Bitooteessa\0", "Elba\0", "Caamsa\0", "Waxabajjii\0", "Adooleessa\0", "Hagayya\0", "Fuulbana\0", "Onkololeessa\0", "Sadaasa\0", "Muddee\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Wix\0", "Qib\0", "Rob\0", "Kam\0", "Jim\0", "San\0", "Dil\0" },
        { "Wiixata\0", "Qibxata\0", "Roobii\0", "Kamiisa\0", "Jimaata\0", "Sanbata\0", "Dilbata\0" },
        { "W\0", "Q\0", "R\0", "K\0", "J\0", "S\0", "D\0" },
        { "Wix\0", "Qib\0", "Rob\0", "Kam\0", "Jim\0", "San\0", "Dil\0" },
        { "Wiixata\0", "Qibxata\0", "Roobii\0", "Kamiisa\0", "Jimaata\0", "Sanbata\0", "Dilbata\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // om_KE
    {
        QLocale::Language::Odia, QLocale::Script::OdiaScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ଓଡ଼ିଆ\0", "ଭାରତ\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "ଜାନୁଆରୀ\0", "ଫେବୃଆରୀ\0", "ମାର୍ଚ୍ଚ\0", "ଅପ୍ରେଲ\0", "ମଇ\0", "ଜୁନ\0", "ଜୁଲାଇ\0", "ଅଗଷ୍ଟ\0", "ସେପ୍ଟେମ୍ବର\0", "ଅକ୍ଟୋବର\0", "ନଭେମ୍ବର\0", "ଡିସେମ୍ବର\0" },
        { "ଜାନୁଆରୀ\0", "ଫେବୃଆରୀ\0", "ମାର୍ଚ୍ଚ\0", "ଅପ୍ରେଲ\0", "ମଇ\0", "ଜୁନ\0", "ଜୁଲାଇ\0", "ଅଗଷ୍ଟ\0", "ସେପ୍ଟେମ୍ବର\0", "ଅକ୍ଟୋବର\0", "ନଭେମ୍ବର\0", "ଡିସେମ୍ବର\0" },
        { "ଜା\0", "ଫେ\0", "ମା\0", "ଅ\0", "ମଇ\0", "ଜୁ\0", "ଜୁ\0", "ଅ\0", "ସେ\0", "ଅ\0", "ନ\0", "ଡି\0" },
        { "ଜାନୁଆରୀ\0", "ଫେବୃଆରୀ\0", "ମାର୍ଚ୍ଚ\0", "ଅପ୍ରେଲ\0", "ମଇ\0", "ଜୁନ\0", "ଜୁଲାଇ\0", "ଅଗଷ୍ଟ\0", "ସେପ୍ଟେମ୍ବର\0", "ଅକ୍ଟୋବର\0", "ନଭେମ୍ବର\0", "ଡିସେମ୍ବର\0" },
        { "ଜାନୁଆରୀ\0", "ଫେବୃଆରୀ\0", "ମାର୍ଚ୍ଚ\0", "ଅପ୍ରେଲ\0", "ମଇ\0", "ଜୁନ\0", "ଜୁଲାଇ\0", "ଅଗଷ୍ଟ\0", "ସେପ୍ଟେମ୍ବର\0", "ଅକ୍ଟୋବର\0", "ନଭେମ୍ବର\0", "ଡିସେମ୍ବର\0" },
        { "ଜା\0", "ଫେ\0", "ମା\0", "ଅ\0", "ମଇ\0", "ଜୁ\0", "ଜୁ\0", "ଅ\0", "ସେ\0", "ଅ\0", "ନ\0", "ଡି\0" },
        { "ସୋମ\0", "ମଙ୍ଗଳ\0", "ବୁଧ\0", "ଗୁରୁ\0", "ଶୁକ୍ର\0", "ଶନି\0", "ରବି\0" },
        { "ସୋମବାର\0", "ମଙ୍ଗଳବାର\0", "ବୁଧବାର\0", "ଗୁରୁବାର\0", "ଶୁକ୍ରବାର\0", "ଶନିବାର\0", "ରବିବାର\0" },
        { "ସୋ\0", "ମ\0", "ବୁ\0", "ଗୁ\0", "ଶୁ\0", "ଶ\0", "ର\0" },
        { "ସୋମ\0", "ମଙ୍ଗଳ\0", "ବୁଧ\0", "ଗୁରୁ\0", "ଶୁକ୍ର\0", "ଶନି\0", "ରବି\0" },
        { "ସୋମବାର\0", "ମଙ୍ଗଳବାର\0", "ବୁଧବାର\0", "ଗୁରୁବାର\0", "ଶୁକ୍ରବାର\0", "ଶନିବାର\0", "ରବିବାର\0" },
        { "ସୋ\0", "ମ\0", "ବୁ\0", "ଗୁ\0", "ଶୁ\0", "ଶ\0", "ର\0" }
    }, // or_IN
    {
        QLocale::Language::Ossetic, QLocale::Script::CyrillicScript, QLocale::Country::Georgia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "ирон\0", "Гуырдзыстон\0",
        "dd.MM.yyyy\0", "d MMMM, yyyy 'аз'\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ӕмбисбоны размӕ\0", "ӕмбисбоны фӕстӕ\0",
        { "Янв.\0", "Февр.\0", "Март.\0", "Апр.\0", "Май\0", "Июнь\0", "Июль\0", "Авг.\0", "Сент.\0", "Окт.\0", "Нояб.\0", "Дек.\0" },
        { "Январь\0", "Февраль\0", "Мартъи\0", "Апрель\0", "Май\0", "Июнь\0", "Июль\0", "Август\0", "Сентябрь\0", "Октябрь\0", "Ноябрь\0", "Декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "янв.\0", "фев.\0", "мар.\0", "апр.\0", "майы\0", "июны\0", "июлы\0", "авг.\0", "сен.\0", "окт.\0", "ноя.\0", "дек.\0" },
        { "январы\0", "февралы\0", "мартъийы\0", "апрелы\0", "майы\0", "июны\0", "июлы\0", "августы\0", "сентябры\0", "октябры\0", "ноябры\0", "декабры\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "Крс\0", "Дцг\0", "Ӕрт\0", "Цпр\0", "Мрб\0", "Сбт\0", "Хцб\0" },
        { "Къуырисӕр\0", "Дыццӕг\0", "Ӕрыццӕг\0", "Цыппӕрӕм\0", "Майрӕмбон\0", "Сабат\0", "Хуыцаубон\0" },
        { "К\0", "Д\0", "Ӕ\0", "Ц\0", "М\0", "С\0", "Х\0" },
        { "крс\0", "дцг\0", "ӕрт\0", "цпр\0", "мрб\0", "сбт\0", "хцб\0" },
        { "къуырисӕр\0", "дыццӕг\0", "ӕртыццӕг\0", "цыппӕрӕм\0", "майрӕмбон\0", "сабат\0", "хуыцаубон\0" },
        { "К\0", "Д\0", "Ӕ\0", "Ц\0", "М\0", "С\0", "Х\0" }
    }, // os_GE
    {
        QLocale::Language::Ossetic, QLocale::Script::CyrillicScript, QLocale::Country::Russia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "ирон\0", "Уӕрӕсе\0",
        "dd.MM.yyyy\0", "d MMMM, yyyy 'аз'\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ӕмбисбоны размӕ\0", "ӕмбисбоны фӕстӕ\0",
        { "Янв.\0", "Февр.\0", "Март.\0", "Апр.\0", "Май\0", "Июнь\0", "Июль\0", "Авг.\0", "Сент.\0", "Окт.\0", "Нояб.\0", "Дек.\0" },
        { "Январь\0", "Февраль\0", "Мартъи\0", "Апрель\0", "Май\0", "Июнь\0", "Июль\0", "Август\0", "Сентябрь\0", "Октябрь\0", "Ноябрь\0", "Декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "янв.\0", "фев.\0", "мар.\0", "апр.\0", "майы\0", "июны\0", "июлы\0", "авг.\0", "сен.\0", "окт.\0", "ноя.\0", "дек.\0" },
        { "январы\0", "февралы\0", "мартъийы\0", "апрелы\0", "майы\0", "июны\0", "июлы\0", "августы\0", "сентябры\0", "октябры\0", "ноябры\0", "декабры\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "Крс\0", "Дцг\0", "Ӕрт\0", "Цпр\0", "Мрб\0", "Сбт\0", "Хцб\0" },
        { "Къуырисӕр\0", "Дыццӕг\0", "Ӕртыццӕг\0", "Цыппӕрӕм\0", "Майрӕмбон\0", "Сабат\0", "Хуыцаубон\0" },
        { "К\0", "Д\0", "Ӕ\0", "Ц\0", "М\0", "С\0", "Х\0" },
        { "крс\0", "дцг\0", "ӕрт\0", "цпр\0", "мрб\0", "сбт\0", "хцб\0" },
        { "къуырисӕр\0", "дыццӕг\0", "ӕртыццӕг\0", "цыппӕрӕм\0", "майрӕмбон\0", "сабат\0", "хуыцаубон\0" },
        { "К\0", "Д\0", "Ӕ\0", "Ц\0", "М\0", "С\0", "Х\0" }
    }, // os_RU
    {
        QLocale::Language::Punjabi, QLocale::Script::ArabicScript, QLocale::Country::Pakistan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ਪੰਜਾਬੀ\0", "ਪਾਕਿਸਤਾਨ\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "ਪੂ.ਦੁ.\0", "ਬਾ.ਦੁ.\0",
        { "ਜਨ\0", "ਫ਼ਰ\0", "ਮਾਰਚ\0", "ਅਪ੍ਰੈ\0", "ਮਈ\0", "ਜੂਨ\0", "ਜੁਲਾ\0", "ਅਗ\0", "ਸਤੰ\0", "ਅਕਤੂ\0", "ਨਵੰ\0", "ਦਸੰ\0" },
        { "ਜਨਵਰੀ\0", "ਫ਼ਰਵਰੀ\0", "ਮਾਰਚ\0", "ਅਪ੍ਰੈਲ\0", "ਮਈ\0", "ਜੂਨ\0", "ਜੁਲਾਈ\0", "ਅਗਸਤ\0", "ਸਤੰਬਰ\0", "ਅਕਤੂਬਰ\0", "ਨਵੰਬਰ\0", "ਦਸੰਬਰ\0" },
        { "ਜ\0", "ਫ਼\0", "ਮਾ\0", "ਅ\0", "ਮ\0", "ਜੂ\0", "ਜੁ\0", "ਅ\0", "ਸ\0", "ਅ\0", "ਨ\0", "ਦ\0" },
        { "ਜਨ\0", "ਫ਼ਰ\0", "ਮਾਰਚ\0", "ਅਪ੍ਰੈ\0", "ਮਈ\0", "ਜੂਨ\0", "ਜੁਲਾ\0", "ਅਗ\0", "ਸਤੰ\0", "ਅਕਤੂ\0", "ਨਵੰ\0", "ਦਸੰ\0" },
        { "ਜਨਵਰੀ\0", "ਫ਼ਰਵਰੀ\0", "ਮਾਰਚ\0", "ਅਪ੍ਰੈਲ\0", "ਮਈ\0", "ਜੂਨ\0", "ਜੁਲਾਈ\0", "ਅਗਸਤ\0", "ਸਤੰਬਰ\0", "ਅਕਤੂਬਰ\0", "ਨਵੰਬਰ\0", "ਦਸੰਬਰ\0" },
        { "ਜ\0", "ਫ਼\0", "ਮਾ\0", "ਅ\0", "ਮ\0", "ਜੂ\0", "ਜੁ\0", "ਅ\0", "ਸ\0", "ਅ\0", "ਨ\0", "ਦ\0" },
        { "ਸੋਮ\0", "ਮੰਗਲ\0", "ਬੁੱਧ\0", "ਵੀਰ\0", "ਸ਼ੁੱਕਰ\0", "ਸ਼ਨਿੱਚਰ\0", "ਐਤ\0" },
        { "ਸੋਮਵਾਰ\0", "ਮੰਗਲਵਾਰ\0", "ਬੁੱਧਵਾਰ\0", "ਵੀਰਵਾਰ\0", "ਸ਼ੁੱਕਰਵਾਰ\0", "ਸ਼ਨਿੱਚਰਵਾਰ\0", "ਐਤਵਾਰ\0" },
        { "ਸੋ\0", "ਮੰ\0", "ਬੁੱ\0", "ਵੀ\0", "ਸ਼ੁੱ\0", "ਸ਼\0", "ਐ\0" },
        { "ਸੋਮ\0", "ਮੰਗਲ\0", "ਬੁੱਧ\0", "ਵੀਰ\0", "ਸ਼ੁੱਕਰ\0", "ਸ਼ਨਿੱਚਰ\0", "ਐਤ\0" },
        { "ਸੋਮਵਾਰ\0", "ਮੰਗਲਵਾਰ\0", "ਬੁੱਧਵਾਰ\0", "ਵੀਰਵਾਰ\0", "ਸ਼ੁੱਕਰਵਾਰ\0", "ਸ਼ਨਿੱਚਰਵਾਰ\0", "ਐਤਵਾਰ\0" },
        { "ਸੋ\0", "ਮੰ\0", "ਬੁੱ\0", "ਵੀ\0", "ਸ਼ੁੱ\0", "ਸ਼\0", "ਐ\0" }
    }, // pa_Arab_PK
    {
        QLocale::Language::Punjabi, QLocale::Script::GurmukhiScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ਪੰਜਾਬੀ\0", "ਭਾਰਤ\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "ਪੂ.ਦੁ.\0", "ਬਾ.ਦੁ.\0",
        { "ਜਨ\0", "ਫ਼ਰ\0", "ਮਾਰਚ\0", "ਅਪ੍ਰੈ\0", "ਮਈ\0", "ਜੂਨ\0", "ਜੁਲਾ\0", "ਅਗ\0", "ਸਤੰ\0", "ਅਕਤੂ\0", "ਨਵੰ\0", "ਦਸੰ\0" },
        { "ਜਨਵਰੀ\0", "ਫ਼ਰਵਰੀ\0", "ਮਾਰਚ\0", "ਅਪ੍ਰੈਲ\0", "ਮਈ\0", "ਜੂਨ\0", "ਜੁਲਾਈ\0", "ਅਗਸਤ\0", "ਸਤੰਬਰ\0", "ਅਕਤੂਬਰ\0", "ਨਵੰਬਰ\0", "ਦਸੰਬਰ\0" },
        { "ਜ\0", "ਫ਼\0", "ਮਾ\0", "ਅ\0", "ਮ\0", "ਜੂ\0", "ਜੁ\0", "ਅ\0", "ਸ\0", "ਅ\0", "ਨ\0", "ਦ\0" },
        { "ਜਨ\0", "ਫ਼ਰ\0", "ਮਾਰਚ\0", "ਅਪ੍ਰੈ\0", "ਮਈ\0", "ਜੂਨ\0", "ਜੁਲਾ\0", "ਅਗ\0", "ਸਤੰ\0", "ਅਕਤੂ\0", "ਨਵੰ\0", "ਦਸੰ\0" },
        { "ਜਨਵਰੀ\0", "ਫ਼ਰਵਰੀ\0", "ਮਾਰਚ\0", "ਅਪ੍ਰੈਲ\0", "ਮਈ\0", "ਜੂਨ\0", "ਜੁਲਾਈ\0", "ਅਗਸਤ\0", "ਸਤੰਬਰ\0", "ਅਕਤੂਬਰ\0", "ਨਵੰਬਰ\0", "ਦਸੰਬਰ\0" },
        { "ਜ\0", "ਫ਼\0", "ਮਾ\0", "ਅ\0", "ਮ\0", "ਜੂ\0", "ਜੁ\0", "ਅ\0", "ਸ\0", "ਅ\0", "ਨ\0", "ਦ\0" },
        { "ਸੋਮ\0", "ਮੰਗਲ\0", "ਬੁੱਧ\0", "ਵੀਰ\0", "ਸ਼ੁੱਕਰ\0", "ਸ਼ਨਿੱਚਰ\0", "ਐਤ\0" },
        { "ਸੋਮਵਾਰ\0", "ਮੰਗਲਵਾਰ\0", "ਬੁੱਧਵਾਰ\0", "ਵੀਰਵਾਰ\0", "ਸ਼ੁੱਕਰਵਾਰ\0", "ਸ਼ਨਿੱਚਰਵਾਰ\0", "ਐਤਵਾਰ\0" },
        { "ਸੋ\0", "ਮੰ\0", "ਬੁੱ\0", "ਵੀ\0", "ਸ਼ੁੱ\0", "ਸ਼\0", "ਐ\0" },
        { "ਸੋਮ\0", "ਮੰਗਲ\0", "ਬੁੱਧ\0", "ਵੀਰ\0", "ਸ਼ੁੱਕਰ\0", "ਸ਼ਨਿੱਚਰ\0", "ਐਤ\0" },
        { "ਸੋਮਵਾਰ\0", "ਮੰਗਲਵਾਰ\0", "ਬੁੱਧਵਾਰ\0", "ਵੀਰਵਾਰ\0", "ਸ਼ੁੱਕਰਵਾਰ\0", "ਸ਼ਨਿੱਚਰਵਾਰ\0", "ਐਤਵਾਰ\0" },
        { "ਸੋ\0", "ਮੰ\0", "ਬੁੱ\0", "ਵੀ\0", "ਸ਼ੁੱ\0", "ਸ਼\0", "ਐ\0" }
    }, // pa_Guru_IN
    {
        QLocale::Language::NigerianPidgin, QLocale::Script::LatinScript, QLocale::Country::Nigeria,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Naijíriá Píjin\0", "Naijíria\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "H:mm:ss Z\0",
        "Fọ mọ́nin\0", "Fọ ívnin\0",
        { "Jén\0", "Fẹ́b\0", "Mach\0", "Épr\0", "Mee\0", "Jun\0", "Jul\0", "Ọ́gọ\0", "Sẹp\0", "Ọkt\0", "Nọv\0", "Dis\0" },
        { "Jénúári\0", "Fẹ́búári\0", "Mach\0", "Éprel\0", "Mee\0", "Jun\0", "Julai\0", "Ọgọst\0", "Sẹptẹ́mba\0", "Ọktóba\0", "Nọvẹ́mba\0", "Disẹ́mba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jén\0", "Fẹ́b\0", "Mach\0", "Épr\0", "Mee\0", "Jun\0", "Jul\0", "Ọgọ\0", "Sẹp\0", "Ọkt\0", "Nọv\0", "Dis\0" },
        { "Jénúári\0", "Fẹ́búári\0", "Mach\0", "Éprel\0", "Mee\0", "Jun\0", "Julai\0", "Ọgọst\0", "Sẹptẹ́mba\0", "Ọktóba\0", "Nọvẹ́mba\0", "Disẹ́mba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mọ́n\0", "Tiú\0", "Wẹ́n\0", "Tọ́z\0", "Fraí\0", "Sát\0", "Sọ́n\0" },
        { "Mọ́ndè\0", "Tiúzdè\0", "Wẹ́nẹ́zdè\0", "Tọ́zdè\0", "Fraídè\0", "Sátọdè\0", "Sọ́ndè\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mọ́n\0", "Tiú\0", "Wẹ́n\0", "Tọ́z\0", "Fraí\0", "Sát\0", "Sọ́n\0" },
        { "Mọ́ndè\0", "Tiúzdè\0", "Wẹ́nẹ́zdè\0", "Tọ́zdè\0", "Fraídè\0", "Sátọdè\0", "Sọ́ndè\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // pcm_NG
    {
        QLocale::Language::Polish, QLocale::Script::LatinScript, QLocale::Country::Poland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "polski\0", "Polska\0",
        "d.MM.yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "sty\0", "lut\0", "mar\0", "kwi\0", "maj\0", "cze\0", "lip\0", "sie\0", "wrz\0", "paź\0", "lis\0", "gru\0" },
        { "styczeń\0", "luty\0", "marzec\0", "kwiecień\0", "maj\0", "czerwiec\0", "lipiec\0", "sierpień\0", "wrzesień\0", "październik\0", "listopad\0", "grudzień\0" },
        { "S\0", "L\0", "M\0", "K\0", "M\0", "C\0", "L\0", "S\0", "W\0", "P\0", "L\0", "G\0" },
        { "sty\0", "lut\0", "mar\0", "kwi\0", "maj\0", "cze\0", "lip\0", "sie\0", "wrz\0", "paź\0", "lis\0", "gru\0" },
        { "stycznia\0", "lutego\0", "marca\0", "kwietnia\0", "maja\0", "czerwca\0", "lipca\0", "sierpnia\0", "września\0", "października\0", "listopada\0", "grudnia\0" },
        { "s\0", "l\0", "m\0", "k\0", "m\0", "c\0", "l\0", "s\0", "w\0", "p\0", "l\0", "g\0" },
        { "pon.\0", "wt.\0", "śr.\0", "czw.\0", "pt.\0", "sob.\0", "niedz.\0" },
        { "poniedziałek\0", "wtorek\0", "środa\0", "czwartek\0", "piątek\0", "sobota\0", "niedziela\0" },
        { "P\0", "W\0", "Ś\0", "C\0", "P\0", "S\0", "N\0" },
        { "pon.\0", "wt.\0", "śr.\0", "czw.\0", "pt.\0", "sob.\0", "niedz.\0" },
        { "poniedziałek\0", "wtorek\0", "środa\0", "czwartek\0", "piątek\0", "sobota\0", "niedziela\0" },
        { "p\0", "w\0", "ś\0", "c\0", "p\0", "s\0", "n\0" }
    }, // pl_PL
    {
        QLocale::Language::Pashto, QLocale::Script::ArabicScript, QLocale::Country::Afghanistan,
        Qt::Saturday, Qt::Thursday, Qt::Friday,
        46, 44, 59, 1642, 45, 43, 69, 1776,
        "پښتو\0", "افغانستان\0",
        "yyyy/M/d\0", "د yyyy د MMMM d\0", "H:mm\0", "H:mm:ss (Z)\0",
        "غ.م.\0", "غ.و.\0",
        { "جنوري\0", "فبروري\0", "مارچ\0", "اپریل\0", "مۍ\0", "جون\0", "جولای\0", "اګست\0", "سپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "جنوري\0", "فېبروري\0", "مارچ\0", "اپریل\0", "مۍ\0", "جون\0", "جولای\0", "اګست\0", "سپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "جنوري\0", "فبروري\0", "مارچ\0", "اپریل\0", "مۍ\0", "جون\0", "جولای\0", "اګست\0", "سېپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "جنوري\0", "فبروري\0", "مارچ\0", "اپریل\0", "مۍ\0", "جون\0", "جولای\0", "اګست\0", "سېپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "ج\0", "ف\0", "م\0", "ا\0", "م\0", "ج\0", "ج\0", "ا\0", "س\0", "ا\0", "ن\0", "د\0" },
        { "دونۍ\0", "درېنۍ\0", "څلرنۍ\0", "پينځنۍ\0", "جمعه\0", "اونۍ\0", "يونۍ\0" },
        { "دونۍ\0", "درېنۍ\0", "څلرنۍ\0", "پينځنۍ\0", "جمعه\0", "اونۍ\0", "يونۍ\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "دونۍ\0", "درېنۍ\0", "څلرنۍ\0", "پينځنۍ\0", "جمعه\0", "اونۍ\0", "يونۍ\0" },
        { "دونۍ\0", "درېنۍ\0", "څلرنۍ\0", "پينځنۍ\0", "جمعه\0", "اونۍ\0", "يونۍ\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // ps_AF
    {
        QLocale::Language::Pashto, QLocale::Script::AnyScript, QLocale::Country::Pakistan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 1642, 45, 43, 69, 1776,
        "پښتو\0", "پاکستان\0",
        "yyyy/M/d\0", "د yyyy د MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "غ.م.\0", "غ.و.\0",
        { "جنوري\0", "فبروري\0", "مارچ\0", "اپریل\0", "مۍ\0", "جون\0", "جولای\0", "اګست\0", "سپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "جنوري\0", "فېبروري\0", "مارچ\0", "اپریل\0", "مۍ\0", "جون\0", "جولای\0", "اګست\0", "سپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "جنوري\0", "فبروري\0", "مارچ\0", "اپریل\0", "مۍ\0", "جون\0", "جولای\0", "اګست\0", "سېپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "جنوري\0", "فبروري\0", "مارچ\0", "اپریل\0", "مۍ\0", "جون\0", "جولای\0", "اګست\0", "سېپتمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "ج\0", "ف\0", "م\0", "ا\0", "م\0", "ج\0", "ج\0", "ا\0", "س\0", "ا\0", "ن\0", "د\0" },
        { "دونۍ\0", "درېنۍ\0", "څلرنۍ\0", "پينځنۍ\0", "جمعه\0", "اونۍ\0", "يونۍ\0" },
        { "دونۍ\0", "درېنۍ\0", "څلرنۍ\0", "پينځنۍ\0", "جمعه\0", "اونۍ\0", "يونۍ\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "دونۍ\0", "درېنۍ\0", "څلرنۍ\0", "پينځنۍ\0", "جمعه\0", "اونۍ\0", "يونۍ\0" },
        { "دونۍ\0", "درېنۍ\0", "څلرنۍ\0", "پينځنۍ\0", "جمعه\0", "اونۍ\0", "يونۍ\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // ps_PK
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::Angola,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "Angola\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_AO
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::Brazil,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "Brasil\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_BR
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::Switzerland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "Suíça\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_CH
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::CapeVerde,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "Cabo Verde\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_CV
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::EquatorialGuinea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "Guiné Equatorial\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_GQ
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::GuineaBissau,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "Guiné-Bissau\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_GW
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::Luxembourg,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "Luxemburgo\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_LU
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::MacaoSARChina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "Macau, RAE da China\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "manhã\0", "tarde\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_MO
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::Mozambique,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "Moçambique\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_MZ
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::Portugal,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "português\0", "Portugal\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "manhã\0", "tarde\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_PT
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::SaoTomeAndPrincipe,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "São Tomé e Príncipe\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_ST
    {
        QLocale::Language::Portuguese, QLocale::Script::LatinScript, QLocale::Country::TimorLeste,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "português\0", "Timor-Leste\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "fev.\0", "mar.\0", "abr.\0", "mai.\0", "jun.\0", "jul.\0", "ago.\0", "set.\0", "out.\0", "nov.\0", "dez.\0" },
        { "janeiro\0", "fevereiro\0", "março\0", "abril\0", "maio\0", "junho\0", "julho\0", "agosto\0", "setembro\0", "outubro\0", "novembro\0", "dezembro\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "segunda\0", "terça\0", "quarta\0", "quinta\0", "sexta\0", "sábado\0", "domingo\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" },
        { "seg.\0", "ter.\0", "qua.\0", "qui.\0", "sex.\0", "sáb.\0", "dom.\0" },
        { "segunda-feira\0", "terça-feira\0", "quarta-feira\0", "quinta-feira\0", "sexta-feira\0", "sábado\0", "domingo\0" },
        { "S\0", "T\0", "Q\0", "Q\0", "S\0", "S\0", "D\0" }
    }, // pt_TL
    {
        QLocale::Language::Quechua, QLocale::Script::LatinScript, QLocale::Country::Bolivia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Runasimi\0", "Bolivia\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "Ene\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Jul\0", "Ago\0", "Set\0", "Oct\0", "Nov\0", "Dic\0" },
        { "Enero\0", "Febrero\0", "Marzo\0", "Abril\0", "Mayo\0", "Junio\0", "Julio\0", "Agosto\0", "Setiembre\0", "Octubre\0", "Noviembre\0", "Diciembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Ene\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Jul\0", "Ago\0", "Set\0", "Oct\0", "Nov\0", "Dic\0" },
        { "Enero\0", "Febrero\0", "Marzo\0", "Abril\0", "Mayo\0", "Junio\0", "Julio\0", "Agosto\0", "Setiembre\0", "Octubre\0", "Noviembre\0", "Diciembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Lun\0", "Mar\0", "Mié\0", "Jue\0", "Vie\0", "Sab\0", "Dom\0" },
        { "Lunes\0", "Martes\0", "Miércoles\0", "Jueves\0", "Viernes\0", "Sábado\0", "Domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "Lun\0", "Mar\0", "Mié\0", "Jue\0", "Vie\0", "Sab\0", "Dom\0" },
        { "Lunes\0", "Martes\0", "Miércoles\0", "Jueves\0", "Viernes\0", "Sábado\0", "Domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // qu_BO
    {
        QLocale::Language::Quechua, QLocale::Script::LatinScript, QLocale::Country::Ecuador,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Runasimi\0", "Ecuador\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "Ene\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Jul\0", "Ago\0", "Set\0", "Oct\0", "Nov\0", "Dic\0" },
        { "Enero\0", "Febrero\0", "Marzo\0", "Abril\0", "Mayo\0", "Junio\0", "Julio\0", "Agosto\0", "Setiembre\0", "Octubre\0", "Noviembre\0", "Diciembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Ene\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Jul\0", "Ago\0", "Set\0", "Oct\0", "Nov\0", "Dic\0" },
        { "Enero\0", "Febrero\0", "Marzo\0", "Abril\0", "Mayo\0", "Junio\0", "Julio\0", "Agosto\0", "Setiembre\0", "Octubre\0", "Noviembre\0", "Diciembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Lun\0", "Mar\0", "Mié\0", "Jue\0", "Vie\0", "Sab\0", "Dom\0" },
        { "Lunes\0", "Martes\0", "Miércoles\0", "Jueves\0", "Viernes\0", "Sábado\0", "Domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "Lun\0", "Mar\0", "Mié\0", "Jue\0", "Vie\0", "Sab\0", "Dom\0" },
        { "Lunes\0", "Martes\0", "Miércoles\0", "Jueves\0", "Viernes\0", "Sábado\0", "Domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // qu_EC
    {
        QLocale::Language::Quechua, QLocale::Script::LatinScript, QLocale::Country::Peru,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Runasimi\0", "Perú\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "Ene\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Jul\0", "Ago\0", "Set\0", "Oct\0", "Nov\0", "Dic\0" },
        { "Enero\0", "Febrero\0", "Marzo\0", "Abril\0", "Mayo\0", "Junio\0", "Julio\0", "Agosto\0", "Setiembre\0", "Octubre\0", "Noviembre\0", "Diciembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Ene\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Jul\0", "Ago\0", "Set\0", "Oct\0", "Nov\0", "Dic\0" },
        { "Enero\0", "Febrero\0", "Marzo\0", "Abril\0", "Mayo\0", "Junio\0", "Julio\0", "Agosto\0", "Setiembre\0", "Octubre\0", "Noviembre\0", "Diciembre\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Lun\0", "Mar\0", "Mié\0", "Jue\0", "Vie\0", "Sab\0", "Dom\0" },
        { "Lunes\0", "Martes\0", "Miércoles\0", "Jueves\0", "Viernes\0", "Sábado\0", "Domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" },
        { "Lun\0", "Mar\0", "Mié\0", "Jue\0", "Vie\0", "Sab\0", "Dom\0" },
        { "Lunes\0", "Martes\0", "Miércoles\0", "Jueves\0", "Viernes\0", "Sábado\0", "Domingo\0" },
        { "L\0", "M\0", "X\0", "J\0", "V\0", "S\0", "D\0" }
    }, // qu_PE
    {
        QLocale::Language::Romansh, QLocale::Script::LatinScript, QLocale::Country::Switzerland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 8217, 59, 37, 8722, 43, 69, 48,
        "rumantsch\0", "Svizra\0",
        "dd-MM-yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "schan.\0", "favr.\0", "mars\0", "avr.\0", "matg\0", "zercl.\0", "fan.\0", "avust\0", "sett.\0", "oct.\0", "nov.\0", "dec.\0" },
        { "schaner\0", "favrer\0", "mars\0", "avrigl\0", "matg\0", "zercladur\0", "fanadur\0", "avust\0", "settember\0", "october\0", "november\0", "december\0" },
        { "S\0", "F\0", "M\0", "A\0", "M\0", "Z\0", "F\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "schan.\0", "favr.\0", "mars\0", "avr.\0", "matg\0", "zercl.\0", "fan.\0", "avust\0", "sett.\0", "oct.\0", "nov.\0", "dec.\0" },
        { "da schaner\0", "da favrer\0", "da mars\0", "d’avrigl\0", "da matg\0", "da zercladur\0", "da fanadur\0", "d’avust\0", "da settember\0", "d’october\0", "da november\0", "da december\0" },
        { "S\0", "F\0", "M\0", "A\0", "M\0", "Z\0", "F\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "gli\0", "ma\0", "me\0", "gie\0", "ve\0", "so\0", "du\0" },
        { "glindesdi\0", "mardi\0", "mesemna\0", "gievgia\0", "venderdi\0", "sonda\0", "dumengia\0" },
        { "G\0", "M\0", "M\0", "G\0", "V\0", "S\0", "D\0" },
        { "gli\0", "ma\0", "me\0", "gie\0", "ve\0", "so\0", "du\0" },
        { "glindesdi\0", "mardi\0", "mesemna\0", "gievgia\0", "venderdi\0", "sonda\0", "dumengia\0" },
        { "G\0", "M\0", "M\0", "G\0", "V\0", "S\0", "D\0" }
    }, // rm_CH
    {
        QLocale::Language::Rundi, QLocale::Script::LatinScript, QLocale::Country::Burundi,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Ikirundi\0", "Uburundi\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Z.MU.\0", "Z.MW.\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mut.\0", "Gas.\0", "Wer.\0", "Mat.\0", "Gic.\0", "Kam.\0", "Nya.\0", "Kan.\0", "Nze.\0", "Ukw.\0", "Ugu.\0", "Uku.\0" },
        { "Nzero\0", "Ruhuhuma\0", "Ntwarante\0", "Ndamukiza\0", "Rusama\0", "Ruheshi\0", "Mukakaro\0", "Nyandagaro\0", "Nyakanga\0", "Gitugutu\0", "Munyonyo\0", "Kigarama\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "mbe.\0", "kab.\0", "gtu.\0", "kan.\0", "gnu.\0", "gnd.\0", "cu.\0" },
        { "Ku wa mbere\0", "Ku wa kabiri\0", "Ku wa gatatu\0", "Ku wa kane\0", "Ku wa gatanu\0", "Ku wa gatandatu\0", "Ku w’indwi\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // rn_BI
    {
        QLocale::Language::Romanian, QLocale::Script::LatinScript, QLocale::Country::Moldova,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "română\0", "Republica Moldova\0",
        "dd.MM.yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "ian.\0", "feb.\0", "mar.\0", "apr.\0", "mai\0", "iun.\0", "iul.\0", "aug.\0", "sept.\0", "oct.\0", "nov.\0", "dec.\0" },
        { "ianuarie\0", "februarie\0", "martie\0", "aprilie\0", "mai\0", "iunie\0", "iulie\0", "august\0", "septembrie\0", "octombrie\0", "noiembrie\0", "decembrie\0" },
        { "I\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ian.\0", "feb.\0", "mar.\0", "apr.\0", "mai\0", "iun.\0", "iul.\0", "aug.\0", "sept.\0", "oct.\0", "nov.\0", "dec.\0" },
        { "ianuarie\0", "februarie\0", "martie\0", "aprilie\0", "mai\0", "iunie\0", "iulie\0", "august\0", "septembrie\0", "octombrie\0", "noiembrie\0", "decembrie\0" },
        { "I\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Lun\0", "Mar\0", "Mie\0", "Joi\0", "Vin\0", "Sâm\0", "Dum\0" },
        { "luni\0", "marți\0", "miercuri\0", "joi\0", "vineri\0", "sâmbătă\0", "duminică\0" },
        { "L\0", "Ma\0", "Mi\0", "J\0", "V\0", "S\0", "D\0" },
        { "Lun\0", "Mar\0", "Mie\0", "Joi\0", "Vin\0", "Sâm\0", "Dum\0" },
        { "luni\0", "marți\0", "miercuri\0", "joi\0", "vineri\0", "sâmbătă\0", "duminică\0" },
        { "L\0", "Ma\0", "Mi\0", "J\0", "V\0", "S\0", "D\0" }
    }, // ro_MD
    {
        QLocale::Language::Romanian, QLocale::Script::LatinScript, QLocale::Country::Romania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "română\0", "România\0",
        "dd.MM.yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "a.m.\0", "p.m.\0",
        { "ian.\0", "feb.\0", "mar.\0", "apr.\0", "mai\0", "iun.\0", "iul.\0", "aug.\0", "sept.\0", "oct.\0", "nov.\0", "dec.\0" },
        { "ianuarie\0", "februarie\0", "martie\0", "aprilie\0", "mai\0", "iunie\0", "iulie\0", "august\0", "septembrie\0", "octombrie\0", "noiembrie\0", "decembrie\0" },
        { "I\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ian.\0", "feb.\0", "mar.\0", "apr.\0", "mai\0", "iun.\0", "iul.\0", "aug.\0", "sept.\0", "oct.\0", "nov.\0", "dec.\0" },
        { "ianuarie\0", "februarie\0", "martie\0", "aprilie\0", "mai\0", "iunie\0", "iulie\0", "august\0", "septembrie\0", "octombrie\0", "noiembrie\0", "decembrie\0" },
        { "I\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "lun.\0", "mar.\0", "mie.\0", "joi\0", "vin.\0", "sâm.\0", "dum.\0" },
        { "luni\0", "marți\0", "miercuri\0", "joi\0", "vineri\0", "sâmbătă\0", "duminică\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" },
        { "lun.\0", "mar.\0", "mie.\0", "joi\0", "vin.\0", "sâm.\0", "dum.\0" },
        { "luni\0", "marți\0", "miercuri\0", "joi\0", "vineri\0", "sâmbătă\0", "duminică\0" },
        { "L\0", "M\0", "M\0", "J\0", "V\0", "S\0", "D\0" }
    }, // ro_RO
    {
        QLocale::Language::Rombo, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kihorombo\0", "Tanzania\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "kang’ama\0", "kingoto\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "K\0", "K\0", "K\0", "K\0", "T\0", "S\0", "S\0", "N\0", "T\0", "I\0", "I\0", "I\0" },
        { "M1\0", "M2\0", "M3\0", "M4\0", "M5\0", "M6\0", "M7\0", "M8\0", "M9\0", "M10\0", "M11\0", "M12\0" },
        { "Mweri wa kwanza\0", "Mweri wa kaili\0", "Mweri wa katatu\0", "Mweri wa kaana\0", "Mweri wa tanu\0", "Mweri wa sita\0", "Mweri wa saba\0", "Mweri wa nane\0", "Mweri wa tisa\0", "Mweri wa ikumi\0", "Mweri wa ikumi na moja\0", "Mweri wa ikumi na mbili\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "3\0", "4\0", "5\0", "6\0", "7\0", "1\0", "2\0" },
        { "Ijt\0", "Ijn\0", "Ijtn\0", "Alh\0", "Iju\0", "Ijm\0", "Ijp\0" },
        { "Ijumatatu\0", "Ijumanne\0", "Ijumatano\0", "Alhamisi\0", "Ijumaa\0", "Ijumamosi\0", "Ijumapili\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // rof_TZ
    {
        QLocale::Language::Russian, QLocale::Script::CyrillicScript, QLocale::Country::Belarus,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "русский\0", "Беларусь\0",
        "dd.MM.yyyy\0", "d MMMM yyyy 'г'.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "янв.\0", "февр.\0", "март\0", "апр.\0", "май\0", "июнь\0", "июль\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "январь\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "янв.\0", "февр.\0", "мар.\0", "апр.\0", "мая\0", "июн.\0", "июл.\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "января\0", "февраля\0", "марта\0", "апреля\0", "мая\0", "июня\0", "июля\0", "августа\0", "сентября\0", "октября\0", "ноября\0", "декабря\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "П\0", "В\0", "С\0", "Ч\0", "П\0", "С\0", "В\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ru_BY
    {
        QLocale::Language::Russian, QLocale::Script::CyrillicScript, QLocale::Country::Kyrgyzstan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "русский\0", "Киргизия\0",
        "dd.MM.yyyy\0", "d MMMM yyyy 'г'.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "янв.\0", "февр.\0", "март\0", "апр.\0", "май\0", "июнь\0", "июль\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "январь\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "янв.\0", "февр.\0", "мар.\0", "апр.\0", "мая\0", "июн.\0", "июл.\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "января\0", "февраля\0", "марта\0", "апреля\0", "мая\0", "июня\0", "июля\0", "августа\0", "сентября\0", "октября\0", "ноября\0", "декабря\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "П\0", "В\0", "С\0", "Ч\0", "П\0", "С\0", "В\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ru_KG
    {
        QLocale::Language::Russian, QLocale::Script::CyrillicScript, QLocale::Country::Kazakhstan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "русский\0", "Казахстан\0",
        "dd.MM.yyyy\0", "d MMMM yyyy 'г'.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "янв.\0", "февр.\0", "март\0", "апр.\0", "май\0", "июнь\0", "июль\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "январь\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "янв.\0", "февр.\0", "мар.\0", "апр.\0", "мая\0", "июн.\0", "июл.\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "января\0", "февраля\0", "марта\0", "апреля\0", "мая\0", "июня\0", "июля\0", "августа\0", "сентября\0", "октября\0", "ноября\0", "декабря\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "П\0", "В\0", "С\0", "Ч\0", "П\0", "С\0", "В\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ru_KZ
    {
        QLocale::Language::Russian, QLocale::Script::CyrillicScript, QLocale::Country::Moldova,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "русский\0", "Молдова\0",
        "dd.MM.yyyy\0", "d MMMM yyyy 'г'.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "янв.\0", "февр.\0", "март\0", "апр.\0", "май\0", "июнь\0", "июль\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "январь\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "янв.\0", "февр.\0", "мар.\0", "апр.\0", "мая\0", "июн.\0", "июл.\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "января\0", "февраля\0", "марта\0", "апреля\0", "мая\0", "июня\0", "июля\0", "августа\0", "сентября\0", "октября\0", "ноября\0", "декабря\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "П\0", "В\0", "С\0", "Ч\0", "П\0", "С\0", "В\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ru_MD
    {
        QLocale::Language::Russian, QLocale::Script::CyrillicScript, QLocale::Country::Russia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "русский\0", "Россия\0",
        "dd.MM.yyyy\0", "d MMMM yyyy 'г'.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "янв.\0", "февр.\0", "март\0", "апр.\0", "май\0", "июнь\0", "июль\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "январь\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "янв.\0", "февр.\0", "мар.\0", "апр.\0", "мая\0", "июн.\0", "июл.\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "января\0", "февраля\0", "марта\0", "апреля\0", "мая\0", "июня\0", "июля\0", "августа\0", "сентября\0", "октября\0", "ноября\0", "декабря\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "П\0", "В\0", "С\0", "Ч\0", "П\0", "С\0", "В\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ru_RU
    {
        QLocale::Language::Russian, QLocale::Script::CyrillicScript, QLocale::Country::Ukraine,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "русский\0", "Украина\0",
        "dd.MM.yyyy\0", "d MMMM yyyy 'г'.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "янв.\0", "февр.\0", "март\0", "апр.\0", "май\0", "июнь\0", "июль\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "январь\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "янв.\0", "февр.\0", "мар.\0", "апр.\0", "мая\0", "июн.\0", "июл.\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "января\0", "февраля\0", "марта\0", "апреля\0", "мая\0", "июня\0", "июля\0", "августа\0", "сентября\0", "октября\0", "ноября\0", "декабря\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "П\0", "В\0", "С\0", "Ч\0", "П\0", "С\0", "В\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "вс\0" },
        { "понедельник\0", "вторник\0", "среда\0", "четверг\0", "пятница\0", "суббота\0", "воскресенье\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ru_UA
    {
        QLocale::Language::Kinyarwanda, QLocale::Script::LatinScript, QLocale::Country::Rwanda,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Kinyarwanda\0", "U Rwanda\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "mut.\0", "gas.\0", "wer.\0", "mat.\0", "gic.\0", "kam.\0", "nya.\0", "kan.\0", "nze.\0", "ukw.\0", "ugu.\0", "uku.\0" },
        { "Mutarama\0", "Gashyantare\0", "Werurwe\0", "Mata\0", "Gicurasi\0", "Kamena\0", "Nyakanga\0", "Kanama\0", "Nzeli\0", "Ukwakira\0", "Ugushyingo\0", "Ukuboza\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "mut.\0", "gas.\0", "wer.\0", "mat.\0", "gic.\0", "kam.\0", "nya.\0", "kan.\0", "nze.\0", "ukw.\0", "ugu.\0", "uku.\0" },
        { "Mutarama\0", "Gashyantare\0", "Werurwe\0", "Mata\0", "Gicurasi\0", "Kamena\0", "Nyakanga\0", "Kanama\0", "Nzeli\0", "Ukwakira\0", "Ugushyingo\0", "Ukuboza\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "mbe.\0", "kab.\0", "gtu.\0", "kan.\0", "gnu.\0", "gnd.\0", "cyu.\0" },
        { "Kuwa mbere\0", "Kuwa kabiri\0", "Kuwa gatatu\0", "Kuwa kane\0", "Kuwa gatanu\0", "Kuwa gatandatu\0", "Ku cyumweru\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "mbe.\0", "kab.\0", "gtu.\0", "kan.\0", "gnu.\0", "gnd.\0", "cyu.\0" },
        { "Kuwa mbere\0", "Kuwa kabiri\0", "Kuwa gatatu\0", "Kuwa kane\0", "Kuwa gatanu\0", "Kuwa gatandatu\0", "Ku cyumweru\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // rw_RW
    {
        QLocale::Language::Rwa, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kiruwa\0", "Tanzania\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "utuko\0", "kyiukonyi\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprilyi\0", "Mei\0", "Junyi\0", "Julyai\0", "Agusti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "J\0", "J\0", "J\0", "A\0", "I\0", "J\0", "J\0" },
        { "Jtt\0", "Jnn\0", "Jtn\0", "Alh\0", "Iju\0", "Jmo\0", "Jpi\0" },
        { "Jumatatuu\0", "Jumanne\0", "Jumatanu\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapilyi\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // rwk_TZ
    {
        QLocale::Language::Sanskrit, QLocale::Script::AnyScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "संस्कृत भाषा\0", "भारतः\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "जनवरी:\0", "फरवरी:\0", "मार्च:\0", "अप्रैल:\0", "मई\0", "जून:\0", "जुलाई:\0", "अगस्त:\0", "सितंबर:\0", "अक्तूबर:\0", "नवंबर:\0", "दिसंबर:\0" },
        { "जनवरीमासः\0", "फरवरीमासः\0", "मार्चमासः\0", "अप्रैलमासः\0", "मईमासः\0", "जूनमासः\0", "जुलाईमासः\0", "अगस्तमासः\0", "सितंबरमासः\0", "अक्तूबरमासः\0", "नवंबरमासः\0", "दिसंबरमासः\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "जनवरी:\0", "फरवरी:\0", "मार्च:\0", "अप्रैल:\0", "मई\0", "जून:\0", "जुलाई:\0", "अगस्त:\0", "सितंबर:\0", "अक्तूबर:\0", "नवंबर:\0", "दिसंबर:\0" },
        { "जनवरीमासः\0", "फरवरीमासः\0", "मार्चमासः\0", "अप्रैलमासः\0", "मईमासः\0", "जूनमासः\0", "जुलाईमासः\0", "अगस्तमासः\0", "सितंबरमासः\0", "अक्तूबरमासः\0", "नवंबरमासः\0", "दिसंबरमासः\0" },
        { "ज\0", "फ\0", "मा\0", "अ\0", "म\0", "जू\0", "जु\0", "अ\0", "सि\0", "अ\0", "न\0", "दि\0" },
        { "सोम\0", "मंगल\0", "बुध\0", "गुरु\0", "शुक्र\0", "शनि\0", "रवि\0" },
        { "सोमवासरः\0", "मंगलवासरः\0", "बुधवासरः\0", "गुरुवासर:\0", "शुक्रवासरः\0", "शनिवासरः\0", "रविवासरः\0" },
        { "सो\0", "मं\0", "बु\0", "गु\0", "शु\0", "श\0", "र\0" },
        { "सोम\0", "मंगल\0", "बुध\0", "गुरु\0", "शुक्र\0", "शनि\0", "रवि\0" },
        { "सोमवासरः\0", "मंगलवासरः\0", "बुधवासरः\0", "गुरुवासर:\0", "शुक्रवासरः\0", "शनिवासरः\0", "रविवासरः\0" },
        { "सो\0", "मं\0", "बु\0", "गु\0", "शु\0", "श\0", "र\0" }
    }, // sa_IN
    {
        QLocale::Language::Sakha, QLocale::Script::CyrillicScript, QLocale::Country::Russia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "саха тыла\0", "Арассыыйа\0",
        "yyyy/M/d\0", "yyyy, MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ЭИ\0", "ЭК\0",
        { "Тохс\0", "Олун\0", "Клн\0", "Мсу\0", "Ыам\0", "Бэс\0", "Отй\0", "Атр\0", "Блҕ\0", "Алт\0", "Сэт\0", "Ахс\0" },
        { "тохсунньу\0", "олунньу\0", "кулун тутар\0", "муус устар\0", "ыам ыйа\0", "бэс ыйа\0", "от ыйа\0", "атырдьых ыйа\0", "балаҕан ыйа\0", "алтынньы\0", "сэтинньи\0", "ахсынньы\0" },
        { "Т\0", "О\0", "К\0", "М\0", "Ы\0", "Б\0", "О\0", "А\0", "Б\0", "А\0", "С\0", "А\0" },
        { "Тохс\0", "Олун\0", "Клн\0", "Мсу\0", "Ыам\0", "Бэс\0", "Отй\0", "Атр\0", "Блҕ\0", "Алт\0", "Сэт\0", "Ахс\0" },
        { "Тохсунньу\0", "Олунньу\0", "Кулун тутар\0", "Муус устар\0", "Ыам ыйын\0", "Бэс ыйын\0", "От ыйын\0", "Атырдьых ыйын\0", "Балаҕан ыйын\0", "Алтынньы\0", "Сэтинньи\0", "ахсынньы\0" },
        { "Т\0", "О\0", "К\0", "М\0", "Ы\0", "Б\0", "О\0", "А\0", "Б\0", "А\0", "С\0", "А\0" },
        { "бн\0", "оп\0", "сэ\0", "чп\0", "бэ\0", "сб\0", "бс\0" },
        { "бэнидиэнньик\0", "оптуорунньук\0", "сэрэдэ\0", "чэппиэр\0", "Бээтиҥсэ\0", "субуота\0", "баскыһыанньа\0" },
        { "Б\0", "О\0", "С\0", "Ч\0", "Б\0", "С\0", "Б\0" },
        { "бн\0", "оп\0", "сэ\0", "чп\0", "бэ\0", "сб\0", "бс\0" },
        { "бэнидиэнньик\0", "оптуорунньук\0", "сэрэдэ\0", "чэппиэр\0", "Бээтиҥсэ\0", "субуота\0", "баскыһыанньа\0" },
        { "Б\0", "О\0", "С\0", "Ч\0", "Б\0", "С\0", "Б\0" }
    }, // sah_RU
    {
        QLocale::Language::Samburu, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kisampur\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Tesiran\0", "Teipa\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "O\0", "W\0", "O\0", "O\0", "I\0", "I\0", "S\0", "I\0", "S\0", "T\0", "T\0", "T\0" },
        { "Obo\0", "Waa\0", "Oku\0", "Ong\0", "Ime\0", "Ile\0", "Sap\0", "Isi\0", "Saa\0", "Tom\0", "Tob\0", "Tow\0" },
        { "Lapa le obo\0", "Lapa le waare\0", "Lapa le okuni\0", "Lapa le ong’wan\0", "Lapa le imet\0", "Lapa le ile\0", "Lapa le sapa\0", "Lapa le isiet\0", "Lapa le saal\0", "Lapa le tomon\0", "Lapa le tomon obo\0", "Lapa le tomon waare\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "K\0", "O\0", "I\0", "I\0", "S\0", "K\0", "A\0" },
        { "Kun\0", "Ong\0", "Ine\0", "Ile\0", "Sap\0", "Kwe\0", "Are\0" },
        { "Mderot ee kuni\0", "Mderot ee ong’wan\0", "Mderot ee inet\0", "Mderot ee ile\0", "Mderot ee sapa\0", "Mderot ee kwe\0", "Mderot ee are\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // saq_KE
    {
        QLocale::Language::Santali, QLocale::Script::OlChikiScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ᱥᱟᱱᱛᱟᱲᱤ\0", "ᱤᱱᱰᱤᱭᱟ\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "ᱥᱮᱛᱟᱜ\0", "ᱧᱤᱫᱟᱹ\0",
        { "ᱡᱟᱱ\0", "ᱯᱷᱟ\0", "ᱢᱟᱨ\0", "ᱟᱯᱨ\0", "ᱢᱮ\0", "ᱡᱩᱱ\0", "ᱡᱩᱞ\0", "ᱟᱜᱟ\0", "ᱥᱮᱯ\0", "ᱚᱠᱴ\0", "ᱱᱟᱣ\0", "ᱫᱤᱥ\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "ᱡ\0", "ᱯ\0", "ᱢ\0", "ᱟ\0", "ᱢ\0", "ᱡ\0", "ᱡ\0", "ᱟ\0", "ᱥ\0", "ᱚ\0", "ᱱ\0", "ᱫ\0" },
        { "ᱡᱟᱱ\0", "ᱯᱷᱟ\0", "ᱢᱟᱨ\0", "ᱟᱯᱨ\0", "ᱢᱮ\0", "ᱡᱩᱱ\0", "ᱡᱩᱞ\0", "ᱟᱜᱟ\0", "ᱥᱮᱯ\0", "ᱚᱠᱴ\0", "ᱱᱟᱣ\0", "ᱫᱤᱥ\0" },
        { "ᱡᱟᱱᱣᱟᱨᱤ\0", "ᱯᱷᱟᱨᱣᱟᱨᱤ\0", "ᱢᱟᱨᱪ\0", "ᱟᱯᱨᱮᱞ\0", "ᱢᱮ\0", "ᱡᱩᱱ\0", "ᱡᱩᱞᱟᱭ\0", "ᱟᱜᱟᱥᱛ\0", "ᱥᱮᱯᱴᱮᱢᱵᱟᱨ\0", "ᱚᱠᱴᱚᱵᱟᱨ\0", "ᱱᱟᱣᱟᱢᱵᱟᱨ\0", "ᱫᱤᱥᱟᱢᱵᱟᱨ\0" },
        { "ᱡ\0", "ᱯ\0", "ᱢ\0", "ᱟ\0", "ᱢ\0", "ᱡ\0", "ᱡ\0", "ᱟ\0", "ᱥ\0", "ᱚ\0", "ᱱ\0", "ᱫ\0" },
        { "ᱚᱛ\0", "ᱵᱟ\0", "ᱥᱟᱹ\0", "ᱥᱟᱹᱨ\0", "ᱡᱟᱹ\0", "ᱧᱩ\0", "ᱥᱤᱸ\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "ᱚ\0", "ᱵ\0", "ᱥ\0", "ᱥ\0", "ᱡ\0", "ᱧ\0", "ᱥ\0" },
        { "ᱚᱛ\0", "ᱵᱟ\0", "ᱥᱟᱹ\0", "ᱥᱟᱹᱨ\0", "ᱡᱟᱹ\0", "ᱧᱩ\0", "ᱥᱤᱸ\0" },
        { "ᱚᱛᱮ\0", "ᱵᱟᱞᱮ\0", "ᱥᱟᱹᱜᱩᱱ\0", "ᱥᱟᱹᱨᱫᱤ\0", "ᱡᱟᱹᱨᱩᱢ\0", "ᱧᱩᱦᱩᱢ\0", "ᱥᱤᱸᱜᱮ\0" },
        { "ᱚ\0", "ᱵ\0", "ᱥ\0", "ᱥ\0", "ᱡ\0", "ᱧ\0", "ᱥ\0" }
    }, // sat_Olck_IN
    {
        QLocale::Language::Sangu, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Ishisangu\0", "Tansaniya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Lwamilawu\0", "Pashamihe\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mup\0", "Mwi\0", "Msh\0", "Mun\0", "Mag\0", "Muj\0", "Msp\0", "Mpg\0", "Mye\0", "Mok\0", "Mus\0", "Muh\0" },
        { "Mupalangulwa\0", "Mwitope\0", "Mushende\0", "Munyi\0", "Mushende Magali\0", "Mujimbi\0", "Mushipepo\0", "Mupuguto\0", "Munyense\0", "Mokhu\0", "Musongandembwe\0", "Muhaano\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "J\0", "J\0", "J\0", "A\0", "I\0", "J\0", "M\0" },
        { "Jtt\0", "Jnn\0", "Jtn\0", "Alh\0", "Iju\0", "Jmo\0", "Mul\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alahamisi\0", "Ijumaa\0", "Jumamosi\0", "Mulungu\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // sbp_TZ
    {
        QLocale::Language::Sardinian, QLocale::Script::LatinScript, QLocale::Country::Italy,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "sardu\0", "Itàlia\0",
        "dd/MM/yyyy\0", "d 'dddd' MMMM 'dddd' 's' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "ghe\0", "fre\0", "mar\0", "abr\0", "maj\0", "làm\0", "trì\0", "aus\0", "cab\0", "stG\0", "stA\0", "nad\0" },
        { "ghennàrgiu\0", "freàrgiu\0", "martzu\0", "abrile\0", "maju\0", "làmpadas\0", "trìulas\0", "austu\0", "cabudanni\0", "santugaine\0", "santandria\0", "nadale\0" },
        { "G\0", "F\0", "M\0", "A\0", "M\0", "L\0", "T\0", "A\0", "C\0", "S\0", "S\0", "N\0" },
        { "ghe\0", "fre\0", "mar\0", "abr\0", "maj\0", "làm\0", "trì\0", "aus\0", "cab\0", "stG\0", "stA\0", "nad\0" },
        { "ghennàrgiu\0", "freàrgiu\0", "martzu\0", "abrile\0", "maju\0", "làmpadas\0", "trìulas\0", "austu\0", "cabudanni\0", "santugaine\0", "santandria\0", "nadale\0" },
        { "G\0", "F\0", "M\0", "A\0", "M\0", "L\0", "T\0", "A\0", "C\0", "S\0", "S\0", "N\0" },
        { "lun\0", "mar\0", "mèr\0", "giò\0", "che\0", "sàb\0", "dom\0" },
        { "lunis\0", "martis\0", "mèrcuris\0", "giòbia\0", "chenàbura\0", "sàbadu\0", "domìniga\0" },
        { "L\0", "M\0", "M\0", "G\0", "C\0", "S\0", "D\0" },
        { "lun\0", "mar\0", "mèr\0", "giò\0", "che\0", "sàb\0", "dom\0" },
        { "lunis\0", "martis\0", "mèrcuris\0", "giòbia\0", "chenàbura\0", "sàbadu\0", "domìniga\0" },
        { "L\0", "M\0", "M\0", "G\0", "C\0", "S\0", "D\0" }
    }, // sc_IT
    {
        QLocale::Language::Sindhi, QLocale::Script::ArabicScript, QLocale::Country::Pakistan,
        Qt::Saturday, Qt::Friday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "سنڌي\0", "پاڪستان\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صبح، منجهند\0", "منجهند، شام\0",
        { "جنوري\0", "فيبروري\0", "مارچ\0", "اپريل\0", "مئي\0", "جون\0", "جولاءِ\0", "آگسٽ\0", "سيپٽمبر\0", "آڪٽوبر\0", "نومبر\0", "ڊسمبر\0" },
        { "جنوري\0", "فيبروري\0", "مارچ\0", "اپريل\0", "مئي\0", "جون\0", "جولاءِ\0", "آگسٽ\0", "سيپٽمبر\0", "آڪٽوبر\0", "نومبر\0", "ڊسمبر\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "جنوري\0", "فيبروري\0", "مارچ\0", "اپريل\0", "مئي\0", "جون\0", "جولاءِ\0", "آگسٽ\0", "سيپٽمبر\0", "آڪٽوبر\0", "نومبر\0", "ڊسمبر\0" },
        { "جنوري\0", "فيبروري\0", "مارچ\0", "اپريل\0", "مئي\0", "جون\0", "جولاءِ\0", "آگسٽ\0", "سيپٽمبر\0", "آڪٽوبر\0", "نومبر\0", "ڊسمبر\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "سومر\0", "اڱارو\0", "اربع\0", "خميس\0", "جمعو\0", "ڇنڇر\0", "آچر\0" },
        { "سومر\0", "اڱارو\0", "اربع\0", "خميس\0", "جمعو\0", "ڇنڇر\0", "آچر\0" },
        { "سو\0", "اڱارو\0", "اربع\0", "خم\0", "جمعو\0", "ڇنڇر\0", "آچر\0" },
        { "سومر\0", "اڱارو\0", "اربع\0", "خميس\0", "جمعو\0", "ڇنڇر\0", "آچر\0" },
        { "سومر\0", "اڱارو\0", "اربع\0", "خميس\0", "جمعو\0", "ڇنڇر\0", "آچر\0" },
        { "سو\0", "اڱارو\0", "اربع\0", "خم\0", "جمعو\0", "ڇنڇر\0", "آچر\0" }
    }, // sd_Arab_PK
    {
        QLocale::Language::Sindhi, QLocale::Script::DevanagariScript, QLocale::Country::India,
        Qt::Saturday, Qt::Sunday, Qt::Saturday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "سنڌي\0", "ڀارت\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "صبح، منجهند\0", "منجهند، شام\0",
        { "جنوري\0", "فيبروري\0", "مارچ\0", "اپريل\0", "مئي\0", "جون\0", "جولاءِ\0", "آگسٽ\0", "سيپٽمبر\0", "آڪٽوبر\0", "نومبر\0", "ڊسمبر\0" },
        { "جنوري\0", "فيبروري\0", "مارچ\0", "اپريل\0", "مئي\0", "جون\0", "جولاءِ\0", "آگسٽ\0", "سيپٽمبر\0", "آڪٽوبر\0", "نومبر\0", "ڊسمبر\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "جنوري\0", "فيبروري\0", "مارچ\0", "اپريل\0", "مئي\0", "جون\0", "جولاءِ\0", "آگسٽ\0", "سيپٽمبر\0", "آڪٽوبر\0", "نومبر\0", "ڊسمبر\0" },
        { "جنوري\0", "فيبروري\0", "مارچ\0", "اپريل\0", "مئي\0", "جون\0", "جولاءِ\0", "آگسٽ\0", "سيپٽمبر\0", "آڪٽوبر\0", "نومبر\0", "ڊسمبر\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "سومر\0", "اڱارو\0", "اربع\0", "خميس\0", "جمعو\0", "ڇنڇر\0", "آچر\0" },
        { "سومر\0", "اڱارو\0", "اربع\0", "خميس\0", "جمعو\0", "ڇنڇر\0", "آچر\0" },
        { "سو\0", "اڱارو\0", "اربع\0", "خم\0", "جمعو\0", "ڇنڇر\0", "آچر\0" },
        { "سومر\0", "اڱارو\0", "اربع\0", "خميس\0", "جمعو\0", "ڇنڇر\0", "آچر\0" },
        { "سومر\0", "اڱارو\0", "اربع\0", "خميس\0", "جمعو\0", "ڇنڇر\0", "آچر\0" },
        { "سو\0", "اڱارو\0", "اربع\0", "خم\0", "جمعو\0", "ڇنڇر\0", "آچر\0" }
    }, // sd_Deva_IN
    {
        QLocale::Language::NorthernSami, QLocale::Script::LatinScript, QLocale::Country::Finland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "davvisámegiella\0", "Suopma\0",
        "dd.MM.yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ib\0", "eb\0",
        { "ođđj\0", "guov\0", "njuk\0", "cuoŋ\0", "mies\0", "geas\0", "suoi\0", "borg\0", "čakč\0", "golg\0", "skáb\0", "juov\0" },
        { "ođđajagemánnu\0", "guovvamánnu\0", "njukčamánnu\0", "cuoŋománnu\0", "miessemánnu\0", "geassemánnu\0", "suoidnemánnu\0", "borgemánnu\0", "čakčamánnu\0", "golggotmánnu\0", "skábmamánnu\0", "juovlamánnu\0" },
        { "O\0", "G\0", "N\0", "C\0", "M\0", "G\0", "S\0", "B\0", "Č\0", "G\0", "S\0", "J\0" },
        { "ođđj\0", "guov\0", "njuk\0", "cuoŋ\0", "mies\0", "geas\0", "suoi\0", "borg\0", "čakč\0", "golg\0", "skáb\0", "juov\0" },
        { "ođđajagemánnu\0", "guovvamánnu\0", "njukčamánnu\0", "cuoŋománnu\0", "miessemánnu\0", "geassemánnu\0", "suoidnemánnu\0", "borgemánnu\0", "čakčamánnu\0", "golggotmánnu\0", "skábmamánnu\0", "juovlamánnu\0" },
        { "O\0", "G\0", "N\0", "C\0", "M\0", "G\0", "S\0", "B\0", "Č\0", "G\0", "S\0", "J\0" },
        { "má\0", "di\0", "ga\0", "du\0", "be\0", "lá\0", "so\0" },
        { "mánnodat\0", "disdat\0", "gaskavahkku\0", "duorastat\0", "bearjadat\0", "lávvordat\0", "sotnabeaivi\0" },
        { "M\0", "D\0", "G\0", "D\0", "B\0", "L\0", "S\0" },
        { "má\0", "di\0", "ga\0", "du\0", "be\0", "lá\0", "so\0" },
        { "mánnodat\0", "disdat\0", "gaskavahkku\0", "duorastat\0", "bearjadat\0", "lávvordat\0", "sotnabeaivi\0" },
        { "M\0", "D\0", "G\0", "D\0", "B\0", "L\0", "S\0" }
    }, // se_FI
    {
        QLocale::Language::NorthernSami, QLocale::Script::LatinScript, QLocale::Country::Norway,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "davvisámegiella\0", "Norga\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "iđitbeaivi\0", "eahketbeaivi\0",
        { "ođđj\0", "guov\0", "njuk\0", "cuo\0", "mies\0", "geas\0", "suoi\0", "borg\0", "čakč\0", "golg\0", "skáb\0", "juov\0" },
        { "ođđajagemánnu\0", "guovvamánnu\0", "njukčamánnu\0", "cuoŋománnu\0", "miessemánnu\0", "geassemánnu\0", "suoidnemánnu\0", "borgemánnu\0", "čakčamánnu\0", "golggotmánnu\0", "skábmamánnu\0", "juovlamánnu\0" },
        { "O\0", "G\0", "N\0", "C\0", "M\0", "G\0", "S\0", "B\0", "Č\0", "G\0", "S\0", "J\0" },
        { "ođđj\0", "guov\0", "njuk\0", "cuo\0", "mies\0", "geas\0", "suoi\0", "borg\0", "čakč\0", "golg\0", "skáb\0", "juov\0" },
        { "ođđajagemánnu\0", "guovvamánnu\0", "njukčamánnu\0", "cuoŋománnu\0", "miessemánnu\0", "geassemánnu\0", "suoidnemánnu\0", "borgemánnu\0", "čakčamánnu\0", "golggotmánnu\0", "skábmamánnu\0", "juovlamánnu\0" },
        { "O\0", "G\0", "N\0", "C\0", "M\0", "G\0", "S\0", "B\0", "Č\0", "G\0", "S\0", "J\0" },
        { "vuos\0", "maŋ\0", "gask\0", "duor\0", "bear\0", "láv\0", "sotn\0" },
        { "vuossárga\0", "maŋŋebárga\0", "gaskavahkku\0", "duorasdat\0", "bearjadat\0", "lávvardat\0", "sotnabeaivi\0" },
        { "V\0", "M\0", "G\0", "D\0", "B\0", "L\0", "S\0" },
        { "vuos\0", "maŋ\0", "gask\0", "duor\0", "bear\0", "láv\0", "sotn\0" },
        { "vuossárga\0", "maŋŋebárga\0", "gaskavahkku\0", "duorasdat\0", "bearjadat\0", "lávvardat\0", "sotnabeaivi\0" },
        { "V\0", "M\0", "G\0", "D\0", "B\0", "L\0", "S\0" }
    }, // se_NO
    {
        QLocale::Language::NorthernSami, QLocale::Script::LatinScript, QLocale::Country::Sweden,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "davvisámegiella\0", "Ruoŧŧa\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "iđitbeaivi\0", "eahketbeaivi\0",
        { "ođđj\0", "guov\0", "njuk\0", "cuo\0", "mies\0", "geas\0", "suoi\0", "borg\0", "čakč\0", "golg\0", "skáb\0", "juov\0" },
        { "ođđajagemánnu\0", "guovvamánnu\0", "njukčamánnu\0", "cuoŋománnu\0", "miessemánnu\0", "geassemánnu\0", "suoidnemánnu\0", "borgemánnu\0", "čakčamánnu\0", "golggotmánnu\0", "skábmamánnu\0", "juovlamánnu\0" },
        { "O\0", "G\0", "N\0", "C\0", "M\0", "G\0", "S\0", "B\0", "Č\0", "G\0", "S\0", "J\0" },
        { "ođđj\0", "guov\0", "njuk\0", "cuo\0", "mies\0", "geas\0", "suoi\0", "borg\0", "čakč\0", "golg\0", "skáb\0", "juov\0" },
        { "ođđajagemánnu\0", "guovvamánnu\0", "njukčamánnu\0", "cuoŋománnu\0", "miessemánnu\0", "geassemánnu\0", "suoidnemánnu\0", "borgemánnu\0", "čakčamánnu\0", "golggotmánnu\0", "skábmamánnu\0", "juovlamánnu\0" },
        { "O\0", "G\0", "N\0", "C\0", "M\0", "G\0", "S\0", "B\0", "Č\0", "G\0", "S\0", "J\0" },
        { "vuos\0", "maŋ\0", "gask\0", "duor\0", "bear\0", "láv\0", "sotn\0" },
        { "vuossárga\0", "maŋŋebárga\0", "gaskavahkku\0", "duorasdat\0", "bearjadat\0", "lávvardat\0", "sotnabeaivi\0" },
        { "V\0", "M\0", "G\0", "D\0", "B\0", "L\0", "S\0" },
        { "vuos\0", "maŋ\0", "gask\0", "duor\0", "bear\0", "láv\0", "sotn\0" },
        { "vuossárga\0", "maŋŋebárga\0", "gaskavahkku\0", "duorasdat\0", "bearjadat\0", "lávvardat\0", "sotnabeaivi\0" },
        { "V\0", "M\0", "G\0", "D\0", "B\0", "L\0", "S\0" }
    }, // se_SE
    {
        QLocale::Language::Sena, QLocale::Script::LatinScript, QLocale::Country::Mozambique,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "sena\0", "Moçambique\0",
        "d/M/yyyy\0", "d 'dddd' MMMM 'dddd' yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Fev\0", "Mar\0", "Abr\0", "Mai\0", "Jun\0", "Jul\0", "Aug\0", "Set\0", "Otu\0", "Nov\0", "Dec\0" },
        { "Janeiro\0", "Fevreiro\0", "Marco\0", "Abril\0", "Maio\0", "Junho\0", "Julho\0", "Augusto\0", "Setembro\0", "Otubro\0", "Novembro\0", "Decembro\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "P\0", "C\0", "T\0", "N\0", "S\0", "S\0", "D\0" },
        { "Pos\0", "Pir\0", "Tat\0", "Nai\0", "Sha\0", "Sab\0", "Dim\0" },
        { "Chiposi\0", "Chipiri\0", "Chitatu\0", "Chinai\0", "Chishanu\0", "Sabudu\0", "Dimingu\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // seh_MZ
    {
        QLocale::Language::KoyraboroSenni, QLocale::Script::LatinScript, QLocale::Country::Mali,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 160, 59, 37, 45, 43, 69, 48,
        "Koyraboro senni\0", "Maali\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Adduha\0", "Aluula\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "Ž\0", "F\0", "M\0", "A\0", "M\0", "Ž\0", "Ž\0", "U\0", "S\0", "O\0", "N\0", "D\0" },
        { "Žan\0", "Fee\0", "Mar\0", "Awi\0", "Me\0", "Žuw\0", "Žuy\0", "Ut\0", "Sek\0", "Okt\0", "Noo\0", "Dee\0" },
        { "Žanwiye\0", "Feewiriye\0", "Marsi\0", "Awiril\0", "Me\0", "Žuweŋ\0", "Žuyye\0", "Ut\0", "Sektanbur\0", "Oktoobur\0", "Noowanbur\0", "Deesanbur\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "T\0", "T\0", "L\0", "L\0", "L\0", "S\0", "H\0" },
        { "Ati\0", "Ata\0", "Ala\0", "Alm\0", "Alz\0", "Asi\0", "Alh\0" },
        { "Atinni\0", "Atalaata\0", "Alarba\0", "Alhamiisa\0", "Alzuma\0", "Asibti\0", "Alhadi\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // ses_ML
    {
        QLocale::Language::Sango, QLocale::Script::LatinScript, QLocale::Country::CentralAfricanRepublic,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Sängö\0", "Ködörösêse tî Bêafrîka\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ND\0", "LK\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "N\0", "F\0", "M\0", "N\0", "B\0", "F\0", "L\0", "K\0", "M\0", "N\0", "N\0", "K\0" },
        { "Nye\0", "Ful\0", "Mbä\0", "Ngu\0", "Bêl\0", "Fön\0", "Len\0", "Kük\0", "Mvu\0", "Ngb\0", "Nab\0", "Kak\0" },
        { "Nyenye\0", "Fulundïgi\0", "Mbängü\0", "Ngubùe\0", "Bêläwü\0", "Föndo\0", "Lengua\0", "Kükürü\0", "Mvuka\0", "Ngberere\0", "Nabändüru\0", "Kakauka\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "S\0", "T\0", "S\0", "K\0", "P\0", "Y\0", "K\0" },
        { "Bk2\0", "Bk3\0", "Bk4\0", "Bk5\0", "Lâp\0", "Lây\0", "Bk1\0" },
        { "Bïkua-ûse\0", "Bïkua-ptâ\0", "Bïkua-usïö\0", "Bïkua-okü\0", "Lâpôsö\0", "Lâyenga\0", "Bikua-ôko\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // sg_CF
    {
        QLocale::Language::Tachelhit, QLocale::Script::LatinScript, QLocale::Country::Morocco,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "ⵜⴰⵛⵍⵃⵉⵜ\0", "ⵍⵎⵖⵔⵉⴱ\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ⵜⵉⴼⴰⵡⵜ\0", "ⵜⴰⴷⴳⴳⵯⴰⵜ\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "ⵉ\0", "ⴱ\0", "ⵎ\0", "ⵉ\0", "ⵎ\0", "ⵢ\0", "ⵢ\0", "ⵖ\0", "ⵛ\0", "ⴽ\0", "ⵏ\0", "ⴷ\0" },
        { "ⵉⵏⵏ\0", "ⴱⵕⴰ\0", "ⵎⵕ\0", "ⵉⴱⵔ\0", "ⵎⴰⵢ\0", "ⵢⵓⵏ\0", "ⵢⵓⵍ\0", "ⵖⵓⵛ\0", "ⵛⵓⵜ\0", "ⴽⵜⵓ\0", "ⵏⵓⵡ\0", "ⴷⵓⵊ\0" },
        { "ⵉⵏⵏⴰⵢⵔ\0", "ⴱⵕⴰⵢⵕ\0", "ⵎⴰⵕⵚ\0", "ⵉⴱⵔⵉⵔ\0", "ⵎⴰⵢⵢⵓ\0", "ⵢⵓⵏⵢⵓ\0", "ⵢⵓⵍⵢⵓⵣ\0", "ⵖⵓⵛⵜ\0", "ⵛⵓⵜⴰⵏⴱⵉⵔ\0", "ⴽⵜⵓⴱⵔ\0", "ⵏⵓⵡⴰⵏⴱⵉⵔ\0", "ⴷⵓⵊⴰⵏⴱⵉⵔ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "ⴰⵢⵏ\0", "ⴰⵙⵉ\0", "ⴰⴽⵕ\0", "ⴰⴽⵡ\0", "ⴰⵙⵉⵎ\0", "ⴰⵙⵉⴹ\0", "ⴰⵙⴰ\0" },
        { "ⴰⵢⵏⴰⵙ\0", "ⴰⵙⵉⵏⴰⵙ\0", "ⴰⴽⵕⴰⵙ\0", "ⴰⴽⵡⴰⵙ\0", "ⵙⵉⵎⵡⴰⵙ\0", "ⴰⵙⵉⴹⵢⴰⵙ\0", "ⴰⵙⴰⵎⴰⵙ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // shi_Latn_MA
    {
        QLocale::Language::Tachelhit, QLocale::Script::TifinaghScript, QLocale::Country::Morocco,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "ⵜⴰⵛⵍⵃⵉⵜ\0", "ⵍⵎⵖⵔⵉⴱ\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ⵜⵉⴼⴰⵡⵜ\0", "ⵜⴰⴷⴳⴳⵯⴰⵜ\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "ⵉ\0", "ⴱ\0", "ⵎ\0", "ⵉ\0", "ⵎ\0", "ⵢ\0", "ⵢ\0", "ⵖ\0", "ⵛ\0", "ⴽ\0", "ⵏ\0", "ⴷ\0" },
        { "ⵉⵏⵏ\0", "ⴱⵕⴰ\0", "ⵎⴰⵕ\0", "ⵉⴱⵔ\0", "ⵎⴰⵢ\0", "ⵢⵓⵏ\0", "ⵢⵓⵍ\0", "ⵖⵓⵛ\0", "ⵛⵓⵜ\0", "ⴽⵜⵓ\0", "ⵏⵓⵡ\0", "ⴷⵓⵊ\0" },
        { "ⵉⵏⵏⴰⵢⵔ\0", "ⴱⵕⴰⵢⵕ\0", "ⵎⴰⵕⵚ\0", "ⵉⴱⵔⵉⵔ\0", "ⵎⴰⵢⵢⵓ\0", "ⵢⵓⵏⵢⵓ\0", "ⵢⵓⵍⵢⵓⵣ\0", "ⵖⵓⵛⵜ\0", "ⵛⵓⵜⴰⵏⴱⵉⵔ\0", "ⴽⵜⵓⴱⵔ\0", "ⵏⵓⵡⴰⵏⴱⵉⵔ\0", "ⴷⵓⵊⴰⵏⴱⵉⵔ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "ⴰⵢⵏ\0", "ⴰⵙⵉ\0", "ⴰⴽⵕ\0", "ⴰⴽⵡ\0", "ⴰⵙⵉⵎ\0", "ⴰⵙⵉⴹ\0", "ⴰⵙⴰ\0" },
        { "ⴰⵢⵏⴰⵙ\0", "ⴰⵙⵉⵏⴰⵙ\0", "ⴰⴽⵕⴰⵙ\0", "ⴰⴽⵡⴰⵙ\0", "ⵙⵉⵎⵡⴰⵙ\0", "ⴰⵙⵉⴹⵢⴰⵙ\0", "ⴰⵙⴰⵎⴰⵙ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // shi_Tfng_MA
    {
        QLocale::Language::Sinhala, QLocale::Script::SinhalaScript, QLocale::Country::SriLanka,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "සිංහල\0", "ශ්‍රී ලංකාව\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH.mm\0", "HH.mm.ss Z\0",
        "පෙ.ව.\0", "ප.ව.\0",
        { "ජන\0", "පෙබ\0", "මාර්\0", "අප්‍රේල්\0", "මැයි\0", "ජූනි\0", "ජූලි\0", "අගෝ\0", "සැප්\0", "ඔක්\0", "නොවැ\0", "දෙසැ\0" },
        { "ජනවාරි\0", "පෙබරවාරි\0", "මාර්තු\0", "අප්‍රේල්\0", "මැයි\0", "ජූනි\0", "ජූලි\0", "අගෝස්තු\0", "සැප්තැම්බර්\0", "ඔක්තෝබර්\0", "නොවැම්බර්\0", "දෙසැම්බර්\0" },
        { "ජ\0", "පෙ\0", "මා\0", "අ\0", "මැ\0", "ජූ\0", "ජූ\0", "අ\0", "සැ\0", "ඔ\0", "නෙ\0", "දෙ\0" },
        { "ජන\0", "පෙබ\0", "මාර්තු\0", "අප්‍රේල්\0", "මැයි\0", "ජූනි\0", "ජූලි\0", "අගෝ\0", "සැප්\0", "ඔක්\0", "නොවැ\0", "දෙසැ\0" },
        { "ජනවාරි\0", "පෙබරවාරි\0", "මාර්තු\0", "අප්‍රේල්\0", "මැයි\0", "ජූනි\0", "ජූලි\0", "අගෝස්තු\0", "සැප්තැම්බර්\0", "ඔක්තෝබර්\0", "නොවැම්බර්\0", "දෙසැම්බර්\0" },
        { "ජ\0", "පෙ\0", "මා\0", "අ\0", "මැ\0", "ජූ\0", "ජූ\0", "අ\0", "සැ\0", "ඔ\0", "නෙ\0", "දෙ\0" },
        { "සඳුදා\0", "අඟහ\0", "බදාදා\0", "බ්‍රහස්\0", "සිකු\0", "සෙන\0", "ඉරිදා\0" },
        { "සඳුදා\0", "අඟහරුවාදා\0", "බදාදා\0", "බ්‍රහස්පතින්දා\0", "සිකුරාදා\0", "සෙනසුරාදා\0", "ඉරිදා\0" },
        { "ස\0", "අ\0", "බ\0", "බ්‍ර\0", "සි\0", "සෙ\0", "ඉ\0" },
        { "සඳුදා\0", "අඟහ\0", "බදාදා\0", "බ්‍රහස්\0", "සිකු\0", "සෙන\0", "ඉරිදා\0" },
        { "සඳුදා\0", "අඟහරුවාදා\0", "බදාදා\0", "බ්‍රහස්පතින්දා\0", "සිකුරාදා\0", "සෙනසුරාදා\0", "ඉරිදා\0" },
        { "ස\0", "අ\0", "බ\0", "බ්‍ර\0", "සි\0", "සෙ\0", "ඉ\0" }
    }, // si_LK
    {
        QLocale::Language::Slovak, QLocale::Script::LatinScript, QLocale::Country::Slovakia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 101, 48,
        "slovenčina\0", "Slovensko\0",
        "d. M. yyyy\0", "d. MMMM yyyy\0", "H:mm\0", "H:mm:ss Z\0",
        "AM\0", "PM\0",
        { "jan\0", "feb\0", "mar\0", "apr\0", "máj\0", "jún\0", "júl\0", "aug\0", "sep\0", "okt\0", "nov\0", "dec\0" },
        { "január\0", "február\0", "marec\0", "apríl\0", "máj\0", "jún\0", "júl\0", "august\0", "september\0", "október\0", "november\0", "december\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "jan\0", "feb\0", "mar\0", "apr\0", "máj\0", "jún\0", "júl\0", "aug\0", "sep\0", "okt\0", "nov\0", "dec\0" },
        { "januára\0", "februára\0", "marca\0", "apríla\0", "mája\0", "júna\0", "júla\0", "augusta\0", "septembra\0", "októbra\0", "novembra\0", "decembra\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "po\0", "ut\0", "st\0", "št\0", "pi\0", "so\0", "ne\0" },
        { "pondelok\0", "utorok\0", "streda\0", "štvrtok\0", "piatok\0", "sobota\0", "nedeľa\0" },
        { "p\0", "u\0", "s\0", "š\0", "p\0", "s\0", "n\0" },
        { "po\0", "ut\0", "st\0", "št\0", "pi\0", "so\0", "ne\0" },
        { "pondelok\0", "utorok\0", "streda\0", "štvrtok\0", "piatok\0", "sobota\0", "nedeľa\0" },
        { "p\0", "u\0", "s\0", "š\0", "p\0", "s\0", "n\0" }
    }, // sk_SK
    {
        QLocale::Language::Slovenian, QLocale::Script::LatinScript, QLocale::Country::Slovenia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 8722, 43, 101, 48,
        "slovenščina\0", "Slovenija\0",
        "d. MM. yyyy\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "dopoldne\0", "popoldne\0",
        { "jan.\0", "feb.\0", "mar.\0", "apr.\0", "maj\0", "jun.\0", "jul.\0", "avg.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januar\0", "februar\0", "marec\0", "april\0", "maj\0", "junij\0", "julij\0", "avgust\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "jan.\0", "feb.\0", "mar.\0", "apr.\0", "maj\0", "jun.\0", "jul.\0", "avg.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januar\0", "februar\0", "marec\0", "april\0", "maj\0", "junij\0", "julij\0", "avgust\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "j\0", "f\0", "m\0", "a\0", "m\0", "j\0", "j\0", "a\0", "s\0", "o\0", "n\0", "d\0" },
        { "pon.\0", "tor.\0", "sre.\0", "čet.\0", "pet.\0", "sob.\0", "ned.\0" },
        { "ponedeljek\0", "torek\0", "sreda\0", "četrtek\0", "petek\0", "sobota\0", "nedelja\0" },
        { "p\0", "t\0", "s\0", "č\0", "p\0", "s\0", "n\0" },
        { "pon.\0", "tor.\0", "sre.\0", "čet.\0", "pet.\0", "sob.\0", "ned.\0" },
        { "ponedeljek\0", "torek\0", "sreda\0", "četrtek\0", "petek\0", "sobota\0", "nedelja\0" },
        { "p\0", "t\0", "s\0", "č\0", "p\0", "s\0", "n\0" }
    }, // sl_SI
    {
        QLocale::Language::InariSami, QLocale::Script::LatinScript, QLocale::Country::Finland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "anarâškielâ\0", "Suomâ\0",
        "d.M.yyyy\0", "MMMM d. yyyy\0", "H.mm\0", "H.mm.ss Z\0",
        "ip.\0", "ep.\0",
        { "uđiv\0", "kuovâ\0", "njuhčâ\0", "cuáŋui\0", "vyesi\0", "kesi\0", "syeini\0", "porge\0", "čohčâ\0", "roovvâd\0", "skammâ\0", "juovlâ\0" },
        { "uđđâivemáánu\0", "kuovâmáánu\0", "njuhčâmáánu\0", "cuáŋuimáánu\0", "vyesimáánu\0", "kesimáánu\0", "syeinimáánu\0", "porgemáánu\0", "čohčâmáánu\0", "roovvâdmáánu\0", "skammâmáánu\0", "juovlâmáánu\0" },
        { "U\0", "K\0", "NJ\0", "C\0", "V\0", "K\0", "S\0", "P\0", "Č\0", "R\0", "S\0", "J\0" },
        { "uđiv\0", "kuovâ\0", "njuhčâ\0", "cuáŋui\0", "vyesi\0", "kesi\0", "syeini\0", "porge\0", "čohčâ\0", "roovvâd\0", "skammâ\0", "juovlâ\0" },
        { "uđđâivemáánu\0", "kuovâmáánu\0", "njuhčâmáánu\0", "cuáŋuimáánu\0", "vyesimáánu\0", "kesimáánu\0", "syeinimáánu\0", "porgemáánu\0", "čohčâmáánu\0", "roovvâdmáánu\0", "skammâmáánu\0", "juovlâmáánu\0" },
        { "U\0", "K\0", "NJ\0", "C\0", "V\0", "K\0", "S\0", "P\0", "Č\0", "R\0", "S\0", "J\0" },
        { "vuo\0", "maj\0", "kos\0", "tuo\0", "vás\0", "láv\0", "pas\0" },
        { "vuossargâ\0", "majebargâ\0", "koskokko\0", "tuorâstâh\0", "vástuppeivi\0", "lávurdâh\0", "pasepeivi\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "vuo\0", "maj\0", "kos\0", "tuo\0", "vás\0", "láv\0", "pas\0" },
        { "vuossaargâ\0", "majebaargâ\0", "koskoho\0", "tuorâstuv\0", "vástuppeeivi\0", "lávurduv\0", "pasepeeivi\0" },
        { "V\0", "M\0", "K\0", "T\0", "V\0", "L\0", "p\0" }
    }, // smn_FI
    {
        QLocale::Language::Shona, QLocale::Script::LatinScript, QLocale::Country::Zimbabwe,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "chiShona\0", "Zimbabwe\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Ndi\0", "Kuk\0", "Kur\0", "Kub\0", "Chv\0", "Chk\0", "Chg\0", "Nya\0", "Gun\0", "Gum\0", "Mbu\0", "Zvi\0" },
        { "Ndira\0", "Kukadzi\0", "Kurume\0", "Kubvumbi\0", "Chivabvu\0", "Chikumi\0", "Chikunguru\0", "Nyamavhuvhu\0", "Gunyana\0", "Gumiguru\0", "Mbudzi\0", "Zvita\0" },
        { "N\0", "K\0", "K\0", "K\0", "C\0", "C\0", "C\0", "N\0", "G\0", "G\0", "M\0", "Z\0" },
        { "Ndi\0", "Kuk\0", "Kur\0", "Kub\0", "Chv\0", "Chk\0", "Chg\0", "Nya\0", "Gun\0", "Gum\0", "Mbu\0", "Zvi\0" },
        { "Ndira\0", "Kukadzi\0", "Kurume\0", "Kubvumbi\0", "Chivabvu\0", "Chikumi\0", "Chikunguru\0", "Nyamavhuvhu\0", "Gunyana\0", "Gumiguru\0", "Mbudzi\0", "Zvita\0" },
        { "N\0", "K\0", "K\0", "K\0", "C\0", "C\0", "C\0", "N\0", "G\0", "G\0", "M\0", "Z\0" },
        { "Muv\0", "Chp\0", "Cht\0", "Chn\0", "Chs\0", "Mug\0", "Svo\0" },
        { "Muvhuro\0", "Chipiri\0", "Chitatu\0", "China\0", "Chishanu\0", "Mugovera\0", "Svondo\0" },
        { "M\0", "C\0", "C\0", "C\0", "C\0", "M\0", "S\0" },
        { "Muv\0", "Chp\0", "Cht\0", "Chn\0", "Chs\0", "Mug\0", "Svo\0" },
        { "Muvhuro\0", "Chipiri\0", "Chitatu\0", "China\0", "Chishanu\0", "Mugovera\0", "Svondo\0" },
        { "M\0", "C\0", "C\0", "C\0", "C\0", "M\0", "S\0" }
    }, // sn_ZW
    {
        QLocale::Language::Somali, QLocale::Script::LatinScript, QLocale::Country::Djibouti,
        Qt::Saturday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Soomaali\0", "Jabuuti\0",
        "dd/MM/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "GH\0", "GD\0",
        { "Jan\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Lul\0", "Ogs\0", "Seb\0", "Okt\0", "Nof\0", "Dis\0" },
        { "Jannaayo\0", "Febraayo\0", "Maarso\0", "Abriil\0", "May\0", "Juun\0", "Luuliyo\0", "Ogost\0", "Sebtembar\0", "Oktoobar\0", "Nofembar\0", "Desembar\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "L\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Lul\0", "Ogs\0", "Seb\0", "Okt\0", "Nof\0", "Dis\0" },
        { "Bisha Koobaad\0", "Bisha Labaad\0", "Bisha Saddexaad\0", "Bisha Afraad\0", "Bisha Shanaad\0", "Bisha Lixaad\0", "Bisha Todobaad\0", "Bisha Sideedaad\0", "Bisha Sagaalaad\0", "Bisha Tobnaad\0", "Bisha Kow iyo Tobnaad\0", "Bisha Laba iyo Tobnaad\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "L\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Isn\0", "Tldo\0", "Arbc\0", "Khms\0", "Jmc\0", "Sbti\0", "Axd\0" },
        { "Isniin\0", "Talaado\0", "Arbaco\0", "Khamiis\0", "Jimco\0", "Sabti\0", "Axad\0" },
        { "I\0", "T\0", "A\0", "Kh\0", "J\0", "S\0", "A\0" },
        { "Isn\0", "Tldo\0", "Arbc\0", "Khms\0", "Jmc\0", "Sbti\0", "Axd\0" },
        { "Isniin\0", "Talaado\0", "Arbaco\0", "Khamiis\0", "Jimco\0", "Sabti\0", "Axad\0" },
        { "I\0", "T\0", "A\0", "Kh\0", "J\0", "S\0", "A\0" }
    }, // so_DJ
    {
        QLocale::Language::Somali, QLocale::Script::LatinScript, QLocale::Country::Ethiopia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Soomaali\0", "Itoobiya\0",
        "dd/MM/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "GH\0", "GD\0",
        { "Jan\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Lul\0", "Ogs\0", "Seb\0", "Okt\0", "Nof\0", "Dis\0" },
        { "Jannaayo\0", "Febraayo\0", "Maarso\0", "Abriil\0", "May\0", "Juun\0", "Luuliyo\0", "Ogost\0", "Sebtembar\0", "Oktoobar\0", "Nofembar\0", "Desembar\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "L\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Lul\0", "Ogs\0", "Seb\0", "Okt\0", "Nof\0", "Dis\0" },
        { "Bisha Koobaad\0", "Bisha Labaad\0", "Bisha Saddexaad\0", "Bisha Afraad\0", "Bisha Shanaad\0", "Bisha Lixaad\0", "Bisha Todobaad\0", "Bisha Sideedaad\0", "Bisha Sagaalaad\0", "Bisha Tobnaad\0", "Bisha Kow iyo Tobnaad\0", "Bisha Laba iyo Tobnaad\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "L\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Isn\0", "Tldo\0", "Arbc\0", "Khms\0", "Jmc\0", "Sbti\0", "Axd\0" },
        { "Isniin\0", "Talaado\0", "Arbaco\0", "Khamiis\0", "Jimco\0", "Sabti\0", "Axad\0" },
        { "I\0", "T\0", "A\0", "Kh\0", "J\0", "S\0", "A\0" },
        { "Isn\0", "Tldo\0", "Arbc\0", "Khms\0", "Jmc\0", "Sbti\0", "Axd\0" },
        { "Isniin\0", "Talaado\0", "Arbaco\0", "Khamiis\0", "Jimco\0", "Sabti\0", "Axad\0" },
        { "I\0", "T\0", "A\0", "Kh\0", "J\0", "S\0", "A\0" }
    }, // so_ET
    {
        QLocale::Language::Somali, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Soomaali\0", "Kenya\0",
        "dd/MM/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "GH\0", "GD\0",
        { "Jan\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Lul\0", "Ogs\0", "Seb\0", "Okt\0", "Nof\0", "Dis\0" },
        { "Jannaayo\0", "Febraayo\0", "Maarso\0", "Abriil\0", "May\0", "Juun\0", "Luuliyo\0", "Ogost\0", "Sebtembar\0", "Oktoobar\0", "Nofembar\0", "Desembar\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "L\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Lul\0", "Ogs\0", "Seb\0", "Okt\0", "Nof\0", "Dis\0" },
        { "Bisha Koobaad\0", "Bisha Labaad\0", "Bisha Saddexaad\0", "Bisha Afraad\0", "Bisha Shanaad\0", "Bisha Lixaad\0", "Bisha Todobaad\0", "Bisha Sideedaad\0", "Bisha Sagaalaad\0", "Bisha Tobnaad\0", "Bisha Kow iyo Tobnaad\0", "Bisha Laba iyo Tobnaad\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "L\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Isn\0", "Tldo\0", "Arbc\0", "Khms\0", "Jmc\0", "Sbti\0", "Axd\0" },
        { "Isniin\0", "Talaado\0", "Arbaco\0", "Khamiis\0", "Jimco\0", "Sabti\0", "Axad\0" },
        { "I\0", "T\0", "A\0", "Kh\0", "J\0", "S\0", "A\0" },
        { "Isn\0", "Tldo\0", "Arbc\0", "Khms\0", "Jmc\0", "Sbti\0", "Axd\0" },
        { "Isniin\0", "Talaado\0", "Arbaco\0", "Khamiis\0", "Jimco\0", "Sabti\0", "Axad\0" },
        { "I\0", "T\0", "A\0", "Kh\0", "J\0", "S\0", "A\0" }
    }, // so_KE
    {
        QLocale::Language::Somali, QLocale::Script::LatinScript, QLocale::Country::Somalia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Soomaali\0", "Soomaaliya\0",
        "dd/MM/yyyy\0", "MMMM d, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "GH\0", "GD\0",
        { "Jan\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Lul\0", "Ogs\0", "Seb\0", "Okt\0", "Nof\0", "Dis\0" },
        { "Jannaayo\0", "Febraayo\0", "Maarso\0", "Abriil\0", "May\0", "Juun\0", "Luuliyo\0", "Ogost\0", "Sebtembar\0", "Oktoobar\0", "Nofembar\0", "Desembar\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "L\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Abr\0", "May\0", "Jun\0", "Lul\0", "Ogs\0", "Seb\0", "Okt\0", "Nof\0", "Dis\0" },
        { "Bisha Koobaad\0", "Bisha Labaad\0", "Bisha Saddexaad\0", "Bisha Afraad\0", "Bisha Shanaad\0", "Bisha Lixaad\0", "Bisha Todobaad\0", "Bisha Sideedaad\0", "Bisha Sagaalaad\0", "Bisha Tobnaad\0", "Bisha Kow iyo Tobnaad\0", "Bisha Laba iyo Tobnaad\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "L\0", "O\0", "S\0", "O\0", "N\0", "D\0" },
        { "Isn\0", "Tldo\0", "Arbc\0", "Khms\0", "Jmc\0", "Sbti\0", "Axd\0" },
        { "Isniin\0", "Talaado\0", "Arbaco\0", "Khamiis\0", "Jimco\0", "Sabti\0", "Axad\0" },
        { "I\0", "T\0", "A\0", "Kh\0", "J\0", "S\0", "A\0" },
        { "Isn\0", "Tldo\0", "Arbc\0", "Khms\0", "Jmc\0", "Sbti\0", "Axd\0" },
        { "Isniin\0", "Talaado\0", "Arbaco\0", "Khamiis\0", "Jimco\0", "Sabti\0", "Axad\0" },
        { "I\0", "T\0", "A\0", "Kh\0", "J\0", "S\0", "A\0" }
    }, // so_SO
    {
        QLocale::Language::Albanian, QLocale::Script::LatinScript, QLocale::Country::Albania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "shqip\0", "Shqipëri\0",
        "d.M.yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP, Z\0",
        "paradite\0", "pasdite\0",
        { "jan\0", "shk\0", "mar\0", "pri\0", "maj\0", "qer\0", "korr\0", "gush\0", "sht\0", "tet\0", "nën\0", "dhj\0" },
        { "janar\0", "shkurt\0", "mars\0", "prill\0", "maj\0", "qershor\0", "korrik\0", "gusht\0", "shtator\0", "tetor\0", "nëntor\0", "dhjetor\0" },
        { "j\0", "sh\0", "m\0", "p\0", "m\0", "q\0", "k\0", "g\0", "sh\0", "t\0", "n\0", "dh\0" },
        { "jan\0", "shk\0", "mar\0", "pri\0", "maj\0", "qer\0", "korr\0", "gush\0", "sht\0", "tet\0", "nën\0", "dhj\0" },
        { "janar\0", "shkurt\0", "mars\0", "prill\0", "maj\0", "qershor\0", "korrik\0", "gusht\0", "shtator\0", "tetor\0", "nëntor\0", "dhjetor\0" },
        { "j\0", "sh\0", "m\0", "p\0", "m\0", "q\0", "k\0", "g\0", "sh\0", "t\0", "n\0", "dh\0" },
        { "hën\0", "mar\0", "mër\0", "enj\0", "pre\0", "sht\0", "die\0" },
        { "e hënë\0", "e martë\0", "e mërkurë\0", "e enjte\0", "e premte\0", "e shtunë\0", "e diel\0" },
        { "h\0", "m\0", "m\0", "e\0", "p\0", "sh\0", "d\0" },
        { "Hën\0", "Mar\0", "Mër\0", "Enj\0", "Pre\0", "Sht\0", "Die\0" },
        { "e hënë\0", "e martë\0", "e mërkurë\0", "e enjte\0", "e premte\0", "e shtunë\0", "e diel\0" },
        { "h\0", "m\0", "m\0", "e\0", "p\0", "sh\0", "d\0" }
    }, // sq_AL
    {
        QLocale::Language::Albanian, QLocale::Script::AnyScript, QLocale::Country::NorthMacedonia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "shqip\0", "Maqedonia e Veriut\0",
        "d.M.yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "paradite\0", "pasdite\0",
        { "jan\0", "shk\0", "mar\0", "pri\0", "maj\0", "qer\0", "korr\0", "gush\0", "sht\0", "tet\0", "nën\0", "dhj\0" },
        { "janar\0", "shkurt\0", "mars\0", "prill\0", "maj\0", "qershor\0", "korrik\0", "gusht\0", "shtator\0", "tetor\0", "nëntor\0", "dhjetor\0" },
        { "j\0", "sh\0", "m\0", "p\0", "m\0", "q\0", "k\0", "g\0", "sh\0", "t\0", "n\0", "dh\0" },
        { "jan\0", "shk\0", "mar\0", "pri\0", "maj\0", "qer\0", "korr\0", "gush\0", "sht\0", "tet\0", "nën\0", "dhj\0" },
        { "janar\0", "shkurt\0", "mars\0", "prill\0", "maj\0", "qershor\0", "korrik\0", "gusht\0", "shtator\0", "tetor\0", "nëntor\0", "dhjetor\0" },
        { "j\0", "sh\0", "m\0", "p\0", "m\0", "q\0", "k\0", "g\0", "sh\0", "t\0", "n\0", "dh\0" },
        { "hën\0", "mar\0", "mër\0", "enj\0", "pre\0", "sht\0", "die\0" },
        { "e hënë\0", "e martë\0", "e mërkurë\0", "e enjte\0", "e premte\0", "e shtunë\0", "e diel\0" },
        { "h\0", "m\0", "m\0", "e\0", "p\0", "sh\0", "d\0" },
        { "Hën\0", "Mar\0", "Mër\0", "Enj\0", "Pre\0", "Sht\0", "Die\0" },
        { "e hënë\0", "e martë\0", "e mërkurë\0", "e enjte\0", "e premte\0", "e shtunë\0", "e diel\0" },
        { "h\0", "m\0", "m\0", "e\0", "p\0", "sh\0", "d\0" }
    }, // sq_MK
    {
        QLocale::Language::Albanian, QLocale::Script::LatinScript, QLocale::Country::Kosovo,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "shqip\0", "Kosovë\0",
        "d.M.yyyy\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "paradite\0", "pasdite\0",
        { "jan\0", "shk\0", "mar\0", "pri\0", "maj\0", "qer\0", "korr\0", "gush\0", "sht\0", "tet\0", "nën\0", "dhj\0" },
        { "janar\0", "shkurt\0", "mars\0", "prill\0", "maj\0", "qershor\0", "korrik\0", "gusht\0", "shtator\0", "tetor\0", "nëntor\0", "dhjetor\0" },
        { "j\0", "sh\0", "m\0", "p\0", "m\0", "q\0", "k\0", "g\0", "sh\0", "t\0", "n\0", "dh\0" },
        { "jan\0", "shk\0", "mar\0", "pri\0", "maj\0", "qer\0", "korr\0", "gush\0", "sht\0", "tet\0", "nën\0", "dhj\0" },
        { "janar\0", "shkurt\0", "mars\0", "prill\0", "maj\0", "qershor\0", "korrik\0", "gusht\0", "shtator\0", "tetor\0", "nëntor\0", "dhjetor\0" },
        { "j\0", "sh\0", "m\0", "p\0", "m\0", "q\0", "k\0", "g\0", "sh\0", "t\0", "n\0", "dh\0" },
        { "hën\0", "mar\0", "mër\0", "enj\0", "pre\0", "sht\0", "die\0" },
        { "e hënë\0", "e martë\0", "e mërkurë\0", "e enjte\0", "e premte\0", "e shtunë\0", "e diel\0" },
        { "h\0", "m\0", "m\0", "e\0", "p\0", "sh\0", "d\0" },
        { "Hën\0", "Mar\0", "Mër\0", "Enj\0", "Pre\0", "Sht\0", "Die\0" },
        { "e hënë\0", "e martë\0", "e mërkurë\0", "e enjte\0", "e premte\0", "e shtunë\0", "e diel\0" },
        { "h\0", "m\0", "m\0", "e\0", "p\0", "sh\0", "d\0" }
    }, // sq_XK
    {
        QLocale::Language::Serbian, QLocale::Script::CyrillicScript, QLocale::Country::BosniaAndHerzegovina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "српски\0", "Босна и Херцеговина\0",
        "d.M.yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "прије подне\0", "по подне\0",
        { "јан\0", "феб\0", "мар\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "сеп\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "јан\0", "феб\0", "мар\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "сеп\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "пон\0", "уто\0", "сри\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедјељак\0", "уторак\0", "сриједа\0", "четвртак\0", "петак\0", "субота\0", "недјеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедјељак\0", "уторак\0", "сриједа\0", "четвртак\0", "петак\0", "субота\0", "недјеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // sr_Cyrl_BA
    {
        QLocale::Language::Serbian, QLocale::Script::CyrillicScript, QLocale::Country::Montenegro,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "српски\0", "Црна Гора\0",
        "d.M.yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "прије подне\0", "по подне\0",
        { "јан\0", "феб\0", "март\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "септ\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "јан\0", "феб\0", "март\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "септ\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедељак\0", "уторак\0", "сриједа\0", "четвртак\0", "петак\0", "субота\0", "недјеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедељак\0", "уторак\0", "сриједа\0", "четвртак\0", "петак\0", "субота\0", "недјеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // sr_Cyrl_ME
    {
        QLocale::Language::Serbian, QLocale::Script::CyrillicScript, QLocale::Country::Serbia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "српски\0", "Србија\0",
        "d.M.yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "јан\0", "феб\0", "мар\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "сеп\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "јан\0", "феб\0", "мар\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "сеп\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедељак\0", "уторак\0", "среда\0", "четвртак\0", "петак\0", "субота\0", "недеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедељак\0", "уторак\0", "среда\0", "четвртак\0", "петак\0", "субота\0", "недеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // sr_Cyrl_RS
    {
        QLocale::Language::Serbian, QLocale::Script::CyrillicScript, QLocale::Country::Kosovo,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "српски\0", "Косово\0",
        "d.M.yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "јан\0", "феб\0", "март\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "септ\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "јан\0", "феб\0", "март\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "септ\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедељак\0", "уторак\0", "среда\0", "четвртак\0", "петак\0", "субота\0", "недеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедељак\0", "уторак\0", "среда\0", "четвртак\0", "петак\0", "субота\0", "недеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // sr_Cyrl_XK
    {
        QLocale::Language::Serbian, QLocale::Script::LatinScript, QLocale::Country::BosniaAndHerzegovina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "српски\0", "Босна и Херцеговина\0",
        "d.M.yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "prije podne\0", "po podne\0",
        { "јан\0", "феб\0", "мар\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "сеп\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "јан\0", "феб\0", "мар\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "сеп\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "pon\0", "uto\0", "sri\0", "čet\0", "pet\0", "sub\0", "ned\0" },
        { "ponedjeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "ponedjeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // sr_Latn_BA
    {
        QLocale::Language::Serbian, QLocale::Script::LatinScript, QLocale::Country::Montenegro,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "српски\0", "Црна Гора\0",
        "d.M.yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "prije podne\0", "po podne\0",
        { "јан\0", "феб\0", "mart\0", "апр\0", "maj\0", "jun\0", "jul\0", "авг\0", "sept\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "јан\0", "феб\0", "mart\0", "апр\0", "maj\0", "jun\0", "jul\0", "авг\0", "sept\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "ponedeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "ponedeljak\0", "utorak\0", "srijeda\0", "četvrtak\0", "petak\0", "subota\0", "nedjelja\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // sr_Latn_ME
    {
        QLocale::Language::Serbian, QLocale::Script::LatinScript, QLocale::Country::Serbia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "српски\0", "Србија\0",
        "d.M.yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "јан\0", "феб\0", "мар\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "сеп\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "јан\0", "феб\0", "мар\0", "апр\0", "мај\0", "јун\0", "јул\0", "авг\0", "сеп\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедељак\0", "уторак\0", "среда\0", "четвртак\0", "петак\0", "субота\0", "недеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедељак\0", "уторак\0", "среда\0", "четвртак\0", "петак\0", "субота\0", "недеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // sr_Latn_RS
    {
        QLocale::Language::Serbian, QLocale::Script::LatinScript, QLocale::Country::Kosovo,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "српски\0", "Косово\0",
        "d.M.yyyy.\0", "d. MMMM yyyy.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "јан\0", "феб\0", "mart\0", "апр\0", "maj\0", "jun\0", "jul\0", "авг\0", "sept\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "јан\0", "феб\0", "mart\0", "апр\0", "maj\0", "jun\0", "jul\0", "авг\0", "sept\0", "окт\0", "нов\0", "дец\0" },
        { "јануар\0", "фебруар\0", "март\0", "април\0", "мај\0", "јун\0", "јул\0", "август\0", "септембар\0", "октобар\0", "новембар\0", "децембар\0" },
        { "ј\0", "ф\0", "м\0", "а\0", "м\0", "ј\0", "ј\0", "а\0", "с\0", "о\0", "н\0", "д\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедељак\0", "уторак\0", "среда\0", "четвртак\0", "петак\0", "субота\0", "недеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" },
        { "пон\0", "уто\0", "сре\0", "чет\0", "пет\0", "суб\0", "нед\0" },
        { "понедељак\0", "уторак\0", "среда\0", "четвртак\0", "петак\0", "субота\0", "недеља\0" },
        { "п\0", "у\0", "с\0", "ч\0", "п\0", "с\0", "н\0" }
    }, // sr_Latn_XK
    {
        QLocale::Language::Sundanese, QLocale::Script::LatinScript, QLocale::Country::Indonesia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Basa Sunda\0", nullptr,
        "d/M/yyyy\0", "d MMMM yyyy\0", "H.mm\0", "H.mm.ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "Januari\0", "Pébruari\0", "Maret\0", "April\0", "Méi\0", "Juni\0", "Juli\0", "Agustus\0", "Séptémber\0", "Oktober\0", "Nopémber\0", "Désémber\0" },
        { "J\0", "P\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Péb\0", "Mar\0", "Apr\0", "Méi\0", "Jun\0", "Jul\0", "Ags\0", "Sép\0", "Okt\0", "Nop\0", "Dés\0" },
        { "Januari\0", "Pébruari\0", "Maret\0", "April\0", "Méi\0", "Juni\0", "Juli\0", "Agustus\0", "Séptémber\0", "Oktober\0", "Nopémber\0", "Désémber\0" },
        { "J\0", "P\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Sen\0", "Sal\0", "Reb\0", "Kem\0", "Jum\0", "Sap\0", "Mng\0" },
        { "Senén\0", "Salasa\0", "Rebo\0", "Kemis\0", "Jumaah\0", "Saptu\0", "Minggu\0" },
        { "S\0", "S\0", "R\0", "K\0", "J\0", "S\0", "M\0" },
        { "Sen\0", "Sal\0", "Reb\0", "Kem\0", "Jum\0", "Sap\0", "Mng\0" },
        { "Senén\0", "Salasa\0", "Rebo\0", "Kemis\0", "Jumaah\0", "Saptu\0", "Minggu\0" },
        { "S\0", "S\0", "R\0", "K\0", "J\0", "S\0", "M\0" }
    }, // su_Latn_ID
    {
        QLocale::Language::Swedish, QLocale::Script::LatinScript, QLocale::Country::AlandIslands,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "svenska\0", "Åland\0",
        "yyyy-MM-dd\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "förmiddag\0", "eftermiddag\0",
        { "jan.\0", "feb.\0", "mars\0", "apr.\0", "maj\0", "juni\0", "juli\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "mars\0", "april\0", "maj\0", "juni\0", "juli\0", "augusti\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mars\0", "apr.\0", "maj\0", "juni\0", "juli\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "mars\0", "april\0", "maj\0", "juni\0", "juli\0", "augusti\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "mån\0", "tis\0", "ons\0", "tors\0", "fre\0", "lör\0", "sön\0" },
        { "måndag\0", "tisdag\0", "onsdag\0", "torsdag\0", "fredag\0", "lördag\0", "söndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" },
        { "mån\0", "tis\0", "ons\0", "tors\0", "fre\0", "lör\0", "sön\0" },
        { "måndag\0", "tisdag\0", "onsdag\0", "torsdag\0", "fredag\0", "lördag\0", "söndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" }
    }, // sv_AX
    {
        QLocale::Language::Swedish, QLocale::Script::LatinScript, QLocale::Country::Finland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "svenska\0", "Finland\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "förmiddag\0", "eftermiddag\0",
        { "jan.\0", "feb.\0", "mars\0", "apr.\0", "maj\0", "juni\0", "juli\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "mars\0", "april\0", "maj\0", "juni\0", "juli\0", "augusti\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "jan.\0", "feb.\0", "mars\0", "apr.\0", "maj\0", "juni\0", "juli\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "mars\0", "april\0", "maj\0", "juni\0", "juli\0", "augusti\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "mån\0", "tis\0", "ons\0", "tors\0", "fre\0", "lör\0", "sön\0" },
        { "måndag\0", "tisdag\0", "onsdag\0", "torsdag\0", "fredag\0", "lördag\0", "söndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" },
        { "mån\0", "tis\0", "ons\0", "tors\0", "fre\0", "lör\0", "sön\0" },
        { "måndag\0", "tisdag\0", "onsdag\0", "torsdag\0", "fredag\0", "lördag\0", "söndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" }
    }, // sv_FI
    {
        QLocale::Language::Swedish, QLocale::Script::LatinScript, QLocale::Country::Sweden,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 8722, 43, 69, 48,
        "svenska\0", "Sverige\0",
        "yyyy-MM-dd\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "förmiddag\0", "eftermiddag\0",
        { "jan.\0", "feb.\0", "mars\0", "apr.\0", "maj\0", "juni\0", "juli\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "mars\0", "april\0", "maj\0", "juni\0", "juli\0", "augusti\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "jan.\0", "feb.\0", "mars\0", "apr.\0", "maj\0", "juni\0", "juli\0", "aug.\0", "sep.\0", "okt.\0", "nov.\0", "dec.\0" },
        { "januari\0", "februari\0", "mars\0", "april\0", "maj\0", "juni\0", "juli\0", "augusti\0", "september\0", "oktober\0", "november\0", "december\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "mån\0", "tis\0", "ons\0", "tors\0", "fre\0", "lör\0", "sön\0" },
        { "måndag\0", "tisdag\0", "onsdag\0", "torsdag\0", "fredag\0", "lördag\0", "söndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" },
        { "mån\0", "tis\0", "ons\0", "tors\0", "fre\0", "lör\0", "sön\0" },
        { "måndag\0", "tisdag\0", "onsdag\0", "torsdag\0", "fredag\0", "lördag\0", "söndag\0" },
        { "M\0", "T\0", "O\0", "T\0", "F\0", "L\0", "S\0" }
    }, // sv_SE
    {
        QLocale::Language::Swahili, QLocale::Script::AnyScript, QLocale::Country::CongoKinshasa,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Kiswahili\0", "Jamhuri ya Kidemokrasia ya Kongo\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // sw_CD
    {
        QLocale::Language::Swahili, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kiswahili\0", "Kenya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // sw_KE
    {
        QLocale::Language::Swahili, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kiswahili\0", "Tanzania\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // sw_TZ
    {
        QLocale::Language::Swahili, QLocale::Script::LatinScript, QLocale::Country::Uganda,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kiswahili\0", "Uganda\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprili\0", "Mei\0", "Juni\0", "Julai\0", "Agosti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "Jumatatu\0", "Jumanne\0", "Jumatano\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapili\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // sw_UG
    {
        QLocale::Language::Tamil, QLocale::Script::AnyScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "தமிழ்\0", "இந்தியா\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "AP h:mm\0", "AP h:mm:ss Z\0",
        "முற்பகல்\0", "பிற்பகல்\0",
        { "ஜன.\0", "பிப்.\0", "மார்.\0", "ஏப்.\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆக.\0", "செப்.\0", "அக்.\0", "நவ.\0", "டிச.\0" },
        { "ஜனவரி\0", "பிப்ரவரி\0", "மார்ச்\0", "ஏப்ரல்\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆகஸ்ட்\0", "செப்டம்பர்\0", "அக்டோபர்\0", "நவம்பர்\0", "டிசம்பர்\0" },
        { "ஜ\0", "பி\0", "மா\0", "ஏ\0", "மே\0", "ஜூ\0", "ஜூ\0", "ஆ\0", "செ\0", "அ\0", "ந\0", "டி\0" },
        { "ஜன.\0", "பிப்.\0", "மார்.\0", "ஏப்.\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆக.\0", "செப்.\0", "அக்.\0", "நவ.\0", "டிச.\0" },
        { "ஜனவரி\0", "பிப்ரவரி\0", "மார்ச்\0", "ஏப்ரல்\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆகஸ்ட்\0", "செப்டம்பர்\0", "அக்டோபர்\0", "நவம்பர்\0", "டிசம்பர்\0" },
        { "ஜ\0", "பி\0", "மா\0", "ஏ\0", "மே\0", "ஜூ\0", "ஜூ\0", "ஆ\0", "செ\0", "அ\0", "ந\0", "டி\0" },
        { "திங்.\0", "செவ்.\0", "புத.\0", "வியா.\0", "வெள்.\0", "சனி\0", "ஞாயி.\0" },
        { "திங்கள்\0", "செவ்வாய்\0", "புதன்\0", "வியாழன்\0", "வெள்ளி\0", "சனி\0", "ஞாயிறு\0" },
        { "தி\0", "செ\0", "பு\0", "வி\0", "வெ\0", "ச\0", "ஞா\0" },
        { "திங்.\0", "செவ்.\0", "புத.\0", "வியா.\0", "வெள்.\0", "சனி\0", "ஞாயி.\0" },
        { "திங்கள்\0", "செவ்வாய்\0", "புதன்\0", "வியாழன்\0", "வெள்ளி\0", "சனி\0", "ஞாயிறு\0" },
        { "தி\0", "செ\0", "பு\0", "வி\0", "வெ\0", "ச\0", "ஞா\0" }
    }, // ta_IN
    {
        QLocale::Language::Tamil, QLocale::Script::TamilScript, QLocale::Country::SriLanka,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "தமிழ்\0", "இலங்கை\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "முற்பகல்\0", "பிற்பகல்\0",
        { "ஜன.\0", "பிப்.\0", "மார்.\0", "ஏப்.\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆக.\0", "செப்.\0", "அக்.\0", "நவ.\0", "டிச.\0" },
        { "ஜனவரி\0", "பிப்ரவரி\0", "மார்ச்\0", "ஏப்ரல்\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆகஸ்ட்\0", "செப்டம்பர்\0", "அக்டோபர்\0", "நவம்பர்\0", "டிசம்பர்\0" },
        { "ஜ\0", "பி\0", "மா\0", "ஏ\0", "மே\0", "ஜூ\0", "ஜூ\0", "ஆ\0", "செ\0", "அ\0", "ந\0", "டி\0" },
        { "ஜன.\0", "பிப்.\0", "மார்.\0", "ஏப்.\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆக.\0", "செப்.\0", "அக்.\0", "நவ.\0", "டிச.\0" },
        { "ஜனவரி\0", "பிப்ரவரி\0", "மார்ச்\0", "ஏப்ரல்\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆகஸ்ட்\0", "செப்டம்பர்\0", "அக்டோபர்\0", "நவம்பர்\0", "டிசம்பர்\0" },
        { "ஜ\0", "பி\0", "மா\0", "ஏ\0", "மே\0", "ஜூ\0", "ஜூ\0", "ஆ\0", "செ\0", "அ\0", "ந\0", "டி\0" },
        { "திங்.\0", "செவ்.\0", "புத.\0", "வியா.\0", "வெள்.\0", "சனி\0", "ஞாயி.\0" },
        { "திங்கள்\0", "செவ்வாய்\0", "புதன்\0", "வியாழன்\0", "வெள்ளி\0", "சனி\0", "ஞாயிறு\0" },
        { "தி\0", "செ\0", "பு\0", "வி\0", "வெ\0", "ச\0", "ஞா\0" },
        { "திங்.\0", "செவ்.\0", "புத.\0", "வியா.\0", "வெள்.\0", "சனி\0", "ஞாயி.\0" },
        { "திங்கள்\0", "செவ்வாய்\0", "புதன்\0", "வியாழன்\0", "வெள்ளி\0", "சனி\0", "ஞாயிறு\0" },
        { "தி\0", "செ\0", "பு\0", "வி\0", "வெ\0", "ச\0", "ஞா\0" }
    }, // ta_LK
    {
        QLocale::Language::Tamil, QLocale::Script::AnyScript, QLocale::Country::Malaysia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "தமிழ்\0", "மலேசியா\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "AP h:mm\0", "AP h:mm:ss Z\0",
        "முற்பகல்\0", "பிற்பகல்\0",
        { "ஜன.\0", "பிப்.\0", "மார்.\0", "ஏப்.\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆக.\0", "செப்.\0", "அக்.\0", "நவ.\0", "டிச.\0" },
        { "ஜனவரி\0", "பிப்ரவரி\0", "மார்ச்\0", "ஏப்ரல்\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆகஸ்ட்\0", "செப்டம்பர்\0", "அக்டோபர்\0", "நவம்பர்\0", "டிசம்பர்\0" },
        { "ஜ\0", "பி\0", "மா\0", "ஏ\0", "மே\0", "ஜூ\0", "ஜூ\0", "ஆ\0", "செ\0", "அ\0", "ந\0", "டி\0" },
        { "ஜன.\0", "பிப்.\0", "மார்.\0", "ஏப்.\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆக.\0", "செப்.\0", "அக்.\0", "நவ.\0", "டிச.\0" },
        { "ஜனவரி\0", "பிப்ரவரி\0", "மார்ச்\0", "ஏப்ரல்\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆகஸ்ட்\0", "செப்டம்பர்\0", "அக்டோபர்\0", "நவம்பர்\0", "டிசம்பர்\0" },
        { "ஜ\0", "பி\0", "மா\0", "ஏ\0", "மே\0", "ஜூ\0", "ஜூ\0", "ஆ\0", "செ\0", "அ\0", "ந\0", "டி\0" },
        { "திங்.\0", "செவ்.\0", "புத.\0", "வியா.\0", "வெள்.\0", "சனி\0", "ஞாயி.\0" },
        { "திங்கள்\0", "செவ்வாய்\0", "புதன்\0", "வியாழன்\0", "வெள்ளி\0", "சனி\0", "ஞாயிறு\0" },
        { "தி\0", "செ\0", "பு\0", "வி\0", "வெ\0", "ச\0", "ஞா\0" },
        { "திங்.\0", "செவ்.\0", "புத.\0", "வியா.\0", "வெள்.\0", "சனி\0", "ஞாயி.\0" },
        { "திங்கள்\0", "செவ்வாய்\0", "புதன்\0", "வியாழன்\0", "வெள்ளி\0", "சனி\0", "ஞாயிறு\0" },
        { "தி\0", "செ\0", "பு\0", "வி\0", "வெ\0", "ச\0", "ஞா\0" }
    }, // ta_MY
    {
        QLocale::Language::Tamil, QLocale::Script::TamilScript, QLocale::Country::Singapore,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "தமிழ்\0", "சிங்கப்பூர்\0",
        "d/M/yyyy\0", "d MMMM, yyyy\0", "AP h:mm\0", "AP h:mm:ss Z\0",
        "முற்பகல்\0", "பிற்பகல்\0",
        { "ஜன.\0", "பிப்.\0", "மார்.\0", "ஏப்.\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆக.\0", "செப்.\0", "அக்.\0", "நவ.\0", "டிச.\0" },
        { "ஜனவரி\0", "பிப்ரவரி\0", "மார்ச்\0", "ஏப்ரல்\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆகஸ்ட்\0", "செப்டம்பர்\0", "அக்டோபர்\0", "நவம்பர்\0", "டிசம்பர்\0" },
        { "ஜ\0", "பி\0", "மா\0", "ஏ\0", "மே\0", "ஜூ\0", "ஜூ\0", "ஆ\0", "செ\0", "அ\0", "ந\0", "டி\0" },
        { "ஜன.\0", "பிப்.\0", "மார்.\0", "ஏப்.\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆக.\0", "செப்.\0", "அக்.\0", "நவ.\0", "டிச.\0" },
        { "ஜனவரி\0", "பிப்ரவரி\0", "மார்ச்\0", "ஏப்ரல்\0", "மே\0", "ஜூன்\0", "ஜூலை\0", "ஆகஸ்ட்\0", "செப்டம்பர்\0", "அக்டோபர்\0", "நவம்பர்\0", "டிசம்பர்\0" },
        { "ஜ\0", "பி\0", "மா\0", "ஏ\0", "மே\0", "ஜூ\0", "ஜூ\0", "ஆ\0", "செ\0", "அ\0", "ந\0", "டி\0" },
        { "திங்.\0", "செவ்.\0", "புத.\0", "வியா.\0", "வெள்.\0", "சனி\0", "ஞாயி.\0" },
        { "திங்கள்\0", "செவ்வாய்\0", "புதன்\0", "வியாழன்\0", "வெள்ளி\0", "சனி\0", "ஞாயிறு\0" },
        { "தி\0", "செ\0", "பு\0", "வி\0", "வெ\0", "ச\0", "ஞா\0" },
        { "திங்.\0", "செவ்.\0", "புத.\0", "வியா.\0", "வெள்.\0", "சனி\0", "ஞாயி.\0" },
        { "திங்கள்\0", "செவ்வாய்\0", "புதன்\0", "வியாழன்\0", "வெள்ளி\0", "சனி\0", "ஞாயிறு\0" },
        { "தி\0", "செ\0", "பு\0", "வி\0", "வெ\0", "ச\0", "ஞா\0" }
    }, // ta_SG
    {
        QLocale::Language::Telugu, QLocale::Script::TeluguScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "తెలుగు\0", "భారతదేశం\0",
        "dd-MM-yyyy\0", "d MMMM, yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "జన\0", "ఫిబ్ర\0", "మార్చి\0", "ఏప్రి\0", "మే\0", "జూన్\0", "జులై\0", "ఆగ\0", "సెప్టెం\0", "అక్టో\0", "నవం\0", "డిసెం\0" },
        { "జనవరి\0", "ఫిబ్రవరి\0", "మార్చి\0", "ఏప్రిల్\0", "మే\0", "జూన్\0", "జులై\0", "ఆగస్టు\0", "సెప్టెంబర్\0", "అక్టోబర్\0", "నవంబర్\0", "డిసెంబర్\0" },
        { "జ\0", "ఫి\0", "మా\0", "ఏ\0", "మే\0", "జూ\0", "జు\0", "ఆ\0", "సె\0", "అ\0", "న\0", "డి\0" },
        { "జన\0", "ఫిబ్ర\0", "మార్చి\0", "ఏప్రి\0", "మే\0", "జూన్\0", "జులై\0", "ఆగ\0", "సెప్టెం\0", "అక్టో\0", "నవం\0", "డిసెం\0" },
        { "జనవరి\0", "ఫిబ్రవరి\0", "మార్చి\0", "ఏప్రిల్\0", "మే\0", "జూన్\0", "జులై\0", "ఆగస్టు\0", "సెప్టెంబర్\0", "అక్టోబర్\0", "నవంబర్\0", "డిసెంబర్\0" },
        { "జ\0", "ఫి\0", "మా\0", "ఏ\0", "మే\0", "జూ\0", "జు\0", "ఆ\0", "సె\0", "అ\0", "న\0", "డి\0" },
        { "సోమ\0", "మంగళ\0", "బుధ\0", "గురు\0", "శుక్ర\0", "శని\0", "ఆది\0" },
        { "సోమవారం\0", "మంగళవారం\0", "బుధవారం\0", "గురువారం\0", "శుక్రవారం\0", "శనివారం\0", "ఆదివారం\0" },
        { "సో\0", "మ\0", "బు\0", "గు\0", "శు\0", "శ\0", "ఆ\0" },
        { "సోమ\0", "మంగళ\0", "బుధ\0", "గురు\0", "శుక్ర\0", "శని\0", "ఆది\0" },
        { "సోమవారం\0", "మంగళవారం\0", "బుధవారం\0", "గురువారం\0", "శుక్రవారం\0", "శనివారం\0", "ఆదివారం\0" },
        { "సో\0", "మ\0", "బు\0", "గు\0", "శు\0", "శ\0", "ఆ\0" }
    }, // te_IN
    {
        QLocale::Language::Teso, QLocale::Script::LatinScript, QLocale::Country::Kenya,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kiteso\0", "Kenia\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Taparachu\0", "Ebongi\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "R\0", "M\0", "K\0", "D\0", "M\0", "M\0", "J\0", "P\0", "S\0", "T\0", "L\0", "P\0" },
        { "Rar\0", "Muk\0", "Kwa\0", "Dun\0", "Mar\0", "Mod\0", "Jol\0", "Ped\0", "Sok\0", "Tib\0", "Lab\0", "Poo\0" },
        { "Orara\0", "Omuk\0", "Okwamg’\0", "Odung’el\0", "Omaruk\0", "Omodok’king’ol\0", "Ojola\0", "Opedel\0", "Osokosokoma\0", "Otibar\0", "Olabor\0", "Opoo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "B\0", "A\0", "U\0", "U\0", "K\0", "S\0", "J\0" },
        { "Bar\0", "Aar\0", "Uni\0", "Ung\0", "Kan\0", "Sab\0", "Jum\0" },
        { "Nakaebarasa\0", "Nakaare\0", "Nakauni\0", "Nakaung’on\0", "Nakakany\0", "Nakasabiti\0", "Nakaejuma\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // teo_KE
    {
        QLocale::Language::Teso, QLocale::Script::LatinScript, QLocale::Country::Uganda,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kiteso\0", "Uganda\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Taparachu\0", "Ebongi\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "R\0", "M\0", "K\0", "D\0", "M\0", "M\0", "J\0", "P\0", "S\0", "T\0", "L\0", "P\0" },
        { "Rar\0", "Muk\0", "Kwa\0", "Dun\0", "Mar\0", "Mod\0", "Jol\0", "Ped\0", "Sok\0", "Tib\0", "Lab\0", "Poo\0" },
        { "Orara\0", "Omuk\0", "Okwamg’\0", "Odung’el\0", "Omaruk\0", "Omodok’king’ol\0", "Ojola\0", "Opedel\0", "Osokosokoma\0", "Otibar\0", "Olabor\0", "Opoo\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "B\0", "A\0", "U\0", "U\0", "K\0", "S\0", "J\0" },
        { "Bar\0", "Aar\0", "Uni\0", "Ung\0", "Kan\0", "Sab\0", "Jum\0" },
        { "Nakaebarasa\0", "Nakaare\0", "Nakauni\0", "Nakaung’on\0", "Nakakany\0", "Nakasabiti\0", "Nakaejuma\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // teo_UG
    {
        QLocale::Language::Tajik, QLocale::Script::AnyScript, QLocale::Country::Tajikistan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "тоҷикӣ\0", "Тоҷикистон\0",
        "dd/MM/yyyy\0", "dd MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Янв\0", "Фев\0", "Мар\0", "Апр\0", "Май\0", "Июн\0", "Июл\0", "Авг\0", "Сен\0", "Окт\0", "Ноя\0", "Дек\0" },
        { "Январ\0", "Феврал\0", "Март\0", "Апрел\0", "Май\0", "Июн\0", "Июл\0", "Август\0", "Сентябр\0", "Октябр\0", "Ноябр\0", "Декабр\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "Янв\0", "Фев\0", "Мар\0", "Апр\0", "Май\0", "Июн\0", "Июл\0", "Авг\0", "Сен\0", "Окт\0", "Ноя\0", "Дек\0" },
        { "Январ\0", "Феврал\0", "Март\0", "Апрел\0", "Май\0", "Июн\0", "Июл\0", "Август\0", "Сентябр\0", "Октябр\0", "Ноябр\0", "Декабр\0" },
        { "Я\0", "Ф\0", "М\0", "А\0", "М\0", "И\0", "И\0", "А\0", "С\0", "О\0", "Н\0", "Д\0" },
        { "Дшб\0", "Сшб\0", "Чшб\0", "Пшб\0", "Ҷмъ\0", "Шнб\0", "Яшб\0" },
        { "Душанбе\0", "Сешанбе\0", "Чоршанбе\0", "Панҷшанбе\0", "Ҷумъа\0", "Шанбе\0", "Якшанбе\0" },
        { "Д\0", "С\0", "Ч\0", "П\0", "Ҷ\0", "Ш\0", "Я\0" },
        { "Дшб\0", "Сшб\0", "Чшб\0", "Пшб\0", "Ҷмъ\0", "Шнб\0", "Яшб\0" },
        { "Душанбе\0", "Сешанбе\0", "Чоршанбе\0", "Панҷшанбе\0", "Ҷумъа\0", "Шанбе\0", "Якшанбе\0" },
        { "Д\0", "С\0", "Ч\0", "П\0", "Ҷ\0", "Ш\0", "Я\0" }
    }, // tg_TJ
    {
        QLocale::Language::Thai, QLocale::Script::ThaiScript, QLocale::Country::Thailand,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ไทย\0", "ไทย\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "H นาฬิกา mm นาที ss วินาที Z\0",
        "ก่อนเที่ยง\0", "หลังเที่ยง\0",
        { "ม.ค.\0", "ก.พ.\0", "มี.ค.\0", "เม.ย.\0", "พ.ค.\0", "มิ.ย.\0", "ก.ค.\0", "ส.ค.\0", "ก.ย.\0", "ต.ค.\0", "พ.ย.\0", "ธ.ค.\0" },
        { "มกราคม\0", "กุมภาพันธ์\0", "มีนาคม\0", "เมษายน\0", "พฤษภาคม\0", "มิถุนายน\0", "กรกฎาคม\0", "สิงหาคม\0", "กันยายน\0", "ตุลาคม\0", "พฤศจิกายน\0", "ธันวาคม\0" },
        { "ม.ค.\0", "ก.พ.\0", "มี.ค.\0", "เม.ย.\0", "พ.ค.\0", "มิ.ย.\0", "ก.ค.\0", "ส.ค.\0", "ก.ย.\0", "ต.ค.\0", "พ.ย.\0", "ธ.ค.\0" },
        { "ม.ค.\0", "ก.พ.\0", "มี.ค.\0", "เม.ย.\0", "พ.ค.\0", "มิ.ย.\0", "ก.ค.\0", "ส.ค.\0", "ก.ย.\0", "ต.ค.\0", "พ.ย.\0", "ธ.ค.\0" },
        { "มกราคม\0", "กุมภาพันธ์\0", "มีนาคม\0", "เมษายน\0", "พฤษภาคม\0", "มิถุนายน\0", "กรกฎาคม\0", "สิงหาคม\0", "กันยายน\0", "ตุลาคม\0", "พฤศจิกายน\0", "ธันวาคม\0" },
        { "ม.ค.\0", "ก.พ.\0", "มี.ค.\0", "เม.ย.\0", "พ.ค.\0", "มิ.ย.\0", "ก.ค.\0", "ส.ค.\0", "ก.ย.\0", "ต.ค.\0", "พ.ย.\0", "ธ.ค.\0" },
        { "จ.\0", "อ.\0", "พ.\0", "พฤ.\0", "ศ.\0", "ส.\0", "อา.\0" },
        { "วันจันทร์\0", "วันอังคาร\0", "วันพุธ\0", "วันพฤหัสบดี\0", "วันศุกร์\0", "วันเสาร์\0", "วันอาทิตย์\0" },
        { "จ\0", "อ\0", "พ\0", "พฤ\0", "ศ\0", "ส\0", "อา\0" },
        { "จ.\0", "อ.\0", "พ.\0", "พฤ.\0", "ศ.\0", "ส.\0", "อา.\0" },
        { "วันจันทร์\0", "วันอังคาร\0", "วันพุธ\0", "วันพฤหัสบดี\0", "วันศุกร์\0", "วันเสาร์\0", "วันอาทิตย์\0" },
        { "จ\0", "อ\0", "พ\0", "พฤ\0", "ศ\0", "ส\0", "อา\0" }
    }, // th_TH
    {
        QLocale::Language::Tigrinya, QLocale::Script::EthiopicScript, QLocale::Country::Eritrea,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ትግርኛ\0", "ኤርትራ\0",
        "dd/MM/yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "ቅ.ቀ.\0", "ድ.ቀ.\0",
        { "ጥሪ\0", "ለካ\0", "መጋ\0", "ሚያ\0", "ግን\0", "ሰነ\0", "ሓም\0", "ነሓ\0", "መስ\0", "ጥቅ\0", "ሕዳ\0", "ታሕ\0" },
        { "ጥሪ\0", "ለካቲት\0", "መጋቢት\0", "ሚያዝያ\0", "ግንቦት\0", "ሰነ\0", "ሓምለ\0", "ነሓሰ\0", "መስከረም\0", "ጥቅምቲ\0", "ሕዳር\0", "ታሕሳስ\0" },
        { "ጥ\0", "ለ\0", "መ\0", "ሚ\0", "ግ\0", "ሰ\0", "ሓ\0", "ነ\0", "መ\0", "ጥ\0", "ሕ\0", "ታ\0" },
        { "ጥሪ\0", "ለካ\0", "መጋ\0", "ሚያ\0", "ግን\0", "ሰነ\0", "ሓም\0", "ነሓ\0", "መስ\0", "ጥቅ\0", "ሕዳ\0", "ታሕ\0" },
        { "ጥሪ\0", "ለካቲት\0", "መጋቢት\0", "ሚያዝያ\0", "ግንቦት\0", "ሰነ\0", "ሓምለ\0", "ነሓሰ\0", "መስከም\0", "ጥቅምቲ\0", "ሕዳር\0", "ታሕሳስ\0" },
        { "ጥ\0", "ለ\0", "መ\0", "ሚ\0", "ግ\0", "ሰ\0", "ሓ\0", "ነ\0", "መ\0", "ጥ\0", "ሕ\0", "ታ\0" },
        { "ሰኑ\0", "ሰሉ\0", "ረቡ\0", "ሓሙ\0", "ዓር\0", "ቀዳ\0", "ሰን\0" },
        { "ሰኑይ\0", "ሰሉስ\0", "ረቡዕ\0", "ሓሙስ\0", "ዓርቢ\0", "ቀዳም\0", "ሰንበት\0" },
        { "ሰ\0", "ሰ\0", "ረ\0", "ሓ\0", "ዓ\0", "ቀ\0", "ሰ\0" },
        { "ሰኑ\0", "ሰሉ\0", "ረቡ\0", "ሓሙ\0", "ዓር\0", "ቀዳ\0", "ሰን\0" },
        { "ሰኑይ\0", "ሰሉስ\0", "ረቡዕ\0", "ሓሙስ\0", "ዓርቢ\0", "ቀዳም\0", "ሰንበት\0" },
        { "ሰ\0", "ሰ\0", "ረ\0", "ሓ\0", "ዓ\0", "ቀ\0", "ሰ\0" }
    }, // ti_ER
    {
        QLocale::Language::Tigrinya, QLocale::Script::AnyScript, QLocale::Country::Ethiopia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ትግርኛ\0", "ኢትዮጵያ\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "ቅ.ቀ.\0", "ድ.ቀ.\0",
        { "ጥሪ\0", "ለካ\0", "መጋ\0", "ሚያ\0", "ግን\0", "ሰነ\0", "ሓም\0", "ነሓ\0", "መስ\0", "ጥቅ\0", "ሕዳ\0", "ታሕ\0" },
        { "ጥሪ\0", "ለካቲት\0", "መጋቢት\0", "ሚያዝያ\0", "ግንቦት\0", "ሰነ\0", "ሓምለ\0", "ነሓሰ\0", "መስከረም\0", "ጥቅምቲ\0", "ሕዳር\0", "ታሕሳስ\0" },
        { "ጥ\0", "ለ\0", "መ\0", "ሚ\0", "ግ\0", "ሰ\0", "ሓ\0", "ነ\0", "መ\0", "ጥ\0", "ሕ\0", "ታ\0" },
        { "ጥሪ\0", "ለካ\0", "መጋ\0", "ሚያ\0", "ግን\0", "ሰነ\0", "ሓም\0", "ነሓ\0", "መስ\0", "ጥቅ\0", "ሕዳ\0", "ታሕ\0" },
        { "ጥሪ\0", "ለካቲት\0", "መጋቢት\0", "ሚያዝያ\0", "ግንቦት\0", "ሰነ\0", "ሓምለ\0", "ነሓሰ\0", "መስከረም\0", "ጥቅምቲ\0", "ሕዳር\0", "ታሕሳስ\0" },
        { "ጥ\0", "ለ\0", "መ\0", "ሚ\0", "ግ\0", "ሰ\0", "ሓ\0", "ነ\0", "መ\0", "ጥ\0", "ሕ\0", "ታ\0" },
        { "ሰኑ\0", "ሰሉ\0", "ረቡ\0", "ሓሙ\0", "ዓር\0", "ቀዳ\0", "ሰን\0" },
        { "ሰኑይ\0", "ሰሉስ\0", "ረቡዕ\0", "ሓሙስ\0", "ዓርቢ\0", "ቀዳም\0", "ሰንበት\0" },
        { "ሰ\0", "ሰ\0", "ረ\0", "ሓ\0", "ዓ\0", "ቀ\0", "ሰ\0" },
        { "ሰኑ\0", "ሰሉ\0", "ረቡ\0", "ሓሙ\0", "ዓር\0", "ቀዳ\0", "ሰን\0" },
        { "ሰኑይ\0", "ሰሉስ\0", "ረቡዕ\0", "ሓሙስ\0", "ዓርቢ\0", "ቀዳም\0", "ሰንበት\0" },
        { "ሰ\0", "ሰ\0", "ረ\0", "ሓ\0", "ዓ\0", "ቀ\0", "ሰ\0" }
    }, // ti_ET
    {
        QLocale::Language::Turkmen, QLocale::Script::AnyScript, QLocale::Country::Turkmenistan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "türkmen dili\0", "Türkmenistan\0",
        "dd.MM.yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "günortadan öň\0", "günortadan soň\0",
        { "Ýan\0", "Few\0", "Mar\0", "Apr\0", "Maý\0", "Iýun\0", "Iýul\0", "Awg\0", "Sen\0", "Okt\0", "Noý\0", "Dek\0" },
        { "Ýanwar\0", "Fewral\0", "Mart\0", "Aprel\0", "Maý\0", "Iýun\0", "Iýul\0", "Awgust\0", "Sentýabr\0", "Oktýabr\0", "Noýabr\0", "Dekabr\0" },
        { "Ý\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "ýan\0", "few\0", "mart\0", "apr\0", "maý\0", "iýun\0", "iýul\0", "awg\0", "sen\0", "okt\0", "noý\0", "dek\0" },
        { "ýanwar\0", "fewral\0", "mart\0", "aprel\0", "maý\0", "iýun\0", "iýul\0", "awgust\0", "sentýabr\0", "oktýabr\0", "noýabr\0", "dekabr\0" },
        { "Ý\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Duş\0", "Siş\0", "Çar\0", "Pen\0", "Ann\0", "Şen\0", "Ýek\0" },
        { "Duşenbe\0", "Sişenbe\0", "Çarşenbe\0", "Penşenbe\0", "Anna\0", "Şenbe\0", "Ýekşenbe\0" },
        { "D\0", "S\0", "Ç\0", "P\0", "A\0", "Ş\0", "Ý\0" },
        { "duş\0", "siş\0", "çar\0", "pen\0", "ann\0", "şen\0", "ýek\0" },
        { "duşenbe\0", "sişenbe\0", "çarşenbe\0", "penşenbe\0", "anna\0", "şenbe\0", "ýekşenbe\0" },
        { "D\0", "S\0", "Ç\0", "P\0", "A\0", "Ş\0", "Ý\0" }
    }, // tk_TM
    {
        QLocale::Language::Tongan, QLocale::Script::LatinScript, QLocale::Country::Tonga,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "lea fakatonga\0", "Tonga\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "HH\0", "EA\0",
        { "Sān\0", "Fēp\0", "Maʻa\0", "ʻEpe\0", "Mē\0", "Sun\0", "Siu\0", "ʻAok\0", "Sep\0", "ʻOka\0", "Nōv\0", "Tīs\0" },
        { "Sānuali\0", "Fēpueli\0", "Maʻasi\0", "ʻEpeleli\0", "Mē\0", "Sune\0", "Siulai\0", "ʻAokosi\0", "Sepitema\0", "ʻOkatopa\0", "Nōvema\0", "Tīsema\0" },
        { "S\0", "F\0", "M\0", "E\0", "M\0", "S\0", "S\0", "A\0", "S\0", "O\0", "N\0", "T\0" },
        { "Sān\0", "Fēp\0", "Maʻa\0", "ʻEpe\0", "Mē\0", "Sun\0", "Siu\0", "ʻAok\0", "Sep\0", "ʻOka\0", "Nōv\0", "Tīs\0" },
        { "Sānuali\0", "Fēpueli\0", "Maʻasi\0", "ʻEpeleli\0", "Mē\0", "Sune\0", "Siulai\0", "ʻAokosi\0", "Sepitema\0", "ʻOkatopa\0", "Nōvema\0", "Tīsema\0" },
        { "S\0", "F\0", "M\0", "E\0", "M\0", "S\0", "S\0", "A\0", "S\0", "O\0", "N\0", "T\0" },
        { "Mōn\0", "Tūs\0", "Pul\0", "Tuʻa\0", "Fal\0", "Tok\0", "Sāp\0" },
        { "Mōnite\0", "Tūsite\0", "Pulelulu\0", "Tuʻapulelulu\0", "Falaite\0", "Tokonaki\0", "Sāpate\0" },
        { "M\0", "T\0", "P\0", "T\0", "F\0", "T\0", "S\0" },
        { "Mōn\0", "Tūs\0", "Pul\0", "Tuʻa\0", "Fal\0", "Tok\0", "Sāp\0" },
        { "Mōnite\0", "Tūsite\0", "Pulelulu\0", "Tuʻapulelulu\0", "Falaite\0", "Tokonaki\0", "Sāpate\0" },
        { "M\0", "T\0", "P\0", "T\0", "F\0", "T\0", "S\0" }
    }, // to_TO
    {
        QLocale::Language::Turkish, QLocale::Script::LatinScript, QLocale::Country::Cyprus,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Türkçe\0", "Kıbrıs\0",
        "d.MM.yyyy\0", "yyyy MMMM d\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "ÖÖ\0", "ÖS\0",
        { "Oca\0", "Şub\0", "Mar\0", "Nis\0", "May\0", "Haz\0", "Tem\0", "Ağu\0", "Eyl\0", "Eki\0", "Kas\0", "Ara\0" },
        { "Ocak\0", "Şubat\0", "Mart\0", "Nisan\0", "Mayıs\0", "Haziran\0", "Temmuz\0", "Ağustos\0", "Eylül\0", "Ekim\0", "Kasım\0", "Aralık\0" },
        { "O\0", "Ş\0", "M\0", "N\0", "M\0", "H\0", "T\0", "A\0", "E\0", "E\0", "K\0", "A\0" },
        { "Oca\0", "Şub\0", "Mar\0", "Nis\0", "May\0", "Haz\0", "Tem\0", "Ağu\0", "Eyl\0", "Eki\0", "Kas\0", "Ara\0" },
        { "Ocak\0", "Şubat\0", "Mart\0", "Nisan\0", "Mayıs\0", "Haziran\0", "Temmuz\0", "Ağustos\0", "Eylül\0", "Ekim\0", "Kasım\0", "Aralık\0" },
        { "O\0", "Ş\0", "M\0", "N\0", "M\0", "H\0", "T\0", "A\0", "E\0", "E\0", "K\0", "A\0" },
        { "Pzt\0", "Sal\0", "Çar\0", "Per\0", "Cum\0", "Cmt\0", "Paz\0" },
        { "Pazartesi\0", "Salı\0", "Çarşamba\0", "Perşembe\0", "Cuma\0", "Cumartesi\0", "Pazar\0" },
        { "P\0", "S\0", "Ç\0", "P\0", "C\0", "C\0", "P\0" },
        { "Pzt\0", "Sal\0", "Çar\0", "Per\0", "Cum\0", "Cmt\0", "Paz\0" },
        { "Pazartesi\0", "Salı\0", "Çarşamba\0", "Perşembe\0", "Cuma\0", "Cumartesi\0", "Pazar\0" },
        { "P\0", "S\0", "Ç\0", "P\0", "C\0", "C\0", "P\0" }
    }, // tr_CY
    {
        QLocale::Language::Turkish, QLocale::Script::LatinScript, QLocale::Country::Turkey,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Türkçe\0", "Türkiye\0",
        "d.MM.yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ÖÖ\0", "ÖS\0",
        { "Oca\0", "Şub\0", "Mar\0", "Nis\0", "May\0", "Haz\0", "Tem\0", "Ağu\0", "Eyl\0", "Eki\0", "Kas\0", "Ara\0" },
        { "Ocak\0", "Şubat\0", "Mart\0", "Nisan\0", "Mayıs\0", "Haziran\0", "Temmuz\0", "Ağustos\0", "Eylül\0", "Ekim\0", "Kasım\0", "Aralık\0" },
        { "O\0", "Ş\0", "M\0", "N\0", "M\0", "H\0", "T\0", "A\0", "E\0", "E\0", "K\0", "A\0" },
        { "Oca\0", "Şub\0", "Mar\0", "Nis\0", "May\0", "Haz\0", "Tem\0", "Ağu\0", "Eyl\0", "Eki\0", "Kas\0", "Ara\0" },
        { "Ocak\0", "Şubat\0", "Mart\0", "Nisan\0", "Mayıs\0", "Haziran\0", "Temmuz\0", "Ağustos\0", "Eylül\0", "Ekim\0", "Kasım\0", "Aralık\0" },
        { "O\0", "Ş\0", "M\0", "N\0", "M\0", "H\0", "T\0", "A\0", "E\0", "E\0", "K\0", "A\0" },
        { "Pzt\0", "Sal\0", "Çar\0", "Per\0", "Cum\0", "Cmt\0", "Paz\0" },
        { "Pazartesi\0", "Salı\0", "Çarşamba\0", "Perşembe\0", "Cuma\0", "Cumartesi\0", "Pazar\0" },
        { "P\0", "S\0", "Ç\0", "P\0", "C\0", "C\0", "P\0" },
        { "Pzt\0", "Sal\0", "Çar\0", "Per\0", "Cum\0", "Cmt\0", "Paz\0" },
        { "Pazartesi\0", "Salı\0", "Çarşamba\0", "Perşembe\0", "Cuma\0", "Cumartesi\0", "Pazar\0" },
        { "P\0", "S\0", "Ç\0", "P\0", "C\0", "C\0", "P\0" }
    }, // tr_TR
    {
        QLocale::Language::Tatar, QLocale::Script::CyrillicScript, QLocale::Country::Russia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "татар\0", "Россия\0",
        "dd.MM.yyyy\0", "d MMMM, yyyy 'ел'\0", "H:mm\0", "H:mm:ss Z\0",
        "AM\0", "PM\0",
        { "гыйн.\0", "фев.\0", "мар.\0", "апр.\0", "май\0", "июнь\0", "июль\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "гыйнвар\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "гыйн.\0", "фев.\0", "мар.\0", "апр.\0", "май\0", "июнь\0", "июль\0", "авг.\0", "сент.\0", "окт.\0", "нояб.\0", "дек.\0" },
        { "гыйнвар\0", "февраль\0", "март\0", "апрель\0", "май\0", "июнь\0", "июль\0", "август\0", "сентябрь\0", "октябрь\0", "ноябрь\0", "декабрь\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "дүш.\0", "сиш.\0", "чәр.\0", "пәнҗ.\0", "җом.\0", "шим.\0", "якш.\0" },
        { "дүшәмбе\0", "сишәмбе\0", "чәршәмбе\0", "пәнҗешәмбе\0", "җомга\0", "шимбә\0", "якшәмбе\0" },
        { "Д\0", "С\0", "Ч\0", "П\0", "Җ\0", "Ш\0", "Я\0" },
        { "дүш.\0", "сиш.\0", "чәр.\0", "пәнҗ.\0", "җом.\0", "шим.\0", "якш.\0" },
        { "дүшәмбе\0", "сишәмбе\0", "чәршәмбе\0", "пәнҗешәмбе\0", "җомга\0", "шимбә\0", "якшәмбе\0" },
        { "Д\0", "С\0", "Ч\0", "П\0", "Җ\0", "Ш\0", "Я\0" }
    }, // tt_RU
    {
        QLocale::Language::Tasawaq, QLocale::Script::LatinScript, QLocale::Country::Niger,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 160, 59, 37, 45, 43, 69, 48,
        "Tasawaq senni\0", "Nižer\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Subbaahi\0", "Zaarikay b\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "Ž\0", "F\0", "M\0", "A\0", "M\0", "Ž\0", "Ž\0", "U\0", "S\0", "O\0", "N\0", "D\0" },
        { "Žan\0", "Fee\0", "Mar\0", "Awi\0", "Me\0", "Žuw\0", "Žuy\0", "Ut\0", "Sek\0", "Okt\0", "Noo\0", "Dee\0" },
        { "Žanwiye\0", "Feewiriye\0", "Marsi\0", "Awiril\0", "Me\0", "Žuweŋ\0", "Žuyye\0", "Ut\0", "Sektanbur\0", "Oktoobur\0", "Noowanbur\0", "Deesanbur\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "T\0", "T\0", "L\0", "L\0", "L\0", "S\0", "H\0" },
        { "Ati\0", "Ata\0", "Ala\0", "Alm\0", "Alz\0", "Asi\0", "Alh\0" },
        { "Atinni\0", "Atalaata\0", "Alarba\0", "Alhamiisa\0", "Alzuma\0", "Asibti\0", "Alhadi\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // twq_NE
    {
        QLocale::Language::CentralAtlasTamazight, QLocale::Script::AnyScript, QLocale::Country::Morocco,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "Tamaziɣt n laṭlaṣ\0", "Meṛṛuk\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Zdat azal\0", "Ḍeffir aza\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "Y\0", "Y\0", "M\0", "I\0", "M\0", "Y\0", "Y\0", "Ɣ\0", "C\0", "K\0", "N\0", "D\0" },
        { "Yen\0", "Yeb\0", "Mar\0", "Ibr\0", "May\0", "Yun\0", "Yul\0", "Ɣuc\0", "Cut\0", "Kṭu\0", "Nwa\0", "Duj\0" },
        { "Yennayer\0", "Yebrayer\0", "Mars\0", "Ibrir\0", "Mayyu\0", "Yunyu\0", "Yulyuz\0", "Ɣuct\0", "Cutanbir\0", "Kṭuber\0", "Nwanbir\0", "Dujanbir\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "A\0", "A\0", "A\0", "A\0", "A\0", "A\0", "A\0" },
        { "Ayn\0", "Asn\0", "Akr\0", "Akw\0", "Asm\0", "Asḍ\0", "Asa\0" },
        { "Aynas\0", "Asinas\0", "Akras\0", "Akwas\0", "Asimwas\0", "Asiḍyas\0", "Asamas\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // tzm_MA
    {
        QLocale::Language::Uyghur, QLocale::Script::AnyScript, QLocale::Country::China,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ئۇيغۇرچە\0", "جۇڭگو\0",
        "yyyy-MM-dd\0", "d-MMMM، yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "چ.ب\0", "چ.ك\0",
        { "يانۋار\0", "فېۋرال\0", "مارت\0", "ئاپرېل\0", "ماي\0", "ئىيۇن\0", "ئىيۇل\0", "ئاۋغۇست\0", "سېنتەبىر\0", "ئۆكتەبىر\0", "نويابىر\0", "دېكابىر\0" },
        { "يانۋار\0", "فېۋرال\0", "مارت\0", "ئاپرېل\0", "ماي\0", "ئىيۇن\0", "ئىيۇل\0", "ئاۋغۇست\0", "سېنتەبىر\0", "ئۆكتەبىر\0", "نويابىر\0", "دېكابىر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "يانۋار\0", "فېۋرال\0", "مارت\0", "ئاپرېل\0", "ماي\0", "ئىيۇن\0", "ئىيۇل\0", "ئاۋغۇست\0", "سېنتەبىر\0", "ئۆكتەبىر\0", "نويابىر\0", "دېكابىر\0" },
        { "يانۋار\0", "فېۋرال\0", "مارت\0", "ئاپرېل\0", "ماي\0", "ئىيۇن\0", "ئىيۇل\0", "ئاۋغۇست\0", "سېنتەبىر\0", "ئۆكتەبىر\0", "نويابىر\0", "دېكابىر\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "دۈ\0", "سە\0", "چا\0", "پە\0", "جۈ\0", "شە\0", "يە\0" },
        { "دۈشەنبە\0", "سەيشەنبە\0", "چارشەنبە\0", "پەيشەنبە\0", "جۈمە\0", "شەنبە\0", "يەكشەنبە\0" },
        { "د\0", "س\0", "چ\0", "پ\0", "ج\0", "ش\0", "ي\0" },
        { "دۈ\0", "سە\0", "چا\0", "پە\0", "جۈ\0", "شە\0", "يە\0" },
        { "دۈشەنبە\0", "سەيشەنبە\0", "چارشەنبە\0", "پەيشەنبە\0", "جۈمە\0", "شەنبە\0", "يەكشەنبە\0" },
        { "د\0", "س\0", "چ\0", "پ\0", "ج\0", "ش\0", "ي\0" }
    }, // ug_CN
    {
        QLocale::Language::Ukrainian, QLocale::Script::CyrillicScript, QLocale::Country::Ukraine,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 1045, 48,
        "українська\0", "Україна\0",
        "dd.MM.yyyy\0", "d MMMM yyyy 'р'.\0", "HH:mm\0", "HH:mm:ss Z\0",
        "дп\0", "пп\0",
        { "січ\0", "лют\0", "бер\0", "кві\0", "тра\0", "чер\0", "лип\0", "сер\0", "вер\0", "жов\0", "лис\0", "гру\0" },
        { "січень\0", "лютий\0", "березень\0", "квітень\0", "травень\0", "червень\0", "липень\0", "серпень\0", "вересень\0", "жовтень\0", "листопад\0", "грудень\0" },
        { "С\0", "Л\0", "Б\0", "К\0", "Т\0", "Ч\0", "Л\0", "С\0", "В\0", "Ж\0", "Л\0", "Г\0" },
        { "січ.\0", "лют.\0", "бер.\0", "квіт.\0", "трав.\0", "черв.\0", "лип.\0", "серп.\0", "вер.\0", "жовт.\0", "лист.\0", "груд.\0" },
        { "січня\0", "лютого\0", "березня\0", "квітня\0", "травня\0", "червня\0", "липня\0", "серпня\0", "вересня\0", "жовтня\0", "листопада\0", "грудня\0" },
        { "с\0", "л\0", "б\0", "к\0", "т\0", "ч\0", "л\0", "с\0", "в\0", "ж\0", "л\0", "г\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "нд\0" },
        { "понеділок\0", "вівторок\0", "середа\0", "четвер\0", "пʼятниця\0", "субота\0", "неділя\0" },
        { "П\0", "В\0", "С\0", "Ч\0", "П\0", "С\0", "Н\0" },
        { "пн\0", "вт\0", "ср\0", "чт\0", "пт\0", "сб\0", "нд\0" },
        { "понеділок\0", "вівторок\0", "середа\0", "четвер\0", "пʼятниця\0", "субота\0", "неділя\0" },
        { "П\0", "В\0", "С\0", "Ч\0", "П\0", "С\0", "Н\0" }
    }, // uk_UA
    {
        QLocale::Language::Urdu, QLocale::Script::AnyScript, QLocale::Country::India,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        1643, 1644, 59, 37, 45, 43, 69, 1776,
        "اردو\0", "بھارت\0",
        "d/M/yyyy\0", "d MMMM، yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "جنوری\0", "فروری\0", "مارچ\0", "اپریل\0", "مئی\0", "جون\0", "جولائی\0", "اگست\0", "ستمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "جنوری\0", "فروری\0", "مارچ\0", "اپریل\0", "مئی\0", "جون\0", "جولائی\0", "اگست\0", "ستمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "جنوری\0", "فروری\0", "مارچ\0", "اپریل\0", "مئی\0", "جون\0", "جولائی\0", "اگست\0", "ستمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "جنوری\0", "فروری\0", "مارچ\0", "اپریل\0", "مئی\0", "جون\0", "جولائی\0", "اگست\0", "ستمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "پیر\0", "منگل\0", "بدھ\0", "جمعرات\0", "جمعہ\0", "ہفتہ\0", "اتوار\0" },
        { "پیر\0", "منگل\0", "بدھ\0", "جمعرات\0", "جمعہ\0", "ہفتہ\0", "اتوار\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "پیر\0", "منگل\0", "بدھ\0", "جمعرات\0", "جمعہ\0", "ہفتہ\0", "اتوار\0" },
        { "پیر\0", "منگل\0", "بدھ\0", "جمعرات\0", "جمعہ\0", "ہفتہ\0", "اتوار\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // ur_IN
    {
        QLocale::Language::Urdu, QLocale::Script::ArabicScript, QLocale::Country::Pakistan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "اردو\0", "پاکستان\0",
        "d/M/yyyy\0", "d MMMM، yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "جنوری\0", "فروری\0", "مارچ\0", "اپریل\0", "مئی\0", "جون\0", "جولائی\0", "اگست\0", "ستمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "جنوری\0", "فروری\0", "مارچ\0", "اپریل\0", "مئی\0", "جون\0", "جولائی\0", "اگست\0", "ستمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "جنوری\0", "فروری\0", "مارچ\0", "اپریل\0", "مئی\0", "جون\0", "جولائی\0", "اگست\0", "ستمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "جنوری\0", "فروری\0", "مارچ\0", "اپریل\0", "مئی\0", "جون\0", "جولائی\0", "اگست\0", "ستمبر\0", "اکتوبر\0", "نومبر\0", "دسمبر\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "پیر\0", "منگل\0", "بدھ\0", "جمعرات\0", "جمعہ\0", "ہفتہ\0", "اتوار\0" },
        { "پیر\0", "منگل\0", "بدھ\0", "جمعرات\0", "جمعہ\0", "ہفتہ\0", "اتوار\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "پیر\0", "منگل\0", "بدھ\0", "جمعرات\0", "جمعہ\0", "ہفتہ\0", "اتوار\0" },
        { "پیر\0", "منگل\0", "بدھ\0", "جمعرات\0", "جمعہ\0", "ہفتہ\0", "اتوار\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // ur_PK
    {
        QLocale::Language::Uzbek, QLocale::Script::ArabicScript, QLocale::Country::Afghanistan,
        Qt::Saturday, Qt::Thursday, Qt::Friday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "o‘zbek\0", "Afgʻoniston\0",
        "dd/MM/yyyy\0", "d-MMMM, yyyy\0", "HH:mm\0", "H:mm:ss (Z)\0",
        "TO\0", "TK\0",
        { "Yan\0", "Fev\0", "Mar\0", "Apr\0", "May\0", "Iyn\0", "Iyl\0", "Avg\0", "Sen\0", "Okt\0", "Noy\0", "Dek\0" },
        { "Yanvar\0", "Fevral\0", "Mart\0", "Aprel\0", "May\0", "Iyun\0", "Iyul\0", "Avgust\0", "Sentabr\0", "Oktabr\0", "Noyabr\0", "Dekabr\0" },
        { "Y\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "yan\0", "fev\0", "mar\0", "apr\0", "may\0", "iyn\0", "iyl\0", "avg\0", "sen\0", "okt\0", "noy\0", "dek\0" },
        { "yanvar\0", "fevral\0", "mart\0", "aprel\0", "may\0", "iyun\0", "iyul\0", "avgust\0", "sentabr\0", "oktabr\0", "noyabr\0", "dekabr\0" },
        { "Y\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Dush\0", "Sesh\0", "Chor\0", "Pay\0", "Jum\0", "Shan\0", "Yak\0" },
        { "dushanba\0", "seshanba\0", "chorshanba\0", "payshanba\0", "juma\0", "shanba\0", "yakshanba\0" },
        { "D\0", "S\0", "C\0", "P\0", "J\0", "S\0", "Y\0" },
        { "Dush\0", "Sesh\0", "Chor\0", "Pay\0", "Jum\0", "Shan\0", "Yak\0" },
        { "dushanba\0", "seshanba\0", "chorshanba\0", "payshanba\0", "juma\0", "shanba\0", "yakshanba\0" },
        { "D\0", "S\0", "C\0", "P\0", "J\0", "S\0", "Y\0" }
    }, // uz_Arab_AF
    {
        QLocale::Language::Uzbek, QLocale::Script::CyrillicScript, QLocale::Country::Uzbekistan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "o‘zbek\0", "Oʻzbekiston\0",
        "dd/MM/yyyy\0", "d-MMMM, yyyy\0", "HH:mm\0", "H:mm:ss (Z)\0",
        "TO\0", "TK\0",
        { "Yan\0", "Fev\0", "Mar\0", "Apr\0", "May\0", "Iyn\0", "Iyl\0", "Avg\0", "Sen\0", "Okt\0", "Noy\0", "Dek\0" },
        { "Yanvar\0", "Fevral\0", "Mart\0", "Aprel\0", "May\0", "Iyun\0", "Iyul\0", "Avgust\0", "Sentabr\0", "Oktabr\0", "Noyabr\0", "Dekabr\0" },
        { "Y\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "yan\0", "fev\0", "mar\0", "apr\0", "may\0", "iyn\0", "iyl\0", "avg\0", "sen\0", "okt\0", "noy\0", "dek\0" },
        { "yanvar\0", "fevral\0", "mart\0", "aprel\0", "may\0", "iyun\0", "iyul\0", "avgust\0", "sentabr\0", "oktabr\0", "noyabr\0", "dekabr\0" },
        { "Y\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Dush\0", "Sesh\0", "Chor\0", "Pay\0", "Jum\0", "Shan\0", "Yak\0" },
        { "dushanba\0", "seshanba\0", "chorshanba\0", "payshanba\0", "juma\0", "shanba\0", "yakshanba\0" },
        { "D\0", "S\0", "C\0", "P\0", "J\0", "S\0", "Y\0" },
        { "Dush\0", "Sesh\0", "Chor\0", "Pay\0", "Jum\0", "Shan\0", "Yak\0" },
        { "dushanba\0", "seshanba\0", "chorshanba\0", "payshanba\0", "juma\0", "shanba\0", "yakshanba\0" },
        { "D\0", "S\0", "C\0", "P\0", "J\0", "S\0", "Y\0" }
    }, // uz_Cyrl_UZ
    {
        QLocale::Language::Uzbek, QLocale::Script::LatinScript, QLocale::Country::Uzbekistan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "o‘zbek\0", "Oʻzbekiston\0",
        "dd/MM/yyyy\0", "d-MMMM, yyyy\0", "HH:mm\0", "H:mm:ss (Z)\0",
        "TO\0", "TK\0",
        { "Yan\0", "Fev\0", "Mar\0", "Apr\0", "May\0", "Iyn\0", "Iyl\0", "Avg\0", "Sen\0", "Okt\0", "Noy\0", "Dek\0" },
        { "Yanvar\0", "Fevral\0", "Mart\0", "Aprel\0", "May\0", "Iyun\0", "Iyul\0", "Avgust\0", "Sentabr\0", "Oktabr\0", "Noyabr\0", "Dekabr\0" },
        { "Y\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "yan\0", "fev\0", "mar\0", "apr\0", "may\0", "iyn\0", "iyl\0", "avg\0", "sen\0", "okt\0", "noy\0", "dek\0" },
        { "yanvar\0", "fevral\0", "mart\0", "aprel\0", "may\0", "iyun\0", "iyul\0", "avgust\0", "sentabr\0", "oktabr\0", "noyabr\0", "dekabr\0" },
        { "Y\0", "F\0", "M\0", "A\0", "M\0", "I\0", "I\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Dush\0", "Sesh\0", "Chor\0", "Pay\0", "Jum\0", "Shan\0", "Yak\0" },
        { "dushanba\0", "seshanba\0", "chorshanba\0", "payshanba\0", "juma\0", "shanba\0", "yakshanba\0" },
        { "D\0", "S\0", "C\0", "P\0", "J\0", "S\0", "Y\0" },
        { "Dush\0", "Sesh\0", "Chor\0", "Pay\0", "Jum\0", "Shan\0", "Yak\0" },
        { "dushanba\0", "seshanba\0", "chorshanba\0", "payshanba\0", "juma\0", "shanba\0", "yakshanba\0" },
        { "D\0", "S\0", "C\0", "P\0", "J\0", "S\0", "Y\0" }
    }, // uz_Latn_UZ
    {
        QLocale::Language::Vai, QLocale::Script::LatinScript, QLocale::Country::Liberia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ꕙꔤ\0", "ꕞꔤꔫꕩ\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "ꖨꖕꔞ\0", "ꕒꕡ\0", "ꕾꖺ\0", "ꖢꖕ\0", "ꖑꕱ\0", "ꖱꘋ\0", "ꖱꕞ\0", "ꗛꔕ\0", "ꕢꕌ\0", "ꕭꖃ\0", "ꔞꘋ\0", "ꖨꖕꗏ\0" },
        { "ꖨꖕ ꕪꕴ ꔞꔀꕮꕊ\0", "ꕒꕡꖝꖕ\0", "ꕾꖺ\0", "ꖢꖕ\0", "ꖑꕱ\0", "ꖱꘋ\0", "ꖱꕞꔤ\0", "ꗛꔕ\0", "ꕢꕌ\0", "ꕭꖃ\0", "ꔞꘋꕔꕿ ꕸꖃꗏ\0", "ꖨꖕ ꕪꕴ ꗏꖺꕮꕊ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ꖨꖕꔞ\0", "ꕒꕡ\0", "ꕾꖺ\0", "ꖢꖕ\0", "ꖑꕱ\0", "ꖱꘋ\0", "ꖱꕞ\0", "ꗛꔕ\0", "ꕢꕌ\0", "ꕭꖃ\0", "ꔞꘋ\0", "ꖨꖕꗏ\0" },
        { "ꖨꖕ ꕪꕴ ꔞꔀꕮꕊ\0", "ꕒꕡꖝꖕ\0", "ꕾꖺ\0", "ꖢꖕ\0", "ꖑꕱ\0", "ꖱꘋ\0", "ꖱꕞꔤ\0", "ꗛꔕ\0", "ꕢꕌ\0", "ꕭꖃ\0", "ꔞꘋꕔꕿ ꕸꖃꗏ\0", "ꖨꖕ ꕪꕴ ꗏꖺꕮꕊ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "ꗳꗡꘉ\0", "ꕚꕞꕚ\0", "ꕉꕞꕒ\0", "ꕉꔤꕆꕢ\0", "ꕉꔤꕀꕮ\0", "ꔻꔬꔳ\0", "ꕞꕌꔵ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // vai_Latn_LR
    {
        QLocale::Language::Vai, QLocale::Script::VaiScript, QLocale::Country::Liberia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ꕙꔤ\0", "ꕞꔤꔫꕩ\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "AM\0", "PM\0",
        { "ꖨꖕꔞ\0", "ꕒꕡ\0", "ꕾꖺ\0", "ꖢꖕ\0", "ꖑꕱ\0", "ꖱꘋ\0", "ꖱꕞ\0", "ꗛꔕ\0", "ꕢꕌ\0", "ꕭꖃ\0", "ꔞꘋ\0", "ꖨꖕꗏ\0" },
        { "ꖨꖕ ꕪꕴ ꔞꔀꕮꕊ\0", "ꕒꕡꖝꖕ\0", "ꕾꖺ\0", "ꖢꖕ\0", "ꖑꕱ\0", "ꖱꘋ\0", "ꖱꕞꔤ\0", "ꗛꔕ\0", "ꕢꕌ\0", "ꕭꖃ\0", "ꔞꘋꕔꕿ ꕸꖃꗏ\0", "ꖨꖕ ꕪꕴ ꗏꖺꕮꕊ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "ꖨꖕꔞ\0", "ꕒꕡ\0", "ꕾꖺ\0", "ꖢꖕ\0", "ꖑꕱ\0", "ꖱꘋ\0", "ꖱꕞ\0", "ꗛꔕ\0", "ꕢꕌ\0", "ꕭꖃ\0", "ꔞꘋ\0", "ꖨꖕꗏ\0" },
        { "ꖨꖕ ꕪꕴ ꔞꔀꕮꕊ\0", "ꕒꕡꖝꖕ\0", "ꕾꖺ\0", "ꖢꖕ\0", "ꖑꕱ\0", "ꖱꘋ\0", "ꖱꕞꔤ\0", "ꗛꔕ\0", "ꕢꕌ\0", "ꕭꖃ\0", "ꔞꘋꕔꕿ ꕸꖃꗏ\0", "ꖨꖕ ꕪꕴ ꗏꖺꕮꕊ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "ꗳꗡꘉ\0", "ꕚꕞꕚ\0", "ꕉꕞꕒ\0", "ꕉꔤꕆꕢ\0", "ꕉꔤꕀꕮ\0", "ꔻꔬꔳ\0", "ꕞꕌꔵ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // vai_Vaii_LR
    {
        QLocale::Language::Vietnamese, QLocale::Script::LatinScript, QLocale::Country::Vietnam,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Tiếng Việt\0", "Việt Nam\0",
        "dd/MM/yyyy\0", "d MMMM, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "SA\0", "CH\0",
        { "Thg 1\0", "Thg 2\0", "Thg 3\0", "Thg 4\0", "Thg 5\0", "Thg 6\0", "Thg 7\0", "Thg 8\0", "Thg 9\0", "Thg 10\0", "Thg 11\0", "Thg 12\0" },
        { "Tháng 1\0", "Tháng 2\0", "Tháng 3\0", "Tháng 4\0", "Tháng 5\0", "Tháng 6\0", "Tháng 7\0", "Tháng 8\0", "Tháng 9\0", "Tháng 10\0", "Tháng 11\0", "Tháng 12\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "thg 1\0", "thg 2\0", "thg 3\0", "thg 4\0", "thg 5\0", "thg 6\0", "thg 7\0", "thg 8\0", "thg 9\0", "thg 10\0", "thg 11\0", "thg 12\0" },
        { "tháng 1\0", "tháng 2\0", "tháng 3\0", "tháng 4\0", "tháng 5\0", "tháng 6\0", "tháng 7\0", "tháng 8\0", "tháng 9\0", "tháng 10\0", "tháng 11\0", "tháng 12\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Th 2\0", "Th 3\0", "Th 4\0", "Th 5\0", "Th 6\0", "Th 7\0", "CN\0" },
        { "Thứ Hai\0", "Thứ Ba\0", "Thứ Tư\0", "Thứ Năm\0", "Thứ Sáu\0", "Thứ Bảy\0", "Chủ Nhật\0" },
        { "T2\0", "T3\0", "T4\0", "T5\0", "T6\0", "T7\0", "CN\0" },
        { "Th 2\0", "Th 3\0", "Th 4\0", "Th 5\0", "Th 6\0", "Th 7\0", "CN\0" },
        { "Thứ Hai\0", "Thứ Ba\0", "Thứ Tư\0", "Thứ Năm\0", "Thứ Sáu\0", "Thứ Bảy\0", "Chủ Nhật\0" },
        { "T2\0", "T3\0", "T4\0", "T5\0", "T6\0", "T7\0", "CN\0" }
    }, // vi_VN
    {
        QLocale::Language::Vunjo, QLocale::Script::LatinScript, QLocale::Country::Tanzania,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Kyivunjo\0", "Tanzania\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "utuko\0", "kyiukonyi\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mac\0", "Apr\0", "Mei\0", "Jun\0", "Jul\0", "Ago\0", "Sep\0", "Okt\0", "Nov\0", "Des\0" },
        { "Januari\0", "Februari\0", "Machi\0", "Aprilyi\0", "Mei\0", "Junyi\0", "Julyai\0", "Agusti\0", "Septemba\0", "Oktoba\0", "Novemba\0", "Desemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "J\0", "J\0", "J\0", "A\0", "I\0", "J\0", "J\0" },
        { "Jtt\0", "Jnn\0", "Jtn\0", "Alh\0", "Iju\0", "Jmo\0", "Jpi\0" },
        { "Jumatatuu\0", "Jumanne\0", "Jumatanu\0", "Alhamisi\0", "Ijumaa\0", "Jumamosi\0", "Jumapilyi\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // vun_TZ
    {
        QLocale::Language::Walser, QLocale::Script::LatinScript, QLocale::Country::Switzerland,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 8217, 59, 37, 45, 43, 69, 48,
        "Walser\0", "Schwiz\0",
        "yyyy-MM-dd\0", "d. MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jen\0", "Hor\0", "Mär\0", "Abr\0", "Mei\0", "Brá\0", "Hei\0", "Öig\0", "Her\0", "Wím\0", "Win\0", "Chr\0" },
        { "Jenner\0", "Hornig\0", "Märze\0", "Abrille\0", "Meije\0", "Bráčet\0", "Heiwet\0", "Öigšte\0", "Herbštmánet\0", "Wímánet\0", "Wintermánet\0", "Chrištmánet\0" },
        { "J\0", "H\0", "M\0", "A\0", "M\0", "B\0", "H\0", "Ö\0", "H\0", "W\0", "W\0", "C\0" },
        { "Jen\0", "Hor\0", "Mär\0", "Abr\0", "Mei\0", "Brá\0", "Hei\0", "Öig\0", "Her\0", "Wím\0", "Win\0", "Chr\0" },
        { "Jenner\0", "Hornig\0", "Märze\0", "Abrille\0", "Meije\0", "Bráčet\0", "Heiwet\0", "Öigšte\0", "Herbštmánet\0", "Wímánet\0", "Wintermánet\0", "Chrištmánet\0" },
        { "J\0", "H\0", "M\0", "A\0", "M\0", "B\0", "H\0", "Ö\0", "H\0", "W\0", "W\0", "C\0" },
        { "Män\0", "Ziš\0", "Mit\0", "Fró\0", "Fri\0", "Sam\0", "Sun\0" },
        { "Mäntag\0", "Zištag\0", "Mittwuč\0", "Fróntag\0", "Fritag\0", "Samštag\0", "Sunntag\0" },
        { "M\0", "Z\0", "M\0", "F\0", "F\0", "S\0", "S\0" },
        { "Män\0", "Ziš\0", "Mit\0", "Fró\0", "Fri\0", "Sam\0", "Sun\0" },
        { "Mäntag\0", "Zištag\0", "Mittwuč\0", "Fróntag\0", "Fritag\0", "Samštag\0", "Sunntag\0" },
        { "M\0", "Z\0", "M\0", "F\0", "F\0", "S\0", "S\0" }
    }, // wae_CH
    {
        QLocale::Language::Wolof, QLocale::Script::LatinScript, QLocale::Country::Senegal,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "Wolof\0", "Senegaal\0",
        "dd-MM-yyyy\0", "d MMMM, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Sub\0", "Ngo\0",
        { "Sam\0", "Few\0", "Mar\0", "Awr\0", "Mee\0", "Suw\0", "Sul\0", "Ut\0", "Sàt\0", "Okt\0", "Now\0", "Des\0" },
        { "Samwiyee\0", "Fewriyee\0", "Mars\0", "Awril\0", "Mee\0", "Suwe\0", "Sulet\0", "Ut\0", "Sàttumbar\0", "Oktoobar\0", "Nowàmbar\0", "Desàmbar\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Sam\0", "Few\0", "Mar\0", "Awr\0", "Mee\0", "Suw\0", "Sul\0", "Ut\0", "Sàt\0", "Okt\0", "Now\0", "Des\0" },
        { "Samwiyee\0", "Fewriyee\0", "Mars\0", "Awril\0", "Mee\0", "Suwe\0", "Sulet\0", "Ut\0", "Sàttumbar\0", "Oktoobar\0", "Nowàmbar\0", "Desàmbar\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Alt\0", "Tal\0", "Àla\0", "Alx\0", "Àjj\0", "Ase\0", "Dib\0" },
        { "Altine\0", "Talaata\0", "Àlarba\0", "Alxamis\0", "Àjjuma\0", "Aseer\0", "Dibéer\0" },
        { "Alt\0", "Tal\0", "Àla\0", "Alx\0", "Àjj\0", "Ase\0", "Dib\0" },
        { "Alt\0", "Tal\0", "Àla\0", "Alx\0", "Àjj\0", "Ase\0", "Dib\0" },
        { "Altine\0", "Talaata\0", "Àlarba\0", "Alxamis\0", "Àjjuma\0", "Aseer\0", "Dibéer\0" },
        { "Alt\0", "Tal\0", "Àla\0", "Alx\0", "Àjj\0", "Ase\0", "Dib\0" }
    }, // wo_SN
    {
        QLocale::Language::Xhosa, QLocale::Script::LatinScript, QLocale::Country::SouthAfrica,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 160, 59, 37, 45, 43, 69, 48,
        "isiXhosa\0", "eMzantsi Afrika\0",
        "yyyy-MM-dd\0", "yyyy MMMM d\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mat\0", "Epr\0", "Mey\0", "Jun\0", "Jul\0", "Aga\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Janyuwari\0", "Februwari\0", "Matshi\0", "Epreli\0", "Meyi\0", "Juni\0", "Julayi\0", "Agasti\0", "Septemba\0", "Okthoba\0", "Novemba\0", "Disemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Jan\0", "Feb\0", "Mat\0", "Epr\0", "Mey\0", "Jun\0", "Jul\0", "Aga\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Janyuwari\0", "Februwari\0", "Matshi\0", "Epreli\0", "Meyi\0", "Juni\0", "Julayi\0", "Agasti\0", "Septemba\0", "Okthoba\0", "Novemba\0", "Disemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mvu\0", "Bin\0", "Tha\0", "Sin\0", "Hla\0", "Mgq\0", "Caw\0" },
        { "Mvulo\0", "Lwesibini\0", "Lwesithathu\0", "Lwesine\0", "Lwesihlanu\0", "Mgqibelo\0", "Cawe\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "Mvu\0", "Bin\0", "Tha\0", "Sin\0", "Hla\0", "Mgq\0", "Caw\0" },
        { "Mvulo\0", "Lwesibini\0", "Lwesithathu\0", "Lwesine\0", "Lwesihlanu\0", "Mgqibelo\0", "Cawe\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // xh_ZA
    {
        QLocale::Language::Soga, QLocale::Script::LatinScript, QLocale::Country::Uganda,
        Qt::Monday, Qt::Sunday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Olusoga\0", "Yuganda\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "Munkyo\0", "Eigulo\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mar\0", "Apu\0", "Maa\0", "Juu\0", "Jul\0", "Agu\0", "Seb\0", "Oki\0", "Nov\0", "Des\0" },
        { "Janwaliyo\0", "Febwaliyo\0", "Marisi\0", "Apuli\0", "Maayi\0", "Juuni\0", "Julaayi\0", "Agusito\0", "Sebuttemba\0", "Okitobba\0", "Novemba\0", "Desemba\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "B\0", "B\0", "S\0", "K\0", "K\0", "M\0", "S\0" },
        { "Bala\0", "Kubi\0", "Kusa\0", "Kuna\0", "Kuta\0", "Muka\0", "Sabi\0" },
        { "Balaza\0", "Owokubili\0", "Owokusatu\0", "Olokuna\0", "Olokutaanu\0", "Olomukaaga\0", "Sabiiti\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // xog_UG
    {
        QLocale::Language::Yangben, QLocale::Script::LatinScript, QLocale::Country::Cameroon,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "nuasue\0", "Kemelún\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "kiɛmɛ́ɛm\0", "kisɛ́ndɛ\0",
        { "Jan\0", "Feb\0", "Mar\0", "Apr\0", "May\0", "Jun\0", "Jul\0", "Aug\0", "Sep\0", "Oct\0", "Nov\0", "Dec\0" },
        { "January\0", "February\0", "March\0", "April\0", "May\0", "June\0", "July\0", "August\0", "September\0", "October\0", "November\0", "December\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "o.1\0", "o.2\0", "o.3\0", "o.4\0", "o.5\0", "o.6\0", "o.7\0", "o.8\0", "o.9\0", "o.10\0", "o.11\0", "o.12\0" },
        { "pikítíkítie, oólí ú kutúan\0", "siɛyɛ́, oóli ú kándíɛ\0", "ɔnsúmbɔl, oóli ú kátátúɛ\0", "mesiŋ, oóli ú kénie\0", "ensil, oóli ú kátánuɛ\0", "ɔsɔn\0", "efute\0", "pisuyú\0", "imɛŋ i puɔs\0", "imɛŋ i putúk,oóli ú kátíɛ\0", "makandikɛ\0", "pilɔndɔ́\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Monday\0", "Tuesday\0", "Wednesday\0", "Thursday\0", "Friday\0", "Saturday\0", "Sunday\0" },
        { "m\0", "m\0", "e\0", "k\0", "f\0", "s\0", "s\0" },
        { "md\0", "mw\0", "et\0", "kl\0", "fl\0", "ss\0", "sd\0" },
        { "móndie\0", "muányáŋmóndie\0", "metúkpíápɛ\0", "kúpélimetúkpiapɛ\0", "feléte\0", "séselé\0", "sɔ́ndiɛ\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // yav_CM
    {
        QLocale::Language::Yiddish, QLocale::Script::HebrewScript, QLocale::Country::world,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "ייִדיש\0", "וועלט\0",
        "dd/MM/yyyy\0", "dטן MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "פֿאַרמיטאָג\0", "נאָכמיטאָג\0",
        { "יאַנ\0", "פֿעב\0", "מערץ\0", "אַפּר\0", "מיי\0", "יוני\0", "יולי\0", "אויג\0", "סעפּ\0", "אקט\0", "נאוו\0", "דעצ\0" },
        { "יאַנואַר\0", "פֿעברואַר\0", "מערץ\0", "אַפּריל\0", "מיי\0", "יוני\0", "יולי\0", "אויגוסט\0", "סעפּטעמבער\0", "אקטאבער\0", "נאוועמבער\0", "דעצעמבער\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "יאַנואַר\0", "פֿעברואַר\0", "מערץ\0", "אַפּריל\0", "מיי\0", "יוני\0", "יולי\0", "אויגוסט\0", "סעפּטעמבער\0", "אקטאבער\0", "נאוועמבער\0", "דעצעמבער\0" },
        { "יאַנואַר\0", "פֿעברואַר\0", "מערץ\0", "אַפּריל\0", "מיי\0", "יוני\0", "יולי\0", "אויגוסט\0", "סעפּטעמבער\0", "אקטאבער\0", "נאוועמבער\0", "דעצעמבער\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "מאָנטיק\0", "דינסטיק\0", "מיטוואך\0", "דאנערשטיק\0", "פֿרײַטיק\0", "שבת\0", "זונטיק\0" },
        { "מאָנטיק\0", "דינסטיק\0", "מיטוואך\0", "דאנערשטיק\0", "פֿרײַטיק\0", "שבת\0", "זונטיק\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "מאָנטיק\0", "דינסטיק\0", "מיטוואך\0", "דאנערשטיק\0", "פֿרײַטיק\0", "שבת\0", "זונטיק\0" },
        { "מאָנטיק\0", "דינסטיק\0", "מיטוואך\0", "דאנערשטיק\0", "פֿרײַטיק\0", "שבת\0", "זונטיק\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0" }
    }, // yi_001
    {
        QLocale::Language::Yoruba, QLocale::Script::AnyScript, QLocale::Country::Benin,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Èdè Yorùbá\0", "Bɛ̀nɛ̀\0",
        "d/M/yyyy\0", "d MMM yyyy\0", "H:m\0", "H:mm:ss Z\0",
        "Àárɔ̀\0", "Ɔ̀sán\0",
        { "Shɛ́\0", "Èr\0", "Ɛr\0", "Ìg\0", "Ɛ̀b\0", "Òk\0", "Ag\0", "Òg\0", "Ow\0", "Ɔ̀w\0", "Bé\0", "Ɔ̀p\0" },
        { "Shɛ́rɛ́\0", "Èrèlè\0", "Ɛrɛ̀nà\0", "Ìgbé\0", "Ɛ̀bibi\0", "Òkúdu\0", "Agɛmɔ\0", "Ògún\0", "Owewe\0", "Ɔ̀wàrà\0", "Bélú\0", "Ɔ̀pɛ̀\0" },
        { "S\0", "È\0", "Ɛ\0", "Ì\0", "Ɛ̀\0", "Ò\0", "A\0", "Ò\0", "O\0", "Ɔ̀\0", "B\0", "Ɔ̀\0" },
        { "Shɛ́r\0", "Èrèl\0", "Ɛrɛ̀n\0", "Ìgb\0", "Ɛ̀bi\0", "Òkú\0", "Agɛ\0", "Ògú\0", "Owe\0", "Ɔ̀wà\0", "Bél\0", "Ɔ̀pɛ\0" },
        { "Oshù Shɛ́rɛ́\0", "Oshù Èrèlè\0", "Oshù Ɛrɛ̀nà\0", "Oshù Ìgbé\0", "Oshù Ɛ̀bibi\0", "Oshù Òkúdu\0", "Oshù Agɛmɔ\0", "Oshù Ògún\0", "Oshù Owewe\0", "Oshù Ɔ̀wàrà\0", "Oshù Bélú\0", "Oshù Ɔ̀pɛ̀\0" },
        { "S\0", "È\0", "Ɛ\0", "Ì\0", "Ɛ̀\0", "Ò\0", "A\0", "Ò\0", "O\0", "Ɔ̀\0", "B\0", "Ɔ̀\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Ajé\0", "Ìsɛ́gun\0", "Ɔjɔ́rú\0", "Ɔjɔ́bɔ\0", "Ɛtì\0", "Àbámɛ́ta\0", "Àìkú\0" },
        { "A\0", "Ì\0", "Ɔ\0", "Ɔ\0", "Ɛ\0", "À\0", "À\0" },
        { "Aj\0", "Ìsɛ́g\0", "Ɔjɔ́r\0", "Ɔjɔ́b\0", "Ɛt\0", "Àbám\0", "Àìk\0" },
        { "Ɔjɔ́ Ajé\0", "Ɔjɔ́ Ìsɛ́gun\0", "Ɔjɔ́rú\0", "Ɔjɔ́bɔ\0", "Ɔjɔ́ Ɛtì\0", "Ɔjɔ́ Àbámɛ́ta\0", "Ɔjɔ́ Àìkú\0" },
        { "A\0", "Ì\0", "Ɔ\0", "Ɔ\0", "Ɛ\0", "À\0", "À\0" }
    }, // yo_BJ
    {
        QLocale::Language::Yoruba, QLocale::Script::LatinScript, QLocale::Country::Nigeria,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "Èdè Yorùbá\0", "Nàìjíríà\0",
        "d/M/yyyy\0", "d MMM yyyy\0", "H:m\0", "H:mm:ss Z\0",
        "Àárọ̀\0", "Ọ̀sán\0",
        { "Ṣẹ́\0", "Èr\0", "Ẹr\0", "Ìg\0", "Ẹ̀b\0", "Òk\0", "Ag\0", "Òg\0", "Ow\0", "Ọ̀w\0", "Bé\0", "Ọ̀p\0" },
        { "Ṣẹ́rẹ́\0", "Èrèlè\0", "Ẹrẹ̀nà\0", "Ìgbé\0", "Ẹ̀bibi\0", "Òkúdu\0", "Agẹmọ\0", "Ògún\0", "Owewe\0", "Ọ̀wàrà\0", "Bélú\0", "Ọ̀pẹ̀\0" },
        { "S\0", "È\0", "Ẹ\0", "Ì\0", "Ẹ̀\0", "Ò\0", "A\0", "Ò\0", "O\0", "Ọ̀\0", "B\0", "Ọ̀\0" },
        { "Ṣẹ́r\0", "Èrèl\0", "Ẹrẹ̀n\0", "Ìgb\0", "Ẹ̀bi\0", "Òkú\0", "Agẹ\0", "Ògú\0", "Owe\0", "Ọ̀wà\0", "Bél\0", "Ọ̀pẹ\0" },
        { "Oṣù Ṣẹ́rẹ́\0", "Oṣù Èrèlè\0", "Oṣù Ẹrẹ̀nà\0", "Oṣù Ìgbé\0", "Oṣù Ẹ̀bibi\0", "Oṣù Òkúdu\0", "Oṣù Agẹmọ\0", "Oṣù Ògún\0", "Oṣù Owewe\0", "Oṣù Ọ̀wàrà\0", "Oṣù Bélú\0", "Oṣù Ọ̀pẹ̀\0" },
        { "S\0", "È\0", "Ẹ\0", "Ì\0", "Ẹ̀\0", "Ò\0", "A\0", "Ò\0", "O\0", "Ọ̀\0", "B\0", "Ọ̀\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "Ajé\0", "Ìsẹ́gun\0", "Ọjọ́rú\0", "Ọjọ́bọ\0", "Ẹtì\0", "Àbámẹ́ta\0", "Àìkú\0" },
        { "A\0", "Ì\0", "Ọ\0", "Ọ\0", "Ẹ\0", "À\0", "À\0" },
        { "Aj\0", "Ìsẹ́g\0", "Ọjọ́r\0", "Ọjọ́b\0", "Ẹt\0", "Àbám\0", "Àìk\0" },
        { "Ọjọ́ Ajé\0", "Ọjọ́ Ìsẹ́gun\0", "Ọjọ́rú\0", "Ọjọ́bọ\0", "Ọjọ́ Ẹtì\0", "Ọjọ́ Àbámẹ́ta\0", "Ọjọ́ Àìkú\0" },
        { "A\0", "Ì\0", "Ọ\0", "Ọ\0", "Ẹ\0", "À\0", "À\0" }
    }, // yo_NG
    {
        QLocale::Language::Nheengatu, QLocale::Script::LatinScript, QLocale::Country::Brazil,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "nheẽgatu\0", "Brasiu\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "ye\0", "mk\0", "ms\0", "id\0", "pu\0", "py\0", "pm\0", "ps\0", "pi\0", "yp\0", "yy\0", "ym\0" },
        { "yepé\0", "mukũi\0", "musapíri\0", "irũdí\0", "pú\0", "pú-yepé\0", "pú-mukũi\0", "pú-musapíri\0", "pú-irũdí\0", "yepé-putimaã\0", "yepé-yepé\0", "yepé-mukũi\0" },
        { "Y\0", "M\0", "M\0", "I\0", "P\0", "P\0", "P\0", "P\0", "P\0", "Y\0", "Y\0", "Y\0" },
        { "ye\0", "mk\0", "ms\0", "id\0", "pu\0", "py\0", "pm\0", "ps\0", "pi\0", "yp\0", "yy\0", "ym\0" },
        { "yepé\0", "mukũi\0", "musapíri\0", "irũdí\0", "pú\0", "pú-yepé\0", "pú-mukũi\0", "pú-musapíri\0", "pú-irũdí\0", "yepé-putimaã\0", "yepé-yepé\0", "yepé-mukũi\0" },
        { "Y\0", "M\0", "M\0", "I\0", "P\0", "P\0", "P\0", "P\0", "P\0", "Y\0", "Y\0", "Y\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "murakipí\0", "murakí-mukũi\0", "murakí-musapíri\0", "supapá\0", "yukuakú\0", "saurú\0", "mituú\0" },
        { "M\0", "M\0", "M\0", "S\0", "Y\0", "S\0", "M\0" },
        { "mur\0", "mmk\0", "mms\0", "sup\0", "yuk\0", "sau\0", "mit\0" },
        { "murakipí\0", "murakí-mukũi\0", "murakí-musapíri\0", "supapá\0", "yukuakú\0", "saurú\0", "mituú\0" },
        { "M\0", "M\0", "M\0", "S\0", "Y\0", "S\0", "M\0" }
    }, // yrl_BR
    {
        QLocale::Language::Nheengatu, QLocale::Script::LatinScript, QLocale::Country::Colombia,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "ñengatú\0", "Kurũbiya\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "a. m.\0", "p. m.\0",
        { "ye\0", "mk\0", "ms\0", "id\0", "pu\0", "py\0", "pm\0", "ps\0", "pi\0", "yp\0", "yy\0", "ym\0" },
        { "yepé\0", "mukũi\0", "musapíri\0", "irũdí\0", "pú\0", "pú-yepé\0", "pú-mukũi\0", "pú-musapíri\0", "pú-irũdí\0", "yepé-putimaã\0", "yepé-yepé\0", "yepé-mukũi\0" },
        { "Y\0", "M\0", "M\0", "I\0", "P\0", "P\0", "P\0", "P\0", "P\0", "Y\0", "Y\0", "Y\0" },
        { "ye\0", "mk\0", "ms\0", "id\0", "pu\0", "py\0", "pm\0", "ps\0", "pi\0", "yp\0", "yy\0", "ym\0" },
        { "yepé\0", "mukũi\0", "musapíri\0", "irũdí\0", "pú\0", "pú-yepé\0", "pú-mukũi\0", "pú-musapíri\0", "pú-irũdí\0", "yepé-putimaã\0", "yepé-yepé\0", "yepé-mukũi\0" },
        { "Y\0", "M\0", "M\0", "I\0", "P\0", "P\0", "P\0", "P\0", "P\0", "Y\0", "Y\0", "Y\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "murakipí\0", "murakí-mukũi\0", "murakí-musapíri\0", "supapá\0", "yukuakú\0", "saurú\0", "mituú\0" },
        { "M\0", "M\0", "M\0", "S\0", "Y\0", "S\0", "M\0" },
        { "mur\0", "mmk\0", "mms\0", "sup\0", "yuk\0", "sau\0", "mit\0" },
        { "murakipí\0", "murakí-mukũi\0", "murakí-musapíri\0", "supapá\0", "yukuakú\0", "saurú\0", "mituú\0" },
        { "M\0", "M\0", "M\0", "S\0", "Y\0", "S\0", "M\0" }
    }, // yrl_CO
    {
        QLocale::Language::Nheengatu, QLocale::Script::LatinScript, QLocale::Country::Venezuela,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 46, 59, 37, 45, 43, 69, 48,
        "ñengatú\0", "Wenesuera\0",
        "dd/MM/yyyy\0", "d MMMM yyyy\0", "h:mm AP\0", "h:mm:ss AP Z\0",
        "a. m.\0", "p. m.\0",
        { "ye\0", "mk\0", "ms\0", "id\0", "pu\0", "py\0", "pm\0", "ps\0", "pi\0", "yp\0", "yy\0", "ym\0" },
        { "yepé\0", "mukũi\0", "musapíri\0", "irũdí\0", "pú\0", "pú-yepé\0", "pú-mukũi\0", "pú-musapíri\0", "pú-irũdí\0", "yepé-putimaã\0", "yepé-yepé\0", "yepé-mukũi\0" },
        { "Y\0", "M\0", "M\0", "I\0", "P\0", "P\0", "P\0", "P\0", "P\0", "Y\0", "Y\0", "Y\0" },
        { "ye\0", "mk\0", "ms\0", "id\0", "pu\0", "py\0", "pm\0", "ps\0", "pi\0", "yp\0", "yy\0", "ym\0" },
        { "yepé\0", "mukũi\0", "musapíri\0", "irũdí\0", "pú\0", "pú-yepé\0", "pú-mukũi\0", "pú-musapíri\0", "pú-irũdí\0", "yepé-putimaã\0", "yepé-yepé\0", "yepé-mukũi\0" },
        { "Y\0", "M\0", "M\0", "I\0", "P\0", "P\0", "P\0", "P\0", "P\0", "Y\0", "Y\0", "Y\0" },
        { "Mon\0", "Tue\0", "Wed\0", "Thu\0", "Fri\0", "Sat\0", "Sun\0" },
        { "murakipí\0", "murakí-mukũi\0", "murakí-musapíri\0", "supapá\0", "yukuakú\0", "saurú\0", "mituú\0" },
        { "M\0", "M\0", "M\0", "S\0", "Y\0", "S\0", "M\0" },
        { "mur\0", "mmk\0", "mms\0", "sup\0", "yuk\0", "sau\0", "mit\0" },
        { "murakipí\0", "murakí-mukũi\0", "murakí-musapíri\0", "supapá\0", "yukuakú\0", "saurú\0", "mituú\0" },
        { "M\0", "M\0", "M\0", "S\0", "Y\0", "S\0", "M\0" }
    }, // yrl_VE
    {
        QLocale::Language::Cantonese, QLocale::Script::SimplifiedScript, QLocale::Country::China,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "粵語\0", "中華人民共和國\0",
        "yyyy/M/d\0", "yyyy年M月d日\0", "APh:mm\0", "APh:mm:ss [Z]\0",
        "上午\0", "下午\0",
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" }
    }, // yue_Hans_CN
    {
        QLocale::Language::Cantonese, QLocale::Script::TraditionalScript, QLocale::Country::HongKongSARChina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "粵語\0", "中華人民共和國香港特別行政區\0",
        "yyyy/M/d\0", "yyyy年M月d日\0", "APh:mm\0", "APh:mm:ss [Z]\0",
        "上午\0", "下午\0",
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" }
    }, // yue_Hant_HK
    {
        QLocale::Language::StandardMoroccanTamazight, QLocale::Script::TifinaghScript, QLocale::Country::Morocco,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        44, 160, 59, 37, 45, 43, 69, 48,
        "ⵜⴰⵎⴰⵣⵉⵖⵜ\0", "ⵍⵎⵖⵔⵉⴱ\0",
        "d/M/yyyy\0", "d MMMM yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "ⵜⵉⴼⴰⵡⵜ\0", "ⵜⴰⴷⴳⴳⵯⴰⵜ\0",
        { "ⵉⵏⵏ\0", "ⴱⵕⴰ\0", "ⵎⴰⵕ\0", "ⵉⴱⵔ\0", "ⵎⴰⵢ\0", "ⵢⵓⵏ\0", "ⵢⵓⵍ\0", "ⵖⵓⵛ\0", "ⵛⵓⵜ\0", "ⴽⵜⵓ\0", "ⵏⵓⵡ\0", "ⴷⵓⵊ\0" },
        { "ⵉⵏⵏⴰⵢⵔ\0", "ⴱⵕⴰⵢⵕ\0", "ⵎⴰⵕⵚ\0", "ⵉⴱⵔⵉⵔ\0", "ⵎⴰⵢⵢⵓ\0", "ⵢⵓⵏⵢⵓ\0", "ⵢⵓⵍⵢⵓⵣ\0", "ⵖⵓⵛⵜ\0", "ⵛⵓⵜⴰⵏⴱⵉⵔ\0", "ⴽⵜⵓⴱⵔ\0", "ⵏⵓⵡⴰⵏⴱⵉⵔ\0", "ⴷⵓⵊⴰⵏⴱⵉⵔ\0" },
        { "ⵉ\0", "ⴱ\0", "ⵎ\0", "ⵉ\0", "ⵎ\0", "ⵢ\0", "ⵢ\0", "ⵖ\0", "ⵛ\0", "ⴽ\0", "ⵏ\0", "ⴷ\0" },
        { "ⵉⵏⵏ\0", "ⴱⵕⴰ\0", "ⵎⴰⵕ\0", "ⵉⴱⵔ\0", "ⵎⴰⵢ\0", "ⵢⵓⵏ\0", "ⵢⵓⵍ\0", "ⵖⵓⵛ\0", "ⵛⵓ\0", "ⴽⵜⵓ\0", "ⵏⵓⵡ\0", "ⴷⵓⵊ\0" },
        { "ⵉⵏⵏⴰⵢⵔ\0", "ⴱⵕⴰⵢⵕ\0", "ⵎⴰⵕⵚ\0", "ⵉⴱⵔⵉⵔ\0", "ⵎⴰⵢⵢⵓ\0", "ⵢⵓⵏⵢⵓ\0", "ⵢⵓⵍⵢⵓⵣ\0", "ⵖⵓⵛⵜ\0", "ⵛⵓⵜⴰⵏⴱⵉⵔ\0", "ⴽⵜⵓⴱⵔ\0", "ⵏⵓⵡⴰⵏⴱⵉⵔ\0", "ⴷⵓⵊⴰⵏⴱⵉⵔ\0" },
        { "ⵉ\0", "ⴱ\0", "ⵎ\0", "ⵉ\0", "ⵎ\0", "ⵢ\0", "ⵢ\0", "ⵖ\0", "ⵛ\0", "ⴽ\0", "ⵏ\0", "ⴷ\0" },
        { "ⴰⵢⵏ\0", "ⴰⵙⵉ\0", "ⴰⴽⵕ\0", "ⴰⴽⵡ\0", "ⴰⵙⵉⵎ\0", "ⴰⵙⵉⴹ\0", "ⴰⵙⴰ\0" },
        { "ⴰⵢⵏⴰⵙ\0", "ⴰⵙⵉⵏⴰⵙ\0", "ⴰⴽⵕⴰⵙ\0", "ⴰⴽⵡⴰⵙ\0", "ⴰⵙⵉⵎⵡⴰⵙ\0", "ⴰⵙⵉⴹⵢⴰⵙ\0", "ⴰⵙⴰⵎⴰⵙ\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" },
        { "ⴰⵢⵏ\0", "ⴰⵙⵉ\0", "ⴰⴽⵕ\0", "ⴰⴽⵡ\0", "ⴰⵙⵉⵎ\0", "ⴰⵙⵉⴹ\0", "ⴰⵙⴰ\0" },
        { "ⴰⵢⵏⴰⵙ\0", "ⴰⵙⵉⵏⴰⵙ\0", "ⴰⴽⵕⴰⵙ\0", "ⴰⴽⵡⴰⵙ\0", "ⴰⵙⵉⵎⵡⴰⵙ\0", "ⴰⵙⵉⴹⵢⴰⵙ\0", "ⴰⵙⴰⵎⴰⵙ\0" },
        { "M\0", "T\0", "W\0", "T\0", "F\0", "S\0", "S\0" }
    }, // zgh_MA
    {
        QLocale::Language::Chinese, QLocale::Script::SimplifiedScript, QLocale::Country::China,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "中文\0", "中国\0",
        "yyyy/M/d\0", "yyyy年M月d日\0", "HH:mm\0", "Z HH:mm:ss\0",
        "上午\0", "下午\0",
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" }
    }, // zh_Hans_CN
    {
        QLocale::Language::Chinese, QLocale::Script::SimplifiedScript, QLocale::Country::HongKongSARChina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "中文\0", "中国香港特别行政区\0",
        "d/M/yyyy\0", "yyyy年M月d日\0", "APh:mm\0", "Z APh:mm:ss\0",
        "上午\0", "下午\0",
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" }
    }, // zh_Hans_HK
    {
        QLocale::Language::Chinese, QLocale::Script::SimplifiedScript, QLocale::Country::MacaoSARChina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "中文\0", "中国澳门特别行政区\0",
        "d/M/yyyy\0", "yyyy年M月d日\0", "APh:mm\0", "Z APh:mm:ss\0",
        "上午\0", "下午\0",
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" }
    }, // zh_Hans_MO
    {
        QLocale::Language::Chinese, QLocale::Script::SimplifiedScript, QLocale::Country::Singapore,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "中文\0", "新加坡\0",
        "dd/MM/yyyy\0", "yyyy年M月d日\0", "APh:mm\0", "Z APh:mm:ss\0",
        "上午\0", "下午\0",
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" }
    }, // zh_Hans_SG
    {
        QLocale::Language::Chinese, QLocale::Script::TraditionalScript, QLocale::Country::HongKongSARChina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "中文\0", "中國香港\0",
        "d/M/yyyy\0", "yyyy年M月d日\0", "APh:mm\0", "APh:mm:ss [Z]\0",
        "上午\0", "下午\0",
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" }
    }, // zh_Hant_HK
    {
        QLocale::Language::Chinese, QLocale::Script::TraditionalScript, QLocale::Country::MacaoSARChina,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "中文\0", "中国澳门特别行政区\0",
        "yyyy/M/d\0", "yyyy年M月d日\0", "HH:mm\0", "Z HH:mm:ss\0",
        "上午\0", "下午\0",
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" }
    }, // zh_Hant_MO
    {
        QLocale::Language::Chinese, QLocale::Script::TraditionalScript, QLocale::Country::Taiwan,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "中文\0", "台湾\0",
        "yyyy/M/d\0", "yyyy年M月d日\0", "HH:mm\0", "Z HH:mm:ss\0",
        "上午\0", "下午\0",
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "1月\0", "2月\0", "3月\0", "4月\0", "5月\0", "6月\0", "7月\0", "8月\0", "9月\0", "10月\0", "11月\0", "12月\0" },
        { "一月\0", "二月\0", "三月\0", "四月\0", "五月\0", "六月\0", "七月\0", "八月\0", "九月\0", "十月\0", "十一月\0", "十二月\0" },
        { "1\0", "2\0", "3\0", "4\0", "5\0", "6\0", "7\0", "8\0", "9\0", "10\0", "11\0", "12\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" },
        { "周一\0", "周二\0", "周三\0", "周四\0", "周五\0", "周六\0", "周日\0" },
        { "星期一\0", "星期二\0", "星期三\0", "星期四\0", "星期五\0", "星期六\0", "星期日\0" },
        { "一\0", "二\0", "三\0", "四\0", "五\0", "六\0", "日\0" }
    }, // zh_Hant_TW
    {
        QLocale::Language::Zulu, QLocale::Script::LatinScript, QLocale::Country::SouthAfrica,
        Qt::Monday, Qt::Saturday, Qt::Sunday,
        46, 44, 59, 37, 45, 43, 69, 48,
        "isiZulu\0", "iNingizimu Afrika\0",
        "M/d/yyyy\0", "MMMM d, yyyy\0", "HH:mm\0", "HH:mm:ss Z\0",
        "AM\0", "PM\0",
        { "Jan\0", "Feb\0", "Mas\0", "Eph\0", "Mey\0", "Jun\0", "Jul\0", "Aga\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januwari\0", "Februwari\0", "Mashi\0", "Ephreli\0", "Meyi\0", "Juni\0", "Julayi\0", "Agasti\0", "Septhemba\0", "Okthoba\0", "Novemba\0", "Disemba\0" },
        { "J\0", "F\0", "M\0", "A\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Jan\0", "Feb\0", "Mas\0", "Eph\0", "Mey\0", "Jun\0", "Jul\0", "Aga\0", "Sep\0", "Okt\0", "Nov\0", "Dis\0" },
        { "Januwari\0", "Februwari\0", "Mashi\0", "Ephreli\0", "Meyi\0", "Juni\0", "Julayi\0", "Agasti\0", "Septhemba\0", "Okthoba\0", "Novemba\0", "Disemba\0" },
        { "J\0", "F\0", "M\0", "E\0", "M\0", "J\0", "J\0", "A\0", "S\0", "O\0", "N\0", "D\0" },
        { "Mso\0", "Bil\0", "Tha\0", "Sin\0", "Hla\0", "Mgq\0", "Son\0" },
        { "UMsombuluko\0", "ULwesibili\0", "ULwesithathu\0", "ULwesine\0", "ULwesihlanu\0", "UMgqibelo\0", "ISonto\0" },
        { "M\0", "B\0", "T\0", "S\0", "H\0", "M\0", "S\0" },
        { "Mso\0", "Bil\0", "Tha\0", "Sin\0", "Hla\0", "Mgq\0", "Son\0" },
        { "UMsombuluko\0", "ULwesibili\0", "ULwesithathu\0", "ULwesine\0", "ULwesihlanu\0", "UMgqibelo\0", "ISonto\0" },
        { "M\0", "B\0", "T\0", "S\0", "H\0", "M\0", "S\0" }
    }, // zu_ZA
};
static const qint16 localeTblSize = sizeof(localeTbl) / sizeof(QLocalePrivate);

static const struct subtagAliasTblData {
    const QLocale::Language fromlanguage;
    const QLocale::Script fromscript;
    const QLocale::Country fromcountry;
    const QLocale::Language tolanguage;
    const QLocale::Script toscript;
    const QLocale::Country tocountry;
} subtagAliasTbl[] = {
    {
        QLocale::Language::Afar, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Afar, QLocale::Script::LatinScript, QLocale::Country::Ethiopia
    },
    {
        QLocale::Language::Abkhazian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Abkhazian, QLocale::Script::CyrillicScript, QLocale::Country::Georgia
    },
    {
        QLocale::Language::Achinese, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Achinese, QLocale::Script::LatinScript, QLocale::Country::Indonesia
    },
    {
        QLocale::Language::Acoli, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Acoli, QLocale::Script::LatinScript, QLocale::Country::Uganda
    },
    {
        QLocale::Language::Adangme, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Adangme, QLocale::Script::LatinScript, QLocale::Country::Ghana
    },
    {
        QLocale::Language::Adyghe, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Adyghe, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Avestan, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Avestan, QLocale::Script::AvestanScript, QLocale::Country::Iran
    },
    {
        QLocale::Language::TunisianArabic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::TunisianArabic, QLocale::Script::ArabicScript, QLocale::Country::Tunisia
    },
    {
        QLocale::Language::Afrikaans, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Afrikaans, QLocale::Script::LatinScript, QLocale::Country::SouthAfrica
    },
    {
        QLocale::Language::Aghem, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Aghem, QLocale::Script::LatinScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Akan, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Akan, QLocale::Script::LatinScript, QLocale::Country::Ghana
    },
    {
        QLocale::Language::Akkadian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Akkadian, QLocale::Script::SumeroAkkadianCuneiformScript, QLocale::Country::Iraq
    },
    {
        QLocale::Language::GhegAlbanian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::GhegAlbanian, QLocale::Script::LatinScript, QLocale::Country::Kosovo
    },
    {
        QLocale::Language::SouthernAltai, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::SouthernAltai, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Amharic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Amharic, QLocale::Script::EthiopicScript, QLocale::Country::Ethiopia
    },
    {
        QLocale::Language::Aragonese, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Aragonese, QLocale::Script::LatinScript, QLocale::Country::Spain
    },
    {
        QLocale::Language::Arabic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Arabic, QLocale::Script::ArabicScript, QLocale::Country::Egypt
    },
    {
        QLocale::Language::Aramaic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Aramaic, QLocale::Script::ImperialAramaicScript, QLocale::Country::Iran
    },
    {
        QLocale::Language::Mapuche, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Mapuche, QLocale::Script::LatinScript, QLocale::Country::Chile
    },
    {
        QLocale::Language::Araona, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Araona, QLocale::Script::LatinScript, QLocale::Country::Bolivia
    },
    {
        QLocale::Language::AlgerianArabic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::AlgerianArabic, QLocale::Script::ArabicScript, QLocale::Country::Algeria
    },
    {
        QLocale::Language::NajdiArabic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::NajdiArabic, QLocale::Script::ArabicScript, QLocale::Country::SaudiArabia
    },
    {
        QLocale::Language::MoroccanArabic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::MoroccanArabic, QLocale::Script::ArabicScript, QLocale::Country::Morocco
    },
    {
        QLocale::Language::EgyptianArabic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::EgyptianArabic, QLocale::Script::ArabicScript, QLocale::Country::Egypt
    },
    {
        QLocale::Language::Assamese, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Assamese, QLocale::Script::BanglaScript, QLocale::Country::India
    },
    {
        QLocale::Language::Asu, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Asu, QLocale::Script::LatinScript, QLocale::Country::Tanzania
    },
    {
        QLocale::Language::AmericanSignLanguage, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::AmericanSignLanguage, QLocale::Script::SignWritingScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::Asturian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Asturian, QLocale::Script::LatinScript, QLocale::Country::Spain
    },
    {
        QLocale::Language::Atikamekw, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Atikamekw, QLocale::Script::LatinScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::Avaric, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Avaric, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Awadhi, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Awadhi, QLocale::Script::DevanagariScript, QLocale::Country::India
    },
    {
        QLocale::Language::Aymara, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Aymara, QLocale::Script::LatinScript, QLocale::Country::Bolivia
    },
    {
        QLocale::Language::Azerbaijani, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Azerbaijani, QLocale::Script::LatinScript, QLocale::Country::Azerbaijan
    },
    {
        QLocale::Language::Azerbaijani, QLocale::Script::AnyScript, QLocale::Country::Iraq,
        QLocale::Language::Azerbaijani, QLocale::Script::ArabicScript, QLocale::Country::Iraq
    },
    {
        QLocale::Language::Azerbaijani, QLocale::Script::AnyScript, QLocale::Country::Iran,
        QLocale::Language::Azerbaijani, QLocale::Script::ArabicScript, QLocale::Country::Iran
    },
    {
        QLocale::Language::Azerbaijani, QLocale::Script::AnyScript, QLocale::Country::Russia,
        QLocale::Language::Azerbaijani, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Bashkir, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bashkir, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Baluchi, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Baluchi, QLocale::Script::ArabicScript, QLocale::Country::Pakistan
    },
    {
        QLocale::Language::Balinese, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Balinese, QLocale::Script::LatinScript, QLocale::Country::Indonesia
    },
    {
        QLocale::Language::Bavarian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bavarian, QLocale::Script::LatinScript, QLocale::Country::Austria
    },
    {
        QLocale::Language::Basaa, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Basaa, QLocale::Script::LatinScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Bamun, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bamun, QLocale::Script::BamumScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::BatakToba, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::BatakToba, QLocale::Script::LatinScript, QLocale::Country::Indonesia
    },
    {
        QLocale::Language::Ghomala, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Ghomala, QLocale::Script::LatinScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Belarusian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Belarusian, QLocale::Script::CyrillicScript, QLocale::Country::Belarus
    },
    {
        QLocale::Language::Beja, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Beja, QLocale::Script::ArabicScript, QLocale::Country::Sudan
    },
    {
        QLocale::Language::Bemba, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bemba, QLocale::Script::LatinScript, QLocale::Country::Zambia
    },
    {
        QLocale::Language::Betawi, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Betawi, QLocale::Script::LatinScript, QLocale::Country::Indonesia
    },
    {
        QLocale::Language::Bena, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bena, QLocale::Script::LatinScript, QLocale::Country::Tanzania
    },
    {
        QLocale::Language::Bafut, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bafut, QLocale::Script::LatinScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Badaga, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Badaga, QLocale::Script::TamilScript, QLocale::Country::India
    },
    {
        QLocale::Language::Bulgarian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bulgarian, QLocale::Script::CyrillicScript, QLocale::Country::Bulgaria
    },
    {
        QLocale::Language::WesternBalochi, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::WesternBalochi, QLocale::Script::ArabicScript, QLocale::Country::Pakistan
    },
    {
        QLocale::Language::Bhojpuri, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bhojpuri, QLocale::Script::DevanagariScript, QLocale::Country::India
    },
    {
        QLocale::Language::Bislama, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bislama, QLocale::Script::LatinScript, QLocale::Country::Vanuatu
    },
    {
        QLocale::Language::Bikol, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bikol, QLocale::Script::LatinScript, QLocale::Country::Philippines
    },
    {
        QLocale::Language::Bini, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bini, QLocale::Script::LatinScript, QLocale::Country::Nigeria
    },
    {
        QLocale::Language::Banjar, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Banjar, QLocale::Script::LatinScript, QLocale::Country::Indonesia
    },
    {
        QLocale::Language::Kom, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Kom, QLocale::Script::LatinScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Siksika, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Siksika, QLocale::Script::LatinScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::TaiDam, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::TaiDam, QLocale::Script::TaiVietScript, QLocale::Country::Vietnam
    },
    {
        QLocale::Language::Bambara, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bambara, QLocale::Script::LatinScript, QLocale::Country::Mali
    },
    {
        QLocale::Language::Bangla, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bangla, QLocale::Script::BanglaScript, QLocale::Country::Bangladesh
    },
    {
        QLocale::Language::Tibetan, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Tibetan, QLocale::Script::TibetanScript, QLocale::Country::China
    },
    {
        QLocale::Language::Bishnupriya, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bishnupriya, QLocale::Script::BanglaScript, QLocale::Country::India
    },
    {
        QLocale::Language::Bakhtiari, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bakhtiari, QLocale::Script::ArabicScript, QLocale::Country::Iran
    },
    {
        QLocale::Language::Breton, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Breton, QLocale::Script::LatinScript, QLocale::Country::France
    },
    {
        QLocale::Language::Braj, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Braj, QLocale::Script::DevanagariScript, QLocale::Country::India
    },
    {
        QLocale::Language::Brahui, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Brahui, QLocale::Script::ArabicScript, QLocale::Country::Pakistan
    },
    {
        QLocale::Language::Bodo, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bodo, QLocale::Script::DevanagariScript, QLocale::Country::India
    },
    {
        QLocale::Language::Bosnian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bosnian, QLocale::Script::LatinScript, QLocale::Country::BosniaAndHerzegovina
    },
    {
        QLocale::Language::Akoose, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Akoose, QLocale::Script::LatinScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Buriat, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Buriat, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Buginese, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Buginese, QLocale::Script::LatinScript, QLocale::Country::Indonesia
    },
    {
        QLocale::Language::Bulu, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Bulu, QLocale::Script::LatinScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Blin, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Blin, QLocale::Script::EthiopicScript, QLocale::Country::Eritrea
    },
    {
        QLocale::Language::Medumba, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Medumba, QLocale::Script::LatinScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Catalan, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Catalan, QLocale::Script::LatinScript, QLocale::Country::Spain
    },
    {
        QLocale::Language::Caddo, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Caddo, QLocale::Script::LatinScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::Atsam, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Atsam, QLocale::Script::LatinScript, QLocale::Country::Nigeria
    },
    {
        QLocale::Language::Chakma, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Chakma, QLocale::Script::ChakmaScript, QLocale::Country::Bangladesh
    },
    {
        QLocale::Language::Chechen, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Chechen, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Cebuano, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Cebuano, QLocale::Script::LatinScript, QLocale::Country::Philippines
    },
    {
        QLocale::Language::Chiga, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Chiga, QLocale::Script::LatinScript, QLocale::Country::Uganda
    },
    {
        QLocale::Language::Chamorro, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Chamorro, QLocale::Script::LatinScript, QLocale::Country::Guam
    },
    {
        QLocale::Language::Chuukese, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Chuukese, QLocale::Script::LatinScript, QLocale::Country::Micronesia
    },
    {
        QLocale::Language::Mari, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Mari, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Choctaw, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Choctaw, QLocale::Script::LatinScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::Chipewyan, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Chipewyan, QLocale::Script::LatinScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::Cherokee, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Cherokee, QLocale::Script::CherokeeScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::Chickasaw, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Chickasaw, QLocale::Script::LatinScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::CentralKurdish, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::CentralKurdish, QLocale::Script::ArabicScript, QLocale::Country::Iraq
    },
    {
        QLocale::Language::Chilcotin, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Chilcotin, QLocale::Script::LatinScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::Corsican, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Corsican, QLocale::Script::LatinScript, QLocale::Country::France
    },
    {
        QLocale::Language::Coptic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Coptic, QLocale::Script::CopticScript, QLocale::Country::Egypt
    },
    {
        QLocale::Language::Capiznon, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Capiznon, QLocale::Script::LatinScript, QLocale::Country::Philippines
    },
    {
        QLocale::Language::Cree, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Cree, QLocale::Script::UnifiedCanadianAboriginalSyllabicsScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::Michif, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Michif, QLocale::Script::LatinScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::CrimeanTatar, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::CrimeanTatar, QLocale::Script::CyrillicScript, QLocale::Country::Ukraine
    },
    {
        QLocale::Language::PlainsCree, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::PlainsCree, QLocale::Script::UnifiedCanadianAboriginalSyllabicsScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::NorthernEastCree, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::NorthernEastCree, QLocale::Script::UnifiedCanadianAboriginalSyllabicsScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::SeselwaCreoleFrench, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::SeselwaCreoleFrench, QLocale::Script::LatinScript, QLocale::Country::Seychelles
    },
    {
        QLocale::Language::Czech, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Czech, QLocale::Script::LatinScript, QLocale::Country::Czechia
    },
    {
        QLocale::Language::Kashubian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Kashubian, QLocale::Script::LatinScript, QLocale::Country::Poland
    },
    {
        QLocale::Language::SwampyCree, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::SwampyCree, QLocale::Script::UnifiedCanadianAboriginalSyllabicsScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::ChurchSlavic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::ChurchSlavic, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Chuvash, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Chuvash, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Welsh, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Welsh, QLocale::Script::LatinScript, QLocale::Country::UnitedKingdom
    },
    {
        QLocale::Language::Danish, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Danish, QLocale::Script::LatinScript, QLocale::Country::Denmark
    },
    {
        QLocale::Language::Dakota, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Dakota, QLocale::Script::LatinScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::Dargwa, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Dargwa, QLocale::Script::CyrillicScript, QLocale::Country::Russia
    },
    {
        QLocale::Language::Taita, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Taita, QLocale::Script::LatinScript, QLocale::Country::Kenya
    },
    {
        QLocale::Language::German, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::German, QLocale::Script::LatinScript, QLocale::Country::Germany
    },
    {
        QLocale::Language::Slave, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Slave, QLocale::Script::LatinScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::Dogrib, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Dogrib, QLocale::Script::LatinScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::Zarma, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Zarma, QLocale::Script::LatinScript, QLocale::Country::Niger
    },
    {
        QLocale::Language::Dogri, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Dogri, QLocale::Script::DevanagariScript, QLocale::Country::India
    },
    {
        QLocale::Language::LowerSorbian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::LowerSorbian, QLocale::Script::LatinScript, QLocale::Country::Germany
    },
    {
        QLocale::Language::CentralDusun, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::CentralDusun, QLocale::Script::LatinScript, QLocale::Country::Malaysia
    },
    {
        QLocale::Language::Duala, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Duala, QLocale::Script::LatinScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Divehi, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Divehi, QLocale::Script::ThaanaScript, QLocale::Country::Maldives
    },
    {
        QLocale::Language::JolaFonyi, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::JolaFonyi, QLocale::Script::LatinScript, QLocale::Country::Senegal
    },
    {
        QLocale::Language::Dyula, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Dyula, QLocale::Script::LatinScript, QLocale::Country::BurkinaFaso
    },
    {
        QLocale::Language::Dzongkha, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Dzongkha, QLocale::Script::TibetanScript, QLocale::Country::Bhutan
    },
    {
        QLocale::Language::Dazaga, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Dazaga, QLocale::Script::LatinScript, QLocale::Country::UnknownRegion
    },
    {
        QLocale::Language::Embu, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Embu, QLocale::Script::LatinScript, QLocale::Country::Kenya
    },
    {
        QLocale::Language::Ewe, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Ewe, QLocale::Script::LatinScript, QLocale::Country::Ghana
    },
    {
        QLocale::Language::Efik, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Efik, QLocale::Script::LatinScript, QLocale::Country::Nigeria
    },
    {
        QLocale::Language::Emilian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Emilian, QLocale::Script::LatinScript, QLocale::Country::Italy
    },
    {
        QLocale::Language::AncientEgyptian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::AncientEgyptian, QLocale::Script::EgyptianhieroglyphsScript, QLocale::Country::Egypt
    },
    {
        QLocale::Language::Ekajuk, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Ekajuk, QLocale::Script::LatinScript, QLocale::Country::UnknownRegion
    },
    {
        QLocale::Language::Greek, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Greek, QLocale::Script::GreekScript, QLocale::Country::Greece
    },
    {
        QLocale::Language::English, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::English, QLocale::Script::LatinScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::Esperanto, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Esperanto, QLocale::Script::LatinScript, QLocale::Country::world
    },
    {
        QLocale::Language::Spanish, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Spanish, QLocale::Script::LatinScript, QLocale::Country::Spain
    },
    {
        QLocale::Language::CentralYupik, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::CentralYupik, QLocale::Script::LatinScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::Estonian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Estonian, QLocale::Script::LatinScript, QLocale::Country::Estonia
    },
    {
        QLocale::Language::Basque, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Basque, QLocale::Script::LatinScript, QLocale::Country::Spain
    },
    {
        QLocale::Language::Ewondo, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Ewondo, QLocale::Script::LatinScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Extremaduran, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Extremaduran, QLocale::Script::LatinScript, QLocale::Country::Spain
    },
    {
        QLocale::Language::Persian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Persian, QLocale::Script::ArabicScript, QLocale::Country::Iran
    },
    {
        QLocale::Language::Fang, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Fang, QLocale::Script::LatinScript, QLocale::Country::EquatorialGuinea
    },
    {
        QLocale::Language::Fulah, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Fulah, QLocale::Script::LatinScript, QLocale::Country::Senegal
    },
    {
        QLocale::Language::Finnish, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Finnish, QLocale::Script::LatinScript, QLocale::Country::Finland
    },
    {
        QLocale::Language::Filipino, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Filipino, QLocale::Script::LatinScript, QLocale::Country::Philippines
    },
    {
        QLocale::Language::TornedalenFinnish, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::TornedalenFinnish, QLocale::Script::LatinScript, QLocale::Country::Sweden
    },
    {
        QLocale::Language::Fijian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Fijian, QLocale::Script::LatinScript, QLocale::Country::Fiji
    },
    {
        QLocale::Language::Faroese, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Faroese, QLocale::Script::LatinScript, QLocale::Country::FaroeIslands
    },
    {
        QLocale::Language::Fon, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Fon, QLocale::Script::LatinScript, QLocale::Country::Benin
    },
    {
        QLocale::Language::French, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::French, QLocale::Script::LatinScript, QLocale::Country::France
    },
    {
        QLocale::Language::CajunFrench, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::CajunFrench, QLocale::Script::LatinScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::Arpitan, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Arpitan, QLocale::Script::LatinScript, QLocale::Country::France
    },
    {
        QLocale::Language::NorthernFrisian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::NorthernFrisian, QLocale::Script::LatinScript, QLocale::Country::Germany
    },
    {
        QLocale::Language::EasternFrisian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::EasternFrisian, QLocale::Script::LatinScript, QLocale::Country::Germany
    },
    {
        QLocale::Language::Friulian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Friulian, QLocale::Script::LatinScript, QLocale::Country::Italy
    },
    {
        QLocale::Language::WesternFrisian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::WesternFrisian, QLocale::Script::LatinScript, QLocale::Country::Netherlands
    },
    {
        QLocale::Language::Irish, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Irish, QLocale::Script::LatinScript, QLocale::Country::Ireland
    },
    {
        QLocale::Language::Ga, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Ga, QLocale::Script::LatinScript, QLocale::Country::Ghana
    },
    {
        QLocale::Language::Gagauz, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gagauz, QLocale::Script::LatinScript, QLocale::Country::Moldova
    },
    {
        QLocale::Language::GanChinese, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::GanChinese, QLocale::Script::SimplifiedScript, QLocale::Country::China
    },
    {
        QLocale::Language::Gayo, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gayo, QLocale::Script::LatinScript, QLocale::Country::Indonesia
    },
    {
        QLocale::Language::Gbaya, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gbaya, QLocale::Script::LatinScript, QLocale::Country::UnknownRegion
    },
    {
        QLocale::Language::ZoroastrianDari, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::ZoroastrianDari, QLocale::Script::ArabicScript, QLocale::Country::Iran
    },
    {
        QLocale::Language::ScottishGaelic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::ScottishGaelic, QLocale::Script::LatinScript, QLocale::Country::UnitedKingdom
    },
    {
        QLocale::Language::Geez, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Geez, QLocale::Script::EthiopicScript, QLocale::Country::Ethiopia
    },
    {
        QLocale::Language::Gilbertese, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gilbertese, QLocale::Script::LatinScript, QLocale::Country::Kiribati
    },
    {
        QLocale::Language::Galician, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Galician, QLocale::Script::LatinScript, QLocale::Country::Spain
    },
    {
        QLocale::Language::Gilaki, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gilaki, QLocale::Script::ArabicScript, QLocale::Country::Iran
    },
    {
        QLocale::Language::Guarani, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Guarani, QLocale::Script::LatinScript, QLocale::Country::Paraguay
    },
    {
        QLocale::Language::GoanKonkani, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::GoanKonkani, QLocale::Script::DevanagariScript, QLocale::Country::India
    },
    {
        QLocale::Language::Gondi, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gondi, QLocale::Script::TeluguScript, QLocale::Country::India
    },
    {
        QLocale::Language::Gorontalo, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gorontalo, QLocale::Script::LatinScript, QLocale::Country::Indonesia
    },
    {
        QLocale::Language::Gothic, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gothic, QLocale::Script::GothicScript, QLocale::Country::Ukraine
    },
    {
        QLocale::Language::Grebo, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Grebo, QLocale::Script::LatinScript, QLocale::Country::UnknownRegion
    },
    {
        QLocale::Language::AncientGreek, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::AncientGreek, QLocale::Script::CypriotScript, QLocale::Country::Cyprus
    },
    {
        QLocale::Language::SwissGerman, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::SwissGerman, QLocale::Script::LatinScript, QLocale::Country::Switzerland
    },
    {
        QLocale::Language::Gujarati, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gujarati, QLocale::Script::GujaratiScript, QLocale::Country::India
    },
    {
        QLocale::Language::Wayuu, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Wayuu, QLocale::Script::LatinScript, QLocale::Country::Colombia
    },
    {
        QLocale::Language::Frafra, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Frafra, QLocale::Script::LatinScript, QLocale::Country::Ghana
    },
    {
        QLocale::Language::Gusii, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gusii, QLocale::Script::LatinScript, QLocale::Country::Kenya
    },
    {
        QLocale::Language::Manx, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Manx, QLocale::Script::LatinScript, QLocale::Country::IsleofMan
    },
    {
        QLocale::Language::Gwichin, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Gwichin, QLocale::Script::LatinScript, QLocale::Country::Canada
    },
    {
        QLocale::Language::Hausa, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Hausa, QLocale::Script::LatinScript, QLocale::Country::Nigeria
    },
    {
        QLocale::Language::Hausa, QLocale::Script::AnyScript, QLocale::Country::Cameroon,
        QLocale::Language::Hausa, QLocale::Script::ArabicScript, QLocale::Country::Cameroon
    },
    {
        QLocale::Language::Hausa, QLocale::Script::AnyScript, QLocale::Country::Sudan,
        QLocale::Language::Hausa, QLocale::Script::ArabicScript, QLocale::Country::Sudan
    },
    {
        QLocale::Language::HakkaChinese, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::HakkaChinese, QLocale::Script::SimplifiedScript, QLocale::Country::China
    },
    {
        QLocale::Language::Hawaiian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Hawaiian, QLocale::Script::LatinScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::Hebrew, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Hebrew, QLocale::Script::HebrewScript, QLocale::Country::Israel
    },
    {
        QLocale::Language::Hindi, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Hindi, QLocale::Script::DevanagariScript, QLocale::Country::India
    },
    {
        QLocale::Language::FijiHindi, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::FijiHindi, QLocale::Script::LatinScript, QLocale::Country::Fiji
    },
    {
        QLocale::Language::Hiligaynon, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::Hiligaynon, QLocale::Script::LatinScript, QLocale::Country::Philippines
    },
    {
        QLocale::Language::HmongNjua, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::HmongNjua, QLocale::Script::NyiakengPuachueHmongScript, QLocale::Country::UnitedStates
    },
    {
        QLocale::Language::HiriMotu, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
        QLocale::Language::HiriMotu, QLocale::Script::LatinScript, QLocale::Country::PapuaNewGuinea
    },
    {
        QLocale::Language::Croatian, QLocale::Script::AnyScript, QLocale::Country::AnyCountry,
      