/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Copyright (C) 2016 Ivailo Monev
**
** This file is part of the Katie Designer of the Katie Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
**
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QDECLARATIVEVIEW_PLUGIN_H
#define QDECLARATIVEVIEW_PLUGIN_H

#include <QtUiTools/customwidget.h>

QT_BEGIN_NAMESPACE

class QDeclarativeViewWidget: public QCustomWidget
{
    Q_OBJECT
public:
    QDeclarativeViewWidget(QObject *parent = nullptr);

    virtual QString name() const;
    virtual QString group() const;
    virtual QString toolTip() const;
    virtual QString whatsThis() const;
    virtual QString includeFile() const;
    virtual QIcon icon() const;
    virtual bool isContainer() const;
    virtual QWidget *createWidget(QWidget *parent);
    virtual bool isInitialized() const;
    virtual void initialize();
    virtual QString domXml() const;

private:
    bool m_initialized;
};

class QDeclarativeViewPlugin: public QCustomWidgetPlugin
{
    Q_OBJECT
public:
    QDeclarativeViewPlugin(QObject *parent = nullptr);
    virtual ~QDeclarativeViewPlugin();

    virtual QList<QCustomWidget*> customWidgets() const;

private:
    QList<QCustomWidget*> m_plugins;
};

QT_END_NAMESPACE

#endif // QDECLARATIVEVIEW_PLUGIN_H
