/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Copyright (C) 2016 Ivailo Monev
**
** This file is part of the QtScript module of the Katie Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
**
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QSCRIPTEXTENSIONINTERFACE_H
#define QSCRIPTEXTENSIONINTERFACE_H

#include <QtCore/qobject.h>

QT_BEGIN_NAMESPACE

class QScriptEngine;

struct Q_SCRIPT_EXPORT QScriptExtensionInterface
{
    virtual ~QScriptExtensionInterface() {}
    virtual QStringList keys() const = 0;
    virtual void initialize(const QString &key, QScriptEngine *engine) = 0;
};

QT_END_NAMESPACE

Q_DECLARE_INTERFACE(QScriptExtensionInterface,
    "Katie.QScriptExtensionInterface/1.0")


#endif // QSCRIPTEXTENSIONINTERFACE_H
