/* This file is part of the KDE project
   Copyright (C) 2008 Joseph Wenninger <jowenn@kde.org>
   Copyright (C) 2010 Dominik Haumann <dhaumann kde org>

   In addition to the following license there is an exception, that the KDE e.V.
   may decide on other forms of relicensing.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _KATE_CONTAINER_
#define _KATE_CONTAINER_

#include <KTextEditor/ContainerInterface>

class KateApp;
#include <QWidget>
namespace KTextEditor {
  class View;
}

class KateContainer
  : public QObject
  , public KTextEditor::ViewBarContainer
  , public KTextEditor::MdiContainer
{
  Q_OBJECT
  Q_INTERFACES( KTextEditor::ViewBarContainer )
  Q_INTERFACES( KTextEditor::MdiContainer )
  public:
    KateContainer(KateApp* parent);
    virtual ~KateContainer();

  //
  // KTextEditor::ViewBarContainer
  //
  public:
    virtual QWidget* getViewBarParent(KTextEditor::View *view,KTextEditor::ViewBarContainer::Position position);
    virtual void addViewBarToLayout(KTextEditor::View *view,QWidget *bar,KTextEditor::ViewBarContainer::Position position);
    virtual void showViewBarForView(KTextEditor::View *view,KTextEditor::ViewBarContainer::Position position);
    virtual void hideViewBarForView(KTextEditor::View *view,KTextEditor::ViewBarContainer::Position position);
    virtual void deleteViewBarForView(KTextEditor::View *view,KTextEditor::ViewBarContainer::Position position);

  //
  // KTextEditor::MdiContainer
  //
  public:
    virtual void setActiveView( KTextEditor::View * view );
    virtual KTextEditor::View * activeView();
    virtual KTextEditor::Document * createDocument();
    virtual bool closeDocument( KTextEditor::Document * doc );
    virtual KTextEditor::View * createView( KTextEditor::Document * doc );
    virtual bool closeView( KTextEditor::View * view );
};

#endif
// kate: space-indent on; indent-width 2; replace-tabs on;
