
#include "kcm_main.h"

extern "C"
{
    KCModule *create_mplayerthumbnail_config(QWidget *parent,const char *name) {
        KGlobal::locale()->insertCatalogue("mplayerthumbnail_config");
        return new kcmMplayerThumbnailConfig(parent,name);
    }
}

kcmMplayerThumbnailConfig::kcmMplayerThumbnailConfig(QWidget *,const char *name)
//    :KCModule(parent,name)
{
    config = new KConfig(MPLAYERTHUMBNAILRC,false,true);
    
        
    type << "MplayerThumbnail" << "AVI" << "MPG" << "MOV";
    names << 
        i18n("All files") <<
        i18n("AVI files (.AVI)") <<
        i18n("MPEG files (.MPG)") <<
        i18n("QuickTime files (.MOV)");
    vlayout = new QVBoxLayout(this);
    tab = new QTabWidget(this);
    vlayout->addWidget(tab);
                    
    for (unsigned int num = 0;num != type.count();++num) {
        configw[num] = new mplayerThumbnailConfigBase(this,name);
        tab->addTab(configw[num],(QString)names[num]);
        config->setGroup(type[num]);
        configw[num]->cFrames->setMinValue(1); // 饤ˤޤͤͿ뤪ޤʤ
        // ͭ/̵ɽʤ
        if (type[num] != "MplayerThumbnail") {
            bool e = config->readBoolEntry("Enable",false);
            emit configw[num]->configEnable->setChecked(e);
            emit configw[num]->configFrame->setEnabled(e);
        } else configw[num]->configEnable->setHidden(true);
        //
        emit configw[num]->cPosition->setValue(config->readNumEntry("CapturePosition"));
        emit configw[num]->cFrames->setValue(config->readNumEntry("CaptureFrames",1));
        if (config->readBoolEntry("DrawArrow",true)) 
            emit configw[num]->drawArrow->setChecked(true);
        else 
            emit configw[num]->drawArrow->setChecked(false);
        
        connect(configw[num]->drawArrow,SIGNAL(clicked()),SLOT(m_changed()));
        connect(configw[num]->configEnable,SIGNAL(clicked()),SLOT(m_changed()));
        connect(configw[num]->cPosition,SIGNAL(valueChanged(int)),SLOT(m_changed()));
        connect(configw[num]->cFrames,SIGNAL(valueChanged(int)),SLOT(m_changed()));
    }


//    layout = new QGridLayout(this,0,0,10);
//    mc = new mplayerThumbnailConfigBase(this,name);
//    layout->addWidget(mc,0,1);
    vlayout->activate();
//    emit changed(true);
}

kcmMplayerThumbnailConfig::~kcmMplayerThumbnailConfig()
{
    for (unsigned int num = 0;num != type.count();++num) {
        delete configw[num];
    }
    delete vlayout;
    delete tab;
    delete config;
}

void kcmMplayerThumbnailConfig::load() {
    for (unsigned int num = 0;num != type.count();++num) {
        config->setGroup(type[num]);
        configw[num]->cFrames->setMinValue(1); // 饤ˤޤͤͿ뤪ޤʤ
        // ͭ/̵ɽʤ
        if (type[num] != "MplayerThumbnail") {
            bool e = config->readBoolEntry("Enable",false);
            emit configw[num]->configEnable->setChecked(e);
            emit configw[num]->configFrame->setEnabled(e);
        } else configw[num]->configEnable->setHidden(true);
        //
        emit configw[num]->cPosition->setValue(config->readNumEntry("CapturePosition"));
        emit configw[num]->cFrames->setValue(config->readNumEntry("CaptureFrames",1));
        if (config->readBoolEntry("DrawArrow",true)) 
            emit configw[num]->drawArrow->setChecked(true);
        else 
            emit configw[num]->drawArrow->setChecked(false);
    }
}


void kcmMplayerThumbnailConfig::save() {
    for (unsigned int num = 0;num != type.count();++num) {
        config->setGroup(type[num]);
        if (type[num] != "MplayerThumbnail") {
            config->writeEntry("Enable",configw[num]->configEnable->isChecked());
        }
        config->writeEntry("CapturePosition",configw[num]->cPosition->value());
        config->writeEntry("CaptureFrames",configw[num]->cFrames->value());
        config->writeEntry("DrawArrow",configw[num]->drawArrow->isChecked());
    }
    config->sync();
}

void kcmMplayerThumbnailConfig::defaults() {
    for (unsigned int num = 0;num != type.count();++num) {
        configw[num]->cFrames->setMinValue(1); // 饤ˤޤͤͿ뤪ޤʤ
        // ͭ/̵ɽʤ
        if (type[num] != "MplayerThumbnail") {
            emit configw[num]->configEnable->setChecked(false);
            emit configw[num]->configFrame->setEnabled(false);
        } else configw[num]->configEnable->setHidden(true);
        //
        emit configw[num]->cPosition->setValue(0);
        emit configw[num]->cFrames->setValue(1);
        emit configw[num]->drawArrow->setChecked(true);
    }

}

void kcmMplayerThumbnailConfig::m_changed() {
    emit changed(true);
}


#include "kcm_main.moc"

