/*
 * Copyright (C) 2001 TAM (Teppei Tamra) <tamra@users.sourceforge.jp>
 */

#include <iostream.h>
#include <assert.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qpaintdevice.h>
/*
#include <qcolor.h>
#include <qfont.h>
#include <qpen.h>
*/
#include <qdir.h>
#include <qfile.h>
#include <qstring.h>
#include <qstringlist.h>
#include <kimageio.h>
#include <kprocess.h>
#include <kmdcodec.h>
#include <kstandarddirs.h>
#include <kconfig.h>
#include <kdebug.h>
#include "mplayerthumbnail.h"


extern "C"
{
        ThumbCreator *new_creator()
        {
                KImageIO::registerFormats();
                return new MplayerThumbnail;
        }
};

bool MplayerThumbnail::create(const QString &path, int, int, QImage &img)
{
	KMD5 md5(path);
	QString tmpdir = TMPDIR;
	QString d = "mt_" + QString::fromLatin1(md5.hexDigest());
	QDir tmp(TMPDIR);
	QImage mpimg;
	QPixmap play,pixmap;
    int position,frames;
    bool drawarrow;
    
    config = new KConfig(MPLAYERTHUMBNAILRC,true,true);
    
    config->setGroup("MplayerThumbnail");
    position = config->readNumEntry("CapturePosition");
    frames = config->readNumEntry("CaptureFrames",1);
    drawarrow = config->readBoolEntry("DrawArrow",true);
    //
    // ʬΥäȥޡȤˡ
    //
    QStringList e(QStringList::split(QString("."),path.upper()));
    QStringList::Iterator ext = e.end();
    ext--;
    config->setGroup(QString(*ext));
    
    if (config->readBoolEntry("Enable",false)) {
//        config->setGroup(QString(*ext));
        position = config->readNumEntry("CapturePosition");
        frames = config->readNumEntry("CaptureFrames",1);
        drawarrow = config->readBoolEntry("DrawArrow",true);
    }
 

     
    if ((position < 0) || (position > 100)) position = 0;
    if ((frames < 0) || (frames >20)) frames = 1;
    
    //if (!(config->readBoolEntry("Enable",true))) return(false);
	
    tmp.mkdir(d);
	tmpdir.append(d);
	process.clearArguments ();
	process.setWorkingDirectory(tmpdir);
	process.setUseShell(true);
	process << "mplayer -vo png -ao null -frames " << QString::number(frames) << " -ss " << QString::number(position) << " " << KProcess::quote(path).local8Bit();
	process.start(KProcess::Block);
    int i = frames + 1;
    while(i != 0){
        QString pngs;
        if (mpimg.load(tmpdir + pngs.sprintf("/%08d.png",i))) break;
        i --;
    }
	
    tmp = tmpdir;
	
    //
	// rm -rf /tmp/mt_...	
	//
	
	QStringList tmpfiles = tmp.entryList("*");
	for(QStringList::Iterator i = tmpfiles.begin(); i != tmpfiles.end(); ++i )
	{
        	tmp.remove(*i);
	}
	tmp.rmdir(tmpdir);
	
    if (mpimg.isNull()) {
        delete config;
        return (false);
    }

	//
	// draw arrow.
	//
	if (drawarrow) {
    	pixmap.convertFromImage(mpimg);
    	play = QPixmap(locate("data","mplayerthumbnail/play.png"));
    	QPainter paint(&pixmap);
    	paint.drawPixmap(0,0,play);
    	
/*        
        // ̵̤ɼ
        // פޤ͡ġ
        QColor color(214,124,14);
        paint.setPen(color);
        
        QFont font(paint.font());
        font.setPixelSize(24);
        font.setBold(true);
        paint.setFont(font);
        
        QPen pen(paint.pen());
        pen.setCapStyle(RoundCap);
        pen.setWidth(20);
        paint.setPen(pen);
        paint.drawText(60,60,"VIDEO");
        
*/        
        mpimg = pixmap.convertToImage();
    }
	img = mpimg.copy();

    delete config;
	return(true);
}

ThumbCreator::Flags MplayerThumbnail::flags() const
{
        return static_cast<Flags>(DrawFrame);
}


MplayerThumbnail::MplayerThumbnail()
{
//  config = new KConfig(MPLAYERTHUMBNAILRC,true,false);
//    config->setGroup("MplayerThumbnail");
}

MplayerThumbnail::~MplayerThumbnail()
{
//    delete config;
}





#include "mplayerthumbnail.moc"

