# -*- mode: perl; coding: utf-8 -*-
# Keitairc::View
# $Id: View.pm,v 1.29 2010/04/11 06:02:42 ishikawa Exp $
# $Source: /cvsroot/keitairc/lib/Keitairc/View.pm,v $
#
# Copyright (c) 2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2

package Keitairc::View;
use HTML::Template;
use HTTP::Response;
use Keitairc::Config;
use Keitairc::ClientInfo;
use strict;
use warnings;

################################################################
sub new{
	my $proto = shift;
	my $cf = shift;
	my $ci = shift;
	my $session_id = shift;
	my $me = {};
	$me->{Config} = $cf;
	$me->{ClientInfo} = $ci;
	if(defined $session_id){
		$me->{session_id} = $session_id;
	}
        bless $me;
}

################################################################
sub redirect{
	my $me = shift;
	my $path = shift;

	if($me->{Config}->web_root() ne '/'){
		# Softbank
		$path =~ s|^/||;
		$path = sprintf('%s%s', $me->{Config}->web_root(), $path);
	}

	Keitairc::Log::log_debug("path [$path]");

	my $response = HTTP::Response->new(302);
	$response->push_header('Location', $path);
	$response;
}

################################################################
sub template_path{
	my $me = shift;
	my $template = shift;
	for my $template_dir (split(':', $me->{Config}->template_dir())){
		if(-r "$template_dir/$template"){
			return "$template_dir/$template";
		}
	}
}

################################################################
sub public_path{
	my $me = shift;
	my $file = shift;
	for my $public_dir (split(':', $me->{Config}->public_dir())){
		if(-r "$public_dir/$file"){
			return "$public_dir/$file";
		}
	}
}

################################################################
sub template{
	my $me = shift;
	my $template = shift;
	my $vars = shift;

	my $p = {};
	$p->{root} = $me->{Config}->web_root();
	$p->{title} = $me->{Config}->web_title();
	$p->{version} = $me->{Config}->version();
	$p->{common_header} = $me->{Config}->common_header();
	$p->{extra_header} = $me->{Config}->extra_header();
	$p->{content_charset} = $me->{Config}->content_charset();

	if($me->{ClientInfo}->is_mobile){
		$p->{fontsize} = $me->{Config}->mobile_fontsize();
	}else{
		$p->{fontsize} = $me->{Config}->fontsize();
	}
	$p->{target} = $me->{Config}->url_target();
	$p->{redirect} = $me->{Config}->url_redirect();
	$p->{timestamp} = timestamp();
	$p->{stamp} = time;

	$p->{is_ipod} = $me->{ClientInfo}->is_ipod();
	$p->{is_docomo} = $me->{ClientInfo}->is_docomo();
	$p->{is_ezweb} = $me->{ClientInfo}->is_ezweb();
	$p->{is_softbank} = $me->{ClientInfo}->is_softbank();
	$p->{is_emobile} = $me->{ClientInfo}->is_emobile();
	$p->{is_mobile} = $me->{ClientInfo}->is_mobile();

	map {
		$p->{"plugin_$_"} = 1;
	} $::pl->list_plugins();

	my $arch = 'default';
	if($me->{ClientInfo}->is_ipod()){
		$arch = 'ipod-sjis';
	}

	# Note: ishikawa
	# 現状、varsの中は既にencodeされた文字列が入ってきているはずだけど
	# 内部コードのままで、最後の output を encode するのが本来はいい
	# のではないかと思う。
	# が、今いじるとあちこち影響でそうなので 2.0 出てから直す。
	if (my $filename = $me->template_path("$arch/$template")) {
		my $t = new HTML::Template(
			filename => $filename,
			die_on_bad_params => 0,
			filter => sub {
				my $text_ref = shift;
				Encode::from_to($$text_ref, 'shift_jis', $me->{Config}->web_charset());
			},
			cache => 1);
		$t->param($p);

		if(defined $vars){
			$t->param($vars);
		}

		$t->output();
	}
}

################################################################
sub public{
	my $me = shift;
	my $file = shift;
	my $mime_types = {
		html => 'text/html',
		css => 'text/css',
		gif => 'image/gif',
		png => 'image/png',
		jpg => 'image/jpg',
		txt => 'text/plain',
		js => 'application/javascript',
	};

	if(open(my $fh, '<', $me->public_path($file))){
		local $/;
		undef $/;
		my $buf = join('', <$fh>);
		close($fh);

		my ($ext) = ($file =~ /\.(.*)$/);
		my $mime_type = $mime_types->{$ext} || 'text/plain';

		my $response = HTTP::Response->new(200);
		$response->push_header('Content-type', $mime_type);
		$response->content($buf);
		return $response;
	}

	# not found
	my $response = HTTP::Response->new(404);
	$response->push_header('Content-type', 'text/html; charset=' . $me->{Config}->content_charset());
	$response->content($me->template('404.html', { action => $file }));
	return $response;
}

################################################################
sub render{
	my $me = shift;
	my $template = shift;
	my $vars = shift || {};
	$vars->{_http_status_code} ||= 200;
	my $response = HTTP::Response->new($vars->{_http_status_code});
	$vars->{content_type} |= 'text/html; charset=' . $me->{Config}->content_charset();
	$response->push_header('Content-type', $vars->{content_type});
	$response->content($me->template($template, $vars));
	$response;
}

################################################################
sub timestamp{
	my ($sec, $min, $hour, $day, $mon, $year) = localtime(time);
	sprintf('%d/%d/%d %02d:%02d:%02d',
		$year+1900, $mon+1, $day, $hour, $min, $sec);
}

1;
