///////////////////////////////////////////////////////////////////////////////
// cmd_ui.hpp
//

#ifndef KETCHUP_CMD_UI_H
#define KETCHUP_CMD_UI_H

#ifdef _MSC_VER
#pragma once
#endif

namespace ketchup {

///////////////////////////////////////////////////////////////////////////////
// cmd_ui
//
struct cmd_ui
{
private:
	UINT m_nID;

public:
	explicit cmd_ui(UINT nID) : m_nID(nID) { }
	UINT get_id() const { return m_nID; }
	virtual void enable(bool = true) { }
	virtual void set_check(int = 1) { }
	virtual void set_radio(bool bOn = true) { set_check(bOn); }
	virtual void set_text(LPCTSTR) { };
	virtual void set_default(bool = true) { }
	virtual bool is_clingy() { return false; }
	virtual ~cmd_ui() { }
};

} // namespace ketchup

#endif
