
#pragma once

#include "../cmd_ui.hpp"

namespace ketchup { namespace cmd_ui_impl {

///////////////////////////////////////////////////////////////////////////////
// childwindow_cmd_ui
//
struct childwindow_cmd_ui : cmd_ui
{
	CWindow m_wndChild;
	explicit childwindow_cmd_ui(UINT nID, HWND hWndChild)
		: cmd_ui(nID), m_wndChild(hWndChild)
	{
		assert(m_wndChild.IsWindow());
	}

	virtual void enable(bool bOn = true)
	{
		// See: MFC7::CCmdUI::Enable
		// if control has the focus, move the focus before disabling
		if (!bOn && (::GetFocus() == m_wndChild))
		{
			CWindow wndParent = m_wndChild.GetParent();
			wndParent.SendMessage(WM_NEXTDLGCTL, 0, FALSE);
		}
		m_wndChild.EnableWindow(bOn);
	}

	virtual void set_check(int nCheck = 1)
	{
		// we can only check buttons or controls acting like buttons
		if (m_wndChild.SendMessage(WM_GETDLGCODE) & DLGC_BUTTON)
			m_wndChild.SendMessage(BM_SETCHECK, nCheck);
	}

	virtual void set_text(LPCTSTR lpszText)
	{
		assert(lpszText != NULL);
		m_wndChild.SetWindowText(lpszText);
	}
};

} } // namespace ketchup::cmd_ui_impl
