//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : KiBbsUploadServlet.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: KiBbsUploadServlet.java,v 1.1.1.1 2004/03/03 15:24:02 k-imoto Exp $
//====================================================================
package KiWeb.KiBbs;

import java.io.*;
import java.text.*;
import java.util.*;
import java.lang.*;
import javax.servlet.*;
import javax.servlet.http.*;
import KiWeb.Util.*;
import KiWeb.Servlet.*;
import KiWeb.Util.Upload.*;

//--------------------------------------------------------------------
// BBS SERVLET
//--------------------------------------------------------------------
public class KiBbsUploadServlet extends HttpServlet 
{
    static final int    mMaxSize = 100 * 1024;
    static final String mUploadFileAttr = "uploadfile";
    static long         mNumber  = 0;
    
    //----------------------------------------------------------------
    // Servlet
    //----------------------------------------------------------------
    public void init()
    {
    }
    
    //----------------------------------------------------------------
    // POST\bh -> GETƓ
    //----------------------------------------------------------------
    public void doPost(HttpServletRequest request,
                       HttpServletResponse response)
        throws IOException, ServletException
    {
        doGet(request, response);
    }
    
    //----------------------------------------------------------------
    // GET\bh
    //----------------------------------------------------------------
    public void doGet(HttpServletRequest  request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {
        try {
            ServletContext sc =
                getServletConfig().getServletContext();
            ServletInputStream aStream = request.getInputStream();
            int aContentLength = request.getIntHeader("Content-Length");
            if (aContentLength > mMaxSize) {
                throw new ServletException(
                    new FileUploadSizeOverException(aContentLength));
            }
            String aFileSuffix = 
                "" + assignNumber() + (new Date()).getTime();
            MultipartSplitter aSplitter = 
                new MultipartSplitter(request.getHeader("Content-Type"),
                                      aStream,
                                      sc.getRealPath("/WEB-INF"),
                                      aFileSuffix);
            
            request.setAttribute(mUploadFileAttr,
                                 aSplitter.get(mUploadFileAttr));
            sc.getRequestDispatcher(
                "/KiBbsServlet?function=" + KiBbsServlet.FUNC_ID_RESTORE).
                forward(request, response);
        } catch (Exception e){ 
            throw new ServletException(e);
        }
    }
    
    private synchronized long assignNumber()
    {
        return mNumber++;
    }
}

