//====================================================================
// KiWeb
//--------------------------------------------------------------------
// t@C : MultipartSplitter.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: MultipartSplitter.java,v 1.1.1.1 2004/03/03 15:24:02 k-imoto Exp $
//====================================================================
package KiWeb.Util.Upload;

import java.io.*;
import java.text.*;
import java.util.*;
import java.lang.*;
import javax.servlet.*;
import javax.servlet.http.*;
import KiWeb.Util.*;

//--------------------------------------------------------------------
// MULTIPART SPLITTER
//--------------------------------------------------------------------
public class MultipartSplitter
{
    static final String mBoundaryKeyStr        = "boundary=";
    static final String mContentDispositionStr = "content-disposition";
    static final String mParamNameStr          = "name=\"";
    static final String mParamFileNameStr      = "filename=\"";
    static final String mParamEndStr           = "\"";
    static final String mContentTypeStr        = "content-type:";
    static final String mFileName              = "/upload";
    static final int    mBufSize               = 8 * 1024;
    
    ServletInputStream mStream;
    Hashtable          mParts;
    String             mRootPath;
    String             mBeginBoundary;
    String             mEndBoundary;
    String             mFileSuffix;

    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public MultipartSplitter(String             inType,
                             ServletInputStream inStream,
                             String             inRootPath,
                             String             inFileSuffix)
        throws IOException, FileUploadNotSupportException
    {
        mParts      = new Hashtable();
        mStream     = inStream;
        mRootPath   = inRootPath;
        mFileSuffix = inFileSuffix;
        
        //------------------------------------------------------------
        // Boundary̎擾
        //------------------------------------------------------------
        String aContentType = inType.toLowerCase();
        int aBoundaryStart = aContentType.indexOf(mBoundaryKeyStr);
        if (aBoundaryStart == -1) {
            throw new FileUploadNotSupportException();
        }
        int aBoundaryPos = aBoundaryStart + mBoundaryKeyStr.length();
        mBeginBoundary = 
            "--" + aContentType.substring(aBoundaryPos);
        mEndBoundary = 
            "--" + aContentType.substring(aBoundaryPos) + "--";

        //------------------------------------------------------------
        // Content̐؂蕪
        //------------------------------------------------------------
        byte[] aBuf = new byte[mBufSize];
        int    aLineLen;
        SplitState aState = new SplitStateEmpty();
        while ((aLineLen = mStream.readLine(aBuf, 
                                            0, 
                                            aBuf.length)) > -1) {
            aState = aState.transit(new String(aBuf, 0, aLineLen));
        }
    }
    
    //----------------------------------------------------------------
    // p[^l擾
    //----------------------------------------------------------------
    public String get(String inName)
    {
        return (String)mParts.get(inName);
    }


    //================================================================
    // ́AԊǗp InnerNXQ
    //================================================================
    //----------------------------------------------------------------
    // SPLIT STATE Interface
    //----------------------------------------------------------------
    interface SplitState
    {
        public SplitState transit(String inStr);
    }

    //----------------------------------------------------------------
    // SPLIT STATE :: EMPTY
    //----------------------------------------------------------------
    class SplitStateEmpty implements SplitState
    {
        public SplitStateEmpty() {}
        public SplitState transit(String inStr)
        {
            SplitState aState = this;
            //--------------------------------------------------------
            // Boundary I
            //--------------------------------------------------------
            if (inStr.indexOf(mBeginBoundary) >= 0) {
                aState = new SplitStateFoundBoundary();
            }
            return aState;
        }
    }

    //----------------------------------------------------------------
    // SPLIT STATE :: FOUND_BOUNDARY
    //----------------------------------------------------------------
    class SplitStateFoundBoundary implements SplitState
    {
        public SplitStateFoundBoundary() {}
        public SplitState transit(String inStr)
        {
            String     aName  = null;
            SplitState aState = this;
            String aLowerCase = inStr.toLowerCase();
            if (aLowerCase.startsWith(mContentDispositionStr)) {
                //----------------------------------------------------
                // name 擾
                //----------------------------------------------------
                int aNameBegin = aLowerCase.indexOf(mParamNameStr);
                int aNameEnd   = 
                        aLowerCase.indexOf(
                            mParamEndStr, 
                            aNameBegin + mParamNameStr.length() + 1);
                if ((aNameBegin > -1) && (aNameEnd > -1)) {
                    aName = 
                        inStr.substring(
                            aNameBegin + mParamNameStr.length(), 
                            aNameEnd);
                    aNameBegin = aLowerCase.indexOf(mParamFileNameStr);
                    aNameEnd   = 
                        aLowerCase.indexOf(
                            mParamEndStr, 
                            aNameBegin + mParamFileNameStr.length() + 1);
                    if ((aNameBegin > -1) && (aNameEnd > -1)) {
                        aState = new SplitStateFile(aName);
                    } else {
                        aState = new SplitStateValue(aName);
                    }
                } else {
                    aState = new SplitStateEmpty();
                }
            }
            return aState;
        }
    }
    
    //----------------------------------------------------------------
    // SPLIT STATE :: VALUE
    //----------------------------------------------------------------
    class SplitStateValue implements SplitState
    {
        String mValue;
        String mName;
        public SplitStateValue(String inName) 
        {
            mName  = inName;
            mValue = null;
        }
        public SplitState transit(String inStr)
        {
            SplitState aState = this;
            String aLowerCase = inStr.toLowerCase();
            if (aLowerCase.indexOf(mBeginBoundary) != -1) {
                mParts.put(mName, mValue);
                aState = new SplitStateFoundBoundary();
            } else if (aLowerCase.indexOf(mEndBoundary) != -1) {
                mParts.put(mName, mValue);
                aState = new SplitStateEmpty();
            } else {
                mValue = inStr;
            }
            return aState;
        }
    }

    //----------------------------------------------------------------
    // SPLIT STATE :: FILE
    //----------------------------------------------------------------
    class SplitStateFile implements SplitState
    {
        String mName;
        public SplitStateFile(String inName) 
        {
            mName  = inName;
        }
        public SplitState transit(String inStr)
        {
            SplitState aState = this;
            String     aLowerCase = inStr.toLowerCase();
            if (aLowerCase.startsWith(mContentTypeStr)) {
                int aCTypePos = aLowerCase.indexOf(" ");
                if (aCTypePos != -1) {
                    String aContentType =
                        aLowerCase.substring(aCTypePos + 1);
                    if (aContentType.indexOf("text") == -1) {
                        // oCi
                    } else {
                        String aFileName = 
                            mRootPath + mFileName + mFileSuffix /* + ".xml" */ ;
                        try {
                            FileWriter aWriter = 
                                new FileWriter(aFileName);
                            aState = new SplitStateTextFileContent(
                                             mName,
                                             aFileName,
                                             aWriter);
                        } catch (IOException e) {
                            aState = new SplitStateEmpty();
                        }
                    }
                } else {
                    aState = new SplitStateEmpty();
                }
            }
            return aState;
        }
    }

    //----------------------------------------------------------------
    // SPLIT STATE :: TEXT_FILE_CONTENT
    //----------------------------------------------------------------
    class SplitStateTextFileContent implements SplitState
    {
        String     mName;
        String     mFileName;
        FileWriter mWriter;
        boolean    mFirstLine;
        
        public SplitStateTextFileContent(String     inName,
                                         String     inFileName,
                                         FileWriter inWriter) 
        {
            mName     = inName;
            mFileName = inFileName;
            mWriter   = inWriter;
            mFirstLine = true;
        }
        public SplitState transit(String inStr)
        {
            SplitState aState = this;
            String aLowerCase = inStr.toLowerCase();
            try {
                if (aLowerCase.indexOf(mBeginBoundary) != -1) {
                    mParts.put(mName, mFileName);
                    mWriter.close();
                    aState = new SplitStateFoundBoundary();
                } else if (aLowerCase.indexOf(mEndBoundary) != -1) {
                    mParts.put(mName, mFileName);
                    mWriter.close();
                    aState = new SplitStateEmpty();
                } else {
                    if (!mFirstLine) {
                        try {
                            mWriter.write(inStr);
                        } catch (IOException e) {
                            mWriter.close();
                            aState = new SplitStateEmpty();
                        }
                    } else {
                        mFirstLine = false;
                    }
                }
            } catch (IOException e) {
                aState = new SplitStateEmpty();
            }
            return aState;
        }
    }
}

