//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : XmlDataStorage.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: XmlDataStorage.java,v 1.1.1.1 2004/03/03 15:24:03 k-imoto Exp $
//====================================================================
package KiWeb.KiBbs;

import javax.xml.parsers.*;
import javax.xml.transform.*;
import org.w3c.dom.*;
import java.util.*;
import java.io.*;

//--------------------------------------------------------------------
// BBS DATA STORAGE
//--------------------------------------------------------------------
public class XmlDataStorage implements DataStorage
{
    Document mThreadOrder;
    int      mMaxThreads;
    int      mMaxFollows;
    String   mRootPath;
    
    DocumentBuilder mBuilder;
    Transformer     mTransformer;
    
    static final String THREAD_ORDER_FILE = "thread-order.xml";
    static final String DATA_FILE_SUFFIX  = ".xml";
    
    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public XmlDataStorage(int    inMaxThreads, 
                          int    inMaxFollows,
                          String inRootPath)
    {
        mMaxThreads  = inMaxThreads;
        mMaxFollows  = inMaxFollows;
        mRootPath    = inRootPath;
        mThreadOrder = loadOrder();
        
        DocumentBuilderFactory aDBFactory = 
            DocumentBuilderFactory.newInstance();
        DocumentBuilder mBuilder = aDBFactory.newDocumentBuilder();
        
        TransformerFactory aTFactory = 
            TransformerFactory.newInstance();
        Transformer mTransformer = aTFactory.newTransformer();
    }
    
    //----------------------------------------------------------------
    // tH[
    //----------------------------------------------------------------
    public synchronized void write(Item   inItem)
    {
        save(inItem);
        
        Thread aThread = (Thread)read(inItem.getParent());
        if (aThread != null) {
            aThread.add(inItem); // ă[ĥŁAēxtH[ǉ
            removeThreadOrder(aThread.getId());
            insertThreadOrder(0, aThread.getId());
            save(aThread);
            saveOrder(mThreadOrder);
        }
    }
    
    //----------------------------------------------------------------
    // Xbh
    //----------------------------------------------------------------
    public synchronized void write(Thread inThread)
    {
        if (getLength() >= mMaxThreads) {
            int    aLastIndex = getLength() - 1;
//            String anId       = (String)mThreadOrder.get(aLastIndex);
            deleteThreadFile(inThread);
            removeThreadOrder(getLength() - 1);
        }
        save(inThread);
//        insertThreadOrder(0, aThread.getId());
        saveOrder(mThreadOrder);
    }
    
    //----------------------------------------------------------------
    // ACe폜
    //----------------------------------------------------------------
    public synchronized void delete(Item inItem)
    {
        if (inItem instanceof Thread) {
            Thread aThread = (Thread)inItem;
            removeThreadOrder(aThread.getId());
            saveOrder(mThreadOrder);
            deleteThreadFile(aThread);
        } else {
            Thread aThread = readThread(inItem.getParent());
            if (aThread != null) {
                aThread.delete(inItem);
                save(aThread);
                deleteItemFile(inItem);
            }
        }
    }
    
    //----------------------------------------------------------------
    // Xbh/tH[ǂݍ
    //----------------------------------------------------------------
    public synchronized Item read(String inId)
    {
        Item anItem = null;
        anItem = load(inId);
        return anItem;
    }

    //----------------------------------------------------------------
    // Xbhǂݍ
    //----------------------------------------------------------------
    public synchronized Thread readThread(String inId)
    {
        Thread aThread = null;
        aThread = loadThread(inId);
        return aThread;
    }
    
    //----------------------------------------------------------------
    // Xbhǂݍ
    //----------------------------------------------------------------
    public synchronized Thread readThread(int   inIndex)
    {
        Thread aThread = null;
        if (getLength() > inIndex) {
//            aThread = readThread((String)mThreadOrder.get(inIndex));
        }
        return aThread;
    }
    
    //----------------------------------------------------------------
    // Xbh擾
    //----------------------------------------------------------------
    public synchronized int    getLength()
    {
        Element  aRoot = mThreadOrder.getDocumentElement();
        NodeList aList = aRoot.getElementsByTagName("id");
        return aList.getLength();
    }
    
    //----------------------------------------------------------------
    // Xbht@CɃZ[u
    //----------------------------------------------------------------
    public void save(Thread inThread)
    {
        try {
            FileOutputStream   fos = 
                new FileOutputStream(mRootPath + 
                                     "/"       + 
                                     inThread.getId() +
                                     DATA_FILE_SUFFIX);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(inThread);
            oos.flush();
            fos.close();
        } catch (Exception e) {e.printStackTrace();}
    }

    //----------------------------------------------------------------
    // tH[t@CɃZ[u
    //----------------------------------------------------------------
    public void save(Item inItem)
    {
        try {
            FileOutputStream   fos = 
                new FileOutputStream(mRootPath + 
                                     "/"       + 
                                     inItem.getId() +
                                     DATA_FILE_SUFFIX);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(inItem);
            oos.flush();
            fos.close();
        } catch (Exception e) {e.printStackTrace();}
    }
    
    //----------------------------------------------------------------
    // Xbht@C烍[h
    //----------------------------------------------------------------
    public Thread loadThread(String inId)
    {
        Thread aThread = null;
        try {
            FileInputStream   fis = 
                new FileInputStream(mRootPath + 
                                    "/"       + 
                                    inId      + 
                                    DATA_FILE_SUFFIX);
            ObjectInputStream ois = new ObjectInputStream(fis);
            aThread = (Thread)ois.readObject();
            fis.close();
        } catch (Exception e) {
            aThread = null;
        }
        return aThread;
    }

    //----------------------------------------------------------------
    // tH[t@C烍[h
    //----------------------------------------------------------------
    public Item load(String inId)
    {
        Item anItem = null;
        try {
            FileInputStream   fis = 
                new FileInputStream(mRootPath + 
                                    "/"       + 
                                    inId      + 
                                    DATA_FILE_SUFFIX);
            ObjectInputStream ois = new ObjectInputStream(fis);
            anItem = (Item)ois.readObject();
            fis.close();
        } catch (Exception e) {
            anItem = null;
        }
        return anItem;
    }
    
    //----------------------------------------------------------------
    // XbhсÃtH[
    //----------------------------------------------------------------
    public void deleteThreadFile(Thread inThread)
    {
        File f = new File(mRootPath + 
                          "/"       + 
                          inThread.getId() + 
                          DATA_FILE_SUFFIX);
        f.delete();
        
        Iterator i = inThread.iterator();
        while (i.hasNext()) {
            String anId = (String)i.next();
            f = new File(mRootPath + 
                         "/"       + 
                         anId +
                         DATA_FILE_SUFFIX);
            f.delete();
        }
    }
    
    //----------------------------------------------------------------
    // ACe
    //----------------------------------------------------------------
    public void deleteItemFile(Item inItem)
    {
        File f = new File(mRootPath + 
                          "/"       + 
                          inItem.getId() + 
                          DATA_FILE_SUFFIX);
        f.delete();
    }


//====================================================================
    //----------------------------------------------------------------
    // XbhI[_[ɒǉ
    //----------------------------------------------------------------
    private void insertThreadOrder(int inIndex, String inId)
    {
        Element  aRoot = mThreadOrder.getDocumentElement();
        NodeList aList = aRoot.getElementsByTagName("id");
        Element  anElem = (Element)aList.item(inIndex);
        
        Element aNewElem = mThreadOrder.createElement("id");
        aNewElem.setNodeValue(inId);
        
        aRoot.insertBefore(aNewElem, anElem);
    }

    //----------------------------------------------------------------
    // XbhI[_[
    //----------------------------------------------------------------
    private void removeThreadOrder(String inId)
    {
        Element  aRoot = mThreadOrder.getDocumentElement();
        NodeList aList = aRoot.getElementsByTagName("id");
        for (int i = 0; i < aList.getLength(); i++) {
            Element anElem = (Element)aList.item(i);
            String  anId   = anElem.getFirstChild().getNodeValue();
            
            if (anId.equals(inId)) {
                aRoot.removeChild(anElem);
                break;
            }
        }
    }

    //----------------------------------------------------------------
    // XbhI[_[
    //----------------------------------------------------------------
    private void removeThreadOrder(int inIndex)
    {
        Element  aRoot = mThreadOrder.getDocumentElement();
        NodeList aList = aRoot.getElementsByTagName("id");
        Element anElem = (Element)aList.item(inIndex);
        aRoot.removeChild(anElem);
    }

    //----------------------------------------------------------------
    // XbhI[_[̃Z[u
    //----------------------------------------------------------------
    public void saveOrder(Document inOrder)
    {
        try {
            FileOutputStream   fos = 
                new FileOutputStream(mRootPath + 
                                     "/"       + 
                                     THREAD_ORDER_FILE);

//            Source aSource = new DOMSource(inOrder);
//            Result aResult = new stream.StreamResult(fos);
//            mTransformer.transform(aSource, aResult);
            
            fos.close();
        } catch (Exception e) {e.printStackTrace();}
    }
    
    //----------------------------------------------------------------
    // XbhI[_[̃[h
    //----------------------------------------------------------------
    public Document loadOrder()
    {
        Document anOrder = null;
        try {
            FileInputStream   fis = 
                new FileInputStream(mRootPath + 
                                    "/"       + 
                                    THREAD_ORDER_FILE);
                                    
            anOrder = mBuilder.parse(fis);
            fis.close();
        } catch (Exception e) {
//            anOrder = new mBuilder.newDocument();
        }
        return anOrder;
    }
}