//====================================================================
// KiWeb
//--------------------------------------------------------------------
// t@C : ActionDispatcher.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: ActionDispatcher.java,v 1.1.1.1 2004/03/03 15:24:00 k-imoto Exp $
//====================================================================
package KiWeb.Servlet;

import java.util.*;
import java.lang.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

//--------------------------------------------------------------------
// KIWEB SERVLET ACTION DISPATCHER
//--------------------------------------------------------------------
public class ActionDispatcher
{
    Vector mActions;
    Action mDefaultAction;
    
    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public ActionDispatcher()
    {
        mActions = new Vector();
        mDefaultAction = null;
    }

    //----------------------------------------------------------------
    // Actionǉ
    //----------------------------------------------------------------
    public void add(int inActNum, Action inAction)
    {
        Action anAct = search(inActNum);
        if (anAct == null) {
            inAction.attach(inActNum);
            mActions.add(inAction);
        } else {
            /* Exception!! */
        }
    }
    
    //----------------------------------------------------------------
    // Default Actionǉ
    //----------------------------------------------------------------
    public void addDefault(Action inAction)
    {
        mDefaultAction = inAction;
    }

    //----------------------------------------------------------------
    // Action폜
    //----------------------------------------------------------------
    public void remove(int inActNum)
    {
        Action anAct = search(inActNum);
        if (anAct != null) {
            mActions.remove(anAct);
        }
    }

    //----------------------------------------------------------------
    // Action폜
    //----------------------------------------------------------------
    public void remove(Action inAction)
    {
        Action anAct = search(inAction.getActionNumber());
        if (anAct != null) {
            mActions.remove(anAct);
        }
    }
    
    //----------------------------------------------------------------
    // Dispatch
    //----------------------------------------------------------------
    public String dispatch(int                 inActNum,
                           HttpServletRequest  request,
                           HttpServletResponse response)
        throws ServletException, IOException, ActionNotFoundException
    {
        String anUri = null;
        Action anAct = search(inActNum);
        if (anAct != null) {
            if (anAct.perform(request, response) == Action.OK) {
                anUri = anAct.getUri(request);
            } else {
                anUri = anAct.getErrorUri(request);
            }
        } else {
            throw new ActionNotFoundException(inActNum);
        }
        return anUri;
    }

    //----------------------------------------------------------------
    // Default Action  Dispatch
    //----------------------------------------------------------------
    public String dispatchDefault(HttpServletRequest  request,
                                  HttpServletResponse response)
    {
        Action anAct = mDefaultAction;
        String anUri = anAct.getErrorUri(request);
        if (anAct != null) {
            try {
                if (anAct.perform(request, response) == Action.OK) {
                    anUri = anAct.getUri(request);
                }
            } catch (Exception e) {
                anUri = anAct.getErrorUri(request);
            }
        }
        return anUri;
    }
    
    //----------------------------------------------------------------
    // wNumberœo^Ă Action
    //----------------------------------------------------------------
    public Action search(int inActNum)
    {
        Action aSearchAct = null;
        Iterator i = mActions.iterator();
        while (i.hasNext()) {
            Action anAct = (Action)i.next();
            if (anAct.getActionNumber() == inActNum) {
                aSearchAct = anAct;
                break;
            }
        }
        return aSearchAct;
    }
}