//====================================================================
// KiWeb
//--------------------------------------------------------------------
// t@C : ActionOrientedServlet.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: ActionOrientedServlet.java,v 1.1.1.1 2004/03/03 15:24:00 k-imoto Exp $
//====================================================================
package KiWeb.Servlet;

import java.io.*;
import java.text.*;
import java.util.*;
import java.lang.*;
import javax.servlet.*;
import javax.servlet.http.*;

//--------------------------------------------------------------------
// ACTION ORIENTED SERVLET
//--------------------------------------------------------------------
public class ActionOrientedServlet extends HttpServlet 
{
    ActionDispatcher mActionDispatcher;
    
    //----------------------------------------------------------------
    // Servlet
    //----------------------------------------------------------------
    public void init()
    {
        mActionDispatcher = new ActionDispatcher();
    }
    
    //----------------------------------------------------------------
    // POST\bh -> GETƓ
    //----------------------------------------------------------------
    public void doPost(HttpServletRequest request,
                       HttpServletResponse response)
        throws IOException, ServletException
    {
        doGet(request, response);
    }
    
    //----------------------------------------------------------------
    // GET\bh
    //----------------------------------------------------------------
    public void doGet(HttpServletRequest  request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {
        String aFuncStr = request.getParameter("function");
        String anUri;
        try {
            int aFunc = Integer.parseInt(aFuncStr);
            anUri = mActionDispatcher.dispatch(aFunc, 
                                               request, response);
        } catch (Exception e) {
            anUri = mActionDispatcher.dispatchDefault(
                                               request, response);
        }
        if (anUri != null) {
            ServletContext sc = getServletConfig().getServletContext();
            sc.getRequestDispatcher(anUri).forward(request, response);
        }
    }

    //----------------------------------------------------------------
    // Actionǉ
    //----------------------------------------------------------------
    public void addAction(int inActNum, Action inAction)
    {
        mActionDispatcher.add(inActNum, inAction);
    }

    //----------------------------------------------------------------
    // DefaultActionǉ
    //----------------------------------------------------------------
    public void addDefaultAction(Action inAction)
    {
         mActionDispatcher.addDefault(inAction);
    }

    //----------------------------------------------------------------
    // Action폜
    //----------------------------------------------------------------
    public void removeAction(int inActNum)
    {
        mActionDispatcher.remove(inActNum);
    }

    //----------------------------------------------------------------
    // Action폜
    //----------------------------------------------------------------
    public void removeAction(Action inAction)
    {
        mActionDispatcher.remove(inAction);
    }
}