//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : FileDataStorage.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: FileDataStorage.java,v 1.1.1.1 2004/03/03 15:24:00 k-imoto Exp $
//====================================================================
package KiWeb.KiBbs;

import java.util.*;
import java.io.*;

//--------------------------------------------------------------------
// BBS DATA STORAGE
//--------------------------------------------------------------------
public class FileDataStorage implements DataStorage
{
    Vector mThreadOrder;
    int    mMaxThreads;
    int    mMaxFollows;
    String mRootPath;
    
    static final String THREAD_ORDER_FILE = "thread-order.bin";
    static final String DATA_FILE_SUFFIX  = ".bin";
    
    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public FileDataStorage(int    inMaxThreads, 
                           int    inMaxFollows,
                           String inRootPath)
    {
        mMaxThreads  = inMaxThreads;
        mMaxFollows  = inMaxFollows;
        mRootPath    = inRootPath;
        mThreadOrder = loadOrder();
    }
    
    //----------------------------------------------------------------
    // tH[
    //----------------------------------------------------------------
    public synchronized void write(Item   inItem)
    {
        save(inItem);
        
        Thread aThread = (Thread)read(inItem.getParent());
        if (aThread != null) {
            aThread.add(inItem); // ă[ĥŁAēxtH[ǉ
            mThreadOrder.remove(aThread.getId());
            mThreadOrder.add(0, aThread.getId());
            save(aThread);
            saveOrder(mThreadOrder);
        }
    }
    
    //----------------------------------------------------------------
    // Xbh
    //----------------------------------------------------------------
    public synchronized void write(Thread inThread)
    {
        if (getLength() >= mMaxThreads) {
            int    aLastIndex = getLength() - 1;
            String anId       = (String)mThreadOrder.get(aLastIndex);
            deleteThreadFile(inThread);
            mThreadOrder.remove(getLength() - 1);
        }
        save(inThread);
        mThreadOrder.add(0, inThread.getId());
        saveOrder(mThreadOrder);
    }
    
    //----------------------------------------------------------------
    // ACe폜
    //----------------------------------------------------------------
    public synchronized void delete(Item inItem)
    {
        if (inItem instanceof Thread) {
            Thread aThread = (Thread)inItem;
            mThreadOrder.remove(aThread.getId());
            saveOrder(mThreadOrder);
            deleteThreadFile(aThread);
        } else {
            Thread aThread = readThread(inItem.getParent());
            if (aThread != null) {
                aThread.delete(inItem);
                save(aThread);
                deleteItemFile(inItem);
            }
        }
    }
    
    //----------------------------------------------------------------
    // Xbh/tH[ǂݍ
    //----------------------------------------------------------------
    public synchronized Item read(String inId)
    {
        Item anItem = null;
        anItem = load(inId);
        return anItem;
    }

    //----------------------------------------------------------------
    // Xbhǂݍ
    //----------------------------------------------------------------
    public synchronized Thread readThread(String inId)
    {
        Thread aThread = null;
        aThread = loadThread(inId);
        return aThread;
    }
    
    //----------------------------------------------------------------
    // Xbhǂݍ
    //----------------------------------------------------------------
    public synchronized Thread readThread(int   inIndex)
    {
        Thread aThread = null;
        if (getLength() > inIndex) {
            aThread = readThread((String)mThreadOrder.get(inIndex));
        }
        return aThread;
    }
    
    //----------------------------------------------------------------
    // Xbh擾
    //----------------------------------------------------------------
    public synchronized int    getLength()
    {
        return mThreadOrder.size();
    }
    
    //----------------------------------------------------------------
    // Xbht@CɃZ[u
    //----------------------------------------------------------------
    public void save(Thread inThread)
    {
        try {
            FileOutputStream   fos = 
                new FileOutputStream(mRootPath + 
                                     "/"       + 
                                     inThread.getId() +
                                     DATA_FILE_SUFFIX);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(inThread);
            oos.flush();
            fos.close();
        } catch (Exception e) {e.printStackTrace();}
    }

    //----------------------------------------------------------------
    // tH[t@CɃZ[u
    //----------------------------------------------------------------
    public void save(Item inItem)
    {
        try {
            FileOutputStream   fos = 
                new FileOutputStream(mRootPath + 
                                     "/"       + 
                                     inItem.getId() +
                                     DATA_FILE_SUFFIX);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(inItem);
            oos.flush();
            fos.close();
        } catch (Exception e) {e.printStackTrace();}
    }
    
    //----------------------------------------------------------------
    // Xbht@C烍[h
    //----------------------------------------------------------------
    public Thread loadThread(String inId)
    {
        Thread aThread = null;
        try {
            FileInputStream   fis = 
                new FileInputStream(mRootPath + 
                                    "/"       + 
                                    inId      + 
                                    DATA_FILE_SUFFIX);
            ObjectInputStream ois = new ObjectInputStream(fis);
            aThread = (Thread)ois.readObject();
            fis.close();
        } catch (Exception e) {
            aThread = null;
        }
        return aThread;
    }

    //----------------------------------------------------------------
    // tH[t@C烍[h
    //----------------------------------------------------------------
    public Item load(String inId)
    {
        Item anItem = null;
        try {
            FileInputStream   fis = 
                new FileInputStream(mRootPath + 
                                    "/"       + 
                                    inId      + 
                                    DATA_FILE_SUFFIX);
            ObjectInputStream ois = new ObjectInputStream(fis);
            anItem = (Item)ois.readObject();
            fis.close();
        } catch (Exception e) {
            anItem = null;
        }
        return anItem;
    }
    
    //----------------------------------------------------------------
    // XbhсÃtH[
    //----------------------------------------------------------------
    public void deleteThreadFile(Thread inThread)
    {
        File f = new File(mRootPath + 
                          "/"       + 
                          inThread.getId() + 
                          DATA_FILE_SUFFIX);
        f.delete();
        
        Iterator i = inThread.iterator();
        while (i.hasNext()) {
            String anId = (String)i.next();
            f = new File(mRootPath + 
                         "/"       + 
                         anId +
                         DATA_FILE_SUFFIX);
            f.delete();
        }
    }
    
    //----------------------------------------------------------------
    // ACe
    //----------------------------------------------------------------
    public void deleteItemFile(Item inItem)
    {
        File f = new File(mRootPath + 
                          "/"       + 
                          inItem.getId() + 
                          DATA_FILE_SUFFIX);
        f.delete();
    }
 
    //----------------------------------------------------------------
    // XbhI[_[̃Z[u
    //----------------------------------------------------------------
    public void saveOrder(Vector inOrder)
    {
        try {
            FileOutputStream   fos = 
                new FileOutputStream(mRootPath + 
                                     "/"       + 
                                     THREAD_ORDER_FILE);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(inOrder);
            oos.flush();
            fos.close();
        } catch (Exception e) {e.printStackTrace();}
    }
    
    //----------------------------------------------------------------
    // XbhI[_[̃[h
    //----------------------------------------------------------------
    public Vector loadOrder()
    {
        Vector anOrder = null;
        try {
            FileInputStream   fis = 
                new FileInputStream(mRootPath + 
                                    "/"       + 
                                    THREAD_ORDER_FILE);
            ObjectInputStream ois = new ObjectInputStream(fis);
            anOrder = (Vector)ois.readObject();
            fis.close();
        } catch (Exception e) {
            anOrder = new Vector();
        }
        return anOrder;
    }
}