//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : KiBbs.java
// 쐬     : {  L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: KiBbs.java,v 1.4 2004/05/15 03:08:33 k-imoto Exp $
//====================================================================
package KiWeb.KiBbs;

import java.util.*;
import java.lang.*;
import java.io.*;
import KiWeb.Util.*;
import org.w3c.dom.*;

//--------------------------------------------------------------------
// BBS
//--------------------------------------------------------------------
public class KiBbs
{
    private static final String VERSION_STRING   = "KiBbs Ver 1.0.1";
    private static final int DEFAULT_PAGE_SIZE   = 10;
    private static final int DEFAULT_MAX_THREADS = 20;
    private static final int DEFAULT_MAX_FOLLOWS = 100;
    
    public  static final int DEFAULT_MAX_LINKS   = 10;

    DataStorage mStorage;
    int         mPageSize;
    int         mMaxThreads;
    int         mMaxFollows;
    String      mRootPath;
    String      mName;
    Vector      mLink;
    boolean     mClosed;
    boolean     mSupportAdminConsole;
    boolean     mSupportImageBbs;

    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public KiBbs()
    {
        this(VERSION_STRING,
             DEFAULT_PAGE_SIZE,
             DEFAULT_MAX_THREADS,
             DEFAULT_MAX_FOLLOWS,
             "/",
             false,
             false,
             false);
    }
    
    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public KiBbs(String  inName,
                 int     inPageSize, 
                 int     inMaxThreads, 
                 int     inMaxFollows,
                 String  inRootPath,
                 boolean inClosed,
                 boolean inSupportConsole,
                 boolean inSupportImgBbs)
    {
        if (inName == null)    inName = VERSION_STRING;
        if (inPageSize == 0)   inPageSize = DEFAULT_PAGE_SIZE;
        if (inMaxThreads == 0) inMaxThreads = DEFAULT_MAX_THREADS;
        if (inMaxFollows == 0) inMaxFollows = DEFAULT_MAX_FOLLOWS;
        
        mName       = inName;
        mPageSize   = inPageSize;
        mMaxThreads = inMaxThreads;
        mMaxFollows = inMaxFollows;
        mRootPath   = inRootPath;
        mLink       = new Vector(DEFAULT_MAX_LINKS);
        mStorage    = new FileDataStorage(mMaxThreads, 
                                          mMaxFollows, 
                                          mRootPath);
        mClosed     = inClosed;
        mSupportAdminConsole = inSupportConsole;
        mSupportImageBbs     = inSupportImgBbs;
    }
    
    //----------------------------------------------------------------
    // VKXbh쐬
    //----------------------------------------------------------------
    public Thread newThread(String inName,
                            String inMail,
                            String inSubject,
                            String inComment,
                            String inKey)
    {
        Thread aThread = null;
        aThread = new Thread(inName, 
                             inMail,
                             inSubject, 
                             inComment, 
                             inKey);
        mStorage.write(aThread);
        return aThread;
    }
    
    //----------------------------------------------------------------
    // VKtH[쐬
    //----------------------------------------------------------------
    public Item newItem(String inThreadId,
                        String inName,
                        String inMail,
                        String inSubject,
                        String inComment,
                        String inKey)
    {
        Item anItem = null;
        Item aSearchItem = search(inThreadId);
        if ((aSearchItem != null) && (aSearchItem instanceof Thread)) {
            Thread aThread = (Thread)aSearchItem;
            
            if (aThread.getLength() < mMaxFollows) {
                anItem = new Item(inName, 
                                  inMail, 
                                  inSubject, 
                                  inComment, 
                                  inKey);
                aThread.add(anItem);
                mStorage.write(anItem);
            }
        }
        return anItem;
    }
    
    //----------------------------------------------------------------
    // Xbh/tH[
    //----------------------------------------------------------------
    public Item search(String inId)
    {
        return mStorage.read(inId);
    }
    
    //----------------------------------------------------------------
    // Xbh
    //----------------------------------------------------------------
    public Thread searchThread(String inId)
    {
        return mStorage.readThread(inId);
    }
    

    //----------------------------------------------------------------
    // 폜
    //----------------------------------------------------------------
    public void delete(String inId, String inKey)
    {
        Item item = mStorage.read(inId);
        if (item != null) {
            if (item.getKey().equals(inKey)) {
                mStorage.delete(item);
            }
        }
    }

    //----------------------------------------------------------------
    // 폜
    //----------------------------------------------------------------
    public void deleteForce(String inId)
    {
        Item item = mStorage.read(inId);
        if (item != null) {
            mStorage.delete(item);
        }
    }

    //----------------------------------------------------------------
    // Sč폜
    //----------------------------------------------------------------
    public void clear()
    {
        int i = 0;
        Thread aThread = null;
        while ((aThread = mStorage.readThread(i)) != null) {
            mStorage.delete(aThread);
        }
    }
    
    //----------------------------------------------------------------
    // wy[WɑXbh擾
    //----------------------------------------------------------------
    public Vector getPage(int inPage)
    {
        Vector aVec = new Vector();
        for (int i = 0; i < mPageSize; i++) {
            Thread aThread = 
                mStorage.readThread(inPage * mPageSize + i);
            if (aThread != null) {
                aVec.add(aThread);
            } else {
                break; // XbhΏI
            }
        }
        return aVec;
    }
    
    //----------------------------------------------------------------
    // y[W擾
    //----------------------------------------------------------------
    public int getNumOfPages()
    {
        return (mStorage.getLength() + mPageSize - 1) / mPageSize;
    }

    //----------------------------------------------------------------
    // őtH[擾
    //----------------------------------------------------------------
    public int getMaxFollows()
    {
        return mMaxFollows;
    }

    //----------------------------------------------------------------
    // BBS擾
    //----------------------------------------------------------------
    public String getName()
    {
        return mName;
    }
    
    //----------------------------------------------------------------
    // Linkݒ
    //----------------------------------------------------------------
    public void setLink(String inName, String inUrl)
    {
        mLink.add(new WebLink(inName, inUrl));
    }
    
    //----------------------------------------------------------------
    // Get link names.
    //----------------------------------------------------------------
    public String getLinkName(int inNum)
    {
        String aStr = null;
        if (mLink.size() > inNum) {
            aStr = ((WebLink)mLink.get(inNum)).getName();
        }
        return aStr;
    }

    //----------------------------------------------------------------
    // Get link URIs.
    //----------------------------------------------------------------
    public String getLinkUrl(int inNum)
    {
        String aStr = null;
        if (mLink.size() > inNum) {
            aStr = ((WebLink)mLink.get(inNum)).getUrl();
        }
        return aStr;
    }
    
    //----------------------------------------------------------------
    // Is this BBS closed?
    //----------------------------------------------------------------
    public boolean isClosedBbs()
    {
        return mClosed;
    }
    
    //----------------------------------------------------------------
    // Is this BBS supported administrator console?
    //----------------------------------------------------------------
    public boolean isSupportedAdminConsole()
    {
        return mSupportAdminConsole;
    }
    
    //----------------------------------------------------------------
    // Is this BBS supported image upload?
    //----------------------------------------------------------------
    public boolean isSupportedImageBbs()
    {
        return mSupportImageBbs;
    }
    
    //----------------------------------------------------------------
    // Translate to string.
    //----------------------------------------------------------------
    public String toString()
    {
        return VERSION_STRING;
    }
}