//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : KiBbsServlet.java
// 쐬     : {  L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: KiBbsServlet.java,v 1.4 2004/05/15 03:09:34 k-imoto Exp $
//====================================================================
package KiWeb.KiBbs;

import java.io.*;
import java.text.*;
import java.util.*;
import java.lang.*;
import javax.servlet.*;
import javax.servlet.http.*;
import KiWeb.Util.*;
import KiWeb.Servlet.*;

//--------------------------------------------------------------------
// BBS SERVLET
//--------------------------------------------------------------------
public class KiBbsServlet extends ActionOrientedServlet 
{
    private KiBbs            mBbs;
    private ThemeSelector    mThemeSelector;

    //----------------------------------------------------------------
    // @\ID
    //----------------------------------------------------------------
    public static final int FUNC_ID_NEW_THREAD =  1; // ǉ
    public static final int FUNC_ID_DELETE     =  2; // 폜
    public static final int FUNC_ID_NEW_FOLLOW =  3; // tH[ǉ
    public static final int FUNC_ID_REF_PAGE   =  4; // Q(1y[W)
    public static final int FUNC_ID_FOLLOWING  =  5; // tH[
    
    // ́AoCp
    public static final int FUNC_ID_CREATING   = 10; // VK
    public static final int FUNC_ID_REF_THREAD = 11; // XbhQ
    public static final int FUNC_ID_REF_FOLLOW = 12; // tH[Q
    
    // ́AǗҗp
    public static final int FUNC_ID_DUMP       = 20; // DUMP
    public static final int FUNC_ID_RESTORE    = 21; // RESTORE
    

    //----------------------------------------------------------------
    // Servlet
    //----------------------------------------------------------------
    public void init()
    {
        super.init();
        
        int aPageSize   = 0;
        int aMaxThreads = 0;
        int aMaxFollows = 0;
        String aBbsName = null;
        
        // PageSize擾
        String aPrmStr = getInitParameter("pagesize");
        if (aPrmStr != null) {
            try {
                aPageSize = Integer.parseInt(aPrmStr);
            } catch (NumberFormatException e) {
                aPageSize = 0;
            }
        }

        // MaxThreads擾
        aPrmStr = getInitParameter("maxthreads");
        if (aPrmStr != null) {
            try {
                aMaxThreads = Integer.parseInt(aPrmStr);
            } catch (NumberFormatException e) {
                aMaxThreads = 0;
            }
        }

        // MaxFollows擾
        aPrmStr = getInitParameter("maxfollows");
        if (aPrmStr != null) {
            try {
                aMaxFollows = Integer.parseInt(aPrmStr);
            } catch (NumberFormatException e) {
                aMaxFollows = 0;
            }
        }
        
        // BBS NAME 擾
        aPrmStr = getInitParameter("bbsname");
        aBbsName = aPrmStr;

        // BBS̃I[v擾
        boolean isClosedBbs = false;
        aPrmStr = getInitParameter("closed");
        if (aPrmStr != null) {
            try {
                isClosedBbs = (new Boolean(aPrmStr)).booleanValue();
            } catch (NumberFormatException e) {
                isClosedBbs = false;
            }
        }

        // Admin Console ̃T|[gvۂ 擾
        boolean isSupportedConsole = false;
        aPrmStr = getInitParameter("supportconsole");
        if (aPrmStr != null) {
            try {
                isSupportedConsole = 
                    (new Boolean(aPrmStr)).booleanValue();
            } catch (NumberFormatException e) {
                isSupportedConsole = false;
            }
        }

        // Image BBS ̃T|[gvۂ 擾
        boolean isSupportedImgBbs = false;
        aPrmStr = getInitParameter("supportimgbbs");
        if (aPrmStr != null) {
            try {
                isSupportedImgBbs = 
                    (new Boolean(aPrmStr)).booleanValue();
            } catch (NumberFormatException e) {
                isSupportedImgBbs = false;
            }
        }

        ServletContext sc =
            getServletConfig().getServletContext();
        String aRootPath = sc.getRealPath("/WEB-INF");
        mBbs = new KiBbs(aBbsName,
                         aPageSize, 
                         aMaxThreads, 
                         aMaxFollows, 
                         aRootPath,
                         isClosedBbs,
                         isSupportedConsole,
                         isSupportedImgBbs);
                         
        //------------------------------------------------------------
        // LINK擾 & ݒ
        //------------------------------------------------------------
        for (int i = 0; i < mBbs.DEFAULT_MAX_LINKS; i++) {
            String aName;
            String aUrl;
            aName = getInitParameter("link-name" + i);
            aUrl  = getInitParameter("link-url" + i);
            if ((aName != null) && (aUrl != null)) {
                mBbs.setLink(aName, aUrl);
            } else {
                break;
            }
        }
        
        initThemes();
        initActions();
    }

    //----------------------------------------------------------------
    // Theme
    //----------------------------------------------------------------
    private void initThemes()
    {
        String aThemeName = getInitParameter("theme");
        if (aThemeName == null) {
            aThemeName = "blue";
        }
    
        mThemeSelector = new ThemeSelector("themes");

        // "blue" theme
        Theme aTheme = new Theme("blue");
        mThemeSelector.add(aTheme);
        aTheme.setParam("base_css", "kibbs.css");
        aTheme.setParam("logo_img", "kibbslogo.gif");

        // "monochrome" theme
        aTheme = new Theme("monochrome");
        mThemeSelector.add(aTheme);
        aTheme.setParam("base_css", "kibbs.css");
        aTheme.setParam("logo_img", "kibbslogo.jpg");
        
        // set current theme to "blue"
        mThemeSelector.setCurrentTheme(aThemeName);
    }

    //----------------------------------------------------------------
    // Action
    //----------------------------------------------------------------
    private void initActions()
    {
        Action anAct;
        anAct = new RefPageAction(mBbs, mThemeSelector);
        addAction(FUNC_ID_REF_PAGE, anAct);
        addDefaultAction(anAct);
        
        anAct = new NewThreadAction(mBbs, mThemeSelector);
        addAction(FUNC_ID_NEW_THREAD, anAct);
        
        anAct = new DeleteAction(mBbs, mThemeSelector);
        addAction(FUNC_ID_DELETE, anAct);

        anAct = new NewFollowAction(mBbs, mThemeSelector);
        addAction(FUNC_ID_NEW_FOLLOW, anAct);
        
        anAct = new FollowingAction(mBbs, mThemeSelector);
        addAction(FUNC_ID_FOLLOWING, anAct);
        
        anAct = new CreatingAction(mBbs, mThemeSelector);
        addAction(FUNC_ID_CREATING, anAct);
        
        anAct = new RefThreadAction(mBbs, mThemeSelector);
        addAction(FUNC_ID_REF_THREAD, anAct);

        anAct = new RefFollowAction(mBbs, mThemeSelector);
        addAction(FUNC_ID_REF_FOLLOW, anAct);

        anAct = new DumpAction(mBbs, mThemeSelector);
        addAction(FUNC_ID_DUMP, anAct);
        
        anAct = new RestoreAction(mBbs, mThemeSelector);
        addAction(FUNC_ID_RESTORE, anAct);
    }
}


//====================================================================
// Definition of Actions
//====================================================================
class KiBbsAction extends Action
{
    protected ThemeSelector mThemeSelector;

    public KiBbsAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs);
        mThemeSelector = inTs;
    }
    
    protected void setAttributes(HttpServletRequest  request,
                                 HttpServletResponse response,
                                 int inPage)
    {
        request.setAttribute("bbs",  (KiBbs)mObject);
        request.setAttribute("theme", mThemeSelector.getTheme());
        request.setAttribute("page", new Integer(inPage));
        response.setContentType("text/html; charset=Shift_JIS");
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: REF_PAGE
//--------------------------------------------------------------------
class RefPageAction extends KiBbsAction
{
    public RefPageAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs, inTs);
        setUri("/kibbs.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        int aPage;
        String aPageStr = request.getParameter("page");
        try {
            aPage = Integer.parseInt(aPageStr);
        } catch (Exception e) {
            aPage = 0;
        }
        setAttributes(request, response, aPage);
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: NEW_THREAD
//--------------------------------------------------------------------
class NewThreadAction extends KiBbsAction
{
    public NewThreadAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs, inTs);
        setUri("/kibbs.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        String aName, aMail, aSubject, aComment, aKey;
        aName    = WebUtil.normalize(request.getParameter("name"));
        aMail    = WebUtil.normalize(request.getParameter("mail"));
        aSubject = WebUtil.normalize(request.getParameter("subject"));
        aComment = WebUtil.normalize(request.getParameter("comment"));
        aComment = WebUtil.linkUri(aComment);
        aKey     = request.getParameter("key");
        ((KiBbs)mObject).newThread(aName, aMail, 
                                   aSubject, aComment, aKey);
        setAttributes(request, response, 0);
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: DELETE
//--------------------------------------------------------------------
class DeleteAction extends KiBbsAction
{
    public DeleteAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs, inTs);
        setUri("/kibbs.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        ((KiBbs)mObject).delete(request.getParameter("id"), 
                                request.getParameter("key"));
        setAttributes(request, response, 0);
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: NEW_FOLLOW
//--------------------------------------------------------------------
class NewFollowAction extends KiBbsAction
{
    public NewFollowAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs, inTs);
        setUri("/kibbs.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        String aName, aMail, aSubject, aComment, aKey;
        aName    = WebUtil.normalize(request.getParameter("name"));
        aSubject = WebUtil.normalize(request.getParameter("subject"));
        aMail    = WebUtil.normalize(request.getParameter("mail"));
        aComment = WebUtil.normalize(request.getParameter("comment"));
        aComment = WebUtil.linkUri(aComment);
        aKey     = request.getParameter("key");
        ((KiBbs)mObject).newItem(request.getParameter("threadid"), 
                                 aName, aMail, 
                                 aSubject, aComment, aKey);
        setAttributes(request, response, 0);
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: FOLLOWING
//--------------------------------------------------------------------
class FollowingAction extends KiBbsAction
{
    public FollowingAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs, inTs);
        setUri("/kibbsf.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        int aSts  = Action.OK;
        String anId = request.getParameter("id");
        Thread aThread = ((KiBbs)mObject).searchThread(anId);
        if (aThread == null) {
            aSts = Action.ERROR;
        }
        request.setAttribute("thread", aThread);
        setAttributes(request, response, 0);
        return aSts;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: CREATING
//--------------------------------------------------------------------
class CreatingAction extends KiBbsAction
{
    public CreatingAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs, inTs);
        setUri("/kibbsn-m.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        setAttributes(request, response, 0);
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: REF_THREAD
//--------------------------------------------------------------------
class RefThreadAction extends KiBbsAction
{
    public RefThreadAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs, inTs);
        setUri("/kibbst-m.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        int aSts = Action.OK;
        String aTid = request.getParameter("id");
        Thread aTh = ((KiBbs)mObject).searchThread(aTid);
        if (aTh == null) {
            aSts = Action.ERROR;
        }
        request.setAttribute("thread", aTh);
        setAttributes(request, response, 0);
        return aSts;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: REF_FOLLOW
//--------------------------------------------------------------------
class RefFollowAction extends KiBbsAction
{
    public RefFollowAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs, inTs);
        setUri("/kibbsi-m.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        int aSts = Action.OK;
        String anIid = request.getParameter("id");
        Item anItem  = ((KiBbs)mObject).search(anIid);
        if (anItem == null) {
            aSts = Action.ERROR;
        }
        request.setAttribute("item", anItem);
        setAttributes(request, response, 0);
        return aSts;
    }
}


//--------------------------------------------------------------------
// BBS ACTION :: DUMP
//--------------------------------------------------------------------
class DumpAction extends KiBbsAction
{
    public DumpAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs, inTs);
        String anUri = "/KiBbsAdminConsoleServlet?function=" +
                       KiBbsServlet.FUNC_ID_DUMP;
        setUri(anUri, "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        setAttributes(request, response, 0);
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: RESTORE
//--------------------------------------------------------------------
class RestoreAction extends KiBbsAction
{
    public RestoreAction(KiBbs inBbs, ThemeSelector inTs)
    {
        super(inBbs, inTs);
        String anUri = "/KiBbsAdminConsoleServlet?function=" +
                       KiBbsServlet.FUNC_ID_RESTORE;
        setUri(anUri, "/kibbs.jsp");
    }

    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        setAttributes(request, response, 0);
        return Action.OK;
    }
}

