//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : MemoryDataStorage.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: MemoryDataStorage.java,v 1.1.1.1 2004/03/03 15:24:02 k-imoto Exp $
//====================================================================
package KiWeb.KiBbs;

import java.util.*;

//--------------------------------------------------------------------
// BBS DATA STORAGE
//--------------------------------------------------------------------
public class MemoryDataStorage implements DataStorage
{
    Vector mThreadOrder;
    Vector mThreads;
    Vector mItems;
    int    mMaxThreads;
    int    mMaxFollows;
    
    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public MemoryDataStorage(int inMaxThreads, int inMaxFollows)
    {
        mThreads    = new Vector();
        mItems      = new Vector();
        mMaxThreads = inMaxThreads;
        mMaxFollows = inMaxFollows;
        mThreadOrder = new Vector();
    }
    
    //----------------------------------------------------------------
    // tH[
    //----------------------------------------------------------------
    public synchronized void write(Item   inItem)
    {
        mItems.add(inItem);
        
        Thread aThread = (Thread)read(inItem.getParent());
        if (aThread != null) {
            mThreadOrder.remove(aThread.getId());
            mThreadOrder.add(0, aThread.getId());
        }
    }
    
    //----------------------------------------------------------------
    // Xbh
    //----------------------------------------------------------------
    public synchronized void write(Thread inThread)
    {
        if (getLength() >= mMaxThreads) {
            int    aLastIndex = getLength() - 1;
            String anId       = (String)mThreadOrder.get(aLastIndex);
            mThreads.remove(anId);
            mThreadOrder.remove(getLength() - 1);
        }
        mThreads.add(inThread);
        mThreadOrder.add(0, inThread.getId());
    }
    
    //----------------------------------------------------------------
    // ACe폜
    //----------------------------------------------------------------
    public synchronized void delete(Item inItem)
    {
        if (inItem instanceof Thread) {
            Thread aThread = (Thread)inItem;
            mThreadOrder.remove(aThread.getId());
            mThreads.remove(aThread);

            Iterator i = aThread.iterator();
            while (i.hasNext()) {
                mItems.remove((Item)i.next());
            }
        } else {
            Thread aThread = readThread(inItem.getParent());
            if (aThread != null) {
                aThread.delete(inItem);
                mItems.remove(inItem);
            }
        }
    }
    
    //----------------------------------------------------------------
    // Xbh/tH[ǂݍ
    //----------------------------------------------------------------
    public synchronized Item read(String inId)
    {
        Item anItem = null;
        Iterator i = mThreads.iterator();
        while (i.hasNext()) {
            Item aCurItem = (Item)i.next();
            if (aCurItem.getId().equals(inId)) {
                anItem = aCurItem;
            }
        }
        
        if (anItem == null) {
            i = mItems.iterator();
            while (i.hasNext()) {
                Item aCurItem = (Item)i.next();
                if (aCurItem.getId().equals(inId)) {
                    anItem = aCurItem;
                }
            }
        }
        return anItem;
    }

    //----------------------------------------------------------------
    // Xbhǂݍ
    //----------------------------------------------------------------
    public synchronized Thread readThread(String inId)
    {
        Thread aThread = null;
        Iterator i = mThreads.iterator();
        while (i.hasNext()) {
            Thread aCurThread = (Thread)i.next();
            if (aCurThread.getId().equals(inId)) {
                aThread = aCurThread;
            }
        }
        return aThread;
    }
    
    //----------------------------------------------------------------
    // Xbhǂݍ
    //----------------------------------------------------------------
    public synchronized Thread readThread(int   inIndex)
    {
        Thread aThread = null;
        if (mThreads.size() > inIndex) {
            aThread = readThread((String)mThreadOrder.get(inIndex));
        }
        return aThread;
    }
    
    //----------------------------------------------------------------
    // Xbh擾
    //----------------------------------------------------------------
    public synchronized int    getLength()
    {
        return mThreads.size();
    }
}