//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : ThemeSelector.java
// 쐬     : {  L
// COPYRIGHT  : Copyright (c) K.Imoto 2004. All rights reserved.
//--------------------------------------------------------------------
// $Id: ThemeSelector.java,v 1.1 2004/05/04 22:24:49 k-imoto Exp $
//====================================================================
package KiWeb.Util;

import java.util.*;
import java.lang.*;

//--------------------------------------------------------------------
// WEB APPLICATION UTILITIES
//--------------------------------------------------------------------
public class ThemeSelector
{
    private String mBaseLoc;
    private Vector mThemes;
    private String mCurrent;
    
    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public ThemeSelector(String inBaseLoc)
    {
        mBaseLoc = inBaseLoc;
        mThemes  = new Vector();
        mCurrent = null;
    }

    //----------------------------------------------------------------
    // Themeǉ
    //----------------------------------------------------------------
    public void add(String inName, String[] inParam, String[] inValue)
    {
        Theme aTheme = new Theme(inName, mBaseLoc);
        for (int i = 0; i < inParam.length; i++) {
            aTheme.setParam(inParam[i], inValue[i]);
        }
        mThemes.add(aTheme);
    }

    //----------------------------------------------------------------
    // Themeǉ
    //----------------------------------------------------------------
    public void add(Theme inTheme)
    {
        if (inTheme != null) {
            inTheme.setBaseLoc(mBaseLoc);
            mThemes.add(inTheme);
            
            // Current Themew肳ĂȂ́Aŏɒǉꂽ
            // Theme CurrentƂȂB
            if (mCurrent == null) {
                mCurrent = inTheme.getName();
            }
        }
    }

    //----------------------------------------------------------------
    // Current Themeݒ
    //----------------------------------------------------------------
    public void setCurrentTheme(String inName)
    {
        if (getTheme(inName) != null) {
            mCurrent = inName;
        }
    }
    
    //----------------------------------------------------------------
    // Current Theme擾
    //----------------------------------------------------------------
    public Theme getTheme()
    {
        Theme aTheme = null;
        if (mCurrent != null) {
            aTheme = getTheme(mCurrent);
        }
        return aTheme;
    }
    
    //----------------------------------------------------------------
    // Theme擾
    //----------------------------------------------------------------
    public Theme getTheme(String inName)
    {
        Theme aTheme = null;
        Iterator i = mThemes.iterator();
        while (i.hasNext()) {
            Theme aCur = (Theme)i.next();
            if (inName.equals(aCur.getName())) {
                aTheme = aCur;
                break;
            }
        }
        return aTheme;
    }
}
