//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : XmlSerializer.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: XmlSerializer.java,v 1.1.1.1 2004/03/03 15:24:03 k-imoto Exp $
//====================================================================
package KiWeb.KiBbs;

import java.util.*;
import java.lang.*;
import java.io.*;
import KiWeb.Util.*;
import org.w3c.dom.*;

//--------------------------------------------------------------------
// SERIALIZE TO XML DOCUMENT
//--------------------------------------------------------------------
public class XmlSerializer
{
    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public XmlSerializer(){}
    
    //----------------------------------------------------------------
    // Follow  Serialize
    //----------------------------------------------------------------
    public void serializeFollow(XmlUtil  inXmlUtil,
                                Document inDoc, 
                                Element  inParent,
                                Item     inFollow)
    {
        Element aFollow =
            inXmlUtil.appendChild(inDoc, inParent, "follow");
        inXmlUtil.appendChild(inDoc, aFollow, 
                              "subject", inFollow.getSubject());
        inXmlUtil.appendChild(inDoc, aFollow, 
                              "name",    inFollow.getName());
        inXmlUtil.appendChild(inDoc, aFollow, 
                              "mail",    inFollow.getMail());
        inXmlUtil.appendChild(inDoc, aFollow, 
                              "date",    inFollow.getDate().toString());
        inXmlUtil.appendChild(inDoc, aFollow, 
                              "comment", inFollow.getComment());
        inXmlUtil.appendChild(inDoc, aFollow, 
                              "key",     inFollow.getKey());
    }
    
    //----------------------------------------------------------------
    // Thread  Serialize
    //----------------------------------------------------------------
    public void serializeThread(XmlUtil  aXmlUtil,
                                KiBbs    inBbs,
                                Document inDoc, 
                                Element  inRoot,
                                Thread   inThread)
    {
        Element aParent = 
            aXmlUtil.appendChild(inDoc, inRoot, "thread");
        aXmlUtil.appendChild(inDoc, aParent, 
                             "subject", inThread.getSubject());
        aXmlUtil.appendChild(inDoc, aParent, 
                             "name",    inThread.getName());
        aXmlUtil.appendChild(inDoc, aParent, 
                             "mail",    inThread.getMail());
        aXmlUtil.appendChild(inDoc, aParent, 
                             "date",    inThread.getDate().toString());
        aXmlUtil.appendChild(inDoc, aParent, 
                             "comment", inThread.getComment());
        aXmlUtil.appendChild(inDoc, aParent, 
                             "key",     inThread.getKey());

        Iterator Follows = inThread.iterator();
        while (Follows.hasNext()) {
            Item aFollow = inBbs.search((String)Follows.next());
            if (aFollow != null) {
                serializeFollow(aXmlUtil, inDoc, aParent, aFollow);
            }
        }
    }
    
    //----------------------------------------------------------------
    // translate to XML document
    //----------------------------------------------------------------
    public void serialize(OutputStream inOut, KiBbs inBbs)
    {
        try {
            XmlUtil  aXmlUtil = new XmlUtil();
            Document aDoc = aXmlUtil.load("");
            if (aDoc.getDocumentElement() == null) {
                Element aRoot = aXmlUtil.appendChild(aDoc, "kibbs");
                
                for (int p = 0; p < inBbs.getNumOfPages(); p++) {
                    Vector aVec = inBbs.getPage(p);
                    Iterator i  = aVec.iterator();
                    while (i.hasNext()) {
                        Thread aThread = (Thread)i.next();
                        serializeThread(aXmlUtil, 
                                        inBbs, 
                                        aDoc, 
                                        aRoot, 
                                        aThread);
                    }
                }
            }
            aXmlUtil.save(aDoc, inOut);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    //----------------------------------------------------------------
    // translate from XML document
    //----------------------------------------------------------------
    public void unserialize(File inFile, KiBbs inBbs)
    {
        try {
            XmlUtil aXmlUtil = new XmlUtil();
            Document aDoc = aXmlUtil.load(inFile);
            Element aRoot = aDoc.getDocumentElement();
            Vector aVec = aXmlUtil.getElements(aRoot, "thread");

            //--------------------------------------------------------
            // search tail of the Thread list
            //--------------------------------------------------------
            ListIterator i = aVec.listIterator(aVec.size());
            while (i.hasNext()) {
                i.next();
            }

            //--------------------------------------------------------
            // unserialize all thread
            //--------------------------------------------------------
            while (i.hasPrevious()) {
                Element elem = (Element)i.previous();
                unserializeThread(aXmlUtil, inBbs, elem);
            }
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //----------------------------------------------------------------
    // Thread  Unserialize
    //----------------------------------------------------------------
    public void unserializeThread(XmlUtil  aXmlUtil,
                                  KiBbs    inBbs,
                                  Element  inRoot)
    {
        Thread aThread;
        String aSubject = "";
        String aName    = "";
        String aMail    = "";
        String aComment = "";
        String aKey     = "";
        
        Vector vec = aXmlUtil.getElements(inRoot, "subject");
        Iterator i = vec.iterator();
        if (i.hasNext()) {
            Element elem = (Element)i.next();
            aSubject = aXmlUtil.getElementValue(elem);
        }
        
        vec = aXmlUtil.getElements(inRoot, "name");
        i = vec.iterator();
        if (i.hasNext()) {
            Element elem = (Element)i.next();
            aName = aXmlUtil.getElementValue(elem);
        }

        vec = aXmlUtil.getElements(inRoot, "mail");
        i = vec.iterator();
        if (i.hasNext()) {
            Element elem = (Element)i.next();
            aMail = aXmlUtil.getElementValue(elem);
        }

        vec = aXmlUtil.getElements(inRoot, "comment");
        i = vec.iterator();
        if (i.hasNext()) {
            Element elem = (Element)i.next();
            aComment = aXmlUtil.getElementValue(elem);
        }
        
        vec = aXmlUtil.getElements(inRoot, "key");
        i = vec.iterator();
        if (i.hasNext()) {
            Element elem = (Element)i.next();
            aKey = aXmlUtil.getElementValue(elem);
        }
        
        aThread = 
            inBbs.newThread(aName, aMail, aSubject, aComment, aKey);

        vec = aXmlUtil.getElements(inRoot, "follow");
        ListIterator li = vec.listIterator(vec.size());
        while (li.hasNext()) {
            li.next();
        }
        while (li.hasPrevious()) {
            Element elem = (Element)li.previous();
            unserializeFollow(aXmlUtil, inBbs, aThread, elem);
        }
    }
    

    //----------------------------------------------------------------
    // Follow  Unserialize
    //----------------------------------------------------------------
    public void unserializeFollow(XmlUtil  inXmlUtil,
                                  KiBbs    inBbs,
                                  Thread   inThread,
                                  Element  inRoot)
    {
        String aSubject = "";
        String aName    = "";
        String aMail    = "";
        String aComment = "";
        String aKey     = "";
        
        Vector vec = inXmlUtil.getElements(inRoot, "subject");
        Iterator i = vec.iterator();
        if (i.hasNext()) {
            Element elem = (Element)i.next();
            aSubject = inXmlUtil.getElementValue(elem);
        }
        
        vec = inXmlUtil.getElements(inRoot, "name");
        i = vec.iterator();
        if (i.hasNext()) {
            Element elem = (Element)i.next();
            aName = inXmlUtil.getElementValue(elem);
        }

        vec = inXmlUtil.getElements(inRoot, "mail");
        i = vec.iterator();
        if (i.hasNext()) {
            Element elem = (Element)i.next();
            aMail = inXmlUtil.getElementValue(elem);
        }

        vec = inXmlUtil.getElements(inRoot, "comment");
        i = vec.iterator();
        if (i.hasNext()) {
            Element elem = (Element)i.next();
            aComment = inXmlUtil.getElementValue(elem);
        }
        
        vec = inXmlUtil.getElements(inRoot, "key");
        i = vec.iterator();
        if (i.hasNext()) {
            Element elem = (Element)i.next();
            aKey = inXmlUtil.getElementValue(elem);
        }
        
        inBbs.newItem(inThread.getId(), 
                      aName, 
                      aMail, 
                      aSubject,
                      aComment, 
                      aKey);
    }
}