/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.graphics;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import kinugasa.contents.graphics.SerializableImage;
import kinugasa.util.ArrayIndexModel;
import kinugasa.util.SequentialIndex;
import kinugasa.util.TimeCounter;

public class Animation
implements Iterable<SerializableImage>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -4399754764280894556L;
    private TimeCounter visibleTime;
    private ArrayIndexModel index;
    private SerializableImage[] images;

    public Animation(TimeCounter visibleTime, BufferedImage ... images) {
        this(visibleTime, (ArrayIndexModel)new SequentialIndex(), images);
    }

    public Animation(TimeCounter visibleTime, SerializableImage ... images) {
        this(visibleTime, (ArrayIndexModel)new SequentialIndex(), images);
    }

    public Animation(TimeCounter visibleTime, ArrayIndexModel index, BufferedImage ... images) {
        this.visibleTime = visibleTime;
        this.index = index;
        this.images = new SerializableImage[images.length];
        for (int i = 0; i < images.length; ++i) {
            this.images[i] = new SerializableImage(images[i]);
        }
    }

    public Animation(TimeCounter visibleTime, ArrayIndexModel index, SerializableImage ... images) {
        this.visibleTime = visibleTime;
        this.index = index;
        this.images = images;
    }

    public SerializableImage[] getImages() {
        return this.images;
    }

    public SerializableImage getImage(int index) throws ArrayIndexOutOfBoundsException {
        return this.images[index];
    }

    public void setImages(SerializableImage ... images) {
        this.images = images;
    }

    public void setImages(BufferedImage ... images) {
        this.images = new SerializableImage[images.length];
        for (int i = 0; i < images.length; ++i) {
            this.images[i] = new SerializableImage(images[i]);
        }
    }

    public void setImage(int index, BufferedImage image) throws ArrayIndexOutOfBoundsException {
        this.setImage(index, new SerializableImage(image));
    }

    public void setImage(int index, SerializableImage image) {
        this.images[index] = image;
    }

    public void setIndex(ArrayIndexModel index) {
        this.index = index;
    }

    public ArrayIndexModel getIndex() {
        return this.index;
    }

    public void setVisibleTime(TimeCounter visibleTime) {
        this.visibleTime = visibleTime;
    }

    public TimeCounter getVisibleTime() {
        return this.visibleTime;
    }

    public void update() {
        if (this.visibleTime.isReaching()) {
            this.index.index(this.images.length);
        }
    }

    public SerializableImage getCurrentImage() {
        return this.images[this.index.getIndex()];
    }

    public BufferedImage getCurrentBImage() {
        return this.images[this.index.getIndex()].get();
    }

    public int length() {
        return this.images.length;
    }

    @Override
    public Iterator<SerializableImage> iterator() {
        return Arrays.asList(this.images).iterator();
    }

    public Animation clone() {
        try {
            Animation result = (Animation)super.clone();
            result.images = (SerializableImage[])this.images.clone();
            result.index = this.index.clone();
            result.visibleTime = this.visibleTime.clone();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("clone failed");
        }
    }

    public String toString() {
        return "Animation{visibleTime=" + this.visibleTime + ", index=" + this.index + ", images=" + this.images + '}';
    }
}

