/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.graphics;

import java.awt.Color;
import kinugasa.contents.graphics.ColorTransitionModel;
import kinugasa.object.Model;
import kinugasa.object.Statable;

public class ColorChanger
extends Model
implements Statable {
    private static final long serialVersionUID = 7119780668500645887L;
    private ColorTransitionModel red;
    private ColorTransitionModel green;
    private ColorTransitionModel blue;
    private ColorTransitionModel alpha;
    private boolean ended = false;

    public ColorChanger(ColorTransitionModel red, ColorTransitionModel green, ColorTransitionModel blue) {
        this(red, green, blue, ColorTransitionModel.valueOf(255));
    }

    public ColorChanger(ColorTransitionModel red, ColorTransitionModel green, ColorTransitionModel blue, ColorTransitionModel alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public ColorTransitionModel getAlpha() {
        return this.alpha;
    }

    public ColorTransitionModel getBlue() {
        return this.blue;
    }

    public ColorTransitionModel getGreen() {
        return this.green;
    }

    public ColorTransitionModel getRed() {
        return this.red;
    }

    public void setAlpha(ColorTransitionModel alpha) {
        this.alpha = alpha;
    }

    public void setBlue(ColorTransitionModel blue) {
        this.blue = blue;
    }

    public void setGreen(ColorTransitionModel green) {
        this.green = green;
    }

    public void setRed(ColorTransitionModel red) {
        this.red = red;
    }

    @Override
    public ColorChanger clone() {
        ColorChanger result = (ColorChanger)super.clone();
        result.red = this.red.clone();
        result.green = this.green.clone();
        result.blue = this.blue.clone();
        result.alpha = this.alpha.clone();
        return result;
    }

    public void update() {
        this.red.update();
        this.green.update();
        this.blue.update();
        this.alpha.update();
        this.ended = this.red.isEnded() && this.green.isEnded() && this.blue.isEnded() && this.alpha.isEnded();
    }

    @Override
    public boolean isEnded() {
        return this.ended;
    }

    @Override
    public boolean isRunning() {
        return !this.ended;
    }

    public Color createColor() {
        return ColorTransitionModel.createColor(this.red, this.green, this.blue, this.alpha);
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.red != null ? this.red.hashCode() : 0);
        hash = 71 * hash + (this.green != null ? this.green.hashCode() : 0);
        hash = 71 * hash + (this.blue != null ? this.blue.hashCode() : 0);
        hash = 71 * hash + (this.alpha != null ? this.alpha.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorChanger other = (ColorChanger)obj;
        if (!(this.red == other.red || this.red != null && this.red.equals(other.red))) {
            return false;
        }
        if (!(this.green == other.green || this.green != null && this.green.equals(other.green))) {
            return false;
        }
        if (!(this.blue == other.blue || this.blue != null && this.blue.equals(other.blue))) {
            return false;
        }
        return this.alpha == other.alpha || this.alpha != null && this.alpha.equals(other.alpha);
    }

    public String toString() {
        return "ColorChanger{red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + '}';
    }
}

