/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.graphics;

import java.awt.Color;
import kinugasa.object.Model;
import kinugasa.object.Statable;

public abstract class ColorTransitionModel
extends Model
implements Statable {
    private static final long serialVersionUID = -5301732826729025440L;
    public static final int MIN = 0;
    public static final int MAX = 255;
    protected int value;

    public ColorTransitionModel(int value) throws IllegalArgumentException {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("illegal color value : value=[" + value + "]");
        }
        this.value = value;
    }

    public static ColorTransitionModel valueOf(int value) throws IllegalArgumentException {
        return new ColorTransitionModel(value){
            private static final long serialVersionUID = 8593451345811759766L;

            @Override
            public void update() {
            }

            @Override
            public boolean isEnded() {
                return false;
            }

            @Override
            public boolean isRunning() {
                return true;
            }
        };
    }

    @Override
    public abstract boolean isEnded();

    @Override
    public abstract boolean isRunning();

    public abstract void update();

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) throws IllegalArgumentException {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("illegal color value : value=[" + value + "]");
        }
        this.value = value;
    }

    public static Color createColor(ColorTransitionModel r, ColorTransitionModel g, ColorTransitionModel b) {
        return new Color(r.value, g.value, b.value);
    }

    public static Color createColor(ColorTransitionModel r, ColorTransitionModel g, ColorTransitionModel b, ColorTransitionModel a) {
        return new Color(r.value, g.value, b.value, a.value);
    }

    @Override
    public ColorTransitionModel clone() {
        return (ColorTransitionModel)super.clone();
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + this.value;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorTransitionModel other = (ColorTransitionModel)obj;
        return this.value == other.value;
    }

    public String toString() {
        return "ColorCounter{value=" + this.value + '}';
    }
}

