/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.graphics;

import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import kinugasa.contents.graphics.ImageEditor;
import kinugasa.contents.graphics.RenderingPolicy;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;

public final class ImageUtil {
    private static final GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private static final HashMap<String, SoftReference<BufferedImage>> IMAGE_CACHE = new HashMap(32);

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return gc;
    }

    private ImageUtil() {
    }

    public static BufferedImage newImage(int width, int height) {
        return gc.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage copy(BufferedImage src) {
        return ImageUtil.copy(src, null);
    }

    public static BufferedImage copy(BufferedImage src, BufferedImage dst) {
        if (dst == null || dst == src) {
            dst = ImageUtil.newImage(src.getWidth(), src.getHeight());
        }
        Graphics2D g2 = dst.createGraphics();
        g2.setRenderingHints(RenderingPolicy.QUALITY.getRenderingHints());
        g2.drawImage((Image)src, 0, 0, null);
        g2.dispose();
        return dst;
    }

    public static BufferedImage load(String filePath) throws ContentsFileNotFoundException, ContentsIOException {
        SoftReference<BufferedImage> cacheRef = IMAGE_CACHE.get(filePath);
        if (cacheRef != null && cacheRef.get() != null) {
            System.out.println("> ImageUtil : load : return cache : filePath=[" + filePath + "]");
            return cacheRef.get();
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new ContentsFileNotFoundException("file not found : filePath=[" + filePath + "]");
        }
        BufferedImage dst = null;
        try {
            dst = ImageIO.read(file);
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
        if (dst == null) {
            throw new ContentsIOException("image is null");
        }
        dst = ImageUtil.copy(dst, ImageUtil.newImage(dst.getWidth(), dst.getHeight()));
        IMAGE_CACHE.put(filePath, new SoftReference<BufferedImage>(dst));
        System.out.println("> ImageUtil : load : return new : filePath=[" + filePath + "]");
        return dst;
    }

    public static void save(String filePath, BufferedImage image) throws ContentsIOException {
        File file = new File(filePath);
        try {
            ImageIO.write((RenderedImage)image, "PNG", file);
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
    }

    public static int[] getPixel(BufferedImage image) {
        return image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
    }

    public static int[][] getPixel2D(BufferedImage image) {
        int[] pix = ImageUtil.getPixel(image);
        int[][] pix2 = new int[image.getHeight()][image.getWidth()];
        int i = 0;
        int row = 0;
        int WIDTH = image.getWidth();
        while (i < pix2.length) {
            System.arraycopy(pix, row, pix2[i], 0, WIDTH);
            ++i;
            row += WIDTH;
        }
        return pix2;
    }

    public static void setPixel(BufferedImage image, int[] pix) {
        image.setRGB(0, 0, image.getWidth(), image.getHeight(), pix, 0, image.getWidth());
    }

    public static void setPixel2D(BufferedImage image, int[][] pix) {
        int[] newPix = new int[ImageUtil.getPixel(image).length];
        for (int i = 0; i < pix.length; ++i) {
            System.arraycopy(pix[i], 0, newPix, i * pix[0].length, pix[i].length);
        }
        image.setRGB(0, 0, image.getWidth(), image.getHeight(), newPix, 0, image.getWidth());
    }

    public static Graphics2D createGraphics2D(BufferedImage image, RenderingPolicy renderingPolicy) {
        Graphics2D g = image.createGraphics();
        if (renderingPolicy != null) {
            g.setRenderingHints(renderingPolicy.getRenderingHints());
        }
        g.setClip(0, 0, image.getWidth(), image.getHeight());
        return g;
    }

    public static BufferedImage[] rows(BufferedImage src, int y, int w, int h) throws RasterFormatException {
        BufferedImage[] dst = new BufferedImage[src.getWidth() / w];
        int i = 0;
        int x = 0;
        while (i < dst.length) {
            dst[i] = src.getSubimage(x, y, w, h);
            ++i;
            x += w;
        }
        return dst;
    }

    public static BufferedImage[] columns(BufferedImage src, int x, int w, int h) throws RasterFormatException {
        BufferedImage[] dst = new BufferedImage[src.getHeight() / h];
        int i = 0;
        int y = 0;
        while (i < dst.length) {
            dst[i] = src.getSubimage(x, y, w, h);
            ++i;
            y += h;
        }
        return dst;
    }

    public static List<BufferedImage> splitAsList(BufferedImage src, int w, int h) throws RasterFormatException {
        int columns = src.getHeight() / h;
        ArrayList<BufferedImage> dst = new ArrayList<BufferedImage>(columns * (src.getWidth() / w));
        for (int i = 0; i < columns; ++i) {
            dst.addAll(Arrays.asList(ImageUtil.rows(src, i * h, w, h)));
        }
        return dst;
    }

    public static BufferedImage[][] splitAsArray(BufferedImage src, int w, int h) throws RasterFormatException {
        BufferedImage[][] dst = new BufferedImage[src.getHeight() / h][src.getWidth() / w];
        int i = 0;
        int y = 0;
        while (i < dst.length) {
            dst[i] = ImageUtil.rows(src, y, w, h);
            ++i;
            y += h;
        }
        return dst;
    }

    public static Map<String, BufferedImage> splitAsMap(BufferedImage src, int w, int h) throws RasterFormatException {
        HashMap<String, BufferedImage> dst = new HashMap<String, BufferedImage>(src.getWidth() / w * src.getHeight() / h);
        BufferedImage[][] dist = ImageUtil.splitAsArray(src, w, h);
        for (int i = 0; i < dist.length; ++i) {
            for (int j = 0; j < dist[i].length; ++j) {
                String y = Integer.toString(i);
                String x = Integer.toString(j);
                if (y.length() == 1) {
                    y = "0" + y;
                }
                if (x.length() == 1) {
                    x = "0" + x;
                }
                dst.put(y + x, dist[i][j]);
            }
        }
        return dst;
    }

    public static void screenShot(final String FILE_PATH, final Rectangle BOUNDS) throws ContentsIOException {
        new Thread("kgf screen shot"){

            @Override
            public void run() {
                try {
                    BufferedImage image = new Robot().createScreenCapture(BOUNDS);
                    ImageUtil.save(FILE_PATH, image);
                    System.out.println("> ImageUtil : screenShot : successs : FILE_PATH=[" + FILE_PATH + "]");
                }
                catch (AWTException ex) {
                    throw new ContentsIOException(ex);
                }
            }
        }.start();
    }

    public static BufferedImage tiling(BufferedImage src, BufferedImage dst, int xNum, int yNum) {
        if (dst == null || dst == src) {
            dst = ImageUtil.newImage(src.getWidth() * xNum, src.getHeight() * yNum);
        }
        Graphics2D g2 = dst.createGraphics();
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = 0; y < yNum; ++y) {
            for (int x = 0; x < xNum; ++x) {
                g2.drawImage((Image)src, x * width, y * height, null);
            }
        }
        g2.dispose();
        return dst;
    }

    public static BufferedImage trimming(BufferedImage src, int x, int y, int width, int height) throws RasterFormatException {
        return src.getSubimage(x, y, width, height);
    }

    public static BufferedImage[] transparentArray(BufferedImage image, float initialTp, float addTp) throws IllegalArgumentException {
        if (initialTp > 1.0f || initialTp < 0.0f) {
            throw new IllegalArgumentException("initialTp > 1 || initialTp < 0 : initialTp=[" + initialTp + "], addTp=[" + addTp + "]");
        }
        BufferedImage src = ImageUtil.copy(image);
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>((int)(Math.abs(initialTp) / Math.abs(addTp)));
        for (float tp = initialTp; tp > 0.0f; tp += addTp) {
            result.add(ImageUtil.copy(src));
            src = ImageEditor.transparent(src, tp, null);
        }
        return result.toArray(new BufferedImage[result.size()]);
    }

    public static BufferedImage lineUp(BufferedImage ... images) throws IllegalArgumentException {
        if (images.length == 0) {
            throw new IllegalArgumentException("images is empty : images.length=[" + images.length + "]");
        }
        int maxHeight = images[0].getHeight();
        int width = 0;
        for (int i = 0; i < images.length; ++i) {
            if (images[i].getHeight() > maxHeight) {
                maxHeight = images[i].getHeight();
            }
            width += images[i].getWidth();
        }
        BufferedImage result = ImageUtil.newImage(width, maxHeight);
        Graphics2D g = result.createGraphics();
        g.setRenderingHints(RenderingPolicy.QUALITY.getRenderingHints());
        int widthSum = 0;
        for (int i = 0; i < images.length; ++i) {
            g.drawImage((Image)images[i], widthSum, 0, null);
            widthSum += images[i].getWidth();
        }
        return result;
    }
}

