/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.resource;

import kinugasa.contents.resource.Freeable;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.resource.Nameable;
import kinugasa.contents.resource.Storage;
import kinugasa.util.ArrayUtil;
import kinugasa.util.annotations.CallSuper;
import kinugasa.util.annotations.CallTiming;
import kinugasa.util.annotations.CastReturnValue;
import kinugasa.util.annotations.VirtualMethod;

public abstract class DynamicStorage<T extends Nameable & Freeable>
extends Storage<T>
implements Freeable {
    public DynamicStorage(int initialSize) {
        super(initialSize);
    }

    public DynamicStorage() {
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public DynamicStorage<T> load() {
        for (Nameable obj : this) {
            ((Freeable)((Object)obj)).load();
        }
        return this;
    }

    public T load(String name) throws NameNotFoundException {
        Object obj = this.get(name);
        ((Freeable)obj).load();
        return obj;
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public DynamicStorage<T> free() {
        for (Nameable obj : this) {
            ((Freeable)((Object)obj)).free();
        }
        return this;
    }

    public T free(String name) throws NameNotFoundException {
        Object obj = this.get(name);
        ((Freeable)obj).free();
        return obj;
    }

    public void loadAll(String ... names) {
        for (Nameable obj : this) {
            if (!ArrayUtil.contains(names, obj.getName())) continue;
            ((Freeable)((Object)obj)).load();
        }
    }

    public void freeAll(String ... names) {
        for (Nameable obj : this) {
            if (!ArrayUtil.contains(names, obj.getName())) continue;
            ((Freeable)((Object)obj)).free();
        }
    }

    public void exFree(String ... names) {
        for (Nameable obj : this) {
            if (ArrayUtil.contains(names, obj.getName())) continue;
            ((Freeable)((Object)obj)).free();
        }
    }

    @Override
    public boolean isLoaded() {
        for (Nameable obj : this) {
            if (!((Freeable)((Object)obj)).isLoaded()) continue;
            return true;
        }
        return false;
    }

    public boolean isLoadedAll() {
        for (Nameable obj : this) {
            if (((Freeable)((Object)obj)).isLoaded()) continue;
            return false;
        }
        return true;
    }

    public boolean isLoaded(String name) throws NameNotFoundException {
        return ((Freeable)this.get(name)).isLoaded();
    }
}

