/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.text;

import java.io.File;
import java.util.Collection;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.IllegalFormatException;
import kinugasa.contents.text.Reader;
import kinugasa.contents.text.TextIO;
import kinugasa.contents.text.TextReader;

public final class CSVReader
extends TextReader<String[]> {
    private static final Reader<String[]> CSV_READER = new Reader<String[]>(){
        private static final long serialVersionUID = 3750536757078114045L;

        @Override
        public String[] parse(String line) throws IllegalFormatException {
            return line.startsWith("#") || "".equals(line) ? null : line.split(",");
        }
    };
    private static final long serialVersionUID = -4134842560863486462L;

    public CSVReader(File file) throws ContentsFileNotFoundException {
        super(file, CSV_READER);
    }

    public CSVReader(String filePath) throws ContentsFileNotFoundException {
        super(filePath, CSV_READER);
    }

    @Override
    public CSVReader load() throws IllegalFormatException {
        return (CSVReader)super.load();
    }

    @Override
    public CSVReader free() {
        return (CSVReader)super.free();
    }

    public CSVReader add(Collection<? extends String[]> obj) {
        return (CSVReader)super.add(obj);
    }

    public CSVReader add(String[] obj) {
        return (CSVReader)super.add((Object)obj);
    }

    public CSVReader add(String[] ... obj) {
        return (CSVReader)super.add((Object[])obj);
    }

    public CSVReader add(TextIO<? extends String[]> other) {
        return (CSVReader)super.add(other);
    }

    public CSVReader remove(Collection<? extends String[]> obj) {
        return (CSVReader)super.remove(obj);
    }

    public CSVReader remove(String[] obj) {
        return (CSVReader)super.remove((Object)obj);
    }

    public CSVReader remove(String[] ... obj) {
        return (CSVReader)super.remove((Object[])obj);
    }

    public CSVReader remove(TextIO<? extends String[]> other) {
        return (CSVReader)super.remove(other);
    }

    @Override
    public CSVReader clear() {
        return (CSVReader)super.clear();
    }
}

