/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.Freeable;
import kinugasa.contents.resource.IllegalFormatException;
import kinugasa.contents.text.Reader;
import kinugasa.contents.text.TextIO;
import kinugasa.util.annotations.CallSuper;
import kinugasa.util.annotations.CallTiming;
import kinugasa.util.annotations.CastReturnValue;
import kinugasa.util.annotations.VirtualMethod;

public abstract class TextReader<T>
extends TextIO<T>
implements Freeable {
    private static final long serialVersionUID = 8671421693215761665L;
    private Reader<T> reader;

    public TextReader(String filePath, Reader<T> parser) throws ContentsFileNotFoundException {
        super(filePath);
        if (!this.file.exists()) {
            throw new ContentsFileNotFoundException("file not found : file=[" + this.getName() + "]");
        }
        this.reader = parser;
    }

    public TextReader(File file, Reader<T> parser) throws ContentsFileNotFoundException {
        super(file);
        if (!file.exists()) {
            throw new ContentsFileNotFoundException("file not found : file=[" + this.getName() + "]");
        }
        this.reader = parser;
    }

    @Override
    public TextReader<T> load() throws IllegalFormatException, ContentsIOException {
        FileReader fr = null;
        BufferedReader br = null;
        try {
            String line;
            fr = new FileReader(this.file);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                T val = this.reader.parse(line);
                if (val == null) continue;
                this.add((Object)val);
            }
            System.out.println("> TextReader : load : [" + this.file.getName() + "] : load completed : size=[" + this.size() + "]");
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException ex) {
                throw new ContentsIOException(ex);
            }
        }
        return this;
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextReader<T> free() {
        return this.clear();
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public boolean isLoaded() {
        return !this.data.isEmpty();
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextReader<T> add(Collection<? extends T> obj) {
        return (TextReader)super.add(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextReader<T> add(T obj) {
        return (TextReader)super.add(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextReader<T> add(T ... obj) {
        return (TextReader)super.add(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextReader<T> add(TextIO<? extends T> other) {
        return (TextReader)super.add(other);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextReader<T> remove(Collection<? extends T> obj) {
        return (TextReader)super.remove(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextReader<T> remove(T obj) {
        return (TextReader)super.remove(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextReader<T> remove(T ... obj) {
        return (TextReader)super.remove(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextReader<T> remove(TextIO<? extends T> other) {
        return (TextReader)super.remove(other);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextReader<T> clear() {
        return (TextReader)super.clear();
    }

    public Reader<T> getReader() {
        return this.reader;
    }

    public void setReader(Reader<T> reader) {
        this.reader = reader;
    }
}

