/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.text;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.text.TextIO;
import kinugasa.contents.text.Writer;
import kinugasa.util.annotations.CallSuper;
import kinugasa.util.annotations.CallTiming;
import kinugasa.util.annotations.CastReturnValue;
import kinugasa.util.annotations.VirtualMethod;

public class TextWriter<T>
extends TextIO<T> {
    private static final long serialVersionUID = 6062888702166716010L;
    private Writer<T> writer;

    public TextWriter(File file, Writer<T> writer) {
        super(file);
        this.writer = writer;
    }

    public TextWriter(String filePath, Writer<T> writer) {
        super(filePath);
        this.writer = writer;
    }

    public void save() throws ContentsIOException {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(this.file);
            bw = new BufferedWriter(fw);
            for (Object obj : this) {
                String line = this.writer.toString(obj);
                bw.write(line, 0, line.length());
                bw.newLine();
            }
            System.out.println("> TextWriter : save : [" + this.file.getName() + "] : SAVE COMPLETED : size=[" + this.size() + "]");
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ex) {
                throw new ContentsIOException(ex);
            }
        }
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextWriter<T> add(Collection<? extends T> obj) {
        return (TextWriter)super.add(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextWriter<T> add(T obj) {
        return (TextWriter)super.add(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextWriter<T> add(T ... obj) {
        return (TextWriter)super.add(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextWriter<T> add(TextIO<? extends T> other) {
        return (TextWriter)super.add(other);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextWriter<T> remove(Collection<? extends T> obj) {
        return (TextWriter)super.remove(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextWriter<T> remove(T obj) {
        return (TextWriter)super.remove(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextWriter<T> remove(T ... obj) {
        return (TextWriter)super.remove(obj);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextWriter<T> remove(TextIO<? extends T> other) {
        return (TextWriter)super.remove(other);
    }

    @Override
    @VirtualMethod
    @CallSuper(value=CallTiming.ANY)
    @CastReturnValue
    public TextWriter<T> clear() {
        return (TextWriter)super.clear();
    }

    public Writer<T> getWriter() {
        return this.writer;
    }

    public void setWriter(Writer<T> writer) {
        this.writer = writer;
    }
}

