/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.field;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.DuplicateNameException;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.Nameable;
import kinugasa.contents.resource.Storage;
import kinugasa.contents.text.XMLAttribute;
import kinugasa.contents.text.XMLElement;
import kinugasa.contents.text.XMLFileSupport;
import kinugasa.contents.text.XMLReader;
import kinugasa.field.ChipAttribute;

public final class ChipAttributeStorage
extends Storage<ChipAttribute>
implements Serializable,
XMLFileSupport {
    private static final long serialVersionUID = -3407377075571254018L;
    private static final ChipAttributeStorage INSTANCE = new ChipAttributeStorage();

    private ChipAttributeStorage() {
        this.putDefaultAttribute();
    }

    @Override
    public void readFromXML(String filePath) throws IllegalXMLFormatException, ContentsFileNotFoundException, ContentsIOException, DuplicateNameException {
        XMLReader reader = new XMLReader(filePath).load();
        XMLElement root = (XMLElement)reader.getFirst();
        if (!"kinugasaChipAttribute".equals(root.getName())) {
            throw new IllegalXMLFormatException("illegal root node name : " + root);
        }
        List<XMLElement> attributeElements = root.getElement("attribute");
        int size = attributeElements.size();
        for (int i = 0; i < size; ++i) {
            this.add(new ChipAttribute(((XMLAttribute)attributeElements.get(i).getAttributes().get("name")).getValue()));
        }
        reader.free();
    }

    private void putDefaultAttribute() {
        this.put(new ChipAttribute("VOID"));
        this.put(new ChipAttribute("CLOSE"));
    }

    @Override
    public Iterator<ChipAttribute> iterator() {
        return super.iterator();
    }

    public static ChipAttributeStorage getInstance() {
        return INSTANCE;
    }

    @Override
    public void remove(ChipAttribute val) {
        super.remove(val);
        this.putDefaultAttribute();
    }

    @Override
    public void remove(String key) {
        super.remove(key);
        this.putDefaultAttribute();
    }

    public void removeAll(ChipAttribute ... values) {
        super.removeAll((Nameable[])values);
        this.putDefaultAttribute();
    }

    @Override
    public void removeAll(Collection<? extends ChipAttribute> values) {
        super.removeAll(values);
        this.putDefaultAttribute();
    }

    @Override
    public void removeAll(String ... keys) {
        super.removeAll(keys);
        this.putDefaultAttribute();
    }

    @Override
    public void clear() {
        super.clear();
        this.putDefaultAttribute();
    }
}

