/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.field;

import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.graphics.SerializableImage;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.resource.Storage;
import kinugasa.contents.text.XMLAttribute;
import kinugasa.contents.text.XMLElement;
import kinugasa.contents.text.XMLFileSupport;
import kinugasa.contents.text.XMLReader;
import kinugasa.field.ChipAttribute;
import kinugasa.field.ChipAttributeStorage;
import kinugasa.field.ChipSet;
import kinugasa.field.MapChip;

public class ChipSetStorage
extends Storage<ChipSet>
implements XMLFileSupport {
    private static final ChipSetStorage INSTANCE = new ChipSetStorage();

    private ChipSetStorage() {
    }

    public static ChipSetStorage getInstance() {
        return INSTANCE;
    }

    @Override
    public void readFromXML(String filePath) throws IllegalXMLFormatException, ContentsFileNotFoundException, ContentsIOException, NumberFormatException, NameNotFoundException {
        XMLReader reader = new XMLReader(filePath).load();
        XMLElement root = (XMLElement)reader.getFirst();
        if (!"kinugasaChipSet".equals(root.getName())) {
            throw new IllegalXMLFormatException("illegal root node name :" + root);
        }
        List<XMLElement> chipSetElementList = root.getElement("chipSet");
        int chipSetSize = chipSetElementList.size();
        for (int i = 0; i < chipSetSize; ++i) {
            XMLElement chipSetElement = chipSetElementList.get(i);
            ChipSet chipSet = new ChipSet(((XMLAttribute)chipSetElement.getAttributes().get("name")).getValue());
            Map<String, BufferedImage> imageMap = ImageUtil.splitAsMap(ImageUtil.load(((XMLAttribute)chipSetElement.getAttributes().get("image")).getValue()), ((XMLAttribute)chipSetElement.getAttributes().get("cutWidth")).getIntValue(), ((XMLAttribute)chipSetElement.getAttributes().get("cutHeight")).getIntValue());
            List<XMLElement> mapChipElementList = chipSetElement.getElement("mapChip");
            int mapChipSize = mapChipElementList.size();
            for (int j = 0; j < mapChipSize; ++j) {
                XMLElement mapChipElement = mapChipElementList.get(j);
                String mapChipName = ((XMLAttribute)mapChipElement.getAttributes().get("name")).getValue();
                ChipAttribute attribute = (ChipAttribute)ChipAttributeStorage.getInstance().get(((XMLAttribute)mapChipElement.getAttributes().get("attribute")).getValue());
                chipSet.add(new MapChip(mapChipName, new SerializableImage(imageMap.get(mapChipName)), attribute));
            }
            this.add(chipSet);
        }
        reader.free();
    }
}

