/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.field;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.resource.Storage;
import kinugasa.contents.text.XMLAttribute;
import kinugasa.contents.text.XMLElement;
import kinugasa.contents.text.XMLFileSupport;
import kinugasa.contents.text.XMLReader;
import kinugasa.field.ChipAttribute;
import kinugasa.field.ChipAttributeStorage;
import kinugasa.field.Vehicle;

public class VehicleStorage
extends Storage<Vehicle>
implements Serializable,
XMLFileSupport {
    private static final long serialVersionUID = -8199049449459770547L;
    private static final VehicleStorage INSTANCE = new VehicleStorage();
    private Vehicle currentVehicle;

    private VehicleStorage() {
    }

    public static VehicleStorage getInstance() {
        return INSTANCE;
    }

    public Vehicle getCurrentVehicle() {
        return this.currentVehicle;
    }

    public void setCurrentVehicle(Vehicle currentVehicle) {
        this.currentVehicle = currentVehicle;
    }

    @Override
    public void readFromXML(String filePath) throws IllegalXMLFormatException, ContentsFileNotFoundException, ContentsIOException, NameNotFoundException {
        XMLReader reader = new XMLReader(filePath).load();
        XMLElement root = (XMLElement)reader.getFirst();
        if (!"kinugasaVehicle".equals(root.getName())) {
            throw new IllegalXMLFormatException("illegal root node name : " + root);
        }
        List<XMLElement> vehiclesElement = root.getElement("vehicle");
        int size = vehiclesElement.size();
        for (int i = 0; i < size; ++i) {
            XMLElement vehicle = vehiclesElement.get(i);
            String name = ((XMLAttribute)vehicle.getAttributes().get("name")).getValue();
            float speed = ((XMLAttribute)vehicle.getAttributes().get("speed")).getFloatValue();
            List<XMLElement> chipAttribute = vehicle.getElement("stepOn");
            ArrayList<ChipAttribute> stepOnAttributes = new ArrayList<ChipAttribute>(chipAttribute.size());
            ChipAttributeStorage storage = ChipAttributeStorage.getInstance();
            int attributeSize = chipAttribute.size();
            for (int j = 0; j < attributeSize; ++j) {
                stepOnAttributes.add((ChipAttribute)storage.get(((XMLAttribute)chipAttribute.get(j).getAttributes().get("attribute")).getValue()));
            }
            this.add(new Vehicle(name, speed, stepOnAttributes));
        }
        reader.free();
    }
}

