/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.graphics.RenderingPolicy;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.game.WindowCloseEvent;
import kinugasa.util.annotations.Internal;

public class GameConfig {
    private String title;
    private Point location = new Point(0, 0);
    private Dimension size = new Dimension(600, 480);
    private Color backColor = new Color(68, 98, 162);
    private Image icon;
    private int fps = 60;
    private RenderingHints renderingHints = RenderingPolicy.DEFAULT.getRenderingHints();
    private boolean useMouseCursor = false;
    private boolean useGamePad = true;
    private boolean useKeyboard = true;
    private List<WindowCloseEvent> closeEvetList = new ArrayList<WindowCloseEvent>(3);

    public GameConfig() {
        this("My Game");
    }

    public GameConfig(String title) {
        this.title = title;
        this.icon = new ImageIcon(this.getClass().getResource("icon.png")).getImage();
    }

    public GameConfig setTitle(String title) {
        this.title = title;
        return this;
    }

    public GameConfig addCloseEvent(WindowCloseEvent event) {
        this.closeEvetList.add(event);
        return this;
    }

    public GameConfig setLocation(Point location) {
        this.location = location;
        return this;
    }

    public GameConfig setLocation(int x, int y) {
        this.location.x = x;
        this.location.y = y;
        return this;
    }

    public GameConfig setX(int x) {
        this.location.x = x;
        return this;
    }

    public GameConfig setY(int y) {
        this.location.y = y;
        return this;
    }

    public GameConfig setCenterOfScreen() {
        Point centerOfScreen = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.location.x = centerOfScreen.x - this.size.width / 2;
        this.location.y = centerOfScreen.y - this.size.height / 2;
        if (this.location.x < 0) {
            this.location.x = 0;
        }
        if (this.location.y < 0) {
            this.location.y = 0;
        }
        return this;
    }

    public GameConfig setSize(Dimension size) {
        this.size = size;
        return this;
    }

    public GameConfig setSize(int width, int height) {
        this.size.width = width;
        this.size.height = height;
        return this;
    }

    public GameConfig setWidth(int width) {
        this.size.width = width;
        return this;
    }

    public GameConfig setHeight(int height) {
        this.size.height = height;
        return this;
    }

    public GameConfig setBackColor(Color backColor) {
        this.backColor = backColor;
        return this;
    }

    public GameConfig setIcon(Image icon) {
        this.icon = icon;
        return this;
    }

    public GameConfig setIcon(String filePath) throws ContentsFileNotFoundException, ContentsIOException {
        if (filePath == null) {
            this.setIcon((Image)null);
        } else {
            this.setIcon(ImageUtil.load(filePath));
        }
        return this;
    }

    public GameConfig setFps(int fps) {
        this.fps = fps;
        return this;
    }

    public GameConfig setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = renderingHints;
        return this;
    }

    public GameConfig setRenderingHints(RenderingPolicy policy) {
        this.renderingHints = policy.getRenderingHints();
        return this;
    }

    public GameConfig useMouse(boolean use) {
        this.useMouseCursor = use;
        return this;
    }

    public GameConfig useGamePad(boolean use) {
        this.useGamePad = use;
        return this;
    }

    public GameConfig useKeyboard(boolean use) {
        this.useKeyboard = use;
        return this;
    }

    @Internal
    protected Color getBackColor() {
        return this.backColor;
    }

    @Internal
    protected int getFps() {
        return this.fps;
    }

    @Internal
    protected Image getIcon() {
        return this.icon;
    }

    @Internal
    protected Point getLocation() {
        return this.location;
    }

    @Internal
    protected RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Internal
    protected Dimension getSize() {
        return this.size;
    }

    @Internal
    protected String getTitle() {
        return this.title;
    }

    @Internal
    protected boolean isUseMouseCursor() {
        return this.useMouseCursor;
    }

    @Internal
    protected boolean isUseGamePad() {
        return this.useGamePad;
    }

    @Internal
    protected boolean isUseKeyboard() {
        return this.useKeyboard;
    }

    @Internal
    protected List<WindowCloseEvent> getCloseEvetList() {
        return this.closeEvetList;
    }

    public String toString() {
        return "GameConfig{title=" + this.title + ", location=" + this.location + ", size=" + this.size + ", backColor=" + this.backColor + ", icon=" + this.icon + ", fps=" + this.fps + ", useMouseCursor=" + this.useMouseCursor + ", renderingHints=" + this.renderingHints + '}';
    }
}

