/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.util.List;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.game.AWTGameWindow;
import kinugasa.game.Game;
import kinugasa.game.GameConfig;
import kinugasa.game.GameLoop;
import kinugasa.game.GameTimeManager;
import kinugasa.game.GameWindow;
import kinugasa.game.PlayerConstants;
import kinugasa.game.WindowCloseEvent;
import kinugasa.inputDevice.KGPDllLoader;
import kinugasa.inputDevice.KeyConnection;
import kinugasa.inputDevice.MouseConnection;
import kinugasa.util.Versions;
import kinugasa.util.annotations.Internal;

public abstract class KinugasaGame
extends Game {
    private AWTGameWindow window = new AWTGameWindow();
    private BufferStrategy graphicsBuffer;
    private Graphics2D graphicsContext;
    private RenderingHints renderingHints;
    private GameLoop loop;
    private GameTimeManager gameTimeManager;
    private Rectangle clippingRectangle;
    private int fps;
    private boolean started = false;

    protected KinugasaGame(GameConfig conf) {
        super(conf.getTitle());
        this.renderingHints = conf.getRenderingHints();
        this.window.getCloseEventStorage().addAll(conf.getCloseEvetList());
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                List<WindowCloseEvent> eventList = KinugasaGame.this.window.getCloseEventStorage().asSortedList();
                int size = eventList.size();
                for (int i = 0; i < size; ++i) {
                    if (eventList.get(i).close()) continue;
                    return;
                }
                KinugasaGame.this.gameExit();
            }
        });
        this.window.setTitle(conf.getTitle());
        this.window.setIconImage(conf.getIcon());
        this.window.setBackground(conf.getBackColor());
        this.window.setLocation(conf.getLocation());
        this.window.setSize(conf.getSize());
        this.window.setResizable(false);
        PlayerConstants playerConstants = PlayerConstants.getInstance();
        playerConstants.setUsingGamepad(conf.isUseGamePad());
        if (playerConstants.isUsingGamepad()) {
            KGPDllLoader.load();
        }
        playerConstants.setUsingKeyboard(conf.isUseKeyboard());
        if (playerConstants.isUsingKeyboard()) {
            KeyConnection.setListener(this.window);
        }
        playerConstants.setUsingMouse(conf.isUseMouseCursor());
        if (playerConstants.isUsingMouse()) {
            MouseConnection.setListener(this.window);
        } else {
            BufferedImage cursorImage = ImageUtil.newImage(16, 16);
            this.window.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(), "game cursor"));
        }
        this.fps = conf.getFps();
    }

    public KinugasaGame(String name) {
        this(new GameConfig(name));
    }

    @Override
    protected final void gameStart() throws IllegalStateException {
        if (this.started) {
            throw new IllegalStateException("game[" + this.name + "] is already started.");
        }
        this.gameTimeManager = new GameTimeManager(this.fps);
        this.loop = new GameLoop(this, this.gameTimeManager);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    KinugasaGame.this.startUp();
                }
                catch (Throwable ex) {
                    System.out.println("ERROR : " + ex);
                    ex.printStackTrace();
                    System.exit(1);
                }
                KinugasaGame.this.window.setVisible(true);
                KinugasaGame.this.window.createBufferStrategy(2);
                KinugasaGame.this.graphicsBuffer = KinugasaGame.this.window.getBufferStrategy();
                KinugasaGame.this.clippingRectangle = KinugasaGame.this.window.getInternalBounds();
                KinugasaGame.this.loop.start();
                KinugasaGame.this.started = true;
            }
        });
        System.out.println("> KINUGASA " + (Object)((Object)Versions.LATEST) + " [" + this.getName() + "] game start");
    }

    @Override
    public final void gameExit() throws IllegalStateException {
        if (!this.started) {
            throw new IllegalStateException("game[" + this.name + "] is not start.");
        }
        if (this.loop != null && this.loop.isStarted()) {
            this.loop.end();
        }
        try {
            this.dispose();
        }
        catch (Throwable ex) {
            System.out.println("ERROR : " + ex);
            ex.printStackTrace();
            System.exit(1);
        }
        this.window.dispose();
        System.out.println("> [" + this.getName() + "] game exit");
        System.exit(0);
    }

    @Override
    @Internal
    final void repaint() {
        this.graphicsContext = (Graphics2D)this.graphicsBuffer.getDrawGraphics();
        this.graphicsContext.setClip(this.clippingRectangle);
        this.graphicsContext.clearRect(this.clippingRectangle.x, this.clippingRectangle.y, this.clippingRectangle.width, this.clippingRectangle.height);
        this.graphicsContext.setRenderingHints(this.renderingHints);
        this.draw(this.graphicsContext);
        this.graphicsContext.dispose();
        if (this.graphicsBuffer.contentsRestored()) {
            this.repaint();
        }
        this.graphicsBuffer.show();
        if (this.graphicsBuffer.contentsLost()) {
            this.repaint();
        }
    }

    @Override
    protected abstract void startUp();

    @Override
    protected abstract void dispose();

    @Override
    protected abstract void update();

    @Override
    protected abstract void draw(Graphics2D var1);

    @Override
    public final GameWindow getWindow() {
        return this.window;
    }

    @Override
    public final GameTimeManager getGameTimeManager() {
        return this.gameTimeManager;
    }

    @Override
    public String toString() {
        return "kinugasaGame : name=[" + this.name + "]";
    }

    public static void main(String[] args) {
        System.out.println("KINUGASA " + (Object)((Object)Versions.LATEST));
    }
}

