/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.logic;

import kinugasa.contents.resource.Nameable;
import kinugasa.util.annotations.Internal;

public final class CMDElement
implements Nameable {
    private String name;
    private String value;

    @Internal
    CMDElement(String name) {
        this.name = name;
    }

    @Internal
    CMDElement(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public int getIntValue() throws NumberFormatException {
        return Integer.parseInt(this.value);
    }

    public float getFloatValue() throws NumberFormatException {
        return Float.parseFloat(this.value);
    }

    public boolean isOn() {
        return this.value != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 71 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CMDElement other = (CMDElement)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "CMDElement{name=" + this.name + ", value=" + this.value + '}';
    }
}

